#!/bin/sh
T=/opt/vc/include
L=/usr/include

fixincludes() 
{
  if [ -e ${T}/$1 ]; then
    if [ -e ${L}/$1 ]; then
      if [ ! -e ${L}/$1-novc ]; then
        sudo mv ${L}/$1 ${L}/$1-novc
      else
        sudo rm -rf ${L}/$1
      fi
    fi 
    sudo ln -s ${T}/$1 ${L}/$1
  fi
}

fixincludes EGL
fixincludes GLES
fixincludes GLES2
fixincludes KHR
fixincludes VG

[ ! -e ${L}/interface ] && sudo mkdir ${L}/interface

for d in `ls -d ${T}/interface/*` ; do
  bd=`basename $d`
  fixincludes interface/$bd
done

if [ ! -e /opt/vc/include/interface/vcos/vcos_platform.h ]; then 
  sudo ln -s /opt/vc/include/interface/vcos/pthreads/vcos_platform.h /opt/vc/include/interface/vcos/vcos_platform.h
fi
if [ ! -e /opt/vc/include/interface/vcos/vcos_platform_types.h ]; then 
  sudo ln -s /opt/vc/include/interface/vcos/pthreads/vcos_platform_types.h /opt/vc/include/interface/vcos/vcos_platform_types.h
fi

grep eglmesaext /usr/include/EGL/eglext.h || sudo sed -i 's|#include "eglext_brcm.h"|#include "eglext_brcm.h"\n#include "eglmesaext.h"|g' /usr/include/EGL/eglext.h

