#!/bin/bash
needproc=0
mount | grep proc || needproc=1
[ $needproc = 1 ] && mount -t proc /proc /proc

cd /root/board-debs/

debconf-set-selections < /root/board-debs/debconf-selections.txt

#dpkg-reconfigure -f noninteractive dash

true && dpkg-reconfigure -f noninteractive locales

if [ "Raspbian" = "Raspbian" ] ; then
	apt-get install -y xkb-data liblocale-gettext-perl libuuid-perl
	apt-get install -y kbd

	DEBIAN_FRONTEND=noninteractive apt-get install -y console-setup-linux console-setup keyboard-configuration
	dpkg-reconfigure -f noninteractive keyboard-configuration

	dpkg-reconfigure -f noninteractive tzdata

	apt-get install -y initramfs-tools

	DEBIAN_FRONTEND=noninteractive apt-get install -y linux-base

	apt-get install -y linux-image-3.18.0-trunk-rpi linux-image-3.18.0-trunk-rpi2
else
apt-get remove -y linux-image-3.18.0-trunk-rpi linux-image-3.18.0-trunk-rpi2 || true
apt-get remove -y flash-kernel || true

apt-get install -y xkb-data liblocale-gettext-perl libuuid-perl
apt-get install -y kbd

wget http://mirrordirector.raspbian.org/raspbian/dists/jessie/main/binary-armhf/Packages.gz
gunzip Packages.gz 
mv Packages raspbian-jessie-Packages

#export RPICVER=1.88
#export RPIIVER=0.115~bpo70+1
#export RPIKVER=3.18.5-1~exp1+rpi16

export RPICVER=`grep -A9 'Package: console-setup' raspbian-jessie-Packages | grep -m1 'Version:' | cut -d " " -f 2-`
export RPIIVER=`grep -A9 'Package: initramfs-tools' raspbian-jessie-Packages | grep -m1 'Version:' | cut -d " " -f 2-`
export RPIKVER=`grep -A9 'Package: linux-image-3.18.0-trunk-rpi' raspbian-jessie-Packages | grep -m1 'Version:' | cut -d " " -f 2-`

rm raspbian-jessie-Packages

wget http://mirrordirector.raspbian.org/raspbian/pool/main/c/console-setup/console-setup_${RPICVER}_all.deb
wget http://mirrordirector.raspbian.org/raspbian/pool/main/c/console-setup/console-setup-linux_${RPICVER}_all.deb
wget http://mirrordirector.raspbian.org/raspbian/pool/main/c/console-setup/keyboard-configuration_${RPICVER}_all.deb
DEBIAN_FRONTEND=noninteractive dpkg -i console-setup-linux_${RPICVER}_all.deb console-setup_${RPICVER}_all.deb keyboard-configuration_${RPICVER}_all.deb || true

#echo -n "tzdata before"
#read f

dpkg-reconfigure -f noninteractive tzdata

#echo -n "tzdata after"
#read f

wget http://mirrordirector.raspbian.org/raspbian/pool/main/i/initramfs-tools/initramfs-tools_${RPIIVER}_all.deb
dpkg -i initramfs-tools_${RPIIVER}_all.deb
DEBIAN_FRONTEND=noninteractive dpkg -i console-setup-linux_${RPICVER}_all.deb console-setup_${RPICVER}_all.deb keyboard-configuration_${RPICVER}_all.deb

DEBIAN_FRONTEND=noninteractive apt-get install -y linux-base

wget http://mirrordirector.raspbian.org/raspbian/pool/main/l/linux-3.18/linux-image-3.18.0-trunk-rpi_${RPIKVER}_armhf.deb
wget http://mirrordirector.raspbian.org/raspbian/pool/main/l/linux-3.18/linux-image-3.18.0-trunk-rpi2_${RPIKVER}_armhf.deb
dpkg -i linux-image-3.18.0-trunk-rpi_${RPIKVER}_armhf.deb
dpkg -i linux-image-3.18.0-trunk-rpi2_${RPIKVER}_armhf.deb
fi

apt-get install -y linux-firmware 

[ $needproc = 1 ] && umount /proc

touch /tmp/`basename $0`.done
echo "OK"
