#!/bin/bash
apt-get --no-install-recommends install -y alsa-utils
apt-get install -y lua5.1 psmisc
[ 1504 -ge 1204 ] && apt-get install -y triggerhappy

if [ "Raspbian" != "Raspbian" -a "raspberrypi" = "raspberrypi" ] ; then
  dpkg -i /root/board-debs/raspi-config_*_all.deb
elif [ "Raspbian" != "Raspbian" -a 1504 -ge 1204 ] ; then
  dpkg -i /root/board-debs/raspi-config_*_all.deb
  [ "arm" != "arm" ] && update-rc.d -f raspi-config remove
fi

debconf-set-selections < /root/board-debs/debconf-selections.txt

#dpkg-reconfigure -f noninteractive dash

#true && dpkg-reconfigure -f noninteractive locales

apt-get remove -y flash-kernel || true
apt-get remove -y linux-image-3.18.0-trunk-rpi linux-image-3.18.0-trunk-rpi2 || true

apt-get install -y xkb-data liblocale-gettext-perl libuuid-perl
DEBIAN_FRONTEND=noninteractive apt-get install -y kbd

if [ 1504 -ge 1104 ] ; then
  DEBIAN_FRONTEND=noninteractive apt-get install -y keyboard-configuration
  dpkg-reconfigure -f noninteractive keyboard-configuration
fi

#echo -n "tzdata before"
#read f

dpkg-reconfigure -f noninteractive tzdata

#echo -n "tzdata after"
#read f

if [ 1504 -ge 1204 ] ; then
  DEBIAN_FRONTEND=noninteractive apt-get install -y linux-base
fi

if [ "raspberrypi" = "generic" -o "raspberrypi" = "mac" -o "raspberrypi" = "pc" ]; then
  [ 1504 -ge 1504 ] && DEBIAN_FRONTEND=noninteractive apt-get -o Dpkg::Options::="--force-confdef" -o Dpkg::Options::="--force-confnew" install -y kernel-common

  apt-get install -y linux-image-rpi-rpfv
elif [ "raspberrypi" = "amlsx05" ]; then
  [ 1504 -ge 1504 ] && DEBIAN_FRONTEND=noninteractive apt-get -o Dpkg::Options::="--force-confdef" -o Dpkg::Options::="--force-confnew" install -y kernel-common

  #apt-get install -y linux-image-rpi-rpfv:arm64
fi

if [ armhf = amd64 -o armhf = i386 ]; then
  DEBIAN_FRONTEND=noninteractive apt-get -o Dpkg::Options::="--force-confdef" -o Dpkg::Options::="--force-confold" install -y grub-pc

  [ 1504 -ge 1104 ] && update-grub-gfxpayload || true

  mkdir -p /boot/grub/fonts
  mkdir -p /boot/grub/i386-pc
  mkdir -p /boot/grub/locale
  cp -p /usr/lib/grub/i386-pc/*.lst /boot/grub/i386-pc/
  cp -p /usr/lib/grub/i386-pc/*.mod /boot/grub/i386-pc/
  cp -p /usr/lib/grub/i386-pc/*.o   /boot/grub/i386-pc/
  cp -p /usr/lib/grub/i386-pc/boot.img /boot/grub/i386-pc/
  #core.img?
  cp -p /usr/share/grub/unicode.pf2 /boot/grub/fonts/
  cp -p /usr/share/grub/unicode.pf2 /boot/grub/
  cp -p /usr/share/locale-langpack/de/LC_MESSAGES/grub.mo /boot/grub/locale/de.mo || true

  apt-get install -y memtest86+
  
  [ -e /usr/share/grub/default/grub ] && cp -p /usr/share/grub/default/grub /etc/default/grub
#  sed -i s/'GRUB_HIDDEN_TIMEOUT=0'/'#GRUB_HIDDEN_TIMEOUT=0'/g /etc/default/grub

  if [ 1504 -ge 1204 ]; then
    if grep GRUB_CMDLINE_LINUX_DEFAULT /etc/default/grub > /dev/null ; then
      sed -i 's|GRUB_CMDLINE_LINUX_DEFAULT=".*"|GRUB_CMDLINE_LINUX_DEFAULT="init=/sbin/init-tc"|g' /etc/default/grub
    else
      sed -i 's|GRUB_CMDLINE_LINUX=".*"|GRUB_CMDLINE_LINUX="init=/sbin/init-tc"|g' /etc/default/grub
    fi  
  fi

  echo "GRUB_RECORDFAIL_TIMEOUT=10" | tee -a /etc/default/grub > /dev/null

elif [ "raspberrypi" = "generic" -o "raspberrypi" = "mac" ]; then
  update-initramfs -d -k all
fi

touch /tmp/`basename $0`.done
echo "OK"
