#!/bin/bash -e

apt-get install -y file sudo

apt-get install -y ca-certificates curl ntp parted whiptail wget
#apt-get install -y lua5.1
#[ 1504 -ge 1204 ] && apt-get install -y triggerhappy

cd /root/board-debs/

/etc/init.d/triggerhappy stop || true
/etc/init.d/ntp stop

apt-get install -y initramfs-tools
apt-get install -y device-tree-compiler
[ 1504 -ge 1104 ] && apt-get install -y u-boot-tools

wget http://archive.raspberrypi.org/debian/dists/jessie/main/binary-armhf/Packages.gz
gunzip Packages.gz 
mv Packages raspberrypi-jessie-Packages

rpiRepoUi=main
if [ jessie = jessie ]; then
  export rpiRepoUi=ui
  wget http://archive.raspberrypi.org/debian/dists/jessie/ui/binary-armhf/Packages.gz
  gunzip Packages.gz 
  mv Packages raspberrypi-jessie-Packages-ui
else
  cp -p raspberrypi-jessie-Packages raspberrypi-jessie-Packages-ui
fi

#export RPIBVER=2.24.51.20140425-1~rpi1rpi2
#export RPIPIPV=0.1-1
#export RPICOFV=0.4-1
#export RPIFVER=1.20150214-2
#export RPIARTV=20141115
#export RPIUIMV=1.0-7
#export RPICFGV=20150131-1
#export RPIUPDV=20140705
#export RPIOMXV=0.3.6~git20150210~337004e
#export RPIFBTV=1.20131208-1

export RPIBVER=`grep -A9 'Package: binutils' raspberrypi-jessie-Packages | grep -m1 'Version:' | cut -d " " -f 2-`
export RPIWVER=`grep -A9 'Package: firmware-brcm80211' raspberrypi-jessie-Packages | grep -m1 'Version:' | cut -d " " -f 2-`
export RPICOFV=`grep -A9 'Package: raspi-copies-and-fills' raspberrypi-jessie-Packages | grep -m1 'Version:' | cut -d " " -f 2-`
export RPIFVER=`grep -A9 'Package: raspberrypi-bootloader' raspberrypi-jessie-Packages | grep -m1 'Version:' | cut -d " " -f 2-`
export RPIKVER=`grep -A9 'Package: raspberrypi-kernel' raspberrypi-jessie-Packages | grep -m1 'Version:' | cut -d " " -f 2-`
export RPIARTV=`grep -A9 'Package: raspberrypi-artwork' raspberrypi-jessie-Packages | grep -m1 'Version:' | cut -d " " -f 2-`
export RPICFGV=`grep -A9 'Package: raspi-config' raspberrypi-jessie-Packages | grep -m1 'Version:' | cut -d " " -f 2-`
export RPIUPDV=`grep -A9 'Package: rpi-update' raspberrypi-jessie-Packages | grep -m1 'Version:' | cut -d " " -f 2-`
export RPIOMXV=`grep -A9 'Package: omxplayer' raspberrypi-jessie-Packages | grep -m1 'Version:' | cut -d " " -f 2-`
export RPIFBTV=`grep -A9 'Package: xserver-xorg-video-fbturbo' raspberrypi-jessie-Packages | grep -m1 'Version:' | cut -d " " -f 2-`

export RPIUIMV=`grep -A9 'Package: raspberrypi-ui-mods' raspberrypi-jessie-Packages-ui | grep -m1 'Version:' | cut -d " " -f 2-`
export RPIUIMA=`grep -A9 'Package: raspberrypi-ui-mods' raspberrypi-jessie-Packages-ui | grep -m1 'Architecture:' | cut -d " " -f 2-`

export RPIPIPV=`grep -A9 'Package: pipanel' raspberrypi-jessie-Packages-ui | grep -m1 'Version:' | cut -d " " -f 2-`
export RPIPIPA=`grep -A9 'Package: pipanel' raspberrypi-jessie-Packages-ui | grep -m1 'Architecture:' | cut -d " " -f 2-`

#rm raspberrypi-jessie-Packages

export RPIFFTV=20120503-1

if [ jessie = trusty ]; then
	# use raspbian binutils for trusty or older
	wget http://archive.raspberrypi.org/debian/pool/main/b/binutils/binutils_${RPIBVER}_armhf.deb
	dpkg -i binutils_${RPIBVER}_armhf.deb 
fi

# Can not be installed in chroot on non-ARM hardware
wget -N http://archive.raspberrypi.org/debian/pool/main/r/raspi-copies-and-fills/raspi-copies-and-fills_${RPICOFV}_armhf.deb

cp -p raspi-copies-and-fills_*_armhf.deb /usr/share/firstboot/

if $needboardldr ; then
	wget http://archive.raspberrypi.org/debian/pool/main/f/firmware-nonfree/firmware-brcm80211_${RPIWVER}_all.deb && 	dpkg -i firmware-brcm80211_${RPIWVER}_all.deb
	wget http://archive.raspberrypi.org/debian/pool/main/r/raspberrypi-firmware/raspberrypi-kernel_${RPIKVER}_armhf.deb && 	dpkg -i raspberrypi-kernel_${RPIKVER}_armhf.deb
	wget http://archive.raspberrypi.org/debian/pool/main/r/raspberrypi-firmware/raspberrypi-bootloader_${RPIFVER}_armhf.deb && 	dpkg -i raspberrypi-bootloader_${RPIFVER}_armhf.deb
fi

if [ "XFCE" != "none-mini" ] ; then
	if $needboardlib ; then
		wget http://archive.raspberrypi.org/debian/pool/main/r/raspberrypi-firmware/libraspberrypi0_${RPIFVER}_armhf.deb && 		wget http://archive.raspberrypi.org/debian/pool/main/r/raspberrypi-firmware/libraspberrypi-bin_${RPIFVER}_armhf.deb && 		wget http://archive.raspberrypi.org/debian/pool/main/r/raspberrypi-firmware/libraspberrypi-dev_${RPIFVER}_armhf.deb
		dpkg -i libraspberrypi0_${RPIFVER}_armhf.deb && 		dpkg -i libraspberrypi-bin_${RPIFVER}_armhf.deb && 		dpkg -i libraspberrypi-dev_${RPIFVER}_armhf.deb
	fi
	if [ 0 != 0 ]; then
		if $needboarddoc ; then
			wget http://archive.raspberrypi.org/debian/pool/main/r/raspberrypi-firmware/libraspberrypi-doc_${RPIFVER}_armhf.deb && 			dpkg -i libraspberrypi-doc_${RPIFVER}_armhf.deb
		fi
	fi

	echo 1needboardart $needboardart ${rpiRepoUi}
	#read f
	if $needboardart ; then
		wget http://archive.raspberrypi.org/debian/pool/${rpiRepoUi}/p/pipanel/pipanel_${RPIPIPV}_${RPIPIPA}.deb
		wget http://archive.raspberrypi.org/debian/pool/main/r/raspberrypi-artwork/raspberrypi-artwork_${RPIARTV}_all.deb
		wget http://archive.raspberrypi.org/debian/pool/${rpiRepoUi}/r/raspberrypi-ui-mods/raspberrypi-ui-mods_${RPIUIMV}_${RPIUIMA}.deb
	fi
fi

if $needboardcfg ; then
	wget http://archive.raspberrypi.org/debian/pool/main/r/raspi-config/raspi-config_${RPICFGV}_all.deb
	#dpkg -i raspi-config_${RPICFGV}_all.deb
fi

if [ "XFCE" != "none-mini" ] ; then
	if $needboardupd ; then
		wget http://archive.raspberrypi.org/debian/pool/main/r/rpi-update/rpi-update_${RPIUPDV}_all.deb
		dpkg -i rpi-update_${RPIUPDV}_all.deb
	fi

	if $needboardomx ; then
		wget http://archive.raspberrypi.org/debian/pool/main/o/omxplayer/omxplayer_${RPIOMXV}_armhf.deb
		apt-get install -y libasound2 libfreetype6 dbus libsmbclient libssh-4

		if [ 1504 -lt 1210 ]; then
			wget http://mirrordirector.raspbian.org/raspbian/pool/main/f/fonts-freefont/fonts-freefont-ttf_${RPIFFTV}_all.deb && 			wget http://mirrordirector.raspbian.org/raspbian/pool/main/f/fonts-freefont/ttf-freefont_${RPIFFTV}_all.deb
			apt-get remove -y ttf-freefont || true
			dpkg -i fonts-freefont-ttf_${RPIFFTV}_all.deb ttf-freefont_${RPIFFTV}_all.deb
		fi

		if [ 1504 -ge 1608 ]; then
			true
		else
			apt-get install -y fonts-freefont-ttf
			dpkg -i omxplayer_${RPIOMXV}_armhf.deb
		fi
	fi
fi

if [ jessie = wheezy ]; then
	if $needboardfbt ; then
		mkdir -p /root/source
		cd /root/source/
		wget http://archive.raspberrypi.org/debian/pool/main/x/xserver-xorg-video-fbturbo/xserver-xorg-video-fbturbo_${RPIFBTV}_armhf.deb
		cd -
	fi
fi

touch /tmp/`basename $0`.done
echo "OK"
