#!/bin/bash -e
# minimal x11

# linaro x11
apt-get --no-install-recommends install -y   alsa-base alsa-utils anacron bc ca-certificates dc inputattach   libsasl2-modules   screen smbclient ttf-dejavu-core   unzip wpasupplicant xkb-data xserver-xorg-video-fbdev zip
#apt-get --no-install-recommends install -y libpam-ck-connector
#apt-get --no-install-recommends install -y genisoimage lftp rfkill ttf-freefont wireless-tools
[ 1504 -ge 1510 ] || apt-get --no-install-recommends install -y libxp6

#wget http://ppa.launchpad.net/linaro-maintainers/overlay/ubuntu/pool/main/l/linaro-meta/linaro-x11-base_040-utopic1_armhf.deb
#apt-get install -y upstart
#apt-get --no-install-recommends install -y linaro-x11-base

apt-get install -y systemd-sysv

#apt-get remove -y upstart-bin

# before lightdm
[ "raspberrypi" != "amlsx05" -a 1504 -ge 1010 ] && apt-get install -y libegl1-mesa
apt-get install -y xserver-common xserver-xorg-core xserver-xorg-input-evdev xserver-xorg-video-fbdev
apt-get --no-install-recommends install -y xserver-xorg
if [ raspberrypi = generic -o "raspberrypi" = "mac" -o "raspberrypi" = "pc" ]; then
  apt-get install -y  xserver-xorg-input-all xserver-xorg-video-all
  [ 1504 -ge 1404 ] && apt-get install -y mesa-vdpau-drivers
  [ 1504 -ge 1604 ] && apt-get install -y mesa-va-drivers
fi

#  echo ""
#  echo ""
#  echo ""
#  echo "Use apt-get install to choose your xserver-xorg"
#  echo ""
#  bash || true
#  echo ""

apt-get install -y ethtool
if [ 1504 -ge 1210 ]; then
  apt-get --no-install-recommends install -y ubuntu-drivers-common || true
fi
# not available in some Ubuntu versions
apt-get install -y ubuntu-extras-keyring || true
apt-get install -y git-core debconf-utils
[ 1504 -ge 1010 ] && apt-get install -y git

# basic x11
echo ""
echo ""
echo ""
echo "Basic X11"

apt-get install -y xfonts-base xinit
#apt-get install -y xfonts-encodings xfonts-utils
#[ "XFCE" != "Matchbox" ] && apt-get install -y xinput xfonts-scalable xorg

apt-get install -y policykit-1
apt-get install -y policykit-desktop-privileges || true

#apt-get clean

apt-get --purge remove -y language-selector-common || true
[ "XFCE" != "GNOME" -a "XFCE" != "MATE" -a "XFCE" != "Unity" ] && apt-get --purge remove -y accountsservice
apt-get --purge remove -y libbonobo2-common libbonoboui2-common
apt-get --purge remove -y mlocate popularity-contest

rm -f /etc/cron.weekly/fstrim

if [ 1 != 0 ]; then
  if [ 1504 -ge 1110 -a 1504 -le 1604 ] ; then
    apt-get --no-install-recommends install -y gnome-icon-theme-full || true
  else
    apt-get --no-install-recommends install -y gnome-icon-theme
  fi
  #apt-get install -y gnome-themes-standard
fi

# before lightdm to avoid bloat
[ "XFCE" != "Matchbox" ] && apt-get --no-install-recommends install -y network-manager-gnome

# must be installed together to avoid bloat
if [ 1504 -ge 1110 ] ; then
  apt-get --no-install-recommends install -y lightdm lightdm-gtk-greeter
elif [ 1504 -ge 1104 ] ; then
  apt-get --no-install-recommends install -y lightdm lightdm-engine-gtk lightdm-theme-gnome
else
  apt-get --no-install-recommends install -y gdm
fi

apt-get install -y x11-utils x11-xserver-utils shared-mime-info

apt-get --no-install-recommends install -y xdg-utils

if [ "XFCE" = "Matchbox" ] ; then

apt-get --no-install-recommends install -y   python-xdg xdg-user-dirs xdg-user-dirs-gtk
[ 1504 -le 1010 ] || apt-get --no-install-recommends install -y gsettings-desktop-schemas

else

#[ 1504 -le 1110 ] || apt-get --no-install-recommends install -y gvfs-daemons printer-driver-pnm2ppa
#[ 1504 -ge 1010 ] && apt-get --no-install-recommends install -y foomatic-db-compressed-ppds
apt-get install -y desktop-file-utils gtk2-engines-murrine gtk2-engines-pixbuf gvfs hwdata
#apt-get --no-install-recommends install -y #  ghostscript-x openprinting-ppds pm-utils #  libpaper-utils

apt-get --no-install-recommends install -y   python-xdg xdg-user-dirs xdg-user-dirs-gtk
[ 1504 -le 1010 ] || apt-get --no-install-recommends install -y gsettings-desktop-schemas

echo ""

echo ""
echo ""
echo ""
echo "Basic X11 appplications"

apt-get --no-install-recommends install -y   evince   galculator   gpicview   leafpad   scrot   xarchiver
#  x2x echo ""

# != "Matchbox" end
fi

echo ""
echo ""
echo ""
echo "Desktop environment"

if [ "XFCE" = "XFCE" ] ; then
# XFCE 4
  # linaro xfce
  apt-get --no-install-recommends install -y     dmz-cursor-theme doc-base gtk2-engines gtk2-engines-murrine gtk2-engines-pixbuf gtk2-engines-xfce libasound2-plugins     thunar thunar-volman     xfce4-appfinder xfce4-panel xfce4-session xfce4-settings xfdesktop4 xfwm4 xterm
#  apt-get --no-install-recommends install -y tango-icon-theme
#  apt-get --no-install-recommends install -y tango-icon-theme-common || true

  #wget http://ppa.launchpad.net/linaro-maintainers/overlay/ubuntu/pool/main/l/linaro-meta/linaro-xfce-base_040-utopic1_armhf.deb
  #apt-get install -y upstart
  #apt-get --no-install-recommends install -y linaro-xfce-base

  apt-get install -y systemd-sysv

  apt-get install -y gtk2-engines-xfce
  apt-get install -y gtk3-engines-xfce || true
  apt-get install -y xfce4-terminal 
  apt-get install -y xfce4-whiskermenu-plugin || true

  apt-get --no-install-recommends install -y xubuntu-artwork || true
  apt-get install -y xubuntu-wallpapers xubuntu-icon-theme xubuntu-default-settings || true
  apt-get install -y plymouth-theme-xubuntu-logo plymouth-theme-xubuntu-text || true

# calculator, image viewer, document viewer, text editor, archiver (we already installed galculator gpicview evince leafpad xarchiver above)
#  apt-get --no-install-recommends install -y gnome-calculator ristretto evince-gtk mousepad file-roller

  apt-get --no-install-recommends install -y     libnotify-bin xfce4-notifyd

#  [ 1504 -ge 1604 ] && apt-get --no-install-recommends install -y gnome-alsamixer
  [ 1504 -ge 1604 ] && apt-get --no-install-recommends install -y volumeicon-alsa
  [ 1504 -le 1510 ] && apt-get --no-install-recommends install -y xfce4-mixer 
  [ 1504 -le 1204 ] && apt-get --no-install-recommends install -y xfce4-utils
  [ 1504 -le 1010 ] && apt-get --no-install-recommends install -y xfce4-indicator-plugin

  [ 1504 -le 1004 ] || apt-get install -y vdpau-va-driver
  #apt-get install -y blt
  apt-get install -y     emacsen-common hwdata python-pkg-resources python3-pkg-resources
  #apt-get install -y python-pil || true

  #if [ 1504 -le 1404 ]; then
  #  apt-get --no-install-recommends install -y xubuntu-docs || true
  #else
  #  apt-get --no-install-recommends install -y xubuntu-core || true
  #fi

  # make sure these packages get installed on all distros
  [ 1504 -ge 1204 ] && [ 1504 -le 1510 ] && apt-get install -y fonts-droid
  [ 1504 -ge 1604 ] && apt-get install -y fonts-noto-hinted
  #[ 1504 -ge 1604 ] && apt-get install -y fonts-droid-fallback
  apt-get install -y gconf2

# cgmanager needed by systemd-shim
#  apt-get --purge remove -y cgmanager

  apt-get --purge remove -y libtumbler* tumbler tumbler-common || true

  if true ; then
    cd /root/source/

    wget http://ports.ubuntu.com/ubuntu-ports/dists/trusty/universe/binary-armhf/Packages.gz
    gunzip Packages.gz 
    mv Packages ubuntu-trusty-Packages

    wget http://ports.ubuntu.com/ubuntu-ports/dists/trusty-updates/universe/binary-armhf/Packages.gz
    gunzip Packages.gz 
    mv Packages ubuntu-trusty-updates-Packages

    export UBUSHTV=`grep -A9 'Package: shimmer-themes' ubuntu-trusty-Packages | grep -m1 'Version:' | cut -d " " -f 2-`
    export UBUXAWV=`grep -A9 'Package: xubuntu-artwork' ubuntu-trusty-Packages | grep -m1 'Version:' | cut -d " " -f 2-`
    export UBUXDSV=`grep -A9 'Package: xubuntu-default-settings' ubuntu-trusty-updates-Packages | grep -m1 'Version:' | cut -d " " -f 2-`

    ##wget http://ports.ubuntu.com/ubuntu-ports/pool/universe/s/shimmer-themes/greybird-gtk-theme_${UBUSHTV}_all.deb
    ##wget http://ports.ubuntu.com/ubuntu-ports/pool/universe/s/shimmer-themes/numix-gtk-theme_${UBUSHTV}_all.deb
    wget http://ports.ubuntu.com/ubuntu-ports/pool/universe/s/shimmer-themes/shimmer-themes_${UBUSHTV}_all.deb

    ##wget http://ports.ubuntu.com/ubuntu-ports/pool/main/p/plymouth/libplymouth4__armhf.deb
    ##wget http://ports.ubuntu.com/ubuntu-ports/pool/main/p/plymouth/plymouth__armhf.deb
    ##wget http://ports.ubuntu.com/ubuntu-ports/pool/main/p/plymouth/plymouth-label__armhf.deb
    ##wget http://ports.ubuntu.com/ubuntu-ports/pool/main/p/plymouth/plymouth-theme-ubuntu-text__armhf.deb
    ##wget http://ports.ubuntu.com/ubuntu-ports/pool/main/u/ubuntu-font-family-sources/ttf-ubuntu-font-family__all.deb

    ##wget http://ports.ubuntu.com/ubuntu-ports/pool/universe/x/xubuntu-artwork/plymouth-theme-xubuntu-logo_${UBUXAWV}_all.deb
    ##wget http://ports.ubuntu.com/ubuntu-ports/pool/universe/x/xubuntu-artwork/plymouth-theme-xubuntu-text_${UBUXAWV}_all.deb
    wget http://ports.ubuntu.com/ubuntu-ports/pool/universe/x/xubuntu-artwork/xubuntu-artwork_${UBUXAWV}_all.deb

    wget http://ports.ubuntu.com/ubuntu-ports/pool/universe/x/xubuntu-artwork/xubuntu-icon-theme_${UBUXAWV}_all.deb
    wget http://ports.ubuntu.com/ubuntu-ports/pool/universe/x/xubuntu-artwork/xubuntu-wallpapers_${UBUXAWV}_all.deb

    wget http://ports.ubuntu.com/ubuntu-ports/pool/universe/x/xubuntu-default-settings/xubuntu-default-settings_${UBUXDSV}_all.deb

    #apt-get --purge remove -y murrine-themes
    
    dpkg -i xubuntu-icon-theme_${UBUXAWV}_all.deb 
    #dpkg -i xubuntu-wallpapers_${UBUXAWV}_all.deb 

    ##dpkg -i greybird-gtk-theme_${UBUSHTV}_all.deb
    ##dpkg -i numix-gtk-theme_${UBUSHTV}_all.deb
    #dpkg -i shimmer-themes_${UBUSHTV}_all.deb

    ##dpkg -i plymouth-theme-xubuntu-logo_${UBUXAWV}_all.deb
    ##dpkg -i plymouth-theme-xubuntu-text_${UBUXAWV}_all.deb
    #dpkg -i xubuntu-artwork_${UBUXAWV}_all.deb
    
    #dpkg -i xubuntu-default-settings_${UBUXDSV}_all.deb 

    if [ trusty = zztrusty ]; then
      apt-get --purge remove -y murrine-themes

      dpkg -i xubuntu-wallpapers_${UBUXAWV}_all.deb 

      dpkg -i shimmer-themes_${UBUSHTV}_all.deb

      dpkg -i xubuntu-artwork_${UBUXAWV}_all.deb

      dpkg -i xubuntu-default-settings_${UBUXDSV}_all.deb
    else
      mkdir xubuntu-default-settings
      cd xubuntu-default-settings
      ar -x ../xubuntu-default-settings_${UBUXDSV}_all.deb
      [ -e data.tar.gz ] && tar xzvf data.tar.gz
      [ -e data.tar.xz ] && tar xJvf data.tar.xz
      cp -p  etc/skel/.Xdefaults    /etc/skel/
      cp -p  etc/skel/.xscreensaver /etc/skel/
      cp -ap etc/xdg/xdg-xubuntu    /etc/xdg/
      mkdir -p /usr/share/xfce4/whiskermenu
      cp -p  usr/share/xfce4/whiskermenu/defaults.rc /usr/share/xfce4/whiskermenu/
      cd ..
      rm -rf xubuntu-default-settings/
    fi

    if [ -e /etc/xdg/xdg-xubuntu/xfce4 ]; then
      mkdir -p /etc/xdg/xdg-debian/xfce4

      mkdir -p /etc/xdg/xdg-debian/xfce4/panel
      cp -ap /etc/xdg/xfce4/panel/* /etc/xdg/xdg-debian/xfce4/panel/
      cp -ap /etc/xdg/xdg-xubuntu/xfce4/panel/* /etc/xdg/xfce4/panel/

      mkdir -p /etc/xdg/xdg-debian/xfce4/xfconf
      cp -ap /etc/xdg/xfce4/xfconf/* /etc/xdg/xdg-debian/xfce4/xfconf/
      #cp -ap /etc/xdg/xdg-xubuntu/xfce4/xfconf/* /etc/xdg/xfce4/xfconf/
      cp -p /etc/xdg/xdg-xubuntu/xfce4/xfconf/xfce-perchannel-xml/xfce4-desktop.xml /etc/xdg/xfce4/xfconf/xfce-perchannel-xml/
      cp -p /etc/xdg/xdg-xubuntu/xfce4/xfconf/xfce-perchannel-xml/xfce4-keyboard-shortcuts.xml /etc/xdg/xfce4/xfconf/xfce-perchannel-xml/
      cp -p /etc/xdg/xdg-xubuntu/xfce4/xfconf/xfce-perchannel-xml/xfce4-session.xml /etc/xdg/xfce4/xfconf/xfce-perchannel-xml/
      cp -p /etc/xdg/xdg-xubuntu/xfce4/xfconf/xfce-perchannel-xml/xfwm4.xml         /etc/xdg/xfce4/xfconf/xfce-perchannel-xml/
      cp -p /etc/xdg/xdg-xubuntu/xfce4/xfconf/xfce-perchannel-xml/xsettings.xml     /etc/xdg/xfce4/xfconf/xfce-perchannel-xml/
    fi

    if [ -e /usr/share/xfce4/whiskermenu/defaults.rc ]; then
      sed -i s/'button-icon=xubuntu-logo-menu'/'button-icon=xfce4-whiskermenu'/g /usr/share/xfce4/whiskermenu/defaults.rc
    fi

  else
    cd /root/source/

    mkdir xubuntu-default-settings
    cd xubuntu-default-settings

    mkdir etc
    mkdir etc/skel
    mkdir etc/xdg
    mkdir -p usr/share/xfce4

    mkdir -p etc/X11/Xsession.d
    mkdir -p usr/share/gconf/defaults
    mkdir -p usr/share/glib-2.0/schemas
    mkdir -p usr/share/lightdm
    mkdir -p usr/share/pixmaps
    mkdir -p usr/share/xsessions

    cp -adp /etc/skel/. etc/skel/
    cp -adp /etc/xdg/.  etc/xdg/
    cp -adp /usr/share/xfce4/. usr/share/xfce4/

    cp -adp /etc/X11/Xsession.d/. etc/X11/Xsession.d/
    cp -adp /usr/share/gconf/defaults/.   usr/share/gconf/defaults/
    cp -adp /usr/share/glib-2.0/schemas/. usr/share/glib-2.0/schemas/
    cp -adp /usr/share/lightdm/.   usr/share/lightdm/
    cp -adp /usr/share/pixmaps/.   usr/share/pixmaps/
    cp -adp /usr/share/xsessions/. usr/share/xsessions/

    apt-get remove -y xubuntu-default-settings
    #apt-get remove -y --purge xubuntu-icon-theme
    apt-get remove -y --purge xubuntu-wallpapers xubuntu-artwork

    cp -adp etc/. /etc/
    cp -adp usr/. /usr/

    cd ..

    rm -rf xubuntu-default-settings/

    apt-get remove -y --purge plymouth-theme-xubuntu-logo plymouth-theme-xubuntu-text
  fi

  dpkg -i /root/source/gtk*theme*xubuntu*_all.deb || true

  xfceIcons=elementary-xfce-darker
  xfceTheme=Greybird
  xfceFont="Droid Sans 10"
  xfceThemeLower=
  
  if [ -e /etc/xdg/xfce4/xfconf/xfce-perchannel-xml/xfce4-desktop.xml ]; then
    sed -i 's|    <property name="style" type="int" value="2"/>|    <property name="style" type="int" value="2"/>    <property name="icon-size" type="uint" value="48"/>|g' /etc/xdg/xfce4/xfconf/xfce-perchannel-xml/xfce4-desktop.xml
    sed -i 's|        <property name="image-style" type="int" value="5"/>|        <property name="color-style" type="int" value="3"/>        <property name="image-style" type="int" value="5"/>|g' /etc/xdg/xfce4/xfconf/xfce-perchannel-xml/xfce4-desktop.xml
    sed -i 's|/usr/share/xfce4/backdrops/xubuntu-wallpaper.png|/usr/share/images/desktop-base/desktop-background|g' /etc/xdg/xfce4/xfconf/xfce-perchannel-xml/xfce4-desktop.xml
  fi

  if [ -e /etc/xdg/xfce4/xfconf/xfce-perchannel-xml/xfce4-keyboard-shortcuts.xml ]; then
    PADBIN=`which leafpad || true`
    if [ "x${PADBIN}" != "x" ]; then
      sed -i 's|type="string" value="mousepad"|type="string" value="leafpad"|g' /etc/xdg/xfce4/xfconf/xfce-perchannel-xml/xfce4-keyboard-shortcuts.xml
    fi

    CALBIN=`which galculator || true`
    if [ "x${CALBIN}" != "x" ]; then
      sed -i 's|type="string" value="gnome-calculator"|type="string" value="galculator"|g' /etc/xdg/xfce4/xfconf/xfce-perchannel-xml/xfce4-keyboard-shortcuts.xml
    fi
  fi

  if [ -e /etc/xdg/xfce4/xfconf/xfce-perchannel-xml/xsettings.xml ]; then
    if [ -e /usr/share/themes/${xfceTheme} -o -e /usr/share/themes/${xfceThemeLower} ]; then
      sed -i 's|<property name="ThemeName" type="string" value="Xfce"/>|<property name="ThemeName" type="string" value="'${xfceTheme}'"/>|g' /etc/xdg/xfce4/xfconf/xfce-perchannel-xml/xsettings.xml
    fi
    if [ -e /usr/share/icons/${xfceIcons} ]; then
      sed -i 's|<property name="IconThemeName" type="string" value="Tango"/>|<property name="IconThemeName" type="string" value="'${xfceIcons}'"/>|g' /etc/xdg/xfce4/xfconf/xfce-perchannel-xml/xsettings.xml
    fi
    sed -i 's|<property name="FontName" type="string" value="Sans 10"/>|<property name="FontName" type="string" value="'"${xfceFont}"'"/>|g' /etc/xdg/xfce4/xfconf/xfce-perchannel-xml/xsettings.xml
  fi

  # xfce4/xfconf/xfce-perchannel-xml/xfce4-desktop.xml
  #<property name="image-path" type="string" value="/usr/share/xfce4/backdrops/xubuntu-wallpaper.png"/>

  # xfce4/xfconf/xfce-perchannel-xml/xfwm4.xml
  #<property name="theme" type="string" value="Greybird"/>
  #<property name="title_font" type="string" value="Droid Sans Bold 9"/>
  #<property name="show_frame_shadow" type="bool" value="false"/>
  #<property name="show_popup_shadow" type="bool" value="false"/>
  #<property name="wrap_windows" type="bool" value="true"/>
  #<property name="zoom_desktop" type="bool" value="false"/>

  if [ -e /etc/xdg/xfce4/xfconf/xfce-perchannel-xml/xfwm4.xml ]; then
    sed -i s/'property name="use_compositing" type="empty"'/'property name="use_compositing" type="bool" value="false"'/g /etc/xdg/xfce4/xfconf/xfce-perchannel-xml/xfwm4.xml
    sed -i s/'property name="use_compositing" type="bool" value="true"'/'property name="use_compositing" type="bool" value="false"'/g /etc/xdg/xfce4/xfconf/xfce-perchannel-xml/xfwm4.xml
  fi

  # lightdm/lightdm-gtk-greeter.conf
  #theme-name=Greybird
  #icon-theme-name=elementary-xfce-dark
  #font-name=Droid Sans 10

  if [ -e /etc/xdg/xdg-xubuntu/xfce4/xfconf/xfce-perchannel-xml/xfce4-desktop.xml ]; then
    sed -i 's|        <property name="image-style" type="int" value="5"/>|        <property name="color-style" type="int" value="3"/>        <property name="image-style" type="int" value="5"/>|g' /etc/xdg/xdg-xubuntu/xfce4/xfconf/xfce-perchannel-xml/xfce4-desktop.xml
    sed -i 's|/usr/share/xfce4/backdrops/xubuntu-wallpaper.png|/usr/share/images/desktop-base/desktop-background|g' /etc/xdg/xdg-xubuntu/xfce4/xfconf/xfce-perchannel-xml/xfce4-desktop.xml
  fi

  if [ -e /etc/xdg/xdg-xubuntu/xfce4/xfconf/xfce-perchannel-xml/xfwm4.xml ]; then
    sed -i s/'property name="use_compositing" type="empty"'/'property name="use_compositing" type="bool" value="false"'/g /etc/xdg/xdg-xubuntu/xfce4/xfconf/xfce-perchannel-xml/xfwm4.xml
    sed -i s/'property name="use_compositing" type="bool" value="true"'/'property name="use_compositing" type="bool" value="false"'/g /etc/xdg/xdg-xubuntu/xfce4/xfconf/xfce-perchannel-xml/xfwm4.xml
  fi

  if [ -e /usr/bin/volumeicon ]; then
    cat <<EOFDRUAVIA | tee /etc/xdg/autostart/volumeicon.desktop
[Desktop Entry]
Encoding=UTF-8
Version=0.9.4
Type=Application
Name=volumeicon
Comment=
Exec=/usr/bin/volumeicon
OnlyShowIn=XFCE;
StartupNotify=false
Terminal=false
Hidden=false
EOFDRUAVIA
  fi

  
# XFCE 4 end
elif [ "XFCE" = "LXDE" ] ; then
# LXDE
  apt-get install -y     lxappearance-obconf	     lxlauncher		     lxappearance		     lxinput		     lxmenu-data		     lxpanel		     lxrandr		     lxsession		     lxshortcut		     lxtask		     lxterminal		     policykit-1-gnome

  apt-get install -y     lubuntu-artwork	     lubuntu-icon-theme || true

  if [ 1504 -ge 1310 ]; then apt-get install -y lxsession-default-apps  || true ; fi
  if [ 1504 -ge 1304 ]; then apt-get install -y lubuntu-default-session || true ; fi
  if [ 1504 -ge 1210 ]; then apt-get install -y lubuntu-lxpanel-icons   || true ; fi

# install after lightdm
  apt-get install -y     lubuntu-default-settings || true

  apt-get install -y     lxterminal		     lxpanel		     lxsession-edit

  [ 1504 -ge 1210 ] && apt-get install -y lxpolkit

  apt-get --no-install-recommends install -y     lxde-common lxde-core lxde-icon-theme

  [ 1504 -lt 1210 ] && apt-get install --no-install-recommends -y     python-dbus python-dbus-dev

  apt-get --no-install-recommends install -y notification-daemon

  apt-get install -y indicator-application || true
#  apt-get install -y indicator-keyboard || true

# calculator, image viewer, document viewer, text editor, archiver (we already installed galculator gpicview evince leafpad xarchiver above)
#  apt-get --no-install-recommends install -y galculator gpicview evince leafpad file-roller

# browser needed before install lxde
#  apt-get install -y dillo
#  apt-get install -y lxde

  apt-get install -y pcmanfm xscreensaver

  apt-get --no-install-recommends install -y lubuntu-core || true

# LXDE end
elif [ "XFCE" = "KDE" ] ; then
# KDE
  apt-get --no-install-recommends install -y kde-runtime
  apt-get --no-install-recommends install -y kde-window-manager || apt-get --no-install-recommends install -y kwin
  apt-get install -y kde-base-artwork || apt-get install -y plasma-desktopthemes-artwork
  apt-get install -y kde-wallpapers-default
#  apt-get --no-install-recommends install -y kde-window-manager-active
#  apt-get install -y lightdm lightdm-kde-greeter
#  apt-get --no-install-recommends install -y lightdm-gtk-greeter

  apt-get remove -y desktop-base
  apt-get --no-install-recommends install -y kde-artwork-active plasma-active-default-settings || apt-get install -y desktop-base

  apt-get --no-install-recommends install -y breeze breeze-cursor-theme breeze-icon-theme || apt-get install -y oxygen-cursor-theme oxygen-icon-theme

  apt-get --no-install-recommends install -y plasma-workspace || true
  apt-get --no-install-recommends install -y plasma-desktop
  apt-get install -y plasma-widget-folderview
  apt-get install -y gtk2-engines-oxygen kde-config-gtk-style
  apt-get install -y gtk3-engines-oxygen || true

#?  apt-get --no-install-recommends install -y plasma-nm

  apt-get --no-install-recommends install -y kde-workspace-bin || apt-get --no-install-recommends install -y kde-runtime-data
  apt-get --no-install-recommends install -y kubuntu-settings-desktop || true
  apt-get install -y kdepasswd kmix konsole
  apt-get install -y klipper || true
  apt-get install -y oxygen-cursor-theme || true
  apt-get install -y     hicolor-icon-theme oxygen-icon-theme     polkit-kde-1     tcpdump telnet 
  apt-get --no-install-recommends install -y freespacenotifier plasma-netbook || true
  apt-get --no-install-recommends install -y systemsettings


# calculator, image viewer, document viewer, text editor, archiver (we already installed galculator gpicview evince leafpad xarchiver above)
#  apt-get --no-install-recommends install -y kcalc gwenview okular kate ark

#  apt-get --no-install-recommends install -y kde-workspace
#  apt-get install -y upower usbmuxd
#  apt-get install -y kubuntu-settings-active
#  apt-get --no-install-recommends install -y kubuntu-active

  apt-get --no-install-recommends install -y language-pack-kde-de || true

# KDE end
elif [ "XFCE" = "GNOME" ] ; then
# GNOME
  apt-get --no-install-recommends install -y gnome-session-bin gnome-session-canberra
  apt-get install -y gnome-keyring gnome-menus 
#  apt-get install -y ubuntu-artwork ubuntu-ui-toolkit-theme
  apt-get --no-install-recommends install -y gnome-terminal
  # needed for indicators below
  apt-get --no-install-recommends install -y mousetweaks
  apt-get --no-install-recommends install -y gnome-control-center-shared-data unity-control-center || apt-get --no-install-recommends install -y gnome-control-center
  apt-get install -y gvfs-backends
  apt-get --no-install-recommends install -y zenity

  apt-get install -y gnome-backgrounds gnome-icon-theme-extras gnome-settings-daemon gnome-tweak-tool
#  apt-get install -y gnome-session
  apt-get --no-install-recommends install -y gnome-control-center nautilus
  apt-get --no-install-recommends install -y gnome-shell
#? bluez etc. (gnome-user-share)
#  apt-get install -y gnome-user-share 
#  apt-get install -y gnome-shell-extensions
  apt-get install -y ubuntu-gnome-default-settings ubuntu-gnome-wallpapers || true
  apt-get install -y gvfs-bin mutter notification-daemon ssh-askpass-gnome
  apt-get install -y gvfs-backends-goa || apt-get install -y gvfs-backends || true

  apt-get --no-install-recommends install -y gnome-session-flashback

  apt-get install -y indicator-applet || true
  apt-get install -y indicator-datetime indicator-keyboard indicator-power || true
#  apt-get install -y gnome-power-manager gnome-screensaver
  apt-get --no-install-recommends install -y indicator-session
  apt-get install -y indicator-applet-session || true
  apt-get --no-install-recommends install -y ibus-table
  apt-get --no-install-recommends install -y indicator-applet-complete || true

# calculator, image viewer, document viewer, text editor, archiver (we already installed galculator gpicview evince leafpad xarchiver above)
#  apt-get --no-install-recommends install -y gnome-calculator eog evince gedit file-roller

#  apt-get install -y upstart
#  apt-get --no-install-recommends install -y ubuntu-gnome-desktop

  apt-get install -y systemd-sysv

  apt-get install -y libglib2.0-bin
  sed -i s/'show-desktop-icons=false'/'show-desktop-icons=true'/g /usr/share/glib-2.0/schemas/*.override
# Will be run after user is created
#  -H -u remote gsettings set org.gnome.desktop.background show-desktop-icons true

# GNOME end
elif [ "XFCE" = "MATE" ] ; then
# MATE
  # needed by mate-applets
  [ 1504 -le 1604 ] && apt-get --no-install-recommends install -y     gstreamer0.10-plugins-base gstreamer0.10-x     libgstreamer0.10-0 libgstreamer-plugins-base0.10-0
  [ 1504 -le 1604 ] && apt-get --no-install-recommends install -y     gstreamer0.10-alsa gstreamer0.10-gconf gstreamer0.10-plugins-good     python-gst0.10

  apt-get --no-install-recommends install -y mate-session-manager
  apt-get --no-install-recommends install -y gnome-control-center-shared-data || true
  apt-get --no-install-recommends install -y gnome-session-canberra
  apt-get install -y mate-menus
#  apt-get install -y ubuntu-artwork ubuntu-ui-toolkit-theme
  apt-get --no-install-recommends install -y mate-terminal
  apt-get install -y gvfs-backends
  apt-get --no-install-recommends install -y zenity

#  apt-get install -y mate-backgrounds mate-icon-theme-faenza
  apt-get install -y mate-settings-daemon
  apt-get install -y mate-tweak || true
  apt-get --no-install-recommends install -y mate-control-center caja
#  apt-get install -y mate-user-share
  apt-get install -y ubuntu-mate-default-settings ubuntu-mate-wallpapers || true
  apt-get install -y gvfs-bin mate-notification-daemon
#?  apt-get install -y gvfs-backends-goa mutter ssh-askpass-gnome

  apt-get install -y mate-indicator-applet
  apt-get --no-install-recommends install -y marco mate-applets
#  apt-get install -y mate-power-manager mate-screensaver
#  apt-get --no-install-recommends install -y ibus-table

#  apt-get install -y mate-gnome-main-menu-applet
#  apt-get install -y mate-desktop-environment-core

  apt-get install -y gtk2-engines-murrine mozo python-mate-menu
  apt-get install -y plymouth-theme-ubuntu-text ttf-ubuntu-font-family ubuntu-mono || true
  apt-get install -y python-configobj python-glade2 python-xlib python3-requests python3-urllib3
  apt-get install -y rename wmctrl

  # not available in utopic or older
  apt-get install -y mate-menu || true
  apt-get install -y lightdm-gtk-greeter-settings yuyo-gtk-theme || true
  apt-get install -y ubuntu-mate-artwork ubuntu-mate-lightdm-theme ubuntu-mate-themes || apt-get install -y mate-themes

# calculator, image viewer, document viewer, text editor, archiver (we already installed galculator gpicview evince leafpad xarchiver above)
#  apt-get --no-install-recommends install -y galculator eom atril pluma engrampa
#  (mate-calc)

#  apt-get install -y upstart
#  apt-get --no-install-recommends install -y ubuntu-mate-core
#  apt-get --no-install-recommends install -y ubuntu-mate-desktop

  apt-get install -y systemd-sysv

  apt-get install -y libglib2.0-bin
  sed -i s/'show-desktop-icons=false'/'show-desktop-icons=true'/g /usr/share/glib-2.0/schemas/*.override
# Will be run after user is created
#  sudo -H -u remote gsettings set org.gnome.desktop.background show-desktop-icons true

# MATE end
elif [ "XFCE" = "Unity" ] ; then
# Unity
  apt-get --no-install-recommends install -y gnome-session-bin gnome-session-canberra
  apt-get install -y gnome-keyring gnome-menus ubuntu-artwork ubuntu-ui-toolkit-theme
  apt-get --no-install-recommends install -y gnome-terminal
  apt-get --no-install-recommends install -y unity-control-center
  apt-get install -y gvfs-backends
  apt-get --no-install-recommends install -y zenity
  apt-get --no-install-recommends install -y nautilus
  apt-get install -y gvfs-bin mutter notification-daemon ssh-askpass-gnome

  apt-get install -y indicator-applet
  apt-get install -y indicator-datetime indicator-keyboard indicator-power
  apt-get --no-install-recommends install -y indicator-session
  apt-get --no-install-recommends install -y ibus-table

  apt-get install -y python-gobject
  apt-get --no-install-recommends install -y ubuntu-session ubuntu-settings ubuntu-sounds
  apt-get --no-install-recommends install -y unity
#  apt-get install -y unity-gtk2-module unity-gtk3-module
  apt-get install -y appmenu-gtk appmenu-gtk3 appmenu-qt
  apt-get install -y indicator-appmenu

# calculator, image viewer, document viewer, text editor, archiver (we already installed galculator gpicview evince leafpad xarchiver above)
#  apt-get --no-install-recommends install -y gnome-calculator eog evince gedit file-roller

#  apt-get install -y upstart
#  apt-get --no-install-recommends install -y linaro-ubuntu-desktop

  apt-get install -y systemd-sysv
# Unity end
elif [ "XFCE" = "Matchbox" ] ; then
# Matchbox
  apt-get install -y matchbox
# Matchbox end
else
# Other
  echo ""
  echo ""
  echo ""
  echo "Use apt-get install to choose your desktop environment"
  echo ""
  bash || true
  echo ""

# Other end
fi


export needboardart=false
export needboardapp=false
export needboardfbt=false

if true ; then
  if [ "Raspbian" = "Raspbian" ] ; then
    apt-get install -y xserver-xorg-video-fbturbo || export needboardfbt=true
  fi
  if $needboardfbt ; then
    cd /root/source/
    dpkg -i xserver-xorg-video-fbturbo_*_armhf.deb && export needboardfbt=false
    cd -
  fi

  if [ "XFCE" != "Matchbox" -a 1 != 0 ] ; then
  #[ 1504 -ge 1204 ] && apt-get install -y   #  fonts-freefont-ttf		   #  gnome-desktop3-data		   #  python-gi

  apt-get install -y     gettext-base		     gnome-icon-theme-symbolic	     menu			     menu-l10n			     menu-xdg			     netcat-openbsd		     python3			     python3-minimal
#    wireless-tools
  fi

  [ 1504 -le 1510 ] && apt-get install -y python-support

#    python-numpy		 #    python-serial		 #    python-tk			 #    python3-numpy		 #    python3-serial		 #    python3-tk			 
#    gstreamer0.10-plugins-bad	 #    libgstreamer-plugins-bad0.10-0	 
#    java-common			 #    ncdu			 #    netcat-traditional		 #    weston			 #    wpagui

#    netsurf-common		 #    netsurf-gtk			 
  [ arm = "arm" ] && apt-get --no-install-recommends install -y omxplayer || true

  if [ "Raspbian" = "Raspbian" ] ; then
    if [ 1504 -lt 1504 ]; then
      apt-get --no-install-recommends install -y epiphany-browser || export needboardapp=true
    fi
    #apt-get install -y gstreamer0.10-ffmpeg || true
    if [ 1504 -le 1604 ]; then
      apt-get install -y gstreamer1.0-libav gstreamer1.0-omx || export needboardapp=true
    fi
  fi

#  apt-get --purge remove ncdu netcat-traditional weston wpagui
#  apt-get --purge remove equivs heirloom-mailx gnome-user-guide yelp yelp-xsl
#  apt-get --purge remove update-manager-gnome
#  apt-get --purge remove va-driver-all vdpau-va-driver
#  apt-get --purge remove xfonts-100dpi xfonts-75dpi
#  apt-get --purge remove samba samba-dsdb-modules samba-vfs-modules winbind
#  apt-get --purge remove apt-file geoclue-2.0 modemmanager
#  apt-get --purge autoremove
fi


# extra x11

apt-get install -y   numlockx sshfs

if [ "XFCE" != "Matchbox" -a 1 != 0 ] ; then

apt-get --no-install-recommends install -y   network-manager-openvpn-gnome

#apt-get --no-install-recommends install -y #  pulseaudio-utils #  qjackctl

[ 1504 -le 1604 ] && [ arm = "arm" ] && apt-get --no-install-recommends install -y   gstreamer0.10-plugins-base gstreamer0.10-x   libgstreamer0.10-0 libgstreamer-plugins-base0.10-0

#apt-get install -y ltsp-client-core

#[ 1504 -ge 1010 ] && apt-get install -y luajit || true

#apt-get install -y hardlink openssh-blacklist openssh-blacklist-extra
[ 1504 -le 1510 ] && apt-get install -y python-support

[ 1504 -ge 1204 ] && [ 1504 -le 1510 ] && apt-get install -y fonts-droid
#[ 1504 -ge 1604 ] && apt-get install -y fonts-droid-fallback
[ 1504 -ge 1304 ] && [ 1504 -le 1510 ] && apt-get install -y fonts-roboto

apt-get --no-install-recommends install -y gdebi gksu

#apt-get install -y timidity
#apt-get install -y libgtk2-perl
#apt-get install -y software-properties-common
#apt-get install -y g++-multilib libsfgcc1

if [ 1504 -ge 1204 ]; then
# precise
  apt-get install -y     gnome-icon-theme-symbolic     p11-kit     python3-chardet     python3-dbus     python3-gi     python3-six
  #apt-get install -y   #  python-gi
fi

if [ 1504 -ge 1104 ]; then
# natty
  apt-get install -y     gnome-desktop3-data     python-talloc     python3-apt
fi

#apt-get install -y poppler-data

apt-get install -y   doc-base laptop-detect
#apt-get install -y miscfiles gdebi-core python-tk

[ "XFCE" != "KDE" ] && apt-get install -y desktop-base
#apt-get install -y xbacklight

# python package installer
#apt-get install -y python-pip python-smbus

# != "Matchbox" && installKweb end
fi


if [ "XFCE" != "Matchbox" ] ; then

  [ 1504 -ge 1010 ] && apt-get install -y freerdp-x11

  apt-get install -y xtightvncviewer

  [ 1504 -ge 1210 ] && apt-get install -y fake-hwclock

  apt-get install -y fbset

  # maverick
  apt-get install -y gdisk || true

  apt-get install -y language-pack-gnome-de-base || true

  # org.ally.Bus
  [ 1504 -ge 1104 ] && apt-get install -y at-spi2-core
  # org.freedesktop.secrets
  apt-get install -y gnome-keyring

# != "Matchbox" end
fi


if [ "raspberrypi" = "raspberrypi" ]; then
  if [ "Raspbian" = "Raspbian" ] ; then
    apt-get install -y raspberrypi-artwork || export needboardart=true
    if [ "XFCE" = "LXDE" ]; then
      apt-get install -y raspberrypi-ui-mods || export needboardart=true
    fi
  else
    export needboardart=true
  fi

  if $needboardart ; then
    dpkg -i /root/board-debs/raspberrypi-artwork_*_all.deb
    if [ 1504 -ge 1308 -a "XFCE" = "LXDE" ]; then
      apt-get --no-install-recommends install -y xfce4-mixer 
      apt-get --no-install-recommends install -y zenity
      dpkg -i /root/board-debs/pipanel_*_*.deb
      dpkg -i /root/board-debs/raspberrypi-ui-mods_*_*.deb
    fi
  fi
fi

debconf-set-selections < /root/board-debs/debconf-selections-dash.txt

dpkg-reconfigure -f noninteractive dash

if [ "XFCE" != "Matchbox" ] ; then

apt-get install -y aspell			 aspell-de aspell-en		 
#apt-get install -y #hunspell-de-de #hunspell-en-us

# != "Matchbox" end
fi

[ 1 != 0 ] && apt-get --no-install-recommends install -y zenity

if [ 0 = 0 ]; then
  if [ -e /etc/NetworkManager/NetworkManager.conf ]; then
    sed -i s/'managed=false'/'managed=true'/g /etc/NetworkManager/NetworkManager.conf
  elif [ -e /etc/NetworkManager/nm-system-settings.conf ]; then
    sed -i s/'managed=false'/'managed=true'/g /etc/NetworkManager/nm-system-settings.conf
  fi
fi

if [ arm = "arm" ]; then
  apt-get remove -y --purge xserver-xorg-video-amdgpu  || true
  apt-get remove -y --purge xserver-xorg-video-nouveau || true
  apt-get remove -y --purge xserver-xorg-video-radeon  || true
fi

#apt-get install -y command-not-found
apt-get install -y bash-completion iputils-tracepath nano tcpdump telnet
[ 1504 -le 1110 ] || apt-get install -y fuse
apt-get --no-install-recommends install -y update-manager-core || true
#apt-get install -y apparmor friendly-recovery notification-daemon ufw

#apt-get clean

apt-get --purge remove -y language-selector-common || true
[ "XFCE" != "GNOME" -a "XFCE" != "MATE" -a "XFCE" != "Unity" ] && apt-get --purge remove -y accountsservice
apt-get --purge remove -y libbonobo2-common libbonoboui2-common
apt-get --purge remove -y mlocate popularity-contest

if [ ! -e /usr/share/language-tools/language-validate ]; then
  mkdir -p /usr/share/language-tools
  ln -s /bin/true /usr/share/language-tools/language-validate
fi

[ -e /etc/cron.weekly/fstrim ] && rm /etc/cron.weekly/fstrim

#apt-get install -y dphys-swapfile
#[ -e /var/swap ] && swapoff /var/swap
#[ -e /var/swap ] && rm /var/swap

#/etc/init.d/dbus stop || true
kill `ps ax | grep qemu | grep dbus-daemon | grep -v grep | sed -e 's/^[ \t]*//' | cut -d " " -f 1` || true
kill `ps ax | grep qemu | grep dbus-launch | grep -v grep | sed -e 's/^[ \t]*//' | cut -d " " -f 1` || true

umount /proc || true

for f in `find /usr/share/icons/ -name preferences-desktop-remote-desktop*` ; do
  d=`dirname $f`
  b=`basename $f`
  n=${d}/${b/preferences-desktop-remote-desktop/krfb}
  if [ ! -e $n ]; then
    ln -s $b $n
  fi
done

rm -f /usr/share/icons/*/icon-theme.cache

touch /tmp/`basename $0`.done
echo "OK"
