#!/bin/bash -e
cd /root/

cd /root/source/

for d in lenny squeeze wheezy jessie stretch lucid maverick natty oneiric precise quantal raring saucy trusty utopic vivid wily xenial yakkety ; do
  if [ $d != jessie ]; then
    rm -rf ${d}/ | true
    rm -rf ${d}-lts-*/ | true
    rm *${d}-*.zip | true
  fi
done

if true ; then
  rm cogl*.patch | true
  rm cogl*.zip | true
  rm gstreamer*.zip | true
  if [ Raspbian = "Raspbian" ]; then
    rm mesa*.patch | true
    rm mesa*.zip | true
  fi
fi

if [ -e jessie ]; then
  mv jessie/* .
  rmdir jessie
fi

for d in i386 amd64 armhf arm64 ; do
  if [ $d != armhf ]; then
    rm *-${d}*.zip | true
  fi
done

apt-get install -y patch unzip zip

[ 1504 -ge 1008 ] && apt-get install -y xz-utils


bootltgz=raspberrypi-bootloader.tar.gz
for f in `ls raspberrypi-bootloader*.tar.gz`; do
  bootltgz=$f
done
for f in `ls raspberrypi-bootloader*-armhf.tar.gz`; do
  bootltgz=$f
done
for f in `ls raspberrypi-bootloader*jessie-armhf.tar.gz`; do
  bootltgz=$f
done

if [ -e ${bootltgz} ]; then
  cd /
  tar xzvf /root/source/${bootltgz}
  cd /root/
  cd source/
fi


if [ -e /usr/bin/raspi-config ]; then
	export RPICFGV=`grep -A9 'Package: raspi-config' /root/board-debs/raspberrypi-jessie-Packages | grep -m1 'Version:' | cut -d " " -f 2-`

	rpicftgz=raspi-config-patch.tar.gz
	for f in `ls raspi-config*.tar.gz`; do
		rpicftgz=$f
	done
	for f in `ls raspi-config*-armhf.tar.gz`; do
		rpicftgz=$f
	done
	for f in `ls raspi-config*jessie-armhf.tar.gz`; do
		rpicftgz=$f
	done
	
	for f in `ls raspi-config*${RPICFGV}*.tar.gz`; do
		rpicftgz=$f
	done
	for f in `ls raspi-config*${RPICFGV}*-armhf.tar.gz`; do
		rpicftgz=$f
	done
	for f in `ls raspi-config*${RPICFGV}*jessie-armhf.tar.gz`; do
		rpicftgz=$f
	done

	if [ -e ${rpicftgz} ]; then
		echo ${rpicftgz} for raspi-config ${RPICFGV}
		tar xzvf ${rpicftgz}

		cd /
		for p in `ls /root/source/raspi-config-*.patch`; do
			patch -p0 < $p
		done
		cd /root/
		cd source/
	fi

	#sed -i s/'unit s p '/'unit s print '/g /usr/bin/raspi-config
fi

bootlzip=raspberrypi-bootloader.zip
for f in `ls raspberrypi-bootloader*.zip`; do
  bootlzip=$f
done
for f in `ls raspberrypi-bootloader*-armhf.zip`; do
  bootlzip=$f
done
for f in `ls raspberrypi-bootloader*jessie-armhf.zip`; do
  bootlzip=$f
done

if [ -e ${bootlzip} ]; then
  unzip ${bootlzip}

  dpkg -i /root/source/raspberrypi-bootloader_*.deb
fi


btinizip=bootini.zip
for f in `ls bootini*.zip`; do
  btinizip=$f
done
for f in `ls bootini*-armhf.zip`; do
  btinizip=$f
done
for f in `ls bootini*jessie-armhf.zip`; do
  btinizip=$f
done

if [ -e ${btinizip} ]; then
  unzip ${btinizip}

  #./install-bootini.sh
fi


if [ "XFCE" != "none-mini" ] ; then


ldri2zip=libdri2.zip
for f in `ls libdri2*-armhf.zip`; do
  ldri2zip=$f
done
for f in `ls libdri2*jessie-armhf.zip`; do
  ldri2zip=$f
done

if [ -e ${ldri2zip} ]; then
  unzip ${ldri2zip}

  apt-get install -y libdrm2 libx11-6 libxext6

  dpkg -i libdri2-1_*.deb
fi


sxumpzip=libump.zip
for f in `ls libump*-armhf.zip`; do
  sxumpzip=$f
done
for f in `ls libump*jessie-armhf.zip`; do
  sxumpzip=$f
done

if [ -e ${sxumpzip} ]; then
  unzip ${sxumpzip}

  if [ "raspberrypi" = "amlsx05" ] ; then
    dpkg -i libump-mali_*.deb
  else
    dpkg -i libump_*.deb
    mkdir /usr/lib/arm-linux-gnueabihf/.mesa-egl && mv /usr/lib/arm-linux-gnueabihf/mesa-egl/libEGL* /usr/lib/arm-linux-gnueabihf/.mesa-egl/ && mv /usr/lib/arm-linux-gnueabihf/mesa-egl/libGLES* /usr/lib/arm-linux-gnueabihf/.mesa-egl/ && ldconfig
  fi
fi


sxmalzip=libmali.zip
for f in `ls libmali*-armhf.zip`; do
  sxmalzip=$f
done
for f in `ls libmali*jessie-armhf.zip`; do
  sxmalzip=$f
done

if [ -e ${sxmalzip} ]; then
  unzip ${sxmalzip}

  apt-get install -y libdri2-1
  apt-get install -y libdrm2 libx11-6 libxext6 libxfixes3

  dpkg -i libmali_*.deb
  
  #if [ -e /usr/lib/arm-linux-gnueabihf/libUMP.so.3 ]; then
  #  ln -sf /usr/lib/arm-linux-gnueabihf/libUMP.so.3 /usr/lib/libUMP.so
  #  ln -sf /usr/lib/arm-linux-gnueabihf/libUMP.so.3 /usr/lib/libUMP.so.3
  #fi
fi


lbvdpzip=libvdpau-0.9.zip
for f in `ls libvdpau-?.*.zip`; do
  lbvdpzip=$f
done
for f in `ls libvdpau-?.*-armhf.zip`; do
  lbvdpzip=$f
done
for f in `ls libvdpau-?.*jessie-armhf.zip`; do
  lbvdpzip=$f
done

if [ -e ${lbvdpzip} ]; then
  unzip ${lbvdpzip}

  dpkg -i libvdpau?_*.deb
fi


sxcdrzip=libcedrus.zip
for f in `ls libcedrus*.zip`; do
  sxcdrzip=$f
done
for f in `ls libcedrus*-armhf.zip`; do
  sxcdrzip=$f
done
for f in `ls libcedrus*jessie-armhf.zip`; do
  sxcdrzip=$f
done

if [ -e ${sxcdrzip} ]; then
  unzip ${sxcdrzip}

  dpkg -i libcedrus*_*.deb
  
  if [ -e /usr/lib/libcedrus.so.1 ]; then
    ln -sf libcedrus.so.1 /usr/lib/libcedrus.so
    #ln -sf /usr/lib/libcedrus.so.1 /usr/lib/arm-linux-gnueabihf/libcedrus.so.1
  fi
fi


sxvdpzip=libvdpau-sunxi.zip
for f in `ls libvdpau-sunxi*.zip`; do
  sxvdpzip=$f
done
for f in `ls libvdpau-sunxi*-armhf.zip`; do
  sxvdpzip=$f
done
for f in `ls libvdpau-sunxi*jessie-armhf.zip`; do
  sxvdpzip=$f
done

if [ -e ${sxvdpzip} ]; then
  unzip ${sxvdpzip}

  dpkg -i libvdpau-sunxi*_*.deb
  
  if [ -e /usr/lib/arm-linux-gnueabihf/vdpau/libvdpau_sunxi.so.1 ]; then
    ln -sf libvdpau_sunxi.so.1 /usr/lib/arm-linux-gnueabihf/vdpau/libvdpau_sunxi.so
    ln -sf libvdpau_sunxi.so.1 /usr/lib/arm-linux-gnueabihf/vdpau/libvdpau_nvidia.so
    ln -sf libvdpau_sunxi.so.1 /usr/lib/arm-linux-gnueabihf/vdpau/libvdpau_nvidia.so.1
  fi
fi


sxtlszip=sunxi-tools.zip
for f in `ls sunxi-tools*.zip`; do
  sxtlszip=$f
done
for f in `ls sunxi-tools*-armhf.zip`; do
  sxtlszip=$f
done
for f in `ls sunxi-tools*jessie-armhf.zip`; do
  sxtlszip=$f
done

if [ -e ${sxtlszip} ]; then
  unzip ${sxtlszip}

  apt-get install -y libusb-1.0-0

  dpkg -i sunxi-tools*_*.deb
fi


if [ "raspberrypi" = "amlsx05" ] ; then
  apt-get install -y mali-x11 || apt-get install -y mali450-odroid || apt-get install -y libegl1-mesa
fi

ammalzip=mali-x11.zip
for f in `ls mali-x11*-armhf.zip`; do
  ammalzip=$f
done
for f in `ls mali-x11*jessie-armhf.zip`; do
  ammalzip=$f
done

if [ -e ${ammalzip} ]; then
  unzip ${ammalzip}

  apt-get install -y libdri2-1
  apt-get install -y libxfixes3

  dpkg -i mali-x11_*.deb
  
  #if [ -e /usr/lib/arm-linux-gnueabihf/libUMP.so.3 ]; then
  #  ln -sf /usr/lib/arm-linux-gnueabihf/libUMP.so.3 /usr/lib/libUMP.so
  #  ln -sf /usr/lib/arm-linux-gnueabihf/libUMP.so.3 /usr/lib/libUMP.so.3
  #fi
fi

emesabav=10.9
[ 1504 -ge 1510 ] && emesabav=11.9
[ 1504 -ge 1610 ] && emesabav=12.9
[ 1504 -ge 1504 -a "Raspbian" = "Raspbian" ] && emesabav=11.9
emesabas=libegl1-mesa-${emesabav}

emesatgz=${emesabas}-fake.tar.gz
for f in `ls ${emesabas}*-fake*.tar.gz`; do
  emesatgz=$f
done
for f in `ls ${emesabas}*-fake*-armhf.tar.gz`; do
  emesatgz=$f
done
for f in `ls ${emesabas}*-fake*jessie-armhf.tar.gz`; do
  emesatgz=$f
done

if [ -e ${emesatgz} ]; then
  tar xzvf ${emesatgz}

  apt-get install -y libc6 libx11-6 libx11-xcb1 libxcb-dri2-0 libxcb-xfixes0 libxcb1

  if [ "Raspbian" != "Ubuntu" ] ; then
  dpkg -i libgles1-mesa/libgles1-mesa_1?.9.0.deb &&   dpkg -i libgles2-mesa/libgles2-mesa_1?.9.0.deb &&   dpkg -i libegl1-mesa/libegl1-mesa_1?.9.0.deb
  dpkg -i libegl1-mesa/libegl1-mesa-drivers_1?.9.0.deb || true
  dpkg -i libopenvg1-mesa/libopenvg1-mesa_1?.9.0.deb || true
  fi
fi


wmesazip=mesa-${emesabav}-nodbg.zip
for f in `ls mesa-${emesabav}*-nodbg*-armhf.zip`; do
  wmesazip=$f
done
for f in `ls mesa-${emesabav}*-nodbg*jessie-armhf.zip`; do
  wmesazip=$f
done

if [ -e ${wmesazip} -a 1504 -ge 1204 ]; then
  unzip ${wmesazip}

  dpkg -i libwayland-egl1-mesa_1?.9*_armhf.deb
  #apt-get remove -y libegl1-mesa-drivers

  if [ jessie = trusty -a "x" != "x" ]; then
    apt-get install -y libllvm3.5

  elif [ 1504 -ge 1510 ] ; then
    apt-get install -y libllvm3.7
  elif [ 1504 -ge 1410 ] ; then
    apt-get install -y libllvm3.5
  elif [ 1504 -ge 1404 ] ; then
    apt-get install -y libllvm3.4
  elif [ 1504 -ge 1310 ] ; then
    apt-get install -y libllvm3.3
  elif [ 1504 -ge 1304 ] ; then
    apt-get install -y libllvm3.2
  elif [ 1504 -ge 1210 ] ; then
    apt-get install -y libllvm3.1
  elif [ 1504 -ge 1204 ] ; then
    apt-get install -y libllvm3.0
  fi

  apt-get install -y     libelf1 libexpat1     libdrm-radeon1     libxcb-glx0     libxdamage1 libxfixes3 libxxf86vm1
  [ armhf != arm64 ] && apt-get install -y libdrm-omap1

  [ 1504 -ge 1308 ] && apt-get install -y     libdrm-nouveau2     libxcb-dri3-0 libxcb-present0 libxcb-sync1 libxshmfence1     libwayland-client0 libwayland-server0

  [ 1504 -ge 1410 -a armhf != arm64 ] && apt-get install -y libdrm-exynos1 libdrm-freedreno1

  if [ 1504 -ge 1210 ] ; then
    apt-get install -y libdri2-1 || true
  fi

#  if [ "Raspbian" != "Ubuntu" ] ; then
#    dpkg -i libglapi-mesa_1?.9*_armhf.deb && #    dpkg -i libgl1-mesa-dri_1?.9*_armhf.deb && #    dpkg -i libgl1-mesa-glx_1?.9*_armhf.deb && #    dpkg -i libgbm1_1?.9*_armhf.deb
#  fi

  dpkg -i libwayland-egl1-mesa_1?.9*_armhf.deb

  apt-get install libwayland-egl1-mesa

elif [ "Raspbian" = "Debian" ] ; then
  [ 1504 -ge 1010 -a 1504 -lt 1504 ] && apt-get remove -y libwayland-egl1-mesa || true

elif [ 1504 -ge 1404 ] ; then
  apt-get install -y libopenvg1-mesa || true
  apt-get install -y libwayland-egl1-mesa || true
fi

if [ 1504 -ge 1010 -a "Raspbian" != "Ubuntu" ] ; then
  apt-get install -y libopenvg1-mesa || true
  [ "raspberrypi" != "amlsx05" ] && apt-get install -y libegl1-mesa-drivers
elif [ 1504 -ge 1404 ] ; then
  [ "raspberrypi" != "amlsx05" ] && apt-get install -y libegl1-mesa-drivers
  apt-get install -y mesa-utils mesa-vdpau-drivers
fi

lcoglzip=cogl-nodbg.zip
if [ "Raspbian" != "Ubuntu" ] ; then
for f in `ls cogl-*-nodbg*-armhf.zip`; do
  lcoglzip=$f
done
for f in `ls cogl-*-nodbg*jessie-armhf.zip`; do
  lcoglzip=$f
done
fi

if [ -e ${lcoglzip} ]; then
  unzip ${lcoglzip}

  apt-get install -y libgdk-pixbuf2.0-0 libxrandr2 libxcomposite1

  if [ 1504 -ge 1404 ]; then
    apt-get install -y libgbm1
    apt-get install -y libxdamage1 libxfixes3

    dpkg -i libcogl??_1.19.?-?_armhf.deb &&     dpkg -i libcogl-gles2-??_1.19.?-?_armhf.deb

    for f in `ls libcogl-path??_1.19.?-?_armhf.deb`; do
      dpkg -i $f
    done

    dpkg -i libcogl-common_1.19.?-?_all.deb

    apt-get install -y libcairo2 libglib2.0-0 libpango-1.0-0 libpangocairo-1.0-0

    dpkg -i libcogl-pango??_1.19.?-?_armhf.deb
  fi
fi


if [ "XFCE" != "none-mini" ] ; then
	# before lightdm
	[ "raspberrypi" != "amlsx05" -a 1504 -ge 1010 ] && apt-get --no-install-recommends install -y libegl1-mesa
	apt-get install -y xserver-common xserver-xorg-core xserver-xorg-input-evdev xserver-xorg-video-fbdev
	apt-get --no-install-recommends install -y xserver-xorg
	if [ raspberrypi = generic -o "raspberrypi" = "mac" -o "raspberrypi" = "pc" ]; then
		apt-get install -y  xserver-xorg-input-all xserver-xorg-video-all
		[ 1504 -le 1204 ] && apt-get install -y 		  xserver-xorg-video-apm xserver-xorg-video-ark xserver-xorg-video-chips xserver-xorg-video-i128 xserver-xorg-video-i740 		  xserver-xorg-video-rendition xserver-xorg-video-s3virge xserver-xorg-video-tseng xserver-xorg-video-voodoo
		[ 1504 -ge 1404 ] && apt-get install -y  mesa-vdpau-drivers 
	fi

	#DEBIAN_FRONTEND=noninteractive apt-get --no-install-recommends install -y jackd jackd2
	DEBIAN_FRONTEND=noninteractive apt-get --no-install-recommends install -y nbd-client
fi

apt-get install -y lockfile-progs python-serial tftp-hpa udhcpc

if [ "XFCE" != "none" ] ; then
	[ 1504 -ge 1204 ] || touch /etc/ltsp_chroot
	apt-get install -y ltsp-client-core
fi


# rpi stuff

xsfbtzip=xserver-xorg-video-fbturbo.zip
if [ "Raspbian" != "Ubuntu" ] ; then
for f in `ls xserver-xorg-video-*-armhf.zip`; do
  xsfbtzip=$f
done
for f in `ls xserver-xorg-video-*jessie-armhf.zip`; do
  xsfbtzip=$f
done
for f in `ls xserver-xorg-video-fbturbo-*-armhf.zip`; do
  xsfbtzip=$f
done
for f in `ls xserver-xorg-video-fbturbo*jessie-armhf.zip`; do
  xsfbtzip=$f
done
fi

if [ -e ${xsfbtzip} ]; then
  unzip ${xsfbtzip}

  apt-get install -y xserver-common xserver-xorg-core

  apt-get remove -y --purge xserver-xorg-video-mali || true
  apt-get remove -y --purge xf86-video-mali-odroid  || true
  rm -f /etc/X11/xorg.conf.d/40-mali.conf

  [ "Raspbian" != "Raspbian" ] && dpkg -i xserver-xorg-video-*_*_armhf.deb
fi

if [ raspberrypi = generic -o "raspberrypi" = "mac" -o "raspberrypi" = "pc" ]; then
  if [ 1504 -ge 1404 ]; then
    apt-get install -y libvdpau-va-gl1 mesa-vdpau-drivers vdpau-va-driver
    
    [ armhf = amd64 -o armhf = i386 ] && apt-get install -y i965-va-driver

#    apt-get install -y xvba-va-driver
#    mkdir -p /usr/lib/va/drivers
#  for f in /usr/lib/*-linux-gnu/dri/fglrx_drv_video.so ; do
#    ln -s  /usr/lib/va/drivers/xvba_drv_video.so
#  done

    echo "export VDPAU_DRIVER=va_gl" | tee /etc/profile.d/vdpau-vaapi.sh > /dev/null
  fi
fi

# [ "XFCE" != "none-mini" ]
fi

cd -


mkdir -p board-debs

cd board-debs/
#get http://archive.raspberrypi.org/debian/pool/main/o/omxplayer/omxplayer_0.3.6~git20150210~337004e_armhf.deb
[ 1504 -ge 1008 ] && apt-get install -y libssh-4
#udo dpkg -i omxplayer_*_armhf.deb
cd -

cd source/

touch /tmp/`basename $0`.done
echo "OK"
