#!/bin/bash -e
EDIOLDHOME=$HOME
export HOME=/root
cd /root/

cd /root/source/

apt-get install -y unzip zip


# optional stuff

xfrdpzip=freerdp.zip
for f in `ls freerdp-*-armhf.zip`; do
  xfrdpzip=$f
done
for f in `ls freerdp*jessie-armhf.zip`; do
  xfrdpzip=$f
done

if [ -e ${xfrdpzip} ]; then
  unzip ${xfrdpzip}

  if [ -e ./install-freerdp.sh ]; then
    ./install-freerdp.sh
  else
    dpkg -i libfreerdp1_*_armhf.deb &&     dpkg -i libfreerdp-plugins-standard_*_armhf.deb &&     dpkg -i freerdp-x11_*_armhf.deb
  fi
fi


# rpi optional stuff

if [ "XFCE" != "Matchbox" ] ; then

[ 1504 -le 1604 ] && [ arm = "arm" ] && apt-get --no-install-recommends install -y   gstreamer0.10-plugins-base gstreamer0.10-x   libgstreamer0.10-0 libgstreamer-plugins-base0.10-0

#unzip gstreamer1.0-*-armhf.zip 

#dpkg -i libgstreamer1.0-0_*_armhf.deb && #dpkg -i libgstreamer-plugins-base1.0-0_*_armhf.deb && #dpkg -i gstreamer1.0-plugins-base_*_armhf.deb

[ 1504 -ge 1304 ] && apt-get install -y gstreamer1.0-plugins-base
[ 1504 -ge 1304 -a 1 != 0 ] && apt-get install -y gstreamer1.0-alsa gstreamer1.0-x

gstgdzip=gstreamer1.0-plugins-good.zip
for f in `ls gstreamer1.0-plugins-good*-armhf.zip`; do
  gstgdzip=$f
done
for f in `ls gstreamer1.0-plugins-good*jessie-armhf.zip`; do
  gstgdzip=$f
done

if [ -e ${gstgdzip} ]; then
  unzip ${gstgdzip}

  apt-get install -y libaa1 libavc1394-0 libcaca0 libdv4 libiec61883-0 libraw1394-11 libshout3 libspeex1 libtag1c2a libwavpack1 libvpx1

  dpkg -i gstreamer1.0-plugins-good_*_armhf.deb

  apt-get remove -y libgstreamer-plugins-good1.0-0
else
  [ 1504 -ge 1304 -a 1 != 0 ] && apt-get --no-install-recommends install -y gstreamer1.0-plugins-good
fi


gstbdzip=gstreamer1.0-plugins-bad.zip
for f in `ls gstreamer1.0-plugins-bad*-armhf.zip`; do
  gstbdzip=$f
done
for f in `ls gstreamer1.0-plugins-bad*jessie-armhf.zip`; do
  gstbdzip=$f
done

if [ -e ${gstbdzip} ]; then
  unzip ${gstbdzip}

  apt-get install -y libdc1394-22 libilmbase6 libopenexr6     libchromaprint0 libdca0 libdvdnav4 libdvdread4 libfaad2 libflite1 libfluidsynth1

  if [ 1504 -ge 1610 ]; then
    # yakkety and newer
    apt-get install -y libass5 libavcodec57 libavformat57 libavutil55 libswscale4
    apt-get install -y libavdevice57 libavfilter6
    #apt-get install -y libavresample3 libpostproc54 libswresample2
  elif [ 1504 -ge 1510 ]; then
    # wily and newer
    apt-get install -y libass5 libavcodec-ffmpeg56 libavformat-ffmpeg56 libavutil-ffmpeg54 libswscale-ffmpeg3
    apt-get install -y libavdevice-ffmpeg56 libavfilter-ffmpeg5
  elif [ 1504 -ge 1504 ]; then
    # vivid, jessie
    #apt-get install -y libass5 libavcodec-ffmpeg56 libavformat-ffmpeg56 libavutil-ffmpeg54 libswscale-ffmpeg3
    #apt-get install -y libavdevice-ffmpeg56 libavfilter-ffmpeg5
    apt-get install -y libass5 libavcodec56 libavformat56 libavutil54 libswscale3
    apt-get install -y libavdevice55 libavfilter5
  elif [ 1504 -ge 1410 ]; then
    # utopic
    apt-get install -y libass5 libavcodec56 libavformat56 libavutil54 libswscale3
    apt-get install -y libavdevice55 libavfilter5
  elif [ 1504 -ge 1404 ]; then
    # trusty
    apt-get install -y libass4 libavcodec54 libavformat54 libavutil52 libswscale2
    apt-get install -y libavdevice53 libavfilter3
  elif [ 1504 -ge 1110 ]; then
    # oneiric to saucy, wheezy
    apt-get install -y libass4 libavcodec53 libavformat53 libavutil51 libswscale2
    apt-get install -y libavdevice53 libavfilter2
  elif [ 1504 -le 1010 ]; then
    # maverick to natty
    apt-get install -y libass4 libavcodec52 libavformat52 libavutil50 libswscale0
    apt-get install -y libavdevice52 libavfilter1
  #if [ 1504 -le 1004 ]x then
  else
    # lucid
    apt-get install -y libass4 libavcodec52 libavformat52 libavutil49 libswscale0
    apt-get install -y libavdevice52 libavfilter0
  fi

  apt-get --no-install-recommends install -y     libopencv-calib3d2.4     libopencv-contrib2.4     libopencv-core2.4     libopencv-highgui2.4     libopencv-imgproc2.4     libopencv-legacy2.4     libopencv-objdetect2.4

    apt-get install -y libkate1 libmimic0 libmms0 libmodplug1 libmpg123-0 libofa0 libopenal1       libgme0 libsbc1 libsoundtouch0 libspandsp2 libsrtp0 libvo-aacenc0 libvo-amrwbenc0  libwildmidi1 libzbar0

  dpkg -i libgstreamer-plugins-bad1.0-0_*_armhf.deb &&   dpkg -i gstreamer1.0-plugins-bad_*_armhf.deb
#else
#  [ 1504 -ge 1304 ] && apt-get --no-install-recommends install -y gstreamer1.0-plugins-bad
fi


gstomzip=gstreamer1.0-omx.zip
for f in `ls gstreamer1.0-omx*-armhf.zip`; do
  gstomzip=$f
done
for f in `ls gstreamer1.0-omx*jessie-armhf.zip`; do
  gstomzip=$f
done

if [ -e ${gstomzip} ]; then
  unzip ${gstomzip}

  dpkg -i gstreamer1.0-omx_*_armhf.deb
fi


epibrzip=epiphany-browser.zip
for f in `ls epiphany-browser-*-armhf.zip`; do
  epibrzip=$f
done
for f in `ls epiphany-browser*jessie-armhf.zip`; do
  epibrzip=$f
done

if [ -e ${epibrzip} ]; then
  apt-get install -y libavahi-gobject0 libenchant1c2a libgeoclue0
  [ 1504 -ge 1310 ] && apt-get install -y libharfbuzz-icu0
  [ 1504 -ge 1104 ] && apt-get install -y libnspr4 libnss3 libwnck-3-0

  [ 1504 -ge 1104 ] && apt-get --no-install-recommends install -y libwebkitgtk-3.0-0

  if [ jessie = trusty ]; then
    apt-get install -y libgnome-desktop-3-7
  fi

  unzip ${epibrzip}

  dpkg -i epiphany-browser-data_*_all.deb &&   dpkg -i epiphany-browser_*_armhf.deb
fi

# != "Matchbox" end
fi

if [ "Raspbian" = "ZXYDebian" ] ; then
cat <<EOFASLUU | tee -a /etc/apt/sources.list
deb http://mirrordirector.raspbian.org/raspbian/ jessie-backports main
deb-src http://mirrordirector.raspbian.org/raspbian/ jessie-backports main
EOFASLUU

mv /etc/apt/sources.list.d /etc/apt/.sources.list.d

apt-get update
fi

sndiozip=sndio.zip
for f in `ls sndio*.zip`; do
  sndiozip=$f
done
for f in `ls sndio*-armhf.zip`; do
  sndiozip=$f
done
for f in `ls sndio*jessie-armhf.zip`; do
  sndiozip=$f
done

if [ -e ${sndiozip} ]; then
  unzip ${sndiozip}

  mkdir -p dev
  mv *-dev*.deb dev/ || true

  dpkg -i libsndio*_*_armhf.deb
#elif [ jessie = jessie ]; then
#  apt-get -t jessie-backports install -y libsndio6.1
fi

lsdl2zip=libsdl2.zip
for f in `ls libsdl2*.zip`; do
  lsdl2zip=$f
done
for f in `ls libsdl2*-armhf.zip`; do
  lsdl2zip=$f
done
for f in `ls libsdl2*jessie-armhf.zip`; do
  lsdl2zip=$f
done

apt-get install -y libsdl2-2.0-0

if [ -e ${lsdl2zip} ]; then
  unzip ${lsdl2zip}

  dpkg -i libsdl2-2.0-0_*.deb
fi

lx265zip=x265.zip
for f in `ls x265*.zip`; do
  lx265zip=$f
done
for f in `ls x265*-armhf.zip`; do
  lx265zip=$f
done
for f in `ls x265*jessie-armhf.zip`; do
  lx265zip=$f
done

lbasszip=libass.zip
for f in `ls libass*.zip`; do
  lbasszip=$f
done
for f in `ls libass*-armhf.zip`; do
  lbasszip=$f
done
for f in `ls libass*jessie-armhf.zip`; do
  lbasszip=$f
done

leburzip=libebur128.zip
for f in `ls libebur128*.zip`; do
  leburzip=$f
done
for f in `ls libebur128*-armhf.zip`; do
  leburzip=$f
done
for f in `ls libebur128*jessie-armhf.zip`; do
  leburzip=$f
done

ffmpgzip=ffmpeg.zip
for f in `ls ffmpeg*.zip`; do
  ffmpgzip=$f
done
for f in `ls ffmpeg*-armhf.zip`; do
  ffmpgzip=$f
done
for f in `ls ffmpeg*jessie-armhf.zip`; do
  ffmpgzip=$f
done

gstlazip=gstreamer1.0-libav.zip
for f in `ls gstreamer1.0-libav*-armhf.zip`; do
  gstlazip=$f
done
for f in `ls gstreamer1.0-libav*jessie-armhf.zip`; do
  gstlazip=$f
done

alsapzip=alsa-plugins.zip
for f in `ls alsa-plugins*-armhf.zip`; do
  alsapzip=$f
done
for f in `ls alsa-plugins*jessie-armhf.zip`; do
  alsapzip=$f
done

chrmpzip=chromaprint.zip
for f in `ls chromaprint*.zip`; do
  chrmpzip=$f
done
for f in `ls chromaprint*-armhf.zip`; do
  chrmpzip=$f
done
for f in `ls chromaprint*jessie-armhf.zip`; do
  chrmpzip=$f
done

mpvzip=mpv.zip
for f in `ls mpv*-armhf.zip`; do
  mpvzip=$f
done
for f in `ls mpv*jessie-armhf.zip`; do
  mpvzip=$f
done

if [ -e ${mpvzip} -a 1 != 0 ]; then
  unzip ${mpvzip}

  apt-get install -y mpv

  if [ -e ${lx265zip} ]; then
    unzip ${lx265zip}

    mkdir -p dev
    mv *-dev*.deb dev/ || true
    mkdir -p extra
    mv *-doc*.deb extra/ || true

    [ armhf = arm64 ] && apt-get install -y libnuma1

    dpkg -i libx265-*.deb
  #elif [ jessie = jessie ]; then
  #  apt-get -t jessie-backports install -y libx265-79 || apt-get -t jessie-backports install -y libx265-87
  fi

  if [ -e ${lbasszip} ]; then
    unzip ${lbasszip}

    dpkg -i libass?_*.deb
  fi

  if [ -e ${leburzip} ]; then
    unzip ${leburzip}

    mkdir -p dev
    mv *-dev*.deb dev/ || true

    dpkg -i libebur128-?_*_armhf.deb
  elif [ 1504 -ge 1504 ]; then
    apt-get install -y libebur128-1
  fi

  if [ 1504 -ge 1610 ]; then
    # yakkety and newer
    apt-get install -y libass5 libavcodec57 libavformat57 libavutil55 libswscale4
    apt-get install -y libavdevice57 libavfilter6
    #apt-get install -y libavresample3 libpostproc54 libswresample2
    apt-get install -y --no-install-recommends librubberband2v5 libva-drm1 libva-wayland1
    apt-get install -y libchromaprint0 libopenjp2-7
    apt-get install -y fonts-liberation libltdl7 libnspr4 libnss3 libspeechd2
  elif [ 1504 -ge 1510 ]; then
    # wily and newer
    apt-get install -y libass5 libavcodec-ffmpeg56 libavformat-ffmpeg56 libavutil-ffmpeg54 libswscale-ffmpeg3
    apt-get install -y libavdevice-ffmpeg56 libavfilter-ffmpeg5
    apt-get install -y --no-install-recommends librubberband2v5 libva-drm1 libva-wayland1
    apt-get install -y libchromaprint0 libopenjp2-7
    apt-get install -y fonts-liberation libltdl7 libnspr4 libnss3 libspeechd2
  elif [ 1504 -ge 1504 ]; then
    # vivid, jessie
    apt-get install -y libass5 libavcodec-ffmpeg56 libavformat-ffmpeg56 libavutil-ffmpeg54 libswscale-ffmpeg3 || true
    apt-get install -y libavdevice-ffmpeg56 libavfilter-ffmpeg5 || true
    #only if using mpv from xenial
    apt-get install -y --no-install-recommends librubberband2 libva-drm1 libva-wayland1
    if [ "XFCE" != "Matchbox" ]; then
      apt-get install -y libass5 libavcodec56 libavformat56 libavutil54 libswscale3
      apt-get install -y libavdevice55 libavfilter5
    fi
    apt-get install -y libchromaprint0 libopenjp2-7 libbs2b0 libva-x11-1
    apt-get install -y libdvdnav4 libdvdread4 libenca0 libguess1 liblua5.2-0
    apt-get install -y fonts-liberation libltdl7 libnspr4 libnss3 libspeechd2
  elif [ 1504 -ge 1410 ]; then
    # utopic
    apt-get install -y libass5 libavcodec56 libavformat56 libavutil54 libswscale3
    apt-get install -y libavdevice55 libavfilter5
  elif [ 1504 -ge 1404 ]; then
    # trusty
    apt-get install -y libass4 libavcodec54 libavformat54 libavutil52 libswscale2
    apt-get install -y libavdevice53 libavfilter3
  elif [ 1504 -ge 1110 ]; then
    # oneiric to saucy, wheezy
    apt-get install -y libass4 libavcodec53 libavformat53 libavutil51 libswscale2
    apt-get install -y libavdevice53 libavfilter2
  elif [ 1504 -le 1010 ]; then
    # maverick to natty
    apt-get install -y libass4 libavcodec52 libavformat52 libavutil50 libswscale0
    apt-get install -y libavdevice52 libavfilter1
  #if [ 1504 -le 1004 ]x then
  else
    # lucid
    apt-get install -y libass4 libavcodec52 libavformat52 libavutil49 libswscale0
    apt-get install -y libavdevice52 libavfilter0
  fi

  if [ -e ${ffmpgzip} ]; then
    if [ 1504 -ge 1604 ]; then
      apt-get install -y --no-install-recommends         libopenal1 libsdl1.2debian libshine3 libtwolame0 libzvbi0 libflite1 libgme0 libmodplug1 libssh-gcrypt-4 libsoxr0
      apt-get install -y --no-install-recommends libsnappy1v5 libzmq5
    elif [ 1504 -ge 1510 ]; then
      apt-get install -y --no-install-recommends         libopenal1 libsdl1.2debian libshine3 libtwolame0 libzvbi0 libflite1 libgme0 libmodplug1 libssh-gcrypt-4 libsoxr0
      apt-get install -y --no-install-recommends libsnappy1v5 libzmq3
    elif [ 1504 -ge 1504 ]; then
      apt-get install -y --no-install-recommends         libopenal1 libsdl1.2debian libshine3 libtwolame0 libzvbi0 libflite1 libgme0 libmodplug1 libssh-gcrypt-4 libsoxr0
      apt-get install -y --no-install-recommends libsnappy1 libzmq3
    fi

    mkdir -p ffmpeg
    cd ffmpeg

    unzip ../${ffmpgzip}

    mkdir -p dev
    mv *-dev*.deb dev/ || true
    mkdir -p extra
    mv *-doc*.deb extra/ || true
    mv *-extra*.deb extra/ || true
    mv ffmpeg_*.deb extra/ || true
    mv libav-tools_*.deb extra/ || true

    mkdir -p ../dev
    mv dev/*.deb ../dev/

    dpkg -i *.deb

    #apt-get remove -y libavcodec56 libavdevice55 libavfilter5 libavformat56 libavresample2 libavutil54 libswscale3

    cd /root/source/
  fi

  if [ -e ${gstlazip} ]; then
    unzip ${gstlazip}

    dpkg -i gstreamer1.0-libav_*_armhf.deb
  elif [ 1504 -ge 1304 ]; then
    apt-get install -y gstreamer1.0-libav
  fi

  if [ -e ${alsapzip} ]; then
    unzip ${alsapzip}

    dpkg -i libasound?-plugins_*_armhf.deb
  fi

  if [ -e ${chrmpzip} ]; then
    unzip ${chrmpzip}

    mkdir -p dev
    mv *-dev*.deb dev/ || true

    dpkg -i libchromaprint?_*_armhf.deb
  fi

  apt-get install -y libsdl2-2.0-0

  dpkg -i mpv_*.deb
fi


cd ..

if [ "raspberrypi" != "raspberrypi" -a 1 != 0 ]; then
  if [ 1504 -ge 1404 ]; then
    apt-get install -y mpv
  elif [ 1504 -ge 1110 ]; then
    apt-get install -y mplayer2
  else
    apt-get install -y mplayer
  fi
fi

if [ "Raspbian" = "ZXYDebian" ] ; then
mv /etc/apt/.sources.list.d /etc/apt/sources.list.d

apt-get update
fi

mkdir -p extra-debs
cd extra-debs

if [ 1504 -ge 1304 ]; then
  wget https://yt-dl.org/latest/youtube-dl || cp -p /root/source/youtube-dl .
else
  wget --no-check-certificate https://yt-dl.org/latest/youtube-dl || cp -p /root/source/youtube-dl .
fi

chmod a+x youtube-dl
cp youtube-dl /usr/bin/youtube-dl
mkdir -p /root/youtube-dl

cd ..

OMXPV=0.3.6~git20150505~b1ad23e
KWEBV=1.6.4

if [ armhf = "arm64" ]; then
  KWEBV=1.6.8
  [ 1504 -ge 1504 ] && KWEBV=1.6.9
fi

if [ armhf = "armhf" ]; then
  KWEBV=1.6.8
  [ jessie = jessie ] && KWEBV=1.6.9

  cd extra-debs

  apt-get install -y libasound2 libfreetype6 dbus libsmbclient libssh-4

  wget http://omxplayer.sconde.net/builds/omxplayer_${OMXPV}_armhf.deb
  if [ 1504 -ge 1608 ]; then
    true
  elif [ 1504 -ge 1210 ]; then
    apt-get install -y fonts-freefont-ttf
    dpkg -i omxplayer_${OMXPV}_armhf.deb
  fi

  if [ -e /root/source/kweb-${KWEBV}-armhf.tar.gz ]; then
    mv /root/source/kweb-${KWEBV}-armhf.tar.gz ./kweb-${KWEBV}.tar.gz
  else
    #wget http://steinerdatenbank.de/software/kweb-${KWEBV}-src.tar.gz
    wget http://steinerdatenbank.de/software/kweb-${KWEBV}.tar.gz
  fi

  cd ..
elif [ -e /root/source/kweb-${KWEBV}-armhf.tar.gz ]; then
  mv /root/source/kweb-${KWEBV}-armhf.tar.gz extra-debs/kweb-${KWEBV}.tar.gz
fi

if [ 1504 -ge 1504 -o armhf = amd64 -o armhf = i386 ]; then
  apt-get --no-install-recommends install -y firefox || apt-get --no-install-recommends install -y iceweasel
  apt-get --no-install-recommends install -y firefox-locale-de || apt-get --no-install-recommends install -y iceweasel-l10n-de || true
else
  apt-get --purge remove -y firefox-locale-de || true
fi

if [ "Raspbian" = "Debian" ] ; then
cat <<EOFASLUU | tee -a /etc/apt/sources.list
deb http://mirrordirector.raspbian.org/raspbian/ jessie-backports main
EOFASLUU

apt-get update
fi

chromiumName=chromium-browser
if [ 1504 -ge 1604 -a "raspberrypi" = "amlsx05" ]; then
  apt-get --no-install-recommends install -y chromium-browser chromium-chromedriver
  apt-get --no-install-recommends install -y chromium-browser-l10n || true
elif [ 1504 -ge 1504 -a "raspberrypi" = "amlsx05" -a true = true ]; then
  chromiumName=chromium
  apt-get --no-install-recommends install -y chromium chromedriver || chromiumName=chromium-browser
  if [ "${chromiumName}" = "chromium-browser" ]; then
    apt-get --no-install-recommends install -y chromium-browser chromium-chromedriver
    apt-get --no-install-recommends install -y chromium-browser-l10n || true
  else
    apt-get --no-install-recommends install -y chromium-l10n || true
  fi
  echo 'CHROMIUM_FLAGS=" --use-gl=egl --ignore-gpu-blacklist --disable-accelerated-2d-canvas --num-raster-threads=4 --audio-buffer-size=4096"' | sudo tee /etc/chromium.d/odroid-flags
fi

if [ "Raspbian" = "Debian" ] ; then
sed -i s/'deb .* 'jessie'-backports main'/''/g /etc/apt/sources.list

apt-get update
fi

if [ -e extra-debs/kweb-${KWEBV}.tar.gz -a 1504 -ge 1104 -a 1 != 0 ]; then
  apt-get install -y gdebi-core python-tk

  apt-get --no-install-recommends install -y libwebkitgtk-1.0-0
  apt-get --no-install-recommends install -y libwebkitgtk-3.0-0
  [ "XFCE" != "Matchbox" ] && apt-get install -y uget

  cd extra-debs

  tar -xzf kweb-${KWEBV}.tar.gz
  cd kweb-${KWEBV}
  ./debinstall
  cd -

  #if [ -e /usr/local/bin/ginstall-ytdl ]; then
  #  rmdir /root/youtube-dl
  #  ginstall-ytdl
  #fi

  cp -p /root/ktop /etc/skel/
  cp -p /root/kweb_about_c.html /etc/skel/

  mkdir /usr/share/.applications &&   mv /usr/share/applications/kweb3.desktop /usr/share/.applications/
  bash -e /root/bin/kweb-postinst.sh
  cd ..

  cd source/

  omxpgtgz=omxplayergui-patch.tar.gz
  for f in `ls omxplayergui*.tar.gz`; do
    omxpgtgz=$f
  done
  for f in `ls omxplayergui*-armhf.tar.gz`; do
    omxpgtgz=$f
  done
  for f in `ls omxplayergui*jessie-armhf.tar.gz`; do
    omxpgtgz=$f
  done

  for f in `ls omxplayergui*${KWEBV}*.tar.gz`; do
    omxpgtgz=$f
  done
  for f in `ls omxplayergui*${KWEBV}*-armhf.tar.gz`; do
    omxpgtgz=$f
  done
  for f in `ls omxplayergui*${KWEBV}*jessie-armhf.tar.gz`; do
    omxpgtgz=$f
  done

  if [ -e ${omxpgtgz} ]; then
    echo ${omxpgtgz} for omxplayergui ${KWEBV}
    tar xzvf ${omxpgtgz}

    cp -p getbootcmdline /usr/local/bin/
    cd /
    for p in `ls /root/source/omxplayergui-*.patch`; do
      patch -p0 < $p
    done
    cd /root/
    cd source/

    MPVBIN=`which mpv || true`
    if [ "x${MPVBIN}" != "x" ]; then
        mpv --framedrop=help | grep ' yes' || sed -i s/'--framedrop=yes'/'--framedrop=vo'/g /usr/local/bin/omxplayergui.py
    fi
  fi

  mpvpgtgz=mpvplayergui-patch.tar.gz
  for f in `ls mpvplayergui*.tar.gz`; do
    mpvpgtgz=$f
  done
  for f in `ls mpvplayergui*-armhf.tar.gz`; do
    mpvpgtgz=$f
  done
  for f in `ls mpvplayergui*jessie-armhf.tar.gz`; do
    mpvpgtgz=$f
  done

  for f in `ls mpvplayergui*${KWEBV}*.tar.gz`; do
    mpvpgtgz=$f
  done
  for f in `ls mpvplayergui*${KWEBV}*-armhf.tar.gz`; do
    mpvpgtgz=$f
  done
  for f in `ls mpvplayergui*${KWEBV}*jessie-armhf.tar.gz`; do
    mpvpgtgz=$f
  done

  if [ -e ${mpvpgtgz} ]; then
    echo ${mpvpgtgz} for omxplayergui ${KWEBV}
    tar xzvf ${mpvpgtgz}

    cp -p getbootcmdline /usr/local/bin/
    cd /
    for p in `ls /root/source/mpvplayergui-*.patch`; do
      patch -p0 < $p
    done
    cd /root/
    cd source/

    MPVBIN=`which mpv || true`
    if [ "x${MPVBIN}" != "x" ]; then
        mpv --framedrop=help | grep ' yes' || sed -i s/'--framedrop=yes'/'--framedrop=vo'/g /usr/local/bin/omxplayergui.py
    fi
  fi
else
  [ 1504 -lt 1504 -o armhf != amd64 -o armhf != i386 ] && apt-get --purge remove -y firefox-locale-de || true
  [ 1 != 0 ] && apt-get --no-install-recommends install -y gstreamer1.0-libav || true
  #apt-get --no-install-recommends install -y epiphany-browser
fi

export HOME=$EDIOLDHOME

touch /tmp/`basename $0`.done
echo "OK"
