#!/bin/bash

mkdir -p /etc/tmpfiles.d
echo "#Type Path        Mode UID  GID  Age Argument" > /etc/tmpfiles.d/raspbian.conf
stat -c '%f     d    %n  %a %U %G - -' /var/log/* | grep -E '^4' | cut -d " " -f 2- >> /etc/tmpfiles.d/raspbian.conf

if [ -e /root/source ]; then
  cd /root/source/
  for f in `ls *-nodbg*.zip 2>/dev/null`; do
    fx=${f/-nodbg/}
    [ -e ${fx} ] && rm $fx
  done
  for f in `ls *-egl-nodbg*.zip 2>/dev/null`; do
    fx=${f/-egl-nodbg/}
    [ -e ${fx} ] && rm $fx
  done
  for f in `ls *jessie-*.zip 2>/dev/null`; do
    fy=${f/jessie-/*}
    for fz in `ls ${fy}`; do
      [ ${fz} != ${f} ] && rm $fz
    done
  done
fi

if [ "raspberrypi" = "raspberrypi" ]; then
  if [ -e /root/board-debs ]; then
    cd /root/board-debs/
    rm -f libraspberrypi-doc_*_armhf.deb
    rm -f *.1
  fi
  #apt-get remove --purge -y libraspberrypi-doc
fi

if [ armhf != armhf -o "raspberrypi" = "generic" ]; then
  if [ -e /bootfiles ]; then
    rm -rf /bootfiles/
  fi
fi

apt-get clean

if [ 1 = 0 ]; then
  echo "Firmware cleanup..."
  cd /root/
  mkdir fwextra
  mv /lib/firmware/iwlwifi-* fwextra/
  mv /lib/firmware/ipw2* fwextra/
  mv /lib/firmware/i*-fw-usb-* fwextra/
  mv /lib/firmware/ath* fwextra/
  mkdir fwextra/brcm
  mv /lib/firmware/brcm/brcmfmac43* fwextra/brcm/
  mv /lib/firmware/brcm/bcm43* fwextra/brcm/
  mv /lib/firmware/ti-connectivity fwextra/
  mkdir fwextra/mrvl
  mv /lib/firmware/mrvl/pcie8* fwextra/mrvl/
  mv /lib/firmware/mrvl/sd8* fwextra/mrvl/
  mv /lib/firmware/mrvl/usb8* fwextra/mrvl/
  mv /lib/firmware/rtlwifi fwextra/
  mv /lib/firmware/rtl_bt fwextra/
  rm -rf fwextra/
fi

echo "Locale cleanup..."
rm -f /tmp/extra-locales.txt
touch /tmp/extra-locales.txt
langExtra=

cd /

for hl in `ls usr/share/help/` ; do
  if [ ${hl} != C        -a ${hl} != de -a ${hl:0:3} != de_ -a ${hl:0:3} != de@        -a ${hl} != de_DE        -a ${hl} != en -a ${hl:0:3} != en_ -a ${hl:0:3} != en@ ]; then
    for hlf in `ls -d usr/share/help/${hl}/*` ; do
      hlb=`basename ${hlf}`
      if [ ${hlb} != fdl -a ${hlb} != gpl  -a ${hlb} != lgpl ]; then
        echo "${hlf}" >> /tmp/extra-locales.txt
      fi
    done
  else
    echo "Skipping help ${hl}"
  fi
done

for il in `ls usr/share/i18n/locales/` ; do
  if [ x${il:2:1} = x_ -o x${il:3:1} = x_ ] &&      [ ${il} != de -a ${il:0:3} != de_ -a ${il:0:3} != de@        -a ${il} != de_DE        -a ${il} != en -a ${il:0:3} != en_ -a ${il:0:3} != en@ ]; then
    ilf=usr/share/i18n/locales/${il}
    echo "${ilf}" >> /tmp/extra-locales.txt
  else
    echo "Skipping locale ${il}"
  fi
done

for l in `ls usr/share/locale/` ; do
  if [ -e usr/share/locale/${l}/LC_MESSAGES        -a ${l} != de -a ${l:0:3} != de_ -a ${l:0:3} != de@        -a ${l} != de_DE        -a ${l} != en -a ${l:0:3} != en_ -a ${l:0:3} != en@ ]; then
    langExtra="${langExtra} usr/share/locale/${l}/LC_MESSAGES/*.mo"
    for lf in usr/share/locale/${l}/LC_MESSAGES/*.mo ; do
      lb=`basename ${lf}`
      lb4=${lb:0:4}
      lb6=${lb:0:6}
      if [ ${lb4} != *.mo -a ${lb4} != iso_ -a ${lb4} != lang -a ${lb4} != xdg-            -a ${lb4} != apt. -a ${lb6} != debcon -a ${lb4} != dpkg -a ${lb6} != libapt -a ${lb6} != lightd ]; then
        echo "${lf}" >> /tmp/extra-locales.txt
      fi
    done
    #echo rm -f usr/share/locale/${l}/LC_MESSAGES/*.mo
  else
    echo "Skipping locale ${l}"
  fi
done

for vd in `ls -d usr/share/vim/vim*` ; do
  #echo ${vd}
  if [ -e ${vd}/lang ]; then
    echo ${vd}/lang
    
    for vl in `ls ${vd}/lang/` ; do
      vlm=${vl:5}
      if [ -e ${vd}/lang/${vl}/LC_MESSAGES            -a ${vl} != de -a ${vl:0:3} != de_ -a ${vl:0:3} != de@ -a ${vl:0:3} != de.            -a ${vl} != de_DE            -a ${vl} != en -a ${vl:0:3} != en_ -a ${vl:0:3} != en@ -a ${vl:0:3} != en. ]; then
        langExtra="${langExtra} ${vd}/lang/${vl}/LC_MESSAGES/*.mo"
        for vlf in ${vd}/lang/${vl}/LC_MESSAGES/*.mo ; do
          vlb=`basename ${vlf}`
          vlb4=${vlb:0:4}
          vlb6=${vlb:0:6}
          if [ ${vlb4} != *.mo -a ${vlb4} != iso_ -a ${vlb4} != lang -a ${vlb4} != xdg-                -a ${vlb4} != apt. -a ${vlb6} != debcon -a ${vlb4} != dpkg -a ${vlb6} != libapt -a ${vlb6} != lightd ]; then
            echo "${vlf}" >> /tmp/extra-locales.txt
          fi
        done
        #echo rm -f ${vd}/lang/${vl}/LC_MESSAGES/*.mo
      elif [ ${vl:0:5} = "menu_"            -a x${vlm} != xde -a x${vlm:0:3} != xde_ -a x${vlm:0:3} != xde@ -a x${vlm:0:3} != xde.            -a x${vlm} != xde_DE -a x${vlm:0:5} != xgerma            -a x${vlm} != xen -a x${vlm:0:3} != xen_ -a x${vlm:0:3} != xen@ -a x${vlm:0:3} != xen. -a x${vlm:0:5} != xengli ]; then
            echo "${vd}/lang/${vl}" >> /tmp/extra-locales.txt
      else
        echo "Skipping locale ${vl}"
      fi
    done
  fi
done

#tar cJvf /root/source/extra-locales.tar.xz --files-from /tmp/extra-locales.txt
#rm -f 
cd - > /dev/null

#echo "Done."
touch /tmp/`basename $0`.done
