#!/usr/bin/env python
# -*- coding: utf-8 -*-

# set kwebhelper_settings.py values and create an HTML config page from it
# generate :command pages and more
# part of Minimal Kiosk Browser suite
# Copyright 2013-2015 by Guenter Kreidl
# version 1.6.9

import os,sys,shutil,urllib
global_vars = ['dldir', 'pdfprog', 'pdfoptions', 'pdfpathreplacements',
               'show_download_in_terminal', 'wget_options', 'uget_options', 'check_desktop', 'direct_commands', 'preferred_terminal', 'sudo_requires_password', 'run_as_script', 'config_path',
               'omxoptions', 'omx_livetv_options', 'live_tv', 'mimetypes', 'omxplayer_in_terminal_for_video', 'omxplayer_in_terminal_for_audio', 'audioextensions', 'streammode', 'videoextensions', 'useAudioplayer', 'omxaudiooptions', 'defaultaudiovolume', 'autoplay', 'autofinish', 'fontname', 'fontheight', 'maxlines', 'lwidth',
               'useVideoplayer', 'videoheight', 'screenmode', 'videomode', 'freeze_window', 'get_DAR', 'hide_controls', 'useVLC',
               'preferred_html5_video_format', 'html5_first', 'youtube_dl_options', 'youtube_omxoptions']

methods = {'dldir':{'text': '', 'method': 'str', 'method_data': []},
'pdfprog':{'text': '', 'method': 'str', 'method_data': ['','evince','xpdf','mupdf']},
'pdfoptions':{'text': '', 'method': 'list', 'method_data': []},
'pdfpathreplacements':{'text': '', 'method': 'dict', 'method_data': []},
'show_download_in_terminal':{'text': '', 'method': 'bool', 'method_data': []},
'wget_options':{'text': '', 'method': 'list', 'method_data': []},
'uget_options':{'text': '', 'method': 'list', 'method_data': []},
'check_desktop':{'text': '', 'method': 'bool', 'method_data': []},
'direct_commands':{'text': '', 'method': 'list', 'method_data': []},
'preferred_terminal':{'text': '', 'method': 'str', 'method_data': []},
'sudo_requires_password':{'text': '', 'method': 'bool', 'method_data': []},
'run_as_script':{'text': '', 'method': 'bool', 'method_data': []},
'config_path':{'text': '', 'method': 'str', 'method_data': []},
'omxoptions':{'text': '', 'method': 'list', 'method_data': []},
'omx_livetv_options':{'text': '', 'method': 'list', 'method_data': []},
'live_tv':{'text': '', 'method': 'list', 'method_data': []},
'mimetypes':{'text': '', 'method': 'list', 'method_data': []},
'omxplayer_in_terminal_for_video':{'text': '', 'method': 'bool', 'method_data': []},
'omxplayer_in_terminal_for_audio':{'text': '', 'method': 'bool', 'method_data': []},
'audioextensions':{'text': '', 'method': 'list', 'method_data': []},
'streammode':{'text': '', 'method': 'str', 'method_data': ['audio','video']},
'videoextensions':{'text': '', 'method': 'list', 'method_data': []},
'useAudioplayer':{'text': '', 'method': 'bool', 'method_data': []},
'omxaudiooptions':{'text': '', 'method': 'list', 'method_data': []},
'defaultaudiovolume':{'text': '', 'method': 'int', 'method_data': range(-20,5)},
'autoplay':{'text': '', 'method': 'bool', 'method_data': []},
'autofinish':{'text': '', 'method': 'bool', 'method_data': []},
'fontname':{'text': '', 'method': 'str', 'method_data': []},
'fontheight':{'text': '', 'method': 'int', 'method_data': []},
'maxlines':{'text': '', 'method': 'int', 'method_data': range(5,26)},
'lwidth':{'text': '', 'method': 'int', 'method_data': range(40,81)},
'useVideoplayer':{'text': '', 'method': 'bool', 'method_data': []},
'videoheight':{'text': '', 'method': 'int', 'method_data': []},
'screenmode':{'text': '', 'method': 'str', 'method_data': ['min','max','full']},
'videomode':{'text': '', 'method': 'str', 'method_data': []},
'freeze_window':{'text': '', 'method': 'bool', 'method_data': []},
'get_DAR':{'text': '', 'method': 'bool', 'method_data': []},
'hide_controls':{'text': '', 'method': 'bool', 'method_data': []},
'useVLC':{'text': '', 'method': 'bool', 'method_data': []},
'preferred_html5_video_format':{'text': '', 'method': 'str', 'method_data': []},
'html5_first':{'text': '', 'method': 'bool', 'method_data': []},
'youtube_dl_options':{'text': '', 'method': 'list', 'method_data': []},
'youtube_omxoptions':{'text': '', 'method': 'list', 'method_data': []}}

header = u'''<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html><head>
<meta content="text/html; charset=UTF-8" http-equiv="content-type">
<title>kweb :$title$</title>
<meta http-equiv="cache-control" content="max-age=0" />
<meta http-equiv="cache-control" content="no-cache" />
<meta http-equiv="expires" content="0" />
<meta http-equiv="expires" content="Tue, 01 Jan 1980 1:00:00 GMT" />
<meta http-equiv="pragma" content="no-cache" />
<link rel="stylesheet" type="text/css" href="file:///usr/local/share/kweb/about.css">
</head><body>
'''
header2=u'''<table widht="100%"><tr><td>
<h2>kwebhelper and omxplayerGUI settings</h2></td><td>
<form accept-charset="utf-8" enctype="application/x-www-form-urlencoded" method="get" action="file:///homepage.html" name="gksettings">
<input name="cmd" value="formdata" type="hidden">
<input name="gsudo" value="gksudo" type="hidden">
<input name="quotedset" value="kweb -ISAHMU0+-zbhrqfpok file:///usr/local/share/kweb/kweb_about_s.html" type="hidden">
<input value="Edit as root" type="submit"></form></td></tr></table>
<hr>
<b>Available Presets: </b> $presetlinks$
<hr>
Your current settings are shown below and you can modify every single one of them.<br>
All changes take effect immediately. Check the manual for a detailed explanation of all options.<br><br>
'''

formheader = u'''
<form accept-charset="utf-8" enctype="application/x-www-form-urlencoded" method="get" action="file:///homepage.html" name="$name$form">
<input name="cmd" value="formdata" type="hidden">
<input name="sudo" value="sudo" type="hidden">
<input name="set" value="kwebhelper_set.py" type="hidden">
<input name="name" value="$name$" type="hidden">
'''

editorfooter = u'''<hr>
<b>You can create your own editable :command pages</b><br>
<form accept-charset="utf-8" enctype="application/x-www-form-urlencoded" method="get" action="file:///homepage.html" name="create">
<input name="cmd" value="formdata" type="hidden">
<input name="sudo" value="sudo" type="hidden">
<input name="set" value="kwebhelper_set.py" type="hidden">
<input name="proc" value="createabout" type="hidden">
<input value="Create Command" type="submit"> Name: <input name="quoteds" type="text" size="10" value="">
</form>
Reload this page after creating or deleting a :command page.
</body></html>
'''

presetform = u'''<big><b>Save and Load Presets</b></big><br>
You may save the currents settings as a named preset and load them again later on.<br>
After loading a preset, you should reload this page.<br>
<table><tr><td>
<form accept-charset="utf-8" enctype="application/x-www-form-urlencoded" method="get" action="file:///homepage.html" name="presetform">
<input name="cmd" value="formdata" type="hidden">
<input name="sudo" value="sudo" type="hidden">
<input name="set1" value="kwebhelper_set.py" type="hidden">
<input name="proc" value="savepreset" type="hidden">
<input value="Save Preset" type="submit"> Name: <input name="quoteds" type="text" size="20" value="">
</form>
<br>
<form accept-charset="utf-8" enctype="application/x-www-form-urlencoded" method="get" action="file:///homepage.html" name="presetform">
<input name="cmd" value="formdata" type="hidden">
<input name="sudo" value="sudo" type="hidden">
<input name="set2" value="kwebhelper_set.py" type="hidden">
<input name="proc" value="deletepreset" type="hidden">
<input value="Delete Preset" type="submit"> Name: <input name="quotedd" type="text" size="20" value="">
</form></td><td><b>Load Preset:</b> $presetlinks$</td></tr></table><hr>'''

presetbutton=u'''
<a href="file:///homepage.html?cmd=sudo%20kwebhelper_set.py%20loadpreset%20$name$"><button>$name$</button></a>
'''

direct_edit = u'''<hr>
You can also edit kwebhelper_settings.py directly.<br>
Edit with either: <a href="file:///homepage.html?cmd=gksudo%20leafpad%20/usr/local/bin/kwebhelper_settings.py"><button>Leafpad</button></a>,
 <a href="file:///homepage.html?cmd=gksudo%20idle%20/usr/local/bin/kwebhelper_settings.py"><button>Idle</button></a> or 
 <a href="file:///homepage.html?cmd=gksudo%20gedit%20/usr/local/bin/kwebhelper_settings.py"><button>Gedit</button></a>
and <a href="file:///homepage.html?cmd=sudo%20kwebhelper_set.py"><button>Refresh Page</button></a> afterwards.
'''

predefined_names = ['c','s','e','k','o','p','m']
predefined_editables = ['a','b']

editable_defaults = {'b':u'''#!mode=link
#!spacer= &nbsp;&nbsp; 
#!target=top
#<h2>Bookmarks</h2>
Raspberry Pi Forum=http://www.raspberrypi.org/forum
Omxplayer Download=http://omxplayer.sconde.net/
Youtube=http://www.youtube.com/
''',
'a':u'''#!mode=button
#!spacer= &nbsp;&nbsp; 
#!target=top
#<h2>Applications and Commands</h2>
#<b>Basic Applications</b><br>
Terminal=lxterminal
Editor (leafpad)=leafpad
File Manager=pcmanfm
OmxplayerGUI=omxplayergui.py
Synaptic=gksudo synaptic
Taskmanager=lxtask
Python Editor=idle
Appearance=lxappearance
OpenBox Configuration=obconf
#<br><b>Useful Commands</b><br>
Top=top
Reboot=sudo reboot
Shutdown=sudo shutdown -h now
Update=sudo apt-get update
Upgrade=sudo apt-get upgrade
Rpi-Update=sudo rpi-update
#<br><b>Browser Commands</b><br>
Toggle Fullscreen=?f
Show/Hide Toolbar=?k
English Spell Checking (UK)=#!en_UK
Delete Cookies=rm ~/.web_cookie_jar
Quit Browser=?q
#<br><b>User Agents</b><br>
Default=#$
Empty (-)=#$-
Kweb (to be used in kweb3)=#$Mozilla/5.0 (X11; Linux armv6l) AppleWebKit/535.22+ (KHTML, like Gecko) Chromium/17.0.963.56 Chrome/17.0.963.56 Safari/535.22+
Firefox Mobile=#$Mozilla/5.0 (Android; Tablet; rv:34.0) Gecko/34.0 Firefox/34.0
Firefox Desktop=#$Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:35.0) Gecko/20100101 Firefox/35.0
Chrome Desktop=#$Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/40.0.2214.95 Safari/537.36
'''}
aboutheader = u'''#!mode=mixed
#!spacer=
#!target=top
#<h2>Untitled</h2>
'''
about_edit_button = u'<a href="file:///homepage.html?cmd=gksudo%20leafpad%20/usr/local/share/kweb/kweb_about_$name$.txt"><button>Edit</button></a>'
about_refresh_button = u'<a href="file:///homepage.html?cmd=sudo%20kwebhelper_set.py%20refreshabout%20$name$"><button>Generate Page</button></a>'
about_delete_button = u'<a href="file:///homepage.html?cmd=sudo%20kwebhelper_set.py%20deleteabout%20$name$"><button>Delete</button></a>'
about_html_footer = u'<hr>' + about_edit_button + ' &nbsp;&nbsp; ' + about_refresh_button + '</body></html>'

def create_form_body(name,value):
    output = u''
    output += '<b>'+name+':</b> '
    method = methods[name]['method']
    if methods[name]['text']:
        output += methods[name]['text'] + '<br>'
    if method == 'int':
        elem = '<input name="var$name$" type="text" size="4" value="$value$">'
        output += elem.replace('$name$',name).replace('$value$',value)
    elif method == 'str':
        evalue = value.strip('\'')
        if evalue:
            size = len(evalue)+4
        else:
            size = 25
        elem = '<input name="quotedvar$name$" type="text" size="$size$" value="$value$">'
        output += elem.replace('$name$',name).replace('$value$',evalue).replace('$size$',str(size))
    elif method == 'bool':
        elem = '<input type="radio" name="var$name$" value="True">True'
        elem += ' <input type="radio" name="var$name$" value="False">False'
        if value == 'True':
            elem = elem.replace('"True"','"True" checked')
        else:
            elem = elem.replace('"False"','"False" checked')            
        output += elem.replace('$name$',name)
    elif method == 'list':
        output += 'Enter one element per line!<br>'
        evalue = eval(value)
        if len(evalue) == 0:
            rows = 3
            cols = 25
        else:
            rows = max(min(8,len(evalue)),5)
            cols = 0
            for e in evalue:
                if len(e) > cols:
                    cols = len(e)
            cols = cols+4
        elem = '<textarea name="quoted$name$" cols="$cols$" rows="$rows$">'
        elem = elem.replace('$name$',name)
        elem = elem.replace('$rows$',str(rows))
        elem = elem.replace('$cols$',str(cols))
        txt  = ''
        if evalue:
            txt = '\n'.join(evalue)
        output += elem+txt+'</textarea>'
    elif method == 'dict':
        output += 'Enter one element per line in the form value1=value2<br>'
        evalued = eval(value)
        evalue = []
        for k,v in evalued.iteritems():
            evalue.append(k+'='+v)
        if len(evalue) == 0:
            rows = 3
            cols = 40
        else:
            rows = max(min(8,len(evalue)),5)
            cols = 0
            for e in evalue:
                if len(e) > cols:
                    cols = len(e)
            cols = cols+4
        elem = '<textarea name="quoted$name$" cols="$cols$" rows="$row$">'
        elem = elem.replace('$name$',name)
        elem = elem.replace('$rows$',str(rows))
        elem = elem.replace('$cols$',str(cols))
        txt  = ''
        if evalue:
            txt = '\n'.join(evalue)
        output += elem+txt+'</textarea>'
    return output

def set_value(name,value):
    method = methods[name]['method']
    save_list = False
    for lnr in range(0,len(settingslist)):
        if settingslist[lnr].startswith(name+' ') or settingslist[lnr].startswith(name+'='):
            break
    if method == 'int':
        if value:
            try:
                val = int(value)
            except:
                val = ''
        if val and methods[name]['method_data']:
            if val not in methods[name]['method_data']:
                val = ''
        if val:
            settingslist[lnr] = name + ' = ' + str(val)
            save_list = True            
    elif method == 'str':
        save_list = True
        if methods[name]['method_data']:
            if value not in methods[name]['method_data']:
                save_list = False
        if value:
            val = '\''+value+'\''
        else:
            val = "''"
        if save_list:
            settingslist[lnr] = name + ' = ' + str(val)
    elif method == 'bool':
        if value and value in ['False','True']:
            settingslist[lnr] = name + ' = ' + value
            save_list = True
    elif method == 'list':
        if value:
            val = value.replace('%0A','').split('%0D')
        else:
            val = []
        val2 = []
        for v in val:
            nv = v.strip()
            if ' ' in nv and "'" not in nv and '"' not in nv:
                val2 = val2 + nv.split(' ')
            else:
                val2.append(nv)            
        save_list = True
        settingslist[lnr] = name + ' = ' + str(val2)        
    elif method == 'dict':
        if value:
            val = value.replace('%0A','').split('%0D')
            vad = {}
            for v in val:
                if '=' in v:
                    vd = v.strip().split('=')
                    vad[vd[0]] = vd[1]
        else:
            vad = {}
        save_list = True
        settingslist[lnr] = name + ' = ' + str(vad)
    if save_list:
        f = file(settingspath,'wb')
        f.write(('\n'.join(settingslist)).encode('utf-8'))
        f.close()
        os.chmod(settingspath,0755)
    return save_list

def create_presetlinks():
    res = ''
    presetfiles = os.listdir(spagepath)
    presetfiles.sort()
    for prf in presetfiles:
        name = prf.replace('.preset','')
        if prf.endswith('.preset'):
            res += presetbutton.replace('$name$',name)
    return res

def create_settings_page(settingslist):
    presetlinks = create_presetlinks()
    page = header.replace('$title$','settings')
    page += header2.replace('$presetlinks$',presetlinks)
    for line in settingslist[9:-1]:
        if line.startswith('#'):
            if line.startswith('# '):
                page += line.replace('#','').strip()+'<br>\n'
        elif '=' in line:
            ll = line.split('=')
            name = ll[0].strip()
            value = ll[1].strip()
            page += formheader.replace('$name$',name)
            page += create_form_body(name,value)
            page += ' <input value="save" type="submit">' 
            page += '</form><hr>'
    page += presetform.replace('$presetlinks$',presetlinks)
    page += direct_edit
    page += '</body></html>'
    f = file(about_s_path,'wb')
    f.write(page.encode('utf-8'))
    f.close()
    os.chmod(about_s_path,0644)

def preset(cmd, name):
    global settingslist
    result = False
    presetpath = spagepath+'/'+name+'.preset'
    if cmd == 'savepreset':
        shutil.copy(settingspath,presetpath)
        result = True
    elif cmd == 'loadpreset':
        if os.path.exists(presetpath):
            shutil.copy(presetpath,settingspath)
            result = True
            settingslist = load_settings()
    elif cmd == 'deletepreset':
        if os.patch.exists(presetpath):
            os.remove(resetpath)
    return result

def get_command_names():
    fixed = [] + predefined_names
    editable = [] + predefined_editables
    basedir = '/usr/local/share/kweb'
    kwebcontent = os.listdir(basedir)
    for cont in kwebcontent:
        if cont.startswith('kweb_about_') and '.' in cont:
            name = cont.split('.')[0].replace('kweb_about_','')
            if cont.endswith('.txt'):
                if name not in editable:
                    editable.append(name)
            elif cont.endswith('.html'):
                if os.path.exists(basedir+'/'+cont.replace('.html','.txt')):
                    if name not in editable:
                        editable.append(name)
                else:
                    if name not in fixed:
                        fixed.append(name)
    return (fixed,editable)

def about_commands(cmd,name):
    sname = name.strip(' :')
    sname = sname.replace(' ','_')
    rlist = []
    refresh_editor = False
    fixed, editable = get_command_names()
    if cmd == 'deleteabout':
        if sname in editable and sname not in predefined_editables:
            bp = '/usr/local/share/kweb/kweb_about_'+sname
            if os.path.exists(bp+'.txt'):
                os.remove(bp+'.txt')
            if os.path.exists(bp+'.html'):
                os.remove(bp+'.html')
            refresh_editor = True
    elif cmd == 'refreshabout':
        if sname in editable:
            rlist.append(sname)
    elif cmd == 'createabout':
        if sname not in editable and sname not in fixed:
            bp = '/usr/local/share/kweb/kweb_about_'+sname+'.txt'
            if not os.path.exists(bp):
                f = file(bp,'wb')
                f.write(aboutheader.encode('utf-8'))
                f.close()
                os.chmod(bp,0644)
                refresh_editor = True
                rlist.append(name)
    return refresh_editor,rlist

def create_about_pages(ablist):
    for name in ablist:
        bp = '/usr/local/share/kweb/kweb_about_'+name+'.txt'
        linkform = u'<a href="$link$" $target$">$name$</a>'
        cmdform = u'<a href="file:///homepage.html?cmd=$cmd$">$name$</a>'
        if not os.path.exists(bp) and name in predefined_editables:
            f = file(bp,'wb')
            f.write(editable_defaults[name].encode('utf-8'))
            f.close()
            os.chmod(bp,0644)
        if os.path.exists(bp):
            f = file(bp,'rb')
            template = f.read().decode('utf-8')
            f.close()
            tl = template.split('\n')
            mode = 'mixed'
            spacer = ' '
            target = 'target="_top"'
            page = header.replace('$title$',':'+name)
            for line in tl:
                if line.startswith('#!spacer='):
                    newspacer = line.replace('#!spacer=','')
                    if newspacer:
                        spacer = newspacer
                    else:
                        spacer = ' '
                elif line.startswith('#!mode='):
                    newmode = line.replace('#!mode=','').strip()
                    if newmode in ['mixed','link','button']:
                        mode = newmode
                elif line.startswith('#!target='):
                    newtarget = line.replace('#!target=','').strip()
                    if not newtarget or newtarget == 'this':
                        target = ''
                    elif newtarget == 'top':
                        target = 'target="_top"'
                    elif newtarget == 'parent':
                        target = 'target="_parent"'
                    elif newtarget == 'blank':
                        target = 'target="_blank"'
                elif line.startswith('#'):
                    page += line.replace('#','').strip() + '\n'
                elif '=' in line:
                    ltl = line.split('=',1)
                    cmdname = ltl[0].strip().replace(' ','&nbsp;')
                    link = ltl[1].strip()
                    if link and cmdname:
                        if link.startswith('http://') or link.startswith('https://') or link.startswith('file://'):
                            if mode == 'button':
                                cmdname = '<button>'+cmdname+'</button>'
                            page += linkform.replace('$link$',link).replace('$name$',cmdname).replace('$target$',target) + spacer
                        elif link.startswith('?') and len(link) == 2:
                            if mode in ['button','mixed']:
                                cmdname = '<button>'+cmdname+'</button>'
                            page += linkform.replace('$link$','file:///homepage.html?kbd='+link[1]).replace('$name$',cmdname).replace('$target$',target) + spacer
                        elif link.startswith('#'):
                            cmd = link[1:].replace(' ','%20')
                            if mode in ['button','mixed']:
                                cmdname = '<button>'+cmdname+'</button>'
                            page += linkform.replace('$link$','file:///homepage.html?txt='+cmd).replace('$name$',cmdname).replace('$target$',target) + spacer
                        else:
                            cmd = urllib.quote(link).replace(' ','%20')
                            if mode in ['button','mixed']:
                                cmdname = '<button>'+cmdname+'</button>'
                            page += cmdform.replace('$cmd$',cmd).replace('$name$',cmdname) + spacer
            page += about_html_footer.replace('$name$',name)
            f = file(bp.replace('.txt','.html'),'wb')
            f.write(page.encode('utf-8'))
            f.close()
            os.chmod(bp.replace('.txt','.html'),0644)

def create_editor_page():
    epath = '/usr/local/share/kweb/kweb_about_e.html'
    linkform = u'<a href="file:///usr/local/share/kweb/kweb_about_$name$.html" target="_top">:$name$</a>'
    static,editable = get_command_names()
    spacer = u' &nbsp;&nbsp; '
    page = header.replace('$title$',':e')
    page += u'<h2>:command Editor</h2>'
    page += u'<br><b>Available Static :Command Pages</b><br>'+spacer
    for name in static:
        if name != 'c':
            page += linkform.replace('$name$',name)+spacer
        else:
            page += u'<a href="file://~/kweb_about_c.html" target="_top">:c</a>' +spacer
    page += u'<br><br><b>Available User Editable :Command Pages</b><br>'
    for name in editable:
        page += spacer+linkform.replace('$name$',name)+spacer
        page += about_edit_button.replace('$name$',name)+spacer
        page += about_refresh_button.replace('$name$',name)+spacer
        if name not in predefined_editables:
            page += about_delete_button.replace('$name$',name)
        page += '<br>'
    page += editorfooter
    f = file(epath,'wb')
    f.write(page.encode('utf-8'))
    f.close()
    os.chmod(epath,0644)

def load_settings():
    if os.path.exists(settingspath):
        f = file(settingspath,'rb')
        settings = f.read().decode('utf-8')
        f.close()
        return settings.split('\n')
    else:
        return []

    

if __name__ == '__main__':
    settingspath = '/usr/local/bin/kwebhelper_settings.py'
    settingslist = load_settings()
    spagepath = '/usr/local/share/kweb'
    if not os.path.exists(spagepath):
        os.mkdir(spagepath)
    about_s_path = spagepath+'/kweb_about_s.html'
    createsettingspage = False
    aboutlist = []
    editor_refresh = False
    args = sys.argv
    if len(args) == 3 and args[1] in ['savepreset','loadpreset','deletepreset']:
        createsettingspage = preset(args[1],args[2])
    elif len(args) == 3 and args[1] in ['createabout','deleteabout','refreshabout']:
        editor_refresh,aboutlist = about_commands(args[1],args[2])
    elif len(args) == 2 and args[1] == 'refresheditor':
        editor_refresh = True
    elif len(args) == 2 and args[1] in global_vars:
        createsettingspage = set_value(args[1],'')
    elif len(args) == 3 and args[1] in global_vars:
        createsettingspage = set_value(args[1],args[2])
    else:
        createsettingspage = True
        dummy,aboutlist = get_command_names()
        editor_refresh = True
    if settingslist and createsettingspage:
        create_settings_page(settingslist)
    if aboutlist:
        create_about_pages(aboutlist)
    if editor_refresh:
        create_editor_page()
