#! /bin/sh

set -e

version="$1"

if [ -n "$DEB_MAINT_PARAMS" ]; then
    eval set -- "$DEB_MAINT_PARAMS"
    if [ -z "$1" ] || [ "$1" != "configure" ]; then
        exit 0;
    fi
fi

# passing the kernel version is required
[ -z "$version" ] && exit 1

mkimage -A arm64 -O linux -T ramdisk -C none -a 0 -e 0 -n uInitrd -d /boot/initrd.img-$version /boot/uInitrd-$version

# checking if /media boot exists if so, then copy uInitrd there (should be Ubuntu)
if [ ! -d /media/boot ]; then
	#cp /boot/initrd.img-$version /boot/initrd.img
	cp /boot/uInitrd-$version /boot/uInitrd
else
	#cp /boot/initrd.img-$version /media/boot/initrd.img
	cp /boot/uInitrd-$version /media/boot/uInitrd
fi
