#! /bin/sh

set -e

version="$1"
vmlinuz_location="$2"

if [ -n "$DEB_MAINT_PARAMS" ]; then
    eval set -- "$DEB_MAINT_PARAMS"
    if [ -z "$1" ] || [ "$1" != "configure" ]; then
        exit 0;
    fi
fi

# passing the kernel version is required
[ -z "$version" ] && exit 1


if [  -n "$vmlinuz_location" ]; then
    # Where is the image located? We'll place the zImage there.
    boot=$(dirname "$vmlinuz_location")
    # Copy the image to zImage
	if [ ! -d /media/boot ]; then
		cp $vmlinuz_location /boot/Image
	else
		cp $vmlinuz_location /media/boot/Image
	fi
fi

if [ `cat /proc/cpuinfo | grep -c ODROID-N2` -ge 1 ]; then
	if [ -f /media/boot/Image ]; then
		[ -f /media/boot/Image.gz ] && mv /media/boot/Image.gz /media/boot/Image.gz.bak
		gzip -9 /media/boot/Image
	else
		[ -f /boot/Image.gz ] && mv /boot/Image.gz /boot/Image.gz.bak
		gzip -9 /boot/Image
	fi
fi
