/* SPDX-License-Identifier: GPL-2.0 */
#ifndef _DT_BINDINGS_CLOCK_ROCKCHIP_RK3368_H
#define _DT_BINDINGS_CLOCK_ROCKCHIP_RK3368_H

#include "rockchip.h"

/* reset id */
#define RK3368_SRST_CORE_B_0_SC         0
#define RK3368_SRST_CORE_B_1            1
#define RK3368_SRST_CORE_B_2            2
#define RK3368_SRST_CORE_B_3            3
#define RK3368_SRST_CORE_B_PO0_SC       4
#define RK3368_SRST_CORE_B_PO1          5
#define RK3368_SRST_CORE_B_PO2          6
#define RK3368_SRST_CORE_B_PO3          7
#define RK3368_SRST_L2_B_SC             8
#define RK3368_SRST_ADB_B_SC            9
#define RK3368_SRST_PD_CORE_B_NIU       10
#define RK3368_SRST_STRC_SYS_A_SC       11
#define RK3368_SRST_0RES12              12
#define RK3368_SRST_0RES13              13
#define RK3368_SRST_SOCDBG_B            14
#define RK3368_SRST_CORE_B_DBG          15

#define RK3368_SRST_1RES0               16
#define RK3368_SRST_1RES1               17
#define RK3368_SRST_DMA1                18
#define RK3368_SRST_INTMEM              19
#define RK3368_SRST_ROM                 20
#define RK3368_SRST_SPDIF_8CH           21
#define RK3368_SRST_1RES6               22
#define RK3368_SRST_I2S                 23
#define RK3368_SRST_MAILBOX             24
#define RK3368_SRST_I2S_2CH             25
#define RK3368_SRST_EFUSE_256_P         26
#define RK3368_SRST_1RES11              27
#define RK3368_SRST_MCU_SYS             28
#define RK3368_SRST_MCU_PO              29
#define RK3368_SRST_MCU_NOC_H           30
#define RK3368_SRST_EFUSE_P             31

#define RK3368_SRST_GPIO0               32
#define RK3368_SRST_GPIO1               33
#define RK3368_SRST_GPIO2               34
#define RK3368_SRST_GPIO3               35
#define RK3368_SRST_GPIO4               36
#define RK3368_SRST_2RES5               37
#define RK3368_SRST_2RES6               38
#define RK3368_SRST_2RES7               39
#define RK3368_SRST_2RES8               40
#define RK3368_SRST_PMUGRF_P            41
#define RK3368_SRST_I2C0                42
#define RK3368_SRST_I2C1                43
#define RK3368_SRST_I2C2                44
#define RK3368_SRST_I2C3                45
#define RK3368_SRST_I2C4                46
#define RK3368_SRST_I2C5                47

#define RK3368_SRST_DW_PWM              48
#define RK3368_SRST_MMC_PERI            49
#define RK3368_SRST_PERIPH_MMU          50
#define RK3368_SRST_3RES3               51
#define RK3368_SRST_3RES4               52
#define RK3368_SRST_3RES5               53
#define RK3368_SRST_3RES6               54
#define RK3368_SRST_GRF                 55
#define RK3368_SRST_PMU                 56
#define RK3368_SRST_PERIPH_SYS_A        57
#define RK3368_SRST_PERIPH_SYS_H        58
#define RK3368_SRST_PERIPH_SYS_P        59
#define RK3368_SRST_PERIPH_NIU          60
#define RK3368_SRST_PD_PERI_AHB_ARBITOR 61
#define RK3368_SRST_EMEM_PERI           62
#define RK3368_SRST_USB_PERI            63

#define RK3368_SRST_DMA2                64
#define RK3368_SRST_4RES1               65
#define RK3368_SRST_MAC                 66
#define RK3368_SRST_GPS                 67
#define RK3368_SRST_4RES4               68
#define RK3368_SRST_RK_PWM              69
#define RK3368_SRST_4RES6               70
#define RK3368_SRST_4RES7               71
#define RK3368_SRST_HOST0_H             72
#define RK3368_SRST_EHCI1                73
#define RK3368_SRST_EHCI1_AUX            74
#define RK3368_SRST_EHCI1PHY             75
#define RK3368_SRST_HSADC_H             76
#define RK3368_SRST_NANDC0              77
#define RK3368_SRST_4RES14              78
#define RK3368_SRST_SFC                 79

#define RK3368_SRST_5RES0               80
#define RK3368_SRST_5RES1               81
#define RK3368_SRST_5RES2               82
#define RK3368_SRST_SPI0                83
#define RK3368_SRST_SPI1                84
#define RK3368_SRST_SPI2                85
#define RK3368_SRST_5RES6               86
#define RK3368_SRST_SARADC              87
#define RK3368_SRST_PD_ALIVE_NIU_P      88
#define RK3368_SRST_PD_PMU_INTMEM_P     89
#define RK3368_SRST_PD_PMU_NIU_P        90
#define RK3368_SRST_SGRF_P              91
#define RK3368_SRST_5RES12              92
#define RK3368_SRST_5RES13              93
#define RK3368_SRST_5RES14              94
#define RK3368_SRST_5RES15              95

#define RK3368_SRST_VIO_ARBI_H          96
#define RK3368_SRST_RGA_NIU_A           97
#define RK3368_SRST_VIO0_NIU_A          98
#define RK3368_SRST_VIO0_BUS_H          99
#define RK3368_SRST_LCDC0_A             100
#define RK3368_SRST_LCDC0_H             101
#define RK3368_SRST_LCDC0_D             102
#define RK3368_SRST_6RES7               103
#define RK3368_SRST_VIP                 104
#define RK3368_SRST_RGA_CORE            105
#define RK3368_SRST_IEP_A               106
#define RK3368_SRST_IEP_H               107
#define RK3368_SRST_RGA_A               108
#define RK3368_SRST_RGA_H               109
#define RK3368_SRST_ISP                 110
#define RK3368_SRST_EDP_24M             111

#define RK3368_SRST_VIDEO_A             112
#define RK3368_SRST_VIDEO_H             113
#define RK3368_SRST_MIPIDPHYTX_P        114
#define RK3368_SRST_MIPIDSI0_P          115
#define RK3368_SRST_MIPIDPHYRX_P        116
#define RK3368_SRST_MIPICSI_P           117
#define RK3368_SRST_7RES6               118
#define RK3368_SRST_7RES7               119
#define RK3368_SRST_GPU_CORE            120
#define RK3368_SRST_HDMI                121
#define RK3368_SRST_EDP_P               122
#define RK3368_SRST_PMU_PVTM            123
#define RK3368_SRST_CORE_PVTM           124
#define RK3368_SRST_GPU_PVTM            125
#define RK3368_SRST_GPU_SYS_A           126
#define RK3368_SRST_GPU_MEM_NIU_A       127

#define RK3368_SRST_MMC0                128
#define RK3368_SRST_SDIO0               129
#define RK3368_SRST_8RES2               130
#define RK3368_SRST_EMMC                131
#define RK3368_SRST_USBOTG0_H           132
#define RK3368_SRST_USBOTGPHY0          133
#define RK3368_SRST_USBOTGC0            134
#define RK3368_SRST_USBHOSTC0_H         135
#define RK3368_SRST_USBOTGPHY1          136
#define RK3368_SRST_USBHOSTC0           137
#define RK3368_SRST_USBPHY0_UTMI        138
#define RK3368_SRST_USBPHY1_UTMI        139
#define RK3368_SRST_8RES12              140
#define RK3368_SRST_USB_ADP             141
#define RK3368_SRST_8RES14              142
#define RK3368_SRST_8RES15              143

#define RK3368_SRST_DBG                 144
#define RK3368_SRST_PD_CORE_AHB_NOC     145
#define RK3368_SRST_PD_CORE_APB_NOC     146
#define RK3368_SRST_9RES3               147
#define RK3368_SRST_GIC                 148
#define RK3368_SRST_LCDCPWM0            149
#define RK3368_SRST_9RES6               150
#define RK3368_SRST_9RES7               151
#define RK3368_SRST_9RES8               152
#define RK3368_SRST_RGA_H2P_BRG         153
#define RK3368_SRST_VIDEO               154
#define RK3368_SRST_9RES11              155
#define RK3368_SRST_9RES12              156
#define RK3368_SRST_GPU_CFG_NIU_A       157
#define RK3368_SRST_9RES14              158
#define RK3368_SRST_TSADC_P             159

#define RK3368_SRST_DDRPHY0             160
#define RK3368_SRST_DDRPHY0_P           161
#define RK3368_SRST_DDRCTRL0            162
#define RK3368_SRST_DDRCTRL0_P          163
#define RK3368_SRST_10RES4              164
#define RK3368_SRST_VIDEO_NIU_A         165
#define RK3368_SRST_10RES6              166
#define RK3368_SRST_VIDEO_NIU_H         167
#define RK3368_SRST_10RES8              168
#define RK3368_SRST_10RES9              169
#define RK3368_SRST_DDRMSCH0            170
#define RK3368_SRST_10RES11             171
#define RK3368_SRST_10RES12             172
#define RK3368_SRST_SYS_BUS             173
#define RK3368_SRST_CRYPTO              174
#define RK3368_SRST_10RES15             175

#define RK3368_SRST_11RES0              176
#define RK3368_SRST_11RES1              177
#define RK3368_SRST_11RES2              178
#define RK3368_SRST_UART0               179
#define RK3368_SRST_UART1               180
#define RK3368_SRST_UART2               181
#define RK3368_SRST_UART3               182
#define RK3368_SRST_UART4               183
#define RK3368_SRST_11RES8              184
#define RK3368_SRST_11RES9              185
#define RK3368_SRST_SIMC_P              186
#define RK3368_SRST_11RES11             187
#define RK3368_SRST_TSP_H               188
#define RK3368_SRST_TSP_CLKIN0          189
#define RK3368_SRST_11RES14             190
#define RK3368_SRST_11RES15             191

#define RK3368_SRST_CORE_L_0_SC         192
#define RK3368_SRST_CORE_L_1            193
#define RK3368_SRST_CORE_L_2            194
#define RK3368_SRST_CORE_L_3            195
#define RK3368_SRST_CORE_L_PO0_SC       196
#define RK3368_SRST_CORE_L_PO1          197
#define RK3368_SRST_CORE_L_PO2          198
#define RK3368_SRST_CORE_L_PO3          199
#define RK3368_SRST_L2_L_SC             200
#define RK3368_SRST_ADB_L_SC            201
#define RK3368_SRST_PD_CORE_L_NIU_A_SC  202
#define RK3368_SRST_CCI400_SYS_SC       203
#define RK3368_SRST_CCI400_DDR_SC       204
#define RK3368_SRST_CCI400_SC           205
#define RK3368_SRST_SOCDBG_L            206
#define RK3368_SRST_CORE_L_DBG          207

#define RK3368_SRST_CORE_B_0            208
#define RK3368_SRST_CORE_B_PO0          209
#define RK3368_SRST_L2_B                210
#define RK3368_SRST_ADB_B               211
#define RK3368_SRST_PD_CORE_B_NIU_A     212
#define RK3368_SRST_STRC_SYS_A          213
#define RK3368_SRST_CORE_L_0            214
#define RK3368_SRST_CORE_L_PO0          215
#define RK3368_SRST_L2_L                216
#define RK3368_SRST_ADB_L               217
#define RK3368_SRST_PD_CORE_L_NIU_A     218
#define RK3368_SRST_CCI400_SYS          219
#define RK3368_SRST_CCI400_DDR          220
#define RK3368_SRST_CCI400              221
#define RK3368_SRST_TRACE               222
#define RK3368_SRST_13RES15             223

#define RK3368_SRST_TIMER00             224
#define RK3368_SRST_TIMER01             225
#define RK3368_SRST_TIMER02             226
#define RK3368_SRST_TIMER03             227
#define RK3368_SRST_TIMER04             228
#define RK3368_SRST_TIMER05             229
#define RK3368_SRST_TIMER10             230
#define RK3368_SRST_TIMER11             231
#define RK3368_SRST_TIMER12             232
#define RK3368_SRST_TIMER13             233
#define RK3368_SRST_TIMER14             234
#define RK3368_SRST_TIMER15             235
#define RK3368_SRST_TIMER0_P            236
#define RK3368_SRST_TIMER1_P            237
#define RK3368_SRST_14RES14             238
#define RK3368_SRST_14RES15             239

#endif /* _DT_BINDINGS_CLOCK_ROCKCHIP_RK3368_H */
