#!/bin/sh
ubname=licheerv-dock-480x272
dtname=sun20i-d1-licheerv-dock-480x272
XYTAG=2018.03
UBTAG=2018.05

#git clone -b v${XYTAG} https://github.com/xypron/u-boot-odroid-c2 u-boot-${ubname}
git clone -b master https://github.com/scpcom/u-boot-build u-boot-${ubname}

cd u-boot-${ubname}

sed -i s/'arm64'/'riscv64'/g build-dpkg.sh 
sed -i s/'arm64'/'riscv64'/g debian/control 
sed -i s/' ARCH=arm64'/' ARCH=riscv'/g Makefile 
sed -i s/'aarch64-linux-gnu-'/'riscv64-linux-gnu-'/g Makefile
sed -i s/'aarch64'/'rv64gc'/g Makefile 
sed -i s/'odroid-c2'/'nezha'/g debian/changelog 

sed -i s/'Odroid C2'/'Nezha'/g debian/control
sed -i s/'odroid-c2'/'nezha'/g debian/control 

sed -i s/'odroid-c2'/'nezha'/g debian/source/options 
sed -i s/meson-tools/sunxi-tools/g debian/source/options
sed -i s/hardkernel/sunxi/g debian/source/options

sed -i s/'Odroid C2'/'Nezha'/g Makefile
sed -i s/'odroid-c2'/'nezha'/g Makefile 
sed -i "s|make fip_create|#make fip_create|g" Makefile
sed -i "s|make sign|#make sign|g" Makefile
sed -i "s|dd if=u-boot.bin of=|#dd if=u-boot.bin of=|g" Makefile
#sed -i "s|hardkernel/sd_fuse/bl1.bin.hardkernel|denx/u-boot-sunxi-with-spl.bin|g" Makefile
sed -i "s|hardkernel/sd_fuse/bl1.bin.hardkernel|denx/u-boot.bin|g" Makefile
sed -i "s|hardkernel/sd_fuse/sd_fusing.sh|patch/sd_fusing.sh|g" Makefile
sed -i "s|http://git.denx.de/u-boot.git|https://github.com/scpcom/u-boot|g" Makefile
sed -i "s|https://github.com/hardkernel/u-boot.git|https://github.com/linux-sunxi/u-boot-sunxi|g" Makefile
sed -i "s|https://github.com/afaerber/meson-tools.git|https://github.com/linux-sunxi/sunxi-tools|g" Makefile
sed -i s/meson-tools/sunxi-tools/g Makefile
sed -i s/hardkernel/sunxi/g Makefile

sed -i /'cd denx .. git verify-tag'/d Makefile
sed -i /'grep .E872 DB40 9C1A 687E FBE8  6336 87F9 F635 D31D 7652.'/d Makefile
sed -i /'gpg --list-keys 87F9F635D31D7652'/d Makefile
sed -i /'gpg --keyserver keys.gnupg.net --recv-key 87F9F635D31D7652'/d Makefile
sed -i /'gpg --list-keys FA2ED12D3E7E013F'/d Makefile
sed -i /'gpg --keyserver keys.gnupg.net --recv-key FA2ED12D3E7E013F'/d Makefile

sed -i s/'Odroid C2'/'Nezha'/g README.md
sed -i s/'odroid-c2'/'nezha'/g README.md

#echo 'tar-ignore = "sunxi"' >> debian/source/options

cp -p ../sd_fusing.sh ./patch/
rm -f config/config-${XYTAG}
#cp -p ../config-${UBTAG} ./config/

rm -f patch/*.patch
rm -f patch/patch-${XYTAG}
echo '#!/bin/sh' > patch/patch-${UBTAG}
chmod ugo+rx patch/patch-${UBTAG}

sed -i s/'^TAG='${XYTAG}/'TAG='${UBTAG}/g Makefile 
sed -i s/'^TAGPREFIX='v/'TAGPREFIX='nezha-/g Makefile
sed -i s/${XYTAG}/${UBTAG}/g debian/changelog 

sed -i s/'Heinrich Schuchardt <xypron.glpk@gmx.de>  Sun, 25 Mar 2018 10:20:25 +0200'/'BSP <developer@build.local>  Sat, 18 Dec 2021 21:10:25 +0200'/g debian/changelog

if [ ! -e config/config-${UBTAG} ]; then
  if [ -e ../config-${UBTAG} ]; then
    cp -p ../config-${UBTAG} config/
  elif [ -e ../config-${XYTAG} ]; then
    cp -p ../config-${XYTAG} config/config-${UBTAG}
  else
    cp -p config/config-${XYTAG} config/config-${UBTAG} 
  fi
fi

sed -i s/'nezha'/${ubname}/g debian/changelog 
sed -i s/'nezha'/${ubname}/g debian/control 
sed -i s/'nezha'/${ubname}/g debian/source/options 
sed -i s/'nezha'/${ubname}/g Makefile 
sed -i s/'nezha'/${ubname}/g README.md

sed -i s/'TAGPREFIX='${ubname}'-'/'TAGPREFIX=nezha-'/g Makefile

sed -i s/sun20i-d1-nezha/${dtname}/g config/config-${UBTAG}

if [ ! -e patch/patch-${UBTAG} ]; then
  #cp -p patch/patch-${XYTAG} patch/patch-${UBTAG}
  touch config/config-${UBTAG}
fi

cp -p ../toc1.cfg ./patch/

patch -p1 < ../u-boot-nezha-config-hash.patch
rm -f Makefile.orig
git add .
git commit -m ${ubname}

patch -p1 < ../u-boot-nezha-opensbi.patch
rm -f Makefile.orig
sed -i s/'sunxi\*'/'opensbi*'/g debian/source/options
git add .
git commit -m opensbi

patch -p1 < ../u-boot-nezha-spl.patch
#patch -p1 < ../u-boot-nezha-spl-part2.patch
#patch -p1 < ../u-boot-nezha-spl-part3.patch
rm -f Makefile.orig
sed -i s/sunxi-tools/spl/g debian/source/options
sed -i s/'SUNXI_SPL_TAG=.*'/'SUNXI_SPL_TAG=40c2aea6dc473462ee19fde199484ca388cad957'/g Makefile
git add .
git commit -m spl

sed -i s/${ubname}/'nezha'/g Makefile
patch -p1 < ../u-boot-nezha-opensbi-spl-install.patch
sed -i s/'nezha'/${ubname}/g Makefile
sed -i s/'TAGPREFIX='${ubname}'-'/'TAGPREFIX=nezha-'/g Makefile
sed -i s/'git checkout '${ubname}'-'/'git checkout nezha-'/g Makefile
rm -f Makefile.orig
git add .
git commit -m opensbi-spl-install

sed -i s/${ubname}/'nezha'/g Makefile
patch -p1 < ../u-boot-nezha-toc1.patch
sed -i s/'nezha'/${ubname}/g Makefile
sed -i s/'TAGPREFIX='${ubname}'-'/'TAGPREFIX=nezha-'/g Makefile
sed -i s/'git checkout '${ubname}'-'/'git checkout nezha-'/g Makefile
rm -f Makefile.orig
git add .
git commit -m toc1

cd ..

tar czf u-boot-${UBTAG}-nezha-source.tar.gz u-boot-${ubname}

echo OK
