#!/bin/sh
ubname=nezha
dtname=sun20i-d1-nezha

export BSP_ARCH=riscv64

export ARCH=arm64
export KBUILD_IMAGE=Image
if [ "X${BSP_ARCH}" = "Xarmhf" ]; then
  export ARCH=arm
  export CROSS_COMPILE=arm-linux-gnueabihf-
  export KBUILD_IMAGE=Image

elif [ "X${BSP_ARCH}" = "Xarm64" ]; then
  export ARCH=arm64
  export CROSS_COMPILE=aarch64-linux-gnu-

elif [ "X${BSP_ARCH}" = "Xriscv64" ]; then
  export ARCH=riscv
  export CROSS_COMPILE=riscv64-linux-gnu-

  t=`pwd`/../prebuilt/gcc/linux-x86/riscv/toolchain-thead-glibc/riscv64-glibc-gcc-thead_20200702/bin/riscv64-unknown-linux-gnu-
  if [ -e ${t}gcc ]; then
    export CROSS_COMPILE=$t
  fi
  t=`pwd`/prebuilt/gcc/linux-x86/riscv/toolchain-thead-glibc/riscv64-glibc-gcc-thead_20200702/bin/riscv64-unknown-linux-gnu-
  if [ -e ${t}gcc ]; then
    export CROSS_COMPILE=$t
  fi
  echo "Using ${CROSS_COMPILE}gcc"  

elif [ "X${BSP_ARCH}" = "Xamd64" ]; then
  export ARCH=x86
  export CROSS_COMPILE=x86_64-linux-gnu-
  export KBUILD_IMAGE=bzImage

elif [ "X${BSP_ARCH}" = "Xi686" ]; then
  export ARCH=x86
  export CROSS_COMPILE=i686-linux-gnu-
  export KBUILD_IMAGE=bzImage

elif [ "X${BSP_ARCH}" = "Xpowerpc" ]; then
  export ARCH=powerpc
  export CROSS_COMPILE=powerpc-linux-gnu-
  export KBUILD_IMAGE=zImage
fi

export CC=${CROSS_COMPILE}gcc
export CXX=${CROSS_COMPILE}g++

echo $CXX

#exit 1

cd u-boot-${ubname}

#./build-dpkg.sh
if true ; then
sed -i "s|export CROSS_COMPILE=riscv64-linux-gnu-|export CROSS_COMPILE=${CROSS_COMPILE}|g" Makefile
if [ -e ../linux/arch/riscv/boot/dts/sunxi/${dtname}.dtb ]; then
  sed -i "s|arch/riscv/dts/${dtname}.dtb|../../linux/arch/riscv/boot/dts/sunxi/${dtname}.dtb|g" patch/toc1.cfg
elif [ -e ../../linux/arch/riscv/boot/dts/sunxi/${dtname}.dtb ]; then
  sed -i "s|arch/riscv/dts/${dtname}.dtb|../../../linux/arch/riscv/boot/dts/sunxi/${dtname}.dtb|g" patch/toc1.cfg
fi
make prepare
make clean
dpkg-buildpackage -a${BSP_ARCH} -d -us -uc
else
cd denx && make -j1
fi

cd ..

uver=`ls ${ubname}-u-boot-image_*_*.deb | cut -d _ -f 2`

zip u-boot-${uver}-${ubname}.zip ${ubname}-u-boot-image_*_*.deb install-*.sh

echo OK
