/*
 * include/linux/mfd/acx00-mfd.h -- Core interface for ACX00
 *
 * Copyright 2009 Wolfson Microelectronics PLC.
 *
 * Author: Mark Brown <broonie@opensource.wolfsonmicro.com>
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 */

#ifndef __ACX00_MFD_H__
#define __ACX00_MFD_H__

#include <linux/mutex.h>
#include <linux/interrupt.h>

/* GPIOs in the chip are numbered from 1-11 */
#define ACX00_IRQ_GPIO(x) (x + ACX00_IRQ_TEMP_WARN)

#define SYS_VERSION			0x0000
#define SYS_CONTROL			0x0002
#define SYS_IRQ_ENABLE		0x0004
#define SYS_IRQ_STATUS		0x0006
/*#define SYS_CLK_CTL			0x0008*/
#define SYS_DLDO_OSC_CTL	0x000a
#define SYS_PLL_CTL0		0x000c
#define SYS_PLL_CTL1		0x000e
#define SYS_AUDIO_CTL0		0x0010
#define SYS_AUDIO_CTL1		0x0012
#define SYS_EPHY_CTL0		0x0014
#define SYS_EPHY_CTL1		0x0016
#define SYS_TVE_CTL0		0x0018
#define SYS_TVE_CTL1		0x001a

/*SYS_VERSION:0x0000*/
#define CHIP_PACKAGE		14
#define CHIP_VERSION		0

/*SYS_CONTROL:0x0002*/
#define CIHP_RESET			0

/*SYS_IRQ_ENABLE:0x0004*/
#define INTB_OUTPUT_ENABLE	15
#define INTB_OUTPUT_CFG		14
#define RTC_IRQ_ENABLE		12
#define EPHY_IRQ_ENABLE		8
#define TVE_IRQ_ENABLE		4

/*SYS_IRQ_STATUS:0x0006*/
#define RTC_IRQ_STATUS		12
#define EPHY_IRQ_STATUS		8
#define TVE_IRQ_STATUS		4

/*SYS_CLK_CTL:0x0008*/
#define EFUSE_CLK_SEL		5
#define SYS_CLK_SEL			4
#define CKI_24M_ENABLE		2
#define CKO_RTC_ENABLE		1
#define CKO_32K_ENABLE		0

/*SYS_DLDO_OSC_CTL:0x000a*/
#define DLDOEN				15
#define DLDOVOL				12
#define ENBG				11
#define RESBYPS				10
#define OSCEN				3
#define OSCSEL				0

/*SYS_PLL_CTL0:0x000c*/
#define PLL_ENABLE			15
#define PLL_BIAS_EN			14
#define PLL_LDO1_EN			11
#define PLL_LDO_EN			10
#define PLL_POST_DIV		9
#define PLL_PRE_DIV_M		0

/*SYS_PLL_CTL1:0x000e*/
#define PLL_CS				10
#define PLL_VCO_S			5
#define PLL_CP_S			0

/*SYS_AUDIO_CTL0:0x0010*/
#define AC_MCLK_GATING		1
#define AC_RESET_INVALID	0

/*SYS_AUDIO_CTL1:0x0012*/
#define AC_I2S_IO_EN		0

/*SYS_EPHY_CTL0:0x0014*/
#define EPHY_SYSCLK_GATING	1
#define EPHY_RESET_INVALID	0

/*SYS_EPHY_CTL1:0x0016*/
#define EPHY_MII_IO_FOR_I2S	15
#define EPHY_MII_IO_FOR_PLL	14
#define E_DPX_LED_IO_EN		3
#define E_SPD_LED_IO_EN		2
#define E_LNK_LED_IO_EN		1
#define EPHY_MII_IO_EN		0

/*SYS_TVE_CTL0:0x0018*/
#define TVE_SYSCLK_GATING	3
#define TVE_SCLK_GATING		2
#define TVE_DCLK_GATING		1
#define TVE_RESET_INVALID	0

/*SYS_TVE_CTL1:0x001a*/
#define TVE_CCIR_CLK_IO_EN	1
#define TVE_CCIR_SYNC_DATA_IO_EN 0

struct acx00 {
	struct mutex lock;

	struct device *dev;
	struct regmap *regmap;
	struct pwm_device *pwm_ac200;
	struct work_struct init_work;
	int irq;
};

/* Device I/O API */
int acx00_reg_read(struct acx00 *acx00, unsigned short reg);
int acx00_reg_write(struct acx00 *acx00, unsigned short reg,
		    unsigned short val);
int acx00_enable(void);
int acx00_set_bits(struct acx00 *acx00, unsigned short reg,
		    unsigned short mask, unsigned short val);

#endif
