#!/bin/sh
BOOTPART=/dev/mmcblk0p1

if mount | grep -q '/dev/mmcblk.p1.* /boot.* vfat' ; then
  BOOTPART=`mount | grep '/dev/mmcblk.p1.* /boot.* vfat' | cut -d ' ' -f 1`
  if [ -e /media/boot ]; then
    umount /boot
    mount $BOOTPART /media/boot/
  fi

elif mount | grep -q '/dev/mmcblk.p1.* /media/boot.* vfat' ; then
  BOOTPART=`mount | grep '/dev/mmcblk.p1.* /media/boot.* vfat' | cut -d ' ' -f 1`
fi

BOOTUUID=`blkid -o value -s UUID $BOOTPART | tr -d '"'`

ROOTPART=`df -h / | grep '/' | cut -d ' ' -f 1`
if [ "X${ROOTPART}" = "X" -o "X${ROOTPART}" = "X-" ]; then
  ROOTPART=`echo $BOOTPART | sed s/'.$'/'2'/g`
fi

ROOTUUID=`blkid -o value -s UUID $ROOTPART | tr -d '"'`
if [ "X${ROOTUUID}" != "X" ]; then
  ROOTPART=`blkid -U ${ROOTUUID}`
fi

kver=none
for f in `ls linux-image-*_*_*.deb`; do
    kver=`echo $f | cut -d "_" -f 1 | cut -d - -f 3- | sed s/-dbg//g`
done

dpkg -i linux-image-?.*.*sunxi_?.*.*-*-sunxi*_armhf.deb

if [ ! -e /lib/firmware/meson/gx ]; then
  dpkg -i meson-vdec-firmware_*.deb
fi

kdtb=none.dtb
for f in `ls /boot/*.dtb-${kver} /usr/lib/linux-image-${kver}/sun7i-a20-banana*.dtb /usr/lib/linux-image-${kver}/*/sun7i-a20-banana*.dtb 2> /dev/null`; do
    if [ -e $f ]; then
      kdtb=$f
    fi
done

if [ -e $kdtb ]; then
   b=`basename $kdtb`
   b=${b/-$kver/}
   c=/boot/boot.cmd

   if [ -d /media/boot ]; then
     c=/media/boot/boot.cmd
   fi

   echo Using $b
   [ "x${BOOTUUID}" != "x" ] && echo "Using boot=UUID=${BOOTUUID} for ${BOOTPART}"
   [ "x${ROOTUUID}" != "x" ] && echo "Using root=UUID=${ROOTUUID} for ${ROOTPART}"

   if [ "x${BOOTUUID}" != "x" -a "x${ROOTUUID}" != "x" ] ; then
     if false ; then
       if grep -q ${ROOTPART} /etc/fstab ; then
         sed -i 's|'${BOOTPART}'|UUID="'${BOOTUUID}'"|g' /etc/fstab
         sed -i 's|'${ROOTPART}'|UUID="'${ROOTUUID}'"|g' /etc/fstab
       fi
     fi
   fi

   if [ -e ${c/\.cmd/\.ini} -a ! -e ${c} ]; then
     cp -p ${c/\.cmd/\.ini} ${c}
     sed -i s/'ttyS0'/'ttyAML0'/g ${c}
     sed -i /'^fdt .*'/d ${c}
     sed -i /'^if .* then fdt rm .* fi'/d ${c}
     sed -i s/' mmc .:. '/' ${devtype} ${devnum}:${rootpart} '/g /media/boot/boot.cmd
   fi

   if [ -e ${c} ]; then
     if grep -q -E '\${dtb_loadaddr} .*\.dtb' ${c} ; then
       sed -i s/'\${dtb_loadaddr} .*\.dtb'/'${dtb_loadaddr} '${b}/g ${c} 
       [ "x${ROOTUUID}" != "x" ] && sed -i "s|${ROOTPART}|UUID=${ROOTUUID}|g" ${c}
       mkimage -C none -A arm -T script -d ${c} ${c/\.cmd/\.scr}
     fi
   fi

   cp -p `dirname ${kdtb}`/sun7i-a20-banana*.dtb /boot/
   ./install-dtb.sh $kver
fi

kimg=none
for f in `ls /boot/vmlinu?-${kver} 2> /dev/null`; do
    kimg=$f
done

if [ -e $kimg ]; then
  b=`basename $kimg`
  echo Using $b

  ./install-image.sh $kver $kimg
fi

update-initramfs -c -k $kver || update-initramfs -u -k $kver
./install-uinitrd.sh $kver

if [ -e 10-efuse.rules ]; then
  if [ ! -e /etc/udev/rules.d/10-efuse.rules ]; then
    cp -p 10-efuse.rules /etc/udev/rules.d/
  fi
fi

if [ -e asound.conf ]; then
  if [ ! -e /etc/asound.conf ]; then
    cp -p asound.conf /etc/
  fi
fi

if [ -e HDMI.conf ]; then
  if [ ! -e /usr/share/alsa/cards/HDMI.conf ]; then
    cp -p HDMI.conf /usr/share/alsa/cards/
  fi
fi

echo OK
