#!/bin/sh
malia=armhf
malim=mali400
malis=sunxi
maliv=r6p2

#brtgz=arm-buildroot-2016-08-18-5aaca1b35f.tar.gz
brtgz=buildroot_openlinux_kernel_3.14_wayland_20170630.tar.gz

defcfg=arch/arm/configs/bananapi_defconfig

if [ "X$1" = "Xarmhf" -o "X$1" = "Xarm64" ]; then
  malia=$1
fi

brarc=arm

if [ "${malia}" = "arm64" ]; then
  brarc=arm64
fi

if [ "X$3" = "Xmali400" -o "X$3" = "Xmali450" ]; then
  malim=$3
fi

brmal=m400
malil=sunxi_mali_400

if [ "${malim}" = "mali450" ]; then
  brmal=m450
  malil=sunxi_mali_450
fi

if [ "X$2" = "Xr5p1" -o "X$2" = "Xr6p2" -o "X$2" = "Xr7p0" ]; then
  maliv=$2
fi

brver=${maliv}
malix=${maliv}

if [ "${maliv:0:3}" = "r7p" ]; then
  brver=r7p0
elif [ "${maliv:0:3}" = "r6p" ]; then
  brver=r6p2
  malix=r6p2
elif [ "${maliv:0:3}" = "r5p" ]; then
  brver=r5p1
  malix=r7p0
fi

KDIR=$(pwd)/linux
if [ ! -e $KDIR ]; then
  KDIR=$(pwd)/linux-sunxi
fi

scriptdir=`dirname $0`
cd ${scriptdir} ; scriptdir=`pwd` ; cd - > /dev/null

mkdir -p archives

cd archives

#if [ ! -e ${brtgz} ]; then
#  #wget -N http://openlinux.amlogic.com:8000/download/ARM/filesystem/${brtgz}
#  wget -N http://openlinux2.amlogic.com:8000/download/ARM/filesystem/Linux_BSP/${brtgz}
#fi

cd ..

if [ ! -e sunxi-mali-lib ]; then
  git clone --depth 1 https://github.com/free-electrons/mali-blobs sunxi-mali-lib
fi

#if [ ! -e sunxi-mali-lib ]; then
#  mkdir sunxi-mali-lib
#  cd sunxi-mali-lib
# 
#  echo "Extracting meson mali lib from buildroot..."
#  #tar xzf ../archives/${brtgz} buildroot_openlinux/buildroot/package/meson-mali
#
#  cd ..
#fi

#if [ ! -e xf86-video-armsoc ]; then
#  git clone -b meson-drm https://github.com/superna9999/xf86-video-armsoc
#fi

if [ ! -e ${malil} ]; then
  #git clone -b DX910-SW-99002-r6p1-01rel0_meson_gx https://github.com/superna9999/${malil}
  git clone --depth 1 https://github.com/mripard/sunxi-mali ${malil}

  cd ${malil}/

  for f in `cat ../patches/series-mali-${malix} | grep -E "^${malix}/" | cut -d / -f 2-` ; do
    cp -p ../patches/$f patches/${malix}/
    echo "${malix}/$f" >> patches/${malix}/series
  done

  ##patch -p1 < ../${malil}-4.14-build.patch
  #patch -p1 < ../${malil}-4.14.patch

  ./build.sh -r ${malix} -a
else
  cd ${malil}/
fi

cp -p ../patches/mali-lib-END_USER_LICENCE_AGREEMENT.txt ./END_USER_LICENCE_AGREEMENT.txt

mkdir -p ${malia}
cd ${malia}

echo "Prepare ${brarc}/${brmal}/${brver}"

cp -p ${scriptdir}/sunxi-mali-lib/${brver}/${brarc}/x11_dma_buf/libMali.so .

if [ -e ${scriptdir}/sunxi-mali-lib/${brver}/${brarc}/x11_ump/libMali.so ]; then
  mkdir -p lib_x11-ump
  cp -p ${scriptdir}/sunxi-mali-lib/${brver}/${brarc}/x11_ump/libMali.so lib_x11-ump/
  cp -p ${scriptdir}/sunxi-mali-lib/${brver}/${brarc}/x11_ump/libUMP.so  lib_x11-ump/

elif [ -e ${scriptdir}/sunxi-mali-lib/${brver}/${brarc}/x11_ump/lib/lib_x11_ump.tar.bz2 ]; then
  tar xjf ${scriptdir}/sunxi-mali-lib/${brver}/${brarc}/x11_ump/lib/lib_x11_ump.tar.bz2 lib_x11/libMali.so lib_x11/libUMP.so
  mv lib_x11 lib_x11-ump

else
   echo "Warning: ${brver}/${brarc}/x11_ump/libMali.so not found."
fi

mkdir -p lib_wayland

cp -p ${scriptdir}/sunxi-mali-lib/${brver}/${brarc}/wayland/libMali.so lib_wayland/

mkdir -p lib_fbdev

cp -p ${scriptdir}/sunxi-mali-lib/${brver}/${brarc}/fbdev/libMali.so lib_fbdev/

cd ..


cd ..

if [ -e ${KDIR}/drivers/gpu ]; then
  echo "Integrating sunxi mali driver..."

  if [ ! -e ${KDIR}/drivers/gpu/arm/mali ]; then
    mkdir -p ${KDIR}/drivers/gpu/arm
    cp -apP ${malil}/${malix}/src/devicedrv/mali ${KDIR}/drivers/gpu/arm/
    cp -apP ${malil}/${malix}/src/devicedrv/ump linux/drivers/gpu/arm/
    cp -apP ${malil}/${malix}/src/devicedrv/umplock linux/drivers/gpu/arm/
    #cp -apP ${malil}/${malix}/src/ump/include linux/drivers/gpu/arm/ump/
    cp -apP ${malil}/${malix}/src/ump/include/ump linux/include/
  fi

  if ! grep -q CONFIG_MALI400 ${KDIR}/${defcfg} ; then
    cat <<EOFMALIDEFCFG | tee -a ${KDIR}/${defcfg}

CONFIG_MALI400=y
# CONFIG_MALI450 is not set
# CONFIG_MALI470 is not set
# CONFIG_MALI400_DEBUG is not set
# CONFIG_MALI400_PROFILING is not set
CONFIG_MALI400_UMP=y
# CONFIG_MALI_DVFS is not set
CONFIG_MALI_DMA_BUF_MAP_ON_ATTACH=y
# CONFIG_MALI_SHARED_INTERRUPTS is not set
# CONFIG_MALI_PMU_PARALLEL_POWER_UP is not set
# CONFIG_MALI_DT is not set
# CONFIG_MALI_DEVFREQ is not set
# CONFIG_MALI_QUIET is not set
EOFMALIDEFCFG
  fi

  if ! grep -q CONFIG_UMP ${KDIR}/${defcfg} ; then
    cat <<EOFUMPDEFCFG | tee -a ${KDIR}/${defcfg}

CONFIG_UMP=y
# CONFIG_UMP_DEBUG is not set
EOFUMPDEFCFG
  fi

  sed -i s/CONFIG_ARCH_EXYNOS4/CONFIG_ARCH_SUNXI/g ${KDIR}/drivers/gpu/arm/mali/Kbuild
  sed -i s/exynos4/sunxi/g ${KDIR}/drivers/gpu/arm/mali/Kbuild

  if [ ! -e ${KDIR}/drivers/gpu/arm/Kconfig ]; then
    touch ${KDIR}/drivers/gpu/arm/Kconfig
  fi
  if ! grep -q 'arm/mali/' ${KDIR}/drivers/gpu/arm/Kconfig ; then
    echo 'source "drivers/gpu/arm/mali/Kconfig"' >> ${KDIR}/drivers/gpu/arm/Kconfig
  fi
  if ! grep -q 'arm/ump/' ${KDIR}/drivers/gpu/arm/Kconfig ; then
    echo 'source "drivers/gpu/arm/ump/Kconfig"' >> ${KDIR}/drivers/gpu/arm/Kconfig
  fi

  if [ ! -e ${KDIR}/drivers/gpu/arm/Makefile ]; then
    touch ${KDIR}/drivers/gpu/arm/Makefile
  fi
  if ! grep -q 'mali/' ${KDIR}/drivers/gpu/arm/Makefile ; then
    echo 'obj-$(CONFIG_MALI400) += mali/' >> ${KDIR}/drivers/gpu/arm/Makefile
  fi
  if ! grep -q 'ump/' ${KDIR}/drivers/gpu/arm/Makefile ; then
    echo 'obj-$(CONFIG_UMP) += ump/' >> ${KDIR}/drivers/gpu/arm/Makefile
  fi
  if ! grep -q 'umplock/' ${KDIR}/drivers/gpu/arm/Makefile ; then
    echo 'obj-$(CONFIG_UMP) += umplock/' >> ${KDIR}/drivers/gpu/arm/Makefile
  fi

  if ! grep -q 'gpu/arm/' ${KDIR}/drivers/video/Kconfig ; then
    echo 'source "drivers/gpu/arm/Kconfig"' >> ${KDIR}/drivers/video/Kconfig
  fi

  if ! grep -q 'arm/' ${KDIR}/drivers/gpu/Makefile ; then
    echo 'obj-y += arm/' >> ${KDIR}/drivers/gpu/Makefile
  fi
fi

if [ -e mali400-${malis} ]; then
  if [ ! -e ${malim}-${malis} ]; then
    mkdir ${malim}-${malis}
    cp -apP mali400-${malis}/DEBIAN ${malim}-${malis}/
    sed -i s/mali400-${malis}/${malim}-${malis}/g ${malim}-${malis}/DEBIAN/control
  fi
fi

sed -i s/'^malia=.*'/'malia='${malia}/g build-mali-driver.sh
sed -i s/'^malil=.*'/'malil='${malil}/g build-mali-driver.sh
sed -i s/'^malim=.*'/'malim='${malim}/g build-mali-driver.sh
sed -i s/'^malis=.*'/'malis='${malis}/g build-mali-driver.sh
sed -i s/'^maliv=.*'/'maliv='${maliv}/g build-mali-driver.sh

echo OK
