#!/bin/sh

doOptional=false
useDebianSource=false

. ./build-env.sh

lxmmmkb=`echo ${lxdebkb} | cut -d '.' -f 1-2`

if [ ! -e linux-${lxmmmkb}.y ]; then
  git clone -b linux-${lxmmmkb}.y --depth 100 https://git.kernel.org/pub/scm/linux/kernel/git/stable/linux-stable.git linux-${lxmmmkb}.y
  #git clone --depth 100 https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git linux-${lxmmmkb}.y
  #git clone git://github.com/linux-sunxi/linux-sunxi.git -b sunxi-next --depth=1 linux-${lxmmmkb}.y
  #git clone https://github.com/bootlin/linux-cedrus -b cedrus/4.18/requests-api-v17-merge --depth=1 linux-${lxmmmkb}.y
fi

echo "Copying files from linux-${lxmmmkb}.y git..."
mkdir linux && \
cp -apP linux-${lxmmmkb}.y/. linux/ && \
cd linux

if [ -e ../patches/series-bananapi ]; then
  mkdir -p patches
  mkdir -p patches/platform

  for f in `cat ../patches/series-bananapi | grep -E '^platform/' | cut -d / -f 2-` ; do
    cp -p ../patches/${f} patches/platform/
  done

  cat ../patches/series-bananapi >> patches/series

  #cp -p ../patches/stmmac_platform_mac_addr_set.patch patches/
  #echo "stmmac_platform_mac_addr_set.patch" >> patches/series

  quilt push -a
fi

cp -p ../patches/*_defconfig arch/arm/configs/

echo OK
