#!/bin/sh
malia=armhf
malig=arm-linux-gnueabihf
malil=sunxi_mali_400
malim=mali400
malis=sunxi
maliv=r6p2

malid=$1

KDIR=$(pwd)/linux
if [ ! -e $KDIR ]; then
  KDIR=$(pwd)/linux-sunxi
fi

if [ "X$1" = "Xarmhf" -o "X$1" = "Xarm64" ]; then
  malia=$1
  malid=$2
fi

malideb=${malim}${malid}-${malis}
malig=arm-linux-gnueabihf

if [ "${malia}" = "arm64" ]; then
  malig=aarch64-linux-gnu
fi

restoredlib=none

if [ -e mali.ko ]; then
  VERSION=`cat ${KDIR}/Makefile | grep -E '^VERSION.=' | cut -d "=" -f 2- | tr -d " \t\n\r"`
  PATCHLEVEL=`cat ${KDIR}/Makefile | grep PATCHLEVEL.= | cut -d "=" -f 2- | tr -d " \t\n\r"`
  SUBVERSION=`cat ${KDIR}/Makefile | grep SUBLEVEL.= | cut -d "=" -f 2- | tr -d " \t\n\r"`
  ARCH=${malia}
  LOCALVERSION="+c2"

  #cp -p ump.ko /lib/modules/${VERSION}.${PATCHLEVEL}.${SUBVERSION}${LOCALVERSION}/kernel/
  cp -p mali.ko /lib/modules/${VERSION}.${PATCHLEVEL}.${SUBVERSION}${LOCALVERSION}/kernel/
  depmod ${VERSION}.${PATCHLEVEL}.${SUBVERSION}${LOCALVERSION}
fi

malidebfile=${malideb}_1_${malia}.deb
malidebmode=replace
malilib=/usr/lib/${malig}/${malideb}/libMali.so

for f in ${malideb}_*_${malia}.deb ; do
  if [ -e $f ]; then
    malidebfile=$f
  fi
done

if [ -e ${malidebfile} ]; then
  if [ ! -e /usr/lib/${malig}/libwayland-egl.so.1 ]; then
    apt-get install -y libwayland-egl1 || apt-get install -y libwayland-egl1-mesa
  fi

  if [ ! -e /usr/lib/${malig}/libgbm.so.1 ]; then
    apt-get install -y libgbm1
  fi

  if [ ! -e /usr/lib/${malig}/libEGL.so.1 ]; then
    apt-get install -y libegl1  || apt-get install -y libegl1-mesa
  fi

  if [ ! -e /usr/lib/${malig}/libGLESv2.so.2 ]; then
    apt-get install -y libgles2 || apt-get install -y libgles2-mesa
  fi

  if [ ! -e /usr/lib/${malig}/libGL.so.1 ]; then
    apt-get install -y libgl1   || apt-get install -y libgl1-mesa-glx
  fi

  if [ ! -e /usr/lib/${malig}/libGLU.so.1 ]; then
    apt-get install -y libglu1  || apt-get install -y libglu1-mesa
  fi

  if [ ! -e /usr/lib/${malig}/libGLX.so.0 ]; then
    apt-get install -y libglx0  || true
  fi

  apt-get install -y \
    libdrm2 \
    libxdamage1 \
    libxfixes3

  dpkg -i ${malidebfile}

elif [ X${malid} = X-restore -o X${malid} = X-ump ]; then
  malidebmode=restore
  malilib=/usr/lib/${malig}/libMali.so

else
  echo ${malideb} not found
  exit 1
fi

i=/usr/include/umplock

if [ -e ${i} -a ! -e ${i}.disabled ]; then
  mv ${i} ${i}.disabled
fi

sl="libEGL.so.1.0.0
libGLESv1_CM.so.1.1.0
libGLESv2.so.2.0.0"

if grep -q wl_egl_window_create ${malilib} ; then
  sl="${sl}
libwayland-egl.so.1.0.0"
fi
if grep -q gbm_bo_create ${malilib} ; then
  sl="${sl}
libgbm.so.1.0.0"
fi

fixlink() {
  lt=$1
  ld=$2
  ln=$3
  ll=none

  if readlink ${ld}/${ln} > /dev/null ; then
    ll=`readlink ${ld}/${ln}`
    ll=`basename ${ll}`
  fi

  echo ${ll} ${ln}
  #echo ${lt}

  if [ "X${ll}" != "X${lt}" ]; then
    if [ -e ${ld}/${ln} -a ! -e ${ld}/${ln}.distrib ]; then
      dpkg-divert --local --rename --add ${ld}/${ln}
    fi
  
    rm -f ${ld}/${ln}
  fi

  if [ ! -e ${ld}/${ln} ]; then
    #echo ln -s ${lt} ${ld}/${ln}
    ln -s ${lt} ${ld}/${ln}
  fi
}

replacemali() {
  l=$1

  #libgbm.so.1.0.0 libwayland-egl.so.1.0.0
  #libEGL.so.1.0.0 libGLESv1_CM.so.1.1.0 libGLESv2.so.2.0.0
  for s in ${sl} ; do
    a=`echo ${s} | cut -d . -f 1-2`
    b=`echo ${s} | cut -d . -f 1-3`
    c=`echo ${s} | cut -d . -f 1-4`
    d=none

    if [ -e ${l}/${s} ]; then
      if readlink ${l}/${s} > /dev/null ; then
        d=`readlink ${l}/${s}`
        d=`basename ${d}`
      fi
    fi
    echo $d $s

    if [ -e ${l}/${s} ]; then
      fixlink ./libMali.so ${l} ${c}
      fixlink ./libMali.so ${l} ${b}
      fixlink ./libMali.so ${l} ${a}
    fi

    if [ "X${d}" != "XlibMali.so" ]; then
      if [ -e ${l}/${s} -a ! -e ${l}/${s}.distrib ]; then
        dpkg-divert --local --rename --add ${l}/${s}
      fi

      ln -s ./libMali.so ${l}/${s}
    fi

    echo ""
  done

  if [ -e ${l}/libMali.so -a ! -e ${l}/libMali.so.distrib ]; then
    dpkg-divert --local --rename --add ${l}/libMali.so
  fi

  cp -p /usr/lib/${malig}/${malideb}/libMali.so ${l}
}

replaceump() {
  l=$1

  ul=libUMP.so.3.0.0
  for s in ${ul} ; do
    a=`echo ${s} | cut -d . -f 1-2`
    b=`echo ${s} | cut -d . -f 1-3`
    c=`echo ${s} | cut -d . -f 1-4`
    d=none

    if [ -e ${l}/${s} ]; then
      if readlink ${l}/${s} > /dev/null ; then
        d=`readlink ${l}/${s}`
        d=`basename ${d}`
      fi
    fi
    echo $d $s

    if [ -e ${l}/${s} ]; then
      fixlink ./libUMP.so ${l} ${c}
      fixlink ./libUMP.so ${l} ${b}
      fixlink ./libUMP.so ${l} ${a}
    fi

    if [ "X${d}" != "XlibUMP.so" ]; then
      if [ -e ${l}/${s} -a ! -e ${l}/${s}.distrib ]; then
        dpkg-divert --local --rename --add ${l}/${s}
      fi

      ln -s ./libUMP.so ${l}/${s}
    fi

    echo ""
  done

  if [ -e ${l}/libUMP.a -a ! -e ${l}/libUMP.a.distrib ]; then
    dpkg-divert --local --rename --add ${l}/libUMP.a
  fi

  if [ -e ${l}/libUMP.so -a ! -e ${l}/libUMP.so.distrib ]; then
    dpkg-divert --local --rename --add ${l}/libUMP.so
  fi

  rm -f ${l}/libUMP.so

  cp -p /usr/lib/${malig}/${malideb}/libUMP.so ${l}
}

restorelib() {
  lt=$1
  ld=$2
  ln=$3
  ll=none

  lt=`basename ${lt}`

  if readlink ${ld}/${ln} > /dev/null ; then
    ll=`readlink ${ld}/${ln}`
    ll=`basename ${ll}`
  fi

  echo ${ll} ${ln}
  #echo ${lt}

  if [ "X${ll}" = "X${lt}" ]; then
    if [ -e ${ld}/${ln} -a -e ${ld}/${ln}.distrib ]; then
      rm -f ${ld}/${ln}
      dpkg-divert --local --rename --remove ${ld}/${ln}
    fi
  fi

  if [ ! -e ${ld}/${ln} ]; then
    #echo ln -s ${lt} ${ld}/${ln}
    ln -s ${lt} ${ld}/${ln}
  fi

  ll=none

  if readlink ${ld}/${ln} > /dev/null ; then
    ll=`readlink ${ld}/${ln}`
    ll=`basename ${ll}`
  fi

  if [ -e ${ld}/${ln} -a "X${ll}" = "Xnone" ]; then
    restoredlib=${ln}
  fi

  if [ "X${ll}" != "Xnone" -a "X${ll}" != "X${lt}" ]; then
    rm -f ${ld}/${ln}
    ln -s ${lt} ${ld}/${ln}
  fi
}

restoremali() {
  l=$1

  #libgbm.so.1.0.0 libwayland-egl.so.1.0.0
  #libEGL.so.1.0.0 libGLESv1_CM.so.1.1.0 libGLESv2.so.2.0.0
  for s in ${sl} ; do
    a=`echo ${s} | cut -d . -f 1-2`
    b=`echo ${s} | cut -d . -f 1-3`
    c=`echo ${s} | cut -d . -f 1-4`
    d=none

    restoredlib=./libMali.so

    if [ -e ${l}/${s} ]; then
      if readlink ${l}/${s} > /dev/null ; then
        d=`readlink ${l}/${s}`
        d=`basename ${d}`
      fi
    fi
    echo $d $s

    if [ -e ${l}/${s} ]; then
      restorelib ./libMali.so ${l} ${c}
      restorelib ./libMali.so ${l} ${b}
      restorelib ./libMali.so ${l} ${a}
    fi

    if [ "X${d}" = "XlibMali.so" ]; then
      if [ -e ${l}/${s} -a -e ${l}/${s}.distrib ]; then
        rm -f ${l}/${s}
        dpkg-divert --local --rename --remove ${l}/${s}
      fi
    fi

    d=none

    if readlink ${l}/${s} > /dev/null ; then
      d=`readlink ${l}/${s}`
      d=`basename ${d}`
    fi

    if [ -e ${l}/${s} -a "X${d}" = "Xnone" ]; then
      restoredlib=${s}
    fi

    if [ "${restoredlib}" != "./libMali.so" ]; then
      restorelib ${restoredlib} ${l} ${c}
      restorelib ${restoredlib} ${l} ${b}
      restorelib ${restoredlib} ${l} ${a}
    fi

    echo ""
  done

  if [ -e ${l}/libMali.so -a -e ${l}/libMali.so.distrib ]; then
    rm -f ${l}/libMali.so
    dpkg-divert --local --rename --remove ${l}/libMali.so
  fi
}


if [ -e /usr/share/X11/xorg.conf.d/99-fbturbo.conf ]; then
  if grep -q '"UseDumb"' /usr/share/X11/xorg.conf.d/99-fbturbo.conf ; then
    if [ $malidebmode = replace -a "X${malid}" != "X-ump" ]; then
      sed -i s/'"UseDumb" .*'/'"UseDumb" "true"'/g /usr/share/X11/xorg.conf.d/99-fbturbo.conf
    else
      sed -i s/'"UseDumb" .*'/'"UseDumb" "false"'/g /usr/share/X11/xorg.conf.d/99-fbturbo.conf
    fi
  fi
fi

if [ $malidebmode = replace ]; then
  replacemali /usr/lib/${malig}
  replacemali /usr/lib

  if [ -e /usr/lib/${malig}/${malideb}/libUMP.so ]; then
    if [ -e /usr/lib/libUMP.so ]; then
      replaceump /usr/lib
    else
      replaceump /usr/lib/${malig}
    fi
  fi

else
  restoremali /usr/lib/${malig}
  restoremali /usr/lib
fi

echo OK
