#!/bin/sh
ldcfg=5.x-bpi.config
lxcfg=.config

cd linux

VERSION=`cat Makefile | grep -E '^VERSION.=' | cut -d "=" -f 2- | tr -d " \t\n\r"`
PATCHLEVEL=`cat Makefile | grep PATCHLEVEL.= | cut -d "=" -f 2- | tr -d " \t\n\r"`
SUBVERSION=`cat Makefile | grep SUBLEVEL.= | cut -d "=" -f 2- | tr -d " \t\n\r"`

ldcfg=${VERSION}.${PATCHLEVEL}-bpi.config

echo "Configuring ${VERSION}.${PATCHLEVEL}.${SUBVERSION}..."

export ARCH=arm
export LOCALVERSION="+bpi"

make LOCALVERSION="${LOCALVERSION}" ARCH=${ARCH} CROSS_COMPILE=arm-linux-gnueabihf- defconfig

if [ ! -e config-0 ]; then
  cp -p .config config-0
fi

if [ -e arch/arm/configs/bananapi_defconfig ]; then
  make LOCALVERSION="${LOCALVERSION}" ARCH=${ARCH} CROSS_COMPILE=arm-linux-gnueabihf- bananapi_defconfig

  cp -p .config $ldcfg
fi

lxcfg=.config
cp -p $ldcfg $lxcfg

sed -i 's|^CONFIG_LOCALVERSION_AUTO=.*|# CONFIG_LOCALVERSION_AUTO is not set|g' $lxcfg
sed -i 's|^CONFIG_DEFAULT_HOSTNAME=.*|CONFIG_DEFAULT_HOSTNAME="(none)"|g' $lxcfg

sed -i 's|^CONFIG_CMDLINE=.*|CONFIG_CMDLINE=""|g' $lxcfg
sed -i 's|^CONFIG_INITRAMFS_SOURCE=.*|CONFIG_INITRAMFS_SOURCE=""|g' $lxcfg

sed -i 's|^CONFIG_DEBUG_INFO=y|# CONFIG_DEBUG_INFO is not set|g' $lxcfg

sed -i 's|^CONFIG_STMMAC_ETH=m|CONFIG_STMMAC_ETH=y|g' $lxcfg
sed -i 's|^CONFIG_STMMAC_PLATFORM=m|CONFIG_STMMAC_PLATFORM=y|g' $lxcfg
sed -i 's|^CONFIG_DWMAC_GENERIC=m|CONFIG_DWMAC_GENERIC=y|g' $lxcfg
sed -i 's|^CONFIG_DWMAC_IPQ806X=m|CONFIG_DWMAC_IPQ806X=y|g' $lxcfg
sed -i 's|^CONFIG_DWMAC_MESON=m|CONFIG_DWMAC_MESON=y|g' $lxcfg
sed -i 's|^CONFIG_DWMAC_ROCKCHIP=m|CONFIG_DWMAC_ROCKCHIP=y|g' $lxcfg
sed -i 's|^CONFIG_DWMAC_SUNXI=m|CONFIG_DWMAC_SUNXI=y|g' $lxcfg

make LOCALVERSION="${LOCALVERSION}" ARCH=${ARCH} CROSS_COMPILE=arm-linux-gnueabihf- oldconfig

cd ..

echo OK
