#!/bin/sh
malia=armhf
malil=sunxi_mali_400
malim=mali400
malis=sunxi
malit=20170630
maliv=r6p2

KDIR=$(pwd)/linux
if [ ! -e $KDIR ]; then
  KDIR=$(pwd)/linux-${malis}
fi

if [ "X$1" = "Xarmhf" -o "X$1" = "Xarm64" ]; then
  malia=$1
fi

malig=arm-linux-gnueabihf

if [ "${malia}" = "arm64" ]; then
  malig=aarch64-linux-gnu
fi

buildmalideb() {
  malid=$1

  if [ ! -e ${malim}-${malid}-${malis} ]; then
    mkdir ${malim}-${malid}-${malis}
    cp -apP ${malim}-${malis}/DEBIAN ${malim}-${malid}-${malis}/
    sed -i s/${malim}-${malis}/${malim}-${malid}-${malis}/g ${malim}-${malid}-${malis}/DEBIAN/control
  fi

  cd ${malim}-${malid}-${malis}

  sed -i s/'Version: .*'/'Version: '${malit}-${maliv}-1/g DEBIAN/control

  mkdir -p usr/lib/${malig}/${malim}-${malid}-${malis}

  malio=../${malil}/${malia}/lib_${malid}/libMali.so

  if [ -e ../${malil}/${malia}/lib_x11-${malid}/libUMP.so ]; then
    malio=../${malil}/${malia}/lib_x11-${malid}/libMali.so
    cp -p ../${malil}/${malia}/lib_x11-${malid}/libUMP.so  usr/lib/${malig}/${malim}-${malid}-${malis}/
  fi

  if [ -e ${malio} ]; then
    cp -p ${malio} usr/lib/${malig}/${malim}-${malid}-${malis}/

    mkdir -p usr/share/doc/${malim}-${malid}-${malis}
    cp -p ../${malil}/END_USER_LICENCE_AGREEMENT.txt usr/share/doc/${malim}-${malid}-${malis}/

    cd ..

    dpkg-deb -b ${malim}-${malid}-${malis} ${malim}-${malid}-${malis}_${malit}-${maliv}-1_${malia}.deb

  else
    cd ..

    echo "Warning: Skip ${malim}-${malid}-${malis}_${malit}-${maliv}-1_${malia}.deb"
  fi
}

cd ${malil}/

if [ ! -e ${KDIR}/drivers/gpu/arm/mali ]; then
  ARCH=${malia} KDIR=$KDIR ./build.sh
fi

cd ..

cd ${malim}-${malis}

sed -i s/'Architecture: .*'/'Architecture: '${malia}/g DEBIAN/control
sed -i s/'Version: .*'/'Version: '${malit}-${maliv}-1/g DEBIAN/control

cd ..

if [ -e ${malil}/${malia}/libMali.so ]; then
  cd ${malim}-${malis}

  mkdir -p usr/lib/${malig}/${malim}-${malis}
  cp -p ../${malil}/${malia}/libMali.so usr/lib/${malig}/${malim}-${malis}/

  mkdir -p usr/share/doc/${malim}-${malis}
  cp -p ../${malil}/END_USER_LICENCE_AGREEMENT.txt usr/share/doc/${malim}-${malis}/

  cd ..

  dpkg-deb -b ${malim}-${malis} ${malim}-${malis}_${malit}-${maliv}-1_${malia}.deb

else
  echo "Warning: Skip ${malim}-${malis}_${malit}-${maliv}-1_${malia}.deb"
fi

buildmalideb ump
buildmalideb wayland
buildmalideb fbdev

sed -i s/'^malia=.*'/'malia='${malia}/g install-mali-driver.sh
sed -i s/'^malil=.*'/'malil='${malil}/g install-mali-driver.sh
sed -i s/'^malim=.*'/'malim='${malim}/g install-mali-driver.sh
sed -i s/'^malis=.*'/'malis='${malis}/g install-mali-driver.sh
sed -i s/'^maliv=.*'/'maliv='${maliv}/g install-mali-driver.sh

if [ -e install-mali-dev.sh ]; then
  sed -i s/'^malia=.*'/'malia='${malia}/g install-mali-dev.sh
  sed -i s/'^malil=.*'/'malil='${malil}/g install-mali-dev.sh
  sed -i s/'^malim=.*'/'malim='${malim}/g install-mali-dev.sh
  sed -i s/'^malis=.*'/'malis='${malis}/g install-mali-dev.sh
  sed -i s/'^maliv=.*'/'maliv='${maliv}/g install-mali-dev.sh
fi

zip ${malim}-${malis}-${malia}.zip \
  install-mali-driver.sh \
  ${malim}*-${malis}_${malit}-${maliv}-1_${malia}.deb

echo OK
