#!/bin/sh

cd linux/

if [ ! -e .builddate ]; then
  LANG=C date -u > .builddate
fi

VERSION=`cat Makefile | grep -E '^VERSION.=' | cut -d "=" -f 2- | tr -d " \t\n\r"`
PATCHLEVEL=`cat Makefile | grep PATCHLEVEL.= | cut -d "=" -f 2- | tr -d " \t\n\r"`
SUBVERSION=`cat Makefile | grep SUBLEVEL.= | cut -d "=" -f 2- | tr -d " \t\n\r"`
BUILDVERSION=1
BUILDTIMESTAMP=`cat .builddate`
export ARCH=arm
export LOCALVERSION="+bpi"
export KBUILD_BUILD_TIMESTAMP=${BUILDTIMESTAMP}
export KBUILD_BUILD_VERSION=${BUILDVERSION}
export KBUILD_DEBARCH=armhf
export KDEB_PKGVERSION="${VERSION}.${PATCHLEVEL}.${SUBVERSION}-20200222-bpi"

echo "Building ${KDEB_PKGVERSION}..."

kmake() {
  echo ""
  echo "make $*"

  #KBUILD_IMAGE="Image"
    make $* KDEB_PKGVERSION="${KDEB_PKGVERSION}" LOCALVERSION="${LOCALVERSION}" ARCH=${ARCH} CROSS_COMPILE=arm-linux-gnueabihf- \
  KBUILD_BUILD_TIMESTAMP="${KBUILD_BUILD_TIMESTAMP}" KBUILD_BUILD_VERSION=${KBUILD_BUILD_VERSION} \
  KBUILD_DEBARCH=${KBUILD_DEBARCH} \
  DEBFULLNAME="SCP" \
  DEBEMAIL="scsupport@detc.local"
}

kmake -j4 Image modules
kmake dtbs

kmake headers_check 
kmake scripts

#kmake -j1 deb-pkg 
kmake -j1 bindeb-pkg

cd ..

echo linux-image-${KDEB_PKGVERSION}-${KBUILD_DEBARCH}.zip
zip linux-image-${KDEB_PKGVERSION}-${KBUILD_DEBARCH}.zip install-linux.sh install-dtb.sh install-image.sh install-uinitrd.sh linux-*_${KDEB_PKGVERSION}_*.deb

