#!/bin/sh

#LINUX_GCC=gcc-4.8
#LINUX_GCC=gcc-4.9
LINUX_GCC=gcc-6

apt-get --no-install-recommends install -y \
  devscripts

apt-get install -y \
  build-essential fakeroot \
  xsltproc \
  libconfig-general-perl \
  libfile-fcntllock-perl \
  \
  pkg-config \
  \
  autotools-dev cmake \
  autoconf automake autopoint comerr-dev libtool m4 quilt \
  bison flex libbison-dev \
  cdbs debhelper dh-autoreconf \
  krb5-multidev zlib1g-dev \
  \
  libperl-dev libglib2.0-dev libsysfs-dev libwrap0-dev \
  libaudit-dev libudev-dev \
  \
  libncurses5-dev \
  \
  kernel-wedge quilt lzma patchutils \
  \
  binutils-dev libdw-dev libelf-dev libnewt-dev \
  \
  dh-exec libssl-dev \
  libpci-dev \
  \
  python-dev python-six

apt-get --no-install-recommends install -y \
  asciidoc xmlto

apt-get install -y \
  dh-systemd \
  libiberty-dev \
  libunwind8-dev \
  libbabeltrace-dev libbabeltrace-ctf-dev

#apt-get install -y python-sphinx

#apt-get install -y python-sphinx-rtd-theme || true

apt-get install -y bc zip

if ! apt-get install -y ${LINUX_GCC} ${LINUX_GCC/gcc/cpp} ; then
  LINUX_GCC=gcc-5
  echo "Switching to ${LINUX_GCC}"
  apt-get install -y ${LINUX_GCC} ${LINUX_GCC/gcc/cpp}
fi

CROSS_GCC=
CROSS_DEBARCH=
if [ "X`uname -m`" != "Xarmv7l" ]; then
  CROSS_GCC=-arm-linux-gnueabihf
  CROSS_DEBARCH=-armhf-cross
fi

apt-get install \
  gcc${CROSS_GCC} \
  binutils${CROSS_GCC} \
  cpp${CROSS_GCC}

apt-get install \
  libc6-dev${CROSS_DEBARCH} \
  linux-libc-dev${CROSS_DEBARCH}

echo OK

