#!/bin/sh
ARCH=`dpkg --print-architecture`

tar -xzf arduino_1.8.19.orig.tar.gz && \
mv arduino-1.8.19 arduino-1.8.19-1dfsg3 && \
cd arduino-1.8.19-1dfsg3 && \
tar -xJf ../arduino_1.0.5+dfsg2-4.debian.tar.xz

#cp -ap ../arduino-1.0.5+dfsg2/debian .

cp -p ../patches/arduino-1.8.19-remove_update_warning.patch debian/patches/remove_update_warning.patch && \
cp -p ../patches/arduino-1.8.19-install_jar_links.patch debian/patches/install_jar_links.patch && \
cp -p ../patches/arduino-1.8.x-wrapper_for_deb.patch debian/patches/wrapper_for_deb.patch && \
cp -p ../patches/arduino-1.8.x-permission_fix.patch debian/patches/permission_fix.patch && \
cp -p ../patches/arduino-1.8.x-remove_copying_binaries.patch debian/patches/remove_copying_binaries.patch

cp -p ../patches/arduino-1.8.1x-remove_macosx.patch debian/patches/remove_macosx.patch && \
echo "remove_macosx.patch" >> debian/patches/series

sed -i s/'gcc47_avr.patch'/''/g debian/patches/series && \
sed -i s/'no-caller-saves.patch'/''/g debian/patches/series && \
sed -i s/'Adafruit_GFX.patch'/''/g debian/patches/series && \
sed -i s/'const_progmem.patch'/''/g debian/patches/series && \
sed -i s/'depricated_typedef_support.patch'/''/g debian/patches/series && \
sed -i s/'roboIRread.patch'/''/g debian/patches/series

patch -p1 < ../patches/arduino-1.8.x-debian-arduino-builder.patch && \
patch -p1 < ../patches/arduino-1.8.x-debian-rules.patch && \
patch -p1 < ../patches/arduino-1.8.x-debian-rules-no-dh_strip_nondeterminism.patch && \
patch -p1 < ../patches/arduino-1.8.x-debian-rules-no-dh_strip.patch

patch -p1 < ../patches/arduino-1.8.x-debian-control.patch && \
patch -p1 < ../patches/arduino-1.8.x-debian-arduino-avr.patch

patch -p1 < ../patches/arduino-1.8.10-no-avr-share.patch

sed -i s/'remove_copying_binaries.patch'/''/g debian/patches/series

#sed -i s/'default-jdk'/'openjdk-8-jdk'/g debian/control && \
#sed -i s/'default-jre'/'openjdk-8-jre'/g debian/control && \

sed -i 's|arduino/bootloaders/optiboot|arduino/avr/bootloaders/optiboot|g' debian/rules && \
sed -i 's|reference/\*.html|reference/*/*.html|g' debian/rules && \
sed -i 's|/usr/bin /usr/share/arduino/hardware/tools/avr/bin||g' debian/arduino-core.links && \
sed -i 's|/usr/lib /usr/share/arduino/hardware/tools/avr/lib||g' debian/arduino-core.links

patch -p1 < ../patches/arduino-1.8.x-debian-rules-replace-jar.patch
patch -p1 < ../patches/arduino-1.8.1x-fix-favicon-links-remove.patch

sed -i s/'arduino-1\.8\..*-linux'/'arduino-1.8.19-linux'/g debian/rules

if [ $ARCH = amd64 ]; then
  sed -i s/'Architecture: armhf'/'Architecture: amd64'/g debian/control
  sed -i s/armv7l-unknown-linux-gnueabihf/x86_64-pc-linux-gnu/g debian/rules
  sed -i s/armv7l-unknown-linux-gnueabihf/x86_64-pc-linux-gnu/g debian/arduino-avr.install
elif [ $ARCH = i386 ]; then
  sed -i s/'Architecture: armhf'/'Architecture: i386'/g debian/control
  sed -i s/armv7l-unknown-linux-gnueabihf/i686-pc-linux-gnu/g debian/rules
  sed -i s/armv7l-unknown-linux-gnueabihf/i686-pc-linux-gnu/g debian/arduino-avr.install
elif [ $ARCH = aarch64 -o $ARCH = arm64 ]; then
  sed -i s/'Architecture: armhf'/'Architecture: arm64'/g debian/control
  sed -i s/armv7l-unknown-linux-gnueabihf/aarch64-unknown-linux-gnu/g debian/rules
  sed -i s/armv7l-unknown-linux-gnueabihf/aarch64-unknown-linux-gnu/g debian/arduino-avr.install
elif [ $ARCH = armhf ]; then
  sed -i s/armv7l-unknown-linux-gnueabihf/arm-linux-gnueabihf/g debian/rules
  sed -i s/armv7l-unknown-linux-gnueabihf/arm-linux-gnueabihf/g debian/arduino-avr.install
fi

if [ ! -e ../arduino-1.8.19-linux/reference ]; then
  sed -i /reference/d debian/arduino-core.docs
  sed -i /arduino-core.reference/d debian/rules
fi

patch -p1 < ../patches/arduino-1.8.19-no-WiFi101-manifest.patch
patch -p1 < ../patches/arduino-1.8.19-deb-arch.patch

#echo "build/linux/work/arduino-builder usr/share/arduino" >> debian/arduino.install
#echo "build/linux/work/tools-builder usr/share/arduino" >> debian/arduino.install

DEBFULLNAME=SCP DEBEMAIL=scp@build.local debchange --newversion 2:1.8.19-1dfsg3

echo OK
