<?php
/**
 * This file is part of OpenMediaVault.
 *
 * @license   http://www.gnu.org/licenses/gpl.html GPL Version 3
 * @author    Volker Theile <volker.theile@openmediavault.org>
 * @copyright Copyright (c) 2009-2016 Volker Theile
 *
 * OpenMediaVault is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * OpenMediaVault is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenMediaVault. If not, see <http://www.gnu.org/licenses/>.
 */
namespace OMV\System\Health;

require_once("openmediavault/functions.inc");

/**
 * Helper class that provides various functions regarding the Linux system.
 * @ingroup api
 */
class Health {
	public static function getCpuTemp() {
		$cmdArgs = [];
		$cmdArgs[] = "-y";
		$cmdArgs[] = "0x0";
		$cmdArgs[] = "0x0a";
		$cmdArgs[] = "0x07";
		$cmd = new \OMV\System\Process("i2cget", $cmdArgs);
		$cmd->setRedirect2to1();
		$cmd->execute($output);

		$outval = filter_var($output[0], FILTER_VALIDATE_INT, FILTER_FLAG_ALLOW_HEX);

		if (false === $outval) {
			return 'unknown';
		} else {
			//$outval = $output[0] + 0;
			//$outval = $output[0];
			return $outval . ' °C';
		}
	}

	public static function getFanSpeed() {
		$cmdArgs = [];
		$cmdArgs[] = "-y";
		$cmdArgs[] = "0x0";
		$cmdArgs[] = "0x0a";
		$cmdArgs[] = "0x08";
		$cmd = new \OMV\System\Process("i2cget", $cmdArgs);
		$cmd->setRedirect2to1();
		$cmd->execute($output);

		$outval = filter_var($output[0], FILTER_VALIDATE_INT, FILTER_FLAG_ALLOW_HEX);

		if (false === $outval) {
			return 'unknown';
		} else {
			$outval = round(60000 / ($outval + 0));
			//$outval = $output[0];
			return $outval . ' rpm';
		}
	}
}
