<?php
/**
 * This file is part of OpenMediaVault.
 *
 * @license   http://www.gnu.org/licenses/gpl.html GPL Version 3
 * @author    Volker Theile <volker.theile@openmediavault.org>
 * @copyright Copyright (c) 2009-2016 Volker Theile
 *
 * OpenMediaVault is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * OpenMediaVault is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with OpenMediaVault. If not, see <http://www.gnu.org/licenses/>.
 */
namespace OMV\System\Health;

require_once("openmediavault/functions.inc");

/**
 * Helper class that provides various functions regarding the Linux system.
 * @ingroup api
 */
class Health {
	public static function getCpuTemp() {
		$cmd = new \OMV\System\Process("i2cget", "-y", "0x0", "0x0a", "0x07");
		$cmd->setRedirect2to1();
		$cmd->execute($output);
		$outval = $output[0] + 0;
		return $outval . ' °C';
	}

	public static function getFanSpeed() {
		$cmd = new \OMV\System\Process("i2cget", "-y", "0x0", "0x0a", "0x08");
		$cmd->setRedirect2to1();
		$cmd->execute($output);
		$outval = round(60000 / ($output[0] + 0));
		return $outval . ' rpm';
	}
}
