#!/bin/sh

. /etc/debian-build.conf

#mount none /proc -t proc

[ -e /proc/mounts ] && ln -sf /proc/mounts /etc/mtab

#mount none /sys -t sysfs
#mount none /dev/pts -t devpts

if [ ! -e /etc/.zy-first.done ]; then
  #sed -i s/'eth0'/'egiga0'/g /etc/network/interfaces
  #sed -i s/'eth1'/'egiga1'/g /etc/network/interfaces
  /etc/init.d/resolvconf stop
else
  killall dhcpcd
  ifconfig egiga0 0.0.0.0 down
  ifconfig egiga1 0.0.0.0 down
  ifconfig eth0 0.0.0.0 down
  ifconfig eth1 0.0.0.0 down
  ip link set dev egiga0 name eth0
  ip link set dev egiga1 name eth1
fi
#mkdir -p /mnt/partnerkey

[ -e /bin/systemd-tmpfiles ] && /bin/systemd-tmpfiles --create --remove --boot --exclude-prefix=/dev

/etc/init.d/networking start
/etc/init.d/hostname.sh start
/etc/init.d/resolvconf start
/etc/init.d/ssh restart
service sshd restart

rm -f /run/nologin

if [ ! -e /etc/.zy-first.done ]; then
  update-rc.d -f halt remove
  update-rc.d -f reboot remove
  update-rc.d -f sendsigs remove
  #update-rc.d -f umountfs remove
  update-rc.d -f umountroot remove

  ln -s `which nice` /bin/nice
  ln -s `which busybox` /sbin/watchdog

  if [ "${boardModel}" = "onboot" ]; then
    /usr/local/bin/zy-sysdisk-mount
  fi
fi

if [ ${imageMdMount} = true ]; then
  /usr/local/bin/start-md.sh
fi

for m in `cat /etc/fstab  | grep -v -E '^#' | cut -d " " -f 2 | grep -E '^/export|^/media'` ; do
  mkdir -p ${m}
done

mount -a

touch /tmp/.dru-hw-init.done

#telinit u
#/etc/init.d/rcS
/etc/init.d/rc 2

if [ ${imageMdMount} = true -a ${imageOmv} != true ]; then
  /usr/local/bin/mount-md.sh
fi

mkdir -p /run/sendsigs.omit.d

/etc/init.d/rpcbind restart
/etc/init.d/nfs-kernel-server restart
/etc/init.d/samba restart

