#ifndef _LINUX_SEM_H
#define _LINUX_SEM_H

#include <linux/atomic.h>
#include <linux/rcupdate.h>
#include <linux/cache.h>
#include <uapi/linux/sem.h>

struct task_struct;

/* One sem_array data structure for each set of semaphores in the system. */
struct sem_array {
	struct kern_ipc_perm	____cacheline_aligned_in_smp
				sem_perm;	/* permissions .. see ipc.h */
#if defined(CONFIG_SYNO_HI3536_ALIGN_STRUCTURES)
	time_t			sem_otime;	/* last semop time */
#endif /* CONFIG_SYNO_HI3536_ALIGN_STRUCTURES */
	time_t			sem_ctime;	/* last change time */
	struct sem		*sem_base;	/* ptr to first semaphore in array */
	struct list_head	pending_alter;	/* pending operations */
						/* that alter the array */
#if defined(CONFIG_SYNO_HI3536_ALIGN_STRUCTURES)
	// do nothing
#else /* CONFIG_SYNO_HI3536_ALIGN_STRUCTURES */
	struct list_head	pending_const;	/* pending complex operations */
						/* that do not alter semvals */
#endif /* CONFIG_SYNO_HI3536_ALIGN_STRUCTURES */
	struct list_head	list_id;	/* undo requests on this array */
	int			sem_nsems;	/* no. of semaphores in array */
	int			complex_count;	/* pending complex operations */
#if defined(CONFIG_SYNO_HI3536_ALIGN_STRUCTURES)
	struct list_head	pending_const;	/* pending complex operations */
						/* that do not alter semvals */
#endif /* CONFIG_SYNO_HI3536_ALIGN_STRUCTURES */
};

#ifdef CONFIG_SYSVIPC

struct sysv_sem {
	struct sem_undo_list *undo_list;
};

extern int copy_semundo(unsigned long clone_flags, struct task_struct *tsk);
extern void exit_sem(struct task_struct *tsk);

#else

struct sysv_sem {
	/* empty */
};

static inline int copy_semundo(unsigned long clone_flags, struct task_struct *tsk)
{
	return 0;
}

static inline void exit_sem(struct task_struct *tsk)
{
	return;
}
#endif

#endif /* _LINUX_SEM_H */
