/*****************************************************************************
  This is the driver for the CreVinn TOE-NK-2G TCP Offload Engine.
  TOE-NK-2G incorporates a Synopsys Ethernet MAC core.

  Copyright (C) 2011 Emutex Ltd. All rights reserved.

  This program is free software; you can redistribute it and/or modify it
  under the terms and conditions of the GNU General Public License,
  version 2, as published by the Free Software Foundation.

  This program is distributed in the hope it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along with
  this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.

  Authors: Dan O'Donovan <dan@emutex.com>

*******************************************************************************/

/*
 *  TNK hardware register map
 */

#ifndef __TNKHW_REGMAP_H__
#define __TNKHW_REGMAP_H__

/* Offsets in the overall register map for each logical block
 * Note that these are relative to a base I/O address which needs
 * to be mapped into kernel virtual memory using ioremap() or similar
 */

/* GMAC0 - Includes CSR's for the 3 channel DMA engine
 * and the MAC port 0 instance */
#define TNK_GMAC0_CSR_OFFSET         (0x00000)
/* GMAC1 - CSR's for MAC port 1 instance only */
#define TNK_GMAC1_CSR_OFFSET         (0x04000)
/* TOENK Engine CSRs */
#define TNK_ENGINE_CSR_OFFSET        (0x08000)
/* TOENK System CSRs */
#define TNK_SYSTEM_CSR_OFFSET        (0x09000)
/* TOE Rx DB table */
#define TNK_DMA_RX_DB_OFFSET		(0x0E000)
/* TOE transmit descriptor database */
#define TNK_DMA_TTX_DB_OFFSET        (0x10000)
/* TOE transmit statistics per channel */
#define TNK_DMA_TTX_DB_TXSTAT_OFFSET (0x18000)
/* TOE receive statistics per channel */
#define TNK_DMA_TTX_DB_RXSTAT_OFFSET (0x1C000)
/* TOE transmit DMA engine CSRs */
#define TNK_DMA_TTX_DB_CSR_OFFSET    (0x1E000)

/* Connection Table access registers */
#define TNK_REG_CT_CPU_WRADDR          \
	(TNK_ENGINE_CSR_OFFSET + 0x000) /* RW */
#define TNK_REG_CT_CPU_RDADDR          \
	(TNK_ENGINE_CSR_OFFSET + 0x004) /* RW */
#define TNK_REG_CT_CPU_WRDATA          \
	(TNK_ENGINE_CSR_OFFSET + 0x008) /* RW */
#define TNK_REG_CT_CPU_RDDATA          \
	(TNK_ENGINE_CSR_OFFSET + 0x00C) /* RO */
#define TNK_REG_CT_CPU_ACSTAT          \
	(TNK_ENGINE_CSR_OFFSET + 0x010) /* RO */
#define TNK_REG_CT_CPU_WRMASK          \
	(TNK_ENGINE_CSR_OFFSET + 0x014) /* RW */

/* Tx/Rx Engine configuration registers */
#define TNK_REG_CT_LOCAL_MACADDR0_U16   \
	(TNK_ENGINE_CSR_OFFSET + 0x100) /* RW */
#define TNK_REG_CT_LOCAL_MACADDR0_L32   \
	(TNK_ENGINE_CSR_OFFSET + 0x104) /* RW */
#define TNK_REG_CT_LOCAL_IPADDR0        \
	(TNK_ENGINE_CSR_OFFSET + 0x108) /* RW */
#define TNK_REG_CT_REMOTE_IPADDR        \
	(TNK_ENGINE_CSR_OFFSET + 0x120) /* RW */
#define TNK_REG_CT_TCP_PORTS            \
	(TNK_ENGINE_CSR_OFFSET + 0x124) /* RW */
#define TNK_REG_CT_CONN_CTRL            \
	(TNK_ENGINE_CSR_OFFSET + 0x128) /* RW */
#define TNK_REG_TOE_INTR_STAT           \
	(TNK_ENGINE_CSR_OFFSET + 0x13C) /* RW */
#define TNK_REG_TOE_INTR_EN             \
	(TNK_ENGINE_CSR_OFFSET + 0x140) /* RW */
#define TNK_REG_TOE_CTRL0               \
	(TNK_ENGINE_CSR_OFFSET + 0x144) /* RW */
#define TNK_REG_TOE_CTRL1               \
	(TNK_ENGINE_CSR_OFFSET + 0x148) /* RW */
#define TNK_REG_TOE_CTRL2               \
	(TNK_ENGINE_CSR_OFFSET + 0x14C) /* RW */
#define TNK_REG_TOE_CONFIG0             \
	(TNK_ENGINE_CSR_OFFSET + 0x150) /* RW */
#define TNK_REG_CT_LOCAL_MACADDR1_U16   \
	(TNK_ENGINE_CSR_OFFSET + 0x154) /* RW */
#define TNK_REG_CT_LOCAL_MACADDR1_L32   \
	(TNK_ENGINE_CSR_OFFSET + 0x158) /* RW */
#define TNK_REG_CT_LOCAL_IPADDR1        \
	(TNK_ENGINE_CSR_OFFSET + 0x15C) /* RW */
#define TNK_REG_CT_LOCAL_IPV6_ADDR0_W0  \
	(TNK_ENGINE_CSR_OFFSET + 0x160) /* RW */
#define TNK_REG_CT_LOCAL_IPV6_ADDR0_W1  \
	(TNK_ENGINE_CSR_OFFSET + 0x164) /* RW */
#define TNK_REG_CT_LOCAL_IPV6_ADDR0_W2  \
	(TNK_ENGINE_CSR_OFFSET + 0x168) /* RW */
#define TNK_REG_CT_LOCAL_IPV6_ADDR0_W3  \
	(TNK_ENGINE_CSR_OFFSET + 0x16C) /* RW */
#define TNK_REG_CT_LOCAL_IPV6_ADDR1_W0  \
	(TNK_ENGINE_CSR_OFFSET + 0x170) /* RW */
#define TNK_REG_CT_LOCAL_IPV6_ADDR1_W1  \
	(TNK_ENGINE_CSR_OFFSET + 0x174) /* RW */
#define TNK_REG_CT_LOCAL_IPV6_ADDR1_W2  \
	(TNK_ENGINE_CSR_OFFSET + 0x178) /* RW */
#define TNK_REG_CT_LOCAL_IPV6_ADDR1_W3  \
	(TNK_ENGINE_CSR_OFFSET + 0x17C) /* RW */
#define TNK_REG_CT_REMOTE_IPV6_ADDR_W0  \
	(TNK_ENGINE_CSR_OFFSET + 0x180) /* RW */
#define TNK_REG_CT_REMOTE_IPV6_ADDR_W1  \
	(TNK_ENGINE_CSR_OFFSET + 0x184) /* RW */
#define TNK_REG_CT_REMOTE_IPV6_ADDR_W2  \
	(TNK_ENGINE_CSR_OFFSET + 0x188) /* RW */
#define TNK_REG_CT_REMOTE_IPV6_ADDR_W3  \
	(TNK_ENGINE_CSR_OFFSET + 0x18C) /* RW */
#define TNK_REG_TOE_SWITCH_CTRL	\
	(TNK_ENGINE_CSR_OFFSET + 0x1C0) /* RW */
#define TNK_REG_TOE_SWITCH_CTRL_V220 \
	(TNK_ENGINE_CSR_OFFSET + 0x1C4) /* RW */
#define TNK_REG_TOE_DUP_ACK_CNT \
	(TNK_ENGINE_CSR_OFFSET + 0x1C8) /* RW */
#define TNK_REG_CT_ACK_CMD_REQ \
	(TNK_ENGINE_CSR_OFFSET + 0x1CC) /* RW */
#define TNK_REG_TOE_BONDING_CTRL	\
	(TNK_ENGINE_CSR_OFFSET + 0x1d0) /* RW */
#define TNK_REG_CT_TXADVWND_SCALE	\
	(TNK_ENGINE_CSR_OFFSET + 0x1d4) /* RW */
#define TNK_REG_CT_PROBE_INTR	\
	(TNK_ENGINE_CSR_OFFSET + 0x1d8) /* RC */
#define TNK_REG_CT_FIN_SEND_STATE \
	(TNK_ENGINE_CSR_OFFSET + 0x1dc) /* RW */
#define TNK_REG_CT_ZERO_PROBE_CNT \
	(TNK_ENGINE_CSR_OFFSET + 0x1f8) /* RW */
#define TNK_REG_CT_PORT0_VLANTAG0   \
	(TNK_ENGINE_CSR_OFFSET + 0x280) /* RW */
#define TNK_REG_CT_PORT0_VLANTAG1   \
	(TNK_ENGINE_CSR_OFFSET + 0x284) /* RW */
#define TNK_REG_CT_PORT0_VLANTAG2   \
	(TNK_ENGINE_CSR_OFFSET + 0x288) /* RW */
#define TNK_REG_CT_PORT0_VLANTAG3   \
	(TNK_ENGINE_CSR_OFFSET + 0x28c) /* RW */
#define TNK_REG_CT_PORT1_VLANTAG0   \
	(TNK_ENGINE_CSR_OFFSET + 0x290) /* RW */
#define TNK_REG_CT_PORT1_VLANTAG1   \
	(TNK_ENGINE_CSR_OFFSET + 0x294) /* RW */
#define TNK_REG_CT_PORT1_VLANTAG2   \
	(TNK_ENGINE_CSR_OFFSET + 0x298) /* RW */
#define TNK_REG_CT_PORT1_VLANTAG3   \
	(TNK_ENGINE_CSR_OFFSET + 0x29c) /* RW */
#define TNK_REG_CT_LOCAL0_MACADDR1_U16   \
	(TNK_ENGINE_CSR_OFFSET + 0x2c8) /* RW */
#define TNK_REG_CT_LOCAL0_MACADDR1_L32   \
	(TNK_ENGINE_CSR_OFFSET + 0x2cc) /* RW */
#define TNK_REG_CT_LOCAL0_MACADDR2_U16   \
	(TNK_ENGINE_CSR_OFFSET + 0x2d0) /* RW */
#define TNK_REG_CT_LOCAL0_MACADDR2_L32   \
	(TNK_ENGINE_CSR_OFFSET + 0x2d4) /* RW */
#define TNK_REG_CT_LOCAL0_MACADDR3_U16   \
	(TNK_ENGINE_CSR_OFFSET + 0x2d8) /* RW */
#define TNK_REG_CT_LOCAL0_MACADDR3_L32   \
	(TNK_ENGINE_CSR_OFFSET + 0x2dc) /* RW */
#define TNK_REG_CT_LOCAL1_MACADDR1_U16   \
	(TNK_ENGINE_CSR_OFFSET + 0x2e8) /* RW */
#define TNK_REG_CT_LOCAL1_MACADDR1_L32   \
	(TNK_ENGINE_CSR_OFFSET + 0x2ec) /* RW */
#define TNK_REG_CT_LOCAL1_MACADDR2_U16   \
	(TNK_ENGINE_CSR_OFFSET + 0x2f0) /* RW */
#define TNK_REG_CT_LOCAL1_MACADDR2_L32   \
	(TNK_ENGINE_CSR_OFFSET + 0x2f4) /* RW */
#define TNK_REG_CT_LOCAL1_MACADDR3_U16   \
	(TNK_ENGINE_CSR_OFFSET + 0x2f8) /* RW */
#define TNK_REG_CT_LOCAL1_MACADDR3_L32   \
	(TNK_ENGINE_CSR_OFFSET + 0x2fc) /* RW */
#define TNK_REG_CT_LOCAL_IPADDR_SEL     \
	(TNK_ENGINE_CSR_OFFSET + 0x300) /* RW */
#define TNK_REG_CT_LOCAL_IPADDR0_1      \
	(TNK_ENGINE_CSR_OFFSET + 0x304) /* RW */
#define TNK_REG_CT_LOCAL_IPADDR0_2      \
	(TNK_ENGINE_CSR_OFFSET + 0x308) /* RW */
#define TNK_REG_CT_LOCAL_IPADDR0_3      \
	(TNK_ENGINE_CSR_OFFSET + 0x30c) /* RW */
#define TNK_REG_CT_LOCAL_IPV6_ADDR0_W0_1	\
	(TNK_ENGINE_CSR_OFFSET + 0x310) /* RW */
#define TNK_REG_CT_LOCAL_IPV6_ADDR0_W1_1	\
	(TNK_ENGINE_CSR_OFFSET + 0x314) /* RW */
#define TNK_REG_CT_LOCAL_IPV6_ADDR0_W2_1	\
	(TNK_ENGINE_CSR_OFFSET + 0x318) /* RW */
#define TNK_REG_CT_LOCAL_IPV6_ADDR0_W3_1	\
	(TNK_ENGINE_CSR_OFFSET + 0x31c) /* RW */
#define TNK_REG_CT_LOCAL_IPV6_ADDR0_W0_2	\
	(TNK_ENGINE_CSR_OFFSET + 0x320) /* RW */
#define TNK_REG_CT_LOCAL_IPV6_ADDR0_W1_2	\
	(TNK_ENGINE_CSR_OFFSET + 0x324) /* RW */
#define TNK_REG_CT_LOCAL_IPV6_ADDR0_W2_2	\
	(TNK_ENGINE_CSR_OFFSET + 0x328) /* RW */
#define TNK_REG_CT_LOCAL_IPV6_ADDR0_W3_2	\
	(TNK_ENGINE_CSR_OFFSET + 0x32c) /* RW */
#define TNK_REG_CT_LOCAL_IPV6_ADDR0_W0_3	\
	(TNK_ENGINE_CSR_OFFSET + 0x330) /* RW */
#define TNK_REG_CT_LOCAL_IPV6_ADDR0_W1_3	\
	(TNK_ENGINE_CSR_OFFSET + 0x334) /* RW */
#define TNK_REG_CT_LOCAL_IPV6_ADDR0_W2_3	\
	(TNK_ENGINE_CSR_OFFSET + 0x338) /* RW */
#define TNK_REG_CT_LOCAL_IPV6_ADDR0_W3_3	\
	(TNK_ENGINE_CSR_OFFSET + 0x33c) /* RW */
#define TNK_REG_CT_LOCAL_IPADDR1_1		\
	(TNK_ENGINE_CSR_OFFSET + 0x344) /* RW */
#define TNK_REG_CT_LOCAL_IPADDR1_2		\
	(TNK_ENGINE_CSR_OFFSET + 0x348) /* RW */
#define TNK_REG_CT_LOCAL_IPADDR1_3		\
	(TNK_ENGINE_CSR_OFFSET + 0x34c) /* RW */
#define TNK_REG_CT_LOCAL_IPV6_ADDR1_W0_1	\
	(TNK_ENGINE_CSR_OFFSET + 0x350) /* RW */
#define TNK_REG_CT_LOCAL_IPV6_ADDR1_W1_1	\
	(TNK_ENGINE_CSR_OFFSET + 0x354) /* RW */
#define TNK_REG_CT_LOCAL_IPV6_ADDR1_W2_1	\
	(TNK_ENGINE_CSR_OFFSET + 0x358) /* RW */
#define TNK_REG_CT_LOCAL_IPV6_ADDR1_W3_1	\
	(TNK_ENGINE_CSR_OFFSET + 0x35c) /* RW */
#define TNK_REG_CT_LOCAL_IPV6_ADDR1_W0_2	\
	(TNK_ENGINE_CSR_OFFSET + 0x360) /* RW */
#define TNK_REG_CT_LOCAL_IPV6_ADDR1_W1_2	\
	(TNK_ENGINE_CSR_OFFSET + 0x364) /* RW */
#define TNK_REG_CT_LOCAL_IPV6_ADDR1_W2_2	\
	(TNK_ENGINE_CSR_OFFSET + 0x368) /* RW */
#define TNK_REG_CT_LOCAL_IPV6_ADDR1_W3_2	\
	(TNK_ENGINE_CSR_OFFSET + 0x36c) /* RW */
#define TNK_REG_CT_LOCAL_IPV6_ADDR1_W0_3	\
	(TNK_ENGINE_CSR_OFFSET + 0x370) /* RW */
#define TNK_REG_CT_LOCAL_IPV6_ADDR1_W1_3	\
	(TNK_ENGINE_CSR_OFFSET + 0x374) /* RW */
#define TNK_REG_CT_LOCAL_IPV6_ADDR1_W2_3	\
	(TNK_ENGINE_CSR_OFFSET + 0x378) /* RW */
#define TNK_REG_CT_LOCAL_IPV6_ADDR1_W3_3	\
	(TNK_ENGINE_CSR_OFFSET + 0x37c) /* RW */
#define TNK_REG_CT_LOCAL_IPADDR_INDEX_SEL	\
	(TNK_ENGINE_CSR_OFFSET + 0x380) /* RW */

/* TCP/UDP Connection configuration registers */
#define TNK_REG_CT_TCP_MSS             (TNK_ENGINE_CSR_OFFSET + 0x118) /* RW */
#define TNK_REG_CT_RTT_STATUS          (TNK_ENGINE_CSR_OFFSET + 0x11C) /* RO */

/* TCP/UDP Connection status registers */

/* TNK System interrupt registers */
#define TNK_REG_INTR_STAT              (TNK_SYSTEM_CSR_OFFSET + 0x000) /* RO */
#define TNK_REG_INTR_EN                (TNK_SYSTEM_CSR_OFFSET + 0x004) /* RW */
#define TNK_REG_RESET_STAT             (TNK_SYSTEM_CSR_OFFSET + 0x008) /* RW */
#define TNK_REG_ID                     (TNK_SYSTEM_CSR_OFFSET + 0x00C) /* RW */
#define TNK_REG_INTR1_STAT		(TNK_SYSTEM_CSR_OFFSET + 0x010) /* RO */
#define TNK_REG_INTR1_EN		(TNK_SYSTEM_CSR_OFFSET + 0x014) /* RW */
#define TNK_REG_INTR2_STAT              (TNK_SYSTEM_CSR_OFFSET + 0x018) /* RO */
#define TNK_REG_INTR2_EN                (TNK_SYSTEM_CSR_OFFSET + 0x01C) /* RW */
#define TNK_REG_INTR3_STAT              (TNK_SYSTEM_CSR_OFFSET + 0x020) /* RO */
#define TNK_REG_INTR3_EN                (TNK_SYSTEM_CSR_OFFSET + 0x024) /* RW */
#define TNK_REG_AHB_DEBUG_OUT          (TNK_SYSTEM_CSR_OFFSET + 0x100) /* RW */
#define TNK_REG_AHB_DEBUG_IN           (TNK_SYSTEM_CSR_OFFSET + 0x120) /* RW */

/* TNK DMA TTX registers */
#define TNK_REG_DMA_TTX_CTRL0 \
	(TNK_DMA_TTX_DB_CSR_OFFSET + 0x000) /* RW */
#define TNK_REG_DMA_TTX_ADD_SIZE \
	(TNK_DMA_TTX_DB_CSR_OFFSET + 0x004) /* RW */
#define TNK_REG_DMA_TTX_ADD \
	(TNK_DMA_TTX_DB_CSR_OFFSET + 0x008) /* RW */
#define TNK_REG_DMA_TTX_ACKD_CID \
	(TNK_DMA_TTX_DB_CSR_OFFSET + 0x00C) /* RO */
#define TNK_REG_DMA_TTX_ERR_STATUS \
	(TNK_DMA_TTX_DB_CSR_OFFSET + 0x010) /* RO */
#define TNK_REG_DMA_TTX_DFETCH_ERR_CID \
	(TNK_DMA_TTX_DB_CSR_OFFSET + 0x014) /* RO */
#define TNK_REG_DMA_TTX_RETRY_ERR_CID \
	(TNK_DMA_TTX_DB_CSR_OFFSET + 0x018) /* RO */
#define TNK_REG_DMA_TTX_ACKD_ERR_CID \
	(TNK_DMA_TTX_DB_CSR_OFFSET + 0x01C) /* RO */
#define TNK_REG_DMA_TRX_CTRL \
	(TNK_DMA_TTX_DB_CSR_OFFSET + 0x020) /* RW */
#define TNK_REG_DMA_TRX_ADD_SIZE \
	(TNK_DMA_TTX_DB_CSR_OFFSET + 0x024) /* RW */
#define TNK_REG_DMA_TTX_ALT_REQ \
	(TNK_DMA_TTX_DB_CSR_OFFSET + 0x028) /* RW */
#define TNK_REG_DMA_TTX_ACK_IRQ \
	(TNK_DMA_TTX_DB_CSR_OFFSET + 0x064) /* RW */
#define TNK_REG_DMA_TTX_ACKD1_CID \
	(TNK_DMA_TTX_DB_CSR_OFFSET + 0x18C) /* RO */
#define TNK_REG_DMA_TTX_ACKD2_CID \
	(TNK_DMA_TTX_DB_CSR_OFFSET + 0x190) /* RO */
#define TNK_REG_DMA_TTX_ACKD3_CID \
	(TNK_DMA_TTX_DB_CSR_OFFSET + 0x194) /* RO */
#define TNK_REG_DMA_RXF_DB_RD_ACT \
	(TNK_DMA_TTX_DB_CSR_OFFSET + 0x1a0) /* RW */
#define TNK_REG_DMA_RXF_EXP_SEQNUM \
	(TNK_DMA_TTX_DB_CSR_OFFSET + 0x1a4) /* RW */
#define TNK_REG_DMA_RXF_TXWND_WR \
	(TNK_DMA_TTX_DB_CSR_OFFSET + 0x1a8) /* RW */
#define TNK_REG_DMA_TTX_RXFETCH_POLL \
	(TNK_DMA_TTX_DB_CSR_OFFSET + 0x1b0) /* RW */
#define TNK_REG_DMA_TTX_RXFETCH_ERR_CID \
	(TNK_DMA_TTX_DB_CSR_OFFSET + 0x1b4) /* RW */
#define TNK_REG_DMA_TIMER_BASE_CLK \
	(TNK_DMA_TTX_DB_CSR_OFFSET + 0x1c0) /* RW */
#define TNK_REG_DMA_TIMER_WATCHDOG \
	(TNK_DMA_TTX_DB_CSR_OFFSET + 0x1c4) /* RW */
#define TNK_REG_DMA_TIMER_CPU_CMD \
	(TNK_DMA_TTX_DB_CSR_OFFSET + 0x1d0) /* RW */
#define TNK_REG_DMA_TIMER_CPU_WDATA \
	(TNK_DMA_TTX_DB_CSR_OFFSET + 0x1d4) /* RW */
#define TNK_REG_DMA_TIMER_CPU_RDATA \
	(TNK_DMA_TTX_DB_CSR_OFFSET + 0x1d8) /* RW */
#define TNK_REG_DMA_RXINTR_CORE0 \
	(TNK_DMA_TTX_DB_CSR_OFFSET + 0x1e0) /* RW */
#define TNK_REG_DMA_RXINTR_CORE1 \
	(TNK_DMA_TTX_DB_CSR_OFFSET + 0x1e4) /* RW */
#define TNK_REG_DMA_RXINTR_CORE2 \
	(TNK_DMA_TTX_DB_CSR_OFFSET + 0x1e8) /* RW */
#define TNK_REG_DMA_RXINTR_CORE3 \
	(TNK_DMA_TTX_DB_CSR_OFFSET + 0x1ec) /* RW */
#define TNK_REG_DMA_BITMAP_RDCMD \
	(TNK_DMA_TTX_DB_CSR_OFFSET + 0x1f0) /* RW */
#define TNK_REG_DMA_BITMAP_RDATA \
	(TNK_DMA_TTX_DB_CSR_OFFSET + 0x1f4) /* RW */

/* WRADDR register fields */
#define TNK_OFFSET_CT_CPU_WRADDR_LOC       0
#define TNK_MASK_CT_CPU_WRADDR_LOC         0x0000001F
#define TNK_OFFSET_CT_CPU_WRADDR_CSEL      5
#define TNK_MASK_CT_CPU_WRADDR_CSEL        0x000007FF

/* RDADDR register fields */
#define TNK_OFFSET_CT_CPU_RDADDR_LOC       0
#define TNK_MASK_CT_CPU_RDADDR_LOC         0x0000001F
#define TNK_OFFSET_CT_CPU_RDADDR_CSEL      5
#define TNK_MASK_CT_CPU_RDADDR_CSEL        0x000007FF

/* ACSTAT register fields */
#define TNK_OFFSET_CT_CPU_ACSTAT_RDDONE    0
#define TNK_MASK_CT_CPU_ACSTAT_RDDONE      0x00000001
#define TNK_OFFSET_CT_CPU_ACSTAT_WRDONE    1
#define TNK_MASK_CT_CPU_ACSTAT_WRDONE      0x00000001

/* LOCAL_MACADDR_U16 register fields */
#define TNK_MASK_CT_LOCAL_MACADDR_U16      0x0000FFFF

/* TCP_MSS register fields */
#define TNK_MASK_CT_TCP_MSS                0x000007FF

/* TCP_PORTS register fields */
#define TNK_OFFSET_CT_TCP_PORTS_LOCAL      16
#define TNK_MASK_CT_TCP_PORTS_LOCAL        0x0000FFFF
#define TNK_OFFSET_CT_TCP_PORTS_REMOTE     0
#define TNK_MASK_CT_TCP_PORTS_REMOTE       0x0000FFFF

/* CONN_CTRL register fields */
#define TNK_OFFSET_CT_CONN_CTRL_ERR        16
#define TNK_MASK_CT_CONN_CTRL_ERR          0x00000001
#define TNK_OFFSET_CT_CONN_CTRL_IPV6       15
#define TNK_MASK_CT_CONN_CTRL_IPV6         0x00000001
#define TNK_OFFSET_CT_CONN_CTRL_CSEL       2
#define TNK_MASK_CT_CONN_CTRL_CSEL         0x000007FF
#define TNK_OFFSET_CT_CONN_CTRL_ADD        1
#define TNK_MASK_CT_CONN_CTRL_ADD          0x00000001
#define TNK_OFFSET_CT_CONN_CTRL_UPDATE     0
#define TNK_MASK_CT_CONN_CTRL_UPDATE       0x00000001

/* CONN_STAT register fields */
#define TNK_OFFSET_CT_CONN_STAT_RXDROPPED  31
#define TNK_MASK_CT_CONN_STAT_RXDROPPED    0x00000001
#define TNK_OFFSET_CT_CONN_STAT_INTR_VALID 11
#define TNK_MASK_CT_CONN_INTR_VALID        0x00000001
#define TNK_OFFSET_CT_CONN_STAT_CSEL       0
#define TNK_MASK_CT_CONN_STAT_CSEL         0x000007FF

/* TNK_INTR_STAT register fields */
#define TNK_OFFSET_INTR_STAT_DMA_TTX_ACK   0
#define TNK_MASK_INTR_STAT_DMA_TTX_ACK     0x00000001
#define TNK_OFFSET_INTR_STAT_DMA_TTX_ERR   1
#define TNK_MASK_INTR_STAT_DMA_TTX_ERR     0x00000001
#if defined(CONFIG_SYNO_LSP_HI3536_V2060)
#define TNK_INTR_STAT_GMAC0_DATA	BIT(2)
#define TNK_INTR_STAT_GMAC1_DATA	BIT(3)
#define TNK_OFFSET_INTR_STAT_DMA_CH2       4
#define TNK_MASK_INTR_STAT_DMA_CH2         0x00000001
#define TNK_INTR_STAT_GMAC0_CTRL	BIT(5)
#define TNK_INTR_STAT_GMAC1_CTRL	BIT(6)
#else /* CONFIG_SYNO_LSP_HI3536_V2060 */
#define TNK_OFFSET_INTR_STAT_DMA_CH0       2
#define TNK_MASK_INTR_STAT_DMA_CH0         0x00000001
#define TNK_OFFSET_INTR_STAT_DMA_CH1       3
#define TNK_MASK_INTR_STAT_DMA_CH1         0x00000001
#define TNK_OFFSET_INTR_STAT_DMA_CH2       4
#define TNK_MASK_INTR_STAT_DMA_CH2         0x00000001
#define TNK_OFFSET_INTR_STAT_GMAC0         5
#define TNK_MASK_INTR_STAT_GMAC0           0x00000001
#define TNK_OFFSET_INTR_STAT_GMAC1         6
#define TNK_MASK_INTR_STAT_GMAC1           0x00000001
#endif /* CONFIG_SYNO_LSP_HI3536_V2060 */
#define TNK_OFFSET_INTR_STAT_TOE           7
#define TNK_MASK_INTR_STAT_TOE             0x00000001
#define TNK_OFFSET_INTR_STAT_TTX_ACK1		8
#define TNK_MASK_INTR_STAT_TTX_ACK1		0x1
#define TNK_OFFSET_INTR_STAT_TTX_ACK2		9
#define TNK_MASK_INTR_STAT_TTX_ACK2		0x1
#define TNK_OFFSET_INTR_STAT_TTX_ACK3		10
#define TNK_MASK_INTR_STAT_TTX_ACK3		0x1
#define TNK_OFFSET_INTR_STAT_RX1		11
#define TNK_MASK_INTR_STAT_RX1			0x1
#define TNK_OFFSET_INTR_STAT_RX2		12
#define TNK_MASK_INTR_STAT_RX2			0x1
#define TNK_OFFSET_INTR_STAT_RX3		13
#define TNK_MASK_INTR_STAT_RX3			0x1
#define TNK_OFFSET_INTR_RX_LRO0			14
#define TNK_MASK_INTR_RX_LRO0			0x1
#define TNK_OFFSET_INTR_RX_LRO1			15
#define TNK_MASK_INTR_RX_LRO1			0x1
#define TNK_OFFSET_INTR_RX_LRO2			16
#define TNK_MASK_INTR_RX_LRO2			0x1
#define TNK_OFFSET_INTR_RX_LRO3			17
#define TNK_MASK_INTR_RX_LRO3			0x1
#if defined(CONFIG_SYNO_LSP_HI3536_V2060)
#define TNK_INTR_GROUP_GMAC0 \
	(TNK_INTR_STAT_GMAC0_DATA | TNK_INTR_STAT_GMAC0_CTRL)
#define TNK_INTR_GROUP_GMAC1 \
	(TNK_INTR_STAT_GMAC1_DATA | TNK_INTR_STAT_GMAC1_CTRL)
#endif /* CONFIG_SYNO_LSP_HI3536_V2060 */

/* TNK_INTR_STAT register mask */
#if defined(CONFIG_SYNO_LSP_HI3536_V2060)
#define TNK_MASK_INTR		(0x000000b7 | \
				(1 << TNK_OFFSET_INTR_RX_LRO0))
#define TNK_MASK_INTR1		((1 << TNK_OFFSET_INTR_STAT_TTX_ACK1) | \
				(1 << TNK_OFFSET_INTR_STAT_RX1) | \
				(1 << TNK_OFFSET_INTR_RX_LRO1) | \
				TNK_INTR_GROUP_GMAC1)
#else /* CONFIG_SYNO_LSP_HI3536_V2060 */
#define TNK_MASK_INTR		(0x000000ff | \
				(1 << TNK_OFFSET_INTR_RX_LRO0))
#define TNK_MASK_INTR1		((1 << TNK_OFFSET_INTR_STAT_TTX_ACK1) | \
				(1 << TNK_OFFSET_INTR_STAT_RX1) | \
				(1 << TNK_OFFSET_INTR_RX_LRO1))
#endif /* CONFIG_SYNO_LSP_HI3536_V2060 */
#define TNK_MASK_INTR2		((1 << TNK_OFFSET_INTR_STAT_TTX_ACK2) | \
				(1 << TNK_OFFSET_INTR_STAT_RX2) | \
				(1 << TNK_OFFSET_INTR_RX_LRO2))
#define TNK_MASK_INTR3		((1 << TNK_OFFSET_INTR_STAT_TTX_ACK3) | \
				(1 << TNK_OFFSET_INTR_STAT_RX3) | \
				(1 << TNK_OFFSET_INTR_RX_LRO3))

/* TNK_INTR_EN register fields */
#define TNK_OFFSET_INTR_EN_DMA_TTX_ACK   0
#define TNK_MASK_INTR_EN_DMA_TTX_ACK     0x00000001
#define TNK_OFFSET_INTR_EN_DMA_TTX_ERR   1
#define TNK_MASK_INTR_EN_DMA_TTX_ERR     0x00000001
#define TNK_OFFSET_INTR_EN_DMA_CH0       2
#define TNK_MASK_INTR_EN_DMA_CH0         0x00000001
#define TNK_OFFSET_INTR_EN_DMA_CH1       3
#define TNK_MASK_INTR_EN_DMA_CH1         0x00000001
#define TNK_OFFSET_INTR_EN_DMA_CH2       4
#define TNK_MASK_INTR_EN_DMA_CH2         0x00000001
#define TNK_OFFSET_INTR_EN_GMAC0         5
#define TNK_MASK_INTR_EN_GMAC0           0x00000001
#define TNK_OFFSET_INTR_EN_GMAC1         6
#define TNK_MASK_INTR_EN_GMAC1           0x00000001
#define TNK_OFFSET_INTR_EN_TOE           7
#define TNK_MASK_INTR_EN_TOE             0x00000001

/* TOE_CTRL1 register fields */
#define TNK_OFFSET_CTRL1_PERSISTCOUNT    0
#define TNK_MASK_CTRL1_PERSISTCOUNT      0x000000FF

/* TOE_CONFIG0 register fields */
#define TNK_OFFSET_CONFIG0_PROMISCMODE    0
#define TNK_MASK_CONFIG0_PROMISCMODE      0x00000001
#define TNK_OFFSET_CONFIG0_RXBYPASSMODE   1
#define TNK_MASK_CONFIG0_RXBYPASSMODE     0x00000001
#define TNK_OFFSET_CONFIG0_IPV6_EN        2
#define TNK_MASK_CONFIG0_IPV6_EN          0x00000001
#define TNK_OFFSET_CONFIG0_VLAN_EN        3
#define TNK_MASK_CONFIG0_VLAN_EN          0x00000001
#define TNK_OFFSET_CONFIG0_CONG_WIN_EN    4
#define TNK_MASK_CONFIG0_CONG_WIN_EN      0x00000001
#define TNK_OFFSET_CONFIG0_FORCE_RD_CT    5
#define TNK_MASK_CONFIG0_FORCE_RD_CT      0x00000001
#define TNK_OFFSET_CONFIG0_MAC_SPACE_CHK  6
#define TNK_MASK_CONFIG0_MAC_SPACE_CHK    0x00000001
#define TNK_OFFSET_THIN_LINEAR_TIMEOUTS		8
#define TNK_MASK_THIN_LINEAR_TIMEOUTS		0x1

/* TNK_ID register fields */
#define TNK_OFFSET_ID_MAX_CONNECTIONS    0
#define TNK_MASK_ID_MAX_CONNECTIONS      0x0000FFFF
#define TNK_OFFSET_ID_HWID               16
#define TNK_MASK_ID_HWID                 0x0000FFFF

/* DMA_TTX_ADD_SIZE register fields */
#define TNK_OFFSET_DMA_TTX_ADD_SIZE      0
#define TNK_MASK_DMA_TTX_ADD_SIZE        0x00FFFFFF

/* DMA_TTX_ADD register fields */
#define TNK_OFFSET_DMA_TTX_ADD_CID       0
#define TNK_MASK_DMA_TTX_ADD_CID         0x000007FF
#define TNK_OFFSET_DMA_TTX_ADD_FLUSH     16
#define TNK_MASK_DMA_TTX_ADD_FLUSH       0x00000001

/* DMA_TTX_ALT_REQ register fields */
#define TNK_OFFSET_DMA_TTX_ALT_REQ_CID   0
#define TNK_MASK_DMA_TTX_ALT_REQ_CID     0x000007FF
#define TNK_OFFSET_DMA_TTX_ALT_REQ_SIZE  11
#define TNK_MASK_DMA_TTX_ALT_REQ_SIZE    0x001FFFFF

/* DMA_TTX_ACKD_CID register fields */
#define TNK_OFFSET_DMA_TTX_ACKD_OVFLOW   0
#define TNK_MASK_DMA_TTX_ACKD_OVFLOW     0x00000001
#define TNK_OFFSET_DMA_TTX_ACKD_VALID    1
#define TNK_MASK_DMA_TTX_ACKD_VALID      0x00000001
#define TNK_OFFSET_DMA_TTX_ACKD_CID      4
#define TNK_MASK_DMA_TTX_ACKD_CID        0x000007FF

/* DMA_RXINTR_CORE register fields */
#define TNK_OFFSET_DMA_RX_INTR_OVFLOW   0
#define TNK_MASK_DMA_RX_INTR_OVFLOW     0x00000001
#define TNK_OFFSET_DMA_RX_INTR_VALID    1
#define TNK_MASK_DMA_RX_INTR_VALID      0x00000001
#define TNK_OFFSET_DMA_RX_INTR_CID      4
#define TNK_MASK_DMA_RX_INTR_CID        0x000007FF

/* DMA_BITMAP_RDCMD register fields */
#define TNK_MASK_RDSEL_RX_INTR		0xF
#define TNK_RX_BITMAP_SIZE		32

/* DMA_TTX_ERR_STATUS register fields */
#define TNK_OFFSET_TTX_ERR_DFETCH0       0
#define TNK_MASK_TTX_ERR_DFETCH0         0x00000001
#define TNK_OFFSET_TTX_ERR_DFETCH1       1
#define TNK_MASK_TTX_ERR_DFETCH1         0x00000001
#define TNK_OFFSET_TTX_ERR_DFETCH2       2
#define TNK_MASK_TTX_ERR_DFETCH2         0x00000001
#define TNK_OFFSET_TTX_ERR_RETRY0        3
#define TNK_MASK_TTX_ERR_RETRY0          0x00000001
#define TNK_OFFSET_TTX_ERR_RETRY1        4
#define TNK_MASK_TTX_ERR_RETRY1          0x00000001
#define TNK_OFFSET_TTX_ERR_ACKD0         5
#define TNK_MASK_TTX_ERR_ACKD0           0x00000001
#define TNK_OFFSET_TTX_ERR_ACKD1         6
#define TNK_MASK_TTX_ERR_ACKD1           0x00000001
#define TNK_OFFSET_TTX_ERR_ACKD2         7
#define TNK_MASK_TTX_ERR_ACKD2           0x00000001
#define TNK_OFFSET_RX_OWN_ERR		8
#define TNK_MASK_RX_OWN_ERR		0x00000001

/* DMA_TTX_DFETCH_ERR_CID register fields */
#define TNK_OFFSET_TTX_DFETCH_ERR_CID    0
#define TNK_MASK_TTX_DFETCH_ERR_CID      0x000007FF

/* DMA_TTX_RETRY_ERR_CID register fields */
#define TNK_OFFSET_TTX_RETRY_ERR_CID     0
#define TNK_MASK_TTX_RETRY_ERR_CID       0x000007FF

/* DMA_TTX_ACKD_ERR_CID register fields */
#define TNK_OFFSET_TTX_ACKD_ERR_CID      0
#define TNK_MASK_TTX_ACKD_ERR_CID        0x000007FF

#define TNK_OFFSET_RXFETCH_ERR_CID	0
#define TNK_MASK_RXFETCH_ERR_CID	0x7FF
#define TNK_OFFSET_RXFETCH_POLL		0
#define TNK_MASK_RXFETCH_POLL		0x1

/* DMA_TTX_CTRL0 register fields */
#define TNK_OFFSET_TTX_CTRL0_MAXBURSTLEN 0
#define TNK_MASK_TTX_CTRL0_MAXBURSTLEN   0x000000FF

/* DMA_TRX_CTRL register fields */
#define TNK_OFFSET_TRX_CTRL_RXBUFFERSIZE 0
#define TNK_MASK_TRX_CTRL_RXBUFFERSIZE   0x00000007
#define TNK_OFFSET_TRX_CTRL_TOE_STAT_EN  3
#define TNK_MASK_TRX_CTRL_TOE_STAT_EN    0x00000001
#define TNK_OFFSET_TRX_CTRL_IPC_STAT_EN  4
#define TNK_MASK_TRX_CTRL_IPC_STAT_EN    0x00000001

/* DMA_TRX_ADD_SIZE register fields */
#define TNK_OFFSET_TRX_ADD_COUNT         0
#define TNK_MASK_TRX_ADD_COUNT           0x00FFFFFF

/* DMA_TIMER_CPU_CMD register fields */
#define TNK_MASK_CPU_ACS_CID			0x1FF
#define TNK_OFFSET_CPU_ACS_WR_MASK		9
#define TNK_MASK_CPU_ACS_WR_MASK		0x1
#define TNK_OFFSET_CPU_ACS_WR_SEL		10
#define TNK_MASK_CPU_ACS_WR_SEL			0x1
#define TNK_OFFSET_CPU_ACS_REQ_STAT		11
#define TNK_MASK_CPU_ACS_REQ_STAT		0x1

/* DMA_TIMER_BASE_CLK and DMA_TIMER_WATCHDOG */
#define TNK_MASK_DMA_TIMER_BASE_CLK		0x000FFFFF
#define TNK_MASK_DMA_TIMER_WATCHDOG		0x1FFFFFFF

/* RECV_LRO: RXF_DB_RD_ACT, RXF_EXP_SEQNUM, RXF_TXWND_WR */
#define TNK_MASK_RXF_DB_RD_CID			0x1FF
#define TNK_OFFSET_RXF_DB_RD_STAT		9
#define TNK_MASK_RXF_DB_RD_STAT			0x1
#define TNK_MASK_RXF_TXWND_WR_CID		0x1FF
#define TNK_MASK_RXF_TXWND_WR_WND		0x3FFFFF
#define TNK_OFFSET_RXF_TXWND_WR_WND		9
#define TNK_OFFSET_RXF_TXWND_OPT_TYPE		31

/* TOE_INTR_STAT register fields */
#define TNK_OFFSET_TOE_INTR_STAT_FLUSH      0
#define TNK_MASK_TOE_INTR_STAT_FLUSH        0x00000001
#define TNK_OFFSET_TOE_INTR_STAT_TX_ERR     1
#define TNK_MASK_TOE_INTR_STAT_TX_ERR       0x00000001
#define TNK_OFFSET_TOE_INTR_STAT_TX_ERR_CID 2
#define TNK_MASK_TOE_INTR_STAT_TX_ERR_CID   0x000007FF
#define TNK_OFFSET_TOE_INTR_STAT_RETRY_MAX  13
#define TNK_MASK_TOE_INTR_STAT_RETRY_MAX    0x00000001
#define TNK_OFFSET_TOE_INTR_STAT_RETRY_CID  14
#define TNK_MASK_TOE_INTR_STAT_RETRY_CID    0x000007FF
#define TNK_OFFSET_TOE_INTR_STAT_PROBE_MAX	25
#define TNK_MASK_TOE_INTR_STAT_PROBE_MAX	0x1
#define TNK_MASK_TOE_INTR_PROBE_CID		0x7FF

/* TOE_INTR_EN register fields */
#define TNK_OFFSET_TOE_INTR_EN_FLUSH      0
#define TNK_MASK_TOE_INTR_EN_FLUSH        0x00000001
#define TNK_OFFSET_TOE_INTR_EN_TX_ERR     1
#define TNK_MASK_TOE_INTR_EN_TX_ERR       0x00000001
#define TNK_OFFSET_TOE_INTR_EN_RETRY_MAX  2
#define TNK_MASK_TOE_INTR_EN_RETRY_MAX    0x00000001

/* TOE send ack register fields */
#define TNK_OFFSET_CT_CPU_TXACK_STAT	9
#define TNK_MASK_CT_CPU_TXACK_STAT	0x1

/* TOE send fin state register */
#define TNK_OFFSET_TOE_FIN_CID		4
#define TNK_MASK_TOE_FIN_CID		0x1ff
#define TNK_OFFSET_TOE_FIN_OPT		15
#define TNK_OFFSET_TOE_FIN_STATE	16
#define TNK_MASK_TOE_FIN_STATE		0x1
#define TNK_MASK_TOE_FIN_WDATA		0x1

/* TOE zero probe cnt register */
#define TNK_OFFSET_TOE_ZERO_PROBE_CID	4
#define TNK_MASK_TOE_ZERO_PROBE_CID	0x1ff
#define TNK_OFFSET_TOE_ZERO_PROBE_OPT	15
#define TNK_OFFSET_TOE_ZERO_PROBE_CNT	16
#define TNK_MASK_TOE_ZERO_PROBE_CNT	0xf

/* TOE rcv_wsacle register fields */
#define TNK_OFFSET_WSCALE_WR		15
#define TNK_OFFSET_WSCALE_CID		4
#define TNK_MASK_WSCALE_WDATA		0xf

/* TOE CPU FLAG bit */
#define TNK_OFFSET_CORK		11
#define TNK_OFFSET_NONAGLE	7
#define TNK_OFFSET_KEEPALIVE	12
#define TNK_OFFSET_THIN_STREAM	8
#define TNK_OFFSET_FIN		13
#define TNK_OFFSET_TX_ACK_IRQ	14
#define TNK_MASK_TX_ACK_IRQ	0x3

#define TNK_OFFSET_LOOKUP_TABLE		0x100000
#define TNK_OFFSET_AD_ENTRY		128
#define TNK_AD_ENTRY_SIZE		8
#define TNK_OFFSET_RX_IRQ		5

/* TOE retrans and probes timeout */
#define TNK_OFFSET_RETRY_INTR	8
#define TNK_MASK_RETRY_INTR	0x1
#define TNK_OFFSET_PROBE_INTR	15
#define TNK_MASK_PROBE_INTR	0x1

/* TOE DUP ACK CNT register */
#define TNK_MASK_TCP_DUPACK_CNT		0xff
#define TNK_MASK_TCP_RETRIES2		0xfff

/* TOE BONJOUR register fields */
#define TNK_MASK_BONJOUR_SEL_WRDATA	0x3
#define TNK_OFFSET_BONJOUR_WR		3
#define TNK_OFFSET_BONJOUR_CID		4
#define TNK_MASK_BONJOUR_CID		0x1ff
#define TNK_OFFSET_BONJOUR_RDDATA	16
#define TNK_MASK_BONJOUR_SEL_RDDATA	0x3

/*  TOE out of order register fields */
#ifdef CONFIG_ARCH_HI3536
#define TNK_HW_OUT_OF_ORDER_ENABLE		0x81c0
#define	TNK_HW_OUT_OF_ORDER_CRTL		0x81ec
#define	TNK_HW_OUT_OF_ORDER_WVAL		0x81f0
#define	TNK_HW_OUT_OF_ORDER_RVAL		0x81f4
#define	TNK_HW_OUT_OF_ORDER_IS01_ENDNUM		0
#define	TNK_HW_OUT_OF_ORDER_IS01_SEQNUM		1
#define	TNK_HW_OUT_OF_ORDER_IS02_ENDNUM		2
#define	TNK_HW_OUT_OF_ORDER_IS02_SEQNUM		3
#define	TNK_HW_OUT_OF_ORDER_IS03_ENDNUM		4
#define	TNK_HW_OUT_OF_ORDER_IS03_SEQNUM		5
#define	TNK_HW_OUT_OF_ORDER_IS04_ENDNUM		6
#define	TNK_HW_OUT_OF_ORDER_IS04_SEQNUM		7
#define	TNK_HW_OUT_OF_ORDER_LAST_ENDNUM		8
#define	TNK_HW_OUT_OF_ORDER_LAST_SEQNUM		9
#define	TNK_HW_OUT_OF_ORDER_IS_VALID_FLAG	10
#else /* for HI3535 */
#define TNK_HW_OUT_OF_ORDER_ENABLE		0x81c0
#define	TNK_HW_OUT_OF_ORDER_CRTL		0x81e0
#define	TNK_HW_OUT_OF_ORDER_WVAL		0x81e4
#define	TNK_HW_OUT_OF_ORDER_RVAL		0x81e8
#define	TNK_HW_OUT_OF_ORDER_IS01_ENDNUM		0
#define	TNK_HW_OUT_OF_ORDER_IS01_SEQNUM		1
#define	TNK_HW_OUT_OF_ORDER_IS02_ENDNUM		2
#define	TNK_HW_OUT_OF_ORDER_IS02_SEQNUM		3
#define	TNK_HW_OUT_OF_ORDER_IS01_IS02_FLAG	4
#endif

#define TNK_TTX_DMA_DB_ENTRY_SIZE (4 * sizeof(uint32_t))
#define TNK_TTX_DMA_DB_TXSTAT_SIZE (2 * sizeof(uint32_t))
#define TNK_TTX_DMA_DB_RXSTAT_SIZE (1 * sizeof(uint32_t))

#define TNK_RX_DMA_DB_ENTRY_SIZE (4 * sizeof(uint32_t))
#define TNK_RX_DB_DESC_ADDR	0
#define TNK_RX_DB_RCV_NXT	1
#define TNK_RX_DB_RX_OFFSET	2
#define TNK_RX_DB_TX_ADV_WND	3

#endif /*  __TNKHW_REGMAP_H__ */
