 
#include <linux/irq.h>
#include <linux/of_irq.h>
#include <linux/of_platform.h>
#include <asm/mach/arch.h>
#include <asm/mach/time.h>

#include "common.h"
#include "mx27.h"

static void __init imx27_dt_init(void)
{
#if defined(CONFIG_SYNO_LSP_ARMADA_2015_T1_1p4)
	struct platform_device_info devinfo = { .name = "cpufreq-dt", };
#else  
	struct platform_device_info devinfo = { .name = "cpufreq-cpu0", };
#endif  

	of_platform_populate(NULL, of_default_bus_match_table, NULL, NULL);

	platform_device_register_full(&devinfo);
}

static const char * const imx27_dt_board_compat[] __initconst = {
	"fsl,imx27",
	NULL
};

static void __init imx27_timer_init(void)
{
	mx27_clocks_init_dt();
}

DT_MACHINE_START(IMX27_DT, "Freescale i.MX27 (Device Tree Support)")
	.map_io		= mx27_map_io,
	.init_early	= imx27_init_early,
	.init_irq	= mx27_init_irq,
	.handle_irq	= imx27_handle_irq,
	.init_time	= imx27_timer_init,
	.init_machine	= imx27_dt_init,
	.dt_compat	= imx27_dt_board_compat,
	.restart	= mxc_restart,
MACHINE_END
