/*
 * Copyright (C) 2011 STRATO AG
 * written by Arne Jansen <sensille@gmx.net>
 * Distributed under the GNU GPL license version 2.
 *
 */

#ifndef __ULIST__
#define __ULIST__

#include <linux/list.h>
#include <linux/rbtree.h>

/*
 * ulist is a generic data structure to hold a collection of unique u64
 * values. The only operations it supports is adding to the list and
 * enumerating it.
 * It is possible to store an auxiliary value along with the key.
 *
 */
struct ulist_iterator {
#ifdef CONFIG_BTRFS_DEBUG
	int i;
#endif
	struct list_head *cur_list;  /* hint to start search */
};

/*
 * element of the list
 */
struct ulist_node {
	u64 val;		/* value to store */
	u64 aux;		/* auxiliary value saved along with the val */

#ifdef CONFIG_BTRFS_DEBUG
	int seqnum;		/* sequence number this node is added */
#endif

	struct list_head list;  /* used to link node */
	struct rb_node rb_node;	/* used to speed up search */
};

struct ulist {
	/*
	 * number of elements stored in list
	 */
	unsigned long nnodes;

	struct list_head nodes;
	struct rb_root root;
};

void ulist_init(struct ulist *ulist);
void ulist_reinit(struct ulist *ulist);
struct ulist *ulist_alloc(gfp_t gfp_mask);
void ulist_free(struct ulist *ulist);
int ulist_add(struct ulist *ulist, u64 val, u64 aux, gfp_t gfp_mask);
int ulist_add_merge(struct ulist *ulist, u64 val, u64 aux,
		    u64 *old_aux, gfp_t gfp_mask);
struct ulist_node *ulist_next(struct ulist *ulist,
			      struct ulist_iterator *uiter);

#define ULIST_ITER_INIT(uiter) ((uiter)->cur_list = NULL)

#if defined(CONFIG_SYNO_BTRFS_COMPR_CTL)
#define ULIST_NODES_MAX 16384 // 128MiB / 4KiB / 2 = 16384; 16384 ulist_node = 7MiB
int ulist_add_lru_adjust(struct ulist *ulist, u64 val, gfp_t gfp_mask);
void ulist_remove_first(struct ulist *ulist);
#endif

#endif
