#ifndef MY_ABC_HERE
#define MY_ABC_HERE
#endif
// Copyright (c) 2000-2016 Synology Inc. All rights reserved.
#ifndef __SYNOBIOS_KERNEL_H_
#define __SYNOBIOS_KERNEL_H_

#define HW_DS107e      "DS107e"
#define HW_DS107v10    "DS107v10"
#define HW_DS107v20    "DS107v20"
#define HW_DS107v30    "DS107v30"
#define HW_DS207       "DS207"         //"DS207v10"
#define HW_DS406       "DS406"         //"DS406v10"  "DS406v20"
#define HW_DS407ev10   "DS407ev10"     //"DS407ev10"
#define HW_DS407v10    "DS407v10"      //"DS407v10"
#define HW_DS407v20    "DS407v20"      //"DS407v20"
#define HW_RS408       "RS408"         //"RS408"
#define HW_RS408rp     "RS408rp"       //"RS408rp"
#define HW_RS409p      "RS409p"        //"RS409p"
#define HW_RS409rpp    "RS409rpp"      //"RS409rpp"
#define HW_DS408       "DS408"         //"DS408"
#define HW_DS409p      "DS409p"        //"DS409p"
#define HW_DS409pv20   "DS409pv20"     //"DS409pv20"
#define HW_DS508       "DS508"         //"DS508"
#define HW_DS509p      "DS509p"        //"DS509p"
#define HW_DS209p      "DS209p"        //"DS209p"
#define HW_DS209pII    "DS209pII"      //"DS209pII"
#define HW_DS209pIIr1  "DS209pIIr1"    //"DS209pIIr1"
#define HW_DS108jv10   "DS108jv10"     //"DS108jv10"
#define HW_DS108jv20   "DS108jv20"     //"DS108jv20"
#define HW_DS109j      "DS109jv10"     //"DS109jv10"
#define HW_DS209j      "DS209jv10"     //"DS209jv10"
#define HW_DS109       "DS109"         //"DS109"
#define HW_DS209       "DS209"         //"DS209"
#define HW_DS409slim   "DS409slim"     //"DS409slim"
#define HW_DS409       "DS409"         //"DS409"
#define HW_RS409v10    "RS409v10"      //"RS409v10"
#define HW_RS409v20    "RS409v20"      //"RS409v20"
#define HW_DS109p      "DS109p"        //"DS109p"
#define HW_DS410j      "DS410j"        //"DS410j"
#define HW_DS210jv10   "DS210jv10"     //"DS210jv10"
#define HW_DS210jv20   "DS210jv20"     //"DS210jv20"
#define HW_DS210jv30   "DS210jv30"     //"DS210jv30"
#define HW_DS110jv10   "DS110jv10"     //"DS110jv10"
#define HW_DS110jv20   "DS110jv20"     //"DS110jv20"
#define HW_DS110jv30   "DS110jv30"     //"DS110jv30"
#define HW_DS710p      "DS710+"        //"DS710+"
#define HW_DS712pv10   "DS712+"        //"DS712+"
#define HW_DS712pv20   "DS712+v20"     //"DS712+v20"
#define HW_DS1010p     "DS1010+"       //"DS1010+"
#define HW_DS110p      "DS110p"        //"DS110+"
#define HW_DS210p      "DS210p"        //"DS210+"
#define HW_DS410       "DS410"         //"DS410"
#define HW_DS411p      "DS411+"        //"DS411+"
#define HW_DS411pII    "DS411+II"      //"DS411+II"
#define HW_RS810p      "RS810+"        //"RS810+"
#define HW_RS810rpp    "RS810rp+"      //"RS810rp+"
#define HW_DS211j      "DS211j"        //"DS211j"
#define HW_DS411j      "DS411j"        //"DS411j"
#define HW_DS211       "DS211"         //"DS211"
#define HW_DS111       "DS111"         //"DS111"
#define HW_DS411slim   "DS411slim"     //"DS411slim"
#define HW_DS411       "DS411"         //"DS411"
#define HW_DS1511p     "DS1511+"       //"DS1511+"
#define HW_DS211pv10   "DS211pv10"     //"DS211+"
#define HW_DS211pv20   "DS211pv20"     //"DS211+"
#define HW_RS411       "RS411"         //"RS411"
#define HW_RS2211p     "RS2211+"       //"RS2211+"
#define HW_RS2211rpp   "RS2211rp+"     //"RS2211rp+"
#define HW_DS2411p     "DS2411+"       //"DS2411+"
#define HW_RS3411rpxs  "RS3411rpxs"    //"RS3411rpxs"
#define HW_RS3411xs    "RS3411xs"      //"RS3411xs"
#define HW_RS10613xsp  "RS10613xs+"    //"RS10613xs+"
#define HW_DS3611xs    "DS3611xs"      //"DS3611xs"
#define HW_RS3412rpxs  "RS3412rpxs"    //"RS3412rpxs"
#define HW_RS3412xs    "RS3412xs"      //"RS3412xs"
#define HW_DS3612xs    "DS3612xs"      //"DS3612xs"
#define HW_DS3615xs    "DS3615xs"      //"DS3615xs"
#define HW_RS3413xsp   "RS3413xs+"     //"RS3413xs+"
#define HW_RS3614xs    "RS3614xs"      //"RS3614xs"
#define HW_RS3614rpxs  "RS3614rpxs"    //"RS3614rpxs"
#define HW_RS3614xsp   "RS3614xs+"     //"RS3614xs+"
#define HW_ES3614xsp   "ES3614xs+"     //"ES3614xs+"
#define HW_DS2414xs    "DS2414xs"      //"DS2414xs"
#define HW_DS111j      "DS111j"        //"DS111j"
#define HW_DS212       "DS212"         //"DS212v10"
#define HW_DS413       "DS413"         //"DS413"
#define HW_DS412p      "DS412+"        //"DS412+"
#define HW_DS713p      "DS713+"        //"DS713+"
#define HW_RS812p      "RS812+"        //"RS812+"
#define HW_RS812rpp    "RS812rp+"      //"RS812rp+"
#define HW_DS1812p     "DS1812+"       //"DS1812+"
#define HW_DS1813p     "DS1813+"       //"DS1813+"
#define HW_RS2212p     "RS2212+"       //"RS2212+"
#define HW_RS2212rpp   "RS2212rp+"     //"RS2212rp+"
#define HW_RS2414p     "RS2414+"       //"RS2414+"
#define HW_RS2414rpp   "RS2414rp+"     //"RS2414rp+"
#define HW_DS2413p     "DS2413+"       //"DS2413+"
#define HW_DS2415p     "DS2415+"       //"DS2415+"
#define HW_RS212       "RS212"         //"RS212"
#define HW_DS212jv10   "DS212j"        //"DS212j"
#define HW_DS212jv20   "DS212jv20"     //"DS212j"
#define HW_RS812       "RS812"         //"RS812"
#define HW_DS1512p     "DS1512+"       //"DS1512+"
#define HW_DS1513p     "DS1513+"       //"DS1513+"
#define HW_DS212pv10   "DS212pv10"     //"DS212+"
#define HW_DS212pv20   "DS212pv20"     //"DS212+"
#define HW_DS112j      "DS112jv10"     //"DS112j"
#define HW_DS112       "DS112v10"      //"DS112"
#define HW_DS112pv10   "DS112pv10"     //"DS112+"
#define HW_DS112slim   "DS112slim"     //"DS112slim"
#define HW_DS413jv10   "DS413jv10"     //"DS413jv10"
#define HW_DS414jv10   "DS414jv10"     //"DS414jv10"
#define HW_DS415jv10   "DS415jv10"     //"DS415jv10"
#define HW_DS215airv10 "DS215airv10"   //"DS215airv10"
#define HW_DS213pv10   "DS213pv10"     //"DS213pv10"
#define HW_DS213airv10 "DS213airv10"   //"DS213airv10"
#define HW_DS213v10    "DS213v10"      //"DS213v10"
#define HW_NVR614v10   "NVR614v10"     //"NVR614v10"
#define HW_VS240hdv10  "VS240hdv10"    //"VS240hdv10"
#define HW_RS813       "RS813v10"      //"RS813v10"
#define HW_RS213p      "RS213pv10"     //"RS213pv10"
#define HW_DS213jv10   "DS213jv10"     //"DS213jv10"
#define HW_US3v10      "US3v10"        //"US3v10"
#define HW_DS114v10    "DS114v10"      //"DS114v10"
#define HW_RS214v10    "RS214v10"      //"RS214v10"
#define HW_DS214v10    "DS214v10"      //"DS214v10"
#define HW_DS214p      "DS214+"
#define HW_DS214se     "DS214se"       //DS214se
#define HW_DS414v10    "DS414v10"
#define HW_RS814v10    "RS814v10"
#define HW_DS114p      "DS114+"        //"DS114+"
#define HW_RC18015xsp  "RC18015xs+"    //"RC18015xs+"
#define HW_RS18016xsp  "RS18016xs+"    //"RS18016xs+"
#define HW_RR36015xsppp "RR36015xs+++" //"RR36015xs+++"
#define HW_VirtualDSM  "VirtualDSM"    //"VirtualDSM"
#define HW_RS18016Dxsp "RS18016Dxs+"   //"RS18016Dxs+"
#define HW_DS714v10    "DS714v10"
#define HW_RS814p      "RS814+"        //"RS814+"
#define HW_RS814rpp    "RS814rp+"      //"RS814rp+"
#define HW_DS214play   "DS214play"
#define HW_DS415play   "DS415play"     //"DS415play"
#define HW_DS414slim   "DS414slim"     //DS414slim
#define HW_DS2015xs    "DS2015xs"
#define HW_DS115j      "DS115j"
#define HW_RS3415xsp   "RS3415xs+"     //"RS3415xs+"
#define HW_DS415p      "DS415+"        //"DS415+"
#define HW_DS1815p     "DS1815+"       //"DS1815+"
#define HW_DS1515p     "DS1515+"       //"DS1515+"
#define HW_DS215j      "DS215j"
#define HW_DS115       "DS115"
#define HW_RS815p      "RS815+"        //"RS815+"
#define HW_RS815rpp    "RS815rp+"      //"RS815rp+"
#define HW_DS215router "DS215router"   //"DS215router"
#define HW_RS815       "RS815"         //"RS815"
#define HW_DS1515      "DS1515"
#define HW_DS715       "DS715"
#define HW_DS215p      "DS215+"
#define HW_DS416       "DS416"
#define HW_RS2416p     "RS2416+"       //"RS2416+"
#define HW_RS2416rpp   "RS2416rp+"     //"RS2416rp+"
#define HW_DS216play   "DS216play"
#define HW_DS216se     "DS216se"       //DS216se
#define HW_DS916p      "DS916+"        //DS916+
#define HW_DS716p      "DS716+"        //DS716+
#define HW_DS716pII    "DS716+II"      //DS716+II
#define HW_RSD18016xsp "RSD18016xs+"   //"RSD18016xs+"
#define HW_DockerDSM   "DockerDSM"     //"DockerDSM"
#define HW_DS1616p     "DS1616+"       //"DS1616+"
#define HW_RS3618xs    "RS3618xs"      //"RS3618xs"
#define HW_RS3617rpxs  "RS3617rpxs"    //"RS3617rpxs"
#define HW_RS3617xsp   "RS3617xs+"     //"RS3617xs+"
#define HW_DS416j      "DS416j"        //DS416j
#define HW_DS216       "DS216"         //DS216
#define HW_DS416slim   "DS416slim"     //DS416slim
#define HW_DS216p      "DS216+"        //"DS216+"
#define HW_DS216pII    "DS216+II"      //"DS216+II"
#define HW_DS216j      "DS216j"        //"DS216j"
#define HW_RS816       "RS816"         //"RS816"
#define HW_DS116       "DS116"         //"DS116"
#define HW_DS416play   "DS416play"     //"DS416play"
#define HW_RS217       "RS217"         //"RS217"
#define HW_FS3017      "FS3017"        //"FS3017"
#define HW_RS3617xs    "RS3617xs"      //"RS3617xs"
#define HW_RS2417p     "RS2417+"       //"RS2417+"
#define HW_RS2417rpp   "RS2417rp+"     //"RS2417rp+"
#define HW_DS917p      "DS917+"        //DS917+
#define HW_RS4017xsp   "RS4017xs+"     //"RS4017xs+"
#define HW_DS3617xs    "DS3617xs"      //"DS3617xs"
#define HW_RS18017xsp  "RS18017xs+"    //"RS18017xs+"
#define HW_DS217p      "DS217+"        //DS217+
#define HW_DS1518p     "DS1518+"       //"DS1518+"
#define HW_C2DSM       "C2DSM"         //"C2DSM"
#define HW_DS1517p     "DS1517+"       //"DS1517+"
#define HW_DS1817p     "DS1817+"       //"DS1817+"
#define HW_DS717p      "DS717+"        //DS717+
#define HW_FS2017      "FS2017"        //"FS2017"
#define HW_RS818p      "RS818+"        //"RS818+"
#define HW_RS818rpp    "RS818rp+"      //"RS818rp+"
#define HW_UNKNOWN     "DSUnknown"

#define EBOX_INFO_UNIQUE_RX410  "RX410"
#define EBOX_INFO_UNIQUE_RX413  "RX413"
#define EBOX_INFO_UNIQUE_DX510  "DX510"
#define EBOX_INFO_UNIQUE_DX513  "DX513"
#define EBOX_INFO_UNIQUE_RX4    "RX4"
#define EBOX_INFO_UNIQUE_DX5    "DX5"
#define EBOX_INFO_UNIQUE_RXC    "RX1211"
#define EBOX_INFO_UNIQUE_DXC    "DX1211"
#define EBOX_INFO_UNIQUE_RXCRP  "RX1211rp"
#define EBOX_INFO_UNIQUE_RX1214 "RX1214"
#define EBOX_INFO_UNIQUE_RX1217 "RX1217"
#define EBOX_INFO_UNIQUE_RX1214RP   "RX1214rp"
#define EBOX_INFO_UNIQUE_RX1217RP   "RX1217rp"
#define EBOX_INFO_UNIQUE_DX213  "DX213"
#define EBOX_INFO_UNIQUE_RX415  "RX415"
#define EBOX_INFO_UNIQUE_DX1215 "DX1215"
#define EBOX_INFO_UNIQUE_DX517  "DX517"
#define EBOX_INFO_UNIQUE_RX418  "RX418"

#define SYNO_UNIQUE(x)     (x>>2)
#define IS_SYNOLOGY_RX4(x) (SYNO_UNIQUE(x) == 0x15 || SYNO_UNIQUE(x) == 0xd) // 0x54 ~ 0x57
#define IS_SYNOLOGY_RX410(x) (SYNO_UNIQUE(x) == 0xd) // 0x34 ~ 0x37
#define IS_SYNOLOGY_DX5(x) (SYNO_UNIQUE(x) == 0xa || SYNO_UNIQUE(x) == 0x1a) // 0x28 ~ 0x2b
#define IS_SYNOLOGY_DX510(x) (SYNO_UNIQUE(x) == 0x1a) // 0x68 ~ 0x6b
#define IS_SYNOLOGY_DX513(x) (SYNO_UNIQUE(x) == 0x6) // 0x18 ~ 0x1b
#define IS_SYNOLOGY_DXC(x) (SYNO_UNIQUE(x) == 0x13) // 0x4c ~ 0x4f
#define IS_SYNOLOGY_RXC(x) (SYNO_UNIQUE(x) == 0xb) // 0x2c ~ 0x2f
#define IS_SYNOLOGY_DX213(x) (SYNO_UNIQUE(x) == 0x16) // 0x58 ~ 0x5b
#define IS_SYNOLOGY_RX413(x) (x == 0x11) // This model is obsoleted
#define IS_SYNOLOGY_RX1214(x) (x == 0x12)
#define IS_SYNOLOGY_RX1217(x) (x == 0x14)
#define IS_SYNOLOGY_RX415(x) (SYNO_UNIQUE(x) == 0x1d) // 0x54 ~ 0x57
#define IS_SYNOLOGY_DX1215(x) (x == 0x13)
#define IS_SYNOLOGY_DX517(x) (x == 0x15)
#define IS_SYNOLOGY_RX418(x) (x == 0x16)

typedef enum _tag_EUNIT_PWRON_TYPE {
	EUNIT_NOT_SUPPORT,
	EUNIT_PWRON_GPIO,
	EUNIT_PWRON_ATACMD,
	EUNIT_SAS_NO_PWRON,
} EUNIT_PWRON_TYPE;

typedef enum {
	CAPABILITY_THERMAL      = 1,
	CAPABILITY_DISK_LED_CTRL= 2,
	CAPABILITY_AUTO_POWERON = 3,
	CAPABILITY_CPU_TEMP     = 4,
	CAPABILITY_S_LED_BREATH = 5,
	CAPABILITY_FAN_RPM_RPT  = 6,
	CAPABILITY_MICROP_PWM   = 7,
	CAPABILITY_CARDREADER   = 8,
	CAPABILITY_LCM          = 9,
	CAPABILITY_NONE         = -1,
} SYNO_HW_CAPABILITY;

typedef struct _tag_CAPABILITY {
	SYNO_HW_CAPABILITY      id;
	int support;
} CAPABILITY;

typedef enum {
	DISK_LED_OFF = 0,
	DISK_LED_GREEN_SOLID,
	DISK_LED_ORANGE_SOLID,
	DISK_LED_ORANGE_BLINK,
	DISK_LED_GREEN_BLINK,
} SYNO_DISK_LED;

typedef struct _tag_SYNO_SUPERIO_PACKAGE{
	unsigned char ldn;
	unsigned char reg;
	unsigned char value;
} SYNO_SUPERIO_PACKAGE;

typedef enum {
	EUP_FULLY_SUPPORT = 0,
	EUP_NOT_FULLY_SUPPORT,
	EUP_NOT_SUPPORT,
} SYNO_EUP_SUPPORT;

#define MAX_CPU 2
typedef struct _SynoCpuTemp {
	unsigned char blSurface;
	int cpu_num;
	int cpu_temp[MAX_CPU];
} SYNOCPUTEMP;

typedef struct _SynoThermalTemp {
	unsigned char blSurface;
	int temperature;
} SYNO_THERMAL_TEMP;

enum {
    MD_SECTOR_READ_ERROR = 0,
    MD_SECTOR_WRITE_ERROR = 1,
    MD_SECTOR_REWRITE_OK = 2,
};

typedef enum {
	SYNO_LED_OFF = 0,
	SYNO_LED_ON,
	SYNO_LED_BLINKING,
} SYNO_LED;

/* TODO: Because user space also need this define, so we define them here.
 * But userspace didn't have a common define like MY_ABC_HERE include
 * kernel space. So we can't define it inside some define */
#define EBOX_GPIO_KEY           "gpio"
#define EBOX_INFO_DEV_LIST_KEY  "syno_device_list"
#define EBOX_INFO_VENDOR_KEY    "vendorid"
#define EBOX_INFO_DEVICE_KEY    "deviceid"
#define EBOX_INFO_ERROR_HANDLE  "error_handle"
#define EBOX_INFO_UNIQUE_KEY    "Unique"
#define EBOX_INFO_EMID_KEY      "EMID"
#define EBOX_INFO_SATAHOST_KEY  "sata_host"
#define EBOX_INFO_PORTNO_KEY    "port_no"
#define EBOX_INFO_CPLDVER_KEY   "cpld_version"
#define EBOX_INFO_DEEP_SLEEP    "deepsleep_support"
#define EBOX_INFO_IRQ_OFF       "irq_off"

/* Use 'K' as magic number */
#define SYNOBIOS_IOC_MAGIC  'K'

#define SYNOIO_GET_EUNIT_TYPE     _IOR(SYNOBIOS_IOC_MAGIC, 41, EUNIT_PWRON_TYPE)
#define SYNOIO_SUPERIO_READ       _IOWR(SYNOBIOS_IOC_MAGIC, 216, SYNO_SUPERIO_PACKAGE)
#define SYNOIO_SUPERIO_WRITE      _IOWR(SYNOBIOS_IOC_MAGIC, 217, SYNO_SUPERIO_PACKAGE)
#define SYNOIO_IS_FULLY_SUPPORT_EUP _IOWR(SYNOBIOS_IOC_MAGIC, 218, SYNO_EUP_SUPPORT)

extern int syno_is_hw_version(const char *hw_version);

#endif /* __SYNOBIOS_KERNEL_H_ */
