#ifndef MY_ABC_HERE
#define MY_ABC_HERE
#endif
 
#ifndef _LINUX_RANDOM_H
#define _LINUX_RANDOM_H

#include <linux/types.h>
#include <linux/ioctl.h>
#include <linux/irqnr.h>

#define RNDGETENTCNT	_IOR( 'R', 0x00, int )

#define RNDADDTOENTCNT	_IOW( 'R', 0x01, int )

#define RNDGETPOOL	_IOR( 'R', 0x02, int [2] )

#define RNDADDENTROPY	_IOW( 'R', 0x03, int [2] )

#define RNDZAPENTCNT	_IO( 'R', 0x04 )

#define RNDCLEARPOOL	_IO( 'R', 0x06 )

#if defined(MY_DEF_HERE) && defined(CONFIG_FIPS_RNG)

#define AES_BLOCK_SIZE_BYTES	16
#define SEED_SIZE_BYTES			AES_BLOCK_SIZE_BYTES
 
#define KEY_SIZE_BYTES		16

struct rand_fips_test {
	unsigned char key[KEY_SIZE_BYTES];			 
	unsigned char datetime[SEED_SIZE_BYTES];	 
	unsigned char seed[SEED_SIZE_BYTES];		 
	unsigned char result[SEED_SIZE_BYTES];		 
};

#define RNDFIPSVST	_IOWR('R', 0x10, struct rand_fips_test)

#define RNDFIPSMCT	_IOWR('R', 0x11, struct rand_fips_test)

#endif  

struct rand_pool_info {
	int	entropy_count;
	int	buf_size;
	__u32	buf[0];
};

struct rnd_state {
	__u32 s1, s2, s3;
};

#ifdef __KERNEL__

extern void rand_initialize_irq(int irq);

extern void add_device_randomness(const void *, unsigned int);
extern void add_input_randomness(unsigned int type, unsigned int code,
				 unsigned int value);
extern void add_interrupt_randomness(int irq, int irq_flags);

#ifdef MY_ABC_HERE
extern void random_input_words(__u32 *buf, size_t wordcount, int ent_count);
extern int random_input_wait(void);
#define HAS_RANDOM_INPUT_WAIT 1
#endif

#if defined(MY_DEF_HERE)
extern void random_input_words(__u32 *buf, size_t wordcount, int ent_count);
extern int random_input_wait(void);
#define HAS_RANDOM_INPUT_WAIT 1
#endif

extern void get_random_bytes(void *buf, int nbytes);
extern void get_random_bytes_arch(void *buf, int nbytes);
void generate_random_uuid(unsigned char uuid_out[16]);

#ifndef MODULE
extern const struct file_operations random_fops, urandom_fops;
#endif

unsigned int get_random_int(void);
unsigned long randomize_range(unsigned long start, unsigned long end, unsigned long len);

u32 prandom_u32(void);
void prandom_bytes(void *buf, int nbytes);
void prandom_seed(u32 seed);

#define random32() prandom_u32()
#define srandom32(seed) prandom_seed(seed)

u32 prandom_u32_state(struct rnd_state *);
void prandom_bytes_state(struct rnd_state *state, void *buf, int nbytes);

static inline u32 __seed(u32 x, u32 m)
{
	return (x < m) ? x + m : x;
}

static inline void prandom_seed_state(struct rnd_state *state, u64 seed)
{
	u32 i = (seed >> 32) ^ (seed << 10) ^ seed;

	state->s1 = __seed(i, 1);
	state->s2 = __seed(i, 7);
	state->s3 = __seed(i, 15);
}

#ifdef CONFIG_ARCH_RANDOM
# include <asm/archrandom.h>
#else
static inline int arch_get_random_long(unsigned long *v)
{
	return 0;
}
static inline int arch_get_random_int(unsigned int *v)
{
	return 0;
}
#endif

#endif  

#endif  
