#ifndef MY_ABC_HERE
#define MY_ABC_HERE
#endif
#ifndef _NF_CONNTRACK_COMMON_H
#define _NF_CONNTRACK_COMMON_H
 
enum ip_conntrack_info {
	 
	IP_CT_ESTABLISHED,

	IP_CT_RELATED,

	IP_CT_NEW,

	IP_CT_IS_REPLY,

	IP_CT_ESTABLISHED_REPLY = IP_CT_ESTABLISHED + IP_CT_IS_REPLY,
	IP_CT_RELATED_REPLY = IP_CT_RELATED + IP_CT_IS_REPLY,
	IP_CT_NEW_REPLY = IP_CT_NEW + IP_CT_IS_REPLY,	
	 
	IP_CT_NUMBER = IP_CT_IS_REPLY * 2 - 1
};

enum ip_conntrack_status {
	 
	IPS_EXPECTED_BIT = 0,
	IPS_EXPECTED = (1 << IPS_EXPECTED_BIT),

	IPS_SEEN_REPLY_BIT = 1,
	IPS_SEEN_REPLY = (1 << IPS_SEEN_REPLY_BIT),

	IPS_ASSURED_BIT = 2,
	IPS_ASSURED = (1 << IPS_ASSURED_BIT),

	IPS_CONFIRMED_BIT = 3,
	IPS_CONFIRMED = (1 << IPS_CONFIRMED_BIT),

	IPS_SRC_NAT_BIT = 4,
	IPS_SRC_NAT = (1 << IPS_SRC_NAT_BIT),

	IPS_DST_NAT_BIT = 5,
	IPS_DST_NAT = (1 << IPS_DST_NAT_BIT),

	IPS_NAT_MASK = (IPS_DST_NAT | IPS_SRC_NAT),

	IPS_SEQ_ADJUST_BIT = 6,
	IPS_SEQ_ADJUST = (1 << IPS_SEQ_ADJUST_BIT),

	IPS_SRC_NAT_DONE_BIT = 7,
	IPS_SRC_NAT_DONE = (1 << IPS_SRC_NAT_DONE_BIT),

	IPS_DST_NAT_DONE_BIT = 8,
	IPS_DST_NAT_DONE = (1 << IPS_DST_NAT_DONE_BIT),

	IPS_NAT_DONE_MASK = (IPS_DST_NAT_DONE | IPS_SRC_NAT_DONE),

	IPS_DYING_BIT = 9,
	IPS_DYING = (1 << IPS_DYING_BIT),

	IPS_FIXED_TIMEOUT_BIT = 10,
	IPS_FIXED_TIMEOUT = (1 << IPS_FIXED_TIMEOUT_BIT),

	IPS_TEMPLATE_BIT = 11,
	IPS_TEMPLATE = (1 << IPS_TEMPLATE_BIT),

	IPS_UNTRACKED_BIT = 12,
	IPS_UNTRACKED = (1 << IPS_UNTRACKED_BIT),

#if defined(MY_DEF_HERE)
	 
	IPS_PERMANENT_BIT = 13,
	IPS_PERMANENT = (1 << IPS_PERMANENT_BIT),

#ifdef CONFIG_COMCERTO_FP
    
   IPS_DPI_ALLOWED_BIT = 14,
   IPS_DPI_ALLOWED = (1 << IPS_DPI_ALLOWED_BIT),
#endif
#endif
};

enum ip_conntrack_events {
	IPCT_NEW,		 
	IPCT_RELATED,		 
	IPCT_DESTROY,		 
	IPCT_REPLY,		 
	IPCT_ASSURED,		 
	IPCT_PROTOINFO,		 
	IPCT_HELPER,		 
	IPCT_MARK,		 
	IPCT_NATSEQADJ,		 
	IPCT_SECMARK,		 
};

enum ip_conntrack_expect_events {
	IPEXP_NEW,		 
	IPEXP_DESTROY,		 
};

#define NF_CT_EXPECT_PERMANENT		0x1
#define NF_CT_EXPECT_INACTIVE		0x2
#define NF_CT_EXPECT_USERSPACE		0x4

#ifdef __KERNEL__
struct ip_conntrack_stat {
	unsigned int searched;
	unsigned int found;
	unsigned int new;
	unsigned int invalid;
	unsigned int ignore;
	unsigned int delete;
	unsigned int delete_list;
	unsigned int insert;
	unsigned int insert_failed;
	unsigned int drop;
	unsigned int early_drop;
	unsigned int error;
	unsigned int expect_new;
	unsigned int expect_create;
	unsigned int expect_delete;
	unsigned int search_restart;
};

extern void need_conntrack(void);

#endif  

#endif  
