/******************************************************************************
 *
 * Name:	mvyexhw.h
 * Project:	Yukon Extreme, Common Modules
 * Version:	$Revision: 1.1 $
 * Date:	$Date: 2010/04/15 15:13:31 $
 * Purpose:	Defines and Macros for the Yukon Extreme Gigabit Ethernet Adapters
 *
 ******************************************************************************/

/******************************************************************************
 *
 *	LICENSE:
 *	(C)Copyright 2005-2007 Marvell.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *	The information in this file is provided "AS IS" without warranty.
 *	/LICENSE
 *
 ******************************************************************************/

/******************************************************************************
 *
 * This file was automatically generated by reg.pl (Rev. 1.55) using
 *	Yukon_Extreme_Registers_Config.csv
 *	Yukon_Extreme_Registers_Control.csv
 *	Yukon_Extreme_Registers_GMAC.csv
 *
 ******************************************************************************/

#ifndef __INC_MVYEXHW_H
#define __INC_MVYEXHW_H

#define	PCI_VEN_ID						0x0000	/* 16 bit	Vendor ID Register */
#define	PCI_DEV_ID						0x0002	/* 16 bit	Device ID Register */
#define	PCI_CMD							0x0004	/* 16 bit	Command Register */
#define	PCI_STAT						0x0006	/* 16 bit	Status Register */
//#define	PCI_REV_ID						0x0008	/*  8 bit	Revision ID Register */
#define	PCI_PIF							0x0009	/*  8 bit	Programming
												 *			Interface
												 *			Register, Lower
												 *			Byte
												 */
#define	PCI_SCC							0x000A	/*  8 bit	Sub-Class Register,
												 *			Middle Byte
												 */
#define	PCI_BCC							0x000B	/*  8 bit	Base-Class
												 *			Register, Upper
												 *			Byte
												 */
#define	PCI_CLS							0x000C	/*  8 bit	Cache Line Size
												 *			Register
												 */
//#define	PCI_LAT_TIM						0x000D	/*  8 bit	Latency Timer
//												 *			Register
//												 */
#define	PCI_HDRTYP						0x000E	/*  8 bit	Header Type Register  */
//#define	PCI_BIST						0x000F	/*  8 bit	Built-in Self Test
//												 *			(BIST) Register
//												 */
#define	PCI_BAR1_LO						0x0010	/* 32 bit	Base Address
												 *			Register (1st),
												 *			Lower Address
												 */
#define	PCI_BAR1_HI						0x0014	/* 32 bit	Base Address
												 *			Register (1st),
												 *			Upper Address
												 */
#define	PCI_BAR2						0x0018	/* 32 bit	Base Address
												 *			Register (2nd)
												 */
#define	PCI_SSVEN_ID					0x002C	/* 16 bit	Subsystem Vendor ID
												 *			Register
												 */
#define	PCI_SSDEV_ID					0x002E	/* 16 bit	Subsystem ID
												 *			Register
												 */
#define	PCI_ERBAR						0x0030	/* 32 bit	Expansion Rom Base
												 *			Address Register
												 */
#define	PCI_NCAP_PTR					0x0034	/*  8 bit	New Capabilities
												 *			Pointer (New Cap
												 *			Ptr) Register
												 */
#define	PCI_INT_LINE					0x003C	/*  8 bit	Interrupt Line
												 *			Register
												 */
#define	PCI_INT_PIN						0x003D	/*  8 bit	Interrupt Pin
												 *			Register
												 */
//#define	PCI_MIN_GNT						0x003E	/*  8 bit	Min_Gnt Register */
//#define	PCI_MAX_LAT						0x003F	/*  8 bit	Max_Lat Register */
#define	PCI_OUR1						0x0040	/* 32 bit	Our Register 1 */
#define	PCI_OUR2						0x0044	/* 32 bit	Our Register 2 */
//#define	PCI_PM_CAP_ID					0x0048	/*  8 bit	Power Management
//												 *			Capability ID
//												 *			Register (PM Cap
//												 *			ID)
//												 */
#define	PCI_PM_NXT_PTR					0x0049	/*  8 bit	Power Management
												 *			Next Item Pointer
												 *			Register
												 */
#define	PCI_PM_CAP						0x004A	/* 16 bit	Power Management
												 *			Capabilities
												 *			Register
												 */
#define	PCI_PM_CSR						0x004C	/* 16 bit	Power Management
												 *			Control/Status
												 *			Register
												 */
#define	PCI_PM_DATA						0x004F	/*  8 bit	Power Management
												 *			Data Register
												 */
//#define	PCI_VPD_CAP_ID					0x0050	/*  8 bit	VPD Capability ID
//												 *			Register (VPD Cap
//												 *			ID)
//												 */
#define	PCI_VPD_NPTR					0x0051	/*  8 bit	VPD Next Item
												 *			Pointer Register
												 */
#ifdef XXX	/* Naming Conflict with Linux */
#define	PCI_VPD_ADDR					0x0052	/* 16 bit	VPD Address Register */
#define	PCI_VPD_DATA					0x0054	/* 32 bit	VPD Data Register */
#endif /* XXX */
#define	PCI_LDR_CTRL					0x0058	/* 32 bit	TWSI EEPROM Loader
												 *			Control Register
												 */
//#define	PCI_MSI_CAP_ID					0x005C	/*  8 bit	MSI Capability ID
//												 *			Register (MSI Cap
//												 *			ID)
//												 */
#define	PCI_MSI_NPTR					0x005D	/*  8 bit	MSI Next Item
												 *			Pointer Register
												 */
//#define	PCI_MSI_CTRL					0x005E	/* 16 bit	MSI Message Control
//												 *			Register
//												 */
#define	PCI_MSI_ADDR_LO					0x0060	/* 32 bit	MSI Message Address
												 *			Register, Lower
												 *			Address
												 */
#define	PCI_MSI_ADDR_HI					0x0064	/* 32 bit	MSI Message Address
												 *			Register, Upper
												 *			Address
												 */
//#define	PCI_MSI_DATA					0x0068	/* 32 bit	MSI Message Data
//												 *			Register
//												 */
#define	PCIE_STAT						0x0070	/* 32 bit	PCI Express Status
												 *			Register
												 */
#define	PCIE_OUR_STAT					0x007C	/* 32 bit	Our Status Register */
#define	PCIE_OUR3						0x0080	/* 32 bit	Our Register 3 */
#define	PCIE_OUR4						0x0084	/* 32 bit	Our Register 4 */
#define	PCIE_OUR5						0x0088	/* 32 bit	Our Register 5 */
#define	PCIE_ER_MASK					0x008C	/* 32 bit	Error Reporting
												 *			Mask Register
												 */
#define	CONFIG_REG0						0x0090	/* 32 bit	Config Register 0 */
#define	CONFIG_REG1						0x0094	/* 32 bit	Config Register 1 */
#define	PSM_CONFIG_REG0					0x0098	/* 32 bit	PSM Config Register
												 *			0
												 */
#define	PSM_CONFIG_REG1					0x009C	/* 32 bit	PSM Config Register
												 *			1
												 */
                                                /* Yukon-FE+ */
#define	VPD_CTRL_ADD					0x00A0	/* 32 bit	VPD Start End
												 *			Address
												 */
                                                /* Yukon-FE+ */
#define	OTP_LDR_CTRL					0x00A4	/* 32 bit	OTP Loader Control
												 *			Register
												 */
                                                /* Yukon-FE+ */
#define	OTP_MEM_CTRL_0					0x00A8	/* 32 bit	OTP Memory Control
												 *			Register 0
												 */
                                                /* Yukon-FE+ */
#define	OTP_MEM_CTRL_1					0x00AC	/* 32 bit	OTP Memory Control
												 *			Register 1
												 */
                                                /* Yukon-FE+ */
#define	OTP_MEM_CTRL_2					0x00B0	/* 32 bit	OTP Memory Control
												 *			Register 2
												 */
                                                /* Yukon-FE+ */
#define	OTP_MEM_ST_0					0x00B4	/* 32 bit	OTP Memory Status
												 *			Register 0
												 */
                                                /* Yukon-FE+ */
#define	VPD_CTRL						0x00B8	/* 32 bit	EEPROM and OTP
												 *			Control Register
												 */
                                                /* Yukon-FE+ */
#define	OTP_MEM_CTRL_3					0x00BC	/* 32 bit	LDO Control Register */
#define	PCIE_CAP_ID						0x00C0	/*  8 bit	PE Capability ID
												 *			Register (PM Cap
												 *			ID)
												 */
#define	PCIE_NPTR						0x00C1	/*  8 bit	PE Next Item
												 *			Pointer Register
												 */
#define	PCIE_CAP						0x00C2	/* 16 bit	PE Capabilities
												 *			Register
												 */
#define	DEVICE_CAPABILITIES_REGISTER	0x00C4	/* 32 bit	Device Capabilities
												 *			Register
												 */
#define	PCIE_DEVCTRL					0x00C8	/* 16 bit	Device Control
												 *			Register
												 */
#define	PCIE_DEVSTAT					0x00CA	/* 16 bit	Device Status
												 *			Register
												 */
#define	PCIE_LNKCAP						0x00CC	/* 32 bit	Link Capabilities
												 *			Register
												 */
#define	PCIE_LNKCTRL					0x00D0	/* 16 bit	Link Control
												 *			Register
												 */
#define	PCIE_LNKSTAT					0x00D2	/* 16 bit	Link Status Register */
#define	PCIE_DEV_CAP_2					0x00E4	/* 32 bit	Device Capabilities
												 *			2 Register
												 */
#define	PCIE_DEV_CTRL_2					0x00E8	/* 32 bit	Device Control 2
												 *			Register
												 */
#define	PCIE_AE_CAP_HDR					0x0100	/* 32 bit	Advanced Error
												 *			Reporting
												 *			Enhanced
												 *			Capability Header
												 *			Register
												 */
#define	PCIE_UE_STAT					0x0104	/* 32 bit	Uncorrectable Error
												 *			Status Register
												 */
#define	PCIE_UE_MASK					0x0108	/* 32 bit	Uncorrectable Error
												 *			Mask Register
												 */
#define	PCIE_UE_SVRT					0x010C	/* 32 bit	Uncorrectable Error
												 *			Severity Register
												 */
#define	PCIE_CA_STAT					0x0110	/* 32 bit	Correctable Error
												 *			Status Register
												 */
#define	PCIE_CA_MASK					0x0114	/* 32 bit	Correctable Error
												 *			Mask Register
												 */
#define	PCIE_AE_CAPCTRL					0x0118	/* 32 bit	Advanced Error
												 *			Capabilities and
												 *			Control Register
												 */
#define	PCIE_HDRLOG						0x011C 	/* 13 bit	Header Log Registers */
#define	PCIE_DEVSERNUMCAP				0x0130	/* 32 bit	Device Serial
												 *			Number Enhanced
												 *			Capability Header
												 */
#define	PCIE_SERNUM_LOWDW				0x0134	/* 32 bit	Serial Number
												 *			Register (Lower
												 *			DW)
												 */
#define	PCIE_SERNUM_UPPDW				0x0138	/* 32 bit	Serial Number
												 *			Register (Upper
												 *			DW)
												 */
#define	PCIE_PWRBDGT_CAPHDR				0x0140	/* 32 bit	Power Budgeting
												 *			Enhanced
												 *			Capability Header
												 */
#define	PCIE_PWRBDGT_DATASEL			0x0144	/* 32 bit	Power Budgeting
												 *			Data Select
												 *			Register
												 */
#define	PCIE_PWRBDGT_DATA				0x0148	/* 32 bit	Power Budgeting
												 *			Data Register
												 */
#define	PCIE_PWRBDGT_CAP				0x014c	/* 32 bit	Power Budgeting
												 *			Capability
												 *			Register
												 */
#define	PCIE_TL_CTRL					0x0200	/* 32 bit	Transaction Layer
												 *			Control Register
												 */
#define	PCIE_TL_STAT					0x0204	/* 32 bit	Transaction Layer
												 *			Status Register
												 */
#define	PCIE_DL_CTRL					0x0208	/* 32 bit	Data Link Layer
												 *			Control Register
												 */
#define	PCIE_DL_STAT					0x020C	/* 32 bit	Data Link Layer
												 *			Status Register
												 */
#define	PCIE_PL_CTRL					0x0210	/* 32 bit	PE Physical Layer
												 *			Control Register
												 */
#define	PCIE_PL_STAT					0x0214	/* 32 bit	PE Physical Layer
												 *			Status Register
												 */
#define	PCIE_CPLTO						0x0220	/* 32 bit	PE Completion
												 *			Timeout Register
												 */
#define	PCIE_FC							0x0224	/* 32 bit	PE Flow Control
												 *			Register
												 */
#define	PCIE_ACKTIM_X1					0x0228	/* 32 bit	PE Ack Timer for 1x
												 *			Link Register
												 */

/*
 *
 *	THE BIT DEFINES
 *
 */
/*	PCI_VEN_ID						0x0000	Vendor ID Register */
#define	PCI_VEN_ID_MSK		SHIFT0(0xffffU)	/* Vendor ID */
#define	PCI_VEN_ID_BASE		BIT_0S

/*	PCI_DEV_ID						0x0002	Device ID Register */
#define	PCI_DEV_ID_MSK		SHIFT0(0xffffU)	/* Device ID */
#define	PCI_DEV_ID_BASE		BIT_0S

/*	PCI_CMD							0x0004	Command Register */
/*		Bit(s) PCI_CMD_RSRV_15_11 reserved */
#define	PCI_CMD_INT_DIS				BIT_10S			/* Interrupt Disable */
/*		Bit(s) PCI_CMD_RSRV_9 reserved */
#define	PCI_CMD_SERR_ENA			BIT_8S			/* SERR Enable */
/*		Bit(s) PCI_CMD_RSRV_7 reserved */
#define	PCI_CMD_PERREN				BIT_6S			/* PERREN */
/*		Bit(s) PCI_CMD_RSRV_5_3 reserved */
#define	PCI_CMD_BMEN				BIT_2S			/* BMEN */
#define	PCI_CMD_MEMEN				BIT_1S			/* MEMEN */
#define	PCI_CMD_IOEN				BIT_0S			/* IOEN */

/*	PCI_STAT						0x0006	Status Register */
#define	PCI_STAT_PERR				BIT_15S			/* PERR */
#define	PCI_STAT_SERR				BIT_14S			/* SERR */
#define	PCI_STAT_RMABORT			BIT_13S			/* RMABORT */
#define	PCI_STAT_RTABORT			BIT_12S			/* RTABORT */
/*		Bit(s) PCI_STAT_RSRV_11_9 reserved */
#define	PCI_STAT_DATAPERR			BIT_8S			/* DATAPERR */
/*		Bit(s) PCI_STAT_RSRV_7_5 reserved */
#define	PCI_STAT_NEWCAP				BIT_4S			/* NEWCAP */
#define	PCI_STAT_INTSTA				BIT_3S			/* INTSTA */
/*		Bit(s) PCI_STAT_RSRV_2_0 reserved */

/*	PCI_REV_ID						0x0008	Revision ID Register */
#define	PCI_REV_ID_MSK		SHIFT0(0xffU)	/* Revision ID */
#define	PCI_REV_ID_BASE		BIT_0S

/*	PCI_PIF							0x0009	Programming Interface Register,
 *											Lower Byte
 */
#define	PCI_PIF_MSK			SHIFT0(0xffU)	/* Prog IF */
#define	PCI_PIF_BASE		BIT_0S

/*	PCI_SCC							0x000A	Sub-Class Register, Middle Byte */
#define	PCI_SCC_MSK			SHIFT0(0xffU)	/* Sub Class */
#define	PCI_SCC_BASE		BIT_0S

/*	PCI_BCC							0x000B	Base-Class Register, Upper Byte */
#define	PCI_BCC_MSK			SHIFT0(0xffU)	/* Base Class */
#define	PCI_BCC_BASE		BIT_0S

/*	PCI_CLS							0x000C	Cache Line Size Register */
/*		Bit(s) PCI_CLS_RSRV_7_0 reserved */

/*	PCI_LAT_TIM						0x000D	Latency Timer Register */
/*		Bit(s) PCI_LAT_TIM_RSRV_7_0 reserved */

/*	PCI_HDRTYP						0x000E	Header Type Register */
/*		Bit(s) PCI_HDRTYP_RSRV_7_0 reserved */

/*	PCI_BIST						0x000F	Built-in Self Test (BIST) Register */
/*		Bit(s) PCI_BIST_RSRV_7_0 reserved */

/*	PCI_BAR1_LO						0x0010	Base Address Register (1st), Lower
 *											Address
 */
#define	PCI_BAR1_LO_BASE_MSK		SHIFT14(0x3ffff)	/* Lower MEMBASE Address */
#define	PCI_BAR1_LO_BASE_BASE		14
#define	PCI_BAR1_LO_SIZE_MSK		SHIFT4(0x3ff)		/* MEMSIZE */
#define	PCI_BAR1_LO_SIZE_BASE		4
#define	PCI_BAR1_LO_PREFEN			BIT_3				/* PREFEN */
#define	PCI_BAR1_LO_TYPE_MSK		SHIFT1(0x3)			/* Memory Type */
#define	PCI_BAR1_LO_TYPE_BASE		1
#define	PCI_BAR1_LO_IO_SPC			BIT_0				/* MEMSPACE */

/*	PCI_BAR1_HI						0x0014	Base Address Register (1st), Upper
 *											Address
 */
#define	PCI_BAR1_HI_BASE_MSK		SHIFT0(0xffffffff)	/* Upper MEMBASE */
#define	PCI_BAR1_HI_BASE_BASE		0

/*	PCI_BAR2						0x0018	Base Address Register (2nd) */
#define	PCI_BAR2_BASE_MSK		SHIFT8(0xffffff)	/* IOBASE */
#define	PCI_BAR2_BASE_BASE		8
#define	PCI_BAR2_SIZE_MSK		SHIFT2(0x3f)		/* IOSIZE */
#define	PCI_BAR2_SIZE_BASE		2
/*		Bit(s) PCI_BAR2_RSRV_1 reserved */
#define	PCI_BAR2_IO_SPC			BIT_0				/* IOSPACE */

/*	PCI_SSVEN_ID					0x002C	Subsystem Vendor ID Register */
#define	PCI_SSVEN_ID_MSK		SHIFT0(0xffffU)	/* Subsystem Vendor ID */
#define	PCI_SSVEN_ID_BASE		0

/*	PCI_SSDEV_ID					0x002E	Subsystem ID Register */
#define	PCI_SSDEV_ID_MSK		SHIFT0(0xffffU)	/* Subsystem ID */
#define	PCI_SSDEV_ID_BASE		0

/*	PCI_ERBAR						0x0030	Expansion Rom Base Address Register */
#define	PCI_ERBAR_BASE_MSK				SHIFT17(0x7fff)	/* Rombase */
#define	PCI_ERBAR_BASE_BASE				17
#define	PCI_ERBAR_BASE_SIZE_MSK			SHIFT14(0x7)	/* Rombase/size */
#define	PCI_ERBAR_BASE_SIZE_BASE		14
#define	PCI_ERBAR_SIZE_MSK				SHIFT11(0x7)	/* Romsize */
#define	PCI_ERBAR_SIZE_BASE				11
/*		Bit(s) PCI_ERBAR_RSRV_10_1 reserved */
#define	PCI_ERBAR_ENA					BIT_0			/* ROMEN */

/*	PCI_NCAP_PTR					0x0034	New Capabilities Pointer (New Cap
 *											Ptr) Register
 */
#define	PCI_NCAP_PTR_MSK		SHIFT0(0xffU)	/* New Capabilities Pointer */
#define	PCI_NCAP_PTR_BASE		0

/*	PCI_INT_LINE					0x003C	Interrupt Line Register */
#define	PCI_INT_LINE_MSK		SHIFT0(0xffU)	/* Interrupt Line */
#define	PCI_INT_LINE_BASE		0

/*	PCI_INT_PIN						0x003D	Interrupt Pin Register */
#define	PCI_INT_PIN_MSK			SHIFT0(0xffU)	/* Interrupt Pin */
#define	PCI_INT_PIN_BASE		0

/*	PCI_MIN_GNT						0x003E	Min_Gnt Register */
/*		Bit(s) PCI_MIN_GNT_RSRV_7_0 reserved */

/*	PCI_MAX_LAT						0x003F	Max_Lat Register */
/*		Bit(s) PCI_MAX_LAT_RSRV_7_0 reserved */

/*	PCI_OUR1						0x0040	Our Register 1 */
/*		Bit(s) PCI_OUR1_RSRV_31 reserved */
#define	PCI_OUR1_SW_POR					BIT_30			/* SW POR */
/* Enable Gen Preset during SW POR */
#define	PCI_OUR1_EN_GEN_PRSET			BIT_29			
#define	PCI_OUR1_GP_COMA				BIT_28			/* PHY Coma Mode */
#define	PCI_OUR1_DIS_SPI_LOAD			BIT_27			/* Disable SPI Loader */
#define	PCI_OUR1_GP_PWD					BIT_26			/* PHY Power Down Mode */
#define	PCI_OUR1_DIS_VPD_LOAD			BIT_25			/* Disable VPD Loader */
#define	PCI_OUR1_ENBOOT					BIT_24			/* En Boot */
#define	PCI_OUR1_ENIOMAP				BIT_23			/* En IO Mapping */
#define	PCI_OUR1_ENEPROM				BIT_22			/* En Eprom */
#define	PCI_OUR1_PAGE_SIZ_MSK			SHIFT20(0x3)	/* Pagesize<1:0> */
#define	PCI_OUR1_PAGE_SIZ_BASE			20
/*		Bit(s) PCI_OUR1_RSRV_19 reserved */
#define	PCI_OUR1_PAGE_SEL_MSK			SHIFT16(0x7)	/* Page Reg<2:0> */
#define	PCI_OUR1_PAGE_SEL_BASE			16
#define	PCI_OUR1_DBG_PEX_PME			BIT_15			/* DEBUG_PEX_PME */
/*		Bit(s) PCI_OUR1_RSRV_14_10 reserved */
/* Timer for GPHY Link Trigger */
#define	PCI_OUR1_GP_TRIG_TIM_MSK		SHIFT8(0x3)		
#define	PCI_OUR1_GP_TRIG_TIM_BASE		8
#define	PCI_OUR1_L1_EVT_ENA				BIT_7			/* L1 Event Enable */
#define	PCI_OUR1_GP_LNK_ENA				BIT_6			/* Enable GPHY Link */
#define	PCI_OUR1_FORCE_L1				BIT_5			/* Force to L1 */
/*		Bit(s) PCI_OUR1_RSRV_4_1 reserved */
/* PCIE Receiver Overflow Control */
#define	PCI_OUR1_PEX_RX_OF_CTRL			BIT_0			

/*	PCI_OUR2						0x0044	Our Register 2 */
/*		Bit(s) PCI_OUR2_RSRV_31_24 reserved */
#define	PCI_OUR2_VPD_DEVSEL_MSK			SHIFT17(0x7f)	/* VPD Devsel */
#define	PCI_OUR2_VPD_DEVSEL_BASE		17
#define	PCI_OUR2_VPD_ROMSIZE_MSK		SHIFT14(0x7)	/* VPD ROM Size */
#define	PCI_OUR2_VPD_ROMSIZE_BASE		14
/*		Bit(s) PCI_OUR2_RSRV_13_0 reserved */

/*	PCI_PM_CAP_ID					0x0048	Power Management Capability ID
 *											Register (PM Cap ID)
 */
#define	PCI_PM_CAP_ID_MSK		SHIFT0(0xffU)	/* Cap ID */
#define	PCI_PM_CAP_ID_BASE		0

/*	PCI_PM_NXT_PTR					0x0049	Power Management Next Item Pointer
 *											Register
 */
#define	PCI_PM_NXT_PTR_MSK		SHIFT0(0xffU)	/* Next Item Ptr */
#define	PCI_PM_NXT_PTR_BASE		0

/*	PCI_PM_CAP						0x004A	Power Management Capabilities
 *											Register
 */
#define	PCI_PM_CAP_D3C_ENA				BIT_15S			/* PME Support */
#define	PCI_PM_CAP_D3H_ENA				BIT_14S			/* PME Support */
#define	PCI_PM_CAP_D2_ENA				BIT_13S			/* PME Support */
#define	PCI_PM_CAP_D1_ENA				BIT_12S			/* PME Support */
#define	PCI_PM_CAP_D0_ENA				BIT_11S			/* PME Support */
#define	PCI_PM_CAP_D2_SUP				BIT_10S			/* D2 Support */
#define	PCI_PM_CAP_D1_SUP				BIT_9S			/* D1 Support */
/*		Bit(s) PCI_PM_CAP_RSRV_8_6 reserved */
#define	PCI_PM_CAP_DSI_ENA				BIT_5S			/* DSI */
/*		Bit(s) PCI_PM_CAP_RSRV_4_3 reserved */
#define	PCI_PM_CAP_VER_ID_MSK			SHIFT0(0x7U)	/* Version */
#define	PCI_PM_CAP_VER_ID_BASE			0

/*	PCI_PM_CSR						0x004C	Power Management Control/Status
 *											Register
 */
#define	PCI_PM_CSR_PME_STAT				BIT_15S			/* PME Status */
#define	PCI_PM_CSR_D_SCALE_MSK			SHIFT13(0x3U)	/* Data Scale */
#define	PCI_PM_CSR_D_SCALE_BASE			13
#define	PCI_PM_CSR_D_SEL_MSK			SHIFT9(0xfU)	/* Data Select */
#define	PCI_PM_CSR_D_SEL_BASE			9
#define	PCI_PM_CSR_PMEEN				BIT_8S			/* PME En */
/*		Bit(s) PCI_PM_CSR_RSRV_7_2 reserved */
#define	PCI_PM_CSR_PWST_MSK				SHIFT0(0x3U)	/* Power State */
#define	PCI_PM_CSR_PWST_BASE			0

/*	PCI_PM_DATA						0x004F	Power Management Data Register */
#define	PCI_PM_DATA_MSK			SHIFT0(0xffU)	/* Data */
#define	PCI_PM_DATA_BASE		0

/*	PCI_VPD_CAP_ID					0x0050	VPD Capability ID Register (VPD
 *											Cap ID)
 */
#define	PCI_VPD_CAP_ID_MSK		SHIFT0(0xffU)	/* Cap ID */
#define	PCI_VPD_CAP_ID_BASE		0

/*	PCI_VPD_NPTR					0x0051	VPD Next Item Pointer Register */
#define	PCI_VPD_NPTR_MSK		SHIFT0(0xffU)	/* Next Item Ptr */
#define	PCI_VPD_NPTR_BASE		0

/*	PCI_VPD_ADDR					0x0052	VPD Address Register */
#define	PCI_VPD_ADDR_FLAG		BIT_15S			/* Flag */
#define	PCI_VPD_ADDR_MSK		SHIFT0(0x7fffU)	/* VPD Address */
#define	PCI_VPD_ADDR_BASE		0

/*	PCI_VPD_DATA					0x0054	VPD Data Register */
#define	PCI_VPD_DATA_MSK		SHIFT0(0xffffffff)	/* VPD Data */
#define	PCI_VPD_DATA_BASE		0

/*	PCI_LDR_CTRL					0x0058	TWSI EEPROM Loader Control Register */
#define	PCI_LDR_CTRL_FLAG			BIT_31			/* Flag */
#define	PCI_LDR_CTRL_ADDR_MSK		SHIFT16(0x7fff)	/* TWSI EEPROM loader Address */
#define	PCI_LDR_CTRL_ADDR_BASE		16
/* EEPROM loader start Address for PCI loader */
#define	PCI_LDR_CTRL_ADDR_PCI 		SHIFT8(0xff)	
#define	PCI_LDR_CTRL_ADDR_PCIB		8
/* EEPROM loader start Address for PIG */
#define	PCI_LDR_CTRL_ADDR_PIG		SHIFT0(0xff)	
#define	PCI_LDR_CTRL_ADDR_PIGB		0

/*	PCI_MSI_CAP_ID					0x005C	MSI Capability ID Register (MSI
 *											Cap ID)
 */
#define	PCI_MSI_CAP_ID_MSK		SHIFT0(0xffU)	/* Cap ID */
#define	PCI_MSI_CAP_ID_BASE		0

/*	PCI_MSI_NPTR					0x005D	MSI Next Item Pointer Register */
#define	PCI_MSI_NPTR_MSK		SHIFT0(0xffU)	/* Next Item Ptr */
#define	PCI_MSI_NPTR_BASE		0

/*	PCI_MSI_CTRL					0x005E	MSI Message Control Register */
/*		Bit(s) PCI_MSI_CTRL_RSRV_15_8 reserved */
#define	PCI_MSI_CTRL_64CAP				BIT_7S			/* 64 Bit Addr capable */
#define	PCI_MSI_CTRL_MM_ENA_MSK			SHIFT4(0x7U)	/* Multiple Message Enable */
#define	PCI_MSI_CTRL_MM_ENA_BASE		4
#define	PCI_MSI_CTRL_MM_CAP_MSK			SHIFT1(0x7U)	/* Multiple Message Capable */
#define	PCI_MSI_CTRL_MM_CAP_BASE		1
#define	PCI_MSI_CTRL_ENA				BIT_0S			/* MSI Enable */

/*	PCI_MSI_ADDR_LO					0x0060	MSI Message Address Register,
 *											Lower Address
 */
/* MSI Message Address, Lower Address */
#define	PCI_MSI_ADDR_LO_MSK					SHIFT2(0x3fffffff)	
#define	PCI_MSI_ADDR_LO_BASE				2
/*		Bit(s) PCI_MSI_ADDR_LO_RSRV_1_0 reserved */

/*	PCI_MSI_ADDR_HI					0x0064	MSI Message Address Register,
 *											Upper Address
 */
/* MSI Message Address, Upper Address */
#define	PCI_MSI_ADDR_HI_MSK			SHIFT0(0xffffffff)	
#define	PCI_MSI_ADDR_HI_BASE		0

/*	PCI_MSI_DATA					0x0068	MSI Message Data Register */
/*		Bit(s) PCI_MSI_DATA_RSRV_31_16 reserved */
#define	PCI_MSI_DATA_MSK					SHIFT0(0xffff)	/* Message Data */
#define	PCI_MSI_DATA_BASE					0

/*	PCIE_STAT						0x0070	PCI Express Status Register */
/*		Bit(s) PCIE_STAT_RSRV_31_30 reserved */
#define	PCIE_STAT_FIX_MSK				SHIFT16(0x3fff)	/* Fixed value */
#define	PCIE_STAT_FIX_BASE				16
#define	PCIE_STAT_BUS_NUM_MSK			SHIFT8(0xff)	/* Request ID (Bus Number) */
#define	PCIE_STAT_BUS_NUM_BASE			8
/* Request ID (Device Number) */
#define	PCIE_STAT_DEV_NUM_MSK			SHIFT3(0x1f)	
#define	PCIE_STAT_DEV_NUM_BASE			3
/* Request ID (Function Number) */
#define	PCIE_STAT_FUN_NUM_MSK			SHIFT0(0x7)		
#define	PCIE_STAT_FUN_NUM_BASE			0

/*	PCIE_OUR_STAT					0x007C	Our Status Register */
/*		Bit(s) PCIE_OUR_STAT_RSRV_31_26 reserved */
#define	PCIE_OUR_STAT_DLL_ERR_MSK			SHIFT24(0x3)	/* DLL Err */
#define	PCIE_OUR_STAT_DLL_ERR_BASE			24
#define	PCIE_OUR_STAT_DLL_ROW_MSK			SHIFT20(0xf)	/* DLL Row */
#define	PCIE_OUR_STAT_DLL_ROW_BASE			20
#define	PCIE_OUR_STAT_DLL_COL_MSK			SHIFT16(0xf)	/* DLL Col */
#define	PCIE_OUR_STAT_DLL_COL_BASE			16
/*		Bit(s) PCIE_OUR_STAT_RSRV_15_0 reserved */

/*	PCIE_OUR3						0x0080	Our Register 3 */
/* Mask L0 condition */
#define	PCIE_OUR3_MASK_L0_COMMA					BIT_31			
/* Mask L0s condition */
#define	PCIE_OUR3_MASK_L0S_COMMA				BIT_30			
/* Select MACSec clock */
#define	PCIE_OUR3_MACSEC_CLK_SEL				BIT_29			
/*		Bit(s) PCIE_OUR3_RSRV_27_20 reserved */
/* Select MAC RX clock for TX */
#define	PCIE_OUR3_CLK_RX_TO_TX					BIT_28
/* disable clk_clk for MAC and PHY */
#define	PCIE_OUR3_CLK_PHY_DIS					BIT_19
#define	PCIE_OUR3_CLK_ASF_REGS_DIS				BIT_18			/* disable clk_asf */
/* disable clk_macsec */
#define	PCIE_OUR3_CLK_MACSEC_REGS_DIS			BIT_17			
/* disable clk_pci_regs_d0 */
#define	PCIE_OUR3_CLK_PCI_REGS_DIS				BIT_16			
/* disable clk_core_ytb_arb */
#define	PCIE_OUR3_CLK_CORE_YTB_ARB_DIS			BIT_15			
/* disable clk_mac_lnk1_d3 */
#define	PCIE_OUR3_CLK_MAC_LNK1_D3_DIS			BIT_14			
/* disable clk_core_lnk1_d0 */
#define	PCIE_OUR3_CLK_CORE_LNK1_D0_DIS			BIT_13			
/* disable clk_mac_lnk1_d0 */
#define	PCIE_OUR3_CLK_MAC_LNK1_D0_DIS			BIT_12			
/* disable clk_core_lnk1_d3 */
#define	PCIE_OUR3_CLK_CORE_LNK1_D3_DIS			BIT_11			
/* disable clk_pci_master_arb */
#define	PCIE_OUR3_CLK_PCI_MST_ARB_DIS			BIT_10			
/* disable clk_core_regs_d3 */
#define	PCIE_OUR3_CLK_CORE_REGS_D3_DIS			BIT_9			
/* disable clk_pci_regs_d3 */
#define	PCIE_OUR3_CLK_PCI_REGS_D3_DIS			BIT_8			
/* disable clk_ref_lnk1_gmac */
#define	PCIE_OUR3_CLK_REF_LNK1_GMAC_DIS			BIT_7			
/* disable clk_core_lnk1_gmac */
#define	PCIE_OUR3_CLK_CORE_LNK1_GMAC_DIS		BIT_6			
/* disable clk_pci_common */
#define	PCIE_OUR3_CLK_PCI_COM_DIS				BIT_5			
/* disable clk_core_common */
#define	PCIE_OUR3_CLK_CORE_COM_DIS				BIT_4			
/* disable clk_pci_lnk1_bmu */
#define	PCIE_OUR3_CLK_PCI_LNK1_BMU_DIS			BIT_3			
/* disable clk_core_lnk1_bmu */
#define	PCIE_OUR3_CLK_CORE_LNK1_BMU_DIS			BIT_2			
/* disable pci_clk_biu */
#define	PCIE_OUR3_PCI_CLK_BIU_DIS				BIT_1			
/* disable clk_core_biu */
#define	PCIE_OUR3_CLK_CORE_BIU_DIS				BIT_0			

#define PCIE_OUR3_WOL_D3_COLD_SETTING		\
	( PCIE_OUR3_CLK_CORE_LNK1_BMU_DIS	|	\
	  PCIE_OUR3_CLK_CORE_COM_DIS		|	\
	  PCIE_OUR3_CLK_PCI_MST_ARB_DIS		|	\
	  PCIE_OUR3_CLK_MAC_LNK1_D0_DIS		|	\
	  PCIE_OUR3_CLK_CORE_LNK1_D0_DIS	|	\
	  PCIE_OUR3_CLK_PCI_REGS_DIS		|	\
	  PCIE_OUR3_CLK_MACSEC_REGS_DIS 	|	\
	  PCIE_OUR3_CLK_ASF_REGS_DIS)

/*	PCIE_OUR4						0x0084	Our Register 4 */
/* PEXUNIT LTSSM State for Gating Core Clock */
#define	PCIE_OUR4_PEX_LTSSM_STATE_MSK			SHIFT25(0x7f)	
#define	PCIE_OUR4_PEX_LTSSM_STATE_BASE			25
#define	PCIE_OUR4_GPHY_INT_ASPM					BIT_24			/* GPHY get INT */
#define	PCIE_OUR4_TIM_VAL_MSK					SHIFT16(0xff)	/* Timer Value */
#define	PCIE_OUR4_TIM_VAL_BASE					16
/* Force ASPM Request */
#define	PCIE_OUR4_FORCE_ASPM_REQ				BIT_15			
#define	PCIE_OUR4_GPHY_LNK_DOWN					BIT_14			/* GPHY Link Down */
/* Internal FIFO Empty */
#define	PCIE_OUR4_INT_FIFO_EMPTY				BIT_13			
#define	PCIE_OUR4_CLKRUN_REQ					BIT_12			/* Clkrun Request */
/* Enable EC SMBUS Pin mode */
#define	PCIE_OUR4_EN_EC_SMBUS_PIN				BIT_11			
/* Enable PCIE RX Overflow status */
#define	PCIE_OUR4_EN_PCIE_RX_OVERFLOW			BIT_10			
/* Enable ASPM at No-D0 mode */
#define	PCIE_OUR4_EN_ASPM_NOND0					BIT_9			
/* Enable PIN#63 as LED_LIN */
#define	PCIE_OUR4_EN_LED_LINK_PIN63				BIT_8			
/* Force ASPM L1 Enable */
#define	PCIE_OUR4_FORCE_ASPM_L1_ENA				BIT_7			
/* Force ASPM L0s Enable */
#define	PCIE_OUR4_FORCE_ASPM_L0S_ENA			BIT_6			
/* Force CLKREQn Pin Low */
#define	PCIE_OUR4_FORCE_CLKREQN_PIN_LO			BIT_5			
/* Force CLKREQ Scheme Enable */
#define	PCIE_OUR4_FORCE_CLKREQ_SCHEME_ENA		BIT_4			
/* CLKREQn PAD Control */
#define	PCIE_OUR4_CLKREQN_PAD_CTRL				BIT_3			
#define	PCIE_OUR4_A1_MODE_SEL					BIT_2			/* A1 Mode Select */
/* Enable Gate Pexunit Clock */
#define	PCIE_OUR4_GATE_PEXUNIT_CLK_ENA			BIT_1			
/* Enable Gate Root Core Clock */
#define	PCIE_OUR4_GATE_ROOT_CORE_CLK_ENA		BIT_0			

#if 0
#define PCIE_OUR4_WOL_D3_COLD_SETTING		\
	( PCIE_OUR4_GATE_ROOT_CORE_CLK_ENA	|	\
	  PCIE_OUR4_GATE_PEXUNIT_CLK_ENA	|	\
	  PCIE_OUR4_TIM_VAL_MSK )
#endif

/*	PCIE_OUR5						0x0088	Our Register 5 */
/* Divide Core Clock Enable */
#define	PCIE_OUR5_DIV_CORE_CLK_ENA				BIT_31			
/* Soft Reset for Vmain_avlbl De-Glitch Logic */
#define	PCIE_OUR5_SOFT_RST_VMAIN_DEGLITCH		BIT_30			
/* Bypass Enable for Vmain_avlbl De-Glitch */
#define	PCIE_OUR5_BYPASS_VMAIN_DEGLITCH_ENA		BIT_29			
/* Timer of Vmain_avlbl De-Glitch */
#define	PCIE_OUR5_TIM_VMAIN_DEGLITCH_MSK		SHIFT27(0x3)	
#define	PCIE_OUR5_TIM_VMAIN_DEGLITCH_BASE		27
/* PCI-E Reset De-Asserted */
#define	PCIE_OUR5_PCIE_RST_DEASS				BIT_26			
/* GPHY Received Packet */
#define	PCIE_OUR5_GPHY_RX_PKT					BIT_25			
/* Internal FIFO Not Empty */
#define	PCIE_OUR5_INT_FIFO_NOT_EMPTY			BIT_24			
/* Main Power is Available */
#define	PCIE_OUR5_MAIN_PWR_AVL					BIT_23			
#define	PCIE_OUR5_CLKRUN_REQ					BIT_22			/* CLKRUN Request */
/* PCI-E Reset Asserted */
#define	PCIE_OUR5_PCIE_RST_ASS					BIT_21			
#define	PCIE_OUR5_PME_ASS						BIT_20			/* PME Asserted */
/* PCI-E Exits L1 State */
#define	PCIE_OUR5_PCIE_EX_L1_STATE				BIT_19			
/* EPROM Loader Not Finished */
#define	PCIE_OUR5_EPROM_LDR_NOT_FIN				BIT_18			
/* PCI-E RX Exits ELEC IDLE */
#define	PCIE_OUR5_PCIE_RX_EX_ELEC_IDLE			BIT_17			
#define	PCIE_OUR5_GPHY_LNK_UP					BIT_16			/* GPHY Link Up */
/* CPU Goes to Sleep */
#define	PCIE_OUR5_CPU_SLEEP						BIT_15			
#define	PCIE_OUR5_GPHY_INT						BIT_14			/* GPHY get INT */
/*		Bit(s) PCIE_OUR5_RSRV_13 reserved */
#define	PCIE_OUR5_GPHY_INT_EV					BIT_12			/* GPHY get INT */
/* CPU Goes to Sleep and Events */
#define	PCIE_OUR5_CPU_SLEEP_EV					BIT_11			
/* PCI-E Reset Asserted and Events */
#define	PCIE_OUR5_PCIE_RST_ASS_EV				BIT_10			
/* GPHY Not Received Packet */
#define	PCIE_OUR5_GPHY_NOT_RX_PKT				BIT_9			
/* Internal FIFO Empty */
#define	PCIE_OUR5_INTERNAL_FIFO_EMPTY			BIT_8			
/* Main Power is Not Available */
#define	PCIE_OUR5_MAIN_PWR_NOT_AVL				BIT_7			
/* CLKRUN Not Requested */
#define	PCIE_OUR5_CLKRUN_NOT_REQ				BIT_6			
/* PCI-E Reset De-Asserted and Events */
#define	PCIE_OUR5_PCIE_RST_DEASS_EV				BIT_5			
#define	PCIE_OUR5_PME_DEASS						BIT_4			/* PME De-Asserted */
/* PCI-E Goes to L1 State */
#define	PCIE_OUR5_PCIE_GO_L1_STATE				BIT_3			
/* EPROM Loader Finished */
#define	PCIE_OUR5_EPROM_LDR_FIN					BIT_2			
/* PCI-E Rx ELEC IDLE */
#define	PCIE_OUR5_PCIE_RX_ELEC_IDLE				BIT_1			
#define	PCIE_OUR5_GPHY_LNK_DOWN					BIT_0			/* GPHY Link Down */

#if 0
#define PCIE_OUR5_WOL_D3_COLD_SETTING		\
	( PCIE_OUR5_PME_DEASS				|	\
	  PCIE_OUR5_CLKRUN_NOT_REQ			|	\
	  PCIE_OUR5_MAIN_PWR_NOT_AVL		|	\
	  PCIE_OUR5_INTERNAL_FIFO_EMPTY		|	\
	  PCIE_OUR5_GPHY_NOT_RX_PKT			|	\
	  PCIE_OUR5_PME_ASS					|	\
	  PCIE_OUR5_CLKRUN_REQ				|	\
	  PCIE_OUR5_MAIN_PWR_AVL			|	\
	  PCIE_OUR5_INT_FIFO_NOT_EMPTY		|	\
	  PCIE_OUR5_GPHY_RX_PKT				|	\
	  PCIE_OUR5_DIV_CORE_CLK_ENA )
#endif

/*	PCIE_ER_MASK					0x008C	Error Reporting Mask Register */
/* Enable the Device Feature Set SERR */
#define	PCIE_ER_MASK_DEV_FEAT_SET_SERR_ENA		BIT_31			
/* Receiver Error Mask */
#define	PCIE_ER_MASK_RCV_ERR_MASK				BIT_30			
/*		Bit(s) PCIE_ER_MASK_RSRV_29_28 reserved */
/* Enable Uncorrectable Error (UR Error) */
#define	PCIE_ER_MASK_UR_ENA						BIT_27			
/* Enable Uncorrectable Error (ECRC Error) */
#define	PCIE_ER_MASK_ECRCERR_ENA				BIT_26			
/* Enable Uncorrectable Error (Malformed TLP) */
#define	PCIE_ER_MASK_MTLP_ENA					BIT_25			
/* Enable Uncorrectable Error (RX Overflow) */
#define	PCIE_ER_MASK_RCVOVFL_ENA				BIT_24			
/* Enable Uncorrectable Error (Unexpected Completion) */
#define	PCIE_ER_MASK_UNEXPCPL_ENA				BIT_23			
/* Enable Uncorrectable Error (Completer Abort) */
#define	PCIE_ER_MASK_CPLABRT_ENA				BIT_22			
/* Enable Uncorrectable Error (Completion Timeout) */
#define	PCIE_ER_MASK_CPLTO_ENA					BIT_21			
/* Enable Uncorrectable Error (Flow Control Protocol Error) */
#define	PCIE_ER_MASK_FCPROTERR_ENA				BIT_20			
/* Enable Uncorrectable Error (Poisoned TLP) */
#define	PCIE_ER_MASK_PTLP_ENA					BIT_19			
/* Enable Uncorrectable Error (Data Link Protocol Error) */
#define	PCIE_ER_MASK_DLPRTERR_ENA				BIT_18			
/* Enable Uncorrectable Error (Training Error) */
#define	PCIE_ER_MASK_TRAINERR_ENA				BIT_17			
/*		Bit(s) PCIE_ER_MASK_RSRV_16 reserved */
/* Enable Uncorrectable Error (UR Error) Send Error Message */
#define	PCIE_ER_MASK_UR_SEND_ENA				BIT_15			
/* Enable Uncorrectable Error (ECRC Error) Send Error Message */
#define	PCIE_ER_MASK_ECRCERR_SEND_ENA			BIT_14			
/* Enable Uncorrectable Error (Malformed TLP) Send Error Message */
#define	PCIE_ER_MASK_MTLP_SEND_ENA				BIT_13			
/* Enable Uncorrectable Error (RX Overflow) Send Error Message */
#define	PCIE_ER_MASK_RCVOVFL_SEND_ENA			BIT_12			
/* Enable Uncorrectable Error (Unexpected Completion) Send Error Message */
#define	PCIE_ER_MASK_CPLUC_SEND_ENA				BIT_11			
/* Enable Uncorrectable Error (Completer Abort) Send Error Message */
#define	PCIE_ER_MASK_CPLABRT_SEND_ENA			BIT_10			
/* Enable Uncorrectable Error (Completion Timeout) Send Error Message */
#define	PCIE_ER_MASK_CPLTO_SEND_ENA				BIT_9			
/* Enable Uncorrectable Error (Flow Control Protocol Error) Send Error Message */
#define	PCIE_ER_MASK_FCPROTERR_SEND_ENA			BIT_8			
/* Enable Uncorrectable Error (Poisoned TLP) Send Error Message */
#define	PCIE_ER_MASK_PTLP_SEND_ENA				BIT_7			
/* Enable Uncorrectable Error (Data Link Protocol Error) Send Error Message */
#define	PCIE_ER_MASK_DLPRTERR_SEND_ENA			BIT_6			
/* Enable Uncorrectable Error (Training Error) Send Error Message */
#define	PCIE_ER_MASK_TRAINERR_SEND_ENA			BIT_5			
/* Enable Correctable Error (Replay Timer Timeout) Send Error Message */
#define	PCIE_ER_MASK_RPLYTO_SEND_ENA			BIT_4			
/* Enable Correctable Error (REPLAY_NUM RollOver) Send Error Message */
#define	PCIE_ER_MASK_RPLYNUMRO_SEND_ENA			BIT_3			
/* Enable Correctable Error (Bad DLLP) Send Error Message */
#define	PCIE_ER_MASK_BADDLLP_SEND_ENA			BIT_2			
/* Enable Correctable Error (Bad TLP) Send Error Message */
#define	PCIE_ER_MASK_BADTLP_SEND_ENA			BIT_1			
/* Enable Correctable Error (RX Error) Send Error Message */
#define	PCIE_ER_MASK_RXERR_SEND_ENA				BIT_0			

/*	CONFIG_REG0						0x0090	Config Register 0 */
#define	CONFIG_REG0_RTC_MSK							SHIFT24(0xff)	/* RTC */
#define	CONFIG_REG0_RTC_BASE						24
#define	CONFIG_REG0_WTC_MSK							SHIFT16(0xff)	/* WTC */
#define	CONFIG_REG0_WTC_BASE						16
/* Disable PCIe reset extend after Lom_disable */
#define	CONFIG_REG0_PCIRST_LOM						BIT_15			
/*		Bit(s) CONFIG_REG0_RSRV_14_13 reserved */
#define	CONFIG_REG0_OSC_PU							BIT_12			/* OSC Power Up */
/* OSC Speed Control */
#define	CONFIG_REG0_OSC_SPEED_CTRL_MSK				SHIFT9(0x7)		
#define	CONFIG_REG0_OSC_SPEED_CTRL_BASE				BIT_9
#define	CONFIG_REG0_OSC_OUT							BIT_8			/* OSC output */
/*		Bit(s) CONFIG_REG0_RSRV_7_5 reserved */
/* Disable GPHY reset on Lom_disable mode */
#define	CONFIG_REG0_GPHY_RST_LOMDISABLE				BIT_4			
/* Disable GPHY DPLL reset on Lom_disable mode */
#define	CONFIG_REG0_GPHY_RST_DPLL_LOMDISABLE		BIT_3			
/* Disable GPHY DPLL Power Down on Lom_disable mode */
#define	CONFIG_REG0_GPHY_PD_DPLL_LOMDISABLE			BIT_2			
/* Enable GPHY PD on Lom_disable mode */
#define	CONFIG_REG0_GPHY_PD_LOMDISABLE				BIT_1			
/* <mu>C lock VPD */
#define	CONFIG_REG0_CPU_LOCK_VPD					BIT_0			

/*	CONFIG_REG1						0x0094	Config Register 1 */
/*		Bit(s) CONFIG_REG1_RSRV_31_25 reserved */
/* Disable Release event in CFG0x84 during PCIE reset asserted */
#define	CONFIG_REG1_DIS_CFG84_EVENT					BIT_24			
/* EPROM Loader Not Finished */
#define	CONFIG_REG1_EPROM_LDR_NOT_FIN_RELEASE		BIT_23			
/* Vmain_avlbl release gated clock */
#define	CONFIG_REG1_VMAIN_AVLB_RELEASE				BIT_22			
/* PCIE reset release gated clock */
#define	CONFIG_REG1_PCIE_RST_RELEASE				BIT_21			
/* EPROM Loader Finished */
#define	CONFIG_REG1_EPROM_LDR_FIN					BIT_20			
#define	CONFIG_REG1_PCIE_RX_ELEC_IDLE				BIT_19			/* Vmain_avlbl */
#define	CONFIG_REG1_PCIE_RST						BIT_18			/* PCIE reset */
/* Enable PCIE reset and pm2phy_off generate CLKREQ for auto-gated clock */
#define	CONFIG_REG1_EN_PERST_PMOFF_CLKREQ			BIT_17			
/* Enable PCIE reset generate CLKREQ for auto-gated clock */
#define	CONFIG_REG1_EN_PERST_CLKREQ					BIT_16			
/*		Bit(s) CONFIG_REG1_RSRV_15_9 reserved */
/* Enable core level Config loader done for gated clock */
#define	CONFIG_REG1_EN_CFG_LOAD_DONE				BIT_8			
/* Enable PCIe Header Log Fix1 */
#define	CONFIG_REG1_ENA_PCIE_HDRLOG_FIX1			BIT_7			
/* Enable PCIe CRS Fix */
#define	CONFIG_REG1_EN_PCIE_CRS_FIX					BIT_6			
/* Disable PCIe Header Log Fix0 */
#define	CONFIG_REG1_DIS_PCIE_HDRLOG_FIX0			BIT_5			
/* Disable pexunit Synchronization Fix */
#define	CONFIG_REG1_DIS_PEX_SYNC_FIX				BIT_4			
/* Enable CPU reset gated by YTB cmd */
#define	CONFIG_REG1_EN_CPU_RST_YTB_CMD				BIT_3			
/* Disable PCIe 2.0 linkup fix */
#define	CONFIG_REG1_DIS_PCIE20_LINKUP_FIX			BIT_2			
/* Enable TX BMU Read IDLE for ASPM */
#define	CONFIG_REG1_EN_ASPM_TX_BMU_RD				BIT_1			
/* Enable TX BMU Write IDLE for ASPM */
#define	CONFIG_REG1_EN_ASPM_TX_BMU_WR				BIT_0			

/*	PSM_CONFIG_REG0					0x0098	PSM Config Register 0 */
/* PSM Timer Configuration */
#define	PSM_CONFIG_REG0_PSM_TIM_CONF_MSK		SHIFT0(0xffffffff)	
#define	PSM_CONFIG_REG0_PSM_TIM_CONF_BASE		0

/*	PSM_CONFIG_REG1					0x009C	PSM Config Register 1 */
/* GPHY Energy Detect Status */
#define	PSM_CONFIG_REG1_GPHY_ENERGY_STS		BIT_31			
/*		Bit(s) PSM_CONFIG_REG1_RSRV_30_19 reserved */
/* PCIE L1 Event Polarity for PSM */
#define	PSM_CONFIG_REG1_PSM_PCIE_L1_POL		BIT_18			
#define	PSM_CONFIG_REG1_TIMER_STAT			BIT_17			/* PSM Timer Status */
#define	PSM_CONFIG_REG1_GPHY_INT			BIT_16			/* GPHY INT */
/*		Bit(s) PSM_CONFIG_REG1_RSRV_15_10 reserved */
/* Disable Loader SM after PSM go back to IDLE */
#define	PSM_CONFIG_REG1_DIS_LOADER			BIT_9			
#define	PSM_CONFIG_REG1_DO_PWDN				BIT_8			/* Do Power Down */
/* Disable Plug-in-Go SM after PSM go back to IDLE */
#define	PSM_CONFIG_REG1_DIS_PIG				BIT_7			
/* Disable Internal PCIE reset after PSM going back to IDLE */
#define	PSM_CONFIG_REG1_DIS_PERST			BIT_6			
/* Enable REG18 Power Down for PSM */
#define	PSM_CONFIG_REG1_EN_REG18_PD			BIT_5			
/* Disable EEPROM Loader after PSM go back to IDLE */
#define	PSM_CONFIG_REG1_EN_PSM_LOAD			BIT_4			
/* Enable PCIE Hot reset for PSM */
#define	PSM_CONFIG_REG1_EN_PSM_HOT_RST		BIT_3			
/* Enable PCIE Rst event for PSM */
#define	PSM_CONFIG_REG1_EN_PSM_PERST		BIT_2			
/* Enable PCIE L1 Event for PSM */
#define	PSM_CONFIG_REG1_EN_PSM_PCIE_L1		BIT_1			
#define	PSM_CONFIG_REG1_EN_PSM				BIT_0			/* Enable PSM scheme */

/*	VPD_CTRL_ADD					0x00A0	VPD Start End Address */
#define	VPD_CTRL_ADD_VPD_END_MSK			SHIFT24(0xff)	/* VPD_END */
#define	VPD_CTRL_ADD_VPD_END_BASE			24
#define	VPD_CTRL_ADD_VPD_W_START_MSK		SHIFT16(0xff)	/* VPD_W_START */
#define	VPD_CTRL_ADD_VPD_W_START_BASE		16
#define	VPD_CTRL_ADD_VPD_START_MSK			SHIFT8(0xff)	/* VPD_START */
#define	VPD_CTRL_ADD_VPD_START_BASE			8
#define	VPD_CTRL_ADD_OTP_BYTE_EN_MSK		SHIFT4(0xf)		/* OTP_BYTE_EN */
#define	VPD_CTRL_ADD_OTP_BYTE_EN_BASE		4
/*		Bit(s) VPD_CTRL_ADD_RSRV_3 reserved */
#define	VPD_CTRL_ADD_EEPROM_EN				BIT_2			/* EEPROM_EN */
#define	VPD_CTRL_ADD_OTP_EN					BIT_1			/* OTP_EN */
#define	VPD_CTRL_ADD_VPD_SEL				BIT_0			/* VPD_SEL */

/*	OTP_LDR_CTRL					0x00A4	OTP Loader Control Register */
#define	OTP_LDR_CTRL_OTP_FLAG						BIT_31			/* Flag */
#define	OTP_LDR_CTRL_OTP_ADDR_MSK					SHIFT16(0x7fff)	/* OTP Address */
#define	OTP_LDR_CTRL_OTP_ADDR_BASE					16
/* EEPROM timeout flag */
#define	OTP_LDR_CTRL_EEPROM_TIMEOUT_FLAG			BIT_15			
/* EEPROM timeout disable */
#define	OTP_LDR_CTRL_EEPROM_TIMEOUT_DIS				BIT_14			
/*		Bit(s) OTP_LDR_CTRL_RSRV_13_12 reserved */
/* EEPROM timeout value */
#define	OTP_LDR_CTRL_EEPROM_TIMEOUT_VAL_MSK			SHIFT9(0x7)		
#define	OTP_LDR_CTRL_EEPROM_TIMEOUT_VAL_BASE		9
/*		Bit(s) OTP_LDR_CTRL_RSRV_8 reserved */
/* OTP start Address */
#define	OTP_LDR_CTRL_OTP_ST_ADD_MSK					SHIFT0(0xff)	
#define	OTP_LDR_CTRL_OTP_ST_ADD_BASE				0

/*	OTP_MEM_CTRL_0					0x00A8	OTP Memory Control Register 0 */
#define	OTP_MEM_CTRL_0_CE2RD_SU_TIME_MSK		SHIFT24(0xff)	/* CERD setup time */
#define	OTP_MEM_CTRL_0_CE2RD_SU_TIME_BASE		24
/* Write data hold time */
#define	OTP_MEM_CTRL_0_WRDAT_HLD_TIME_MSK		SHIFT20(0xf)	
#define	OTP_MEM_CTRL_0_WRDAT_HLD_TIME_BASE		20
#define	OTP_MEM_CTRL_0_WRDAT_VLD_TIME_MSK		SHIFT16(0xf)	/* Write valid time */
#define	OTP_MEM_CTRL_0_WRDAT_VLD_TIME_BASE		16
/* Write data setup time */
#define	OTP_MEM_CTRL_0_WRDAT_SU_TIME_MSK		SHIFT12(0xf)	
#define	OTP_MEM_CTRL_0_WRDAT_SU_TIME_BASE		12
/* Read data setup time */
#define	OTP_MEM_CTRL_0_RDDAT_SU_TIME_MSK		SHIFT4(0xff)	
#define	OTP_MEM_CTRL_0_RDDAT_SU_TIME_BASE		4
#define	OTP_MEM_CTRL_0_RST_PULSE_WIDTH_MSK		SHIFT0(0xf)		/* RSTB pulse width */
#define	OTP_MEM_CTRL_0_RST_PULSE_WIDTH_BASE		0

/*	OTP_MEM_CTRL_1					0x00AC	OTP Memory Control Register 1 */
/* CPUMPEN hold time */
#define	OTP_MEM_CTRL_1_CPUMEM_HLD_TIME_MSK		SHIFT28(0xf)	
#define	OTP_MEM_CTRL_1_CPUMEM_HLD_TIME_BASE		28
/* CPUMPEN setup time */
#define	OTP_MEM_CTRL_1_CPUMEM_SU_TIME_MSK		SHIFT24(0xf)	
#define	OTP_MEM_CTRL_1_CPUMEM_SU_TIME_BASE		24
#define	OTP_MEM_CTRL_1_PGMEN_HLD_TIME_MSK		SHIFT16(0xff)	/* PGMEN hold time */
#define	OTP_MEM_CTRL_1_PGMEN_HLD_TIME_BASE		16
#define	OTP_MEM_CTRL_1_PGMEN_VLD_TIME_MSK		SHIFT4(0xfff)	/* Program time */
#define	OTP_MEM_CTRL_1_PGMEN_VLD_TIME_BASE		4
#define	OTP_MEM_CTRL_1_PGMEN_SU_TIME_MSK		SHIFT0(0xf)		/* PGMEN setup time */
#define	OTP_MEM_CTRL_1_PGMEN_SU_TIME_BASE		0

/*	OTP_MEM_CTRL_2					0x00B0	OTP Memory Control Register 2 */
/* OTP ctrl module status */
#define	OTP_MEM_CTRL_2_OTP_DBG_BITS_MSK			SHIFT16(0xffff)	
#define	OTP_MEM_CTRL_2_OTP_DBG_BITS_BASE		16
#define	OTP_MEM_CTRL_2_OTP_TST_MODE_MSK			SHIFT8(0xff)	/* OTP test mode */
#define	OTP_MEM_CTRL_2_OTP_TST_MODE_BASE		8
/*		Bit(s) OTP_MEM_CTRL_2_RSRV_7 reserved */
/* Auto read back after programming */
#define	OTP_MEM_CTRL_2_AUTO_RD_AFTER_WR			BIT_6			
/* OTP test mode enable */
#define	OTP_MEM_CTRL_2_TSTMODE_ENA				BIT_5			
#define	OTP_MEM_CTRL_2_OTP_RST_WHEN_WR			BIT_4			/* OTP reset mode */
/* OTP CEB always low */
#define	OTP_MEM_CTRL_2_CEB_KEEP_LOW				BIT_3			
#define	OTP_MEM_CTRL_2_BYPASS2RSTB				BIT_2			/* OTP RSTB */
#define	OTP_MEM_CTRL_2_BYPASS2RSTB_ENA			BIT_1			/* OTP RSTB enable */
/* OTP interface module reset */
#define	OTP_MEM_CTRL_2_OTP_IF_FREEZE			BIT_0			

/*	OTP_MEM_ST_0					0x00B4	OTP Memory Status Register 0 */
/* OTP memory LOCK pin */
#define	OTP_MEM_ST_0_OTP_LOCK_PIN			BIT_31				
/*		Bit(s) OTP_MEM_ST_0_RSRV_30_24 reserved */
/* OTP memory DOUT pin */
#define	OTP_MEM_ST_0_OTP_DOUT_PIN			BIT_23				
/*		Bit(s) OTP_MEM_ST_0_RSRV_22_0 reserved */

/*	VPD_CTRL						0x00B8	EEPROM and OTP Control Register */
/* mdio to ytb bus IF disable */
#define	VPD_CTRL_MDIO2YTB_DIS			BIT_31			
/* mdio to ytb bus IF software reset */
#define	VPD_CTRL_MDIO2YTB_SWRST			BIT_30			
#define	VPD_CTRL_OTP_TOP_RST			BIT_29			/* otp_top software reset */
/*		Bit(s) VPD_CTRL_RSRV_28_18 reserved */
#define	VPD_CTRL_OTP_IF_TMOUT_MSK		SHIFT16(0x3)	/* otp timeout reg */
#define	VPD_CTRL_OTP_IF_TMOUT_BASE		16
/* EEPROM loader timeout disable */
#define	VPD_CTRL_TMOUT_DIS				BIT_15			
/*		Bit(s) VPD_CTRL_RSRV_14 reserved */
/* EEPROM loader timeout val */
#define	VPD_CTRL_TMOUT_VALUE_MSK		SHIFT12(0x3)	
#define	VPD_CTRL_TMOUT_VALUE_BASE		12
/*		Bit(s) VPD_CTRL_RSRV_11_10 reserved */
#define	VPD_CTRL_SPEED_SELECT_MSK		SHIFT0(0x3ff)	/* EEPROM speed select */
#define	VPD_CTRL_SPEED_SELECT_BASE		0

/*	OTP_MEM_CTRL_3					0x00BC	LDO Control Register */
//#define	_MSK									SHIFT14(0x3ffff)	/* RSVD */
//#define	_BASE									14
/* CLK generator filter bypass */
#define	OTP_MEM_CTRL_3_CLK_GEN_BYPASS			BIT_13				
/* CLK generator soft reset */
#define	OTP_MEM_CTRL_3_CLK_GEN_RST				BIT_12				
/* CLK generator filter control */
#define	OTP_MEM_CTRL_3_CLK_GEN_CTRL_MSK			SHIFT8(0xf)			
#define	OTP_MEM_CTRL_3_CLK_GEN_CTRL_BASE		8
/* LDO 2.5 V testmode sel */
#define	OTP_MEM_CTRL_3_LDO25TSTMODE_MSK			SHIFT4(0x7)			
#define	OTP_MEM_CTRL_3_LDO25TSTMODE_BASE		4
/* LDO 1.2 V testmode sel */
#define	OTP_MEM_CTRL_3_LDO12TSTMODE_MSK			SHIFT0(0x7)			
#define	OTP_MEM_CTRL_3_LDO12TSTMODE_BASE		0

/*	PCIE_CAP_ID						0x00C0	PE Capability ID Register (PM Cap
 *											ID)
 */
#define	PCIE_CAP_ID_MSK			SHIFT0(0xffU)	/* Cap ID */
#define	PCIE_CAP_ID_BASE		0

/*	PCIE_NPTR						0x00C1	PE Next Item Pointer Register */
#define	PCIE_NPTR_MSK		SHIFT0(0xffU)	/* Next Item Ptr */
#define	PCIE_NPTR_BASE		0

/*	PCIE_CAP						0x00C2	PE Capabilities Register */
/*		Bit(s) PCIE_CAP_RSRV_15_14 reserved */
#define	PCIE_CAP_INTMSG_NUM_MSK			SHIFT9(0x1fU)	/* Interrupt Message Number */
#define	PCIE_CAP_INTMSG_NUM_BASE		9
/*		Bit(s) PCIE_CAP_RSRV_8 reserved */
#define	PCIE_CAP_PORT_TYP_MSK			SHIFT4(0xfU)	/* Device/Port Type */
#define	PCIE_CAP_PORT_TYP_BASE			4
#define	PCIE_CAP_CAP_VER_MSK			SHIFT0(0xfU)	/* Capability Version */
#define	PCIE_CAP_CAP_VER_BASE			0

/*	DEVICE_CAPABILITIES_REGISTER	0x00C4	Device Capabilities Register */
/*		Bit(s) DEVICE_CAPABILITIES_REGISTER_RSRV_31_28 reserved */
/* Captured Slot Power Limit Scale */
#define	DEVICE_CAPABILITIES_REGISTER_SPL_SCALE_MSK			SHIFT26(0x3)	
#define	DEVICE_CAPABILITIES_REGISTER_SPL_SCALE_BASE			26
/* Captured Slot Power Limit Value */
#define	DEVICE_CAPABILITIES_REGISTER_SPL_VAL_MSK			SHIFT18(0xff)	
#define	DEVICE_CAPABILITIES_REGISTER_SPL_VAL_BASE			18
/*		Bit(s) DEVICE_CAPABILITIES_REGISTER_RSRV_17_16 reserved */
/* Role-Based Error Reporting */
#define	DEVICE_CAPABILITIES_REGISTER_ROLE_BASED_ERR_RPT		BIT_15			
/* Power Indicator Present */
#define	DEVICE_CAPABILITIES_REGISTER_PI_PRS					BIT_14			
/* Attention Indicator Present */
#define	DEVICE_CAPABILITIES_REGISTER_AI_PRS					BIT_13			
/* Attention Button Present */
#define	DEVICE_CAPABILITIES_REGISTER_AB_PRS					BIT_12			
/* Endpoint L1 Acceptable Latency */
#define	DEVICE_CAPABILITIES_REGISTER_L1_AC_LAT_MSK			SHIFT9(0x7)		
#define	DEVICE_CAPABILITIES_REGISTER_L1_AC_LAT_BASE			9
/* Endpoint L0s Acceptable Latency */
#define	DEVICE_CAPABILITIES_REGISTER_L0_AC_LAT_MSK			SHIFT6(0x7)		
#define	DEVICE_CAPABILITIES_REGISTER_L0_AC_LAT_BASE			6
/* Extended Tag Field Supported */
#define	DEVICE_CAPABILITIES_REGISTER_EXTTAG_SUP				BIT_5			
/* Phantom Functions Supported */
#define	DEVICE_CAPABILITIES_REGISTER_PHANTOM_SUP_MSK		SHIFT3(0x3)		
#define	DEVICE_CAPABILITIES_REGISTER_PHANTOM_SUP_BASE		3
/* Max_Payload_Size Supported */
#define	DEVICE_CAPABILITIES_REGISTER_MAX_PLS_SUP_MSK		SHIFT0(0x7)		
#define	DEVICE_CAPABILITIES_REGISTER_MAX_PLS_SUP_BASE		0

/*	PCIE_DEVCTRL					0x00C8	Device Control Register */
/*		Bit(s) PCIE_DEVCTRL_RSRV_15 reserved */
#define	PCIE_DEVCTRL_MAX_RRS_MSK		SHIFT12(0x7U)	/* Max_Read_Request_Size */
#define	PCIE_DEVCTRL_MAX_RRS_BASE		12
#define	PCIE_DEVCTRL_NOSNP_ENA			BIT_11S			/* Enable No Snoop */
/* Auxiliary (AUX) Power PM Enable */
#define	PCIE_DEVCTRL_AUXPWR_ENA			BIT_10S			
#define	PCIE_DEVCTRL_PHANTOM__ENA		BIT_9S			/* Phantom Functions Enable */
/* Extended Tag Field Enable */
#define	PCIE_DEVCTRL_EXTTAG_ENA			BIT_8S			
#define	PCIE_DEVCTRL_MAX_PLS_MSK		SHIFT5(0x7U)	/* Max_Payload_Size */
#define	PCIE_DEVCTRL_MAX_PLS_BASE		5
#define	PCIE_DEVCTRL_REL_ORD_ENA		BIT_4S			/* Enable Relaxed Ordering */
/* Unsupported Request Reporting Enable */
#define	PCIE_DEVCTRL_URR_ENA			BIT_3S			
/* Fatal Error Reporting Enable */
#define	PCIE_DEVCTRL_FERR_ENA			BIT_2S			
/* Non-Fatal Error Reporting Enable */
#define	PCIE_DEVCTRL_NFERR_ENA			BIT_1S			
/* Correctable Error Reporting Enable */
#define	PCIE_DEVCTRL_CERR_ENA			BIT_0S			

/*	PCIE_DEVSTAT					0x00CA	Device Status Register */
/*		Bit(s) PCIE_DEVSTAT_RSRV_15_6 reserved */
#define	PCIE_DEVSTAT_TRANS_PEND			BIT_5S			/* Transactions Pending */
#define	PCIE_DEVSTAT_AUXPWR_DET			BIT_4S			/* AUX Power Detected */
/* Unsupported Request Detected */
#define	PCIE_DEVSTAT_UR_DET				BIT_3S			
#define	PCIE_DEVSTAT_FERR_DET			BIT_2S			/* Fatal Error Detected */
#define	PCIE_DEVSTAT_NFERR_DET			BIT_1S			/* Non-Fatal Error Detected */
/* Correctable Error Detected */
#define	PCIE_DEVSTAT_CERR_DET			BIT_0S			

/*	PCIE_LNKCAP						0x00CC	Link Capabilities Register */
#define	PCIE_LNKCAP_PORT_NUM_MSK			SHIFT24(0xff)	/* Port Number */
#define	PCIE_LNKCAP_PORT_NUM_BASE			24
/*		Bit(s) PCIE_LNKCAP_RSRV_23_21 reserved */
/*		Bit(s) PCIE_LNKCAP_RSRV_20_19 reserved */
/* Clock Power Management */
#define	PCIE_LNKCAP_CLK_PM					BIT_18			
#define	PCIE_LNKCAP_L1_EXITLAT_MSK			SHIFT15(0x7)	/* L1 Exit Latency */
#define	PCIE_LNKCAP_L1_EXITLAT_BASE			15
#define	PCIE_LNKCAP_LOS_EXITLAT_MSK			SHIFT12(0x7)	/* L0s Exit Latency */
#define	PCIE_LNKCAP_LOS_EXITLAT_BASE		12
/* Active State Link PM Support */
#define	PCIE_LNKCAP_ASPM_SUP_MSK			SHIFT10(0x3)	
#define	PCIE_LNKCAP_ASPM_SUP_BASE			10
#define	PCIE_LNKCAP_MAX_LNKWID_MSK			SHIFT4(0x3f)	/* Maximum Link Width */
#define	PCIE_LNKCAP_MAX_LNKWID_BASE			4
#define	PCIE_LNKCAP_MAX_LNKSPD_MSK			SHIFT0(0xf)		/* Maximum Link Speed */
#define	PCIE_LNKCAP_MAX_LNKSPD_BASE			0

/*	PCIE_LNKCTRL					0x00D0	Link Control Register */
/*		Bit(s) PCIE_LNKCTRL_RSRV_15_9 reserved */
/* Enable Clock Power Management */
#define	PCIE_LNKCTRL_CLK_PM_ENA			BIT_8S			
#define	PCIE_LNKCTRL_EXTSYNC			BIT_7S			/* Extended Sync */
/*		Bit(s) PCIE_LNKCTRL_RSRV_ reserved */
/*		Bit(s) PCIE_LNKCTRL_RSRV_5_4 reserved */
/* Read Completion Boundary (RCB) */
#define	PCIE_LNKCTRL_RCB_128B			BIT_3S			
/*		Bit(s) PCIE_LNKCTRL_RSRV_2 reserved */
/* Active State Link PM Control */
#define	PCIE_LNKCTRL_ASPM_CTRL_MSK		SHIFT0(0x3U)	
#define	PCIE_LNKCTRL_ASPM_CTRL_BASE		0

/*	PCIE_LNKSTAT					0x00D2	Link Status Register */
/*		Bit(s) PCIE_LNKSTAT_RSRV_15_14 reserved */
/*		Bit(s) PCIE_LNKSTAT_RSRV_13 reserved */
#define	PCIE_LNKSTAT_SCLKCFG			BIT_12S			/* Slot Clock Configuration */
#define	PCIE_LNKSTAT_LNKTRAIN			BIT_11S			/* Link Training */
#define	PCIE_LNKSTAT_UNDEF				BIT_10S			/* Undefined */
#define	PCIE_LNKSTAT_NEGLNKWID_MSK		SHIFT4(0x3fU)	/* Negotiated Link Width */
#define	PCIE_LNKSTAT_NEGLNKWID_MSK			SHIFT4(0x3fU)	
#define	PCIE_LNKSTAT_NEGLNKWID_BASE			4
#define	PCIE_LNKSTAT_LNKSPD_MSK				SHIFT0(0xfU)	/* Link Speed */
#define	PCIE_LNKSTAT_LNKSPD_BASE			0

/*	PCIE_DEV_CAP_2					0x00E4	Device Capabilities 2 Register */
/*		Bit(s) PCIE_DEV_CAP_2_RSRV_31_5 reserved */
/* Completion Timeout Disable Supported */
#define	PCIE_DEV_CAP_2_CPL_TO_DIS_SUPP				BIT_4				
/* Completion Timeout Ranges Supported */
#define	PCIE_DEV_CAP_2_CPL_TO_RANGE_SUPP_MSK		SHIFT0(0xf)			
#define	PCIE_DEV_CAP_2_CPL_TO_RANGE_SUPP_BASE		0

/*	PCIE_DEV_CTRL_2					0x00E8	Device Control 2 Register */
/*		Bit(s) PCIE_DEV_CTRL_2_RSRV_31_5 reserved */
/* Completion Timeout Disable */
#define	PCIE_DEV_CTRL_2_CPL_TO_DIS			BIT_4				
/* Completion Timeout Value */
#define	PCIE_DEV_CTRL_2_CPL_TO_VAL_MSK		SHIFT0(0xf)			
#define	PCIE_DEV_CTRL_2_CPL_TO_VAL_BASE		0

/*	PCIE_AE_CAP_HDR					0x0100	Advanced Error Reporting Enhanced
 *											Capability Header Register
 */
#define	PCIE_AE_CAP_HDR_NPTR_MSK		SHIFT20(0xfff)	/* Next Capability Offset */
#define	PCIE_AE_CAP_HDR_NPTR_BASE		20
#define	PCIE_AE_CAP_HDR_VER_ID_MSK		SHIFT16(0xf)	/* Capability Version */
#define	PCIE_AE_CAP_HDR_VER_ID_BASE		16
/* PCI Express Extended Capability ID */
#define	PCIE_AE_CAP_HDR_CAP_ID_MSK		SHIFT0(0xffff)	
#define	PCIE_AE_CAP_HDR_CAP_ID_BASE		0

/*	PCIE_UE_STAT					0x0104	Uncorrectable Error Status Register */
/*		Bit(s) PCIE_UE_STAT_RSRV_31_21 reserved */
/* Unsupported Request Error */
#define	PCIE_UE_STAT_UR					BIT_20			
#define	PCIE_UE_STAT_ECRCERR			BIT_19			/* ECRC Error */
#define	PCIE_UE_STAT_MTLP				BIT_18			/* Malformed TLP */
#define	PCIE_UE_STAT_RCVOVFL			BIT_17			/* Receiver Overflow */
#define	PCIE_UE_STAT_UNEXPCPL			BIT_16			/* Unexpected Completion */
#define	PCIE_UE_STAT_CPLABORT			BIT_15			/* Completer Abort */
#define	PCIE_UE_STAT_CPLTO				BIT_14			/* Completion Timeout */
/* Flow Control Protocol Error */
#define	PCIE_UE_STAT_FCPROTERR			BIT_13			
#define	PCIE_UE_STAT_PTLP				BIT_12			/* Poisoned TLP */
/*		Bit(s) PCIE_UE_STAT_RSRV_11_5 reserved */
#define	PCIE_UE_STAT_DLPROTERR			BIT_4			/* Data Link Protocol Error */
/*		Bit(s) PCIE_UE_STAT_RSRV_3_1 reserved */
#define	PCIE_UE_STAT_UNDEF				BIT_0			/* Undefined */

/*	PCIE_UE_MASK					0x0108	Uncorrectable Error Mask Register */
/*		Bit(s) PCIE_UE_MASK_RSRV_31_21 reserved */
/* Unsupported Request Error */
#define	PCIE_UE_MASK_UR					BIT_20			
#define	PCIE_UE_MASK_ECRCERR			BIT_19			/* ECRC Error */
#define	PCIE_UE_MASK_MTLP				BIT_18			/* Malformed TLP */
#define	PCIE_UE_MASK_RCVOVFL			BIT_17			/* Receiver Overflow */
#define	PCIE_UE_MASK_UNEXPCPL			BIT_16			/* Unexpected Completion */
#define	PCIE_UE_MASK_CPLABRT			BIT_15			/* Completer Abort */
#define	PCIE_UE_MASK_CPLTO				BIT_14			/* Completion Timeout */
/* Flow Control Protocol Error */
#define	PCIE_UE_MASK_FCPROTERR			BIT_13			
#define	PCIE_UE_MASK_PTLP				BIT_12			/* Poisoned TLP */
/*		Bit(s) PCIE_UE_MASK_RSRV_11_5 reserved */
#define	PCIE_UE_MASK_DLPROTERR			BIT_4			/* Data Link Protocol Error */
/*		Bit(s) PCIE_UE_MASK_RSRV_3_1 reserved */
#define	PCIE_UE_MASK_UNDEF				BIT_0			/* Undefined */

/*	PCIE_UE_SVRT					0x010C	Uncorrectable Error Severity
 *											Register
 */
/*		Bit(s) PCIE_UE_SVRT_RSRV_31_21 reserved */
/* Unsupported Request Error */
#define	PCIE_UE_SVRT_UR					BIT_20			
#define	PCIE_UE_SVRT_ECRCERR			BIT_19			/* ECRC Error Severity */
#define	PCIE_UE_SVRT_MTLP				BIT_18			/* Malformed TLP */
#define	PCIE_UE_SVRT_RCVOVFL			BIT_17			/* Receiver Overflow */
#define	PCIE_UE_SVRT_UNEXPCPL			BIT_16			/* Unexpected Completion */
#define	PCIE_UE_SVRT_CPLABRT			BIT_15			/* Completer Abort */
#define	PCIE_UE_SVRT_CPLTO				BIT_14			/* Completion Timeout */
/* Flow Control Protocol Error */
#define	PCIE_UE_SVRT_FCPROTERR			BIT_13			
#define	PCIE_UE_SVRT_PTLP				BIT_12			/* Poisoned TLP */
/*		Bit(s) PCIE_UE_SVRT_RSRV_11_5 reserved */
#define	PCIE_UE_SVRT_DLPROTERR			BIT_4			/* Data Link Protocol Error */
/*		Bit(s) PCIE_UE_SVRT_RSRV_3_1 reserved */
#define	PCIE_UE_SVRT_UNDEF				BIT_0			/* Undefined */

/*	PCIE_CA_STAT					0x0110	Correctable Error Status Register */
/*		Bit(s) PCIE_CA_STAT_RSRV_31_14 reserved */
/* Advisory Non-Fatal Error Status */
#define	PCIE_CA_STAT_ADV_NONFAT_ERRSTAT		BIT_13				
/* Replay Timer Timeout */
#define	PCIE_CA_STAT_RPLYTO					BIT_12				
/*		Bit(s) PCIE_CA_STAT_RSRV_11_9 reserved */
/* REPLAY_NUM Rollover */
#define	PCIE_CA_STAT_RPLYNUMRO				BIT_8				
#define	PCIE_CA_STAT_BADDLLP				BIT_7				/* Bad DLLP */
#define	PCIE_CA_STAT_BADTLP					BIT_6				/* Bad TLP */
/*		Bit(s) PCIE_CA_STAT_RSRV_5_1 reserved */
#define	PCIE_CA_STAT_RCVERR					BIT_0				/* Receiver Error */

/*	PCIE_CA_MASK					0x0114	Correctable Error Mask Register */
/*		Bit(s) PCIE_CA_MASK_RSRV_31_14 reserved */
/* Advisory Non-Fatal Error Mask */
#define	PCIE_CA_MASK_ADV_NONFAT_ERRSTAT		BIT_13				
/* Replay Timer Timeout */
#define	PCIE_CA_MASK_RPLYTO					BIT_12				
/*		Bit(s) PCIE_CA_MASK_RSRV_11_9 reserved */
/* REPLAY_NUM Rollover */
#define	PCIE_CA_MASK_RPLYNUMRO				BIT_8				
#define	PCIE_CA_MASK_BADDLLP				BIT_7				/* Bad DLLP */
#define	PCIE_CA_MASK_BADTLP					BIT_6				/* Bad TLP */
/*		Bit(s) PCIE_CA_MASK_RSRV_5_1 reserved */
#define	PCIE_CA_MASK_RCVERR					BIT_0				/* Receiver Error */

/*	PCIE_AE_CAPCTRL					0x0118	Advanced Error Capabilities and
 *											Control Register
 */
/*		Bit(s) PCIE_AE_CAPCTRL_RSRV_31_9 reserved */
/* ECRC Check Enable */
#define	PCIE_AE_CAPCTRL_ECRCCHK_ENA			BIT_8				
/* ECRC Check Capable */
#define	PCIE_AE_CAPCTRL_ECRCCHK_CAP			BIT_7				
/* ECRC Generation Enable */
#define	PCIE_AE_CAPCTRL_ECRCGEN_ENA			BIT_6				
/* ECRC Generation Capable */
#define	PCIE_AE_CAPCTRL_ECRCGEN_CAP			BIT_5				
/* First Error Pointer */
#define	PCIE_AE_CAPCTRL_1ERR_PTR_MSK		SHIFT0(0x1f)		
#define	PCIE_AE_CAPCTRL_1ERR_PTR_BASE		0

/*	PCIE_HDRLOG						0x011C	Header Log Registers */
#define	PCIE_HDRLOG_MSK			SHIFT0(0xffffffffU)	/* Header Log */
#define	PCIE_HDRLOG_BASE		0

/*	PCIE_DEVSERNUMCAP				0x0130	Device Serial Number Enhanced
 *											Capability Header
 */
/* Next Capability Offset */
#define	PCIE_DEVSERNUMCAP_NPTR_MSK			SHIFT20(0xfff)	
#define	PCIE_DEVSERNUMCAP_NPTR_BASE			20
#define	PCIE_DEVSERNUMCAP_VER_ID_MSK		SHIFT16(0xf)	/* Capability Version */
#define	PCIE_DEVSERNUMCAP_VER_ID_BASE		16
/* PCI Express Extended Capability ID */
#define	PCIE_DEVSERNUMCAP_CAP_ID_MSK		SHIFT0(0xffff)	
#define	PCIE_DEVSERNUMCAP_CAP_ID_BASE		0

/*	PCIE_SERNUM_LOWDW				0x0134	Serial Number Register (Lower DW) */
/* Serial Number Register (Lower DW) */
#define	PCIE_SERNUM_LOWDW_SERNUM_LOWDW_MSK		SHIFT0(0xffffffff)	
#define	PCIE_SERNUM_LOWDW_SERNUM_LOWDW_BASE		0

/*	PCIE_SERNUM_UPPDW				0x0138	Serial Number Register (Upper DW) */
/* Serial Number Register Upper DW) */
#define	PCIE_SERNUM_UPPDW_SERNUM_UPPDW_MSK		SHIFT0(0xffffffff)	
#define	PCIE_SERNUM_UPPDW_SERNUM_UPPDW_BASE		0

/*	PCIE_PWRBDGT_CAPHDR				0x0140	Power Budgeting Enhanced
 *											Capability Header
 */
/* Next Capability Offset */
#define	PCIE_PWRBDGT_CAPHDR_NPTR_MSK		SHIFT20(0xfff)	
#define	PCIE_PWRBDGT_CAPHDR_NPTR_BASE		20
#define	PCIE_PWRBDGT_CAPHDR_VER_ID_MSK		SHIFT16(0xf)	/* Capability Version */
#define	PCIE_PWRBDGT_CAPHDR_VER_ID_BASE		16
/* PCI Express Extended Capability ID */
#define	PCIE_PWRBDGT_CAPHDR_CAP_ID_MSK		SHIFT0(0xffff)	
#define	PCIE_PWRBDGT_CAPHDR_CAP_ID_BASE		0

/*	PCIE_PWRBDGT_DATASEL			0x0144	Power Budgeting Data Select
 *											Register
 */
/*		Bit(s) PCIE_PWRBDGT_DATASEL_RSRV_31_8 reserved */
#define	PCIE_PWRBDGT_DATASEL_DATASEL_MSK		SHIFT0(0xff)		/* Data Select */
#define	PCIE_PWRBDGT_DATASEL_DATASEL_BASE		0

/*	PCIE_PWRBDGT_DATA				0x0148	Power Budgeting Data Register */
/*		Bit(s) PCIE_PWRBDGT_DATA_RSRV_31_21 reserved */
#define	PCIE_PWRBDGT_DATA_PWRRAIL_MSK			SHIFT18(0x7)	/* Power Rail */
#define	PCIE_PWRBDGT_DATA_PWRRAIL_BASE			18
#define	PCIE_PWRBDGT_DATA_TYPE_MSK				SHIFT15(0x7)	/* Type */
#define	PCIE_PWRBDGT_DATA_TYPE_BASE				15
#define	PCIE_PWRBDGT_DATA_PMSTATE_MSK			SHIFT13(0x3)	/* PM State */
#define	PCIE_PWRBDGT_DATA_PMSTATE_BASE			13
#define	PCIE_PWRBDGT_DATA_PMSUBSTATE_MSK		SHIFT10(0x7)	/* PM Sub State */
#define	PCIE_PWRBDGT_DATA_PMSUBSTATE_BASE		10
#define	PCIE_PWRBDGT_DATA_DATASCALE_MSK			SHIFT8(0x3)		/* Data Scale */
#define	PCIE_PWRBDGT_DATA_DATASCALE_BASE		8
#define	PCIE_PWRBDGT_DATA_BASEPWR_MSK			SHIFT0(0xff)	/* Base Power */
#define	PCIE_PWRBDGT_DATA_BASEPWR_BASE			0

/*	PCIE_PWRBDGT_CAP				0x014c	Power Budgeting Capability Register */
/*		Bit(s) PCIE_PWRBDGT_CAP_RSRV_31_1 reserved */
#define	PCIE_PWRBDGT_CAP_SYSALLOC			BIT_0				/* System Allocated */

/*	PCIE_TL_CTRL					0x0200	Transaction Layer Control Register */
/*		Bit(s) PCIE_TL_CTRL_RSRV_31_2 reserved */
#define	PCIE_TL_CTRL_MAXOUTSTAND_MSK		SHIFT0(0x3)			/* Max_outstand */
#define	PCIE_TL_CTRL_MAXOUTSTAND_BASE		0

/*	PCIE_TL_STAT					0x0204	Transaction Layer Status Register */
/*		Bit(s) PCIE_TL_STAT_RSRV_31_0 reserved */

/*	PCIE_DL_CTRL					0x0208	Data Link Layer Control Register */
/*		Bit(s) PCIE_DL_CTRL_RSRV_31_0 reserved */

/*	PCIE_DL_STAT					0x020C	Data Link Layer Status Register */
/*		Bit(s) PCIE_DL_STAT_RSRV_31_0 reserved */

/*	PCIE_PL_CTRL					0x0210	PE Physical Layer Control Register */
/*		Bit(s) PCIE_PL_CTRL_RSRV_31_16 reserved */
#define	PCIE_PL_CTRL_N_FTS_MSK				SHIFT8(0xff)	/* N_FTS */
#define	PCIE_PL_CTRL_N_FTS_BASE				8
/*		Bit(s) PCIE_PL_CTRL_RSRV_7_0 reserved */

/*	PCIE_PL_STAT					0x0214	PE Physical Layer Status Register */
/*		Bit(s) PCIE_PL_STAT_RSRV_31_0 reserved */

/*	PCIE_CPLTO						0x0220	PE Completion Timeout Register */
/*		Bit(s) PCIE_CPLTO_RSRV_31_16 reserved */
#define	PCIE_CPLTO_MSK					SHIFT0(0xffff)	/* CmpTOThrshld */
#define	PCIE_CPLTO_BASE					0

/*	PCIE_FC							0x0224	PE Flow Control Register */
#define	PCIE_FC_PH_INIT_MSK			SHIFT24(0xff)	/* PHInitFC */
#define	PCIE_FC_PH_INIT_BASE		24
#define	PCIE_FC_NPH_INIT_MSK		SHIFT16(0xff)	/* NPHInitFC */
#define	PCIE_FC_NPH_INIT_BASE		16
#define	PCIE_FC_CH_INIT_MSK			SHIFT8(0xff)	/* CHInitFC */
#define	PCIE_FC_CH_INIT_BASE		8
#define	PCIE_FC_UPDATETO_MSK		SHIFT0(0xff)	/* FCUpdateTO */
#define	PCIE_FC_UPDATETO_BASE		0

/*	PCIE_ACKTIM_X1					0x0228	PE Ack Timer for 1x Link Register */
#define	PCIE_ACKTIM_X1_RPLYTO_MSK		SHIFT16(0xffff)	/* AckRplyTOX1 */
#define	PCIE_ACKTIM_X1_RPLYTO_BASE		16
#define	PCIE_ACKTIM_X1_LATTO_MSK		SHIFT0(0xffff)	/* AckLatTOX1 */
#define	PCIE_ACKTIM_X1_LATTO_BASE		0

/* -------------------- */

/*
 *
 *	THE BASE ADDRESSES
 *
 */

/*
 *
 *	THE REGISTER DEFINES
 *
 */
#define	GLB_RAP				0x0000	/* 32 bit	Register Address Port (RAP)
									 *			Register
									 */
#define	GLB_CSR				0x0004	/* 24 bit	Control/Status Register */
#define	GLB_PCTRL			0x0007	/*  8 bit	Power Control Register */
#define	GLB_ISRC			0x0008	/* 32 bit	Interrupt Source Register */
#define	GLB_IMSK			0x000C	/* 32 bit	Interrupt Mask Register */
#define	GLB_ISRC_HW			0x0010	/* 32 bit	Interrupt HW Error Source
									 *			Register
									 */
#define	GLB_IMSK_HW			0x0014	/* 32 bit	Interrupt HW Error Mask Register */
#define	GLB_ISRC_SP1		0x0018	/* 32 bit	Special Interrupt Source
									 *			Register 1
									 */
#define	GLB_ISRC_SP2		0x001C	/* 32 bit	Special Interrupt Source
									 *			Register 2
									 */
#define	GLB_ISRC_SP3		0x0020	/* 32 bit	Special Interrupt Source
									 *			Register 3
									 */
#define	GLB_EISR			0x0024	/* 32 bit	Enter Interrupt Service Routine
									 *			Register
									 */
#define	GLB_LISR			0x0028	/* 32 bit	Leave Interrupt Service Routine
									 *			Register
									 */
#define	GLB_ICTRL			0x002C	/* 32 bit	Interrupt Control Register */
#define	SPI_CTRL			0x0060	/* 32 bit	SPI Flash Memory Control
									 *			Register
									 */
#define	SPI_ADDR			0x0064	/* 32 bit	SPI Flash Memory Address
									 *			Register
									 */
#define	SPI_DATA			0x0068	/* 32 bit	SPI Flash Memory Data Register */
#define	SPI_ID				0x006C	/* 32 bit	SPI Flash Memory Vendor/Device
									 *			ID Register
									 */
#define	SPI_LCFG			0x0070	/* 32 bit	SPI Flash Memory Loader
									 *			Configuration Register
									 */
#define	SPI_CFG				0x0074	/* 32 bit	SPI Flash Memory Configuration
									 *			Register
									 */
#define	SPI_OPC1			0x0078	/* 32 bit	SPI Flash Memory Opcode 1
									 *			Register
									 */
#define	SPI_OPC2			0x007C	/* 32 bit	SPI Flash Memory Opcode 2
									 *			Register
									 */
#define	GLB_BWIN			0x0080 	/* 32 bit	Block Window Register */
#define	L1_CFG_MADDR_HI		0x0100	/*32 bit	Link1 MAC Address Register High */
#define	M_CFG_MADDR_HI		0x0110	/*32 bit	maintenance MAC Address Register High */
#define	L1_CFG_MADDR_LO		0x0104	/*32 bit	Link1 MAC Address Register Low */
#define	M_CFG_MADDR_LO		0x0114	/*32 bit	maintenance MAC Address Register Low */
#define	CFG_IF				0x0118	/* 16 bit	Interface Type Register (PMD
									 *			Type and Connector Type)
									 */
#define	CFG_CREV			0x011A	/*  8 bit	Chip Revision Register */
#define	CFG_CID				0x011B	/*  8 bit	Chip ID Register */
#define	CFG_CGATE			0x011C	/* 16 bit	Clock Gating Register */
#define	CFG_AIR2			0x011E	/*  8 bit	Application Information
									 *			Register 2
									 */
#define	CFG_AIR1			0x011F	/*  8 bit	Application Information
									 *			Register 1
									 */
#define	CFG_CDIV			0x0120	/* 32 bit	Clock Divider Register */
#define	IRQ_TIM_INIT		0x0130	/* 32 bit	Timer Init Value Register */
#define	IRQ_TIM_CNT			0x0134	/* 32 bit	Timer Register */
#define	IRQ_TIM_TCTRL		0x0138	/* 32 bit	Timer Control/Test Register */
#define	MOD_TIM_INIT		0x0140	/* 32 bit	IRQ Moderation Timer Init Value
									 *			Register
									 */
#define	MOD_TIM_CNT			0x0144	/* 32 bit	IRQ Moderation Timer Register */
#define	MOD_TIM_TCTRL		0x0148	/* 32 bit	IRQ Moderation Timer
									 *			Control/Test Register
									 */
#define	MOD_TIM_MSK			0x014C	/* 32 bit	Interrupt Moderation Mask
									 *			Register
									 */
#define	MOD_TIM_MSK_HW		0x0150	/* 32 bit	Interrupt Hardware Error
									 *			Moderation Mask Register
									 */
#define	GLB_TCTRL			0x0158	/* 32 bit	Test Control Register 1 */
#define	GLB_GPIO			0x015C	/* 32 bit	General Purpose I/O Register */
#define	TWSI_CTRL			0x0160	/* 32 bit	TWSI (HW) Control Register */
#define	TWSI_DATA			0x0164	/* 32 bit	TWSI (HW) Data Register */
#define	TWSI_IRQ			0x0168	/* 32 bit	TWSI (HW) IRQ Register */
#define	TWSI_SW				0x016C	/* 32 bit	TWSI (SW) Register */
#define	PCIE_PHY			0x0170	/* 32 bit	PCI Express PHY Address Register */
#define	RAM_ADDR			0x0180	/* 32 bit	RAM Address Register */
#define	RAM_DATA_LO			0x0184	/* 32 bit	Data Port/Lower Dword Register */
#define	RAM_DATA_HI			0x0188	/* 32 bit	Data Port/Upper Dword Register */
#define	ASF_TO				0x0190	/* 32 bit	Timeout Register */
#define	ASF_CTRL			0x01A0	/* 32 bit	FIFO Interface Control */
#define	RSS_KEY0			0x0220	/* 32 bit	RSS Key 0 Register */
#define	RSS_KEY1			0x0224	/* 32 bit	RSS Key 1 Register */
#define	RSS_KEY2			0x0228	/* 32 bit	RSS Key 2 Register */
#define	RSS_KEY3			0x022C	/* 32 bit	RSS Key 3 Register */
#define	RSS_KEY4			0x0230	/* 32 bit	RSS Key 4 Register */
#define	RSS_KEY5			0x0234	/* 32 bit	RSS Key 5 Register */
#define	RSS_KEY6			0x0238	/* 32 bit	RSS Key 6 Register */
#define	RSS_KEY7			0x023C	/* 32 bit	RSS Key 7 Register */
#define	RSS_KEY8			0x0240	/* 32 bit	RSS Key 8 Register */
#define	RSS_KEY9			0x0244	/* 32 bit	RSS Key 9 Register */
#define	RSS_CFG				0x0248	/* 32 bit	RSS Configuration Register */
#define	RBMU_DESCR			0x0400	/* 32 bit	Current Receive Descriptor
									 *			Register
									 */
#define	RBMU_HASH			0x0404	/* 32 bit	RSS Hash Checksum Register */
#define	RBMU_ADDR_HI		0x0408	/* 32 bit	Receive Buffer Address Lo
									 *			Register
									 */
#define	RBMU_ADDR_LO		0x040C	/* 32 bit	Receive Buffer Address Hi
									 *			Register
									 */
#define	RBMU_RFSW			0x0410	/* 32 bit	Receive Buffer Status Word
									 *			Register
									 */
#define	RBMU_TSP			0x0414	/* 32 bit	Receive Timestamp Register */
#define	RBMU_VLAN			0x0420	/* 32 bit	VLAN Tag Register */
#define	RBMU_DONE_IDX		0x0424	/* 32 bit	Receive Done Index Register */
#define	RBMU_REQ_ADDR_LO	0x0428	/* 32 bit	Receive Request Address, Lower
									 *			Register
									 */
#define	RBMU_REQ_ADDR_HI	0x042C	/* 32 bit	Receive Request Address, Upper
									 *			Register
									 */
#define	RBMU_REQ_CNT		0x0430	/* 32 bit	Receive Request Byte Count
									 *			Register
									 */
#define	RBMU_CSR			0x0434	/* 32 bit	Receive BMU Control/Status
									 *			Register
									 */
#define	RBMU_TEST			0x0438	/* 32 bit	Receive BMU Test Register */
#define	RBMU_SM				0x043C	/* 32 bit	Receive BMU State Machine
									 *			Register
									 */
#define	RBMU_FIFO_WM		0x0440	/* 16 bit	Receive FIFO Watermark Register */
#define	RBMU_FIFO_AL		0x0442	/* 16 bit	Receive FIFO Alignment Register */
#define	RPFU_CTRL			0x0450	/* 32 bit	Receive Prefetch Control
									 *			Register
									 */
#define	RPFU_LAST_IDX		0x0454	/* 32 bit	Receive PFU List Last Index
									 *			Register
									 */
#define	RPFU_LADR_LO		0x0458	/* 32 bit	Receive PFU List Start Address
									 *			Low Register
									 */
#define	RPFU_LADR_HI		0x045C	/* 32 bit	Receive PFU List Start Address
									 *			High Register
									 */
#define	RPFU_GET_IDX		0x0460	/* 32 bit	Receive PFU Get Index Register */
#define	RPFU_PUT_IDX		0x0464	/* 32 bit	Receive PFU Put Index Register */
#define	RPFU_FIFO_WR		0x0470	/* 32 bit	Receive PFU FIFO RAM Write and
									 *			Write Shadow Pointer Register
									 */
#define	RPFU_FIFO_RD		0x0474	/* 32 bit	Receive PFU FIFO RAM Read
									 *			Pointer Register
									 */
#define	RPFU_FIFO_REQ_NB	0x0478	/* 32 bit	Receive PFU Master Request
									 *			nbytes Register
									 */
#define	RPFU_FIFO_LEV		0x047C	/* 32 bit	Receive PFU FIFO Shadow Level
									 *			Register
									 */
#define	TBMU_DESC1			0x0680	/* 32 bit	Current Transmit Descriptor
									 *			Register 1
									 */
#define	TBMU_DESC2			0x0684	/* 16 bit	Current Transmit Descriptor
									 *			Register 2
									 */
#define	TBMU_ADDR_LO		0x0688	/* 32 bit	Transmit Buffer Address Lower
									 *			Register
									 */
#define	TBMU_ADDR_HI		0x068C	/* 32 bit	Transmit Buffer Address Upper
									 *			Register
									 */
#define	TBMU_TFSW			0x0690	/* 32 bit	Transmit Buffer Status Word
									 *			Register
									 */
#define	TBMU_VLAN			0x06A0	/* 32 bit	Transmit VLAN Tag Register */
#define	TBMU_DONE_IDX		0x06A4	/* 32 bit	Transmit Done Index Register */
#define	TBMU_REQ_ADDR_LO	0x06A8	/* 32 bit	Transmit Request Address Lower
									 *			Register
									 */
#define	TBMU_REQ_ADDR_HI	0x06AC	/* 32 bit	Transmit Request Address Upper
									 *			Register
									 */
#define	TBMU_REQ_CNT		0x06B0	/* 32 bit	Transmit Request Byte Count
									 *			Register
									 */
#define	TBMU_CSR			0x06B4	/* 32 bit	Transmit BMU Control/Status
									 *			Register
									 */
#define	TBMU_TEST			0x06B8	/* 32 bit	Transmit BMU Test Register */
#define	TBMU_SM				0x06BC	/* 32 bit	Transmit BMU State Machine
									 *			Register
									 */
#define	TBMU_FIFO_WM		0x06C0	/* 16 bit	Transmit FIFO Watermark Register */
#define	TBMU_FIFO_AL		0x06C2	/* 16 bit	Transmit FIFO Alignment Register */
#define	TBMU_FIFO_WSPTR		0x06C4	/* 16 bit	Transmit FIFO Write Shadow
									 *			Pointer Register
									 */
#define	TBMU_FIFO_WSLEV		0x06C6	/* 16 bit	Transmit FIFO Write Shadow
									 *			Level Register
									 */
#define	TBMU_FIFO_WPTR		0x06C8	/* 16 bit	Transmit FIFO Write Pointer
									 *			Register
									 */
#define	TBMU_FIFO_WLEV		0x06CA	/* 16 bit	Transmit FIFO Write Level
									 *			Register
									 */
#define	TBMU_FIFO_RPTR		0x06CC	/* 16 bit	Transmit FIFO Read Pointer
									 *			Register
									 */
#define	TBMU_RLEV			0x06CE	/* 16 bit	Transmit FIFO Read Level
									 *			Register
									 */
#define	TPFU_CTRL			0x06D0	/* 32 bit	Transmit Prefetch Control
									 *			Register
									 */
#define	TPFU_LAST_IDX		0x06D4	/* 32 bit	Transmit PFU List Last Index
									 *			Register
									 */
#define	TPFU_LADR_LO		0x06D8	/* 32 bit	Transmit PFU List Start Address
									 *			Low Register
									 */
#define	TPFU_LADR_HI		0x06DC	/* 32 bit	Transmit PFU List Start Address
									 *			High Register
									 */
#define	TPFU_GET_IDX		0x06E0	/* 32 bit	Transmit PFU Get Index Register */
#define	TPFU_PUT_IDX		0x06E4	/* 32 bit	Transmit PFU Put Index Register */
#define	TPFU_FIFO_WR		0x06F0	/* 32 bit	Transmit PFU FIFO RAM Write and
									 *			Write Shadow Pointer Register
									 */
#define	TPFU_FIFO_RD		0x06F4	/* 32 bit	Transmit PFU FIFO RAM Read
									 *			Pointer Register
									 */
#define	TPFU_FIFO_REQ_NB	0x06F8	/* 32 bit	Transmit PFU Master Request
									 *			nbytes Register
									 */
#define	TPFU_FIFO_LEV		0x06FC	/* 32 bit	Transmit PFU FIFO Shadow Level
									 *			Register
									 */
#define	RA_SADDR			0x0900	/* 32 bit	ASF Receive FIFO Start Address */
#define	RA_EADDR			0x0904	/* 32 bit	ASF Receive FIFO End Address */
#define	RA_WPTR				0x0908	/* 32 bit	ASF Receive FIFO Write Pointer */
#define	RA_RPTR				0x090C	/* 32 bit	ASF Receive FIFO Read Pointer */
#define	RA_BRST				0x0910	/* 32 bit	ASF Receive FIFO Burst Control */
#define	RA_PCNT				0x0920	/* 32 bit	ASF Receive FIFO Packet Counter */
#define	RA_LEV				0x0924	/* 32 bit	ASF Receive FIFO Level */
#define	RA_CTRL				0x0928	/* 32 bit	ASF Receive FIFO Control/Test */
#define	RA_FLSH_CTRL		0x092C	/* 32 bit	ASF Receive FIFO Flush Control */
#define	TA_SADDR			0x0940	/* 32 bit	ASF Transmit FIFO Start Address */
#define	TA_EADDR			0x0944	/* 32 bit	ASF Transmit FIFO End Address */
#define	TA_WPTR				0x0948	/* 32 bit	ASF Transmit FIFO Write Pointer */
#define	TA_RPTR				0x094C	/* 32 bit	ASF Transmit FIFO Read Pointer */
#define	TA_PCNT				0x0960	/* 32 bit	ASF Transmit FIFO Packet Counter */
#define	TA_LEV				0x0964	/* 32 bit	ASF Transmit FIFO Level */
#define	TA_CTRL				0x0968	/* 32 bit	ASF Transmit FIFO Control/Test */
#define	TA_SEND_CTRL		0x096C	/* 32 bit	ASF Transmit FIFO Send Control */
#define	RXMF_EADDR			0x0C40	/* 32 bit	Receive MAC FIFO End Address
									 *			Register
									 */
#define	RXMF_AFTH			0x0C44	/* 32 bit	Receive MAC FIFO Almost Full
									 *			Threshold Register
									 */
#define	RXMF_TCTL			0x0C48	/* 32 bit	Receive MAC FIFO Control/Test
									 *			Register
									 */
#define	RXMF_FLMSK			0x0C4C	/* 32 bit	Receive MAC FIFO Flush Mask
									 *			Register
									 */
#define	RXMF_FLTH			0x0C50	/* 32 bit	Receive MAC FIFO Flush
									 *			Threshold Register
									 */
#define	RXMF_TRTH			0x0C54	/* 32 bit	Receive Truncation Threshold
									 *			Register
									 */
#define	RXMF_ULTH			0x0C58	/* 32 bit	Upper/Lower Threshold/Pause
									 *			Packets Register
									 */
#define	RXMF_VLTYP			0x0C5C	/* 32 bit	Receive VLAN Type Register */
#define	RXMF_WPTR			0x0C60	/* 32 bit	Receive MAC FIFO Write Pointer
									 *			Register
									 */
#define	RXMF_WLEV			0x0C68	/* 32 bit	Receive MAC FIFO Write Level
									 *			Register
									 */
#define	RXMF_RPTR			0x0C70	/* 32 bit	Receive MAC FIFO Read Pointer
									 *			Register
									 */
#define	RXMF_RLEV			0x0C78	/* 32 bit	Receive MAC FIFO Read Level
									 *			Register
									 */
#define	TXMF_EADDR			0x0D40	/* 32 bit	Transmit MAC FIFO End Address
									 *			Register
									 */
#define	TXMF_AETH			0x0D44	/* 32 bit	Transmit MAC FIFO Almost Empty
									 *			Threshold Register
									 */
#define	TXMF_TCTL			0x0D48	/* 32 bit	Transmit MAC FIFO Control/Test
									 *			Register
									 */
#define	TXMF_VLTYP			0x0D5C	/* 32 bit	Transmit VLAN Type Register */
#define	TXMF_WPTR			0x0D60	/* 32 bit	Transmit MAC FIFO Write Pointer
									 *			Register
									 */
#define	TXMF_WSPTR			0x0D64	/* 32 bit	Transmit MAC FIFO Write Shadow
									 *			Pointer Register
									 */
#define	TXMF_WLEV			0x0D68	/* 32 bit	Transmit MAC FIFO Write Level
									 *			Register
									 */
#define	TXMF_RPTR			0x0D70	/* 32 bit	Transmit MAC FIFO Read Pointer
									 *			Register
									 */
#define	TXMF_RES_PTR		0x0D74	/* 32 bit	Transmit MAC FIFO Restart
									 *			Pointer Register
									 */
#define	TXMF_RLEV			0x0D78	/* 32 bit	Transmit MAC FIFO Read Level
									 *			Register
									 */
#define	DPOL_TIM_INIT		0x0E00	/* 32 bit	Descriptor Poll Timer Init
									 *			Value Register
									 */
#define	DPOL_TIM_CNT		0x0E04	/* 32 bit	Descriptor Poll Timer Register */
#define	DPOL_TCTL			0x0E08	/* 32 bit	Descriptor Poll Timer
									 *			Control/Test Register
									 */
#define	TSP_TIM_CNT			0x0E14	/* 32 bit	Timestamp Timer Registers */
#define	TSP_TIM_TCTL		0x0E18	/* 32 bit	Timestamp Timer Control/Test
									 *			Register
									 */
//#define	POLL_CTRL			0x0E20	/* 32 bit	Poll Control Register */
//#define	POLL_LAST_IDX		0x0E24	/* 32 bit	List Last Index Register */
#define	POLL_LADR_LO		0x0E28	/* 32 bit	List Start Address Low Register */
#define	POLL_LADR_HI		0x0E2C	/* 32 bit	List Start Address High Register */
#define	CPU_ISRC			0x0E30	/* 32 bit	Interrupt Source Register */
#define	CPU_IMSK			0x0E34	/* 32 bit	Interrupt Mask Register */
#define	SMB_CFG				0x0E40	/* 32 bit	SMBus Config Register */
#define	SMB_CSR				0x0E44	/* 32 bit	SMBus Control/Status Register */
#define	CPU_WDOG			0x0E48	/* 32 bit	Watchdog Register */
#define	CPU_CNTR			0x0E4C	/* 32 bit	Counter Register */
#define	CPU_TIM				0x0E50	/* 32 bit	Timer Compare Register */
#define	CPU_AHB_ADDR		0x0E54	/* 32 bit	CPU AHB Debug Register */
#define	CPU_AHB_WDATA		0x0E58	/* 32 bit	CPU AHB Debug Register */
#define	CPU_AHB_RDATA		0x0E5C	/* 32 bit	CPU AHB Debug Register */
#define	HCU_MAP_BASE		0x0E60	/* 32 bit	Reset Mapping Base */
#define	CPU_AHB_CTRL		0x0E64	/* 32 bit	CPU AHB Debug Register */
#define	HCU_CCSR			0x0E68	/* 32 bit	CPU Control and Status Register */
#define	HCU_HCSR			0x0E6C	/* 32 bit	Host Control and Status Register */
#define	HCU_DATA1			0x0E70	/* 32 bit	Data Register 1 */
#define	HCU_DATA2			0x0E74	/* 32 bit	Data Register 2 */
#define	HCU_DATA3			0x0E78	/* 32 bit	Data Register 3 */
#define	HCU_DATA4			0x0E7C	/* 32 bit	Data Register 4 */
//#define	STAT_CTRL			0x0E80	/* 32 bit	Status BMU Control Register */
//#define	STAT_LAST_IDX		0x0E84	/* 32 bit	Last Index Register */
#define	STAT_LADR_LO		0x0E88	/* 32 bit	List Start Address Lower
									 *			Register
									 */
#define	STAT_LADR_HI		0x0E8C	/* 32 bit	List Start Address Upper
									 *			Register
									 */
#define	STAT_TXA_REP		0x0E90	/* 16 bit	TXA Report Index Register */
#define	STAT_TXTH			0x0E98	/* 16 bit	TX Index Threshold Register */
#define	STAT_PUT			0x0E9C	/* 32 bit	Put Index Register */
#define	STAT_FIFO_WPTR		0x0EA0	/* 32 bit	FIFO Write Pointer Register */
#define	STAT_FIFO_RPTR		0x0EA4	/* 32 bit	FIFO Read Pointer Register */
#define	STAT_FIFO_LEV		0x0EA8	/* 32 bit	FIFO Level Register */
//#define	STAT_FIFO_WM		0x0EAC	/*  8 bit	FIFO Watermark Register */
#define	STAT_FIFO_WM_ISR	0x0EAD	/*  8 bit	FIFO ISR Watermark Register */
#define	LEV_TIM_INIT		0x0EB0	/* 32 bit	Level Timer Init Value Register */
#define	LEV_TIM_CNT			0x0EB4	/* 32 bit	Level Timer Counter Register */
#define	LEV_TIM_TCTL		0x0EB8	/* 32 bit	Level Timer Control/Test
									 *			Register
									 */
#define	TX_TIM_INIT			0x0EC0	/* 32 bit	TX TImer Init Value Register */
#define	TX_TIM_CNT			0x0EC4	/* 32 bit	TX Timer Counter Register */
#define	TX_TIM_TCTL			0x0EC8	/* 32 bit	TX Timer Control/Test Register */
#define	ISR_TIM_INIT		0x0ED0	/* 32 bit	ISR Timer Init Value Register */
#define	ISR_TIM_CNT			0x0ED4	/* 32 bit	ISR Timer Counter Register */
#define	ISR_TIM_TCTL		0x0ED8	/* 32 bit	ISR Timer Control/Test Register */
#define	MAC_CTRL			0x0F00	/* 16 bit	MAC Control Registers */
#define	PHY_CFG				0x0F04	/* 32 bit	PHY Config Register, loaded
									 *			from external memory
									 */
#define	MAC_ISRC			0x0F08	/* 32 bit	MAC Interrupt Source Register */
#define	MAC_IMSK			0x0F0C	/* 32 bit	MAC Interrupt Mask Register */
#define	LINK_CTRL			0x0F10	/* 16 bit	Link Control Register */
#define	WOL_CSR				0x0F20	/* 16 bit	WOL Control/Status Register */
#define	WOL_MCTRL			0x0F22	/* 16 bit	Match Control Register */
#define	WOL_MADDR_LO		0x0F24	/* 32 bit	MAC Address Register Low
									 *			Register
									 */
#define	WOL_MADDR_HI		0x0F28	/* 16 bit	MAC Address Register High
									 *			Register
									 */
#define	WOL_PME_MEN			0x0F2A	/* 16 bit	PME Match Enable Register */
#define	WOL_ASF_MEN			0x0F2C	/* 16 bit	ASF Match Enable Register */
#define	WOL_MRSL			0x0F2E	/* 16 bit	Match Result Register */
#define	WOL_PLEN0			0x0F30	/* 32 bit	Pattern Length Register 0 (0-3) */
#define	WOL_PLEN1			0x0F34	/* 32 bit	Pattern Length Register 1 (4-7) */
#define	WOL_PLEN2			0x0F38	/* 32 bit	Pattern Length Register 2 (8) */
#define	WOL_PCNT0			0x0F40	/* 32 bit	Pattern Counter Register 0 (0-3) */
#define	WOL_PCNT1			0x0F44	/* 32 bit	Pattern Counter Register 1 (4-7) */
#define	WOL_PCNT2			0x0F48	/* 32 bit	Pattern Counter Register 2 (8) */
#define	PAT_CSR				0x0F50	/* 32 bit	Pattern RAM Control/Status
									 *			Register
									 */
#define	PAT_RAM				0x1000	/* 32 bit	Pattern RAM Register */
#define	THDR0_LO			0x1900	/* 32 bit	TCP Segmentation Header
									 *			Register 0 Lo
									 */
#define	THDR0_HI			0x1904	/* 32 bit	TCP Segmentation Header
									 *			Register 0 Hi
									 */
#define	THDR1_LO			0x1908	/* 32 bit	TCP Segmentation Header
									 *			Register 1 Lo
									 */
#define	THDR1_HI			0x190C	/* 32 bit	TCP Segmentation Header
									 *			Register 1 Hi
									 */
#define	THDR2_LO			0x1910	/* 32 bit	TCP Segmentation Header
									 *			Register 2 Lo
									 */
#define	THDR2_HI			0x1914	/* 32 bit	TCP Segmentation Header
									 *			Register 2 Hi
									 */
#define	THDR3_LO			0x1918	/* 32 bit	TCP Segmentation Header
									 *			Register 3 Lo
									 */
#define	THDR3_HI			0x191C	/* 32 bit	TCP Segmentation Header
									 *			Register 3 Hi
									 */
#define	THDR4_LO			0x1920	/* 32 bit	TCP Segmentation Header
									 *			Register 4 Lo
									 */
#define	THDR4_HI			0x1924	/* 32 bit	TCP Segmentation Header
									 *			Register 4 Hi
									 */
#define	THDR5_LO			0x1928	/* 32 bit	TCP Segmentation Header
									 *			Register 5 Lo
									 */
#define	THDR5_HI			0x192C	/* 32 bit	TCP Segmentation Header
									 *			Register 5 Hi
									 */
#define	THDR6_LO			0x1930	/* 32 bit	TCP Segmentation Header
									 *			Register 6 Lo
									 */
#define	THDR6_HI			0x1934	/* 32 bit	TCP Segmentation Header
									 *			Register 6 Hi
									 */
#define	THDR7_LO			0x1938	/* 32 bit	TCP Segmentation Header
									 *			Register 7 Lo
									 */
#define	THDR7_HI			0x193C	/* 32 bit	TCP Segmentation Header
									 *			Register 7 Hi
									 */
#define	THDR8_LO			0x1940	/* 32 bit	TCP Segmentation Header
									 *			Register 8 Lo
									 */
#define	THDR8_HI			0x1944	/* 32 bit	TCP Segmentation Header
									 *			Register 8 Hi
									 */
#define	THDR9_LO			0x1948	/* 32 bit	TCP Segmentation Header
									 *			Register 9 Lo
									 */
#define	THDR9_HI			0x194C	/* 32 bit	TCP Segmentation Header
									 *			Register 9 Hi
									 */
#define	THDR10_LO			0x1950	/* 32 bit	TCP Segmentation Header
									 *			Register 10 Lo
									 */
#define	THDR10_HI			0x1954	/* 32 bit	TCP Segmentation Header
									 *			Register 10 Hi
									 */
#define	THDR11_LO			0x1958	/* 32 bit	TCP Segmentation Header
									 *			Register 11 Lo
									 */
#define	THDR11_HI			0x195C	/* 32 bit	TCP Segmentation Header
									 *			Register 11 Hi
									 */
#define	THDR12_LO			0x1960	/* 32 bit	TCP Segmentation Header
									 *			Register 12 Lo
									 */
#define	THDR12_HI			0x1964	/* 32 bit	TCP Segmentation Header
									 *			Register 12 Hi
									 */
#define	THDR13_LO			0x1968	/* 32 bit	TCP Segmentation Header
									 *			Register 13 Lo
									 */
#define	THDR13_HI			0x196C	/* 32 bit	TCP Segmentation Header
									 *			Register 13 Hi
									 */
#define	THDR14_LO			0x1970	/* 32 bit	TCP Segmentation Header
									 *			Register 14 Lo
									 */
#define	THDR14_HI			0x1974	/* 32 bit	TCP Segmentation Header
									 *			Register 14 Hi
									 */
#define	THDR15_LO			0x1978	/* 32 bit	TCP Segmentation Header
									 *			Register 15 Lo
									 */
#define	THDR15_HI			0x197C	/* 32 bit	TCP Segmentation Header
									 *			Register 15 Hi
									 */
#define	THDR16_LO			0x1980	/* 32 bit	TCP Segmentation Header
									 *			Register 16 Lo
									 */
#define	THDR16_HI			0x1984	/* 32 bit	TCP Segmentation Header
									 *			Register 16 Hi
									 */
#define	THDR17_LO			0x1988	/* 32 bit	TCP Segmentation Header
									 *			Register 17 Lo
									 */
#define	THDR17_HI			0x198C	/* 32 bit	TCP Segmentation Header
									 *			Register 17 Hi
									 */
#define	THDR18_LO			0x1990	/* 32 bit	TCP Segmentation Header
									 *			Register 18 Lo
									 */
#define	THDR18_HI			0x1994	/* 32 bit	TCP Segmentation Header
									 *			Register 18 Hi
									 */
#define	THDR19_LO			0x1998	/* 32 bit	TCP Segmentation Header
									 *			Register 19 Lo
									 */
#define	THDR19_HI			0x199C	/* 32 bit	TCP Segmentation Header
									 *			Register 19 Hi
									 */
#define	THDR20_LO			0x19A0	/* 32 bit	TCP Segmentation Header
									 *			Register 20 Lo
									 */
#define	THDR20_HI			0x19A4	/* 32 bit	TCP Segmentation Header
									 *			Register 20 Hi
									 */
#define	THDR21_LO			0x19A8	/* 32 bit	TCP Segmentation Header
									 *			Register 21 Lo
									 */
#define	THDR21_HI			0x19AC	/* 32 bit	TCP Segmentation Header
									 *			Register 21 Hi
									 */
#define	THDR22_LO			0x19B0	/* 32 bit	TCP Segmentation Header
									 *			Register 22 Lo
									 */
#define	THDR22_HI			0x19B4	/* 32 bit	TCP Segmentation Header
									 *			Register 22 Hi
									 */
#define	THDR23_LO			0x19B8	/* 32 bit	TCP Segmentation Header
									 *			Register 23 Lo
									 */
#define	THDR23_HI			0x19BC	/* 32 bit	TCP Segmentation Header
									 *			Register 23 Hi
									 */
#define	THDR24_LO			0x19C0	/* 32 bit	TCP Segmentation Header
									 *			Register 24 Lo
									 */
#define	THDR24_HI			0x19C4	/* 32 bit	TCP Segmentation Header
									 *			Register 24 Hi
									 */
#define	THDR25_LO			0x19C8	/* 32 bit	TCP Segmentation Header
									 *			Register 25 Lo
									 */
#define	THDR25_HI			0x19CC	/* 32 bit	TCP Segmentation Header
									 *			Register 25 Hi
									 */
#define	THDR26_LO			0x19D0	/* 32 bit	TCP Segmentation Header
									 *			Register 26 Lo
									 */
#define	THDR26_HI			0x19D4	/* 32 bit	TCP Segmentation Header
									 *			Register 26 Hi
									 */
#define	THDR27_LO			0x19D8	/* 32 bit	TCP Segmentation Header
									 *			Register 27 Lo
									 */
#define	THDR27_HI			0x19DC	/* 32 bit	TCP Segmentation Header
									 *			Register 27 Hi
									 */
#define	THDR28_LO			0x19E0	/* 32 bit	TCP Segmentation Header
									 *			Register 28 Lo
									 */
#define	THDR28_HI			0x19E4	/* 32 bit	TCP Segmentation Header
									 *			Register 28 Hi
									 */
#define	THDR29_LO			0x19E8	/* 32 bit	TCP Segmentation Header
									 *			Register 29 Lo
									 */
#define	THDR29_HI			0x19EC	/* 32 bit	TCP Segmentation Header
									 *			Register 29 Hi
									 */
#define	THDR30_LO			0x19F0	/* 32 bit	TCP Segmentation Header
									 *			Register 30 Lo
									 */
#define	CFG_VLAN_ET1		0x2000	/* 32 bit	VLAN Ethernet Type
									 *			Configuration Register 1
									 */
#define	CFG_VLAN_ET0		0x2004	/* 32 bit	VLAN Ethernet Type
									 *			Configuration Register 0
									 */
#define	CFG_MACSEC_ET1		0x2008	/* 32 bit	802.1AE Ethernet Type
									 *			Configuration Register 1
									 */
#define	CFG_MACSEC_ET0		0x200C	/* 32 bit	802.1AE Ethernet Type
									 *			Configuration Register 0
									 */
#define	CFG_TRAIL_SZ		0x2010	/* 32 bit	Trail Size Configuration
									 *			Register
									 */
#define	CFG_DEFAULT_VLAN0	0x2014	/* 32 bit	Default VLAN Register 0 */
#define	CFG_DEFAULT_VLAN1	0x2018	/* 32 bit	Default VLAN Register 1 */
#define	CFG_MACSEC_SL_SZ	0x201C	/* 32 bit	MACSec Size Configuration
									 *			Register
									 */
#define	CFG_MIN_PKT_LEN		0x2020	/* 32 bit	Minimum Packet Length
									 *			Configuration Register
									 */
#define	SEC_CLK_RST			0x2024	/* 32 bit	MACSec Clock Reset Register */
#define	EGR_KS_SELECT		0x2028	/* 32 bit	Egress Key Store Select Register */
#define	EGR_KS_WRDATA		0x202C	/* 32 bit	Egress Key Store Write Data
									 *			Register
									 */
#define	IGR_KS_SELECT		0x2030	/* 32 bit	Ingress Key Store Select
									 *			Register
									 */
#define	IGR_KS_WRDATA		0x2034	/* 32 bit	Ingress Key Store Write Data
									 *			Register
									 */
#define	CFG_ELU_MC_HIGH0	0x2038	/* 32 bit	Multicast Match Register 0 */
#define	CFG_ELU_MC_HIGH1	0x203C	/* 32 bit	Multicast Match Register 1 */
#define	CFG_ELU_MC_HIGH2	0x2040	/* 32 bit	Multicast Match Register 2 */
#define	CFG_ELU_MC_HIGH3	0x2044	/* 32 bit	Multicast Match Register 3 */
#define	CFG_ELU_MC_HIGH4	0x2048	/* 32 bit	Multicast Match Register 4 */
#define	CFG_ELU_MC_HIGH5	0x204C	/* 32 bit	Multicast Match Register 5 */
#define	CFG_ELU_MC_LOW_MSK0	0x2050	/* 32 bit	Multicast Match Mask Register 0 */
#define	CFG_ELU_MC_LOW_MSK1	0x2054	/* 32 bit	Multicast Match Mask Register 1 */
#define	CFG_DEFAULT_PORT0	0x2058	/* 32 bit	Default Port Configuration
									 *			Register 0
									 */
#define	CFG_DEFAULT_PORT1	0x205C	/* 32 bit	Default Port Configuration
									 *			Register 1
									 */
#define	CFG_SCB_PORT0		0x2060	/* 32 bit	SCB Port Configuration Register
									 *			0
									 */
#define	CFG_SCB_PORT1		0x2064	/* 32 bit	SCB Port Configuration Register
									 *			1
									 */
#define	CFG_AUTH_ADJUST		0x2068	/* 32 bit	Authentication Adjustment
									 *			Register
									 */
#define	CFG_ELU_GEN			0x206C	/* 32 bit	ELU Default Configuration
									 *			Register
									 */
#define	CFG_ELUC_ADDR		0x2070	/* 32 bit	ELU Address Configuration
									 *			Register
									 */
#define	CFG_ELUC_DATA		0x2074	/* 32 bit	ELU Context Data Configuration
									 *			Register
									 */
#define	CFG_ELUE_ADDR		0x2078	/* 32 bit	ELU Entry Configuration Register */
#define	CFG_ELUE_DATA		0x207C	/* 32 bit	ELU Lookup Entry Access
									 *			Configuration Register
									 */
#define	CFG_EPR_GEN			0x2080	/* 32 bit	General Egress Parser
									 *			Configuration Register
									 */
#define	EGR_HR_SELECT		0x2084	/* 32 bit	Egress Write Select for H-Store
									 *			Register
									 */
#define	EGR_HR_WRDATA		0x2088	/* 32 bit	Egress Header Write Data
									 *			Register
									 */
#define	IGR_HR_SELECT		0x208C	/* 32 bit	Ingress Write Select for
									 *			H-Store Register
									 */
#define	IGR_HR_WRDATA		0x2090	/* 32 bit	Ingress Header Write Data
									 *			Register
									 */
#define	CFG_ILU_GEN			0x2094	/*  8 bit	cfg_ilu_gen */
#define	CFG_IMPLICIT_SCI0	0x2098	/* 32 bit	Implicit SCI Register 0 */
#define	CFG_IMPLICIT_SCI1	0x209C	/* 32 bit	Implicit SCI Register 1 */
#define	CFG_IMPLICIT_SCI2	0x20A0	/* 32 bit	Implicit SCI Register 2 */
#define	CFG_IMPLICIT_SCI3	0x20A4	/* 32 bit	Implicit SCI Register 3 */
#define	CFG_IMPLICIT_SCI4	0x20A8	/* 32 bit	Implicit SCI Register 4 */
#define	CFG_IMPLICIT_SCI5	0x20AC	/* 32 bit	Implicit SCI Register 5 */
#define	CFG_IMPLICIT_SCI6	0x20B0	/* 32 bit	Implicit SCI Register 6 */
#define	CFG_IMPLICIT_SCI7	0x20B4	/* 32 bit	Implicit SCI Register 7 */
#define	CFG_REPLAY_WINDOW0	0x20B8	/* 32 bit	Replay Window Register 0 */
#define	CFG_REPLAY_WINDOW1	0x20BC	/* 32 bit	Replay Window Register 1 */
#define	CFG_REPLAY_WINDOW2	0x20C0	/* 32 bit	Replay Window Register 2 */
#define	CFG_REPLAY_WINDOW3	0x20C4	/* 32 bit	Replay Window Register 3 */
#define	CFG_IPR_GEN			0x20C8	/* 32 bit	Ingress Primary Parser Register */
#define	CFG_ISC_GEN			0x20CC	/* 32 bit	Ingress Security Check Block
									 *			Register
									 */
#define	CFG_RPY_ADDR		0x20D0	/* 32 bit	Replay Protect Table Access
									 *			Register
									 */
#define	CFG_RPY_DATA		0x20D4	/* 32 bit	ELU Context Data Register */
#define	CFG_ILUT_ADDR		0x20E0	/* 32 bit	Ingress Lookup Table Access
									 *			Address Configuration Register
									 */
#define	CFG_ILUT_DATA		0x20E4	/* 32 bit	ILU Table Data Register */
#define	STAT_ADDR			0x20E8	/* 32 bit	Statistic Register Address */
#define	STAT_DATA0			0x20EC	/* 32 bit	Statistic Data Register 0 */
#define	STAT_DATA1			0x20F0	/* 32 bit	Statistic Data Register 1 */
#define	STAT_DATA2			0x20F4	/* 32 bit	Statistic Data Register 2 */
#define	CFG_OVER_LEN1		0x20F8	/* 32 bit	Over-Length Configuration
									 *			Register 1
									 */
#define	CNT_TX_ERR			0x2100	/* 32 bit	MACSec TX Processing Error Count */
#define	CFG_IPAR_HYST		0x2104	/* 32 bit	Ingress Parse FIFO Hysteresis */
#define	CFG_EPAR_HYST		0x2108	/* 32 bit	Egress Parse FIFO Hysteresis */
#define	RE_TRF_TCTL			0x2200	/* 32 bit	MACSec Retransmit FIFO Control */
#define	RE_TRF_PCNT			0x2204	/* 32 bit	Retransmit FIFO Packet Counter */
#define	RE_TRF_TTH			0x2208	/* 32 bit	Retransmit FIFO Transmit Start
									 *			Threshold
									 */
#define	RE_TRF_WPTR			0x2210	/* 32 bit	Retransmit FIFO Write Pointer
									 *			Register
									 */
#define	RE_TRF_WLEV			0x2218	/* 32 bit	Retransmit FIFO Write Level
									 *			Register
									 */
#define	RE_TRF_RPTR			0x2220	/* 32 bit	Retransmit FIFO Read Pointer
									 *			Register
									 */
#define	RE_TRF_RES_PTR		0x2224	/* 32 bit	Transmit FIFO Restart Pointer
									 *			Register
									 */
#define	RE_TRF_RLEV			0x2228	/* 32 bit	Retransmit FIFO Read Level
									 *			Register
									 */
#define	RE_TRF_RSPTR		0x222c	/* 32 bit	Retransmit FIFO Read Shadow
									 *			Level Register
									 */

/*
 *
 *	THE BIT DEFINES
 *
 */
/*	GLB_RAP				0x0000	Register Address Port (RAP) Register */
/*		Bit(s) GLB_RAP_RSRV_31_7 reserved */
#define	GLB_RAP_MSK					SHIFT0(0x7f)		/* RAP */
#define	GLB_RAP_BASE				0

/*	GLB_CSR				0x0004	Control/Status Register */
/*		Bit(s) GLB_CSR_RSRV_23_18 reserved */
#define	GLB_CSR_VMAIN_AVL			BIT_17			/* Vmain Available */
#define	GLB_CSR_VAUX_AVL			BIT_16			/* Vaux Available */
#define	GLB_CSR_RUN_PIG_ENA			BIT_15S			/* Run_PiG_Enable */
#define	GLB_CSR_RUN_PIG_DIS			BIT_14S			/* Run_PiG_Disable */
#define	GLB_CSR_ASF_ENA_SET			BIT_13S			/* ASF Enable Set */
#define	GLB_CSR_ASF_ENA_CLR			BIT_12S			/* ASF Enable Clear */
/*		Bit(s) GLB_CSR_RSRV_11 reserved */
/*		Bit(s) GLB_CSR_RSRV_10 reserved */
#define	GLB_CSR_LED0_ON				BIT_9S			/* LED<0>On */
#define	GLB_CSR_LED0_OFF			BIT_8S			/* LED<0>Off */
#define	GLB_CSR_IRQ_SW_SET			BIT_7S			/* Set IRQ SW */
#define	GLB_CSR_IRQ_SW_CLR			BIT_6S			/* Clear IRQ SW */
#define	GLB_CSR_STOP_MST_DONE		BIT_5S			/* Stop Master Done */
#define	GLB_CSR_STOP_MST			BIT_4S			/* Stop Master */
#define	GLB_CSR_MST_RST_CLR			BIT_3S			/* Master Reset Clear */
#define	GLB_CSR_MST_RST_SET			BIT_2S			/* Master Reset Set */
#define	GLB_CSR_SW_RST_CLR			BIT_1S			/* SW Reset Clear */
#define	GLB_CSR_SW_RST_SET			BIT_0S			/* SW Reset Set */

/*	GLB_PCTRL			0x0007	Power Control Register */
#define	GLB_PCTRL_SW_VAUX_ENA		BIT_7S	/* Switch Vaux Enable */
#define	GLB_PCTRL_SW_VAUX_DIS		BIT_6S	/* Switch Vaux Disable */
#define	GLB_PCTRL_SW_VCC_ENA		BIT_5S	/* Switch VCC Enable */
#define	GLB_PCTRL_SW_VCC_DIS		BIT_4S	/* Switch VCC Disable */
#define	GLB_PCTRL_SW_VAUX_ON		BIT_3S	/* Switch Vaux On */
#define	GLB_PCTRL_SW_VAUX_OFF		BIT_2S	/* Switch Vaux Off */
#define	GLB_PCTRL_SW_VCC_ON			BIT_1S	/* Switch VCC On */
#define	GLB_PCTRL_SW_VCC_OFF		BIT_0S	/* Switch VCC Off */

/*	GLB_ISRC			0x0008	Interrupt Source Register */
#define	GLB_ISRC_HW_IRQ				BIT_31			/* HW Interrupt */
#define	GLB_ISRC_STAT_BMU			BIT_30			/* Status BMU */
#define	GLB_ISRC_CPU_HOST			BIT_29			/* CPU to Host */
#define	GLB_ISRC_CPU_TO				BIT_28			/* CPU Timeout */
#define	GLB_ISRC_POLL_CHK			BIT_27			/* IRQ Polling CHK */
#define	GLB_ISRC_TWSI_RDY			BIT_26			/* IRQ TWSI Ready */
#define	GLB_ISRC_SW					BIT_25			/* IRQ SW */
#define	GLB_ISRC_TIM				BIT_24			/* IRQ Timer */
/*		Bit(s) GLB_ISRC_RSRV_23_8 reserved */
/*		Bit(s) GLB_ISRC_RSRV_7_5 reserved */
#define	GLB_ISRC_PHY				BIT_4			/* IRQ PHY */
#define	GLB_ISRC_MAC				BIT_3			/* IRQ MAC */
#define	GLB_ISRC_CHK_RX				BIT_2			/* IRQ CHCK Rx */
/*		Bit(s) GLB_ISRC_RSRV_1 reserved */
#define	GLB_ISRC_CHK_TXA			BIT_0			/* IRQ CHCK TxA */

/*	GLB_IMSK			0x000C	Interrupt Mask Register */
#define	GLB_IMSK_HW_IRQ				BIT_31			/* En IRQ HW Interrupt */
#define	GLB_IMSK_STAT_BMU			BIT_30			/* En IRQ Status BMU */
#define	GLB_IMSK_CPU_HOST			BIT_29			/* En CPU to Host */
#define	GLB_IMSK_CPU_TO				BIT_28			/* En CPU Timeout */
#define	GLB_IMSK_POLL_CHK			BIT_27			/* En IRQ Polling CHK */
#define	GLB_IMSK_TWSI_RDY			BIT_26			/* En IRQ TWSI Ready */
#define	GLB_IMSK_SW					BIT_25			/* En IRQ SW */
#define	GLB_IMSK_TIM				BIT_24			/* En IRQ Timer */
/*		Bit(s) GLB_IMSK_RSRV_23_8 reserved */
/*		Bit(s) GLB_IMSK_RSRV_7_5 reserved */
#define	GLB_IMSK_PHY				BIT_4			/* En IRQ PHY */
#define	GLB_IMSK_MAC				BIT_3			/* En IRQ MAC */
#define	GLB_IMSK_CHK_RX				BIT_2			/* En IRQ CHCK Rx */
/*		Bit(s) GLB_IMSK_RSRV_1 reserved */
#define	GLB_IMSK_CHK_TXA			BIT_0			/* En IRQ CHCK TxA */

/*	GLB_ISRC_HW			0x0010	Interrupt HW Error Source Register */
/*		Bit(s) GLB_ISRC_HW_RSRV_31_30 reserved */
/* IRQ Timestamp Timer Overflow */
#define	GLB_ISRC_HW_TSP_TIM				BIT_29			
#define	GLB_ISRC_HW_SEN					BIT_28			/* IRQ Sensor */
#define	GLB_ISRC_HW_MST_ERR				BIT_27			/* IRQ Master Error */
#define	GLB_ISRC_HW_PCI_STAT			BIT_26			/* IRQ Status */
#define	GLB_ISRC_HW_PCIE_SPE			BIT_25			/* IRQ PE */
#define	GLB_ISRC_HW_PCIE_NO_PE			BIT_24			/* IRQ NO PE */
/*		Bit(s) GLB_ISRC_HW_RSRV_23_8 reserved */
/*		Bit(s) GLB_ISRC_HW_RSRV_7_4 reserved */
#define	GLB_ISRC_HW_PAR_MAC				BIT_3			/* IRQ Par MAC */
#define	GLB_ISRC_HW_PAR_RX				BIT_2			/* IRQ PAR Rx */
/*		Bit(s) GLB_ISRC_HW_RSRV_1 reserved */
#define	GLB_ISRC_HW_TCP_TXA				BIT_0			/* IRQ TCP Length TxA1 */

/*	GLB_IMSK_HW			0x0014	Interrupt HW Error Mask Register */
/*		Bit(s) GLB_IMSK_HW_RSRV_31_30 reserved */
/* En IRQ Timestamp Timer Overflow */
#define	GLB_IMSK_HW_TSP_TIM				BIT_29			
#define	GLB_IMSK_HW_SEN					BIT_28			/* En IRQ Sensor */
#define	GLB_IMSK_HW_MST_ERR				BIT_27			/* En IRQ Master Error */
#define	GLB_IMSK_HW_PCI_STAT			BIT_26			/* En IRQ Status */
#define	GLB_IMSK_HW_PCIE_SPE			BIT_25			/* En IRQ PE */
#define	GLB_IMSK_HW_PCIE_NO_PE			BIT_24			/* En IRQ NO PE */
/*		Bit(s) GLB_IMSK_HW_RSRV_23_8 reserved */
/*		Bit(s) GLB_IMSK_HW_RSRV_7_4 reserved */
#define	GLB_IMSK_HW_PAR_MAC				BIT_3			/* En IRQ Par MAC */
#define	GLB_IMSK_HW_PAR_RX				BIT_2			/* En IRQ PAR Rx */
/*		Bit(s) GLB_IMSK_HW_RSRV_1 reserved */
#define	GLB_IMSK_HW_TCP_TXA				BIT_0			/* En IRQ TCP Length TxA1 */

/*	GLB_ISRC_SP1		0x0018	Special Interrupt Source Register 1 */
#define	GLB_ISRC_SP1__IRQ_XXX_MSK		SHIFT0(0xffffffff)	/* IRQ xxx */
#define	GLB_ISRC_SP1__IRQ_XXX_BASE		0

/*	GLB_ISRC_SP2		0x001C	Special Interrupt Source Register 2 */
#define	GLB_ISRC_SP2__IRQ_XXX_MSK		SHIFT0(0xffffffff)	/* IRQ xxx */
#define	GLB_ISRC_SP2__IRQ_XXX_BASE		0

/*	GLB_ISRC_SP3		0x0020	Special Interrupt Source Register 3 */
#define	GLB_ISRC_SP3__IRQ_XXX_MSK		SHIFT0(0xffffffff)	/* IRQ xxx */
#define	GLB_ISRC_SP3__IRQ_XXX_BASE		0

/*	GLB_EISR			0x0024	Enter Interrupt Service Routine Register */
#define	GLB_EISR__IRQ_XXX_MSK		SHIFT0(0xffffffff)	/* Enter ISR Reg */
#define	GLB_EISR__IRQ_XXX_BASE		0

/*	GLB_LISR			0x0028	Leave Interrupt Service Routine Register */
#define	GLB_LISR__IRQ_XXX_MSK		SHIFT0(0xffffffff)	/* Leave ISR Reg */
#define	GLB_LISR__IRQ_XXX_BASE		0

/*	GLB_ICTRL			0x002C	Interrupt Control Register */
/*		Bit(s) GLB_ICTRL_RSRV_31_4 reserved */
#define	GLB_ICTRL_ISR_MSK				BIT_3				/* isr_mask */
#define	GLB_ICTRL_ISR_STAT				BIT_2				/* isr_status */
#define	GLB_ICTRL_LEAVE_ISR				BIT_1				/* Leave ISR */
#define	GLB_ICTRL_ENTER_ISR				BIT_0				/* Enter ISR */

/*	SPI_CTRL			0x0060	SPI Flash Memory Control Register */
#define	SPI_CTRL_STRT_LDR			BIT_31			/* Loader Start */
#define	SPI_CTRL_BSY				BIT_30			/* SPI Busy */
#define	SPI_CTRL_RESV				BIT_29			/* RESV */
#define	SPI_CTRL_RD_ID_PROT			BIT_28			/* RD ID Protocol */
/*		Bit(s) SPI_CTRL_RSRV_7_0 reserved */
#define	SPI_CTRL_STRT_SPI			BIT_19			/* Start SPI */
#define	SPI_CTRL_INST_MSK			SHIFT16(0x7)	/* Instruction */
#define	SPI_CTRL_INST_BASE			BIT_16
/*		Bit(s) SPI_CTRL_RSRV_7_0 reserved */
#define	SPI_CTRL_STAT_MSK			SHIFT0(0xff)	/* SPI device Status */
#define	SPI_CTRL_STAT_BASE			BIT_0

/*	SPI_ADDR			0x0064	SPI Flash Memory Address Register */
/*		Bit(s) SPI_ADDR_RSRV_11_0 reserved */
#define	SPI_ADDR_MSK				SHIFT0(0xfffff)	/* SPI Flash Memory address */
#define	SPI_ADDR_BASE				BIT_0

/*	SPI_DATA			0x0068	SPI Flash Memory Data Register */
#define	SPI_DATA_MSK		SHIFT0(0xffffffff)	/* SPI Flash Memory data */
#define	SPI_DATA_BASE		BIT_0

/*	SPI_ID				0x006C	SPI Flash Memory Vendor/Device ID Register */
/*		Bit(s) SPI_ID_RSRV_15_0 reserved */
#define	SPI_ID_VEN_ID_MSK			SHIFT8(0xff)	/* Vendor-ID */
#define	SPI_ID_VEN_ID_BASE			BIT_8
#define	SPI_ID_DEV_ID_MSK			SHIFT0(0xff)	/* Device-ID */
#define	SPI_ID_DEV_ID_BASE			BIT_0

/*	SPI_LCFG			0x0070	SPI Flash Memory Loader Configuration Register */
/*		Bit(s) SPI_LCFG_RSRV_3_0 reserved */
#define	SPI_LCFG_NRML_ADDR_MSK		SHIFT16(0xfff)	/* Normal Loader start address */
#define	SPI_LCFG_NRML_ADDR_BASE		BIT_16
/*		Bit(s) SPI_LCFG_RSRV_3_0 reserved */
#define	SPI_LCFG_INIT_ADDR_MSK		SHIFT0(0xfff)	/* PIG Loader start address */
#define	SPI_LCFG_INIT_ADDR_BASE		BIT_0

/*	SPI_CFG				0x0074	SPI Flash Memory Configuration Register */
/*		Bit(s) SPI_CFG_RSRV_30_0 reserved */
#define	SPI_CFG_A17_GATE			BIT_0				/* A17 Gate */

/*	SPI_OPC1			0x0078	SPI Flash Memory Opcode 1 Register */
#define	SPI_OPC1_RDSR_MSK		SHIFT24(0xff)	/* Opcode Read Status */
#define	SPI_OPC1_RDSR_BASE		BIT_24
#define	SPI_OPC1_RDID_MSK		SHIFT16(0xff)	/* Opcode Read ID */
#define	SPI_OPC1_RDID_BASE		BIT_16
#define	SPI_OPC1_RD_MSK			SHIFT8(0xff)	/* Opcode Read */
#define	SPI_OPC1_RD_BASE		BIT_8
#define	SPI_OPC1_NOP_MSK		SHIFT0(0xff)	/* Opcode No Operation */
#define	SPI_OPC1_NOP_BASE		BIT_0

/*	SPI_OPC2			0x007C	SPI Flash Memory Opcode 2 Register */
#define	SPI_OPC2_CE_MSK			SHIFT24(0xff)	/* Opcode Chip Erase */
#define	SPI_OPC2_CE_BASE		BIT_24
#define	SPI_OPC2_SE_MSK			SHIFT16(0xff)	/* Opcode Sector Erase */
#define	SPI_OPC2_SE_BASE		BIT_16
#define	SPI_OPC2_WR_MSK			SHIFT8(0xff)	/* Opcode Write */
#define	SPI_OPC2_WR_BASE		BIT_8
#define	SPI_OPC2_WREN_MSK		SHIFT0(0xff)	/* Opcode Write Enable */
#define	SPI_OPC2_WREN_BASE		BIT_0

/*	GLB_BWIN			0x0080	Block Window Register */
#define	GLB_BWIN_MSK		SHIFT0(0xffffffff)	/* Mapped register XY */
#define	GLB_BWIN_BASE		0

/*	L1_CFG_MADDR_Hi		0x0100	Link1 MAC Address Register High */
#define	CFG_MADDR_HI_VAL_3_MSK		SHIFT24(0xff)	/* MAC Addr_x<3> */
#define	CFG_MADDR_HI_VAL_3_BASE		24
#define	CFG_MADDR_HI_VAL_2_MSK		SHIFT16(0xff)	/* MAC Addr_x<2> */
#define	CFG_MADDR_HI_VAL_2_BASE		16
#define	CFG_MADDR_HI_VAL_1_MSK		SHIFT8(0xff)	/* MAC Addr_x<1> */
#define	CFG_MADDR_HI_VAL_1_BASE		8
#define	CFG_MADDR_HI_VAL_0_MSK		SHIFT0(0xff)	/* MAC Addr_x<0> */
#define	CFG_MADDR_HI_VAL_0_BASE		0

/*	L1_CFG_MADDR_LO		0x0104	Link1 MAC Address Register Low */
/*		Bit(s) CFG_MADDR_LO_RSRV_31_16 reserved */
#define	CFG_MADDR_LO_VAL_5_MSK				SHIFT8(0xff)	/* MAC Addr_x<5> */
#define	CFG_MADDR_LO_VAL_5_BASE				8
#define	CFG_MADDR_LO_VAL_4_MSK				SHIFT0(0xff)	/* MAC Addr_x<4> */
#define	CFG_MADDR_LO_VAL_4_BASE				0

/*	CFG_IF				0x0118	Interface Type Register (PMD Type and
 *								Connector Type)
 */
#define	CFG_IF_PMD_MSK			SHIFT8(0xffU)	/* PMD */
#define	CFG_IF_PMD_BASE			8
#define	CFG_IF_CONN_MSK			SHIFT0(0xffU)	/* Connector */
#define	CFG_IF_CONN_BASE		0

/*	CFG_CREV			0x011A	Chip Revision Register */
#define	CFG_CREV_MSK				SHIFT4(0xfU)	/* Chip Revision */
#define	CFG_CREV_BASE				4
#define	CFG_CREV_HID_ID_MSK			SHIFT0(0xfU)	/* Hidden ID */
#define	CFG_CREV_HID_ID_BASE		0

/*	CFG_CID				0x011B	Chip ID Register */
#define	CFG_CID_MSK			SHIFT0(0xffU)	/* Chip ID */
#define	CFG_CID_BASE		0

/*	CFG_CGATE			0x011C	Clock Gating Register */
/*		Bit(s) CFG_CGATE_RSRV_15 reserved */
/*		Bit(s) CFG_CGATE_RSRV_14_12 reserved */
/*		Bit(s) CFG_CGATE_RSRV_11 reserved */
#define	CFG_CGATE_DIS_MAC			BIT_10S			/* Disable PHY/MAC Link */
#define	CFG_CGATE_CIS_CORE			BIT_9S			/* Disable core_clk Link */
#define	CFG_CGATE_DIS_PCI			BIT_8S			/* Disable pci_clk Link */
/*		Bit(s) CFG_CGATE_RSRV_7_0 reserved */

/*	CFG_AIR2			0x011E	Application Information Register 2 */
/*		Bit(s) CFG_AIR2_RSRV_7_0 reserved */

/*	CFG_AIR1			0x011F	Application Information Register 1 */
/*		Bit(s) CFG_AIR1_RSRV_7_0 reserved */

/*	CFG_CDIV			0x0120	Clock Divider Register */
/*		Bit(s) CFG_CDIV_RSRV_31_24 reserved */
#define	CFG_CDIV_MSK					SHIFT16(0xff)	/* Clock Div Value */
#define	CFG_CDIV_BASE					16
/*		Bit(s) CFG_CDIV_RSRV_15_2 reserved */
#define	CFG_CDIV_ENA					BIT_1			/* Clock Div Enable */
#define	CFG_CDIV_DIS					BIT_0			/* Clock Div Disable */

/*	IRQ_TIM_INIT		0x0130	Timer Init Value Register */
#define	IRQ_TIM_INIT_MSK		SHIFT0(0xffffffff)	/* Timer Init Value */
#define	IRQ_TIM_INIT_BASE		0

/*	IRQ_TIM_CNT			0x0134	Timer Register */
#define	IRQ_TIM_CNT_MSK			SHIFT0(0xffffffff)	/* Timer */
#define	IRQ_TIM_CNT_BASE		0

/*	IRQ_TIM_TCTRL		0x0138	Timer Control/Test Register */
/*		Bit(s) IRQ_TIM_TCTRL_RSRV_31_16 reserved */
/*		Bit(s) IRQ_TIM_TCTRL_RSRV_15_11 reserved */
#define	IRQ_TIM_TCTRL_ON					BIT_10			/* Timer Test On */
#define	IRQ_TIM_TCTRL_OFF					BIT_9			/* Timer Test Off */
#define	IRQ_TIM_TCTRL_STEP					BIT_8			/* Timer Step */
/*		Bit(s) IRQ_TIM_TCTRL_RSRV_7_3 reserved */
#define	IRQ_TIM_TCTRL_STRT					BIT_2			/* Timer Start */
#define	IRQ_TIM_TCTRL_STOP					BIT_1			/* Timer Stop */
#define	IRQ_TIM_TCTRL_CLR_IRQ				BIT_0			/* Timer Clear IRQ */

/*	MOD_TIM_INIT		0x0140	IRQ Moderation Timer Init Value Register */
/* IRQ Moderation Timer Init Value */
#define	MOD_TIM_INIT_MSK		SHIFT0(0xffffffff)	
#define	MOD_TIM_INIT_BASE		0

/*	MOD_TIM_CNT			0x0144	IRQ Moderation Timer Register */
#define	MOD_TIM_CNT_MSK			SHIFT0(0xffffffff)	/* IRQ Moderation Timer */
#define	MOD_TIM_CNT_BASE		0

/*	MOD_TIM_TCTRL		0x0148	IRQ Moderation Timer Control/Test Register */
/*		Bit(s) MOD_TIM_TCTRL_RSRV_31_16 reserved */
/*		Bit(s) MOD_TIM_TCTRL_RSRV_15_11 reserved */
#define	MOD_TIM_TCTRL_ON					BIT_10			/* IM Timer Test On */
#define	MOD_TIM_TCTRL_OFF					BIT_9			/* IM Timer Test Off */
#define	MOD_TIM_TCTRL_STEP					BIT_8			/* IM Timer Step */
/*		Bit(s) MOD_TIM_TCTRL_RSRV_7_3 reserved */
#define	MOD_TIM_TCTRL_STRT					BIT_2			/* IM Timer Start */
#define	MOD_TIM_TCTRL_STOP					BIT_1			/* IM Timer Stop */
/*		Bit(s) MOD_TIM_TCTRL_RSRV_0 reserved */

/*	MOD_TIM_MSK			0x014C	Interrupt Moderation Mask Register */
/* En Mod IRQ xxx */
#define	MOD_TIM_MSK_EN_MOD_IRQ_XXX_MSK			SHIFT0(0xffffffff)	
#define	MOD_TIM_BASE_EN_MOD_IRQ_XXX_BASE		0

/*	MOD_TIM_MSK_HW		0x0150	Interrupt Hardware Error Moderation Mask
 *								Register
 */
/* En Mod IRQ xxx */
#define	MOD_TIM_MSK_HW_EN_MOD_IRQ_XXX_MSK		SHIFT0(0xffffffff)	
#define	MOD_TIM_BASE_HW_EN_MOD_IRQ_XXX_BASE		0

/*	GLB_TCTRL			0x0158	Test Control Register 1 */
#define	GLB_TCTRL_BMU_TX_FIFO_RTC			BIT_31	/* BMU TX FIFO RTC */
#define	GLB_TCTRL_BMU_TX_FIFO_WTC			BIT_30	/* BMU TX FIFO WTC */
#define	GLB_TCTRL_ASF_FIFO_RTC				BIT_29	/* ASF FIFO RTC */
#define	GLB_TCTRL_ASF_FIFO_WTC				BIT_28	/* ASF FIFO WTC */
/* Yukon Fe+ */
#define	GLB_TCTRL_PWR_BDGT_FIFO_RTC			BIT_29	/* PWR_BDGT FIFO RTC */
#define	GLB_TCTRL_PWR_BDGT_FIFO_WTC			BIT_28	/* PWR_BDGT FIFO WTC */
/* Yukon Fe+ end */
#define	GLB_TCTRL_PCIE_MAC_TX_FIFO_RTC		BIT_27	/* PCIE MAC Tx FIFO RTC */
#define	GLB_TCTRL_PCIE_MAC_TX_FIFO_WTC		BIT_26	/* PCIE MAC Tx FIFO WTC */
#define	GLB_TCTRL_PCIE_MAC_RX_FIFO_RTC		BIT_25	/* PCIE MAC Rx FIFO RTC */
#define	GLB_TCTRL_PCIE_MAC_RX_FIFO_WTC		BIT_24	/* PCIE MAC Rx FIFO WTC */
#define	GLB_TCTRL_PEX_TL_RX_FIFO_RTC		BIT_23	/* Pex Tl Rx FIFO RTC */
#define	GLB_TCTRL_PEX_TL_RX_FIFO_WTC		BIT_22	/* Pex Tl Rx FIFO WTC */
#define	GLB_TCTRL_PEX_TL_TX_FIFO_RTC		BIT_21	/* Pex Tl Tx FIFO RTC */
#define	GLB_TCTRL_PEX_TL_TX_FIFO_WTC		BIT_20	/* Pex Tl Tx FIFO WTC */
#define	GLB_TCTRL_WOL_RAM_RTC				BIT_19	/* WOL RAM RTC */
#define	GLB_TCTRL_WOL_RAM_WTC				BIT_18	/* WOL RAM WTC */
#define	GLB_TCTRL_RMON_RAM_RTC				BIT_17	/* RMON RAM RTC */
#define	GLB_TCTRL_RMON_RAM_WTC				BIT_16	/* RMON RAM WTC */
#define	GLB_TCTRL_PFU_STAT_RTC				BIT_15	/* PFU Status RTC */
#define	GLB_TCTRL_PFU_STAT_WTC				BIT_14	/* PFU Status WTC */
#define	GLB_TCTRL_PFU_AQ_FIFO_RTC			BIT_13	/* PFU Aq FIFO RTC */
#define	GLB_TCTRL_PFU_AQ_FIFO_WTC			BIT_12	/* PFU Aq FIFO WTC */
#define	GLB_TCTRL_PFU_RQ_FIFO_RTC			BIT_11	/* PFU Rq FIFO RTC */
#define	GLB_TCTRL_PFU_RQ_FIFO_WTC			BIT_10	/* PFU Rq FIFO WTC */
#define	GLB_TCTRL_MAC_RX_FIFO_RTC			BIT_9	/* MAC Rx FIFO RTC */
/*		Bit(s) GLB_TCTRL_RSRV_8 reserved */
/*		Bit(s) GLB_TCTRL_RSRV_7 reserved */
#define	GLB_TCTRL_MAC_RX_FIFO_WTC			BIT_6	/* MAC Rx FIFO WTC */
/*		Bit(s) GLB_TCTRL_RSRV_5 reserved */
#define	GLB_TCTRL_MAC_TX_FIFO_RTC			BIT_4	/* MAC Tx FIFO RTC */
/*		Bit(s) GLB_TCTRL_RSRV_3 reserved */
#define	GLB_TCTRL_MAC_TX_FIFO_WTC			BIT_2	/* MAC Tx FIFO WTC */
#define	GLB_TCTRL_EN_CFG_WR_ON				BIT_1	/* En Config Write On */
#define	GLB_TCTRL_EN_CFG_WR_OFF				BIT_0	/* En Config Write Off */

/*	GLB_GPIO			0x015C	General Purpose I/O Register */
#define	GLB_GPIO_CLK_DEB_ENA			BIT_31			/* Clock Debug Enable */
/*		Bit(s) GLB_GPIO_RSRV_30 reserved */
#define	GLB_GPIO_CLK_DBG_MSK			SHIFT26(0xf)	/* Clock Debug */
#define	GLB_GPIO_CLK_DBG_BASE			26
/*		Bit(s) GLB_GPIO_RSRV_25_16 reserved */
/* Disable Internal Reset After D3 to D0 */
#define	GLB_GPIO_INT_RST_D3_DIS			BIT_15			
#define	GLB_GPIO_LED_PAD_SPEED_UP		BIT_14			/* LED PAD Speed Up */
#define	GLB_GPIO_STAT_RACE_DIS			BIT_13			/* Status Race Enable */
#define	GLB_GPIO_TEST_SEL_MSK			SHIFT11(0x3)	/* Testmode Select */
#define	GLB_GPIO_TEST_SEL_BASE			11
#define	GLB_GPIO_RAND_ENA				BIT_10			/* Random Enable */
#define	GLB_GPIO_RAND_BIT_1				BIT_9			/* Random Bit 1 */
/*		Bit(s) GLB_GPIO_RSRV_8_0 reserved */

/*	TWSI_CTRL			0x0160	TWSI (HW) Control Register */
#define	TWSI_CTRL_FLAG				BIT_31			/* Flag */
#define	TWSI_CTRL_ADDR_MSK			SHIFT16(0x7fff)	/* TWSI Address */
#define	TWSI_CTRL_ADDR_BASE			BIT_16
#define	TWSI_CTRL_DEVSEL_MSK		SHIFT9(0x7f)	/* TWSI Devsel */
#define	TWSI_CTRL_DEVSEL_BASE		BIT_9
/*		Bit(s) TWSI_CTRL_RSRV_3_0 reserved */
#define	TWSI_CTRL_BURST_ENA			BIT_4			/* TWSI Burst */
#define	TWSI_CTRL_DEVSIZE_MSK		SHIFT1(0x7)		/* TWSI Device Size */
#define	TWSI_CTRL_DEVSIZE_BASE		BIT_1
#define	TWSI_CTRL_STOP				BIT_0			/* TWSI Stop */

/*	TWSI_DATA			0x0164	TWSI (HW) Data Register */
#define	TWSI_DATA_MSK		SHIFT0(0xffffffff)	/* TWSI Data */
#define	TWSI_DATA_BASE		BIT_0

/*	TWSI_IRQ			0x0168	TWSI (HW) IRQ Register */
/*		Bit(s) TWSI_IRQ_RSRV_30_0 reserved */
#define	TWSI_IRQ_CLR_IRQ			BIT_0				/* Clear IRQ TWSI */

/*	TWSI_SW				0x016C	TWSI (SW) Register */
/*		Bit(s) TWSI_SW_RSRV_28_0 reserved */
#define	TWSI_SW_DIR					BIT_2				/* TWSI Data Dir */
#define	TWSI_SW_DATA				BIT_1				/* TWSI Data */
#define	TWSI_SW_CLK					BIT_0				/* TWSI Clock */

/*	PCIE_PHY			0x0170	PCI Express PHY Address Register */
#define	PCIE_PHY_RW				BIT_31			/* PEX PHY Access Mode */
#define	PCIE_PHY_REGFILE		BIT_30			/* PEX PHY regfile */
#define	PCIE_PHY_ADDR_MSK		SHIFT16(0x3fff)	/* PEX PHY Address */
#define	PCIE_PHY_ADDR_BASE		16
#define	PCIE_PHY_DATA_MSK		SHIFT0(0xffff)	/* PEX PHY Data */
#define	PCIE_PHY_DATA_BASE		0

/*	RAM_ADDR			0x0180	RAM Address Register */
#define	RAM_ADDR_SEL_MSK			SHIFT30(0x3)	/* RAM Select */
#define	RAM_ADDR_SEL_BASE			30
#define	RAM_ADDR_ADDR_MUX			BIT_29			/* RAM Address Mux */
/*		Bit(s) RAM_ADDR_RSRV_28_9 reserved */
#define	RAM_ADDR_MSK				SHIFT0(0x1ff)	/* RAM Address */
#define	RAM_ADDR_BASE				0

/*	RAM_DATA_LO			0x0184	Data Port/Lower Dword Register */
#define	RAM_DATA_LO_MSK			SHIFT0(0xffffffff)	/* Data Port/lower dword */
#define	RAM_DATA_LO_BASE		0

/*	RAM_DATA_HI			0x0188	Data Port/Upper Dword Register */
#define	RAM_DATA_HI_MSK			SHIFT0(0xffffffff)	/* Data Port/upper dword */
#define	RAM_DATA_HI_BASE		BIT_0

/*	ASF_TO				0x0190	Timeout Register */
#define	ASF_TO_ASF_TO3_MSK		SHIFT24(0xff)	/* Timeout Value 3 */
#define	ASF_TO_ASF_TO3_BASE		BIT_24
#define	ASF_TO_ASF_TO2_MSK		SHIFT16(0xff)	/* Timeout Value 2 */
#define	ASF_TO_ASF_TO2_BASE		BIT_16
#define	ASF_TO_ASF_TO1_MSK		SHIFT8(0xff)	/* Timeout Value 1 */
#define	ASF_TO_ASF_TO1_BASE		BIT_8
#define	ASF_TO_ASF_TO0_MSK		SHIFT0(0xff)	/* Timeout Value 0 */
#define	ASF_TO_ASF_TO0_BASE		BIT_0

/*	ASF_CTRL			0x01A0	FIFO Interface Control */
/*		Bit(s) ASF_CTRL_RSRV_29_0 reserved */
#define	ASF_CTRL_ASF_ENA			BIT_1				/* Reset Clear */
#define	ASF_CTRL_ASF_RST			BIT_0				/* Reset Set */

/*	RSS_KEY0			0x0220	RSS Key 0 Register */
#define	RSS_KEY0_MSK		SHIFT0(0xffffffff)	/* RSS Key0 */
#define	RSS_KEY0_BASE		0

/*	RSS_KEY1			0x0224	RSS Key 1 Register */
#define	RSS_KEY1_MSK		SHIFT0(0xffffffff)	/* RSS Key1 */
#define	RSS_KEY1_BASE		0

/*	RSS_KEY2			0x0228	RSS Key 2 Register */
#define	RSS_KEY2_MSK		SHIFT0(0xffffffff)	/* RSS Key2 */
#define	RSS_KEY2_BASE		0

/*	RSS_KEY3			0x022C	RSS Key 3 Register */
#define	RSS_KEY3_MSK		SHIFT0(0xffffffff)	/* RSS Key3 */
#define	RSS_KEY3_BASE		0

/*	RSS_KEY4			0x0230	RSS Key 4 Register */
#define	RSS_KEY4_MSK		SHIFT0(0xffffffff)	/* RSS Key4 */
#define	RSS_KEY4_BASE		0

/*	RSS_KEY5			0x0234	RSS Key 5 Register */
#define	RSS_KEY5_MSK		SHIFT0(0xffffffff)	/* RSS Key5 */
#define	RSS_KEY5_BASE		0

/*	RSS_KEY6			0x0238	RSS Key 6 Register */
#define	RSS_KEY6_MSK		SHIFT0(0xffffffff)	/* RSS Key6 */
#define	RSS_KEY6_BASE		0

/*	RSS_KEY7			0x023C	RSS Key 7 Register */
#define	RSS_KEY7_MSK		SHIFT0(0xffffffff)	/* RSS Key7 */
#define	RSS_KEY7_BASE		0

/*	RSS_KEY8			0x0240	RSS Key 8 Register */
#define	RSS_KEY8_MSK		SHIFT0(0xffffffff)	/* RSS Key8 */
#define	RSS_KEY8_BASE		0

/*	RSS_KEY9			0x0244	RSS Key 9 Register */
#define	RSS_KEY9_MSK		SHIFT0(0xffffffff)	/* RSS Key9 */
#define	RSS_KEY9_BASE		0

/*	RSS_CFG				0x0248	RSS Configuration Register */
/*		Bit(s) RSS_CFG_RSRV_31_6 reserved */
/* NDIS_HASH_TCP_IPV6_EX Control */
#define	RSS_CFG_NDIS_HASH_TCP_IPV6_EX_CTRL		BIT_5				
/* NDIS_HASH_IPV6_EX Control */
#define	RSS_CFG_NDIS_HASH_IPV6_EX_CTRL			BIT_4				
/* NDIS_HASH_TCP_IPV6 Control */
#define	RSS_CFG_NDIS_HASH_TCP_IPV6_CTRL			BIT_3				
/* NDIS_HASH_IPV6 Control */
#define	RSS_CFG_NDIS_HASH_IPV6_CTRL				BIT_2				
/* NDIS_HASH_TCP_IPV4 Control */
#define	RSS_CFG_NDIS_HASH_TCP_IPV4_CTRL			BIT_1				
/* NDIS_HASH_IPV4 Control */
#define	RSS_CFG_NDIS_HASH_IPV4_CTRL				BIT_0				

/*	RBMU_DESCR			0x0400	Current Receive Descriptor Register */
#define	RBMU_DESCR_CTRL_MSK				SHIFT16(0xffff)	/* Receive Buffer Control */
#define	RBMU_DESCR_CTRL_BASE			16
/* Receive Buffer Byte Count */
#define	RBMU_DESCR_BYTE_CNT_MSK			SHIFT0(0xffff)	
#define	RBMU_DESCR_BYTE_CNT_BASE		0

/*	RBMU_HASH			0x0404	RSS Hash Checksum Register */
#define	RBMU_HASH_MSK		SHIFT0(0xffffffff)	/* RSS Hash Checksum */
#define	RBMU_HASH_BASE		0

/*	RBMU_ADDR_HI		0x0408	Receive Buffer Address Lo Register */
#define	RBMU_ADDR_HI_MSK		SHIFT0(0xffffffff)	/* Receive Buffer Address Lo */
#define	RBMU_ADDR_HI_BASE		0

/*	RBMU_ADDR_LO		0x040C	Receive Buffer Address Hi Register */
#define	RBMU_ADDR_LO_MSK		SHIFT0(0xffffffff)	/* Receive Buffer Address Hi */
#define	RBMU_ADDR_LO_BASE		0

/*	RBMU_RFSW			0x0410	Receive Buffer Status Word Register */
#define	RBMU_RFSW_MSK		SHIFT0(0xffffffff)	/* RFSW */
#define	RBMU_RFSW_BASE		0

/*	RBMU_TSP			0x0414	Receive Timestamp Register */
#define	RBMU_TSP_MSK		SHIFT0(0xffffffff)	/* Timestamp */
#define	RBMU_TSP_BASE		0

/*	RBMU_VLAN			0x0420	VLAN Tag Register */
/*		Bit(s) RBMU_VLAN_RSRV_31_16 reserved */
#define	RBMU_VLAN_MSK					SHIFT0(0xffff)	/* VLAN Tag */
#define	RBMU_VLAN_BASE					0

/*	RBMU_DONE_IDX		0x0424	Receive Done Index Register */
/*		Bit(s) RBMU_DONE_IDX_RSRV_31_12 reserved */
#define	RBMU_DONE_IDX_MSK					SHIFT0(0xfff)		/* Done Index */
#define	RBMU_DONE_IDX_BASE					0

/*	RBMU_REQ_ADDR_LO	0x0428	Receive Request Address, Lower Register */
#define	RBMU_REQ_ADDR_LO_MSK		SHIFT0(0xffffffff)	/* Request Addr Lo */
#define	RBMU_REQ_ADDR_LO_BASE		0

/*	RBMU_REQ_ADDR_HI	0x042C	Receive Request Address, Upper Register */
#define	RBMU_REQ_ADDR_HI_MSK		SHIFT0(0xffffffff)	/* Request Addr Hi */
#define	RBMU_REQ_ADDR_HI_BASE		0

/*	RBMU_REQ_CNT		0x0430	Receive Request Byte Count Register */
/*		Bit(s) RBMU_REQ_CNT_RSRV_31_11 reserved */
/* Request Byte Count */
#define	RBMU_REQ_CNT_MSK					SHIFT0(0x7ff)		
#define	RBMU_REQ_CNT_BASE					0

/*	RBMU_CSR			0x0434	Receive BMU Control/Status Register */
#define	RBMU_CSR_IDLE					BIT_31			/* BMU Idle */
#define	RBMU_CSR_TCPUDP_CSUMOK			BIT_30			/* TCP/UDP Checksum OK */
#define	RBMU_CSR_UDP_PKT				BIT_29			/* UDP Pkt */
#define	RBMU_CSR_FRAG_PKT				BIT_28			/* Fragment Pkt */
#define	RBMU_CSR_IPV4_CSUMOK			BIT_27			/* IPv4 Checksum OK */
#define	RBMU_CSR_IPV6_PKT				BIT_26			/* IPv6 Pkt */
#define	RBMU_CSR_TCP_PKT				BIT_25			/* TCP Pkt */
#define	RBMU_CSR_IPV4_PKT				BIT_24			/* IPv4 Pkt */
/*		Bit(s) RBMU_CSR_RSRV_23_20 reserved */
/* RX Core CLock Gating Enable */
#define	RBMU_CSR_GCORECLK_ENA			BIT_19			
/* RX Core Clock Gating Disable */
#define	RBMU_CSR_GCORECLK_DIS			BIT_18			
#define	RBMU_CSR_MACSEC_LE_ENA			BIT_17			/* MACSec LE Enable */
#define	RBMU_CSR_MACSEC_LE_DIS			BIT_16			/* MACSec LE Disable */
#define	RBMU_CSR_RSS_ENA				BIT_15			/* RSS Hash Enable */
#define	RBMU_CSR_RSS_DIS				BIT_14			/* RSS Hash Disable */
#define	RBMU_CSR_CSUM_ENA				BIT_13			/* RX Checksum Enable */
#define	RBMU_CSR_CSUM_DIS				BIT_12			/* RX Checksum Disable */
#define	RBMU_CSR_CLR_IRQ_PAR			BIT_11			/* Clear IRQ Parity */
#define	RBMU_CSR_CLR_IRQ_CHK			BIT_10			/* Clear IRQ Check */
#define	RBMU_CSR_STOP_RBMU				BIT_9			/* Stop Rx BMU */
#define	RBMU_CSR_STRT_RBMU				BIT_8			/* Start Rx BMU */
#define	RBMU_CSR_FIFO_OP_ON				BIT_7			/* FIFO Operational On */
#define	RBMU_CSR_FIFO_OP_OFF			BIT_6			/* FIFO Operational Off */
#define	RBMU_CSR_FIFO_ENA				BIT_5			/* FIFO Enable */
#define	RBMU_CSR_FIFO_RST				BIT_4			/* FIFO Reset */
#define	RBMU_CSR_RBMU_OP_ON				BIT_3			/* BMU Operational On */
#define	RBMU_CSR_RBMU_OP_OFF			BIT_2			/* BMU Operational Off */
#define	RBMU_CSR_RBMU_ENA				BIT_1			/* BMU Enable */
#define	RBMU_CSR_RBMU_RST				BIT_0			/* BMU Reset */

/*	RBMU_TEST			0x0438	Receive BMU Test Register */
/*		Bit(s) RBMU_TEST_RSRV_31_25 reserved */
/* MAC Rx RAM Read Control */
#define	RBMU_TEST_MAC_RX_RAM_RD_CTRL		BIT_24			
/*		Bit(s) RBMU_TEST_RSRV_23_8 reserved */
/*		Bit(s) RBMU_TEST_RSRV_7 reserved */
/* Testmode Req Nbytes/Addr On */
#define	RBMU_TEST_TEST_REQ_NB_ON			BIT_6			
/* Testmode Req Nbytes/Addr Off */
#define	RBMU_TEST_TEST_REQ_NB_OFF			BIT_5			
/* Teststep Req Nbytes/Addr */
#define	RBMU_TEST_TESTSTEP_REQ_NB			BIT_4			
/*		Bit(s) RBMU_TEST_RSRV_3 reserved */
/* Testmode Done Index On */
#define	RBMU_TEST_TEST_DONE_IDX_ON			BIT_2			
/* Testmode Done Index Off */
#define	RBMU_TEST_TEST_DONE_IDX_OFF			BIT_1			
#define	RBMU_TEST_TESTSTEP_DONE_IDX			BIT_0			/* Teststep Done Index */

/*	RBMU_SM				0x043C	Receive BMU State Machine Register */
#define	RBMU_SM_MSK			SHIFT0(0xffffffff)	/* BMU State machine */
#define	RBMU_SM_BASE		0

/*	RBMU_FIFO_WM		0x0440	Receive FIFO Watermark Register */
/*		Bit(s) RBMU_FIFO_WM_RSRV_15_11 reserved */
#define	RBMU_FIFO_WM_MSK					SHIFT0(0x7ffU)	/* FIFO Watermark */
#define	RBMU_FIFO_WM_BASE					0

/*	RBMU_FIFO_AL		0x0442	Receive FIFO Alignment Register */
/*		Bit(s) RBMU_FIFO_AL_RSRV_15_7 reserved */
#define	RBMU_FIFO_AL_MUX_MSK			SHIFT4(0x7U)	/* MUX */
#define	RBMU_FIFO_AL_MUX_BASE			4
/*		Bit(s) RBMU_FIFO_AL_RSRV_3 reserved */
#define	RBMU_FIFO_AL_VRAM_MSK			SHIFT0(0x7U)	/* VRAM */
#define	RBMU_FIFO_AL_VRAM_BASE			0

/*	RPFU_CTRL			0x0450	Receive Prefetch Control Register */
/*		Bit(s) RPFU_CTRL_RSRV_31_15 reserved */
/* Master Request Loopback Test On */
#define	RPFU_CTRL_MST_REQ_LPBK_ON			BIT_14				
/* Master Request Loopback Test Off */
#define	RPFU_CTRL_MST_REQ_LPBK_OFF			BIT_13				
/* Master Request Loopback Step */
#define	RPFU_CTRL_MST_REQ_LPBK_STEP			BIT_12				
/*		Bit(s) RPFU_CTRL_RSRV_11 reserved */
/* FIFO Read Pointer Test On */
#define	RPFU_CTRL_FIFO_RPTR_TEST_ON			BIT_10				
/* FIFO Read Pointer Test Off */
#define	RPFU_CTRL_FIFO_RPTR_TEST_OFF		BIT_9				
/* FIFO Read Pointer Step */
#define	RPFU_CTRL_FIFO_RPTR_TEST_STEP		BIT_8				
/*		Bit(s) RPFU_CTRL_RSRV_7 reserved */
/* FIFO Write Pointer Test On */
#define	RPFU_CTRL_FIFO_WPTR_TEST_ON			BIT_6				
/* FIFO Write Pointer Test Off */
#define	RPFU_CTRL_FIFO_WPTR_TEST_OFF		BIT_5				
/* FIFO Write Pointer Step */
#define	RPFU_CTRL_FIFO_WPTR_TEST_STEP		BIT_4				
#define	RPFU_CTRL_OP_ON						BIT_3				/* Operational On */
#define	RPFU_CTRL_OP_OFF					BIT_2				/* Operational Off */
#define	RPFU_CTRL_PFU_RST_CLR				BIT_1				/* PFU Reset Clear */
#define	RPFU_CTRL_PFU_RST_SET				BIT_0				/* PFU Reset Set */

/*	RPFU_LAST_IDX		0x0454	Receive PFU List Last Index Register */
/*		Bit(s) RPFU_LAST_IDX_RSRV_31_12 reserved */
#define	RPFU_LAST_IDX_MSK					SHIFT2(0x3ff)		/* List Last Index */
#define	RPFU_LAST_IDX_BASE					2
/* List Last Index Fix */
#define	RPFU_LAST_IDX_VAL_FIX_MSK			SHIFT0(0x3)			
#define	RPFU_LAST_IDX_VAL_FIX_BASE			0

/*	RPFU_LADR_LO		0x0458	Receive PFU List Start Address Low Register */
/* List Start Address Low */
#define	RPFU_LADR_LO_MSK				SHIFT5(0x7ffffff)	
#define	RPFU_LADR_LO_BASE				5
/* List Start Address Low Fix */
#define	RPFU_LADR_LO_VAL_FIX_MSK		SHIFT0(0x1f)		
#define	RPFU_LADR_LO_VAL_FIX_BASE		0

/*	RPFU_LADR_HI		0x045C	Receive PFU List Start Address High Register */
#define	RPFU_LADR_HI_MSK		SHIFT0(0xffffffff)	/* List Start Address High */
#define	RPFU_LADR_HI_BASE		0

/*	RPFU_GET_IDX		0x0460	Receive PFU Get Index Register */
/*		Bit(s) RPFU_GET_IDX_RSRV_31_12 reserved */
#define	RPFU_GET_IDX_MSK					SHIFT0(0xfff)		/* Get Index */
#define	RPFU_GET_IDX_BASE					0

/*	RPFU_PUT_IDX		0x0464	Receive PFU Put Index Register */
/*		Bit(s) RPFU_PUT_IDX_RSRV_31_12 reserved */
#define	RPFU_PUT_IDX_MSK					SHIFT0(0xfff)		/* Put Index */
#define	RPFU_PUT_IDX_BASE					0

/*	RPFU_FIFO_WR		0x0470	Receive PFU FIFO RAM Write and Write Shadow
 *								Pointer Register
 */
/*		Bit(s) RPFU_FIFO_WR_RSRV_31_24 reserved */
/* FIFO Write Shadow Pointer */
#define	RPFU_FIFO_WR_WSPTR_MSK				SHIFT16(0xff)	
#define	RPFU_FIFO_WR_WSPTR_BASE				16
/*		Bit(s) RPFU_FIFO_WR_RSRV_15_5 reserved */
#define	RPFU_FIFO_WR_WPTR_MSK				SHIFT0(0x1f)	/* FIFO Write Pointer */
#define	RPFU_FIFO_WR_WPTR_BASE				0

/*	RPFU_FIFO_RD		0x0474	Receive PFU FIFO RAM Read Pointer Register */
/*		Bit(s) RPFU_FIFO_RD_RSRV_31_5 reserved */
#define	RPFU_FIFO_RD_RPTR_MSK			SHIFT0(0x1f)		/* FIFO Read Pointer */
#define	RPFU_FIFO_RD_RPTR_BASE			0

/*	RPFU_FIFO_REQ_NB	0x0478	Receive PFU Master Request nbytes Register */
/*		Bit(s) RPFU_FIFO_REQ_NB_RSRV_31_27 reserved */
/* Master Request nBytes */
#define	RPFU_FIFO_REQ_NB_MR_MSK					SHIFT16(0x7ff)	
#define	RPFU_FIFO_REQ_NB_MR_BASE				16
/*		Bit(s) RPFU_FIFO_REQ_NB_RSRV_15_8 reserved */
#define	RPFU_FIFO_REQ_NB_WM_MSK					SHIFT0(0xff)	/* FIFO Watermark */
#define	RPFU_FIFO_REQ_NB_WM_BASE				0

/*	RPFU_FIFO_LEV		0x047C	Receive PFU FIFO Shadow Level Register */
/*		Bit(s) RPFU_FIFO_LEV_RSRV_31_24 reserved */
#define	RPFU_FIFO_LEV_SLEV_MSK				SHIFT16(0xff)	/* FIFO Shadow level */
#define	RPFU_FIFO_LEV_SLEV_BASE				16
/*		Bit(s) RPFU_FIFO_LEV_RSRV_15_5 reserved */
#define	RPFU_FIFO_LEV_MSK					SHIFT0(0x1f)	/* FIFO level */
#define	RPFU_FIFO_LEV_BASE					0

/*	TBMU_DESC1			0x0680	Current Transmit Descriptor Register 1 */
#define	TBMU_DESC1_MSK		SHIFT16(0xffff)	/* Transmit Buffer Control */
#define	TBMU_DESC1_BASE		16

/*	TBMU_DESC2			0x0684	Current Transmit Descriptor Register 2 */
#define	TBMU_DESC2_MSK		SHIFT0(0xffffU)	/* Transmit Buffer Byte Count */
#define	TBMU_DESC2_BASE		0

/*	TBMU_ADDR_LO		0x0688	Transmit Buffer Address Lower Register */
#define	TBMU_ADDR_LO_MSK		SHIFT0(0xffffffff)	/* Transmit Buffer Address Lo */
#define	TBMU_ADDR_LO_BASE		0

/*	TBMU_ADDR_HI		0x068C	Transmit Buffer Address Upper Register */
#define	TBMU_ADDR_HI_MSK		SHIFT0(0xffffffff)	/* Transmit Buffer Address Hi */
#define	TBMU_ADDR_HI_BASE		0

/*	TBMU_TFSW			0x0690	Transmit Buffer Status Word Register */
#define	TBMU_TFSW_MSK		SHIFT0(0xffffffff)	/* TFSW */
#define	TBMU_TFSW_BASE		0

/*	TBMU_VLAN			0x06A0	Transmit VLAN Tag Register */
/*		Bit(s) TBMU_VLAN_RSRV_31_16 reserved */
#define	TBMU_VLAN_MSK					SHIFT0(0xffff)	/* VLAN Tag */
#define	TBMU_VLAN_BASE					0

/*	TBMU_DONE_IDX		0x06A4	Transmit Done Index Register */
/*		Bit(s) TBMU_DONE_IDX_RSRV_31_12 reserved */
#define	TBMU_DONE_IDX_MSK					SHIFT0(0xfff)		/* Done Index */
#define	TBMU_DONE_IDX_BASE					0

/*	TBMU_REQ_ADDR_LO	0x06A8	Transmit Request Address Lower Register */
#define	TBMU_REQ_ADDR_LO_MSK		SHIFT0(0xffffffff)	/* Request Addr Lo */
#define	TBMU_REQ_ADDR_LO_BASE		0

/*	TBMU_REQ_ADDR_HI	0x06AC	Transmit Request Address Upper Register */
#define	TBMU_REQ_ADDR_HI_MSK		SHIFT0(0xffffffff)	/* Request Addr Hi */
#define	TBMU_REQ_ADDR_HI_BASE		0

/*	TBMU_REQ_CNT		0x06B0	Transmit Request Byte Count Register */
/*		Bit(s) TBMU_REQ_CNT_RSRV_31_11 reserved */
/* Request Byte Count */
#define	TBMU_REQ_CNT_MSK					SHIFT0(0x7ff)		
#define	TBMU_REQ_CNT_BASE					0

/*	TBMU_CSR			0x06B4	Transmit BMU Control/Status Register */
#define	TBMU_CSR_IDLE						BIT_31			/* BMU Idle */
/*		Bit(s) TBMU_CSR_RSRV_30_24 reserved */
/* Tx path automatic clock gating enable */
#define	TBMU_CSR_TX_GATE_ON					BIT_23			
/* TX path automatic clock gating disable */
#define	TBMU_CSR_TX_GATE_OFF				BIT_22			
/* TX path automatic clock gating timeout */
#define	TBMU_CSR_TX_GATE_TIMEOUT_MSK		SHIFT16(0x3f)	
#define	TBMU_CSR_TX_GATE_TIMEOUT_BASE		16
/*		Bit(s) TBMU_CSR_RSRV_15_14 reserved */
/* IP ID Increment Enable */
#define	TBMU_CSR_IP_ID_INCR_ENA				BIT_13			
/* IP ID Increment Disable */
#define	TBMU_CSR_IP_ID_INCR_DIS				BIT_12			
#define	TBMU_CSR_CLR_IRQ_TCP				BIT_11			/* Clear IRQ TCP */
#define	TBMU_CSR_CLR_IRQ_CHK				BIT_10			/* Clear IRQ Check */
#define	TBMU_CSR_STOP_TBMU					BIT_9			/* Stop Tx BMU */
#define	TBMU_CSR_STRT_TBMU					BIT_8			/* Start Tx BMU */
#define	TBMU_CSR_FIFO_OP_ON					BIT_7			/* FIFO Operational On */
#define	TBMU_CSR_FIFO_OP_OFF				BIT_6			/* FIFO Operational Off */
#define	TBMU_CSR_FIFO_ENA					BIT_5			/* FIFO Enable */
#define	TBMU_CSR_FIFO_RST					BIT_4			/* FIFO Reset */
#define	TBMU_CSR_TBMU_OP_ON					BIT_3			/* BMU Operational On */
#define	TBMU_CSR_TBMU_OP_OFF				BIT_2			/* BMU Operational Off */
#define	TBMU_CSR_TBMU_ENA					BIT_1			/* BMU Enable */
#define	TBMU_CSR_TBMU_RST					BIT_0			/* BMU Reset */

/*	TBMU_TEST			0x06B8	Transmit BMU Test Register */
/* BMU tx checksum auto calculation disable */
#define	TBMU_TEST_BMU_TX_CHK_AUTO_OFF		BIT_31			
/* BMU tx checksum auto calculation enable */
#define	TBMU_TEST_BMU_TX_CHK_AUTO_ON		BIT_30			
/*		Bit(s) TBMU_TEST_RSRV_29_23 reserved */
/* Testmode Shadow Read Ptr On */
#define	TBMU_TEST_TEST_RSPTR_ON				BIT_22			
/* Testmode Shadow Read Ptr Off */
#define	TBMU_TEST_TEST_RSPTR_OFF			BIT_21			
/* Teststep Shadow Read Ptr */
#define	TBMU_TEST_TESTSTEP_RSPTR			BIT_20			
/*		Bit(s) TBMU_TEST_RSRV_19 reserved */
#define	TBMU_TEST_TEST_RPTR_ON				BIT_18			/* Testmode Read Ptr On */
/* Testmode Read Ptr Off */
#define	TBMU_TEST_TEST_RPTR_OFF				BIT_17			
#define	TBMU_TEST_TESTSTEP_RPTR				BIT_16			/* Teststep Read Ptr */
/*		Bit(s) TBMU_TEST_RSRV_15 reserved */
/* Testmode Shadow Write Ptr On */
#define	TBMU_TEST_TEST_WSPTR_ON				BIT_14			
/* Testmode Shadow Write Ptr Off */
#define	TBMU_TEST_TEST_WSPTR_OFF			BIT_13			
/* Teststep Shadow Write Ptr */
#define	TBMU_TEST_TESTSTEP_WSPTR			BIT_12			
/*		Bit(s) TBMU_TEST_RSRV_11 reserved */
/* Testmode Write Ptr On */
#define	TBMU_TEST_TEST_WPTR_ON				BIT_10			
/* Testmode Write Ptr Off */
#define	TBMU_TEST_TEST_WPTR_OFF				BIT_9			
#define	TBMU_TEST_TESTSTEP_WPTR				BIT_8			/* Teststep Write Ptr */
/*		Bit(s) TBMU_TEST_RSRV_7 reserved */
/* Testmode Req Nbytes/Addr On */
#define	TBMU_TEST_TEST_REQ_NB_ON			BIT_6			
/* Testmode Req Nbytes/Addr Off */
#define	TBMU_TEST_TEST_REQ_NB_OFF			BIT_5			
/* Teststep Req Nbytes/Addr */
#define	TBMU_TEST_TESTSTEP_REQ_NB			BIT_4			
/*		Bit(s) TBMU_TEST_RSRV_3 reserved */
/* Testmode Done Index On */
#define	TBMU_TEST_TEST_DONE_IDX_ON			BIT_2			
/* Testmode Done Index Off */
#define	TBMU_TEST_TEST_DONE_IDX_OFF			BIT_1			
#define	TBMU_TEST_TESTSTEP_DONE_IDX			BIT_0			/* Teststep Done Index */

/*	TBMU_SM				0x06BC	Transmit BMU State Machine Register */
#define	TBMU_SM_MSK			SHIFT0(0xffffffff)	/* BMU State machine */
#define	TBMU_SM_BASE		0

/*	TBMU_FIFO_WM		0x06C0	Transmit FIFO Watermark Register */
/*		Bit(s) TBMU_FIFO_WM_RSRV_15_9 reserved */
#define	TBMU_FIFO_WM_MSK				SHIFT3(0x3fU)	/* FIFO Watermark */
#define	TBMU_FIFO_WM_BASE				3
/*		Bit(s) TBMU_FIFO_WM_RSRV_2_0 reserved */

/*	TBMU_FIFO_AL		0x06C2	Transmit FIFO Alignment Register */
/*		Bit(s) TBMU_FIFO_AL_RSRV_15_7 reserved */
#define	TBMU_FIFO_AL_MUX_MSK			SHIFT4(0x7U)	/* MUX */
#define	TBMU_FIFO_AL_MUX_BASE			4
/*		Bit(s) TBMU_FIFO_AL_RSRV_3 reserved */
#define	TBMU_FIFO_AL_VRAM_MSK			SHIFT0(0x7U)	/* VRAM */
#define	TBMU_FIFO_AL_VRAM_BASE			0

/*	TBMU_FIFO_WSPTR		0x06C4	Transmit FIFO Write Shadow Pointer Register */
/*		Bit(s) TBMU_FIFO_WSPTR_RSRV_15_9 reserved */
/* FIFO Write Shadow Pointer */
#define	TBMU_FIFO_WSPTR_MSK					SHIFT0(0x1ffU)	
#define	TBMU_FIFO_WSPTR_BASE				0

/*	TBMU_FIFO_WSLEV		0x06C6	Transmit FIFO Write Shadow Level Register */
/*		Bit(s) TBMU_FIFO_WSLEV_RSRV_15_6 reserved */
#define	TBMU_FIFO_WSLEV_MSK					SHIFT0(0x3fU)	/* FIFO Write Level */
#define	TBMU_FIFO_WSLEV_BASE				0

/*	TBMU_FIFO_WPTR		0x06C8	Transmit FIFO Write Pointer Register */
/*		Bit(s) TBMU_FIFO_WPTR_RSRV_15_6 reserved */
#define	TBMU_FIFO_WPTR_MSK					SHIFT0(0x3fU)	/* FIFO Write Pointer */
#define	TBMU_FIFO_WPTR_BASE					0

/*	TBMU_FIFO_WLEV		0x06CA	Transmit FIFO Write Level Register */
/*		Bit(s) TBMU_FIFO_WLEV_RSRV_15_6 reserved */
#define	TBMU_FIFO_WLEV_MSK					SHIFT0(0x3fU)	/* FIFO Write Level */
#define	TBMU_FIFO_WLEV_BASE					0

/*	TBMU_FIFO_RPTR		0x06CC	Transmit FIFO Read Pointer Register */
/*		Bit(s) TBMU_FIFO_RPTR_RSRV_15_6 reserved */
#define	TBMU_FIFO_RPTR_MSK					SHIFT0(0x3fU)	/* FIFO Read Pointer */
#define	TBMU_FIFO_RPTR_BASE					0

/*	TBMU_RLEV			0x06CE	Transmit FIFO Read Level Register */
/*		Bit(s) TBMU_RLEV_RSRV_15_6 reserved */
#define	TBMU_RLEV_MSK					SHIFT0(0x3fU)	/* FIFO Read Level */
#define	TBMU_RLEV_BASE					0

/*	TPFU_CTRL			0x06D0	Transmit Prefetch Control Register */
/*		Bit(s) TPFU_CTRL_RSRV_31_15 reserved */
/* Master Request Loopback Test On */
#define	TPFU_CTRL_MST_REQ_LPBK_ON			BIT_14				
/* Master Request Loopback Test Off */
#define	TPFU_CTRL_MST_REQ_LPBK_OFF			BIT_13				
/* Master Request Loopback Step */
#define	TPFU_CTRL_MST_REQ_LPBK_STEP			BIT_12				
/*		Bit(s) TPFU_CTRL_RSRV_11 reserved */
/* FIFO Read Pointer Test On */
#define	TPFU_CTRL_FIFO_RPTR_TEST_ON			BIT_10				
/* FIFO Read Pointer Test Off */
#define	TPFU_CTRL_FIFO_RPTR_TEST_OFF		BIT_9				
/* FIFO Read Pointer Step */
#define	TPFU_CTRL_FIFO_RPTR_TEST_STEP		BIT_8				
/*		Bit(s) TPFU_CTRL_RSRV_7 reserved */
/* FIFO Write Pointer Test On */
#define	TPFU_CTRL_FIFO_WPTR_TEST_ON			BIT_6				
/* FIFO Write Pointer Test Off */
#define	TPFU_CTRL_FIFO_WPTR_TEST_OFF		BIT_5				
/* FIFO Write Pointer Step */
#define	TPFU_CTRL_FIFO_WPTR_TEST_STEP		BIT_4				
#define	TPFU_CTRL_OP_ON						BIT_3				/* Operational On */
#define	TPFU_CTRL_OP_OFF					BIT_2				/* Operational Off */
#define	TPFU_CTRL_PFU_RST_CLR				BIT_1				/* PFU Reset Clear */
#define	TPFU_CTRL_PFU_RST_SET				BIT_0				/* PFU Reset Set */

/*	TPFU_LAST_IDX		0x06D4	Transmit PFU List Last Index Register */
/*		Bit(s) TPFU_LAST_IDX_RSRV_31_12 reserved */
#define	TPFU_LAST_IDX_MSK					SHIFT2(0x3ff)		/* List Last Index */
#define	TPFU_LAST_IDX_BASE					2
/* List Last Index Fix */
#define	TPFU_LAST_IDX_VAL_FIX_MSK			SHIFT0(0x3)			
#define	TPFU_LAST_IDX_VAL_FIX_BASE			0

/*	TPFU_LADR_LO		0x06D8	Transmit PFU List Start Address Low Register */
/* List Start Address Low */
#define	TPFU_LADR_LO_MSK				SHIFT5(0x7ffffff)	
#define	TPFU_LADR_LO_BASE				5
/* List Start Address Low Fix */
#define	TPFU_LADR_LO_VAL_FIX_MSK		SHIFT0(0x1f)		
#define	TPFU_LADR_LO_VAL_FIX_BASE		0

/*	TPFU_LADR_HI		0x06DC	Transmit PFU List Start Address High Register */
#define	TPFU_LADR_HI_MSK		SHIFT0(0xffffffff)	/* List Start Address High */
#define	TPFU_LADR_HI_BASE		0

/*	TPFU_GET_IDX		0x06E0	Transmit PFU Get Index Register */
/*		Bit(s) TPFU_GET_IDX_RSRV_31_12 reserved */
#define	TPFU_GET_IDX_MSK					SHIFT0(0xfff)		/* Get Index */
#define	TPFU_GET_IDX_BASE					0

/*	TPFU_PUT_IDX		0x06E4	Transmit PFU Put Index Register */
/*		Bit(s) TPFU_PUT_IDX_RSRV_31_12 reserved */
#define	TPFU_PUT_IDX_MSK					SHIFT0(0xfff)		/* Put Index */
#define	TPFU_PUT_IDX_BASE					0

/*	TPFU_FIFO_WR		0x06F0	Transmit PFU FIFO RAM Write and Write Shadow
 *								Pointer Register
 */
/*		Bit(s) TPFU_FIFO_WR_RSRV_31_24 reserved */
/* FIFO Write Shadow Pointer */
#define	TPFU_FIFO_WR_WSPTR_MSK				SHIFT16(0xff)	
#define	TPFU_FIFO_WR_WSPTR_BASE				16
/*		Bit(s) TPFU_FIFO_WR_RSRV_15_5 reserved */
#define	TPFU_FIFO_WR_WPTR_MSK				SHIFT0(0x1f)	/* FIFO Write Pointer */
#define	TPFU_FIFO_WR_WPTR_BASE				0

/*	TPFU_FIFO_RD		0x06F4	Transmit PFU FIFO RAM Read Pointer Register */
/*		Bit(s) TPFU_FIFO_RD_RSRV_31_5 reserved */
#define	TPFU_FIFO_RD_RPTR_MSK			SHIFT0(0x1f)		/* FIFO Read Pointer */
#define	TPFU_FIFO_RD_RPTR_BASE			0

/*	TPFU_FIFO_REQ_NB	0x06F8	Transmit PFU Master Request nbytes Register */
/*		Bit(s) TPFU_FIFO_REQ_NB_RSRV_31_27 reserved */
/* Master Request nBytes */
#define	TPFU_FIFO_REQ_NB_MR_MSK					SHIFT16(0x7ff)	
#define	TPFU_FIFO_REQ_NB_MR_BASE				16
/*		Bit(s) TPFU_FIFO_REQ_NB_RSRV_15_8 reserved */
#define	TPFU_FIFO_REQ_NB_WM_MSK					SHIFT0(0xff)	/* FIFO Watermark */
#define	TPFU_FIFO_REQ_NB_WM_BASE				0

/*	TPFU_FIFO_LEV		0x06FC	Transmit PFU FIFO Shadow Level Register */
/*		Bit(s) TPFU_FIFO_LEV_RSRV_31_24 reserved */
#define	TPFU_FIFO_LEV_SLEV_MSK				SHIFT16(0xff)	/* FIFO Shadow level */
#define	TPFU_FIFO_LEV_SLEV_BASE				16
/*		Bit(s) TPFU_FIFO_LEV_RSRV_15_5 reserved */
#define	TPFU_FIFO_LEV_MSK					SHIFT0(0x1f)	/* FIFO level */
#define	TPFU_FIFO_LEV_BASE					0

/*	RA_SADDR			0x0900	ASF Receive FIFO Start Address */
/*		Bit(s) RA_SADDR_RSRV_22_0 reserved */
#define	RA_SADDR_RA_SADDR_MSK		SHIFT0(0x1ff)		/* Start Address */
#define	RA_SADDR_RA_SADDR_BASE		BIT_0

/*	RA_EADDR			0x0904	ASF Receive FIFO End Address */
/*		Bit(s) RA_EADDR_RSRV_22_0 reserved */
#define	RA_EADDR_RA_EADDR_MSK		SHIFT0(0x1ff)		/* End Address */
#define	RA_EADDR_RA_EADDR_BASE		BIT_0

/*	RA_WPTR				0x0908	ASF Receive FIFO Write Pointer */
/*		Bit(s) RA_WPTR_RSRV_22_0 reserved */
#define	RA_WPTR_RA_WPTR_MSK			SHIFT0(0x1ff)		/* Write Pointer */
#define	RA_WPTR_RA_WPTR_BASE		BIT_0

/*	RA_RPTR				0x090C	ASF Receive FIFO Read Pointer */
/*		Bit(s) RA_RPTR_RSRV_22_0 reserved */
#define	RA_RPTR_RA_RPTR_MSK			SHIFT0(0x1ff)		/* Read Pointer */
#define	RA_RPTR_RA_RPTR_BASE		BIT_0

/*	RA_BRST				0x0910	ASF Receive FIFO Burst Control */
/*		Bit(s) RA_BRST_RSRV_13_0 reserved */
#define	RA_BRST_RA_BRST_EN				BIT_17			/* Burst Enable */
#define	RA_BRST_RA_BRST_RST				BIT_16			/* Burst Disable */
/*		Bit(s) RA_BRST_RSRV_6_0 reserved */
#define	RA_BRST_RA_BRST_THRS_MSK		SHIFT0(0x1ff)	/* Burst Threshold */
#define	RA_BRST_RA_BRST_THRS_BASE		BIT_0

/*	RA_PCNT				0x0920	ASF Receive FIFO Packet Counter */
/*		Bit(s) RA_PCNT_RSRV_22_0 reserved */
#define	RA_PCNT_RA_PCNT_MSK			SHIFT0(0x1ff)		/* Packet Counter */
#define	RA_PCNT_RA_PCNT_BASE		BIT_0

/*	RA_LEV				0x0924	ASF Receive FIFO Level */
/*		Bit(s) RA_LEV_RSRV_22_0 reserved */
#define	RA_LEV_RA_LEV_MSK			SHIFT0(0x1ff)		/* Level */
#define	RA_LEV_RA_LEV_BASE			BIT_0

/*	RA_CTRL				0x0928	ASF Receive FIFO Control/Test */
/*		Bit(s) RA_CTRL_RSRV_11_0 reserved */
#define	RA_CTRL_RA_PCNT_DN			BIT_19			/* Packet Counter Step Down */
#define	RA_CTRL_RA_PCNT_ENA			BIT_18			/* Packet Counter Test On */
#define	RA_CTRL_RA_PCNT_RST			BIT_17			/* Packet Counter Test Off */
#define	RA_CTRL_RA_PCNT_UP			BIT_16			/* Packet Counter Step Up */
/*		Bit(s) RA_CTRL_RSRV_ reserved */
#define	RA_CTRL_RA_WPTR_ENA			BIT_14			/* Write Pointer Test On */
#define	RA_CTRL_RA_WPTR_RST			BIT_13			/* Write Pointer Test Off */
#define	RA_CTRL_RA_WPTR_UP			BIT_12			/* Write Pointer Step Up */
/*		Bit(s) RA_CTRL_RSRV_4_0 reserved */
#define	RA_CTRL_RA_IRQ_CLR			BIT_6			/* Clear IRQ ASF Receive FIFO */
/*		Bit(s) RA_CTRL_RSRV_1_0 reserved */
#define	RA_CTRL_RA_OP_ON			BIT_3			/* Operational On */
#define	RA_CTRL_RA_OP_OFF			BIT_2			/* Operational Off */
#define	RA_CTRL_RA_RST_CLR			BIT_1			/* Reset Clear */
#define	RA_CTRL_RA_RST_SET			BIT_0			/* Reset Set */

/*	RA_FLSH_CTRL		0x092C	ASF Receive FIFO Flush Control */
#define	RA_FLSH_CTRL_RA_FLSH				BIT_31				/* Flush */
/*		Bit(s) RA_FLSH_CTRL_RSRV_21_0 reserved */
#define	RA_FLSH_CTRL_RA_FLSH_QWORD_MSK		SHIFT0(0x1ff)		/* Flush Qword */
#define	RA_FLSH_CTRL_RA_FLSH_QWORD_BASE		BIT_0

/*	TA_SADDR			0x0940	ASF Transmit FIFO Start Address */
/*		Bit(s) TA_SADDR_RSRV_22_0 reserved */
#define	TA_SADDR_TA_SADDR_MSK		SHIFT0(0x1ff)		/* Start Address */
#define	TA_SADDR_TA_SADDR_BASE		BIT_0

/*	TA_EADDR			0x0944	ASF Transmit FIFO End Address */
/*		Bit(s) TA_EADDR_RSRV_22_0 reserved */
#define	TA_EADDR_TA_EADDR_MSK		SHIFT0(0x1ff)		/* End Address */
#define	TA_EADDR_TA_EADDR_BASE		BIT_0

/*	TA_WPTR				0x0948	ASF Transmit FIFO Write Pointer */
/*		Bit(s) TA_WPTR_RSRV_22_0 reserved */
#define	TA_WPTR_TA_WPTR_MSK			SHIFT0(0x1ff)		/* Write Pointer */
#define	TA_WPTR_TA_WPTR_BASE		BIT_0

/*	TA_RPTR				0x094C	ASF Transmit FIFO Read Pointer */
/*		Bit(s) TA_RPTR_RSRV_22_0 reserved */
#define	TA_RPTR_TA_RPTR_MSK			SHIFT0(0x1ff)		/* Read Pointer */
#define	TA_RPTR_TA_RPTR_BASE		BIT_0

/*	TA_PCNT				0x0960	ASF Transmit FIFO Packet Counter */
/*		Bit(s) TA_PCNT_RSRV_22_0 reserved */
#define	TA_PCNT_TA_PCNT_MSK			SHIFT0(0x1ff)		/* Packet Counter */
#define	TA_PCNT_TA_PCNT_BASE		BIT_0

/*	TA_LEV				0x0964	ASF Transmit FIFO Level */
/*		Bit(s) TA_LEV_RSRV_22_0 reserved */
#define	TA_LEV_TA_LEV_MSK			SHIFT0(0x1ff)		/* Level */
#define	TA_LEV_TA_LEV_BASE			BIT_0

/*	TA_CTRL				0x0968	ASF Transmit FIFO Control/Test */
/*		Bit(s) TA_CTRL_RSRV_11_0 reserved */
#define	TA_CTRL_TA_PCNT_DN			BIT_19			/* Packet Counter Step Down */
#define	TA_CTRL_TA_PCNT_ENA			BIT_18			/* Packet Counter Test On */
#define	TA_CTRL_TA_PCNT_RST			BIT_17			/* Packet Counter Test Off */
#define	TA_CTRL_TA_PCNT_UP			BIT_16			/* Packet Counter Step Up */
/*		Bit(s) TA_CTRL_RSRV_4_0 reserved */
#define	TA_CTRL_TA_RPTR_ENA			BIT_10			/* Read Pointer Test On */
#define	TA_CTRL_TA_RPTR_RST			BIT_9			/* Read Pointer Test Off */
#define	TA_CTRL_TA_RPTR_UP			BIT_8			/* Read Pointer Step Up */
/*		Bit(s) TA_CTRL_RSRV_ reserved */
#define	TA_CTRL_TA_IRQ_CLR			BIT_6			/* Clear IRQ ASF Transmit FIFO */
/*		Bit(s) TA_CTRL_RSRV_1_0 reserved */
#define	TA_CTRL_TA_OP_ON			BIT_3			/* Operational On */
#define	TA_CTRL_TA_OP_OFF			BIT_2			/* Operational Off */
#define	TA_CTRL_TA_RST_CLR			BIT_1			/* Reset Clear */
#define	TA_CTRL_TA_RST_SET			BIT_0			/* Reset Set */

/*	TA_SEND_CTRL		0x096C	ASF Transmit FIFO Send Control */
#define	TA_SEND_CTRL_TA_SEND				BIT_31				/* Send */
/*		Bit(s) TA_SEND_CTRL_RSRV_21_0 reserved */
#define	TA_SEND_CTRL_TA_SEND_QWORD_MSK		SHIFT0(0x1ff)		/* Send Qword */
#define	TA_SEND_CTRL_TA_SEND_QWORD_BASE		BIT_0

/*	RXMF_EADDR			0x0C40	Receive MAC FIFO End Address Register */
/*		Bit(s) RXMF_EADDR_RSRV_31_1 reserved */
#define	RXMF_EADDR_TS_DIS					BIT_0				/* TIMESTAMP_OUT_E */

/*	RXMF_AFTH			0x0C44	Receive MAC FIFO Almost Full Threshold Register */
/*		Bit(s) RXMF_AFTH_RSRV_31_9 reserved */
/* Almost Full Threshold */
#define	RXMF_AFTH_MSK					SHIFT0(0x1ff)		
#define	RXMF_AFTH_BASE					0

/*	RXMF_TCTL			0x0C48	Receive MAC FIFO Control/Test Register */
/* RX MAC Clock Gating Enable */
#define	RXMF_TCTL_GCLKMAC_ENA			BIT_31			
/* RX MAC Clock Gating Disable */
#define	RXMF_TCTL_GCLKMAC_DIS			BIT_30			
/* RX Store and Forward Enable */
#define	RXMF_TCTL_STFWD_ENA				BIT_29			
/* RX Store and Forward Disable */
#define	RXMF_TCTL_STFWD_DIS				BIT_28			
#define	RXMF_TCTL_TRUNC_ENA				BIT_27			/* Truncation Enable */
#define	RXMF_TCTL_TRUNC_DIS				BIT_26			/* Truncation Disable */
#define	RXMF_TCTL_VLAN_ENA				BIT_25			/* VLAN Enable */
#define	RXMF_TCTL_VLAN_DIS				BIT_24			/* VLAN Disable */
/*		Bit(s) RXMF_TCTL_RSRV_23_20 reserved */
/* RX MACSec Flush Enable */
#define	RXMF_TCTL_MACSEC_FLSH_ENA			BIT_23			
/* RX MACSec Flush Disable */
#define	RXMF_TCTL_MACSEC_FLSH_DIS			BIT_22			
/* ASF RX MACSec Flush Enable */
#define	RXMF_TCTL_RA_MACSEC_FLSH_ENA		BIT_21			
/* ASF RX MACSec Flush Disable */
#define	RXMF_TCTL_RA_MACSEC_FLSH_DIS		BIT_20			
/* RX Overrun Flush Enable */
#define	RXMF_TCTL_OVRRN_FLSH_ENA			BIT_19			
/* RX Overrun Flush Disable */
#define	RXMF_TCTL_OVRRN_FLSH_DIS			BIT_18			
/* ASF RX Overrun Flush Enable */
#define	RXMF_TCTL_RA_FLSH_ENA				BIT_17			
/* ASF RX Overrun Flush Disable */
#define	RXMF_TCTL_RA_FLSH_DIS				BIT_16			
/*		Bit(s) RXMF_TCTL_RSRV_ reserved */
/* Write Pointer Test On */
#define	RXMF_TCTL_WPTR_TEST_ON				BIT_14			
/* Write Pointer Test Off */
#define	RXMF_TCTL_WPTR_TEST_OFF				BIT_13			
#define	RXMF_TCTL_WPTR_TEST_STEP			BIT_12			/* Write Pointer Step */
/*		Bit(s) RXMF_TCTL_RSRV_ reserved */
#define	RXMF_TCTL_RPTR_TEST_ON				BIT_10			/* Read Pointer Test On */
/* Read Pointer Test Off */
#define	RXMF_TCTL_RPTR_TEST_OFF				BIT_9			
#define	RXMF_TCTL_RPTR_TEST_STEP		BIT_8			/* Read Pointer Step */
#define	RXMF_TCTL_FLUSH_ON				BIT_7			/* FIFO Flush On */
#define	RXMF_TCTL_FLUSH_OFF				BIT_6			/* FIFO Flush Off */
/* Clear IRQ Receive FIFO Overrun */
#define	RXMF_TCTL_CLR_IRQ_RX_OF			BIT_5			
/* Clear IRQ Frame Reception Complete */
#define	RXMF_TCTL_CLR_IRQ_RX_OK			BIT_4			
#define	RXMF_TCTL_OP_ON					BIT_3			/* Operational On */
#define	RXMF_TCTL_OP_OFF				BIT_2			/* Operational Off */
#define	RXMF_TCTL_RST_CLR				BIT_1			/* MAC FIFO Reset Clear */
#define	RXMF_TCTL_RST_SET				BIT_0			/* MAC FIFO Reset Set */

/*	RXMF_FLMSK			0x0C4C	Receive MAC FIFO Flush Mask Register */
/*		Bit(s) RXMF_FLMSK_RSRV_31_14 reserved */
#define	RXMF_FLMSK_LEN_ERR				BIT_14				/* Length Error */
#define	RXMF_FLMSK_VLAN					BIT_13				/* VLAN packet */
#define	RXMF_FLMSK_JBR					BIT_12				/* Jabber */
#define	RXMF_FLMSK_USIZE				BIT_11				/* Undersize packet */
#define	RXMF_FLMSK_MCST					BIT_10				/* Multicast packet */
#define	RXMF_FLMSK_BCST					BIT_9				/* Broadcast packet */
#define	RXMF_FLMSK_RX_OK				BIT_8				/* Receive OK */
/* Good flow control packet */
#define	RXMF_FLMSK_GD_FC				BIT_7				
/* Bad flow control packet */
#define	RXMF_FLMSK_BD_FC				BIT_6				
#define	RXMF_FLMSK_MII_ERR				BIT_5				/* MII error */
#define	RXMF_FLMSK_TLNG					BIT_4				/* Too long packet */
#define	RXMF_FLMSK_FRAG					BIT_3				/* Fragment */
/*		Bit(s) RXMF_FLMSK_RSRV_2 reserved */
#define	RXMF_FLMSK_CRC_ERR				BIT_1				/* CRC error */
/* Receive FIFO overflow */
#define	RXMF_FLMSK_RX_OF				BIT_0				

/*	RXMF_FLTH			0x0C50	Receive MAC FIFO Flush Threshold Register */
/*		Bit(s) RXMF_FLTH_RSRV_31_22 reserved */
/* Pointers Delay Synchronization Enable */
#define	RXMF_FLTH_PTR_SYNCDLY_ENA		BIT_21			
/* Pointers Delay Synchronization Disable */
#define	RXMF_FLTH_PTR_SYNCDLY_DIS		BIT_20			
/* RX ASF Flag New Logic Enable */
#define	RXMF_FLTH_ASF_NEWFLAG_ENA		BIT_19			
/* RX ASF Flag New Logic Disable */
#define	RXMF_FLTH_ASF_NEWFLAG_DIS		BIT_18			
/* RX Flush Miss-Packet Enable */
#define	RXMF_FLTH_FLSH_MISSPKT_ENA		BIT_17			
/* RX Flush Miss-Packet Disable */
#define	RXMF_FLTH_FLSH_MISSPKT_DIS		BIT_16			
/*		Bit(s) RXMF_FLTH_RSRV_6_0 reserved */
#define	RXMF_FLTH_MSK					SHIFT0(0x1ff)	/* Flush Threshold */
#define	RXMF_FLTH_BASE					0

/*	RXMF_TRTH			0x0C54	Receive Truncation Threshold Register */
/*		Bit(s) RXMF_TRTH_RSRV_31_9 reserved */
/* Truncation Threshold */
#define	RXMF_TRTH_TRUNCATION_THRESHOLD_MSK		SHIFT0(0x1ff)		
#define	RXMF_TRTH_TRUNCATION_THRESHOLD_BASE		0

/*	RXMF_ULTH			0x0C58	Upper/Lower Threshold/Pause Packets Register */
/*		Bit(s) RXMF_ULTH_RSRV_31_25 reserved */
/* Pause Packet Watermark Low Threshold */
#define	RXMF_ULTH_LO_TH_MSK				SHIFT16(0x1ff)	
#define	RXMF_ULTH_LO_TH_BASE			16
/*		Bit(s) RXMF_ULTH_RSRV_15_9 reserved */
/* Pause Packet Watermark High Threshold */
#define	RXMF_ULTH_HI_TH_MSK				SHIFT0(0x1ff)	
#define	RXMF_ULTH_HI_TH_BASE			0

/*	RXMF_VLTYP			0x0C5C	Receive VLAN Type Register */
/*		Bit(s) RXMF_VLTYP_RSRV_31_16 reserved */
#define	RXMF_VLTYP_MSK					SHIFT0(0xffff)	/* Receive VLAN Type */
#define	RXMF_VLTYP_BASE					0

/*	RXMF_WPTR			0x0C60	Receive MAC FIFO Write Pointer Register */
/*		Bit(s) RXMF_WPTR_RSRV_31_9 reserved */
#define	RXMF_WPTR_MSK					SHIFT0(0x1ff)		/* Write Pointer */
#define	RXMF_WPTR_BASE					0

/*	RXMF_WLEV			0x0C68	Receive MAC FIFO Write Level Register */
/*		Bit(s) RXMF_WLEV_RSRV_31_9 reserved */
#define	RXMF_WLEV_MSK					SHIFT0(0x1ff)		/* Write Level */
#define	RXMF_WLEV_BASE					0

/*	RXMF_RPTR			0x0C70	Receive MAC FIFO Read Pointer Register */
/*		Bit(s) RXMF_RPTR_RSRV_31_9 reserved */
#define	RXMF_RPTR_MSK					SHIFT0(0x1ff)		/* Read Pointer */
#define	RXMF_RPTR_BASE					0

/*	RXMF_RLEV			0x0C78	Receive MAC FIFO Read Level Register */
/*		Bit(s) RXMF_RLEV_RSRV_31_9 reserved */
#define	RXMF_RLEV_MSK					SHIFT0(0x1ff)		/* Read Level */
#define	RXMF_RLEV_BASE					0

/*	TXMF_EADDR			0x0D40	Transmit MAC FIFO End Address Register */
/*		Bit(s) TXMF_EADDR_RSRV_31_4 reserved */
/* MAC Tx RAM Read Control */
#define	TXMF_EADDR_MAC_TX_RAM_RD_CTRL		BIT_3				
/* BMU Tx RAM Read Control */
#define	TXMF_EADDR_BMU_TX_RAM_RD_CTRL		BIT_2				
/*		Bit(s) TXMF_EADDR_RSRV_1_0 reserved */

/*	TXMF_AETH			0x0D44	Transmit MAC FIFO Almost Empty Threshold
 *								Register
 */
/*		Bit(s) TXMF_AETH_RSRV_31_25 reserved */
#define	TXMF_AETH_JUMBO_WM_MSK			SHIFT16(0x1ff)	/* Jumbo Mode Watermark */
#define	TXMF_AETH_JUMBO_WM_BASE			16
/*		Bit(s) TXMF_AETH_RSRV_15_8 reserved */
#define	TXMF_AETH_MSK					SHIFT0(0xff)	/* Almost Empty Threshold */
#define	TXMF_AETH_BASE					0

/*	TXMF_TCTL			0x0D48	Transmit MAC FIFO Control/Test Register */
#define	TXMF_TCTL_JUMBO_ENA				BIT_31			/* Jumbo Mode Enable */
/* Tx Store and Forward Mode Enable */
#define	TXMF_TCTL_STORE_FW_ENA			BIT_30			
#define	TXMF_TCTL_FIX_440_OFF			BIT_29			/* Perf Fix #4.40 Off */
#define	TXMF_TCTL_FIX_440_ON			BIT_28			/* Perf Fix #4.40 On */
/* CHECKSUM SEL use WRITE status bit */
#define	TXMF_TCTL_CHKSUM_DIS			BIT_27			
/* CHECKSUM SEL use CALSUM status bit */
#define	TXMF_TCTL_CHKSUM_EN				BIT_26			
#define	TXMF_TCTL_VLAN_ENA				BIT_25			/* VLAN Enable */
#define	TXMF_TCTL_VLAN_DIS				BIT_24			/* VLAN Disable */
#define	TXMF_TCTL_PCI_JUMBO_ENA			BIT_23			/* PCI Jumbo Mode Enable */
#define	TXMF_TCTL_PCI_JUMBO_DIS			BIT_22			/* PCI Jumbo Mode Disable */
/*		Bit(s) TXMF_TCTL_RSRV_21_19 reserved */
/* Write Shadow Pointer Test On */
#define	TXMF_TCTL_WSPTR_TEST_ON			BIT_18			
/* Write Shadow Pointer Test Off */
#define	TXMF_TCTL_WSPTR_TEST_OFF		BIT_17			
/* Write Shadow Pointer Step */
#define	TXMF_TCTL_WSPTR_TEST_STEP		BIT_16			
/*		Bit(s) TXMF_TCTL_RSRV_15 reserved */
#define	TXMF_TCTL_WPTR_TEST_ON			BIT_14			/* Write Pointer Test On */
#define	TXMF_TCTL_WPTR_TEST_OFF			BIT_13			/* Write Pointer Test Off */
#define	TXMF_TCTL_WPTR_TEST_STEP		BIT_12			/* Write Pointer Step */
/*		Bit(s) TXMF_TCTL_RSRV_11 reserved */
#define	TXMF_TCTL_RPTR_TEST_ON			BIT_10			/* Read Pointer Test On */
#define	TXMF_TCTL_RPTR_TEST_OFF			BIT_9			/* Read Pointer Test Off */
#define	TXMF_TCTL_RPTR_TEST_STEP		BIT_8			/* Read Pointer Step */
/*		Bit(s) TXMF_TCTL_RSRV_7 reserved */
/* Clear IRQ Transmit FIFO Underrun */
#define	TXMF_TCTL_CLR_IRQ_TX_UR			BIT_6			
/* Clear IRQ Frame Transmission Complete */
#define	TXMF_TCTL_CLR_IRQ_TX_OK			BIT_5			
#define	TXMF_TCTL_CLR_IRQ_PAR			BIT_4			/* Clear IRQ Parity Error */
#define	TXMF_TCTL_OP_ON					BIT_3			/* Operational On */
#define	TXMF_TCTL_OP_OFF				BIT_2			/* Operational Off */
#define	TXMF_TCTL_RST_CLR				BIT_1			/* MAC FIFO Reset Clear */
#define	TXMF_TCTL_RST_SET				BIT_0			/* MAC FIFO Reset Set */

/*	TXMF_VLTYP			0x0D5C	Transmit VLAN Type Register */
/*		Bit(s) TXMF_VLTYP_RSRV_31_16 reserved */
#define	TXMF_VLTYP_MSK					SHIFT0(0xffff)	/* Transmit VLAN Type */
#define	TXMF_VLTYP_BASE					0

/*	TXMF_WPTR			0x0D60	Transmit MAC FIFO Write Pointer Register */
/*		Bit(s) TXMF_WPTR_RSRV_31_8 reserved */
#define	TXMF_WPTR_MSK					SHIFT0(0xff)		/* Write Pointer */
#define	TXMF_WPTR_BASE					0

/*	TXMF_WSPTR			0x0D64	Transmit MAC FIFO Write Shadow Pointer Register */
/*		Bit(s) TXMF_WSPTR_RSRV_31_8 reserved */
#define	TXMF_WSPTR_MSK					SHIFT0(0xff)		/* Write Shadow Pointer */
#define	TXMF_WSPTR_BASE					0

/*	TXMF_WLEV			0x0D68	Transmit MAC FIFO Write Level Register */
/*		Bit(s) TXMF_WLEV_RSRV_31_8 reserved */
#define	TXMF_WLEV_MSK					SHIFT0(0xff)		/* Write Level */
#define	TXMF_WLEV_BASE					0

/*	TXMF_RPTR			0x0D70	Transmit MAC FIFO Read Pointer Register */
/*		Bit(s) TXMF_RPTR_RSRV_31_8 reserved */
#define	TXMF_RPTR_MSK					SHIFT0(0xff)		/* Read Pointer */
#define	TXMF_RPTR_BASE					0

/*	TXMF_RES_PTR		0x0D74	Transmit MAC FIFO Restart Pointer Register */
/*		Bit(s) TXMF_RES_PTR_RSRV_31_8 reserved */
#define	TXMF_RES_PTR_MSK				SHIFT0(0xff)		/* Restart Pointer */
#define	TXMF_RES_PTR_BASE				0

/*	TXMF_RLEV			0x0D78	Transmit MAC FIFO Read Level Register */
/*		Bit(s) TXMF_RLEV_RSRV_31_8 reserved */
#define	TXMF_RLEV_MSK					SHIFT0(0xff)		/* Read Level */
#define	TXMF_RLEV_BASE					0

/*	DPOL_TIM_INIT		0x0E00	Descriptor Poll Timer Init Value Register */
#define	DPOL_TIM_INIT_INIT_VALUE_MSK		SHIFT0(0xffffffff)	/* Init Value */
#define	DPOL_TIM_INIT_INIT_VALUE_BASE		0

/*	DPOL_TIM_CNT		0x0E04	Descriptor Poll Timer Register */
#define	DPOL_TIM_CNT_MSK		SHIFT0(0xffffffff)	/* Descriptor Poll Timer */
#define	DPOL_TIM_CNT_BASE		0

/*	DPOL_TCTL			0x0E08	Descriptor Poll Timer Control/Test Register */
/*		Bit(s) DPOL_TCTL_RSRV_31_11 reserved */
/* Descriptor Poll Timer Test On */
#define	DPOL_TCTL_ON					BIT_10				
/* Descriptor Poll Timer Test Off */
#define	DPOL_TCTL_OFF					BIT_9				
/* Descriptor Poll Timer Step */
#define	DPOL_TCTL_STEP					BIT_8				
/*		Bit(s) DPOL_TCTL_RSRV_7_3 reserved */
/* Descriptor Poll Timer Start */
#define	DPOL_TCTL_STRT					BIT_2				
/* Descriptor Poll Timer Stop */
#define	DPOL_TCTL_STOP					BIT_1				
/*		Bit(s) DPOL_TCTL_RSRV_0 reserved */

/*	TSP_TIM_CNT			0x0E14	Timestamp Timer Registers */
#define	TSP_TIM_CNT_MSK			SHIFT0(0xffffffff)	/* Timestamp Timer */
#define	TSP_TIM_CNT_BASE		0

/*	TSP_TIM_TCTL		0x0E18	Timestamp Timer Control/Test Register */
/*		Bit(s) TSP_TIM_TCTL_RSRV_31_11 reserved */
/* Timestamp Timer Test On */
#define	TSP_TIM_TCTL_ON						BIT_10				
/* Timestamp Timer Test Off */
#define	TSP_TIM_TCTL_OFF					BIT_9				
/* Timestamp Timer Step */
#define	TSP_TIM_TCTL_STEP					BIT_8				
/*		Bit(s) TSP_TIM_TCTL_RSRV_7_3 reserved */
/* Timestamp Timer Start */
#define	TSP_TIM_TCTL_STRT					BIT_2				
/* Timestamp Timer Stop */
#define	TSP_TIM_TCTL_STOP					BIT_1				
/* Timestamp Timer Clear IRQ */
#define	TSP_TIM_TCTL_CLR_IRQ				BIT_0				

/*	POLL_CTRL			0x0E20	Poll Control Register */
/*		Bit(s) POLL_CTRL_RSRV_31_6 reserved */
#define	POLL_CTRL_CLR_IRQ				BIT_5				/* Clear IRQ */
#define	POLL_CTRL_POLL_REQ				BIT_4				/* Poll Request */
#define	POLL_CTRL_OP_ON					BIT_3				/* Operational On */
#define	POLL_CTRL_OP_OFF				BIT_2				/* Operational Off */
#define	POLL_CTRL_POLL_RST_CLR			BIT_1				/* POLLU Reset Clear */
#define	POLL_CTRL_POLL_RST_SET			BIT_0				/* POLLU Reset Set */

/*	POLL_LAST_IDX		0x0E24	List Last Index Register */
/*		Bit(s) POLL_LAST_IDX_RSRV_31_1 reserved */
#define	POLL_LAST_IDX_BIT					BIT_0				/* List Last Index */

/*	POLL_LADR_LO		0x0E28	List Start Address Low Register */
/* List Start Address Low */
#define	POLL_LADR_LO_MSK				SHIFT3(0x1fffffff)	
#define	POLL_LADR_LO_BASE				3
/* List Start Address Low fixed */
#define	POLL_LADR_LO_VAL_FIX_MSK		SHIFT0(0x7)			
#define	POLL_LADR_LO_VAL_FIX_BASE		0

/*	POLL_LADR_HI		0x0E2C	List Start Address High Register */
#define	POLL_LADR_HI_MSK		SHIFT0(0xffffffff)	/* List Start Address High */
#define	POLL_LADR_HI_BASE		0

/*	CPU_ISRC			0x0E30	Interrupt Source Register */
/*		Bit(s) CPU_ISRC_RSRV_25_0 reserved */
#define	CPU_ISRC_CPU				BIT_5				/* CPU Interrupt */
#define	CPU_ISRC_TIM				BIT_4				/* Timer Interrupt */
#define	CPU_ISRC_SMB				BIT_3				/* SMBus Interrupt */
#define	CPU_ISRC_RX					BIT_2				/* ASF Rx Queue Interrupt */
#define	CPU_ISRC_TX					BIT_1				/* ASF Tx Queue Interrupt */
/* Host Communication Unit Interrupt */
#define	CPU_ISRC_HCU				BIT_0				

/*	CPU_IMSK			0x0E34	Interrupt Mask Register */
/*		Bit(s) CPU_IMSK_RSRV_9_0 reserved */
#define	CPU_IMSK_FIQ_CPU			BIT_21			/* CPU Interrupt mapped to FIQ */
#define	CPU_IMSK_FIQ_TIM			BIT_20			/* TIM Interrupt mapped to FIQ */
#define	CPU_IMSK_FIQ_SMB			BIT_19			/* SMB Interrupt mapped to FIQ */
#define	CPU_IMSK_FIQ_RX				BIT_18			/* RX Interrupt mapped to FIQ */
#define	CPU_IMSK_FIQ_TX				BIT_17			/* TX Interrupt mapped to FIQ */
#define	CPU_IMSK_FIQ_HCU			BIT_16			/* HCU Interrupt mapped to FIQ */
/*		Bit(s) CPU_IMSK_RSRV_9_0 reserved */
#define	CPU_IMSK_IRQ_CPU			BIT_5			/* CPU Interrupt mapped to IRQ */
#define	CPU_IMSK_IRQ_TIM			BIT_4			/* TIM Interrupt mapped to IRQ */
#define	CPU_IMSK_IRQ_SMB			BIT_3			/* SMB Interrupt mapped to IRQ */
#define	CPU_IMSK_IRQ_RX				BIT_2			/* RX Interrupt mapped to IRQ */
#define	CPU_IMSK_IRQ_TX				BIT_1			/* TX Interrupt mapped to IRQ */
#define	CPU_IMSK_IRQ_HCU			BIT_0			/* HCU Interrupt mapped to IRQ */

/*	SMB_CFG				0x0E40	SMBus Config Register */
#define	SMB_CFG_PS_MSK			SHIFT30(0x3)	/* SMBPS */
#define	SMB_CFG_PS_BASE			BIT_30
#define	SMB_CFG_CSE				BIT_29			/* SMBCSE */
#define	SMB_CFG_BR_MSK			SHIFT16(0x1fff)	/* SMBBR */
#define	SMB_CFG_BR_BASE			BIT_16
#define	SMB_CFG_SADDR_MSK		SHIFT9(0x7f)	/* SMBSlaveAddr */
#define	SMB_CFG_SADDR_BASE		BIT_9
#define	SMB_CFG_SADDR_ENA		BIT_8			/* SMBSAE */
#define	SMB_CFG_DADDR_ENA		BIT_7			/* SMBDAE */
#define	SMB_CFG_GC_ENA			BIT_6			/* SMBGCE */
#define	SMB_CFG_ACK_ENA			BIT_5			/* SMBEA */
#define	SMB_CFG_IRQ_ENA			BIT_4			/* SMBIE */
#define	SMB_CFG_OP_ON			BIT_3			/* Operational On */
#define	SMB_CFG_OP_OFF			BIT_2			/* Operational Off */
#define	SMB_CFG_RST_CLR			BIT_1			/* SMBus Reset Clear */
#define	SMB_CFG_RST_SET			BIT_0			/* SMBus Reset Set */

/*	SMB_CSR				0x0E44	SMBus Control/Status Register */
#define	SMB_CSR_AL					BIT_31			/* SMBAL */
#define	SMB_CSR_RX_ACK				BIT_30			/* SMBRxACK */
#define	SMB_CSR_RX_FULL				BIT_29			/* SMBRxFull */
#define	SMB_CSR_TX_EMPTY			BIT_28			/* SMBTxEmpty */
#define	SMB_CSR_TX_DONE				BIT_27			/* SMBTxDone */
#define	SMB_CSR_STOP				BIT_26			/* SMBSTOP */
#define	SMB_CSR_IF					BIT_25			/* SMBIF */
#define	SMB_CSR_RX_STRT				BIT_24			/* SMBRxSTA */
#define	SMB_CSR_TIP					BIT_23			/* SMBTIP */
#define	SMB_CSR_BUSY				BIT_22			/* SMBBusy */
#define	SMB_CSR_SPEEDUP				BIT_21			/* SMBUS Timer SpeedUp */
#define	SMB_CSR_ALERT				BIT_20			/* SMBALERT */
#define	SMB_CSR_TX_CLR				BIT_19			/* SMBTxCLR */
#define	SMB_CSR_TX					BIT_18			/* SMBTx */
#define	SMB_CSR_TX_STOP				BIT_17			/* SMBTxSTO */
#define	SMB_CSR_TX_STRT				BIT_16			/* SMBTxSTA */
#define	SMB_CSR_RX_DATA_MSK			SHIFT8(0xff)	/* SMBRxData */
#define	SMB_CSR_RX_DATA_BASE		BIT_8
#define	SMB_CSR_TX_DATA_MSK			SHIFT0(0xff)	/* SMBTxData */
#define	SMB_CSR_TX_DATA_BASE		BIT_0

/*	CPU_WDOG			0x0E48	Watchdog Register */
#define	CPU_WDOG_MSK		SHIFT0(0xffffffff)	/* Watchdog */
#define	CPU_WDOG_BASE		BIT_0

/*	CPU_CNTR			0x0E4C	Counter Register */
#define	CPU_CNTR_MSK		SHIFT0(0xffffffff)	/* Counter */
#define	CPU_CNTR_BASE		BIT_0

/*	CPU_TIM				0x0E50	Timer Compare Register */
#define	CPU_TIM_MSK			SHIFT0(0xffffffff)	/* Timer Compare */
#define	CPU_TIM_BASE		BIT_0

/*	CPU_AHB_ADDR		0x0E54	CPU AHB Debug Register */
#define	CPU_AHB_ADDR_MSK		SHIFT0(0xffffffff)	/* Probe AHB address */
#define	CPU_AHB_ADDR_BASE		BIT_0

/*	CPU_AHB_WDATA		0x0E58	CPU AHB Debug Register */
#define	CPU_AHB_WDATA_MSK		SHIFT0(0xffffffff)	/* Probe AHB wdata */
#define	CPU_AHB_WDATA_BASE		BIT_0

/*	CPU_AHB_RDATA		0x0E5C	CPU AHB Debug Register */
#define	CPU_AHB_RDATA_MSK		SHIFT0(0xffffffff)	/* Probe AHB rdata */
#define	CPU_AHB_RDATA_BASE		BIT_0

/*	HCU_MAP_BASE		0x0E60	Reset Mapping Base */
#define	HCU_MAP_BASE_MSK				SHIFT12(0xfffff)	/* MAPBASE */
#define	HCU_MAP_BASE_BASE				BIT_12
/*		Bit(s) HCU_MAP_BASE_RSRV_11_0 reserved */

/*	CPU_AHB_CTRL		0x0E64	CPU AHB Debug Register */
/* Embedded CPU SRAM Write setting */
#define	CPU_AHB_CTRL_SRAM_WTC1				BIT_31			
#define	CPU_AHB_CTRL_TDO					BIT_30			/* tdo */
#define	CPU_AHB_CTRL_TMS					BIT_29			/* tms */
#define	CPU_AHB_CTRL_TDI					BIT_28			/* tdi */
#define	CPU_AHB_CTRL_TRST					BIT_27			/* trst */
#define	CPU_AHB_CTRL_TCLK					BIT_26			/* tclk */
#define	CPU_AHB_CTRL_SET_JTAG_TEST_MSK		SHIFT24(0x3)	/* CPU's JTAG testmode */
#define	CPU_AHB_CTRL_SET_JTAG_TEST_BASE		BIT_24
/* Embedded CPU SRAM Read setting */
#define	CPU_AHB_CTRL_SRAM_RTC1				BIT_23			
/* Embedded CPU SRAM Write setting */
#define	CPU_AHB_CTRL_SRAM_WTC2_MSK			SHIFT21(0x3)	
#define	CPU_AHB_CTRL_SRAM_WTC2_BASE			BIT_21
/*		Bit(s) CPU_AHB_CTRL_RSRV_ reserved */
#define	CPU_AHB_CTRL_FCE_HRESP_MSK			SHIFT18(0x3)	/* Force AHB HRESP */
#define	CPU_AHB_CTRL_FCE_HRESP_BASE			BIT_18
#define	CPU_AHB_CTRL_FCE_HRDY				BIT_17			/* Force AHB HREADY */
/* Enable force AHB response */
#define	CPU_AHB_CTRL_FCE_RESP_EN			BIT_16			
/* Embedded CPU SRAM read setting */
#define	CPU_AHB_CTRL_SRAM_RTC2_MSK			SHIFT14(0x3)	
#define	CPU_AHB_CTRL_SRAM_RTC2_BASE			BIT_14
/*		Bit(s) CPU_AHB_CTRL_RSRV_ reserved */
#define	CPU_AHB_CTRL_PRB_HBURST_MSK			SHIFT10(0x7)	/* Probe AHB HBURST */
#define	CPU_AHB_CTRL_PRB_HBURST_BASE		BIT_10
#define	CPU_AHB_CTRL_PRB_HSIZE_MSK			SHIFT7(0x7)		/* Probe AHB HSIZE */
#define	CPU_AHB_CTRL_PRB_HSIZE_BASE			BIT_7
#define	CPU_AHB_CTRL_PRB_HTRANS_MSK			SHIFT5(0x3)		/* Probe AHB HTRANS */
#define	CPU_AHB_CTRL_PRB_HTRANS_BASE		BIT_5
#define	CPU_AHB_CTRL_PRB_HBUSREQ			BIT_4			/* Probe AHB HBUSREQ */
#define	CPU_AHB_CTRL_PRB_HRESP_MSK			SHIFT2(0x3)		/* Probe AHB HRESP */
#define	CPU_AHB_CTRL_PRB_HRESP_BASE			BIT_2
#define	CPU_AHB_CTRL_PRB_HRDY				BIT_1			/* Probe AHB HREADY */
#define	CPU_AHB_CTRL_PRB_HCLK				BIT_0			/* Probe AHB HCLK */

/*	HCU_CCSR			0x0E68	CPU Control and Status Register */
/*		Bit(s) HCU_CCSR_RSRV_3_0 reserved */
#define	HCU_CCSR_SMBALERT_MONITOR			BIT_27			/* SMBALERT pin monitor */
#define	HCU_CCSR_CPU_SLEEP					BIT_26			/* CPU sleep status */
/* Clock Stretching Timeout */
#define	HCU_CCSR_CS_TO						BIT_25			
#define	HCU_CCSR_WDOG						BIT_24			/* Watchdog Reset */
/*		Bit(s) HCU_CCSR_RSRV_5_0 reserved */
#define	HCU_CCSR_CLR_IRQ_HOST				BIT_17			/* Clear IRQ_HOST */
#define	HCU_CCSR_SET_IRQ_HCU				BIT_16			/* Set IRQ_HCU */
/*		Bit(s) HCU_CCSR_RSRV_3_0 reserved */
#define	HCU_CCSR_ARM_MRVL_ID				BIT_11			/* ARM MRVL ID */
/* Enable ARM ITCM after CPU reset */
#define	HCU_CCSR_EN_ARM_ITCM				BIT_10			
#define	HCU_CCSR_AHB_RST					BIT_9			/* Reset AHB bridge */
#define	HCU_CCSR_CPU_RST_MODE				BIT_8			/* CPU Reset Mode */
/*		Bit(s) HCU_CCSR_RSRV_1_0 reserved */
/* Enable Sync datapath inside AHB bridge */
#define	HCU_CCSR_SET_SYNC_CPU				BIT_5			
#define	HCU_CCSR_CPU_CLK_DIVIDE_MSK			SHIFT3(0x3)		/* CPU Clock Divide */
#define	HCU_CCSR_CPU_CLK_DIVIDE_BASE		BIT_3
#define	HCU_CCSR_OS_PRSNT					BIT_2			/* ASF OS Present */
/* Microcontroller State */
#define	HCU_CCSR_UC_STATE_MSK				SHIFT0(0x3)		
#define	HCU_CCSR_UC_STATE_BASE				BIT_0

/*
 * manually defined, needed, do not remove (MA)
 */
#define HCU_CCSR_ASF_RESET					0
#define HCU_CCSR_ASF_RUNNING				BIT_0
#define HCU_CCSR_ASF_HALTED					BIT_1

/*	HCU_HCSR			0x0E6C	Host Control and Status Register */
/*		Bit(s) HCU_HCSR_RSRV_14_0 reserved */
#define	HCU_HCSR_SET_IRQ_CPU		BIT_16			/* Set IRQ_CPU */
/*		Bit(s) HCU_HCSR_RSRV_13_0 reserved */
#define	HCU_HCSR_CLR_IRQ_HCU		BIT_1			/* Clear IRQ_HCU */
#define	HCU_HCSR_SET_IRQ_HOST		BIT_0			/* Set IRQ_HOST */

/*	HCU_DATA1			0x0E70	Data Register 1 */
#define	HCU_DATA1_MSK		SHIFT0(0xffffffff)	/* DATA1 */
#define	HCU_DATA1_BASE		BIT_0

/*	HCU_DATA2			0x0E74	Data Register 2 */
#define	HCU_DATA2_MSK		SHIFT0(0xffffffff)	/* DATA2 */
#define	HCU_DATA2_BASE		BIT_0

/*	HCU_DATA3			0x0E78	Data Register 3 */
#define	HCU_DATA3_MSK		SHIFT0(0xffffffff)	/* DATA3 */
#define	HCU_DATA3_BASE		BIT_0

/*	HCU_DATA4			0x0E7C	Data Register 4 */
#define	HCU_DATA4_MSK		SHIFT0(0xffffffff)	/* DATA4 */
#define	HCU_DATA4_BASE		BIT_0

/*	STAT_CTRL			0x0E80	Status BMU Control Register */
/*		Bit(s) STAT_CTRL_RSRV_31_19 reserved */
/* Master Request Loopback Test On */
#define	STAT_CTRL_MST_REQ_LPBK_ON		BIT_18			
/* Master Request Loopback Test Off */
#define	STAT_CTRL_MST_REQ_LPBK_OFF		BIT_17			
/* Master Request Loopback Step */
#define	STAT_CTRL_MST_REQ_LPBK_STEP		BIT_16			
/*		Bit(s) STAT_CTRL_RSRV_15 reserved */
/* FIFO Read Pointer Test On */
#define	STAT_CTRL_RPTR_TEST_ON			BIT_14			
/* FIFO Read Pointer Test Off */
#define	STAT_CTRL_RPTR_TEST_OFF			BIT_13			
#define	STAT_CTRL_RPTR_TEST_STEP		BIT_12			/* FIFO Read Pointer Step */
/*		Bit(s) STAT_CTRL_RSRV_11 reserved */
/* FIFO Write Pointer Test On */
#define	STAT_CTRL_WPTR_TEST_ON			BIT_10			
/* FIFO Write Pointer Test Off */
#define	STAT_CTRL_WPTR_TEST_OFF			BIT_9			
#define	STAT_CTRL_WPTR_TEST_STEP		BIT_8			/* FIFO Write Pointer Step */
/*		Bit(s) STAT_CTRL_RSRV_7_5 reserved */
#define	STAT_CTRL_CLR_IRQ_STAT			BIT_4			/* Clear IRQ Status BMU */
#define	STAT_CTRL_OP_ON					BIT_3			/* Operational On */
#define	STAT_CTRL_OP_OFF				BIT_2			/* Operational Off */
#define	STAT_CTRL_ENA					BIT_1			/* Enable */
#define	STAT_CTRL_RST					BIT_0			/* Reset */

/*	STAT_LAST_IDX		0x0E84	Last Index Register */
/*		Bit(s) STAT_LAST_IDX_RSRV_31_12 reserved */
#define	STAT_LAST_IDX_MSK					SHIFT2(0x3ff)		/* Last Index */
#define	STAT_LAST_IDX_BASE					2
#define	STAT_LAST_IDX_VAL_FIX_MSK			SHIFT0(0x3)			/* Last Index Fix */
#define	STAT_LAST_IDX_VAL_FIX_BASE			0

/*	STAT_LADR_LO		0x0E88	List Start Address Lower Register */
/* List Start Address Lo */
#define	STAT_LADR_LO_MSK				SHIFT5(0x7ffffff)	
#define	STAT_LADR_LO_BASE				5
/* List Start Address Lo Fix */
#define	STAT_LADR_LO_VAL_FIX_MSK		SHIFT0(0x1f)		
#define	STAT_LADR_LO_VAL_FIX_BASE		0

/*	STAT_LADR_HI		0x0E8C	List Start Address Upper Register */
#define	STAT_LADR_HI_MSK		SHIFT0(0xffffffff)	/* List Start Address Hi */
#define	STAT_LADR_HI_BASE		0

/*	STAT_TXA_REP		0x0E90	TXA Report Index Register */
/*		Bit(s) STAT_TXA_REP_RSRV_15_12 reserved */
#define	STAT_TXA_REP_MSK					SHIFT0(0xfffU)	/* TXA Report Index */
#define	STAT_TXA_REP_BASE					0

/*	STAT_TXTH			0x0E98	TX Index Threshold Register */
/*		Bit(s) STAT_TXTH_RSRV_15_12 reserved */
#define	STAT_TXTH_MSK					SHIFT0(0xfffU)	/* TX Index Threshold */
#define	STAT_TXTH_BASE					0

/*	STAT_PUT			0x0E9C	Put Index Register */
/*		Bit(s) STAT_PUT_RSRV_31_12 reserved */
#define	STAT_PUT_MSK					SHIFT0(0xfff)		/* Put Index */
#define	STAT_PUT_BASE					0

/*	STAT_FIFO_WPTR		0x0EA0	FIFO Write Pointer Register */
/*		Bit(s) STAT_FIFO_WPTR_RSRV_31_5 reserved */
/* FIFO Write Pointer */
#define	STAT_FIFO_WPTR_MSK					SHIFT0(0x1f)		
#define	STAT_FIFO_WPTR_BASE					0

/*	STAT_FIFO_RPTR		0x0EA4	FIFO Read Pointer Register */
/*		Bit(s) STAT_FIFO_RPTR_RSRV_31_21 reserved */
#define	STAT_FIFO_RPTR_WSPTR_MSK			SHIFT16(0x1f)	/* FIFO Rd Shadow Ptr */
#define	STAT_FIFO_RPTR_WSPTR_BASE			16
/*		Bit(s) STAT_FIFO_RPTR_RSRV_15_5 reserved */
#define	STAT_FIFO_RPTR_MSK					SHIFT0(0x1f)	/* FIFO Read Pointer */
#define	STAT_FIFO_RPTR_BASE					0

/*	STAT_FIFO_LEV		0x0EA8	FIFO Level Register */
/*		Bit(s) STAT_FIFO_LEV_RSRV_31_21 reserved */
#define	STAT_FIFO_LEV_SLEV_MSK				SHIFT16(0x1f)	/* FIFO Shadow Level */
#define	STAT_FIFO_LEV_SLEV_BASE				16
/*		Bit(s) STAT_FIFO_LEV_RSRV_15_5 reserved */
#define	STAT_FIFO_LEV_MSK					SHIFT0(0x1f)	/* FIFO Level */
#define	STAT_FIFO_LEV_BASE					0

/*	STAT_FIFO_WM		0x0EAC	FIFO Watermark Register */
/*		Bit(s) STAT_FIFO_WM_RSRV_7_5 reserved */
#define	STAT_FIFO_WM_MSK				SHIFT0(0x1fU)	/* FIFO Watermark */
#define	STAT_FIFO_WM_BASE				0

/*	STAT_FIFO_WM_ISR	0x0EAD	FIFO ISR Watermark Register */
/*		Bit(s) STAT_FIFO_WM_ISR_RSRV_7_5 reserved */
#define	STAT_FIFO_WM_ISR_MSK				SHIFT0(0x1fU)	/* FIFO ISR Watermark */
#define	STAT_FIFO_WM_ISR_BASE				0

/*	LEV_TIM_INIT		0x0EB0	Level Timer Init Value Register */
#define	LEV_TIM_INIT_MSK		SHIFT0(0xffffffff)	/* Level Timer Init Value */
#define	LEV_TIM_INIT_BASE		0

/*	LEV_TIM_CNT			0x0EB4	Level Timer Counter Register */
#define	LEV_TIM_CNT_MSK			SHIFT0(0xffffffff)	/* Level Timer */
#define	LEV_TIM_CNT_BASE		0

/*	LEV_TIM_TCTL		0x0EB8	Level Timer Control/Test Register */
/*		Bit(s) LEV_TIM_TCTL_RSRV_31_11 reserved */
/* Level Timer Test On */
#define	LEV_TIM_TCTL_TST_ON					BIT_10				
/* Level Timer Test Off */
#define	LEV_TIM_TCTL_TST_OFF				BIT_9				
#define	LEV_TIM_TCTL_STEP					BIT_8				/* Level Timer Step */
/*		Bit(s) LEV_TIM_TCTL_RSRV_7_3 reserved */
/* Level Timer Start */
#define	LEV_TIM_TCTL_STRT					BIT_2				
#define	LEV_TIM_TCTL_STOP					BIT_1				/* Level Timer Stop */
/*		Bit(s) LEV_TIM_TCTL_RSRV_0 reserved */

/*	TX_TIM_INIT			0x0EC0	TX TImer Init Value Register */
#define	TX_TIM_INIT_MSK			SHIFT0(0xffffffff)	/* TX Timer Init Value */
#define	TX_TIM_INIT_BASE		0

/*	TX_TIM_CNT			0x0EC4	TX Timer Counter Register */
#define	TX_TIM_CNT_MSK		SHIFT0(0xffffffff)	/* TX Timer */
#define	TX_TIM_CNT_BASE		0

/*	TX_TIM_TCTL			0x0EC8	TX Timer Control/Test Register */
/*		Bit(s) TX_TIM_TCTL_RSRV_31_11 reserved */
#define	TX_TIM_TCTL_TST_ON				BIT_10				/* TX Timer Test On */
#define	TX_TIM_TCTL_TST_OFF				BIT_9				/* TX Timer Test Off */
#define	TX_TIM_TCTL_STEP				BIT_8				/* TX Timer Step */
/*		Bit(s) TX_TIM_TCTL_RSRV_1_0 reserved */
/* Deviation 5.4 fix enable */
#define	TX_TIM_TCTL_ON					BIT_5				
/* Deviation 5.4 fix enable */
#define	TX_TIM_TCTL_OFF					BIT_4				
/*		Bit(s) TX_TIM_TCTL_RSRV_3 reserved */
#define	TX_TIM_TCTL_STRT				BIT_2				/* TX Timer Start */
#define	TX_TIM_TCTL_STOP				BIT_1				/* TX Timer Stop */
/*		Bit(s) TX_TIM_TCTL_RSRV_0 reserved */

/*	ISR_TIM_INIT		0x0ED0	ISR Timer Init Value Register */
#define	ISR_TIM_INIT_MSK		SHIFT0(0xffffffff)	/* ISR Timer Init Value */
#define	ISR_TIM_INIT_BASE		0

/*	ISR_TIM_CNT			0x0ED4	ISR Timer Counter Register */
#define	ISR_TIM_CNT_MSK			SHIFT0(0xffffffff)	/* ISR Timer */
#define	ISR_TIM_CNT_BASE		0

/*	ISR_TIM_TCTL		0x0ED8	ISR Timer Control/Test Register */
/*		Bit(s) ISR_TIM_TCTL_RSRV_31_11 reserved */
/* ISR Timer Test On */
#define	ISR_TIM_TCTL_TST_ON					BIT_10				
/* ISR Timer Test Off */
#define	ISR_TIM_TCTL_TST_OFF				BIT_9				
#define	ISR_TIM_TCTL_STEP					BIT_8				/* ISR Timer Step */
/*		Bit(s) ISR_TIM_TCTL_RSRV_7_3 reserved */
#define	ISR_TIM_TCTL_STRT					BIT_2				/* ISR Timer Start */
#define	ISR_TIM_TCTL_STOP					BIT_1				/* ISR Timer Stop */
/*		Bit(s) ISR_TIM_TCTL_RSRV_0 reserved */

/*	MAC_CTRL			0x0F00	MAC Control Registers */
#define	MAC_CTRL_MAC_SEC_RST			BIT_15S			/* MAC SEC RST */
#define	MAC_CTRL_MAC_SEC_RST_OFF		BIT_14S			/* MAC SEC RSt OFF */
#define	MAC_CTRL_BYP_MACSECRX_ON		BIT_13S			/* Bypass macsec RX */
#define	MAC_CTRL_BYP_MACSECRX_OFF		BIT_12S			/* Bypass macsec RX off */
#define	MAC_CTRL_BYP_MACSECTX_ON		BIT_11S			/* Bypass macsec TX */
#define	MAC_CTRL_BYP_MACSECTX_OFF		BIT_10S			/* Bypass macsec TX off */
#define	MAC_CTRL_BYP_RETR_ON			BIT_9S			/* Bypass retransmit fifo */
#define	MAC_CTRL_BYP_RETR_OFF			BIT_8S			/* Bypass retransmit fifo off */
#define	MAC_CTRL_BURST_ON				BIT_7S			/* En Burstmode On */
#define	MAC_CTRL_BURST_OFF				BIT_6S			/* En Burstmode Off */
#define	MAC_CTRL_LPBK_ON				BIT_5S			/* Loopback On */
#define	MAC_CTRL_LPBK_OFF				BIT_4S			/* Loopback Off */
#define	MAC_CTRL_PAUSE_ON				BIT_3S			/* En Pause On */
#define	MAC_CTRL_PAUSE_OFF				BIT_2S			/* En Pause Off */
#define	MAC_CTRL_RST_CLR				BIT_1S			/* GMAC Reset Clear */
#define	MAC_CTRL_RST_SET				BIT_0S			/* GMAC Reset Set */

/*	PHY_CFG				0x0F04	PHY Config Register, loaded from external
 *								memory
 */
#define	PHY_CFG_STAT_MSK				SHIFT24(0xff)	/* PHY Status */
#define	PHY_CFG_STAT_BASE				24
/* Internal Regulator 2.5 Power Down Enable */
#define	PHY_CFG_INT_REG_PD_ENA			BIT_23			
#define	PHY_CFG_TEST					BIT_22			/* Testmode */
#define	PHY_CFG_REG18_PD				BIT_21			/* Reg18 Power Down */
#define	PHY_CFG_REG12_SEL_MSK			SHIFT19(0x3)	/* Reg12 Sel */
#define	PHY_CFG_REG12_SEL_BASE			BIT_19
#define	PHY_CFG_REG18_SEL_MSK			SHIFT17(0x3)	/* Reg18 Sel */
#define	PHY_CFG_REG18_SEL_BASE			BIT_17
#define	PHY_CFG_SPI_LOCK				BIT_16			/* SPI Lock */
#define	PHY_CFG_CFG_LED_MUX_MSK			SHIFT14(0x3)	/* GPHY Config for LED Mux */
#define	PHY_CFG_CFG_LED_MUX_BASE		BIT_14
/* GPHY Config for Int Polarity */
#define	PHY_CFG_CFG_POL					BIT_13			
/* GPHY Config for Energy Detect */
#define	PHY_CFG_CFG_ERG_DET				BIT_12			
#define	PHY_CFG_CFG_1000				BIT_11			/* GPHY Config for 1000M/HD */
/* GPHY Config for Master/Slave */
#define	PHY_CFG_CFG_MST_SLV				BIT_10			
/* GPHY Config for Pause Enable */
#define	PHY_CFG_CFG_PAUSE				BIT_9			
#define	PHY_CFG_LED_CFG_MSK				SHIFT6(0x7)		/* GPHY LED Config */
#define	PHY_CFG_LED_CFG_BASE			BIT_6
/*		Bit(s) PHY_CFG_RSRV_3_0 reserved */
#define	PHY_CFG_RST_CLR					BIT_1			/* PHY Reset Clear */
#define	PHY_CFG_RST_SET					BIT_0			/* PHY Reset Set */

/*	MAC_ISRC			0x0F08	MAC Interrupt Source Register */
/*		Bit(s) MAC_ISRC_RSRV_31_6 reserved */
/* Receive Counter Overflow Interrupt */
#define	MAC_ISRC_RX_CNT_OF			BIT_5				
/* Transmit Counter Overflow Interrupt */
#define	MAC_ISRC_TX_CNT_OF			BIT_4				
#define	MAC_ISRC_TX_UR				BIT_3				/* Transmit FIFO Underrun */
/* Frame Transmission Complete */
#define	MAC_ISRC_TX_OK				BIT_2				
#define	MAC_ISRC_RX_OF				BIT_1				/* Receive FIFO Overrun */
#define	MAC_ISRC_RX_OK				BIT_0				/* Frame Reception Complete */

/*	MAC_IMSK			0x0F0C	MAC Interrupt Mask Register */
/*		Bit(s) MAC_IMSK_RSRV_31_6 reserved */
/* En IRQ Receive Counter Overflow Interrupt */
#define	MAC_IMSK_RX_CNT_OF			BIT_5				
/* En IRQ Transmit Counter Overflow Interrupt */
#define	MAC_IMSK_TX_CNT_OF			BIT_4				
/* En IRQ Transmit FIFO Underrun */
#define	MAC_IMSK_TX_UR				BIT_3				
/* En IRQ Frame Transmission Complete */
#define	MAC_IMSK_TX_OK				BIT_2				
/* En IRQ Receive FIFO Overrun */
#define	MAC_IMSK_RX_OF				BIT_1				
/* En IRQ Frame Reception Complete */
#define	MAC_IMSK_RX_OK				BIT_0				

/*	LINK_CTRL			0x0F10	Link Control Register */
/*		Bit(s) LINK_CTRL_RSRV_15_2 reserved */
#define	LINK_CTRL_RST_CLR				BIT_1S			/* Link Reset Clear */
#define	LINK_CTRL_RST_SET				BIT_0S			/* Link Reset Set */

/*	WOL_CSR				0x0F20	WOL Control/Status Register */
#define	WOL_CSR_LC_STAT			BIT_15S	/* Link Up Status */
#define	WOL_CSR_MP_STAT			BIT_14S	/* Magic Pattern Status */
#define	WOL_CSR_WF_STAT			BIT_13S	/* Wake up Frame Status */
#define	WOL_CSR_CLR_RSLT		BIT_12S	/* Clear Match Result */
#define	WOL_CSR_LC_PME_ENA		BIT_11S	/* Enable PME on Link Up */
#define	WOL_CSR_LC_PME_DIS		BIT_10S	/* Disable PME on Link Up */
#define	WOL_CSR_MP_PME_ENA		BIT_9S	/* Enable PME on Magic Pattern */
#define	WOL_CSR_MP_PME_DIS		BIT_8S	/* Disable PME on Magic Pattern */
#define	WOL_CSR_WF_PME_ENA		BIT_7S	/* Enable PME on Wake up Frame */
#define	WOL_CSR_WF_PME_DIS		BIT_6S	/* Disable PME on Wake up Frame */
#define	WOL_CSR_LC_ENA			BIT_5S	/* Enable Link Up Unit */
#define	WOL_CSR_LC_DIS			BIT_4S	/* Disable Link Up Unit */
#define	WOL_CSR_MP_ENA			BIT_3S	/* Enable Magic Pattern Unit */
#define	WOL_CSR_MP_DIS			BIT_2S	/* Disable Magic Pattern Unit */
#define	WOL_CSR_WF_ENA			BIT_1S	/* Enable Pattern Match Unit */
#define	WOL_CSR_WF_DIS			BIT_0S	/* Disable Pattern Match Unit */

/*	WOL_MCTRL			0x0F22	Match Control Register */
/*		Bit(s) WOL_MCTRL_RSRV_15_9 reserved */
#define	WOL_MCTRL_P8_ENA			BIT_8S			/* Pattern 8 Enable */
#define	WOL_MCTRL_P7_ENA			BIT_7S			/* Pattern 7 Enable */
#define	WOL_MCTRL_P6_ENA			BIT_6S			/* Pattern 6 Enable */
#define	WOL_MCTRL_P5_ENA			BIT_5S			/* Pattern 5 Enable */
#define	WOL_MCTRL_P4_ENA			BIT_4S			/* Pattern 4 Enable */
#define	WOL_MCTRL_P3_ENA			BIT_3S			/* Pattern 3 Enable */
#define	WOL_MCTRL_P2_ENA			BIT_2S			/* Pattern 2 Enable */
#define	WOL_MCTRL_P1_ENA			BIT_1S			/* Pattern 1 Enable */
#define	WOL_MCTRL_P0_ENA			BIT_0S			/* Pattern 0 Enable */

/*	WOL_MADDR_LO		0x0F24	MAC Address Register Low Register */
#define	WOL_MADDR_LO_MAC_3_MSK		SHIFT24(0xff)	/* MAC<3> */
#define	WOL_MADDR_LO_MAC_3_BASE		24
#define	WOL_MADDR_LO_MAC_2_MSK		SHIFT16(0xff)	/* MAC<2> */
#define	WOL_MADDR_LO_MAC_2_BASE		16
#define	WOL_MADDR_LO_MAC_1_MSK		SHIFT8(0xff)	/* MAC<1> */
#define	WOL_MADDR_LO_MAC_1_BASE		8
#define	WOL_MADDR_LO_MAC_0_MSK		SHIFT0(0xff)	/* MAC<0> */
#define	WOL_MADDR_LO_MAC_0_BASE		0

/*	WOL_MADDR_HI		0x0F28	MAC Address Register High Register */
#define	WOL_MADDR_HI_MAC_5_MSK		SHIFT8(0xffU)	/* MAC<5> */
#define	WOL_MADDR_HI_MAC_5_BASE		8
#define	WOL_MADDR_HI_MAC_4_MSK		SHIFT0(0xffU)	/* MAC<4> */
#define	WOL_MADDR_HI_MAC_4_BASE		0

/*	WOL_PME_MEN			0x0F2A	PME Match Enable Register */
#define	WOL_PME_MEN_FRC_PME				BIT_15S			/* Force PME */
/*		Bit(s) WOL_PME_MEN_RSRV_14_6 reserved */
#define	WOL_PME_MEN_P8_PME_ENA			BIT_8S			/* PME 8 Enable */
#define	WOL_PME_MEN_P7_PME_ENA			BIT_7S			/* PME 7 Enable */
#define	WOL_PME_MEN_P6_PME_ENA			BIT_6S			/* PME 6 Enable */
#define	WOL_PME_MEN_P5_PME_ENA			BIT_5S			/* PME 5 Enable */
#define	WOL_PME_MEN_P4_PME_ENA			BIT_4S			/* PME 4 Enable */
#define	WOL_PME_MEN_P3_PME_ENA			BIT_3S			/* PME 3 Enable */
#define	WOL_PME_MEN_P2_PME_ENA			BIT_2S			/* PME 2 Enable */
#define	WOL_PME_MEN_P1_PME_ENA			BIT_1S			/* PME 1 Enable */
#define	WOL_PME_MEN_P0_PME_ENA			BIT_0S			/* PME 0 Enable */

/*	WOL_ASF_MEN			0x0F2C	ASF Match Enable Register */
/*		Bit(s) WOL_ASF_MEN_RSRV_15_9 reserved */
#define	WOL_ASF_MEN_P8_ASF_ENA			BIT_8S			/* ASF 8 Enable */
#define	WOL_ASF_MEN_P7_ASF_ENA			BIT_7S			/* ASF 7 Enable */
#define	WOL_ASF_MEN_P6_ASF_ENA			BIT_6S			/* ASF 6 Enable */
#define	WOL_ASF_MEN_P5_ASF_ENA			BIT_5S			/* ASF 5 Enable */
#define	WOL_ASF_MEN_P4_ASF_ENA			BIT_4S			/* ASF 4 Enable */
#define	WOL_ASF_MEN_P3_ASF_ENA			BIT_3S			/* ASF 3 Enable */
#define	WOL_ASF_MEN_P2_ASF_ENA			BIT_2S			/* ASF 2 Enable */
#define	WOL_ASF_MEN_P1_ASF_ENA			BIT_1S			/* ASF 1 Enable */
#define	WOL_ASF_MEN_P0_ASF_ENA			BIT_0S			/* ASF 0 Enable */

/*	WOL_MRSL			0x0F2E	Match Result Register */
/*		Bit(s) WOL_MRSL_RSRV_15_9 reserved */
#define	WOL_MRSL_P8_MATCH			BIT_8S			/* Pattern 8 Match */
#define	WOL_MRSL_P7_MATCH			BIT_7S			/* Pattern 7 Match */
#define	WOL_MRSL_P6_MATCH			BIT_6S			/* Pattern 6 Match */
#define	WOL_MRSL_P5_MATCH			BIT_5S			/* Pattern 5 Match */
#define	WOL_MRSL_P4_MATCH			BIT_4S			/* Pattern 4 Match */
#define	WOL_MRSL_P3_MATCH			BIT_3S			/* Pattern 3 Match */
#define	WOL_MRSL_P2_MATCH			BIT_2S			/* Pattern 2 Match */
#define	WOL_MRSL_P1_MATCH			BIT_1S			/* Pattern 1 Match */
#define	WOL_MRSL_P0_MATCH			BIT_0S			/* Pattern 0 Match */

/*	WOL_PLEN0			0x0F30	Pattern Length Register 0 (0-3) */
/*		Bit(s) WOL_PLEN0_RSRV_31 reserved */
#define	WOL_PLEN0_P3_LEN_MSK		SHIFT24(0x7f)	/* Pattern 3 Length */
#define	WOL_PLEN0_P3_LEN_BASE		24
/*		Bit(s) WOL_PLEN0_RSRV_23 reserved */
#define	WOL_PLEN0_P2_LEN_MSK		SHIFT16(0x7f)	/* Pattern 2 Length */
#define	WOL_PLEN0_P2_LEN_BASE		16
/*		Bit(s) WOL_PLEN0_RSRV_15 reserved */
#define	WOL_PLEN0_P1_LEN_MSK		SHIFT8(0x7f)	/* Pattern 1 Length */
#define	WOL_PLEN0_P1_LEN_BASE		8
/*		Bit(s) WOL_PLEN0_RSRV_7 reserved */
#define	WOL_PLEN0_P0_LEN_MSK		SHIFT0(0x7f)	/* Pattern 0 Length */
#define	WOL_PLEN0_P0_LEN_BASE		0

/*	WOL_PLEN1			0x0F34	Pattern Length Register 1 (4-7) */
/*		Bit(s) WOL_PLEN1_RSRV_31_15 reserved */
#define	WOL_PLEN1_P5_LEN_MSK			SHIFT8(0x7f)		/* Pattern 5 Length */
#define	WOL_PLEN1_P5_LEN_BASE			8
/*		Bit(s) WOL_PLEN1_RSRV_7 reserved */
#define	WOL_PLEN1_P4_LEN_MSK			SHIFT0(0x7f)		/* Pattern 4 Length */
#define	WOL_PLEN1_P4_LEN_BASE			0

/*	WOL_PLEN2			0x0F38	Pattern Length Register 2 (8) */
/*		Bit(s) WOL_PLEN2_RSRV_31_0 reserved */

/*	WOL_PCNT0			0x0F40	Pattern Counter Register 0 (0-3) */
/*		Bit(s) WOL_PCNT0_RSRV_31 reserved */
#define	WOL_PCNT0_P3_CNTR_MSK		SHIFT24(0x7f)	/* Pattern 3 Counter */
#define	WOL_PCNT0_P3_CNTR_BASE		24
/*		Bit(s) WOL_PCNT0_RSRV_23 reserved */
#define	WOL_PCNT0_P2_CNTR_MSK		SHIFT16(0x7f)	/* Pattern 2 Counter */
#define	WOL_PCNT0_P2_CNTR_BASE		16
/*		Bit(s) WOL_PCNT0_RSRV_15 reserved */
#define	WOL_PCNT0_P1_CNTR_MSK		SHIFT8(0x7f)	/* Pattern 1 Counter */
#define	WOL_PCNT0_P1_CNTR_BASE		8
/*		Bit(s) WOL_PCNT0_RSRV_7 reserved */
#define	WOL_PCNT0_P0_CNTR_MSK		SHIFT0(0x7f)	/* Pattern 0 Counter */
#define	WOL_PCNT0_P0_CNTR_BASE		0

/*	WOL_PCNT1			0x0F44	Pattern Counter Register 1 (4-7) */
/*		Bit(s) WOL_PCNT1_RSRV_31_16 reserved */
/*		Bit(s) WOL_PCNT1_RSRV_15 reserved */
#define	WOL_PCNT1_P7_CNTR_BASE		BIT_24
/*		Bit(s) WOL_PCNT1_RSRV_ reserved */
#define	WOL_PCNT1_P6_CNTR_MSK		SHIFT16(0x7f)	/* Pattern 6 Counter */
#define	WOL_PCNT1_P6_CNTR_BASE		BIT_16
/*		Bit(s) WOL_PCNT1_RSRV_ reserved */
#define	WOL_PCNT1_P5_CNTR_MSK			SHIFT8(0x7f)	/* Pattern 5 Counter */
#define	WOL_PCNT1_P5_CNTR_BASE			8
/*		Bit(s) WOL_PCNT1_RSRV_7 reserved */
#define	WOL_PCNT1_P4_CNTR_MSK			SHIFT0(0x7f)	/* Pattern 4 Counter */
#define	WOL_PCNT1_P4_CNTR_BASE			0

/*	WOL_PCNT2			0x0F48	Pattern Counter Register 2 (8) */
/*		Bit(s) WOL_PCNT2_RSRV_31_1 reserved */
#define	WOL_PCNT2_P8_CNTR_MSK			SHIFT0(0x7f)		/* Pattern 8 Counter */
#define	WOL_PCNT2_P8_CNTR_BASE			BIT_0

/*	PAT_CSR				0x0F50	Pattern RAM Control/Status Register */
/*		Bit(s) PAT_CSR_RSRV_31_23 reserved */
#define	PAT_CSR_RPTR_MSK			SHIFT16(0x7f)	/* Pattern Read Pointer */
#define	PAT_CSR_RPTR_BASE			16
/*		Bit(s) PAT_CSR_RSRV_15_1 reserved */
#define	PAT_CSR_BSEL				BIT_0			/* Pattern RAM Bank Select */

/*	PAT_RAM				0x1000	Pattern RAM Register */
#define	PAT_RAM_MSK			SHIFT0(0xffffffff)	/* Lower Half qword No. 0 */
#define	PAT_RAM_BASE		0

/*	THDR0_LO			0x1900	TCP Segmentation Header Register 0 Lo */
#define	THDR0_LO_MAC_HDR_0_MSK		SHIFT0(0xffffffff)	/* MAC_HDR_0 */
#define	THDR0_LO_MAC_HDR_0_BASE		0

/*	THDR0_HI			0x1904	TCP Segmentation Header Register 0 Hi */
#define	THDR0_HI_MAC_HDR_1_MSK		SHIFT0(0xffffffff)	/* MAC_HDR_1 */
#define	THDR0_HI_MAC_HDR_1_BASE		0

/*	THDR1_LO			0x1908	TCP Segmentation Header Register 1 Lo */
#define	THDR1_LO_MAC_HDR_2_MSK		SHIFT0(0xffffffff)	/* MAC_HDR_2 */
#define	THDR1_LO_MAC_HDR_2_BASE		0

/*	THDR1_HI			0x190C	TCP Segmentation Header Register 1 Hi */
#define	THDR1_HI_IP_HDR_0_MSK		SHIFT16(0xffff)	/* IP_HDR_0 */
#define	THDR1_HI_IP_HDR_0_BASE		16
#define	THDR1_HI_MAC_HDR_3_MSK		SHIFT0(0xffff)	/* MAC_HDR_3 */
#define	THDR1_HI_MAC_HDR_3_BASE		0

/*	THDR2_LO			0x1910	TCP Segmentation Header Register 2 Lo */
#define	THDR2_LO_IP_HDR_1_MSK		SHIFT0(0xffffffff)	/* IP_HDR_1 */
#define	THDR2_LO_IP_HDR_1_BASE		0

/*	THDR2_HI			0x1914	TCP Segmentation Header Register 2 Hi */
#define	THDR2_HI_IP_HDR_2_MSK		SHIFT0(0xffffffff)	/* IP_HDR_2 */
#define	THDR2_HI_IP_HDR_2_BASE		0

/*	THDR3_LO			0x1918	TCP Segmentation Header Register 3 Lo */
#define	THDR3_LO_IP_HDR_3_MSK		SHIFT0(0xffffffff)	/* IP_HDR_3 */
#define	THDR3_LO_IP_HDR_3_BASE		0

/*	THDR3_HI			0x191C	TCP Segmentation Header Register 3 Hi */
#define	THDR3_HI_IP_HDR_4_MSK		SHIFT0(0xffffffff)	/* IP_HDR_4 */
#define	THDR3_HI_IP_HDR_4_BASE		0

/*	THDR4_LO			0x1920	TCP Segmentation Header Register 4 Lo */
#define	THDR4_LO_IP_HDR_5_MSK		SHIFT0(0xffffffff)	/* IP_HDR_5 */
#define	THDR4_LO_IP_HDR_5_BASE		0

/*	THDR4_HI			0x1924	TCP Segmentation Header Register 4 Hi */
#define	THDR4_HI_IP_HDR_6_MSK		SHIFT0(0xffffffff)	/* IP_HDR_6 */
#define	THDR4_HI_IP_HDR_6_BASE		0

/*	THDR5_LO			0x1928	TCP Segmentation Header Register 5 Lo */
#define	THDR5_LO_IP_HDR_7_MSK		SHIFT0(0xffffffff)	/* IP_HDR_7 */
#define	THDR5_LO_IP_HDR_7_BASE		0

/*	THDR5_HI			0x192C	TCP Segmentation Header Register 5 Hi */
#define	THDR5_HI_IP_HDR_8_MSK		SHIFT0(0xffffffff)	/* IP_HDR_8 */
#define	THDR5_HI_IP_HDR_8_BASE		0

/*	THDR6_LO			0x1930	TCP Segmentation Header Register 6 Lo */
#define	THDR6_LO_IP_HDR_9_MSK		SHIFT0(0xffffffff)	/* IP_HDR_9 */
#define	THDR6_LO_IP_HDR_9_BASE		0

/*	THDR6_HI			0x1934	TCP Segmentation Header Register 6 Hi */
#define	THDR6_HI_IP_HDR_10_MSK		SHIFT0(0xffffffff)	/* IP_HDR_10 */
#define	THDR6_HI_IP_HDR_10_BASE		0

/*	THDR7_LO			0x1938	TCP Segmentation Header Register 7 Lo */
#define	THDR7_LO_IP_HDR_11_MSK		SHIFT0(0xffffffff)	/* IP_HDR_11 */
#define	THDR7_LO_IP_HDR_11_BASE		0

/*	THDR7_HI			0x193C	TCP Segmentation Header Register 7 Hi */
#define	THDR7_HI_IP_HDR_12_MSK		SHIFT0(0xffffffff)	/* IP_HDR_12 */
#define	THDR7_HI_IP_HDR_12_BASE		0

/*	THDR8_LO			0x1940	TCP Segmentation Header Register 8 Lo */
#define	THDR8_LO_IP_HDR_13_MSK		SHIFT0(0xffffffff)	/* IP_HDR_13 */
#define	THDR8_LO_IP_HDR_13_BASE		0

/*	THDR8_HI			0x1944	TCP Segmentation Header Register 8 Hi */
#define	THDR8_HI_IP_HDR_14_MSK		SHIFT0(0xffffffff)	/* IP_HDR_14 */
#define	THDR8_HI_IP_HDR_14_BASE		0

/*	THDR9_LO			0x1948	TCP Segmentation Header Register 9 Lo */
#define	THDR9_LO_IP_HDR_15_MSK		SHIFT0(0xffffffff)	/* IP_HDR_15 */
#define	THDR9_LO_IP_HDR_15_BASE		0

/*	THDR9_HI			0x194C	TCP Segmentation Header Register 9 Hi */
#define	THDR9_HI_IP_HDR_16_MSK		SHIFT0(0xffffffff)	/* IP_HDR_16 */
#define	THDR9_HI_IP_HDR_16_BASE		0

/*	THDR10_LO			0x1950	TCP Segmentation Header Register 10 Lo */
#define	THDR10_LO_IP_HDR_17_MSK			SHIFT0(0xffffffff)	/* IP_HDR_17 */
#define	THDR10_LO_IP_HDR_17_BASE		0

/*	THDR10_HI			0x1954	TCP Segmentation Header Register 10 Hi */
#define	THDR10_HI_IP_HDR_18_MSK			SHIFT0(0xffffffff)	/* IP_HDR_18 */
#define	THDR10_HI_IP_HDR_18_BASE		0

/*	THDR11_LO			0x1958	TCP Segmentation Header Register 11 Lo */
#define	THDR11_LO_IP_HDR_19_MSK			SHIFT0(0xffffffff)	/* IP_HDR_19 */
#define	THDR11_LO_IP_HDR_19_BASE		0

/*	THDR11_HI			0x195C	TCP Segmentation Header Register 11 Hi */
#define	THDR11_HI_IP_HDR_20_MSK			SHIFT0(0xffffffff)	/* IP_HDR_20 */
#define	THDR11_HI_IP_HDR_20_BASE		0

/*	THDR12_LO			0x1960	TCP Segmentation Header Register 12 Lo */
#define	THDR12_LO_IP_HDR_21_MSK			SHIFT0(0xffffffff)	/* IP_HDR_21 */
#define	THDR12_LO_IP_HDR_21_BASE		0

/*	THDR12_HI			0x1964	TCP Segmentation Header Register 12 Hi */
#define	THDR12_HI_IP_HDR_22_MSK			SHIFT0(0xffffffff)	/* IP_HDR_22 */
#define	THDR12_HI_IP_HDR_22_BASE		0

/*	THDR13_LO			0x1968	TCP Segmentation Header Register 13 Lo */
#define	THDR13_LO_IP_HDR_23_MSK			SHIFT0(0xffffffff)	/* IP_HDR_23 */
#define	THDR13_LO_IP_HDR_23_BASE		0

/*	THDR13_HI			0x196C	TCP Segmentation Header Register 13 Hi */
#define	THDR13_HI_IP_HDR_24_MSK			SHIFT0(0xffffffff)	/* IP_HDR_24 */
#define	THDR13_HI_IP_HDR_24_BASE		0

/*	THDR14_LO			0x1970	TCP Segmentation Header Register 14 Lo */
#define	THDR14_LO_IP_HDR_25_MSK			SHIFT0(0xffffffff)	/* IP_HDR_25 */
#define	THDR14_LO_IP_HDR_25_BASE		0

/*	THDR14_HI			0x1974	TCP Segmentation Header Register 14 Hi */
#define	THDR14_HI_IP_HDR_26_MSK			SHIFT0(0xffffffff)	/* IP_HDR_26 */
#define	THDR14_HI_IP_HDR_26_BASE		0

/*	THDR15_LO			0x1978	TCP Segmentation Header Register 15 Lo */
#define	THDR15_LO_IP_HDR_27_MSK			SHIFT0(0xffffffff)	/* IP_HDR_27 */
#define	THDR15_LO_IP_HDR_27_BASE		0

/*	THDR15_HI			0x197C	TCP Segmentation Header Register 15 Hi */
#define	THDR15_HI_IP_HDR_28_MSK			SHIFT0(0xffffffff)	/* IP_HDR_28 */
#define	THDR15_HI_IP_HDR_28_BASE		0

/*	THDR16_LO			0x1980	TCP Segmentation Header Register 16 Lo */
#define	THDR16_LO_IP_HDR_29_MSK			SHIFT0(0xffffffff)	/* IP_HDR_29 */
#define	THDR16_LO_IP_HDR_29_BASE		0

/*	THDR16_HI			0x1984	TCP Segmentation Header Register 16 Hi */
#define	THDR16_HI_IP_HDR_30_MSK			SHIFT0(0xffffffff)	/* IP_HDR_30 */
#define	THDR16_HI_IP_HDR_30_BASE		0

/*	THDR17_LO			0x1988	TCP Segmentation Header Register 17 Lo */
#define	THDR17_LO_IP_HDR_31_MSK			SHIFT0(0xffffffff)	/* IP_HDR_31 */
#define	THDR17_LO_IP_HDR_31_BASE		0

/*	THDR17_HI			0x198C	TCP Segmentation Header Register 17 Hi */
#define	THDR17_HI_IP_HDR_32_MSK			SHIFT0(0xffffffff)	/* IP_HDR_32 */
#define	THDR17_HI_IP_HDR_32_BASE		0

/*	THDR18_LO			0x1990	TCP Segmentation Header Register 18 Lo */
#define	THDR18_LO_IP_HDR_33_MSK			SHIFT0(0xffffffff)	/* IP_HDR_33 */
#define	THDR18_LO_IP_HDR_33_BASE		0

/*	THDR18_HI			0x1994	TCP Segmentation Header Register 18 Hi */
#define	THDR18_HI_IP_HDR_34_MSK			SHIFT0(0xffffffff)	/* IP_HDR_34 */
#define	THDR18_HI_IP_HDR_34_BASE		0

/*	THDR19_LO			0x1998	TCP Segmentation Header Register 19 Lo */
#define	THDR19_LO_IP_HDR_35_MSK			SHIFT0(0xffffffff)	/* IP_HDR_35 */
#define	THDR19_LO_IP_HDR_35_BASE		0

/*	THDR19_HI			0x199C	TCP Segmentation Header Register 19 Hi */
#define	THDR19_HI_IP_HDR_36_MSK			SHIFT0(0xffffffff)	/* IP_HDR_36 */
#define	THDR19_HI_IP_HDR_36_BASE		0

/*	THDR20_LO			0x19A0	TCP Segmentation Header Register 20 Lo */
#define	THDR20_LO_IP_HDR_37_MSK			SHIFT0(0xffffffff)	/* IP_HDR_37 */
#define	THDR20_LO_IP_HDR_37_BASE		0

/*	THDR20_HI			0x19A4	TCP Segmentation Header Register 20 Hi */
#define	THDR20_HI_IP_HDR_38_MSK			SHIFT0(0xffffffff)	/* IP_HDR_38 */
#define	THDR20_HI_IP_HDR_38_BASE		0

/*	THDR21_LO			0x19A8	TCP Segmentation Header Register 21 Lo */
#define	THDR21_LO_IP_HDR_39_MSK			SHIFT0(0xffffffff)	/* IP_HDR_39 */
#define	THDR21_LO_IP_HDR_39_BASE		0

/*	THDR21_HI			0x19AC	TCP Segmentation Header Register 21 Hi */
#define	THDR21_HI_IP_HDR_40_MSK			SHIFT0(0xffffffff)	/* IP_HDR_40 */
#define	THDR21_HI_IP_HDR_40_BASE		0

/*	THDR22_LO			0x19B0	TCP Segmentation Header Register 22 Lo */
#define	THDR22_LO_IP_HDR_41_MSK			SHIFT0(0xffffffff)	/* IP_HDR_41 */
#define	THDR22_LO_IP_HDR_41_BASE		0

/*	THDR22_HI			0x19B4	TCP Segmentation Header Register 22 Hi */
#define	THDR22_HI_TCP_HDR_0_MSK			SHIFT16(0xffff)	/* TCP_HDR_0 */
#define	THDR22_HI_TCP_HDR_0_BASE		16
#define	THDR22_HI_IP_HDR_42_MSK			SHIFT0(0xffff)	/* IP_HDR_42 */
#define	THDR22_HI_IP_HDR_42_BASE		0

/*	THDR23_LO			0x19B8	TCP Segmentation Header Register 23 Lo */
#define	THDR23_LO_TCP_HDR_1_MSK			SHIFT0(0xffffffff)	/* TCP_HDR_1 */
#define	THDR23_LO_TCP_HDR_1_BASE		0

/*	THDR23_HI			0x19BC	TCP Segmentation Header Register 23 Hi */
#define	THDR23_HI_TCP_HDR_2_MSK			SHIFT0(0xffffffff)	/* TCP_HDR_2 */
#define	THDR23_HI_TCP_HDR_2_BASE		0

/*	THDR24_LO			0x19C0	TCP Segmentation Header Register 24 Lo */
#define	THDR24_LO_TCP_HDR_3_MSK			SHIFT0(0xffffffff)	/* TCP_HDR_3 */
#define	THDR24_LO_TCP_HDR_3_BASE		0

/*	THDR24_HI			0x19C4	TCP Segmentation Header Register 24 Hi */
#define	THDR24_HI_TCP_HDR_4_MSK			SHIFT0(0xffffffff)	/* TCP_HDR_4 */
#define	THDR24_HI_TCP_HDR_4_BASE		0

/*	THDR25_LO			0x19C8	TCP Segmentation Header Register 25 Lo */
#define	THDR25_LO_TCP_HDR_5_MSK			SHIFT0(0xffffffff)	/* TCP_HDR_5 */
#define	THDR25_LO_TCP_HDR_5_BASE		0

/*	THDR25_HI			0x19CC	TCP Segmentation Header Register 25 Hi */
#define	THDR25_HI_TCP_HDR_6_MSK			SHIFT0(0xffffffff)	/* TCP_HDR_6 */
#define	THDR25_HI_TCP_HDR_6_BASE		0

/*	THDR26_LO			0x19D0	TCP Segmentation Header Register 26 Lo */
#define	THDR26_LO_TCP_HDR_7_MSK			SHIFT0(0xffffffff)	/* TCP_HDR_7 */
#define	THDR26_LO_TCP_HDR_7_BASE		0

/*	THDR26_HI			0x19D4	TCP Segmentation Header Register 26 Hi */
#define	THDR26_HI_TCP_HDR_8_MSK			SHIFT0(0xffffffff)	/* TCP_HDR_8 */
#define	THDR26_HI_TCP_HDR_8_BASE		0

/*	THDR27_LO			0x19D8	TCP Segmentation Header Register 27 Lo */
#define	THDR27_LO_TCP_HDR_9_MSK			SHIFT0(0xffffffff)	/* TCP_HDR_9 */
#define	THDR27_LO_TCP_HDR_9_BASE		0

/*	THDR27_HI			0x19DC	TCP Segmentation Header Register 27 Hi */
#define	THDR27_HI_TCP_HDR_10_MSK		SHIFT0(0xffffffff)	/* TCP_HDR_10 */
#define	THDR27_HI_TCP_HDR_10_BASE		0

/*	THDR28_LO			0x19E0	TCP Segmentation Header Register 28 Lo */
#define	THDR28_LO_TCP_HDR_11_MSK		SHIFT0(0xffffffff)	/* TCP_HDR_11 */
#define	THDR28_LO_TCP_HDR_11_BASE		0

/*	THDR28_HI			0x19E4	TCP Segmentation Header Register 28 Hi */
#define	THDR28_HI_TCP_HDR_12_MSK		SHIFT0(0xffffffff)	/* TCP_HDR_12 */
#define	THDR28_HI_TCP_HDR_12_BASE		0

/*	THDR29_LO			0x19E8	TCP Segmentation Header Register 29 Lo */
#define	THDR29_LO_TCP_HDR_13_MSK		SHIFT0(0xffffffff)	/* TCP_HDR_13 */
#define	THDR29_LO_TCP_HDR_13_BASE		0

/*	THDR29_HI			0x19EC	TCP Segmentation Header Register 29 Hi */
#define	THDR29_HI_TCP_HDR_14_MSK		SHIFT0(0xffffffff)	/* TCP_HDR_14 */
#define	THDR29_HI_TCP_HDR_14_BASE		0

/*	THDR30_LO			0x19F0	TCP Segmentation Header Register 30 Lo */
/*		Bit(s) THDR30_LO_RSRV_31_16 reserved */
#define	THDR30_LO_TCP_HDR_15_MSK		SHIFT0(0xffff)	/* TCP_HDR_15 */
#define	THDR30_LO_TCP_HDR_15_BASE		0

/*	CFG_VLAN_ET1		0x2000	VLAN Ethernet Type Configuration Register 1 */
/*		Bit(s) CFG_VLAN_ET1_RSRV_23_0 reserved */
#define	CFG_VLAN_ET1_MSK				SHIFT0(0xff)		/* Val */
#define	CFG_VLAN_ET1_BASE				BIT_0

/*	CFG_VLAN_ET0		0x2004	VLAN Ethernet Type Configuration Register 0 */
/*		Bit(s) CFG_VLAN_ET0_RSRV_23_0 reserved */
#define	CFG_VLAN_ET0_MSK				SHIFT0(0xff)		/* Val */
#define	CFG_VLAN_ET0_BASE				BIT_0

/*	CFG_MACSEC_ET1		0x2008	802.1AE Ethernet Type Configuration Register 1 */
/*		Bit(s) CFG_MACSEC_ET1_RSRV_23_0 reserved */
#define	CFG_MACSEC_ET1_MSK					SHIFT0(0xff)		/* Val */
#define	CFG_MACSEC_ET1_BASE					BIT_0

/*	CFG_MACSEC_ET0		0x200C	802.1AE Ethernet Type Configuration Register 0 */
/*		Bit(s) CFG_MACSEC_ET0_RSRV_23_0 reserved */
#define	CFG_MACSEC_ET0_MSK					SHIFT0(0xff)		/* Val */
#define	CFG_MACSEC_ET0_BASE					BIT_0

/*	CFG_TRAIL_SZ		0x2010	Trail Size Configuration Register */
/*		Bit(s) CFG_TRAIL_SZ_RSRV_23_0 reserved */
#define	CFG_TRAIL_SZ_MSK				SHIFT0(0xff)		/* Val */
#define	CFG_TRAIL_SZ_BASE				BIT_0

/*	CFG_DEFAULT_VLAN0	0x2014	Default VLAN Register 0 */
/*		Bit(s) CFG_DEFAULT_VLAN0_RSRV_23_0 reserved */
#define	CFG_DEFAULT_VLAN0_MSK					SHIFT0(0xff)		/* Val */
#define	CFG_DEFAULT_VLAN0_BASE					BIT_0

/*	CFG_DEFAULT_VLAN1	0x2018	Default VLAN Register 1 */
/*		Bit(s) CFG_DEFAULT_VLAN1_RSRV_27_0 reserved */
#define	CFG_DEFAULT_VLAN1_MSK					SHIFT0(0xf)			/* Val */
#define	CFG_DEFAULT_VLAN1_BASE					BIT_0

/*	CFG_MACSEC_SL_SZ	0x201C	MACSec Size Configuration Register */
/*		Bit(s) CFG_MACSEC_SL_SZ_RSRV_23_0 reserved */
#define	CFG_MACSEC_SL_SZ_MSK				SHIFT0(0xff)		/* Val */
#define	CFG_MACSEC_SL_SZ_BASE				BIT_0

/*	CFG_MIN_PKT_LEN		0x2020	Minimum Packet Length Configuration Register */
/*		Bit(s) CFG_MIN_PKT_LEN_RSRV_23_0 reserved */
#define	CFG_MIN_PKT_LEN_MSK					SHIFT0(0xff)		/* Val */
#define	CFG_MIN_PKT_LEN_BASE				BIT_0

/*	SEC_CLK_RST			0x2024	MACSec Clock Reset Register */
/*		Bit(s) SEC_CLK_RST_RSRV_27_0 reserved */
#define	SEC_CLK_RST_GATE_DIS			BIT_3				/* gate disable */
#define	SEC_CLK_RST_INGRESS_RST			BIT_2				/* ingress reset */
#define	SEC_CLK_RST_EGRESS_RST			BIT_1				/* egress reset */
#define	SEC_CLK_RST_STAT_RST			BIT_0				/* stat reset */

/*	EGR_KS_SELECT		0x2028	Egress Key Store Select Register */
/*		Bit(s) EGR_KS_SELECT_RSRV_25_0 reserved */
#define	EGR_KS_SELECT_CTXT_NUM_MSK			SHIFT4(0x3)			/* context number */
#define	EGR_KS_SELECT_CTXT_NUM_BASE			BIT_4
#define	EGR_KS_SELECT_BYTE_NUM_MSK			SHIFT0(0xf)			/* byte number */
#define	EGR_KS_SELECT_BYTE_NUM_BASE			BIT_0

/*	EGR_KS_WRDATA		0x202C	Egress Key Store Write Data Register */
/*		Bit(s) EGR_KS_WRDATA_RSRV_23_0 reserved */
#define	EGR_KS_WRDATA_MSK					SHIFT0(0xff)		/* Val */
#define	EGR_KS_WRDATA_BASE					BIT_0

/*	IGR_KS_SELECT		0x2030	Ingress Key Store Select Register */
/*		Bit(s) IGR_KS_SELECT_RSRV_25_0 reserved */
#define	IGR_KS_SELECT_CTXT_NUM_MSK			SHIFT4(0x3)			/* context number */
#define	IGR_KS_SELECT_CTXT_NUM_BASE			BIT_4
#define	IGR_KS_SELECT_BYTE_NUM_MSK			SHIFT0(0xf)			/* byte number */
#define	IGR_KS_SELECT_BYTE_NUM_BASE			BIT_0

/*	IGR_KS_WRDATA		0x2034	Ingress Key Store Write Data Register */
/*		Bit(s) IGR_KS_WRDATA_RSRV_23_0 reserved */
#define	IGR_KS_WRDATA_MSK					SHIFT0(0xff)		/* Val */
#define	IGR_KS_WRDATA_BASE					BIT_0

/*	CFG_ELU_MC_HIGH0	0x2038	Multicast Match Register 0 */
/*		Bit(s) CFG_ELU_MC_HIGH0_RSRV_27_0 reserved */
#define	CFG_ELU_MC_HIGH0_MSK				SHIFT0(0xf)			/* Val */
#define	CFG_ELU_MC_HIGH0_BASE				BIT_0

/*	CFG_ELU_MC_HIGH1	0x203C	Multicast Match Register 1 */
/*		Bit(s) CFG_ELU_MC_HIGH1_RSRV_23_0 reserved */
#define	CFG_ELU_MC_HIGH1_MSK				SHIFT0(0xff)		/* Val */
#define	CFG_ELU_MC_HIGH1_BASE				BIT_0

/*	CFG_ELU_MC_HIGH2	0x2040	Multicast Match Register 2 */
/*		Bit(s) CFG_ELU_MC_HIGH2_RSRV_23_0 reserved */
#define	CFG_ELU_MC_HIGH2_MSK				SHIFT0(0xff)		/* Val */
#define	CFG_ELU_MC_HIGH2_BASE				BIT_0

/*	CFG_ELU_MC_HIGH3	0x2044	Multicast Match Register 3 */
/*		Bit(s) CFG_ELU_MC_HIGH3_RSRV_23_0 reserved */
#define	CFG_ELU_MC_HIGH3_MSK				SHIFT0(0xff)		/* Val */
#define	CFG_ELU_MC_HIGH3_BASE				BIT_0

/*	CFG_ELU_MC_HIGH4	0x2048	Multicast Match Register 4 */
/*		Bit(s) CFG_ELU_MC_HIGH4_RSRV_23_0 reserved */
#define	CFG_ELU_MC_HIGH4_MSK				SHIFT0(0xff)		/* Val */
#define	CFG_ELU_MC_HIGH4_BASE				BIT_0

/*	CFG_ELU_MC_HIGH5	0x204C	Multicast Match Register 5 */
/*		Bit(s) CFG_ELU_MC_HIGH5_RSRV_23_0 reserved */
#define	CFG_ELU_MC_HIGH5_MSK				SHIFT0(0xff)		/* Val */
#define	CFG_ELU_MC_HIGH5_BASE				BIT_0

/*	CFG_ELU_MC_LOW_MSK0	0x2050	Multicast Match Mask Register 0 */
/*		Bit(s) CFG_ELU_MC_LOW_MSK0_RSRV_23_0 reserved */
#define	CFG_ELU_MC_LOW_MSK0_MSK					SHIFT0(0xff)		/* Val */
#define	CFG_ELU_MC_LOW_BASE0_BASE				BIT_0

/*	CFG_ELU_MC_LOW_MSK1	0x2054	Multicast Match Mask Register 1 */
/*		Bit(s) CFG_ELU_MC_LOW_MSK1_RSRV_23_0 reserved */
#define	CFG_ELU_MC_LOW_MSK1_MSK					SHIFT0(0xff)		/* Val */
#define	CFG_ELU_MC_LOW_BASE1_BASE				BIT_0

/*	CFG_DEFAULT_PORT0	0x2058	Default Port Configuration Register 0 */
/*		Bit(s) CFG_DEFAULT_PORT0_RSRV_23_0 reserved */
#define	CFG_DEFAULT_PORT0_MSK					SHIFT0(0xff)		/* Val */
#define	CFG_DEFAULT_PORT0_BASE					BIT_0

/*	CFG_DEFAULT_PORT1	0x205C	Default Port Configuration Register 1 */
/*		Bit(s) CFG_DEFAULT_PORT1_RSRV_23_0 reserved */
#define	CFG_DEFAULT_PORT1_MSK					SHIFT0(0xff)		/* Val */
#define	CFG_DEFAULT_PORT1_BASE					BIT_0

/*	CFG_SCB_PORT0		0x2060	SCB Port Configuration Register 0 */
/*		Bit(s) CFG_SCB_PORT0_RSRV_23_0 reserved */
#define	CFG_SCB_PORT0_MSK					SHIFT0(0xff)		/* Val */
#define	CFG_SCB_PORT0_BASE					BIT_0

/*	CFG_SCB_PORT1		0x2064	SCB Port Configuration Register 1 */
/*		Bit(s) CFG_SCB_PORT1_RSRV_23_0 reserved */
#define	CFG_SCB_PORT1_MSK					SHIFT0(0xff)		/* Val */
#define	CFG_SCB_PORT1_BASE					BIT_0

/*	CFG_AUTH_ADJUST		0x2068	Authentication Adjustment Register */
/*		Bit(s) CFG_AUTH_ADJUST_RSRV_23_0 reserved */
#define	CFG_AUTH_ADJUST_MSK					SHIFT0(0xff)		/* Val */
#define	CFG_AUTH_ADJUST_BASE				BIT_0

/*	CFG_ELU_GEN			0x206C	ELU Default Configuration Register */
/*		Bit(s) CFG_ELU_GEN_RSRV_27_0 reserved */
//#define	_MSK							SHIFT2(0x3)			/* min_bypass_len */
//#define	_BASE							BIT_2
/*		Bit(s) CFG_ELU_GEN_RSRV_1_0 reserved */

/*	CFG_ELUC_ADDR		0x2070	ELU Address Configuration Register */
/*		Bit(s) CFG_ELUC_ADDR_RSRV_25_0 reserved */
#define	CFG_ELUC_ADDR_CTXT_NUM_MSK			SHIFT4(0x3)			/* context number */
#define	CFG_ELUC_ADDR_CTXT_NUM_BASE			BIT_4
#define	CFG_ELUC_ADDR_BYTE_NUM_MSK			SHIFT0(0xf)			/* byte number */
#define	CFG_ELUC_ADDR_BYTE_NUM_BASE			BIT_0

/*	CFG_ELUC_DATA		0x2074	ELU Context Data Configuration Register */
/*		Bit(s) CFG_ELUC_DATA_RSRV_23_0 reserved */
#define	CFG_ELUC_DATA_MSK					SHIFT0(0xff)		/* Val */
#define	CFG_ELUC_DATA_BASE					BIT_0

/*	CFG_ELUE_ADDR		0x2078	ELU Entry Configuration Register */
/*		Bit(s) CFG_ELUE_ADDR_RSRV_23_0 reserved */
/* Lookup entry number */
#define	CFG_ELUE_ADDR_LKUP_NUM_MSK			SHIFT5(0x7)			
#define	CFG_ELUE_ADDR_LKUP_NUM_BASE			BIT_5
#define	CFG_ELUE_ADDR_BYTE_NUM_MSK			SHIFT0(0x1f)		/* byte number */
#define	CFG_ELUE_ADDR_BYTE_NUM_BASE			BIT_0

/*	CFG_ELUE_DATA		0x207C	ELU Lookup Entry Access Configuration Register */
/*		Bit(s) CFG_ELUE_DATA_RSRV_23_0 reserved */
#define	CFG_ELUE_DATA_MSK					SHIFT0(0xff)		/* Val */
#define	CFG_ELUE_DATA_BASE					BIT_0

/*	CFG_EPR_GEN			0x2080	General Egress Parser Configuration Register */
/*		Bit(s) CFG_EPR_GEN_RSRV_28_0 reserved */
#define	CFG_EPR_GEN_PARSE_VLAN				BIT_2				/* Parse VLAN */
/*		Bit(s) CFG_EPR_GEN_RSRV_ reserved */
#define	CFG_EPR_GEN_PREAMBLE_PRESENT		BIT_0				/* Preamble present */

/*	EGR_HR_SELECT		0x2084	Egress Write Select for H-Store Register */
/*		Bit(s) EGR_HR_SELECT_RSRV_25_0 reserved */
#define	EGR_HR_SELECT_KEY_NUM_MSK			SHIFT4(0x3)			/* Key number */
#define	EGR_HR_SELECT_KEY_NUM_BASE			BIT_4
#define	EGR_HR_SELECT_BYTE_NUM_MSK			SHIFT0(0xf)			/* byte number */
#define	EGR_HR_SELECT_BYTE_NUM_BASE			BIT_0

/*	EGR_HR_WRDATA		0x2088	Egress Header Write Data Register */
/*		Bit(s) EGR_HR_WRDATA_RSRV_23_0 reserved */
#define	EGR_HR_WRDATA_MSK					SHIFT0(0xff)		/* Val */
#define	EGR_HR_WRDATA_BASE					BIT_0

/*	IGR_HR_SELECT		0x208C	Ingress Write Select for H-Store Register */
/*		Bit(s) IGR_HR_SELECT_RSRV_25_0 reserved */
#define	IGR_HR_SELECT_KEY_NUM_MSK			SHIFT4(0x3)			/* Key number */
#define	IGR_HR_SELECT_KEY_NUM_BASE			BIT_4
#define	IGR_HR_SELECT_BYTE_NUM_MSK			SHIFT0(0xf)			/* byte number */
#define	IGR_HR_SELECT_BYTE_NUM_BASE			BIT_0

/*	IGR_HR_WRDATA		0x2090	Ingress Header Write Data Register */
/*		Bit(s) IGR_HR_WRDATA_RSRV_25_0 reserved */
#define	IGR_HR_WRDATA_2_MSK					SHIFT0(0xff)		/* Val */
#define	IGR_HR_WRDATA_2_BASE				BIT_0

/*	CFG_IMPLICIT_SCI0	0x2098	Implicit SCI Register 0 */
/*		Bit(s) CFG_IMPLICIT_SCI0_RSRV_23_0 reserved */
#define	CFG_IMPLICIT_SCI0_MSK					SHIFT0(0xff)		/* Val */
#define	CFG_IMPLICIT_SCI0_BASE					BIT_0

/*	CFG_IMPLICIT_SCI1	0x209C	Implicit SCI Register 1 */
/*		Bit(s) CFG_IMPLICIT_SCI1_RSRV_23_0 reserved */
#define	CFG_IMPLICIT_SCI1_MSK					SHIFT0(0xff)		/* Val */
#define	CFG_IMPLICIT_SCI1_BASE					BIT_0

/*	CFG_IMPLICIT_SCI2	0x20A0	Implicit SCI Register 2 */
/*		Bit(s) CFG_IMPLICIT_SCI2_RSRV_23_0 reserved */
#define	CFG_IMPLICIT_SCI2_MSK					SHIFT0(0xff)		/* Val */
#define	CFG_IMPLICIT_SCI2_BASE					BIT_0

/*	CFG_IMPLICIT_SCI3	0x20A4	Implicit SCI Register 3 */
/*		Bit(s) CFG_IMPLICIT_SCI3_RSRV_23_0 reserved */
#define	CFG_IMPLICIT_SCI3_MSK					SHIFT0(0xff)		/* Val */
#define	CFG_IMPLICIT_SCI3_BASE					BIT_0

/*	CFG_IMPLICIT_SCI4	0x20A8	Implicit SCI Register 4 */
/*		Bit(s) CFG_IMPLICIT_SCI4_RSRV_23_0 reserved */
#define	CFG_IMPLICIT_SCI4_MSK					SHIFT0(0xff)		/* Val */
#define	CFG_IMPLICIT_SCI4_BASE					BIT_0

/*	CFG_IMPLICIT_SCI5	0x20AC	Implicit SCI Register 5 */
/*		Bit(s) CFG_IMPLICIT_SCI5_RSRV_23_0 reserved */
#define	CFG_IMPLICIT_SCI5_MSK					SHIFT0(0xff)		/* Val */
#define	CFG_IMPLICIT_SCI5_BASE					BIT_0

/*	CFG_IMPLICIT_SCI6	0x20B0	Implicit SCI Register 6 */
/*		Bit(s) CFG_IMPLICIT_SCI6_RSRV_23_0 reserved */
#define	CFG_IMPLICIT_SCI6_MSK					SHIFT0(0xff)		/* Val */
#define	CFG_IMPLICIT_SCI6_BASE					BIT_0

/*	CFG_IMPLICIT_SCI7	0x20B4	Implicit SCI Register 7 */
/*		Bit(s) CFG_IMPLICIT_SCI7_RSRV_23_0 reserved */
#define	CFG_IMPLICIT_SCI7_MSK					SHIFT0(0xff)		/* Val */
#define	CFG_IMPLICIT_SCI7_BASE					BIT_0

/*	CFG_REPLAY_WINDOW0	0x20B8	Replay Window Register 0 */
/*		Bit(s) CFG_REPLAY_WINDOW0_RSRV_23_0 reserved */
#define	CFG_REPLAY_WINDOW0_MSK					SHIFT0(0xff)		/* Val */
#define	CFG_REPLAY_WINDOW0_BASE					BIT_0

/*	CFG_REPLAY_WINDOW1	0x20BC	Replay Window Register 1 */
/*		Bit(s) CFG_REPLAY_WINDOW1_RSRV_23_0 reserved */
#define	CFG_REPLAY_WINDOW1_MSK					SHIFT0(0xff)		/* Val */
#define	CFG_REPLAY_WINDOW1_BASE					BIT_0

/*	CFG_REPLAY_WINDOW2	0x20C0	Replay Window Register 2 */
/*		Bit(s) CFG_REPLAY_WINDOW2_RSRV_23_0 reserved */
#define	CFG_REPLAY_WINDOW2_MSK					SHIFT0(0xff)		/* Val */
#define	CFG_REPLAY_WINDOW2_BASE					BIT_0

/*	CFG_REPLAY_WINDOW3	0x20C4	Replay Window Register 3 */
/*		Bit(s) CFG_REPLAY_WINDOW3_RSRV_23_0 reserved */
#define	CFG_REPLAY_WINDOW3_MSK					SHIFT0(0xff)		/* Val */
#define	CFG_REPLAY_WINDOW3_BASE					BIT_0

/*	CFG_IPR_GEN			0x20C8	Ingress Primary Parser Register */
/*		Bit(s) CFG_IPR_GEN_RSRV_28_0 reserved */
#define	CFG_IPR_GEN_PREAMBLE_PRESENT		BIT_2				/* Preamble present */
#define	CFG_IPR_GEN_PARSE_VLAN				BIT_1				/* Parse VLAN */
/* extract header field */
#define	CFG_IPR_GEN_EXTRACT_HDR_FIELD		BIT_0				

/*	CFG_ISC_GEN			0x20CC	Ingress Security Check Block Register */
/*		Bit(s) CFG_ISC_GEN_RSRV_23_0 reserved */
/*		Bit(s) CFG_ISC_GEN_RSRV_ reserved */
/*		Bit(s) CFG_ISC_GEN_RSRV_ reserved */
/*		Bit(s) CFG_ISC_GEN_RSRV_1_0 reserved */
/* replay_protect */
#define	CFG_ISC_GEN_RPY_PROTECT					BIT_2				
/* validate_frames */
#define	CFG_ISC_GEN_VALIDATE_FRAMES_MSK			SHIFT0(0x3)			
#define	CFG_ISC_GEN_VALIDATE_FRAMES_BASE		BIT_0

/*	CFG_RPY_ADDR		0x20D0	Replay Protect Table Access Register */
/*		Bit(s) CFG_RPY_ADDR_RSRV_27_0 reserved */
/* Replay table entry */
#define	CFG_RPY_ADDR_RPY_TAB_NUM_MSK		SHIFT2(0x3)			
#define	CFG_RPY_ADDR_RPY_TAB_NUM_BASE		BIT_2
#define	CFG_RPY_ADDR_BYTE_NUM_MSK			SHIFT0(0x3)			/* byte number */
#define	CFG_RPY_ADDR_BYTE_NUM_BASE			BIT_0

/*	CFG_RPY_DATA		0x20D4	ELU Context Data Register */
/*		Bit(s) CFG_RPY_DATA_RSRV_23_0 reserved */
#define	CFG_RPY_DATA_MSK				SHIFT0(0xff)		/* val */
#define	CFG_RPY_DATA_BASE				BIT_0

/*	CFG_ILUT_ADDR		0x20E0	Ingress Lookup Table Access Address
 *								Configuration Register
 */
/*		Bit(s) CFG_ILUT_ADDR_RSRV_23_0 reserved */
/* Lookup table entry */
#define	CFG_ILUT_ADDR_LOOKUP_NUM_MSK		SHIFT5(0x7)			
#define	CFG_ILUT_ADDR_LOOKUP_NUM_BASE		BIT_5
#define	CFG_ILUT_ADDR_BYTE_NUM_MSK			SHIFT0(0x1f)		/* byte number */
#define	CFG_ILUT_ADDR_BYTE_NUM_BASE			BIT_0

/*	CFG_ILUT_DATA		0x20E4	ILU Table Data Register */
/*		Bit(s) CFG_ILUT_DATA_RSRV_23_0 reserved */
#define	CFG_ILUT_DATA_MSK					SHIFT0(0xff)		/* val */
#define	CFG_ILUT_DATA_BASE					BIT_0

/*	STAT_ADDR			0x20E8	Statistic Register Address */
/*		Bit(s) STAT_ADDR_RSRV_25_0 reserved */
#define	STAT_ADDR_MSK					SHIFT0(0x3f)		/* val */
#define	STAT_ADDR_BASE					BIT_0

/*	STAT_DATA0			0x20EC	Statistic Data Register 0 */
/*		Bit(s) STAT_DATA0_RSRV_23_0 reserved */
#define	STAT_DATA0_MSK					SHIFT0(0xff)		/* val */
#define	STAT_DATA0_BASE					BIT_0

/*	STAT_DATA1			0x20F0	Statistic Data Register 1 */
/*		Bit(s) STAT_DATA1_RSRV_23_0 reserved */
#define	STAT_DATA1_MSK					SHIFT0(0xff)		/* val */
#define	STAT_DATA1_BASE					BIT_0

/*	STAT_DATA2			0x20F4	Statistic Data Register 2 */
/*		Bit(s) STAT_DATA2_RSRV_23_0 reserved */
#define	STAT_DATA2_MSK					SHIFT0(0xff)		/* val */
#define	STAT_DATA2_BASE					BIT_0

/*	CFG_OVER_LEN1		0x20F8	Over-Length Configuration Register 1 */
/*		Bit(s) CFG_OVER_LEN1_RSRV_23_0 reserved */
#define	CFG_OVER_LEN1_MSK					SHIFT0(0xff)		/* val */
#define	CFG_OVER_LEN1_BASE					BIT_0

/*	CNT_TX_ERR			0x2100	MACSec TX Processing Error Count */
/*		Bit(s) CNT_TX_ERR_RSRV_23_0 reserved */
#define	CNT_TX_ERR_MSK					SHIFT0(0xff)		/* err_cnt */
#define	CNT_TX_ERR_BASE					BIT_0

/*	CFG_IPAR_HYST		0x2104	Ingress Parse FIFO Hysteresis */
/*		Bit(s) CFG_IPAR_HYST_RSRV_27_0 reserved */
#define	CFG_IPAR_HYST_MSK					SHIFT0(0xf)			/* ipar_hyst */
#define	CFG_IPAR_HYST_BASE					BIT_0

/*	CFG_EPAR_HYST		0x2108	Egress Parse FIFO Hysteresis */
/*		Bit(s) CFG_EPAR_HYST_RSRV_27_0 reserved */
#define	CFG_EPAR_HYST_MSK					SHIFT0(0xf)			/* epar_hyst */
#define	CFG_EPAR_HYST_BASE					BIT_0

/*	RE_TRF_TCTL			0x2200	MACSec Retransmit FIFO Control */
/*		Bit(s) RE_TRF_TCTL_RSRV_27_0 reserved */
#define	RE_TRF_TCTL_RETRAN_OP_ON		BIT_3				/* Operational On */
#define	RE_TRF_TCTL_RETRAN_OP_OFF		BIT_2				/* Operational Off */
#define	RE_TRF_TCTL_RETRAN_RST_CLR		BIT_1				/* Reset Clear */
#define	RE_TRF_TCTL_RETRAN_RST_SET		BIT_0				/* Reset Set */

/*	RE_TRF_PCNT			0x2204	Retransmit FIFO Packet Counter */
/*		Bit(s) RE_TRF_PCNT_RSRV_22_0 reserved */
#define	RE_TRF_PCNT_MSK					SHIFT0(0xff)		/* Packet Counter */
#define	RE_TRF_PCNT_BASE				BIT_0

/*	RE_TRF_TTH			0x2208	Retransmit FIFO Transmit Start Threshold */
/*		Bit(s) RE_TRF_TTH_RSRV_26_0 reserved */
/* Transmit Start Threshold */
#define	RE_TRF_TTH_MSK					SHIFT0(0x1f)		
#define	RE_TRF_TTH_BASE					BIT_0

/*	RE_TRF_WPTR			0x2210	Retransmit FIFO Write Pointer Register */
/*		Bit(s) RE_TRF_WPTR_RSRV_26_0 reserved */
#define	RE_TRF_WPTR_MSK					SHIFT0(0x1f)		/* Write Pointer */
#define	RE_TRF_WPTR_BASE				BIT_0

/*	RE_TRF_WLEV			0x2218	Retransmit FIFO Write Level Register */
/*		Bit(s) RE_TRF_WLEV_RSRV_26_0 reserved */
#define	RE_TRF_WLEV_MSK					SHIFT0(0x1f)		/* Write Level */
#define	RE_TRF_WLEV_BASE				BIT_0

/*	RE_TRF_RPTR			0x2220	Retransmit FIFO Read Pointer Register */
/*		Bit(s) RE_TRF_RPTR_RSRV_26_0 reserved */
#define	RE_TRF_RPTR_MSK					SHIFT0(0x1f)		/* Read Pointer */
#define	RE_TRF_RPTR_BASE				BIT_0

/*	RE_TRF_RES_PTR		0x2224	Transmit FIFO Restart Pointer Register */
/*		Bit(s) RE_TRF_RES_PTR_RSRV_26_0 reserved */
#define	RE_TRF_RES_PTR_MSK					SHIFT0(0x1f)		/* Restart Pointer */
#define	RE_TRF_RES_PTR_BASE					BIT_0

/*	RE_TRF_RLEV			0x2228	Retransmit FIFO Read Level Register */
/*		Bit(s) RE_TRF_RLEV_RSRV_26_0 reserved */
#define	RE_TRF_RLEV_MSK					SHIFT0(0x1f)		/* Read Level */
#define	RE_TRF_RLEV_BASE				BIT_0

/*	RE_TRF_RSPTR		0x222c	Retransmit FIFO Read Shadow Level Register */
/*		Bit(s) RE_TRF_RSPTR_RSRV_26_0 reserved */
#define	RE_TRF_RSPTR_MSK				SHIFT0(0x1f)		/* Read Shadow Level */
#define	RE_TRF_RSPTR_BASE				BIT_0

/* -------------------- */

/*
 *
 *	THE BASE ADDRESSES
 *
 */

/*
 *
 *	THE REGISTER DEFINES
 *
 */
#define	GPSR		0x2800	/* 16 bit	General Purpose Status Register */
#define	GPCR		0x2804	/* 16 bit	General Purpose Control Register */
#define	TCR			0x2808	/* 16 bit	Transmit Control Register */
#define	RCR			0x280C	/* 16 bit	Receive Control Register */
#define	TFCR		0x2810	/* 16 bit	Transmit Flow Control Register */
#define	TPR			0x2814	/* 16 bit	Transmit Parameter Register */
#define	SMR			0x2818	/* 16 bit	Serial Mode Register */
#define	SAL1		0x281C	/* 16 bit	Source Address Low */
#define	SAM1		0x2820	/* 16 bit	Source Address Middle */
#define	SA1H		0x2824	/* 16 bit	Source Address High */
#define	SAL2		0x2828	/* 16 bit	Source Address Low */
#define	SAM2		0x282C	/* 16 bit	Source Address Middle */
#define	SAH2		0x2830	/* 16 bit	Source Address High */
#define	MCAH1		0x2834	/* 16 bit	Multicast Address Hash Register 1 */
#define	MCAH2		0x2838	/* 16 bit	Multicast Address Hash Register 2 */
#define	MCAH3		0x283C	/* 16 bit	Multicast Address Hash Register 3 */
#define	MCAH4		0x2840	/* 16 bit	Multicast Address Hash Register 4 */
#define	TIR			0x2844	/* 16 bit	Transmit Interrupt Register */
#define	RIR			0x2848	/* 16 bit	Receive Interrupt Register */
#define	TIR_RIR		0x284C	/* 16 bit	Transmit and Receive Interrupt Register */
#define	TIMR		0x2850	/* 16 bit	Transmit Interrupt Mask Register */
#define	RIMR		0x2854	/* 16 bit	Receive Interrupt Mask Register */
#define	TIMR_RIMR	0x2858	/* 16 bit	Transmit and Receive Interrupt Mask
							 *			Register
							 */
#define	FC_TIMEOUT	0x285c	/* 16 bit	Flow Control Timeout Register */
#define	SMICR		0x2880	/* 16 bit	SMI Control Register */
#define	SMIDR		0x2884	/* 16 bit	SMI Data Register */
#define	PAR			0x2888	/* 16 bit	PHY Address Register */

/*
 *
 *	THE BIT DEFINES
 *
 */
/*	GPSR		0x2800	General Purpose Status Register */
#define	GPSR_SPEED				BIT_15S	/* Speed */
#define	GPSR_DUPLEX				BIT_14S	/* Duplex */
#define	GPSR_FCTLTX				BIT_13S	/* FctlTx */
#define	GPSR_LINK				BIT_12S	/* Link */
#define	GPSR_PAUSE				BIT_11S	/* Pause */
#define	GPSR_TXINPROG			BIT_10S	/* TxinProg */
#define	GPSR_EXCESSCOL			BIT_9S	/* ExcessCol */
#define	GPSR_LATECOL			BIT_8S	/* LateCol */
#define	GPSR_TX_EN_STATUS		BIT_7S	/* TxEnStatus */
#define	GPSR_RX_EN_STATUS		BIT_6S	/* RxEnStatus */
#define	GPSR_MIIPHYSTC			BIT_5S	/* MIIPhySTC */
#define	GPSR_GIGSPEED			BIT_4S	/* GigSpeed */
#define	GPSR_PARTITION			BIT_3S	/* Partition */
#define	GPSR_FCTLRX				BIT_2S	/* FctlRx */
#define	GPSR_PROMISC_MODE		BIT_1S	/* Promiscuous Mode */
/*		Bit(s) GPSR_RSRV_0 reserved */

/*	GPCR		0x2804	General Purpose Control Register */
#define	GPCR_MDIO_SPSEL			BIT_15S	/* mac to phy mdio speed select */
/*		Bit(s) GPCR_RSRV_14 reserved */
#define	GPCR_FCTLTX				BIT_13S			/* FCTLTX */
#define	GPCR_TXEN				BIT_12S			/* TxEn */
#define	GPCR_RXEN				BIT_11S			/* RxEn */
/*		Bit(s) GPCR_RSRV_10 reserved */
#define	GPCR_LPBK				BIT_9S			/* LPBK */
#define	GPCR_PAR				BIT_8S			/* PAR */
#define	GPCR_GIGSPEED			BIT_7S			/* GigSpeed */
#define	GPCR_FLP				BIT_6S			/* FLP */
#define	GPCR_HD					BIT_5S			/* HD */
#define	GPCR_FCTLRX				BIT_4S			/* FCTLRX */
#define	GPCR_SPEED				BIT_3S			/* Speed */
#define	GPCR_DPLYXEN			BIT_2S			/* DPLYXen */
#define	GPCR_FCTLEN				BIT_1S			/* FCTLen */
#define	GPCR_SPEEDEN			BIT_0S			/* SpeedEn */

/*	TCR			0x2808	Transmit Control Register */
#define	TCR_FJ					BIT_15S			/* FJ */
#define	TCR_CRCD				BIT_14S			/* CRCD */
#define	TCR_PADD				BIT_13S			/* PADD */
#define	TCR_COLTH_MSK			SHIFT10(0x7U)	/* ColTh */
#define	TCR_COLTH_BASE			10
#define	TCR_HD_LPBK_DIS			BIT_9S			/* HALF DUPLEX LPBK DISABLE */
#define	TCR_JAM_FIX_EN			BIT_8S			/* JAM UNH FIX_EN */
#define	TCR_PADD_PAT_MSK		SHIFT0(0xffU)	/* Padding Pattern */
#define	TCR_PADD_PAT_BASE		0

/*	RCR			0x280C	Receive Control Register */
#define	RCR_UNFIEN				BIT_15S			/* UnFiEn */
#define	RCR_MUFIEN				BIT_14S			/* MuFiEn */
#define	RCR_CRCR				BIT_13S			/* CRCR */
/*		Bit(s) RCR_RSRV_12 reserved */
/*		Bit(s) RCR_RSRV_11_0 reserved */

/*	TFCR		0x2810	Transmit Flow Control Register */
#define	TFCR_PAUSETIME_MSK		SHIFT0(0xffffU)	/* PauseTime */
#define	TFCR_PAUSETIME_BASE		0

/*	TPR			0x2814	Transmit Parameter Register */
#define	TPR_JAM_LEN_MSK				SHIFT14(0x3U)	/* JAM_Len */
#define	TPR_JAM_LEN_BASE			14
#define	TPR_JAM_IPG_MSK				SHIFT9(0x1fU)	/* JAM_IPG */
#define	TPR_JAM_IPG_BASE			9
#define	TPR_IPGJAM2DATA_MSK			SHIFT4(0x1fU)	/* IPGJAM2Data */
#define	TPR_IPGJAM2DATA_BASE		4
#define	TPR_BACK_OFF_LIMIT_MSK		SHIFT0(0xfU)	/* Back-off Limit */
#define	TPR_BACK_OFF_LIMIT_BASE		0

/*	SMR			0x2818	Serial Mode Register */
#define	SMR_DATA_BLINDER_MSK		SHIFT11(0x1fU)	/* Data Blinder */
#define	SMR_DATA_BLINDER_BASE		11
#define	SMR_LIMIT4					BIT_10S			/* Limit4 */
#define	SMR_VLAN_EN_MFL_MSK			SHIFT8(0x3U)	/* Vlan_en, MFL */
#define	SMR_VLAN_EN_MFL_BASE		8
/*		Bit(s) SMR_RSRV_7_5 reserved */
#define	SMR_IPGDATA_MSK				SHIFT0(0x1fU)	/* IPGData */
#define	SMR_IPGDATA_BASE			0

/*	SAL1		0x281C	Source Address Low */
#define	SAL1_SA1_MSK		SHIFT0(0xffffU)	/* SA1 [15:0] */
#define	SAL1_SA1_BASE		0

/*	SAM1		0x2820	Source Address Middle */
#define	SAM1_SA1_MSK		SHIFT0(0xffffU)	/* SA1 [31:16] */
#define	SAM1_SA1_BASE		0

/*	SA1H		0x2824	Source Address High */
#define	SA1H_SA1_MSK		SHIFT0(0xffffU)	/* SA1 [47:32] */
#define	SA1H_SA1_BASE		0

/*	SAL2		0x2828	Source Address Low */
#define	SAL2_SA2_MSK		SHIFT0(0xffffU)	/* SA2 [15:0] */
#define	SAL2_SA2_BASE		0

/*	SAM2		0x282C	Source Address Middle */
#define	SAM2_SA2_MSK		SHIFT0(0xffffU)	/* SA2 [31:16] */
#define	SAM2_SA2_BASE		0

/*	SAH2		0x2830	Source Address High */
#define	SAH2_SA2_MSK		SHIFT0(0xffffU)	/* SA 2[47:32] */
#define	SAH2_SA2_BASE		0

/*	MCAH1		0x2834	Multicast Address Hash Register 1 */
#define	MCAH1_MCAH1_MSK			SHIFT0(0xffffU)	/* MCAH1[15:0] */
#define	MCAH1_MCAH1_BASE		0

/*	MCAH2		0x2838	Multicast Address Hash Register 2 */
#define	MCAH2_MCAH2_MSK			SHIFT0(0xffffU)	/* MCAH2[15:0] */
#define	MCAH2_MCAH2_BASE		0

/*	MCAH3		0x283C	Multicast Address Hash Register 3 */
#define	MCAH3__MCAH3_MSK		SHIFT0(0xffffU)	/* MCAH3[15:0] */
#define	MCAH3__MCAH3_BASE		0

/*	MCAH4		0x2840	Multicast Address Hash Register 4 */
#define	MCAH4_MCAH4_MSK			SHIFT0(0xffffU)	/* MCAH4[15:0] */
#define	MCAH4_MCAH4_BASE		0

/*	TIR			0x2844	Transmit Interrupt Register */
#define	TIR_LATE				BIT_15S			/* Late */
#define	TIR_COLLISIONS			BIT_14S			/* Collisions */
#define	TIR_DEFER				BIT_13S			/* Defer */
#define	TIR_OUTMAXOCTETS		BIT_12S			/* OutMaxOctets */
#define	TIR_OUT1518OCTETS		BIT_11S			/* Out1518Octets */
#define	TIR_OUT1023OCTETS		BIT_10S			/* Out1023Octets */
#define	TIR_OUT511OCTETS		BIT_9S			/* Out511Octets */
#define	TIR_OUT255OCTETS		BIT_8S			/* Out255Octets */
#define	TIR_OUT127OCTETS		BIT_7S			/* Out127Octets */
#define	TIR_OUT64OCTETS			BIT_6S			/* Out64octets */
#define	TIR_OUTOCTETS_MSK		SHIFT4(0x3U)	/* OutOctets */
#define	TIR_OUTOCTETS_BASE		4
#define	TIR_OUTMULTICASTS		BIT_3S			/* OutMulticasts */
#define	TIR_OUTPAUSE			BIT_2S			/* OutPause */
#define	TIR_OUTBROADCASTS		BIT_1S			/* OutBroadcasts */
#define	TIR_OUTUNICASTS			BIT_0S			/* OutUnicasts */

/*	RIR			0x2848	Receive Interrupt Register */
#define	RIR_IN511OCTETS			BIT_15S			/* In511Octets */
#define	RIR_IN255OCTETS			BIT_14S			/* In255Octets */
#define	RIR_IN127OCTETS			BIT_13S			/* In127Octets */
#define	RIR_IN64OCTETS			BIT_12S			/* In64Octets */
#define	RIR_FRAGMENTS			BIT_11S			/* Fragments */
#define	RIR_UNDERSIZE			BIT_10S			/* Undersize */
#define	RIR_INBADOCTETS_MSK		SHIFT8(0x3U)	/* InBadOctets */
#define	RIR_INBADOCTETS_BASE	8
#define	RIR_INGOODOCTETS_MSK	SHIFT6(0x3U)	/* InGoodOctets */
#define	RIR_INGOODOCTETS_BASE	6
#define	RIR_SPARE				BIT_5S			/* Spare */
#define	RIR_INFCSERR			BIT_4S			/* InFCSErr */
#define	RIR_INMULTICASTS		BIT_3S			/* InMulticasts */
#define	RIR_INPAUSE				BIT_2S			/* InPause */
#define	RIR_INBROADCASTS		BIT_1S			/* InBroadcasts */
#define	RIR_INUNICASTS			BIT_0S			/* InUnicasts */

/*	TIR_RIR		0x284C	Transmit and Receive Interrupt Register */
/*		Bit(s) TIR_RIR_RSRV_15_12 reserved */
#define	TIR_RIR_UNDERFLOW			BIT_11S			/* Underflow */
#define	TIR_RIR_SINGLE				BIT_10S			/* Single */
#define	TIR_RIR_MULTIPLE			BIT_9S			/* Multiple */
#define	TIR_RIR_EXCESSIVE			BIT_8S			/* Excessive */
#define	TIR_RIR_ALIGMENT_ERROR		BIT_7S			/* Align_error */
#define	TIR_RIR_OVERFLOW			BIT_6S			/* Overflow */
#define	TIR_RIR_SYMBOL_ERR			BIT_5S			/* Symbol_error */
#define	TIR_RIR_JABBER				BIT_4S			/* Jabber */
#define	TIR_RIR_OVERSIZE			BIT_3S			/* OverSize */
#define	TIR_RIR_INMAXOCTETS			BIT_2S			/* InMaxOctets */
#define	TIR_RIR_IN1518OCTETS		BIT_1S			/* In1518Octets */
#define	TIR_RIR_IN1023OCTETS		BIT_0S			/* In1023Octets */

/*	TIMR		0x2850	Transmit Interrupt Mask Register */
#define	TIMR_TIMR_MSK		SHIFT0(0xffffU)	/* TIMR[15:0] */
#define	TIMR_TIMR_BASE		0

/*	RIMR		0x2854	Receive Interrupt Mask Register */
#define	RIMR_RIMR_MSK		SHIFT0(0xffffU)	/* RIMR[15:0] */
#define	RIMR_RIMR_BASE		0

/*	TIMR_RIMR	0x2858	Transmit and Receive Interrupt Mask Register */
#define	TIMR_RIMR_TIMR_RIMR_MSK			SHIFT0(0xffffU)	/* TIMR_RIMR[15:0] */
#define	TIMR_RIMR_TIMR_RIMR_BASE		0

/*	FC_TIMEOUT	0x285c	Flow Control Timeout Register */
#define	FC_TIMEOUT_FC_TIMEOUT_MSK		SHIFT0(0xffffU)	/* FC_TIMEOUT[15:0] */
#define	FC_TIMEOUT_FC_TIMEOUT_BASE		0

/*	SMICR		0x2880	SMI Control Register */
#define	SMICR_PHYAD_MSK			SHIFT11(0x1fU)	/* PhyAd */
#define	SMICR_PHYAD_BASE		11
#define	SMICR_REGAD_MSK			SHIFT6(0x1fU)	/* RegAd */
#define	SMICR_REGAD_BASE		6
#define	SMICR_OPCODE			BIT_5S			/* OpCode */
#define	SMICR_READVALID			BIT_4S			/* ReadValid */
#define	SMICR_BUSY				BIT_3S			/* Busy */
/*		Bit(s) SMICR_RSRV_2_0 reserved */

/*	SMIDR		0x2884	SMI Data Register */
#define	SMIDR_DATA_MSK		SHIFT0(0xffffU)	/* Data */
#define	SMIDR_DATA_BASE		0

/*	PAR			0x2888	PHY Address Register */
/*		Bit(s) PAR_RSRV_15_6 reserved */
#define	PAR_MIBCLRMODE			BIT_5S			/* MIBclrMode */
#define	PAR_LOADTSTCNT			BIT_4S			/* LoadTstCnt */
/*		Bit(s) PAR_RSRV_3_0 reserved */

/* -------------------- */

#endif	/* __INC_SKY3HW_H */
