
struct it913xset {	u32 pro;
			u32 address;
			u8 reg[15];
			u8 count;
};

struct adctable {	u32 adcFrequency;
			u32 bandwidth;
			u32 coeff_1_2048;
			u32 coeff_1_4096;
			u32 coeff_1_8191;
			u32 coeff_1_8192;
			u32 coeff_1_8193;
			u32 coeff_2_2k;
			u32 coeff_2_4k;
			u32 coeff_2_8k;
			u16 bfsfcw_fftinx_ratio;
			u16 fftinx_bfsfcw_ratio;
};

/* clock and coeff tables only table 3 is used with IT9137*/
/* TODO other tables relate AF9035 may be removed */
static struct adctable tab1[] = {
	{	20156250, BANDWIDTH_6_MHZ,
		0x02b8ba6e, 0x015c5d37, 0x00ae340d, 0x00ae2e9b, 0x00ae292a,
		0x015c5d37, 0x00ae2e9b, 0x0057174e, 0x02f1, 0x015c	},
	{	20156250, BANDWIDTH_7_MHZ,
		0x032cd980, 0x01966cc0, 0x00cb3cba, 0x00cb3660, 0x00cb3007,
		0x01966cc0, 0x00cb3660, 0x00659b30, 0x0285, 0x0196	},
	{	20156250, BANDWIDTH_8_MHZ,
		0x03a0f893, 0x01d07c49, 0x00e84567, 0x00e83e25, 0x00e836e3,
		0x01d07c49, 0x00e83e25, 0x00741f12, 0x0234, 0x01d0	},
	{	20156250, BANDWIDTH_5_MHZ,
		0x02449b5c, 0x01224dae, 0x00912b60, 0x009126d7, 0x0091224e,
		0x01224dae, 0x009126d7, 0x0048936b, 0x0387, 0x0122	}
};

static struct adctable tab2[] = {
	{	20187500, BANDWIDTH_6_MHZ,
		0x02b7a654, 0x015bd32a, 0x00adef04, 0x00ade995, 0x00ade426,
		0x015bd32a, 0x00ade995, 0x0056f4ca, 0x02f2, 0x015c	},
	{	20187500, BANDWIDTH_7_MHZ,
		0x032b9761, 0x0195cbb1, 0x00caec30, 0x00cae5d8, 0x00cadf81,
		0x0195cbb1, 0x00cae5d8, 0x006572ec, 0x0286, 0x0196	},
	{	20187500, BANDWIDTH_8_MHZ,
		0x039f886f, 0x01cfc438, 0x00e7e95b, 0x00e7e21c, 0x00e7dadd,
		0x01cfc438, 0x00e7e21c, 0x0073f10e, 0x0235, 0x01d0	},
	{	20187500, BANDWIDTH_5_MHZ,
		0x0243b546, 0x0121daa3, 0x0090f1d9, 0x0090ed51, 0x0090e8ca,
		0x0121daa3, 0x0090ed51, 0x004876a9, 0x0388, 0x0122	}

};

static struct adctable tab3[] = {
	{	20250000, BANDWIDTH_6_MHZ,
		0x02b580ad, 0x015ac057, 0x00ad6597, 0x00ad602b, 0x00ad5ac1,
		0x015ac057, 0x00ad602b, 0x0056b016, 0x02f4, 0x015b	},
	{	20250000, BANDWIDTH_7_MHZ,
		0x03291620, 0x01948b10, 0x00ca4bda, 0x00ca4588, 0x00ca3f36,
		0x01948b10, 0x00ca4588, 0x006522c4, 0x0288, 0x0195	},
	{	20250000, BANDWIDTH_8_MHZ,
		0x039cab92, 0x01ce55c9, 0x00e7321e, 0x00e72ae4, 0x00e723ab,
		0x01ce55c9, 0x00e72ae4, 0x00739572, 0x0237, 0x01ce	},
	{	20250000, BANDWIDTH_5_MHZ,
		0x0241eb3b, 0x0120f59e, 0x00907f53, 0x00907acf, 0x0090764b,
		0x0120f59e, 0x00907acf, 0x00483d67, 0x038b, 0x0121	}

};

static struct adctable tab4[] = {
	{	20583333, BANDWIDTH_6_MHZ,
		0x02aa4598, 0x015522cc, 0x00aa96bb, 0x00aa9166, 0x00aa8c12,
		0x015522cc, 0x00aa9166, 0x005548b3, 0x0300, 0x0155	},
	{	20583333, BANDWIDTH_7_MHZ,
		0x031bfbdc, 0x018dfdee, 0x00c7052f, 0x00c6fef7, 0x00c6f8bf,
		0x018dfdee, 0x00c6fef7, 0x00637f7b, 0x0293, 0x018e	},
	{	20583333, BANDWIDTH_8_MHZ,
		0x038db21f, 0x01c6d910, 0x00e373a3, 0x00e36c88, 0x00e3656d,
		0x01c6d910, 0x00e36c88, 0x0071b644, 0x0240, 0x01c7	},
	{	20583333, BANDWIDTH_5_MHZ,
		0x02388f54, 0x011c47aa, 0x008e2846, 0x008e23d5, 0x008e1f64,
		0x011c47aa, 0x008e23d5, 0x004711ea, 0x039a, 0x011c	}

};

static struct adctable tab5[] = {
	{	20416667, BANDWIDTH_6_MHZ,
		0x02afd765, 0x0157ebb3, 0x00abfb39, 0x00abf5d9, 0x00abf07a,
		0x0157ebb3, 0x00abf5d9, 0x0055faed, 0x02fa, 0x0158	},
	{	20416667, BANDWIDTH_7_MHZ,
		0x03227b4b, 0x01913da6, 0x00c8a518, 0x00c89ed3, 0x00c8988e,
		0x01913da6, 0x00c89ed3, 0x00644f69, 0x028d, 0x0191	},
	{	20416667, BANDWIDTH_8_MHZ,
		0x03951f32, 0x01ca8f99, 0x00e54ef7, 0x00e547cc, 0x00e540a2,
		0x01ca8f99, 0x00e547cc, 0x0072a3e6, 0x023c, 0x01cb	},
	{	20416667, BANDWIDTH_5_MHZ,
		0x023d337f, 0x011e99c0, 0x008f515a, 0x008f4ce0, 0x008f4865,
		0x011e99c0, 0x008f4ce0, 0x0047a670, 0x0393, 0x011f	}

};

static struct adctable tab6[] = {
	{	20480000, BANDWIDTH_6_MHZ,
		0x02adb6db, 0x0156db6e, 0x00ab7312, 0x00ab6db7, 0x00ab685c,
		0x0156db6e, 0x00ab6db7, 0x0055b6db, 0x02fd, 0x0157	},
	{	20480000, BANDWIDTH_7_MHZ,
		0x03200000, 0x01900000, 0x00c80640, 0x00c80000, 0x00c7f9c0,
		0x01900000, 0x00c80000, 0x00640000, 0x028f, 0x0190	},
	{	20480000, BANDWIDTH_8_MHZ,
		0x03924925, 0x01c92492, 0x00e4996e, 0x00e49249, 0x00e48b25,
		0x01c92492, 0x00e49249, 0x00724925, 0x023d, 0x01c9	},
	{	20480000, BANDWIDTH_5_MHZ,
		0x023b6db7, 0x011db6db, 0x008edfe5, 0x008edb6e, 0x008ed6f7,
		0x011db6db, 0x008edb6e, 0x00476db7, 0x0396, 0x011e	}
};

static struct adctable tab7[] = {
	{	20500000, BANDWIDTH_6_MHZ,
		0x02ad0b99, 0x015685cc, 0x00ab4840, 0x00ab42e6, 0x00ab3d8c,
		0x015685cc, 0x00ab42e6, 0x0055a173, 0x02fd, 0x0157	},
	{	20500000, BANDWIDTH_7_MHZ,
		0x031f3832, 0x018f9c19, 0x00c7d44b, 0x00c7ce0c, 0x00c7c7ce,
		0x018f9c19, 0x00c7ce0c, 0x0063e706, 0x0290, 0x0190	},
	{	20500000, BANDWIDTH_8_MHZ,
		0x039164cb, 0x01c8b266, 0x00e46056, 0x00e45933, 0x00e45210,
		0x01c8b266, 0x00e45933, 0x00722c99, 0x023e, 0x01c9	},
	{	20500000, BANDWIDTH_5_MHZ,
		0x023adeff, 0x011d6f80, 0x008ebc36, 0x008eb7c0, 0x008eb34a,
		0x011d6f80, 0x008eb7c0, 0x00475be0, 0x0396, 0x011d	}

};

static struct adctable tab8[] = {
	{	20625000, BANDWIDTH_6_MHZ,
		0x02a8e4bd, 0x0154725e, 0x00aa3e81, 0x00aa392f, 0x00aa33de,
		0x0154725e, 0x00aa392f, 0x00551c98, 0x0302, 0x0154	},
	{	20625000, BANDWIDTH_7_MHZ,
		0x031a6032, 0x018d3019, 0x00c69e41, 0x00c6980c, 0x00c691d8,
		0x018d3019, 0x00c6980c, 0x00634c06, 0x0294, 0x018d	},
	{	20625000, BANDWIDTH_8_MHZ,
		0x038bdba6, 0x01c5edd3, 0x00e2fe02, 0x00e2f6ea, 0x00e2efd2,
		0x01c5edd3, 0x00e2f6ea, 0x00717b75, 0x0242, 0x01c6	},
	{	20625000, BANDWIDTH_5_MHZ,
		0x02376948, 0x011bb4a4, 0x008ddec1, 0x008dda52, 0x008dd5e3,
		0x011bb4a4, 0x008dda52, 0x0046ed29, 0x039c, 0x011c	}

};

struct table {
		u32 xtal;
		struct adctable *table;
};

static struct table fe_clockTable[] = {
		{12000000, tab3},	/* FPGA     */
		{16384000, tab6},	/* 16.38MHz */
		{20480000, tab6},	/* 20.48MHz */
		{36000000, tab3},	/* 36.00MHz */
		{30000000, tab1},	/* 30.00MHz */
		{26000000, tab4},	/* 26.00MHz */
		{28000000, tab5},	/* 28.00MHz */
		{32000000, tab7},	/* 32.00MHz */
		{34000000, tab2},	/* 34.00MHz */
		{24000000, tab1},	/* 24.00MHz */
		{22000000, tab8},	/* 22.00MHz */
		{12000000, tab3}	/* 12.00MHz */
};

/* fe get */
fe_code_rate_t fe_code[] = {
	FEC_1_2,
	FEC_2_3,
	FEC_3_4,
	FEC_5_6,
	FEC_7_8,
	FEC_NONE,
};

fe_guard_interval_t fe_gi[] = {
	GUARD_INTERVAL_1_32,
	GUARD_INTERVAL_1_16,
	GUARD_INTERVAL_1_8,
	GUARD_INTERVAL_1_4,
};

fe_hierarchy_t fe_hi[] = {
	HIERARCHY_NONE,
	HIERARCHY_1,
	HIERARCHY_2,
	HIERARCHY_4,
};

fe_transmit_mode_t fe_mode[] = {
	TRANSMISSION_MODE_2K,
	TRANSMISSION_MODE_8K,
	TRANSMISSION_MODE_4K,
};

fe_modulation_t fe_con[] = {
	QPSK,
	QAM_16,
	QAM_64,
};

/* Standard demodulator functions */
static struct it913xset set_solo_fe[] = {
	{PRO_LINK, DVBT_INTEN, {0x04}, 0x01},
	{PRO_LINK, DVBT_ENABLE, {0x05}, 0x01},
	{PRO_DMOD, MP2IF_MPEG_PAR_MODE, {0x00}, 0x01},
	{PRO_LINK, HOSTB_MPEG_SER_MODE, {0x00}, 0x01},
	{PRO_LINK, HOSTB_MPEG_PAR_MODE, {0x00}, 0x01},
	{PRO_DMOD, DCA_UPPER_CHIP, {0x00}, 0x01},
	{PRO_LINK, HOSTB_DCA_UPPER, {0x00}, 0x01},
	{PRO_DMOD, DCA_LOWER_CHIP, {0x00}, 0x01},
	{PRO_LINK, HOSTB_DCA_LOWER, {0x00}, 0x01},
	{PRO_DMOD, DCA_PLATCH, {0x00}, 0x01},
	{PRO_DMOD, DCA_FPGA_LATCH, {0x00}, 0x01},
	{PRO_DMOD, DCA_STAND_ALONE, {0x01}, 0x01},
	{PRO_DMOD, DCA_ENABLE, {0x00}, 0x01},
	{PRO_DMOD, MP2IF_MPEG_PAR_MODE, {0x00}, 0x01},
	{PRO_DMOD, BFS_FCW, {0x00, 0x00, 0x00}, 0x03},
	{0xff, 0x0000, {0x00}, 0x00}, /* Terminating Entry */
};

static struct it913xset init_1[] = {
	{PRO_LINK, LOCK3_OUT, {0x01}, 0x01},
	{PRO_LINK, PADMISCDRSR, {0x01}, 0x01},
	{PRO_LINK, PADMISCDR2, {0x00}, 0x01},
	{PRO_LINK, PADMISCDR4, {0x00}, 0x01}, /* Power up */
	{PRO_LINK, PADMISCDR8, {0x00}, 0x01},
	{0xff, 0x0000, {0x00}, 0x00} /* Terminating Entry */
};

/* ---------IT9137 0x38 tuner init---------- */
static struct it913xset it9137_set[] = {
	{PRO_DMOD, 0x0043, {0x00}, 0x01},
	{PRO_DMOD, 0x0046, {0x38}, 0x01},
	{PRO_DMOD, 0x0051, {0x01}, 0x01},
	{PRO_DMOD, 0x005f, {0x00, 0x00}, 0x02},
	{PRO_DMOD, 0x0068, {0x0a}, 0x01},
	{PRO_DMOD, 0x0070, {0x0a, 0x05, 0x02}, 0x03},
	{PRO_DMOD, 0x0075, {0x8c, 0x8c, 0x8c, 0xc8, 0x01}, 0x05},
	{PRO_DMOD, 0x007e, {0x04, 0x00}, 0x02},
	{PRO_DMOD, 0x0081, {	0x0a, 0x12, 0x02, 0x0a, 0x03, 0xc8, 0xb8,
				0xd0, 0xc3, 0x01	}, 0x0a},
	{PRO_DMOD, 0x008e, {0x01}, 0x01},
	{PRO_DMOD, 0x0092, {0x06, 0x00, 0x00, 0x00, 0x00}, 0x05},
	{PRO_DMOD, 0x0099, {0x01}, 0x01},
	{PRO_DMOD, 0x009b, {0x3c, 0x28}, 0x02},
	{PRO_DMOD, 0x009f, {0xe1, 0xcf}, 0x02},
	{PRO_DMOD, 0x00a3, {0x01, 0x5a, 0x01, 0x01}, 0x04},
	{PRO_DMOD, 0x00a9, {0x00, 0x01}, 0x02},
	{PRO_DMOD, 0x00b0, {0x01}, 0x01},
	{PRO_DMOD, 0x00b3, {0x02, 0x32}, 0x02},
	{PRO_DMOD, 0x00b6, {0x14}, 0x01},
	{PRO_DMOD, 0x00c0, {0x11, 0x00, 0x05}, 0x03},
	{PRO_DMOD, 0x00c4, {0x00}, 0x01},
	{PRO_DMOD, 0x00c6, {0x19, 0x00}, 0x02},
	{PRO_DMOD, 0x00cc, {0x2e, 0x51, 0x33}, 0x03},
	{PRO_DMOD, 0x00f3, {0x05, 0x8c, 0x8c}, 0x03},
	{PRO_DMOD, 0x00f8, {0x03, 0x06, 0x06}, 0x03},
	{PRO_DMOD, 0x00fc, {	0x02, 0x02, 0x02, 0x09, 0x50, 0x7b, 0x77,
				0x00, 0x02, 0xc8, 0x05, 0x7b	}, 0x0c},
	{PRO_DMOD, 0x0109, {0x02}, 0x01},
	{PRO_DMOD, 0x0115, {0x0a, 0x03}, 0x02},
	{PRO_DMOD, 0x011a, {0xc8, 0x7b, 0xbc, 0xa0}, 0x04},
	{PRO_DMOD, 0x0122, {0x02, 0x18, 0xc3}, 0x03},
	{PRO_DMOD, 0x0127, {0x00, 0x07}, 0x02},
	{PRO_DMOD, 0x012a, {0x53, 0x51, 0x4e, 0x43}, 0x04},
	{PRO_DMOD, 0x0137, {0x01, 0x00, 0x07, 0x00, 0x06}, 0x05},
	{PRO_DMOD, 0x013d, {0x00, 0x01, 0x5b, 0xc8}, 0x04},
	{PRO_DMOD, 0xf130, {0x04}, 0x01},
	{PRO_DMOD, 0xf132, {0x04}, 0x01},
	{PRO_DMOD, 0xf144, {0x1a}, 0x01},
	{PRO_DMOD, 0xf146, {0x00}, 0x01},
	{PRO_DMOD, 0xf14a, {0x01}, 0x01},
	{PRO_DMOD, 0xf14c, {0x00, 0x00}, 0x02},
	{PRO_DMOD, 0xf14f, {0x04}, 0x01},
	{PRO_DMOD, 0xf158, {0x7f}, 0x01},
	{PRO_DMOD, 0xf15a, {0x00, 0x08}, 0x02},
	{PRO_DMOD, 0xf15d, {0x03, 0x05}, 0x02},
	{PRO_DMOD, 0xf163, {0x05}, 0x01},
	{PRO_DMOD, 0xf166, {0x01, 0x40, 0x0f}, 0x03},
	{PRO_DMOD, 0xf17a, {0x00, 0x00}, 0x02},
	{PRO_DMOD, 0xf183, {0x01}, 0x01},
	{PRO_DMOD, 0xf19d, {0x40}, 0x01},
	{PRO_DMOD, 0xf1bc, {0x36, 0x00}, 0x02},
	{PRO_DMOD, 0xf1cb, {0xa0, 0x01}, 0x02},
	{PRO_DMOD, 0xf204, {0x10}, 0x01},
	{PRO_DMOD, 0xf214, {0x00}, 0x01},
	{PRO_DMOD, 0xf24c, {0x88, 0x95, 0x9a, 0x90}, 0x04},
	{PRO_DMOD, 0xf25a, {0x07, 0xe8, 0x03, 0xb0, 0x04}, 0x05},
	{PRO_DMOD, 0xf270, {0x01, 0x02, 0x01, 0x02}, 0x04},
	{PRO_DMOD, 0xf40e, {0x0a, 0x40, 0x08}, 0x03},
	{PRO_DMOD, 0xf55f, {0x0a}, 0x01},
	{PRO_DMOD, 0xf561, {0x15, 0x20}, 0x02},
	{PRO_DMOD, 0xf5df, {0xfb, 0x00}, 0x02},
	{PRO_DMOD, 0xf5e3, {0x09, 0x01, 0x01}, 0x03},
	{PRO_DMOD, 0xf5f8, {0x01}, 0x01},
	{PRO_DMOD, 0xf5fd, {0x01}, 0x01},
	{PRO_DMOD, 0xf600, {	0x05, 0x08, 0x0b, 0x0e, 0x11, 0x14, 0x17,
				0x1f	}, 0x08},
	{PRO_DMOD, 0xf60e, {0x00, 0x04, 0x32, 0x10}, 0x04},
	{PRO_DMOD, 0xf707, {0xfc, 0x00, 0x37, 0x00}, 0x04},
	{PRO_DMOD, 0xf78b, {0x01}, 0x01},
	{PRO_DMOD, 0xf80f, {0x40, 0x54, 0x5a}, 0x03},
	{PRO_DMOD, 0xf905, {0x01}, 0x01},
	{PRO_DMOD, 0xfb06, {0x03}, 0x01},
	{PRO_DMOD, 0xfd8b, {0x00}, 0x01},
	{PRO_LINK, GPIOH5_EN, {0x01}, 0x01},
	{PRO_LINK, GPIOH5_ON, {0x01}, 0x01},
	{PRO_LINK, GPIOH5_O, {0x00}, 0x01},
	{PRO_LINK, GPIOH5_O, {0x01}, 0x01},
	{0xff, 0x0000, {0x00}, 0x00}, /* Terminating Entry */
};

static struct it913xset it9137_tuner_off[] = {
	{PRO_DMOD, 0xfba8, {0x01}, 0x01}, /* Tuner Clock Off  */
	{PRO_DMOD, 0xec40, {0x00}, 0x01}, /* Power Down Tuner */
	{PRO_DMOD, 0xec02, {0x3f, 0x1f, 0x3f, 0x3f}, 0x04},
	{PRO_DMOD, 0xec3f, {0x01}, 0x01},
	{0xff, 0x0000, {0x00}, 0x00}, /* Terminating Entry */
};

static struct it913xset set_it9137_template[] = {
	{PRO_DMOD, 0xee06, {0x00}, 0x01},
	{PRO_DMOD, 0xec56, {0x00}, 0x01},
	{PRO_DMOD, 0xec4c, {0x00}, 0x01},
	{PRO_DMOD, 0xec4d, {0x00}, 0x01},
	{PRO_DMOD, 0xec4e, {0x00}, 0x01},
	{PRO_DMOD, 0xec4f, {0x00}, 0x01},
	{PRO_DMOD, 0xec50, {0x00}, 0x01},
	{0xff, 0x0000, {0x00}, 0x00}, /* Terminating Entry */
};
