#ifndef MY_ABC_HERE
#define MY_ABC_HERE
#endif
 
#ifndef __INCmvSatah
#define __INCmvSatah
#ifdef __cplusplus
extern "C"  
#endif  

#include "mvOsS.h"
#include "mvRegs.h"

#define MV_CORE_DRIVER_LOG_ID                   0

#define MV_SATA_VENDOR_ID                       0x11AB
#define MV_SATA_DEVICE_ID_5080                  0x5080
#define MV_SATA_DEVICE_ID_5081                  0x5081
#define MV_SATA_DEVICE_ID_5040                  0x5040
#define MV_SATA_DEVICE_ID_5041                  0x5041
#define MV_SATA_DEVICE_ID_6041                  0x6041
#define MV_SATA_DEVICE_ID_6081                  0x6081
#define MV_SATA_DEVICE_ID_6042                  0x6042
#define MV_SATA_DEVICE_ID_7042                  0x7042
#define MV_SATA_DEVICE_ID_5182                  0x5182  
#define MV_SATA_DEVICE_ID_5082                  0x5082  
#define MV_SATA_DEVICE_ID_6082                  0x6082  
#define MV_SATA_DEVICE_ID_6490                  0x6490  

#define MV_SATA_DEVICE_ID_78XX0                 0x7800  
#define MV_SATA_DEVICE_ID_78100                 0x7810  
#define MV_SATA_DEVICE_ID_78200                 0x7820  

#define MV_SATA_DEVICE_ID_6281                 0x6281  
#define MV_SATA_DEVICE_ID_6192                 0x6192  
#define MV_SATA_DEVICE_ID_6190                 0x6190  

#define MV_SATA_CHANNELS_NUM                    8
#define MV_SATA_UNITS_NUM                       2

#define MV_SATA_5082_PORT_NUM                   1
#define MV_SATA_5182_PORT_NUM                   2
#define MV_SATA_6082_PORT_NUM                   1
#define MV_SATA_6490_PORT_NUM                   1
#define MV_SATA_6281_PORT_NUM                   2
#define MV_SATA_6192_PORT_NUM                   2
#define MV_SATA_6190_PORT_NUM                   1
#define MV_SATA_78XX0_PORT_NUM                  2

#define MV_SATA_PM_MAX_PORTS                    15
#define MV_SATA_PM_CONTROL_PORT                 15

#define MV_EDMA_QUEUE_LENGTH                    32   
#define MV_EDMA_GEN2E_QUEUE_LENGTH              128

#ifndef MV_SATA_OVERRIDE_SW_QUEUE_SIZE
    #define MV_SATA_SW_QUEUE_SIZE                   (MV_EDMA_QUEUE_LENGTH -1)
#else
    #define MV_SATA_SW_QUEUE_SIZE                   MV_SATA_REQUESTED_SW_QUEUE_SIZE
#endif

#ifdef MV_SATA_SUPPORT_GEN2E_128_QUEUE_LEN
    #ifndef MV_SATA_OVERRIDE_GEN2E_SW_QUEUE_SIZE
        #define MV_SATA_GEN2E_SW_QUEUE_SIZE                   (MV_EDMA_GEN2E_QUEUE_LENGTH -1)
    #else
        #define MV_SATA_GEN2E_SW_QUEUE_SIZE                   MV_SATA_REQUESTED_GEN2E_SW_QUEUE_SIZE
    #endif
#else
    #define MV_SATA_GEN2E_SW_QUEUE_SIZE         (MV_SATA_SW_QUEUE_SIZE)
#endif

#if ((MV_SATA_SW_QUEUE_SIZE) >= (MV_EDMA_QUEUE_LENGTH))
#error "FATAL ERROR: Bad Value for MV_SATA_SW_QUEUE_SIZE "
#endif
#if ((MV_SATA_GEN2E_SW_QUEUE_SIZE) >= (MV_EDMA_GEN2E_QUEUE_LENGTH))
#error "FATAL ERROR: Bad Value for MV_EDMA_GEN2E_QUEUE_LENGTH "
#endif
#if ((MV_SATA_SW_QUEUE_SIZE) > (MV_SATA_GEN2E_SW_QUEUE_SIZE))
#error "FATAL ERROR: MV_SATA_SW_QUEUE_SIZE bigger than MV_EDMA_GEN2E_QUEUE_LENGTH"
#endif

#if (((MV_SATA_GEN2E_SW_QUEUE_SIZE) * 4) > ((MV_SATA_SW_QUEUE_SIZE) * 8))
#define _MV_SATA_COMMANDS_PER_ADAPTER ((MV_SATA_GEN2E_SW_QUEUE_SIZE) * 4)
#else
#define _MV_SATA_COMMANDS_PER_ADAPTER ((MV_SATA_SW_QUEUE_SIZE) * 8)
#endif

#define MV_EDMA_QUEUE_MASK                      0x1F
#define MV_EDMA_REQUEST_ENTRY_SIZE              32
#define MV_EDMA_RESPONSE_ENTRY_SIZE             8
#define MV_EDMA_REQUEST_QUEUE_SIZE              1024  
#define MV_EDMA_RESPONSE_QUEUE_SIZE             256   

#define MV_EDMA_GEN2E_QUEUE_MASK                      0x7F
#define MV_EDMA_GEN2E_REQUEST_QUEUE_SIZE              4096  
#define MV_EDMA_GEN2E_RESPONSE_QUEUE_SIZE             1024   

#define MV_EDMA_PRD_ENTRY_SIZE                  16       
#define MV_EDMA_PRD_NO_SNOOP_FLAG               MV_BIT0
#define MV_EDMA_PRD_EOT_FLAG                    MV_BIT15

#define MV_ATA_IDENTIFY_DEV_DATA_LENGTH         256  
#define MV_ATA_MODEL_NUMBER_LEN                 40
#define ATA_SECTOR_SIZE                         512
#define ATA_SECTOR_SIZE_IN_WORDS                256

#define MV_SATA_COMM_INIT_DELAY                 1000  
#define MV_SATA_COMM_INIT_WAIT_DELAY            20000  

#ifdef MV_SATA_C2C_COMM
    #define MV_SATA_REGISTER_HOST_2_DEVICE_FIS         0x00000034
    #define MV_SATA_DMA_ACTIVATE_FIS                   0x00000039
    #define MV_C2C_MESSAGE_SIZE                        10

#endif

#ifdef MV_SATA_IO_GRANULARITY
    #define MV_IOG_QUEUE_SIZE           0x40
    #define MV_IOG_INVALID_COMMAND_ID   MV_IOG_QUEUE_SIZE
#endif

typedef enum mvUdmaType
{
    MV_UDMA_TYPE_READ, MV_UDMA_TYPE_WRITE
} MV_UDMA_TYPE;

typedef enum mvFlushType
{
    MV_FLUSH_TYPE_CALLBACK, MV_FLUSH_TYPE_NONE
} MV_FLUSH_TYPE;

typedef enum mvCompletionType
{
    MV_COMPLETION_TYPE_NORMAL, MV_COMPLETION_TYPE_ERROR,
    MV_COMPLETION_TYPE_ABORT
} MV_COMPLETION_TYPE;

typedef enum mvEventType
{
    MV_EVENT_TYPE_ADAPTER_ERROR, MV_EVENT_TYPE_SATA_CABLE,
    MV_EVENT_TYPE_SATA_ERROR
} MV_EVENT_TYPE;

typedef enum mvSataCableEvent
{
    MV_SATA_CABLE_EVENT_DISCONNECT = 0,
    MV_SATA_CABLE_EVENT_CONNECT,
    MV_SATA_CABLE_EVENT_PM_HOT_PLUG
} MV_SATA_CABLE_EVENT;

typedef enum mvSataErrorEvent
{
    MV_SATA_RECOVERABLE_COMMUNICATION_ERROR = 0,
    MV_SATA_UNRECOVERABLE_COMMUNICATION_ERROR,
    MV_SATA_DEVICE_ERROR
} MV_SATA_ERROR_EVENT;

#ifdef MV_SATA_C2C_COMM
typedef enum mvC2CEventType
{
    MV_C2C_REGISTER_DEVICE_TO_HOST_FIS_DONE,
    MV_C2C_REGISTER_DEVICE_TO_HOST_FIS_ERROR,
    MV_C2C_BM_DMA_DONE,
    MV_C2C_BM_DMA_ERROR,
} MV_C2C_EVENT_TYPE;
#endif

typedef enum mvEdmaMode
{
    MV_EDMA_MODE_QUEUED,
    MV_EDMA_MODE_NOT_QUEUED,
    MV_EDMA_MODE_NATIVE_QUEUING
} MV_EDMA_MODE;

typedef enum mvQueueCommandResult
{
    MV_QUEUE_COMMAND_RESULT_OK = 0,
    MV_QUEUE_COMMAND_RESULT_QUEUED_MODE_DISABLED,
    MV_QUEUE_COMMAND_RESULT_FULL,
    MV_QUEUE_COMMAND_RESULT_BAD_LBA_ADDRESS,
    MV_QUEUE_COMMAND_RESULT_BAD_PARAMS
} MV_QUEUE_COMMAND_RESULT;

typedef enum mvNonUdmaProtocol
{
    MV_NON_UDMA_PROTOCOL_NON_DATA,
    MV_NON_UDMA_PROTOCOL_PIO_DATA_IN,
    MV_NON_UDMA_PROTOCOL_PIO_DATA_OUT,
    MV_NON_UDMA_PROTOCOL_PACKET_PIO_NON_DATA,
    MV_NON_UDMA_PROTOCOL_PACKET_PIO_DATA_IN,
    MV_NON_UDMA_PROTOCOL_PACKET_PIO_DATA_OUT,
    MV_NON_UDMA_PROTOCOL_PACKET_DMA
} MV_NON_UDMA_PROTOCOL;

typedef enum mvSataGeneration
{
    MV_SATA_GEN_I, MV_SATA_GEN_II, MV_SATA_GEN_IIE
} MV_SATA_GEN;

typedef enum mvSataInterfaceSpeed
{
    MV_SATA_IF_SPEED_1_5_GBPS, MV_SATA_IF_SPEED_3_GBPS,
    MV_SATA_IF_SPEED_NO_LIMIT, MV_SATA_IF_SPEED_INVALID
} MV_SATA_IF_SPEED;

typedef enum mvSataInterfacePowerState
{
    MV_SATA_IF_POWER_PHY_READY = 1, MV_SATA_IF_POWER_PARTIAL = 2,
    MV_SATA_IF_POWER_SLUMBER = 6
} MV_SATA_IF_POWER_STATE;

#ifdef MV_SATA_C2C_COMM
typedef enum mvSataC2CMode
{
    MV_SATA_C2C_MODE_INITIATOR, MV_SATA_C2C_MODE_TARGET
} MV_SATA_C2C_MODE;
#endif

typedef enum mvSataDeviceType
{
    MV_SATA_DEVICE_TYPE_UNKNOWN = 0,
    MV_SATA_DEVICE_TYPE_ATA_DISK,
    MV_SATA_DEVICE_TYPE_ATAPI_DEVICE,
    MV_SATA_DEVICE_TYPE_PM
} MV_SATA_DEVICE_TYPE;

typedef enum mvPMSwitchingmode
{   
    MV_SATA_SWITCHING_MODE_NONE = 0,
    MV_SATA_SWITCHING_MODE_CBS,
    MV_SATA_SWITCHING_MODE_QCBS,
    MV_SATA_SWITCHING_MODE_FBS,
}MV_SATA_SWITCHING_MODE;

struct mvDmaRequestQueueEntry;
struct mvDmaResponseQueueEntry;
struct mvDmaCommandEntry;

struct mvSataAdapter;
struct mvStorageDevRegisters;
struct mvSataChannel;

typedef MV_BOOLEAN (* mvSataCommandCompletionCallBack_t)(struct mvSataAdapter *,
                                                         MV_U8,
                                                         MV_COMPLETION_TYPE,
                                                         MV_VOID_PTR, MV_U16,
                                                         MV_U32,
                                                         struct mvStorageDevRegisters *);

#ifdef MY_ABC_HERE
struct _tag_SynoCommandExt;
typedef MV_BOOLEAN (* SynoMVSataCommandCompletionCallBack_t)(struct mvSataAdapter *,
                                                         MV_U8,
                                                         MV_COMPLETION_TYPE,
                                                         MV_VOID_PTR, MV_U16,
                                                         MV_U32,
                                                         struct mvStorageDevRegisters *,
                                                         struct _tag_SynoCommandExt *);
#endif

#ifdef MV_SATA_C2C_COMM
typedef  MV_BOOLEAN (*C2CCallBack_t)(struct mvSataAdapter *,
                                     struct mvSataChannel *,
                                     MV_C2C_EVENT_TYPE event,
                                     MV_U32 msgSize,
                                     MV_U8* msg);

#endif

typedef enum mvQueuedCommandType
{
    MV_QUEUED_COMMAND_TYPE_UDMA,
    MV_QUEUED_COMMAND_TYPE_NONE_UDMA,
    MV_QUEUED_COMMAND_TYPE_PACKET
} MV_QUEUED_COMMAND_TYPE;

#ifdef MV_SATA_IO_GRANULARITY
typedef enum mvIogQueuedCommandType
{
    MV_IOG_COMMAND_TYPE_FIRST,
    MV_IOG_COMMAND_TYPE_NEXT
}   MV_IOG_COMMAND_TYPE;
#endif

typedef enum mvSataInterruptScheme
{
    MV_SATA_INTERRUPT_HANDLING_IN_ISR,
    MV_SATA_INTERRUPT_HANDLING_IN_TASK,
    MV_SATA_INTERRUPTS_DISABLED
}MV_SATA_INTERRUPT_SCHEME;

typedef struct mvUdmaCommandParams
{
    MV_UDMA_TYPE readWrite;
    MV_BOOLEAN   isEXT;
    MV_BOOLEAN   FUA;
    MV_U32       lowLBAAddress;
    MV_U16       highLBAAddress;
    MV_U16       numOfSectors;
    MV_U32       prdLowAddr;
    MV_U32       prdHighAddr;
#ifdef MV_SATA_SUPPORT_EDMA_SINGLE_DATA_REGION
    MV_BOOLEAN   singleDataRegion;
    MV_U16       byteCount;
#endif
    mvSataCommandCompletionCallBack_t callBack;
    MV_VOID_PTR  commandId;
#ifdef MV_SATA_IO_GRANULARITY
    MV_BOOLEAN   ioGranularityEnabled;
    MV_IOG_COMMAND_TYPE  iogCommandType;
    union
    {
        MV_U8 transId;
        MV_U8 transCount;
    }   ioGranularityCommandParam;
    MV_U8 iogCurrentTransId;
#endif
} MV_UDMA_COMMAND_PARAMS;

typedef struct mvNoneUdmaCommandParams
{
    MV_NON_UDMA_PROTOCOL protocolType;
    MV_BOOLEAN  isEXT;
    MV_U16_PTR  bufPtr;
    MV_U32      count;
    MV_U16      features;
    MV_U16      sectorCount;
    MV_U16      lbaLow;
    MV_U16      lbaMid;
    MV_U16      lbaHigh;
    MV_U8       device;
    MV_U8       command;
    mvSataCommandCompletionCallBack_t callBack;
#ifdef MY_ABC_HERE
    SynoMVSataCommandCompletionCallBack_t SynoExtCallBack;
#endif
    MV_VOID_PTR  commandId;
} MV_NONE_UDMA_COMMAND_PARAMS;

typedef struct mvPacketCommandParams
{
    MV_NON_UDMA_PROTOCOL protocolType;
    MV_U16_PTR  bufPtr;
    MV_U32      buffer_len;
    MV_U32      transfered_data;
    MV_U8       cdb_len;
    MV_U16_PTR  cdb_buffer;  
    MV_U8       flags; 
                       
    MV_U32      prdLowAddr;
    MV_U32      prdHighAddr;
    mvSataCommandCompletionCallBack_t callBack;
    MV_VOID_PTR  commandId;
} MV_PACKET_COMMAND_PARAMS;

#ifdef MY_ABC_HERE

#define SYNO_PM_REQ_SUCCESS 0x0
#define SYNO_PM_REQ_FAIL 0x1

#define SYNO_PM_CMD_TIMEOUT 0x0

typedef struct _tag_SynoTaskFile {
    MV_U8    errorRegister;
    MV_U16   featuresRegister; 
    MV_U8    commandRegister; 
    MV_U16   sectorCountRegister;
    MV_U16   lbaLowRegister;
    MV_U16   lbaMidRegister;
    MV_U16   lbaHighRegister;
    MV_U8    deviceRegister;
    MV_U8    statusRegister;
}SynoTaskFile;

typedef struct _tag_SynoCommandExt {    
    SynoTaskFile result_tf;
    unsigned long flags;
    MV_VOID_PTR private_data;
}SynoCommandExt;
#endif

typedef struct mvQueueCommandInfo
{
    MV_QUEUED_COMMAND_TYPE  type;
    MV_U8   PMPort;
    union
    {
        MV_UDMA_COMMAND_PARAMS      udmaCommand;
        MV_NONE_UDMA_COMMAND_PARAMS NoneUdmaCommand;
        MV_PACKET_COMMAND_PARAMS     packetCommand;
    } commandParams;

#ifdef MY_ABC_HERE
    SynoCommandExt *pSynoCmdExt;
    MV_VOID_PTR pQueueCmdEntry;
#endif
} MV_QUEUE_COMMAND_INFO;

typedef struct mvQueuedCommandEntry
{
    MV_BOOLEAN   isFreeEntry;
     
    MV_U8        hostTag;
    MV_U8        deviceTag;
    MV_BOOLEAN   isCommandInEdma:1;
    MV_BOOLEAN   commandAborted:1;
    struct mvQueuedCommandEntry *next;
    struct mvQueuedCommandEntry *prev;
    MV_QUEUE_COMMAND_INFO   *pCommandInfo;
#ifndef MV_SATA_STORE_COMMANDS_INFO_ON_IAL_STACK
    MV_QUEUE_COMMAND_INFO   commandInfo;
#endif
#ifdef MY_ABC_HERE
    unsigned long syno_flags_ext;
#endif
} MV_QUEUED_COMMAND_ENTRY;

typedef enum mvErrorHandlingState
{
    MV_ERROR_HANDLING_STATE_IDLE,
    MV_ERROR_HANDLING_STATE_WAIT_FOR_COMPLETIONS,
    MV_ERROR_HANDLING_STATE_WAIT_FOR_BUSY,
    MV_ERROR_HANDLING_STATE_REQUEST_SENSE
}MV_ERROR_HANDLING_STATE;

typedef struct
{
    MV_ERROR_HANDLING_STATE state;
    MV_U16                      PortsWithErrors; 
    MV_U8                       CurrPort;
    MV_QUEUED_COMMAND_ENTRY     *pReadLogExtEntry;
    MV_U16_PTR                  ReadLogExtBuffer;
    MV_BOOLEAN                  useVendorUniqGen2WA;
}MV_ERROR_HANDLING_INFO;

#define MV_SATA_TAGS_PER_POOL                   32
#ifdef MV_SATA_SUPPORT_GEN2E_128_QUEUE_LEN
    #define MV_SATA_GEN2E_TAG_POOLS_NUM         (MV_SATA_PM_MAX_PORTS + 1)
    #define MV_SATA_GEN2E_TAG_PMPORT_MASK       0x0F
#else
    #define MV_SATA_GEN2E_TAG_POOLS_NUM         1
    #define MV_SATA_GEN2E_TAG_PMPORT_MASK       0x00
#endif

struct _mvTagsStack
{
    MV_U8   *pTagsArray;
    MV_U8   top;
};
struct _mvChannelTags
{
    struct _mvTagsStack  HostTagsPool;
    struct _mvTagsStack  DeviceTagsPool[MV_SATA_GEN2E_TAG_POOLS_NUM];
    MV_U8               HostTags[MV_SATA_GEN2E_SW_QUEUE_SIZE];
    MV_U8               DeviceTags[MV_SATA_GEN2E_TAG_POOLS_NUM][MV_SATA_TAGS_PER_POOL];
};

typedef enum mvHostInterfase
{
    MV_HOST_IF_INTEGRATED,    
    MV_HOST_IF_PEX,
    MV_HOST_IF_PCI  
}MV_HOST_IF;

typedef struct mvSataChannel
{
     
    MV_U8                       channelNumber;
    struct mvDmaRequestQueueEntry  *requestQueue;
    struct mvDmaResponseQueueEntry *responseQueue;
    MV_U32                      requestQueuePciHiAddress;
    MV_U32                      requestQueuePciLowAddress;
    MV_U32                      responseQueuePciHiAddress;
    MV_U32                      responseQueuePciLowAddress;
     
    MV_U8                       DRQDataBlockSize;
     
    struct mvSataAdapter        *mvSataAdapter;
    MV_OS_SEMAPHORE             semaphore;
    MV_U32                      eDmaRegsOffset;
    MV_BOOLEAN                  EdmaActive;
    MV_EDMA_MODE                queuedDMA;
    MV_U8                       outstandingCommands;
    MV_U8                       portQueuedCommands[MV_SATA_PM_MAX_PORTS + 1];
    struct mvQueuedCommandEntry *commandsQueue;
    struct mvQueuedCommandEntry *commandsQueueHead;
    struct mvQueuedCommandEntry *commandsQueueTail;
    MV_BOOLEAN                  queueCommandsEnabled;
    MV_U8                       noneUdmaOutstandingCommands;
#ifdef MV_SUPPORT_ATAPI
    MV_U8                       packetOutstandingCommands;
    MV_BOOLEAN                  waitForBMDMA;
#endif
    MV_U8                       EdmaQueuedCommands;
    MV_U8                       commandsQueueSize;
    struct _mvChannelTags       Tags;
    MV_U8                       reqInPtr;
    MV_U8                       rspOutPtr;
    MV_U8       		EDMAQueuePtrMask;
    MV_U32	                EDMARequestInpMask;
     
    MV_BOOLEAN                  PMSupported;
    MV_SATA_DEVICE_TYPE         deviceType;
    MV_BOOLEAN  		FBSEnabled;
    MV_BOOLEAN                  use128Entries;
#if defined(MY_ABC_HERE) || defined(MY_ABC_HERE)
     
    MV_SATA_DEVICE_TYPE         oldDeviceType;
#endif
#ifdef MY_ABC_HERE
    MV_U16                      PMvendorId;
    MV_U16                      PMdeviceId;
    MV_U8                       PMSynoUnique;
#endif
#ifdef MV_SATA_C2C_COMM

    MV_BOOLEAN                  C2CmodeEnabled;
    MV_SATA_C2C_MODE            C2CMode;
    C2CCallBack_t               C2CCallback;
#endif
    MV_U8                       recoveredErrorsCounter;
     
    MV_ERROR_HANDLING_INFO  ErrorHandlingInfo;
#ifdef MY_ABC_HERE
	unsigned long chkpower_flags;
	 
	#define CHKPOWER_CHECKING 0
	#define CHKPOWER_WAKING 1
	#define CHKPOWER_BLOCKING 2
	unsigned long tLastCmd;
	MV_QUEUE_COMMAND_INFO		CheckPowerCmd;
	MV_QUEUE_COMMAND_INFO		OrigCmd;
	struct timer_list	rstimer;
	struct list_head	pendinglh;
#endif  

#ifdef MY_ABC_HERE
	unsigned long  ssd_list;   
#endif
} MV_SATA_CHANNEL;

#if defined(MY_ABC_HERE) || defined(MY_ABC_HERE)
typedef struct _tag_SYNO_EH {
     
    MV_U32 flags;

    MV_U8 channel;

    MV_U8 retry_count;

    struct mvSataAdapter *pSataAdapter;

    MV_VOID_PTR pIalExt;

    MV_VOID_PTR pataScsiAdapterExt;

    struct delayed_work work;
}SYNO_EH;

enum {
     
    EH_DISCONNECT_TRIGGER = (1 << 0),
    EH_UNRECOVER_TRIGGER  = (1 << 1),
    EH_CONNECT_TRIGGER    = (1 << 2),

    EH_PROCESSING            = (1 << 5),
    EH_SCSI_DONE_NEEDED      = (1 << 6),
    EH_CONNECT_AGAIN         = (1 << 7),
#ifdef MY_ABC_HERE
    EH_HW_COM_ERROR          = (1 << 8),
#endif

    EH_LINK_DISK             = (1 << 20),
    EH_LINK_PMP              = (1 << 21),

#ifdef MY_ABC_HERE
     
    SYNO_PROBE_RETRY = (1 << 0),
    SYNO_PROBE_LIMIT_TO_15 = (1 << 1),
#endif
};
#endif

typedef struct mvSataAdapter
{
     
    MV_U32            adapterId;
    MV_VOID_PTR       IALData;
    MV_U8             pciConfigRevisionId;
    MV_U16            pciConfigDeviceId;
    MV_BUS_ADDR_T     adapterIoBaseAddress;
    MV_U32            intCoalThre[MV_SATA_UNITS_NUM];
    MV_U32            intTimeThre[MV_SATA_UNITS_NUM];
    MV_BOOLEAN        (*mvSataEventNotify)(struct mvSataAdapter *,
                                           MV_EVENT_TYPE,
                                           MV_U32, MV_U32);
    MV_SATA_CHANNEL   *sataChannel[MV_SATA_CHANNELS_NUM];
    MV_U32            pciCommand;
    MV_U32            pciSerrMask;
    MV_U32            pciInterruptMask;

    MV_SATA_GEN       sataAdapterGeneration;
    MV_BOOLEAN        staggaredSpinup[MV_SATA_CHANNELS_NUM];  
    MV_BOOLEAN        limitInterfaceSpeed[MV_SATA_CHANNELS_NUM];  
    MV_SATA_IF_SPEED  ifSpeed[MV_SATA_CHANNELS_NUM];   
    MV_SATA_IF_POWER_STATE ifPowerState[MV_SATA_CHANNELS_NUM];
    MV_U8             numberOfChannels; 
    MV_U8             numberOfUnits; 
    MV_U8             portsPerUnit;
    MV_OS_SEMAPHORE   semaphore;
    MV_U32            mainMask;
    MV_U32            mainMaskOffset;
    MV_U32            mainCauseOffset;
    MV_HOST_IF        hostInterface;
    MV_BOOLEAN        interruptsAreMasked;
    MV_SATA_INTERRUPT_SCHEME interruptsScheme;
    MV_OS_SEMAPHORE   interruptsMaskSem;
    MV_BOOLEAN        chipIs50XXB0;
    MV_BOOLEAN        chipIs50XXB2;
    MV_BOOLEAN        chipIs60X1B2;
    MV_BOOLEAN        chipIs60X1C0;
    MV_BOOLEAN        chipIs62X1Z0;
    MV_U8             signalAmps[MV_SATA_CHANNELS_NUM];
    MV_U8             pre[MV_SATA_CHANNELS_NUM];
    struct mvQueuedCommandEntry adapterCommands[_MV_SATA_COMMANDS_PER_ADAPTER];
#ifdef MV_SATA_IO_GRANULARITY
    MV_BOOLEAN        iogEnabled;
    MV_U8             iogFreeIdsStack[MV_IOG_QUEUE_SIZE];
    MV_U8             iogFreeIdsNum;
    MV_OS_SEMAPHORE   iogSemaphore;
#endif
#ifdef MY_ABC_HERE
    SYNO_EH           eh[MV_SATA_CHANNELS_NUM];
#endif
#ifdef MY_ABC_HERE
    MV_ULONG          flags[MV_SATA_CHANNELS_NUM];
#endif
} MV_SATA_ADAPTER;

typedef struct mvSataEdmaPRDEntry
{
    volatile MV_U32 lowBaseAddr;
    volatile MV_U16 byteCount;
    volatile MV_U16 flags;
    volatile MV_U32 highBaseAddr;
    volatile MV_U32 reserved;
}MV_SATA_EDMA_PRD_ENTRY;

MV_BOOLEAN mvSataInitAdapter(MV_SATA_ADAPTER *pAdapter);

MV_BOOLEAN mvSataShutdownAdapter(MV_SATA_ADAPTER *pAdapter);

MV_U32  mvSataReadReg(MV_SATA_ADAPTER *pAdapter, MV_U32 regOffset);

MV_VOID mvSataWriteReg(MV_SATA_ADAPTER *pAdapter, MV_U32 regOffset,
                       MV_U32 regValue);

MV_BOOLEAN mvSataConfigureChannel(MV_SATA_ADAPTER *pAdapter,
                                  MV_U8 channelIndex);

MV_BOOLEAN mvSataRemoveChannel(MV_SATA_ADAPTER *pAdapter, MV_U8 channelIndex);

MV_BOOLEAN mvSataIsStorageDeviceConnected(MV_SATA_ADAPTER *pAdapter,
                                          MV_U8 channelIndex, MV_U32 *SStatus);

MV_BOOLEAN mvSataIfD2HReceived(MV_SATA_ADAPTER *pAdapter,
			       MV_U8 channelIndex,
			       MV_U8 port);

MV_BOOLEAN mvSataChannelHardReset(MV_SATA_ADAPTER *pAdapter,
                                  MV_U8 channelIndex);

MV_BOOLEAN mvSataSetFBSMode(MV_SATA_ADAPTER *pAdapter, MV_U8 channelIndex,
							MV_BOOLEAN enableFBS, MV_BOOLEAN useQueueLen128);

MV_BOOLEAN mvSataConfigEdmaMode(MV_SATA_ADAPTER *pAdapter, MV_U8 channelIndex,
                                MV_EDMA_MODE eDmaMode, MV_U8 maxQueueDepth);

MV_BOOLEAN mvSataEnableChannelDma(MV_SATA_ADAPTER *pAdapter,
                                  MV_U8 channelIndex);

MV_BOOLEAN mvSataDisableChannelDma(MV_SATA_ADAPTER *pAdapter,
                                   MV_U8 channelIndex);

MV_BOOLEAN mvSataFlushDmaQueue(MV_SATA_ADAPTER *pAdapter, MV_U8 channelIndex,
                               MV_FLUSH_TYPE flushType);

MV_U8 mvSataNumOfDmaCommands(MV_SATA_ADAPTER *pAdapter, MV_U8 channelIndex);

MV_U8 mvSataGetNumOfPortQueuedCommands(MV_SATA_ADAPTER *pAdapter,
                                  MV_U8 channelIndex,
                                  MV_U8 PMPort,
                                  MV_U8 *pCommandsPerChannel);

MV_BOOLEAN mvSataSetIntCoalParams (MV_SATA_ADAPTER *pAdapter, MV_U8 sataUnit,
                                   MV_U32 intCoalThre, MV_U32 intTimeThre);

MV_BOOLEAN mvSataSetChannelPhyParams(MV_SATA_ADAPTER *pAdapter,
                                     MV_U8 channelIndex,
                                     MV_U8 signalAmps, MV_U8 pre);

MV_BOOLEAN mvSataChannelPhyShutdown(MV_SATA_ADAPTER *pAdapter,
                                    MV_U8 channelIndex);

MV_BOOLEAN mvSataChannelPhyPowerOn(MV_SATA_ADAPTER *pAdapter,
                                   MV_U8 channelIndex);

MV_BOOLEAN mvSataChannelFarLoopbackDiagnostic(MV_SATA_ADAPTER *pAdapter,
                                              MV_U8 channelIndex);
 
MV_QUEUE_COMMAND_RESULT mvSataQueueCommand(MV_SATA_ADAPTER *pAdapter,
                                           MV_U8 channelIndex,
                                           MV_QUEUE_COMMAND_INFO *pCommandParams);

#ifdef MY_ABC_HERE
MV_VOID SynoSataPMGPIOQueueCommandTimeout(MV_SATA_ADAPTER *pAdapter,
                                          MV_U8 channelIndex,
                                          MV_QUEUE_COMMAND_INFO *pCommandInfo);
#endif

MV_BOOLEAN mvSataInterruptServiceRoutine(MV_SATA_ADAPTER *pAdapter);

MV_BOOLEAN mvSataMaskAdapterInterrupt(MV_SATA_ADAPTER *pAdapter);

MV_BOOLEAN mvSataUnmaskAdapterInterrupt(MV_SATA_ADAPTER *pAdapter);

MV_BOOLEAN mvSataCheckPendingInterrupt(MV_SATA_ADAPTER *pAdapter);

MV_BOOLEAN mvSataSetInterruptsScheme(MV_SATA_ADAPTER *pAdapter,
                                     MV_SATA_INTERRUPT_SCHEME interruptScheme);

MV_BOOLEAN mvSataEnableStaggeredSpinUpAll (MV_SATA_ADAPTER *pAdapter);

MV_BOOLEAN mvSataEnableStaggeredSpinUp (MV_SATA_ADAPTER *pAdapter,
                                        MV_U8 channelIndex);

MV_BOOLEAN mvSataDisableStaggeredSpinUpAll (MV_SATA_ADAPTER *pAdapter);

MV_BOOLEAN mvSataDisableStaggeredSpinUp (MV_SATA_ADAPTER *pAdapter,
                                         MV_U8 channelIndex);

MV_BOOLEAN mvSataSetInterfaceSpeed (MV_SATA_ADAPTER *pAdapter,
                                    MV_U8 channelIndex,
                                    MV_SATA_IF_SPEED ifSpeed);

MV_SATA_IF_SPEED mvSataGetInterfaceSpeed (MV_SATA_ADAPTER *pAdapter,
                                          MV_U8 channelIndex);

MV_BOOLEAN mvSataSetInterfacePowerState (MV_SATA_ADAPTER *pAdapter,
                                         MV_U8 channelIndex,
                                         MV_SATA_IF_POWER_STATE ifPowerState);

MV_BOOLEAN mvSataGetInterfacePowerState (MV_SATA_ADAPTER *pAdapter,
                                         MV_U8 channelIndex,
                                         MV_SATA_IF_POWER_STATE *ifPowerState);

MV_BOOLEAN mvSataEventNotify(MV_SATA_ADAPTER *, MV_EVENT_TYPE ,
                             MV_U32, MV_U32);
#ifdef MV_SATA_C2C_COMM

MV_BOOLEAN mvSataC2CInit (MV_SATA_ADAPTER *pAdapter, MV_U8 channelIndex,
                          MV_SATA_C2C_MODE mvSataC2CMode,
                          C2CCallBack_t mvSataC2CCallBack);

MV_BOOLEAN mvSataC2CStop (MV_SATA_ADAPTER *pAdapter, MV_U8 channelIndex);

MV_BOOLEAN  mvSataC2CSendRegisterDeviceToHostFIS(
                                                MV_SATA_ADAPTER *pAdapter,
                                                MV_U8 channelIndex,
                                                MV_U8 pmPort,
                                                MV_BOOLEAN bInterrupt,
                                                MV_U8 message[MV_C2C_MESSAGE_SIZE]);

MV_BOOLEAN  mvSataC2CActivateBmDma(MV_SATA_ADAPTER *pAdapter,
                                   MV_U8 channelIndex,
                                   MV_U8 pmPort,
                                   MV_U32 prdTableHi,
                                   MV_U32 prdTableLow,
                                   MV_UDMA_TYPE dmaType);

MV_BOOLEAN mvSataC2CResetBmDma(MV_SATA_ADAPTER *pAdapter,
                               MV_U8 channelIndex);

#endif

#ifdef MV_SATA_IO_GRANULARITY

MV_BOOLEAN mvSataEnableIoGranularity(MV_SATA_ADAPTER *pAdapter,
                                     MV_BOOLEAN enable);

#endif
MV_BOOLEAN mvSata60X1B2CheckDevError(MV_SATA_ADAPTER *pAdapter,
                                       MV_U8 channelIndex);

#endif  
