/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "mvOs.h"
#include "../mvCpuCntrs.h"

const static MV_CPU_CNTRS_OPS mvCpuCntrsOpsTbl[MV_FEROCEON_CNTRS_NUM][MV_FEROCEON_CNTRS_OPS_NUM] = {
	/*0 */
	{
	 /*0x2 *//*0x4 *//*0x8 */
	 MV_CPU_CNTRS_CYCLES, MV_CPU_CNTRS_DCACHE_READ_HIT, MV_CPU_CNTRS_DCACHE_READ_MISS,
	 /*0x10 *//*0x20 *//*0x40 */
	 MV_CPU_CNTRS_DCACHE_WRITE_HIT, MV_CPU_CNTRS_DCACHE_WRITE_MISS, MV_CPU_CNTRS_INSTRUCTIONS,
	 /*0x80 *//*0x100 *//*0x200 */
	 MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID,
	 /*0x400 *//*0x800 *//*0x1000 */
	 MV_CPU_CNTRS_MMU_READ_LATENCY, MV_CPU_CNTRS_ICACHE_READ_LATENCY, MV_CPU_CNTRS_WB_WRITE_LATENCY,
	 /*0x2000 *//*0x4000 *//*0x8000 */
	 MV_CPU_CNTRS_LDM_STM_HOLD, MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID,
	 /*0x10000 *//*0x20000 *//*0x40000 */
	 MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_DATA_WRITE_ACCESS,
	 /*0x80000 *//*0x100000 *//*0x200000 */
	 MV_CPU_CNTRS_DATA_READ_ACCESS, MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID,
	 /*0x400000 *//*0x800000 *//*0x1000000 */
	 MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID,
	 /*0x2000000 *//*0x4000000 *//*0x8000000 */
	 MV_CPU_CNTRS_BRANCH_PREDICT_HIT, MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID,
	 },
	/*1 */
	{
	 /*0x2 *//*0x4 *//*0x8 */
	 MV_CPU_CNTRS_CYCLES, MV_CPU_CNTRS_ICACHE_READ_MISS, MV_CPU_CNTRS_DCACHE_READ_MISS,
	 /*0x10 *//*0x20 *//*0x40 */
	 MV_CPU_CNTRS_DCACHE_WRITE_MISS, MV_CPU_CNTRS_ITLB_MISS, MV_CPU_CNTRS_SINGLE_ISSUE,
	 /*0x80 *//*0x100 *//*0x200 */
	 MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_BRANCH_RETIRED, MV_CPU_CNTRS_INVALID,
	 /*0x400 *//*0x800 *//*0x1000 */
	 MV_CPU_CNTRS_MMU_READ_BEAT, MV_CPU_CNTRS_ICACHE_READ_LATENCY, MV_CPU_CNTRS_WB_WRITE_BEAT,
	 /*0x2000 *//*0x4000 *//*0x8000 */
	 MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_IS_HOLD,
	 /*0x10000 *//*0x20000 *//*0x40000 */
	 MV_CPU_CNTRS_DATA_READ_ACCESS, MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID,
	 /*0x80000 *//*0x100000 *//*0x200000 */
	 MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID,
	 /*0x400000 *//*0x800000 *//*0x1000000 */
	 MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID,
	 /*0x2000000 *//*0x4000000 *//*0x8000000 */
	 MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID,
	 },
	/*2 */
	{
	 /*0x2 *//*0x4 *//*0x8 */
	 MV_CPU_CNTRS_CYCLES, MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_DCACHE_ACCESS,
	 /*0x10 *//*0x20 *//*0x40 */
	 MV_CPU_CNTRS_DTLB_MISS, MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID,
	 /*0x80 *//*0x100 *//*0x200 */
	 MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_BRANCH_PREDICT_MISS, MV_CPU_CNTRS_WB_WRITE_BEAT,
	 /*0x400 *//*0x800 *//*0x1000 */
	 MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_DCACHE_READ_LATENCY, MV_CPU_CNTRS_DCACHE_WRITE_LATENCY,
	 /*0x2000 *//*0x4000 *//*0x8000 */
	 MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID,
	 /*0x10000 *//*0x20000 *//*0x40000 */
	 MV_CPU_CNTRS_BIU_SIMULT_ACCESS, MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID,
	 /*0x80000 *//*0x100000 *//*0x200000 */
	 MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID,
	 /*0x400000 *//*0x800000 *//*0x1000000 */
	 MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID,
	 /*0x2000000 *//*0x4000000 *//*0x8000000 */
	 MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID,
	 },
	/*3 */
	{
	 /*0x2 *//*0x4 *//*0x8 */
	 MV_CPU_CNTRS_CYCLES, MV_CPU_CNTRS_DCACHE_READ_MISS, MV_CPU_CNTRS_DCACHE_WRITE_MISS,
	 /*0x10 *//*0x20 *//*0x40 */
	 MV_CPU_CNTRS_TLB_MISS, MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID,
	 /*0x80 *//*0x100 *//*0x200 */
	 MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_BRANCH_TAKEN, MV_CPU_CNTRS_WB_FULL_CYCLES,
	 /*0x400 *//*0x800 *//*0x1000 */
	 MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_DCACHE_READ_BEAT, MV_CPU_CNTRS_DCACHE_WRITE_BEAT,
	 /*0x2000 *//*0x4000 *//*0x8000 */
	 MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID,
	 /*0x10000 *//*0x20000 *//*0x40000 */
	 MV_CPU_CNTRS_BIU_ANY_ACCESS, MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_DATA_WRITE_ACCESS,
	 /*0x80000 *//*0x100000 *//*0x200000 */
	 MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID,
	 /*0x400000 *//*0x800000 *//*0x1000000 */
	 MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID,
	 /*0x2000000 *//*0x4000000 *//*0x8000000 */
	 MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID, MV_CPU_CNTRS_INVALID,
	 }
};

int		mvCpuCntrsMap(int counter, MV_CPU_CNTRS_OPS op)
{
	int	i;

	for (i = 0; i < MV_FEROCEON_CNTRS_OPS_NUM; i++) {
		if (mvCpuCntrsOpsTbl[counter][i] == op)
			return (i + 1);
	}
	mvOsPrintf("invalid CPU counters event %d for counter %d\n", op, counter);
	return -1;
}

void mvCpuCntrsInit(void)
{
}
