/*
 * Freescale CLKCTRL Register Definitions
 *
 * Copyright 2008 Embedded Alley Solutions, Inc All Rights Reserved.
 * Copyright 2008-2010 Freescale Semiconductor, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * This file is created by xml file. Don't Edit it.
 *
 * Xml Revision: 1.48
 * Template revision: 26195
 */

#ifndef __REGS_CLKCTRL_MX23_H__
#define __REGS_CLKCTRL_MX23_H__

#define HW_CLKCTRL_PLLCTRL0	(0x00000000)
#define HW_CLKCTRL_PLLCTRL0_SET	(0x00000004)
#define HW_CLKCTRL_PLLCTRL0_CLR	(0x00000008)
#define HW_CLKCTRL_PLLCTRL0_TOG	(0x0000000c)

#define BP_CLKCTRL_PLLCTRL0_LFR_SEL	28
#define BM_CLKCTRL_PLLCTRL0_LFR_SEL	0x30000000
#define BF_CLKCTRL_PLLCTRL0_LFR_SEL(v)  \
		(((v) << 28) & BM_CLKCTRL_PLLCTRL0_LFR_SEL)
#define BV_CLKCTRL_PLLCTRL0_LFR_SEL__DEFAULT   0x0
#define BV_CLKCTRL_PLLCTRL0_LFR_SEL__TIMES_2   0x1
#define BV_CLKCTRL_PLLCTRL0_LFR_SEL__TIMES_05  0x2
#define BV_CLKCTRL_PLLCTRL0_LFR_SEL__UNDEFINED 0x3
#define BP_CLKCTRL_PLLCTRL0_CP_SEL	24
#define BM_CLKCTRL_PLLCTRL0_CP_SEL	0x03000000
#define BF_CLKCTRL_PLLCTRL0_CP_SEL(v)  \
		(((v) << 24) & BM_CLKCTRL_PLLCTRL0_CP_SEL)
#define BV_CLKCTRL_PLLCTRL0_CP_SEL__DEFAULT   0x0
#define BV_CLKCTRL_PLLCTRL0_CP_SEL__TIMES_2   0x1
#define BV_CLKCTRL_PLLCTRL0_CP_SEL__TIMES_05  0x2
#define BV_CLKCTRL_PLLCTRL0_CP_SEL__UNDEFINED 0x3
#define BP_CLKCTRL_PLLCTRL0_DIV_SEL	20
#define BM_CLKCTRL_PLLCTRL0_DIV_SEL	0x00300000
#define BF_CLKCTRL_PLLCTRL0_DIV_SEL(v)  \
		(((v) << 20) & BM_CLKCTRL_PLLCTRL0_DIV_SEL)
#define BV_CLKCTRL_PLLCTRL0_DIV_SEL__DEFAULT   0x0
#define BV_CLKCTRL_PLLCTRL0_DIV_SEL__LOWER     0x1
#define BV_CLKCTRL_PLLCTRL0_DIV_SEL__LOWEST    0x2
#define BV_CLKCTRL_PLLCTRL0_DIV_SEL__UNDEFINED 0x3
#define BM_CLKCTRL_PLLCTRL0_EN_USB_CLKS	0x00040000
#define BM_CLKCTRL_PLLCTRL0_POWER	0x00010000

#define HW_CLKCTRL_PLLCTRL1	(0x00000010)

#define BM_CLKCTRL_PLLCTRL1_LOCK	0x80000000
#define BM_CLKCTRL_PLLCTRL1_FORCE_LOCK	0x40000000
#define BP_CLKCTRL_PLLCTRL1_LOCK_COUNT	0
#define BM_CLKCTRL_PLLCTRL1_LOCK_COUNT	0x0000FFFF
#define BF_CLKCTRL_PLLCTRL1_LOCK_COUNT(v)  \
		(((v) << 0) & BM_CLKCTRL_PLLCTRL1_LOCK_COUNT)

#define HW_CLKCTRL_CPU	(0x00000020)
#define HW_CLKCTRL_CPU_SET	(0x00000024)
#define HW_CLKCTRL_CPU_CLR	(0x00000028)
#define HW_CLKCTRL_CPU_TOG	(0x0000002c)

#define BM_CLKCTRL_CPU_BUSY_REF_XTAL	0x20000000
#define BM_CLKCTRL_CPU_BUSY_REF_CPU	0x10000000
#define BM_CLKCTRL_CPU_DIV_XTAL_FRAC_EN	0x04000000
#define BP_CLKCTRL_CPU_DIV_XTAL	16
#define BM_CLKCTRL_CPU_DIV_XTAL	0x03FF0000
#define BF_CLKCTRL_CPU_DIV_XTAL(v)  \
		(((v) << 16) & BM_CLKCTRL_CPU_DIV_XTAL)
#define BM_CLKCTRL_CPU_INTERRUPT_WAIT	0x00001000
#define BM_CLKCTRL_CPU_DIV_CPU_FRAC_EN	0x00000400
#define BP_CLKCTRL_CPU_DIV_CPU	0
#define BM_CLKCTRL_CPU_DIV_CPU	0x0000003F
#define BF_CLKCTRL_CPU_DIV_CPU(v)  \
		(((v) << 0) & BM_CLKCTRL_CPU_DIV_CPU)

#define HW_CLKCTRL_HBUS	(0x00000030)
#define HW_CLKCTRL_HBUS_SET	(0x00000034)
#define HW_CLKCTRL_HBUS_CLR	(0x00000038)
#define HW_CLKCTRL_HBUS_TOG	(0x0000003c)

#define BM_CLKCTRL_HBUS_BUSY	0x20000000
#define BM_CLKCTRL_HBUS_DCP_AS_ENABLE	0x10000000
#define BM_CLKCTRL_HBUS_PXP_AS_ENABLE	0x08000000
#define BM_CLKCTRL_HBUS_APBHDMA_AS_ENABLE	0x04000000
#define BM_CLKCTRL_HBUS_APBXDMA_AS_ENABLE	0x02000000
#define BM_CLKCTRL_HBUS_TRAFFIC_JAM_AS_ENABLE	0x01000000
#define BM_CLKCTRL_HBUS_TRAFFIC_AS_ENABLE	0x00800000
#define BM_CLKCTRL_HBUS_CPU_DATA_AS_ENABLE	0x00400000
#define BM_CLKCTRL_HBUS_CPU_INSTR_AS_ENABLE	0x00200000
#define BM_CLKCTRL_HBUS_AUTO_SLOW_MODE	0x00100000
#define BP_CLKCTRL_HBUS_SLOW_DIV	16
#define BM_CLKCTRL_HBUS_SLOW_DIV	0x00070000
#define BF_CLKCTRL_HBUS_SLOW_DIV(v)  \
		(((v) << 16) & BM_CLKCTRL_HBUS_SLOW_DIV)
#define BV_CLKCTRL_HBUS_SLOW_DIV__BY1  0x0
#define BV_CLKCTRL_HBUS_SLOW_DIV__BY2  0x1
#define BV_CLKCTRL_HBUS_SLOW_DIV__BY4  0x2
#define BV_CLKCTRL_HBUS_SLOW_DIV__BY8  0x3
#define BV_CLKCTRL_HBUS_SLOW_DIV__BY16 0x4
#define BV_CLKCTRL_HBUS_SLOW_DIV__BY32 0x5
#define BM_CLKCTRL_HBUS_DIV_FRAC_EN	0x00000020
#define BP_CLKCTRL_HBUS_DIV	0
#define BM_CLKCTRL_HBUS_DIV	0x0000001F
#define BF_CLKCTRL_HBUS_DIV(v)  \
		(((v) << 0) & BM_CLKCTRL_HBUS_DIV)

#define HW_CLKCTRL_XBUS	(0x00000040)

#define BM_CLKCTRL_XBUS_BUSY	0x80000000
#define BM_CLKCTRL_XBUS_DIV_FRAC_EN	0x00000400
#define BP_CLKCTRL_XBUS_DIV	0
#define BM_CLKCTRL_XBUS_DIV	0x000003FF
#define BF_CLKCTRL_XBUS_DIV(v)  \
		(((v) << 0) & BM_CLKCTRL_XBUS_DIV)

#define HW_CLKCTRL_XTAL	(0x00000050)
#define HW_CLKCTRL_XTAL_SET	(0x00000054)
#define HW_CLKCTRL_XTAL_CLR	(0x00000058)
#define HW_CLKCTRL_XTAL_TOG	(0x0000005c)

#define BP_CLKCTRL_XTAL_UART_CLK_GATE	31
#define BM_CLKCTRL_XTAL_UART_CLK_GATE	0x80000000
#define BP_CLKCTRL_XTAL_FILT_CLK24M_GATE	30
#define BM_CLKCTRL_XTAL_FILT_CLK24M_GATE	0x40000000
#define BP_CLKCTRL_XTAL_PWM_CLK24M_GATE	29
#define BM_CLKCTRL_XTAL_PWM_CLK24M_GATE	0x20000000
#define BM_CLKCTRL_XTAL_DRI_CLK24M_GATE	0x10000000
#define BM_CLKCTRL_XTAL_DIGCTRL_CLK1M_GATE	0x08000000
#define BP_CLKCTRL_XTAL_TIMROT_CLK32K_GATE	26
#define BM_CLKCTRL_XTAL_TIMROT_CLK32K_GATE	0x04000000
#define BP_CLKCTRL_XTAL_DIV_UART	0
#define BM_CLKCTRL_XTAL_DIV_UART	0x00000003
#define BF_CLKCTRL_XTAL_DIV_UART(v)  \
		(((v) << 0) & BM_CLKCTRL_XTAL_DIV_UART)

#define HW_CLKCTRL_PIX	(0x00000060)

#define BP_CLKCTRL_PIX_CLKGATE	31
#define BM_CLKCTRL_PIX_CLKGATE	0x80000000
#define BM_CLKCTRL_PIX_BUSY	0x20000000
#define BM_CLKCTRL_PIX_DIV_FRAC_EN	0x00001000
#define BP_CLKCTRL_PIX_DIV	0
#define BM_CLKCTRL_PIX_DIV	0x00000FFF
#define BF_CLKCTRL_PIX_DIV(v)  \
		(((v) << 0) & BM_CLKCTRL_PIX_DIV)

#define HW_CLKCTRL_SSP	(0x00000070)

#define BP_CLKCTRL_SSP_CLKGATE	31
#define BM_CLKCTRL_SSP_CLKGATE	0x80000000
#define BM_CLKCTRL_SSP_BUSY	0x20000000
#define BM_CLKCTRL_SSP_DIV_FRAC_EN	0x00000200
#define BP_CLKCTRL_SSP_DIV	0
#define BM_CLKCTRL_SSP_DIV	0x000001FF
#define BF_CLKCTRL_SSP_DIV(v)  \
		(((v) << 0) & BM_CLKCTRL_SSP_DIV)

#define HW_CLKCTRL_GPMI	(0x00000080)

#define BP_CLKCTRL_GPMI_CLKGATE	31
#define BM_CLKCTRL_GPMI_CLKGATE	0x80000000
#define BM_CLKCTRL_GPMI_BUSY	0x20000000
#define BM_CLKCTRL_GPMI_DIV_FRAC_EN	0x00000400
#define BP_CLKCTRL_GPMI_DIV	0
#define BM_CLKCTRL_GPMI_DIV	0x000003FF
#define BF_CLKCTRL_GPMI_DIV(v)  \
		(((v) << 0) & BM_CLKCTRL_GPMI_DIV)

#define HW_CLKCTRL_SPDIF	(0x00000090)

#define BM_CLKCTRL_SPDIF_CLKGATE	0x80000000

#define HW_CLKCTRL_EMI	(0x000000a0)

#define BP_CLKCTRL_EMI_CLKGATE	31
#define BM_CLKCTRL_EMI_CLKGATE	0x80000000
#define BM_CLKCTRL_EMI_SYNC_MODE_EN	0x40000000
#define BM_CLKCTRL_EMI_BUSY_REF_XTAL	0x20000000
#define BM_CLKCTRL_EMI_BUSY_REF_EMI	0x10000000
#define BM_CLKCTRL_EMI_BUSY_REF_CPU	0x08000000
#define BM_CLKCTRL_EMI_BUSY_SYNC_MODE	0x04000000
#define BM_CLKCTRL_EMI_BUSY_DCC_RESYNC	0x00020000
#define BM_CLKCTRL_EMI_DCC_RESYNC_ENABLE	0x00010000
#define BP_CLKCTRL_EMI_DIV_XTAL	8
#define BM_CLKCTRL_EMI_DIV_XTAL	0x00000F00
#define BF_CLKCTRL_EMI_DIV_XTAL(v)  \
		(((v) << 8) & BM_CLKCTRL_EMI_DIV_XTAL)
#define BP_CLKCTRL_EMI_DIV_EMI	0
#define BM_CLKCTRL_EMI_DIV_EMI	0x0000003F
#define BF_CLKCTRL_EMI_DIV_EMI(v)  \
		(((v) << 0) & BM_CLKCTRL_EMI_DIV_EMI)

#define HW_CLKCTRL_IR	(0x000000b0)

#define BM_CLKCTRL_IR_CLKGATE	0x80000000
#define BM_CLKCTRL_IR_AUTO_DIV	0x20000000
#define BM_CLKCTRL_IR_IR_BUSY	0x10000000
#define BM_CLKCTRL_IR_IROV_BUSY	0x08000000
#define BP_CLKCTRL_IR_IROV_DIV	16
#define BM_CLKCTRL_IR_IROV_DIV	0x01FF0000
#define BF_CLKCTRL_IR_IROV_DIV(v)  \
		(((v) << 16) & BM_CLKCTRL_IR_IROV_DIV)
#define BP_CLKCTRL_IR_IR_DIV	0
#define BM_CLKCTRL_IR_IR_DIV	0x000003FF
#define BF_CLKCTRL_IR_IR_DIV(v)  \
		(((v) << 0) & BM_CLKCTRL_IR_IR_DIV)

#define HW_CLKCTRL_SAIF	(0x000000c0)

#define BM_CLKCTRL_SAIF_CLKGATE	0x80000000
#define BM_CLKCTRL_SAIF_BUSY	0x20000000
#define BM_CLKCTRL_SAIF_DIV_FRAC_EN	0x00010000
#define BP_CLKCTRL_SAIF_DIV	0
#define BM_CLKCTRL_SAIF_DIV	0x0000FFFF
#define BF_CLKCTRL_SAIF_DIV(v)  \
		(((v) << 0) & BM_CLKCTRL_SAIF_DIV)

#define HW_CLKCTRL_TV	(0x000000d0)

#define BM_CLKCTRL_TV_CLK_TV108M_GATE	0x80000000
#define BM_CLKCTRL_TV_CLK_TV_GATE	0x40000000

#define HW_CLKCTRL_ETM	(0x000000e0)

#define BM_CLKCTRL_ETM_CLKGATE	0x80000000
#define BM_CLKCTRL_ETM_BUSY	0x20000000
#define BM_CLKCTRL_ETM_DIV_FRAC_EN	0x00000040
#define BP_CLKCTRL_ETM_DIV	0
#define BM_CLKCTRL_ETM_DIV	0x0000003F
#define BF_CLKCTRL_ETM_DIV(v)  \
		(((v) << 0) & BM_CLKCTRL_ETM_DIV)

#define HW_CLKCTRL_FRAC	(0x000000f0)
#define HW_CLKCTRL_FRAC_SET	(0x000000f4)
#define HW_CLKCTRL_FRAC_CLR	(0x000000f8)
#define HW_CLKCTRL_FRAC_TOG	(0x000000fc)

#define BP_CLKCTRL_FRAC_CLKGATEIO	31
#define BM_CLKCTRL_FRAC_CLKGATEIO	0x80000000
#define BM_CLKCTRL_FRAC_IO_STABLE	0x40000000
#define BP_CLKCTRL_FRAC_IOFRAC	24
#define BM_CLKCTRL_FRAC_IOFRAC	0x3F000000
#define BF_CLKCTRL_FRAC_IOFRAC(v)  \
		(((v) << 24) & BM_CLKCTRL_FRAC_IOFRAC)
#define BP_CLKCTRL_FRAC_CLKGATEPIX	23
#define BM_CLKCTRL_FRAC_CLKGATEPIX	0x00800000
#define BM_CLKCTRL_FRAC_PIX_STABLE	0x00400000
#define BP_CLKCTRL_FRAC_PIXFRAC	16
#define BM_CLKCTRL_FRAC_PIXFRAC	0x003F0000
#define BF_CLKCTRL_FRAC_PIXFRAC(v)  \
		(((v) << 16) & BM_CLKCTRL_FRAC_PIXFRAC)
#define BP_CLKCTRL_FRAC_CLKGATEEMI	15
#define BM_CLKCTRL_FRAC_CLKGATEEMI	0x00008000
#define BM_CLKCTRL_FRAC_EMI_STABLE	0x00004000
#define BP_CLKCTRL_FRAC_EMIFRAC	8
#define BM_CLKCTRL_FRAC_EMIFRAC	0x00003F00
#define BF_CLKCTRL_FRAC_EMIFRAC(v)  \
		(((v) << 8) & BM_CLKCTRL_FRAC_EMIFRAC)
#define BP_CLKCTRL_FRAC_CLKGATECPU	7
#define BM_CLKCTRL_FRAC_CLKGATECPU	0x00000080
#define BM_CLKCTRL_FRAC_CPU_STABLE	0x00000040
#define BP_CLKCTRL_FRAC_CPUFRAC	0
#define BM_CLKCTRL_FRAC_CPUFRAC	0x0000003F
#define BF_CLKCTRL_FRAC_CPUFRAC(v)  \
		(((v) << 0) & BM_CLKCTRL_FRAC_CPUFRAC)

#define HW_CLKCTRL_FRAC1	(0x00000100)
#define HW_CLKCTRL_FRAC1_SET	(0x00000104)
#define HW_CLKCTRL_FRAC1_CLR	(0x00000108)
#define HW_CLKCTRL_FRAC1_TOG	(0x0000010c)

#define BM_CLKCTRL_FRAC1_CLKGATEVID	0x80000000
#define BM_CLKCTRL_FRAC1_VID_STABLE	0x40000000

#define HW_CLKCTRL_CLKSEQ	(0x00000110)
#define HW_CLKCTRL_CLKSEQ_SET	(0x00000114)
#define HW_CLKCTRL_CLKSEQ_CLR	(0x00000118)
#define HW_CLKCTRL_CLKSEQ_TOG	(0x0000011c)

#define BM_CLKCTRL_CLKSEQ_BYPASS_ETM	0x00000100
#define BM_CLKCTRL_CLKSEQ_BYPASS_CPU	0x00000080
#define BM_CLKCTRL_CLKSEQ_BYPASS_EMI	0x00000040
#define BM_CLKCTRL_CLKSEQ_BYPASS_SSP	0x00000020
#define BM_CLKCTRL_CLKSEQ_BYPASS_GPMI	0x00000010
#define BM_CLKCTRL_CLKSEQ_BYPASS_IR	0x00000008
#define BM_CLKCTRL_CLKSEQ_BYPASS_PIX	0x00000002
#define BM_CLKCTRL_CLKSEQ_BYPASS_SAIF	0x00000001

#define HW_CLKCTRL_RESET	(0x00000120)

#define BM_CLKCTRL_RESET_CHIP	0x00000002
#define BM_CLKCTRL_RESET_DIG	0x00000001

#define HW_CLKCTRL_STATUS	(0x00000130)

#define BP_CLKCTRL_STATUS_CPU_LIMIT	30
#define BM_CLKCTRL_STATUS_CPU_LIMIT	0xC0000000
#define BF_CLKCTRL_STATUS_CPU_LIMIT(v) \
		(((v) << 30) & BM_CLKCTRL_STATUS_CPU_LIMIT)

#define HW_CLKCTRL_VERSION	(0x00000140)

#define BP_CLKCTRL_VERSION_MAJOR	24
#define BM_CLKCTRL_VERSION_MAJOR	0xFF000000
#define BF_CLKCTRL_VERSION_MAJOR(v) \
		(((v) << 24) & BM_CLKCTRL_VERSION_MAJOR)
#define BP_CLKCTRL_VERSION_MINOR	16
#define BM_CLKCTRL_VERSION_MINOR	0x00FF0000
#define BF_CLKCTRL_VERSION_MINOR(v)  \
		(((v) << 16) & BM_CLKCTRL_VERSION_MINOR)
#define BP_CLKCTRL_VERSION_STEP	0
#define BM_CLKCTRL_VERSION_STEP	0x0000FFFF
#define BF_CLKCTRL_VERSION_STEP(v)  \
		(((v) << 0) & BM_CLKCTRL_VERSION_STEP)

#endif /* __REGS_CLKCTRL_MX23_H__ */
