#ifndef MY_ABC_HERE
#define MY_ABC_HERE
#endif
 
#ifndef __ASM_ARCH_AURORA_H
#define __ASM_ARCH_AURORA_H

#include <mach/vmalloc.h>

#define CONFIG_DRAM_IO_RESERVE_BASE	0xF0000000ll

#define SDRAM_CS0_BASE  		0x00000000
#define SDRAM_CS0_SIZE  		_256M
#define SDRAM_CS1_BASE  		0x10000000
#define SDRAM_CS1_SIZE  		_256M
#define SDRAM_CS2_BASE  		0x20000000
#define SDRAM_CS2_SIZE  		_256M
#define SDRAM_CS3_BASE  		0x30000000
#define SDRAM_CS3_SIZE  		_256M

#define INTER_REGS_PHYS_BASE	0xF1000000
#define INTER_REGS_VIRT_BASE	0xFBC00000
#define INTER_REGS_BASE			INTER_REGS_VIRT_BASE  

#define UART_REGS_BASE			0xF1200000
#define UART_VIRT_BASE			0xFBE00000
#define UART_SIZE			_1M

#define PNC_BM_PHYS_BASE		0xF1300000
#define PNC_BM_SIZE			_1M

#define CRYPT_ENG_PHYS_BASE(chan)	(0xF1400000 + (chan * 0x10000))
#define CRYPT_ENG_VIRT_BASE(chan)	(0xFC000000 + (chan * 0x10000))
#define CRYPT_ENG_SIZE			_64K

#define PMU_SCRATCH_PHYS_BASE		0xF1500000
#define PMU_SCRATCH_VIRT_BASE		0xFC100000
#define PMU_SCRATCH_SIZE		_1M

#define PEX0_IO_PHYS_BASE		0xF1600000
#define PEX0_IO_VIRT_BASE		0xFC200000
#define PEX0_IO_SIZE			_1M
#define PEX1_IO_PHYS_BASE		0xF1700000
#define PEX1_IO_VIRT_BASE		0xFC300000
#define PEX1_IO_SIZE			_1M
#define PEX2_IO_PHYS_BASE		0xF1800000
#define PEX2_IO_VIRT_BASE		0xFC400000
#define PEX2_IO_SIZE			_1M
#define PEX3_IO_PHYS_BASE		0xF1900000
#define PEX3_IO_VIRT_BASE		0xFC500000
#define PEX3_IO_SIZE			_1M
#define PEX4_IO_PHYS_BASE		0xF1A00000
#define PEX4_IO_VIRT_BASE		0xFC600000
#define PEX4_IO_SIZE			_1M
#define PEX5_IO_PHYS_BASE		0xF1B00000
#define PEX5_IO_VIRT_BASE		0xFC700000
#define PEX5_IO_SIZE			_1M
#define PEX6_IO_PHYS_BASE		0xF1C00000
#define PEX6_IO_VIRT_BASE		0xFC800000
#define PEX6_IO_SIZE			_1M
#define PEX7_IO_PHYS_BASE		0xF1D00000
#define PEX7_IO_VIRT_BASE		0xFC900000
#define PEX7_IO_SIZE			_1M
#define PEX8_IO_PHYS_BASE		0xF1E00000
#define PEX8_IO_VIRT_BASE		0xFCA00000
#define PEX8_IO_SIZE			_1M
#define PEX9_IO_PHYS_BASE		0xF1F00000
#define PEX9_IO_VIRT_BASE		0xFCB00000
#define PEX9_IO_SIZE			_1M

#define PEX0_MEM_PHYS_BASE		0xF2000000
#define PEX0_MEM_SIZE			_2M
#define PEX1_MEM_PHYS_BASE		0xF2200000
#define PEX1_MEM_SIZE			_2M
#define PEX2_MEM_PHYS_BASE		0xF2400000
#define PEX2_MEM_SIZE			_2M
#define PEX3_MEM_PHYS_BASE		0xF2600000
#define PEX3_MEM_SIZE			_2M
#define PEX4_MEM_PHYS_BASE		0xF2800000
#define PEX4_MEM_SIZE			_2M
#define PEX5_MEM_PHYS_BASE		0xF2A00000
#define PEX5_MEM_SIZE			_2M
#define PEX6_MEM_PHYS_BASE		0xF2C00000
#define PEX6_MEM_SIZE			_2M
#define PEX7_MEM_PHYS_BASE		0xF2E00000
#define PEX7_MEM_SIZE			_2M
#define PEX8_MEM_PHYS_BASE		0xF3000000
#define PEX8_MEM_SIZE			_2M
#define PEX9_MEM_PHYS_BASE		0xF3200000
#define PEX9_MEM_SIZE			_2M

#define DEVICE_CS0_PHYS_BASE		0xF3300000
#define DEVICE_CS0_SIZE			_1M
#define DEVICE_CS1_PHYS_BASE		0xF3400000
#define DEVICE_CS1_SIZE			_1M
#define DEVICE_CS2_PHYS_BASE		0xF3500000
#define DEVICE_CS2_SIZE			_1M
#define DEVICE_CS3_PHYS_BASE		0xF3600000
#define DEVICE_CS3_SIZE			_1M

#define DEVICE_BOOTCS_PHYS_BASE		0xF4000000
#define DEVICE_BOOTCS_SIZE		_32M

#ifdef MY_ABC_HERE
#define SPI_CS0_PHYS_BASE		0xF0000000
#else
#define SPI_CS0_PHYS_BASE		0xF6000000
#endif
#define SPI_CS0_SIZE			_16M

#define BOOTROM_PHYS_BASE		0xFFF00000
#define BOOTROM_VIRT_BASE		0xFF000000
#define BOOTROM_SIZE			_1M

#define XOR0_PHYS_BASE			(INTER_REGS_PHYS_BASE | 0x60900)
#define XOR1_PHYS_BASE			(INTER_REGS_PHYS_BASE | 0xF0900)
#define XOR0_HIGH_PHYS_BASE		(INTER_REGS_PHYS_BASE | 0x60B00)
#define XOR1_HIGH_PHYS_BASE		(INTER_REGS_PHYS_BASE | 0xF0B00)

#define	LCD_PHYS_BASE			(INTER_REGS_PHYS_BASE | 0xE0000)

#define AXP_NFC_PHYS_BASE	(INTER_REGS_PHYS_BASE | 0xD0000)

#define SDRAM_OPERATION_REG		(INTER_REGS_BASE | 0x1418)
#define SDRAM_CONFIG_REG		(INTER_REGS_BASE | 0x1400)
#define SDRAM_DLB_EVICT_REG		(INTER_REGS_BASE | 0x170C)

#define AXP_UART_PHYS_BASE(port)	(INTER_REGS_PHYS_BASE | 0x12000 + (port * 0x100))
#define DDR_VIRT_BASE			(INTER_REGS_BASE | 0x00000)
#define AXP_BRIDGE_VIRT_BASE		(INTER_REGS_BASE | 0x20000)
#define AXP_BRIDGE_PHYS_BASE		(INTER_REGS_PHYS_BASE | 0x20000)
#define DDR_WINDOW_CPU_BASE		(DDR_VIRT_BASE | 0x1500)
#define AXP_SW_TRIG_IRQ			(AXP_BRIDGE_VIRT_BASE | 0x0A04)
#define AXP_SW_TRIG_IRQ_PHYS		(AXP_BRIDGE_PHYS_BASE | 0x0A04)
#define AXP_SW_TRIG_IRQ_CPU_TARGET_OFFS	8
#define AXP_SW_TRIG_IRQ_INITID_MASK	0x1F
#define AXP_PER_CPU_BASE		(AXP_BRIDGE_VIRT_BASE | 0x1000)
#define AXP_IRQ_VIRT_BASE		(AXP_PER_CPU_BASE)
#define AXP_CPU_INTACK			0xB4
#define AXP_IRQ_SEL_CAUSE_OFF		0xA0
#define AXP_IN_DOORBELL_CAUSE		0x78
#define AXP_IN_DRBEL_CAUSE			(AXP_PER_CPU_BASE | 0x78)
#define AXP_IN_DRBEL_MSK			(AXP_PER_CPU_BASE | 0x7c)

#ifdef CONFIG_MACH_ARMADA_XP_FPGA
#define AXP_CPU_RESUME_ADDR_REG(cpu)	(AXP_BRIDGE_VIRT_BASE | 0x984)
#else
#define AXP_CPU_RESUME_ADDR_REG(cpu)	(AXP_BRIDGE_VIRT_BASE | (0x2124+(cpu)*0x100))
#endif
#define AXP_CPU_RESUME_CTRL_REG		(AXP_BRIDGE_VIRT_BASE | 0x988)
#define AXP_CPU_RESET_REG(cpu)		(AXP_BRIDGE_VIRT_BASE | (0x800+(cpu)*8))
#define AXP_CPU_RESET_OFFS		0

#define AXP_L2_CLEAN_WAY_REG		(INTER_REGS_BASE | 0x87BC) 
#define AXP_L2_MNTNC_STAT_REG		(INTER_REGS_BASE | 0x8704)
#define AXP_SNOOP_FILTER_PHYS_REG	(INTER_REGS_PHYS_BASE | 0x21020)
#define AXP_REVISION_ID_PHYS_REG	(INTER_REGS_PHYS_BASE | 0x40008)
#define AXP_REVISION_ID_VIRT_REG	(INTER_REGS_BASE | 0x40008)
#endif
