/*
 * This file is licensed under the terms of the GNU General Public
 * License version 2.  This program is licensed "as is" without any
 * warranty of any kind, whether express or implied.
 */

#ifndef __ASM_ARCH_IRQS_H
#define __ASM_ARCH_IRQS_H

/*
 * Software Generated Interrupts (SGI)
 */
#define IRQ_SGI_0			0
#define IRQ_SGI_15			15

/*
 * Private Peripheral Interrupts (PPI)
 */
#define IRQ_PRIV_CPU_TIMER0		27
#define IRQ_PRIV_MPIC_PPI_FIQ		28
#define IRQ_PRIV_CPU_LOCAL_TIMER	29
#define IRQ_PRIV_CPU_LOCAL_WD		30
#define IRQ_PRIV_MPIC_PPI_IRQ		31

/*
 * Shared Peripheral Interrupts (SPI)
 */
#define IRQ_GLOBAL_SPI0			33
#define IRQ_GLOBAL_I2C0			34
#define IRQ_GLOBAL_I2C1			35

#define IRQ_GLOBAL_TIMER0		40
#define IRQ_GLOBAL_TIMER1		41
#define IRQ_GLOBAL_TIMER2		42
#define IRQ_GLOBAL_TIMER3		43
#define IRQ_GLOBAL_TIMER(timer)		((timer >= 0 && timer <= 3) ? \
					IRQ_GLOBAL_TIMER0 + timer : \
					IRQ_GLOBAL_TIMER0)

#define IRQ_GLOBAL_UART0		44
#define IRQ_GLOBAL_UART1		45

#define IRQ_GLOBAL_USB3_IP(dev)		(48 + dev)
#define IRQ_GLOBAL_USB2_IP		50

#define IRQ_GLOBAL_CESA0		51
#define IRQ_GLOBAL_CESA1		52
#define CESA_IRQ(chan)			((chan == 0) ? \
					IRQ_GLOBAL_CESA0 : \
					IRQ_GLOBAL_CESA1)

#define IRQ_GLOBAL_RTC			53

#define IRQ_GLOBAL_XOR0_CHAN0		54
#define IRQ_GLOBAL_XOR0_CHAN1		55

#define IRQ_GLOBAL_SDIO			57

#define IRQ_GLOBAL_SATA_UNIT0		58
#define IRQ_GLOBAL_SATA_UNIT1		60

#define IRQ_GLOBAL_TDM			59

#define IRQ_GLOBAL_PCIE0		61
#define IRQ_GLOBAL_PCIE1		65
#define IRQ_GLOBAL_PCIE2		102
#define IRQ_GLOBAL_PCIE3		103

#define IRQ_GLOBAL_GUNIT0_SUM		69
#define IRQ_GLOBAL_GUNIT0_RX		70
#define IRQ_GLOBAL_GUNIT0_TX		71
#define IRQ_GLOBAL_GUNIT0_MISC		72
#define IRQ_GLOBAL_GUNIT1_SUM		73
#define IRQ_GLOBAL_GUNIT1_RX		74
#define IRQ_GLOBAL_GUNIT1_TX		75
#define IRQ_GLOBAL_GUNIT1_MISC		76
#define IRQ_GLOBAL_GUNIT2_SUM		77
#define IRQ_GLOBAL_GUNIT2_RX		78
#define IRQ_GLOBAL_GUNIT2_TX		79
#define IRQ_GLOBAL_GUNIT2_MISC		80

#define IRQ_GLOBAL_GOP			82 /* Group of Ports (GOP) */
#define IRQ_GLOBAL_PON			83

#define IRQ_GLOBAL_ETH_COMPLEX		84

#define IRQ_GLOBAL_GPIO_0_7		85
#define IRQ_GLOBAL_GPIO_8_15		86
#define IRQ_GLOBAL_GPIO_16_23		87
#define IRQ_GLOBAL_GPIO_24_31		88

#define IRQ_GLOBAL_DYING_GASP		89

#define IRQ_GLOBAL_GPIO_32_39		90
#define IRQ_GLOBAL_GPIO_40_47		91
#define IRQ_GLOBAL_GPIO_48_55		92
#define IRQ_GLOBAL_GPIO_56_63		93
#define IRQ_GLOBAL_GPIO_64_66		94

#define IRQ_GLOBAL_SPI1			95

#define IRQ_GLOBAL_WD			96

#define IRQ_GLOBAL_XOR1_CHAN0		97
#define IRQ_GLOBAL_XOR1_CHAN1		98

#define IRQ_GLOBAL_INB_DOOR_BELL_SUMMARY0	99
#define IRQ_GLOBAL_INB_DOOR_BELL_SUMMARY1	100
#define IRQ_GLOBAL_INB_DOOR_BELL_SUMMARY2	101

#define IRQ_GLOBAL_AUDIO		107
#define IRQ_GLOBAL_CODEC_SUMMARY	109

#define IRQ_GLOBAL_THERMAL		110

#define IRQ_GLOBAL_DRAM			111

#define IRQ_GLOBAL_NET_WAKE_UP		112

#define IRQ_GLOBAL_NAND			116
/* Redefinition for the NFC driver */
#define IRQ_AURORA_NFC			IRQ_GLOBAL_NAND

#define IRQ_GLOBAL_SOC_MISC_SUMMARY	117

#define IRQ_GLOBAL_DRAGONITE		118

/*
 * Global GPIO interrupts
 */
#define IRQ_START_GLOBAL_GPIO		192
#define NR_IRQS_GLOBAL_GPIO		67
#define IRQ_GLOBAL_GPIO(gpio_irq)	(gpio_irq >= NR_IRQS_GLOBAL_GPIO ? \
			NR_IRQS_GLOBAL_GPIO : IRQ_START_GLOBAL_GPIO + gpio_irq)

/*
 * Global PCIe MSI interrupts
 */
#define IRQ_START_GLOBAL_MSI		(IRQ_START_GLOBAL_GPIO + NR_IRQS_GLOBAL_GPIO)
#define NR_IRQS_GLOBAL_MSI		96
#define IRQ_GLOBAL_MSI(msi_irq)		(msi_irq >= NR_IRQS_GLOBAL_MSI ? \
			NR_IRQS_GLOBAL_MSI : NR_IRQS_GLOBAL_MSI + msi_irq)

/*
 * SoC private interrupts
 */
#define IRQ_START_PRIV_SOC_PPI		(IRQ_START_GLOBAL_MSI + NR_IRQS_GLOBAL_MSI)
#define NR_IRQS_PRIV_SOC_PPI		24

#define IRQ_PRIV_INB_DOOR_BELL_SUMMARY0		(IRQ_START_PRIV_SOC_PPI + 0)
#define IRQ_PRIV_INB_DOOR_BELL_SUMMARY1		(IRQ_START_PRIV_SOC_PPI + 1)
#define IRQ_PRIV_OUT_DOOR_BELL_SUMMARY		(IRQ_START_PRIV_SOC_PPI + 2)
#define IRQ_PRIV_MP_LOCAL_SUMMARY		(IRQ_START_PRIV_SOC_PPI + 3)
#define IRQ_PRIV_SOC_ERROR_SUMMARY		(IRQ_START_PRIV_SOC_PPI + 4)
#define IRQ_PRIV_SOC_PRIV_TIMER0		(IRQ_START_PRIV_SOC_PPI + 5)
#define IRQ_PRIV_SOC_PRIV_TIMER1		(IRQ_START_PRIV_SOC_PPI + 6)
#define IRQ_PRIV_PORT0_TH_RXTX			(IRQ_START_PRIV_SOC_PPI + 8)
#define IRQ_PRIV_PORT0_RXTX			(IRQ_START_PRIV_SOC_PPI + 9)
#define IRQ_PRIV_PORT1_TH_RXTX			(IRQ_START_PRIV_SOC_PPI + 10)
#define IRQ_PRIV_PORT1_RXTX			(IRQ_START_PRIV_SOC_PPI + 11)
#define IRQ_PRIV_PORT2_TH_RXTX			(IRQ_START_PRIV_SOC_PPI + 12)
#define IRQ_PRIV_PORT2_RXTX			(IRQ_START_PRIV_SOC_PPI + 13)
#define IRQ_PRIV_GPIO_0_7			(IRQ_START_PRIV_SOC_PPI + 16)
#define IRQ_PRIV_GPIO_8_15			(IRQ_START_PRIV_SOC_PPI + 17)
#define IRQ_PRIV_GPIO_16_23			(IRQ_START_PRIV_SOC_PPI + 18)
#define IRQ_PRIV_GPIO_24_31			(IRQ_START_PRIV_SOC_PPI + 19)
#define IRQ_PRIV_GPIO_32_39			(IRQ_START_PRIV_SOC_PPI + 20)
#define IRQ_PRIV_GPIO_40_47			(IRQ_START_PRIV_SOC_PPI + 21)
#define IRQ_PRIV_GPIO_48_55			(IRQ_START_PRIV_SOC_PPI + 22)
#define IRQ_PRIV_GPIO_56_63			(IRQ_START_PRIV_SOC_PPI + 23)

/*
 * Private GPIO interrupts
 */
#define IRQ_START_PRIV_GPIO	(IRQ_START_PRIV_SOC_PPI + NR_IRQS_PRIV_SOC_PPI)
#define NR_IRQS_PRIV_GPIO	67
#define IRQ_PRIV_GPIO(gpio_irq)		(gpio_irq >= NR_IRQS_PRIV_GPIO ? \
			NR_IRQS_PRIV_GPIO : IRQ_START_PRIV_GPIO + gpio_irq)

/*
 * Private PCIe MSI interrupts
 */
#define IRQ_START_PRIV_MSI		(IRQ_START_PRIV_GPIO + NR_IRQS_PRIV_GPIO)
#define NR_IRQS_PRIV_MSI		32
#define IRQ_PRIV_MSI(msi_irq)		(msi_irq >= NR_IRQS_PRIV_MSI ? \
			NR_IRQS_PRIV_MSI : IRQ_START_PRIV_MSI + msi_irq)

/*
 * Private SoC error interrupts
 */
#define IRQ_START_PRIV_ERROR		(IRQ_START_PRIV_MSI + NR_IRQS_PRIV_MSI)
#define NR_IRQS_PRIV_ERROR		50

#define IRQ_PRIV_ERROR_CESA0		(IRQ_START_PRIV_ERROR + 0)
#define IRQ_PRIV_ERROR_DEV_BUS		(IRQ_START_PRIV_ERROR + 1)
#define IRQ_PRIV_ERROR_XOR1		(IRQ_START_PRIV_ERROR + 3)
#define IRQ_PRIV_ERROR_PCIE0		(IRQ_START_PRIV_ERROR + 4)
#define IRQ_PRIV_ERROR_PCIE1		(IRQ_START_PRIV_ERROR + 5)
#define IRQ_PRIV_ERROR_CESA1		(IRQ_START_PRIV_ERROR + 7)
#define IRQ_PRIV_ERROR_USB		(IRQ_START_PRIV_ERROR + 8)
#define IRQ_PRIV_ERROR_DRAM		(IRQ_START_PRIV_ERROR + 9)
#define IRQ_PRIV_ERROR_XOR0		(IRQ_START_PRIV_ERROR + 10)
#define IRQ_PRIV_ERROR_BM		(IRQ_START_PRIV_ERROR + 12)
#define IRQ_PRIV_ERROR_PCIE2		(IRQ_START_PRIV_ERROR + 15)
#define IRQ_PRIV_ERROR_PCIE3		(IRQ_START_PRIV_ERROR + 16)
#define IRQ_PRIV_ERROR_SATA0		(IRQ_START_PRIV_ERROR + 17)
#define IRQ_PRIV_ERROR_SATA2		(IRQ_START_PRIV_ERROR + 18)
#define IRQ_PRIV_ERROR_SDIO		(IRQ_START_PRIV_ERROR + 19)
#define IRQ_PRIV_ERROR_AUDIO		(IRQ_START_PRIV_ERROR + 20)
#define IRQ_PRIV_ERROR_NAND		(IRQ_START_PRIV_ERROR + 21)
#define IRQ_PRIV_ERROR_L2_DECODE	(IRQ_START_PRIV_ERROR + 23)
#define IRQ_PRIV_ERROR_L2_EVENT_CNT	(IRQ_START_PRIV_ERROR + 24)
#define IRQ_PRIV_ERROR_L2_RAM_RD_DATA	(IRQ_START_PRIV_ERROR + 25)
#define IRQ_PRIV_ERROR_L2_RAM_RD_TAG	(IRQ_START_PRIV_ERROR + 26)
#define IRQ_PRIV_ERROR_L2_RAM_WR_DATA	(IRQ_START_PRIV_ERROR + 27)
#define IRQ_PRIV_ERROR_L2_RAM_WR_TAG	(IRQ_START_PRIV_ERROR + 28)
#define IRQ_PRIV_ERROR_L2_COMBINED	(IRQ_START_PRIV_ERROR + 29)
#define IRQ_PRIV_ERROR_L2_PARITY_RAM_RD_DATA	(IRQ_START_PRIV_ERROR + 30)
#define IRQ_PRIV_ERROR_L2_PARITY_RAM_RD_TAG	(IRQ_START_PRIV_ERROR + 31)
#define IRQ_PRIV_ERROR_L2_SLAVE_ERR	(IRQ_START_PRIV_ERROR + 32)
#define IRQ_PRIV_ERROR_PARITY_FAIL0(parity0_irq) \
			(parity0_irq >= 8 ? \
			IRQ_START_PRIV_ERROR + 33 : \
			IRQ_START_PRIV_ERROR + 33 + parity0_irq)
#define IRQ_PRIV_ERROR_PARITY_FAIL1(parity1_irq) \
			(parity1_irq >= 8 ? \
			IRQ_START_PRIV_ERROR + 41 : \
			IRQ_START_PRIV_ERROR + 41 + parity1_irq)
#define IRQ_PRIV_ERROR_POLARITY_SCU0	(IRQ_START_PRIV_ERROR + 49)
#define IRQ_PRIV_ERROR_POLARITY_SCU1	(IRQ_START_PRIV_ERROR + 50)
#define IRQ_PRIV_ERROR_SATA1		(IRQ_START_PRIV_ERROR + 51)
#define IRQ_PRIV_ERROR_SATA3		(IRQ_START_PRIV_ERROR + 52)
#define IRQ_PRIV_ERROR_SATA01_MBUS	(IRQ_START_PRIV_ERROR + 53)
#define IRQ_PRIV_ERROR_SATA23_MBUS	(IRQ_START_PRIV_ERROR + 54)

/*
 * Total number of interrupts
 */
#define NR_IRQS			(IRQ_START_PRIV_ERROR + NR_IRQS_PRIV_ERROR)
#define NR_GPIO_IRQS		NR_IRQS_GLOBAL_GPIO

/*
 * IRQ HAL remapping
 */
#define NET_TH_RXTX_IRQ_NUM(x)		(IRQ_PRIV_PORT0_TH_RXTX + ((x) * 2))

#endif /* __ASM_ARCH_IRQS_H */
