 
#ifndef __AL_SERDES_INTERNAL_REGS_H__
#define  __AL_SERDES_INTERNAL_REGS_H__

#ifdef __cplusplus
extern "C" {
#endif

#define SERDES_IREG_FLD_CMNCTLPOR_HARDRSTBYPASS_REG_NUM			2
#define SERDES_IREG_FLD_CMNCTLPOR_HARDRSTBYPASS_MASK			0x01
#define SERDES_IREG_FLD_CMNCTLPOR_HARDRSTBYPASS_VAL_ASSERT		0x00
#define SERDES_IREG_FLD_CMNCTLPOR_HARDRSTBYPASS_VAL_DEASSERT		0x01

#define SERDES_IREG_FLD_CMNCTLPOR_HARDRSTBYPASSEN_REG_NUM		2
#define SERDES_IREG_FLD_CMNCTLPOR_HARDRSTBYPASSEN_MASK			0x02
#define SERDES_IREG_FLD_CMNCTLPOR_HARDRSTBYPASSEN_VAL_IFACE		0x00
#define SERDES_IREG_FLD_CMNCTLPOR_HARDRSTBYPASSEN_VAL_REGS		0x02

#define SERDES_IREG_FLD_LANEPCSPSTATE_RX_REG_NUM			3
#define SERDES_IREG_FLD_LANEPCSPSTATE_RX_MASK				0x1f
#define SERDES_IREG_FLD_LANEPCSPSTATE_RX_VAL_PD				0x01
#define SERDES_IREG_FLD_LANEPCSPSTATE_RX_VAL_P2				0x02
#define SERDES_IREG_FLD_LANEPCSPSTATE_RX_VAL_P1				0x04
#define SERDES_IREG_FLD_LANEPCSPSTATE_RX_VAL_P0S			0x08
#define SERDES_IREG_FLD_LANEPCSPSTATE_RX_VAL_P0				0x10

#define SERDES_IREG_FLD_LANEPCSPSTATE_TX_REG_NUM			4
#define SERDES_IREG_FLD_LANEPCSPSTATE_TX_MASK				0x1f
#define SERDES_IREG_FLD_LANEPCSPSTATE_TX_VAL_PD				0x01
#define SERDES_IREG_FLD_LANEPCSPSTATE_TX_VAL_P2				0x02
#define SERDES_IREG_FLD_LANEPCSPSTATE_TX_VAL_P1				0x04
#define SERDES_IREG_FLD_LANEPCSPSTATE_TX_VAL_P0S			0x08
#define SERDES_IREG_FLD_LANEPCSPSTATE_TX_VAL_P0				0x10

#define SERDES_IREG_FLD_PCSRX_DATAWIDTH_REG_NUM				5
#define SERDES_IREG_FLD_PCSRX_DATAWIDTH_MASK				0x07
#define SERDES_IREG_FLD_PCSRX_DATAWIDTH_VAL_8				0x00
#define SERDES_IREG_FLD_PCSRX_DATAWIDTH_VAL_10				0x01
#define SERDES_IREG_FLD_PCSRX_DATAWIDTH_VAL_16				0x02
#define SERDES_IREG_FLD_PCSRX_DATAWIDTH_VAL_20				0x03
#define SERDES_IREG_FLD_PCSRX_DATAWIDTH_VAL_32				0x04
#define SERDES_IREG_FLD_PCSRX_DATAWIDTH_VAL_40				0x05

#define SERDES_IREG_FLD_PCSTX_DATAWIDTH_REG_NUM				5
#define SERDES_IREG_FLD_PCSTX_DATAWIDTH_MASK				0x70
#define SERDES_IREG_FLD_PCSTX_DATAWIDTH_VAL_8				0x00
#define SERDES_IREG_FLD_PCSTX_DATAWIDTH_VAL_10				0x10
#define SERDES_IREG_FLD_PCSTX_DATAWIDTH_VAL_16				0x20
#define SERDES_IREG_FLD_PCSTX_DATAWIDTH_VAL_20				0x30
#define SERDES_IREG_FLD_PCSTX_DATAWIDTH_VAL_32				0x40
#define SERDES_IREG_FLD_PCSTX_DATAWIDTH_VAL_40				0x50

#define SERDES_IREG_FLD_PCSRX_DIVRATE_REG_NUM				6
#define SERDES_IREG_FLD_PCSRX_DIVRATE_MASK				0x07
#define SERDES_IREG_FLD_PCSRX_DIVRATE_VAL_1_8				0x00
#define SERDES_IREG_FLD_PCSRX_DIVRATE_VAL_1_4				0x01
#define SERDES_IREG_FLD_PCSRX_DIVRATE_VAL_1_2				0x02
#define SERDES_IREG_FLD_PCSRX_DIVRATE_VAL_1_1				0x03

#define SERDES_IREG_FLD_PCSTX_DIVRATE_REG_NUM				6
#define SERDES_IREG_FLD_PCSTX_DIVRATE_MASK				0x70
#define SERDES_IREG_FLD_PCSTX_DIVRATE_VAL_1_8				0x00
#define SERDES_IREG_FLD_PCSTX_DIVRATE_VAL_1_4				0x10
#define SERDES_IREG_FLD_PCSTX_DIVRATE_VAL_1_2				0x20
#define SERDES_IREG_FLD_PCSTX_DIVRATE_VAL_1_1				0x30

#define SERDES_IREG_FLD_LB_RX2TXUNTIMEDEN_REG_NUM			7
#define SERDES_IREG_FLD_LB_RX2TXUNTIMEDEN				0x10

#define SERDES_IREG_FLD_LB_TX2RXBUFTIMEDEN_REG_NUM			7
#define SERDES_IREG_FLD_LB_TX2RXBUFTIMEDEN				0x20

#define SERDES_IREG_FLD_LB_TX2RXIOTIMEDEN_REG_NUM			7
#define SERDES_IREG_FLD_LB_TX2RXIOTIMEDEN				0x40

#define SERDES_IREG_FLD_LB_PARRX2TXTIMEDEN_REG_NUM			7
#define SERDES_IREG_FLD_LB_PARRX2TXTIMEDEN				0x80

#define SERDES_IREG_FLD_LB_CDRCLK2TXEN_REG_NUM				7
#define SERDES_IREG_FLD_LB_CDRCLK2TXEN					0x01

#define SERDES_IREG_FLD_PCSRXBIST_EN_REG_NUM				8
#define SERDES_IREG_FLD_PCSRXBIST_EN					0x01

#define SERDES_IREG_FLD_PCSTXBIST_EN_REG_NUM				8
#define SERDES_IREG_FLD_PCSTXBIST_EN					0x02

#define SERDES_IREG_FLD_RXBIST_DONE_REG_NUM				8
#define SERDES_IREG_FLD_RXBIST_DONE					0x04

#define SERDES_IREG_FLD_RXBIST_ERRCOUNT_OVERFLOW_REG_NUM		8
#define SERDES_IREG_FLD_RXBIST_ERRCOUNT_OVERFLOW			0x08

#define SERDES_IREG_FLD_RXBIST_RXLOCKED_REG_NUM				8
#define SERDES_IREG_FLD_RXBIST_RXLOCKED					0x10

#define SERDES_IREG_FLD_RXBIST_ERRCOUNT_MSB_REG_NUM			9
#define SERDES_IREG_FLD_RXBIST_ERRCOUNT_LSB_REG_NUM			10

#define SERDES_IREG_TX_DRV_1_REG_NUM					21
#define SERDES_IREG_TX_DRV_1_HLEV_MASK					0x7
#define SERDES_IREG_TX_DRV_1_HLEV_SHIFT					0
#define SERDES_IREG_TX_DRV_1_LEVN_MASK					0xf8
#define SERDES_IREG_TX_DRV_1_LEVN_SHIFT					3

#define SERDES_IREG_TX_DRV_2_REG_NUM					22
#define SERDES_IREG_TX_DRV_2_LEVNM1_MASK				0xf
#define SERDES_IREG_TX_DRV_2_LEVNM1_SHIFT				0
#define SERDES_IREG_TX_DRV_2_LEVNM2_MASK				0x30
#define SERDES_IREG_TX_DRV_2_LEVNM2_SHIFT				4

#define SERDES_IREG_TX_DRV_3_REG_NUM					23
#define SERDES_IREG_TX_DRV_3_LEVNP1_MASK				0x7
#define SERDES_IREG_TX_DRV_3_LEVNP1_SHIFT				0
#define SERDES_IREG_TX_DRV_3_SLEW_MASK					0x18
#define SERDES_IREG_TX_DRV_3_SLEW_SHIFT					3

#define SERDES_IREG_RX_CALEQ_1_REG_NUM					24
#define SERDES_IREG_RX_CALEQ_1_DCGAIN_MASK				0x7
#define SERDES_IREG_RX_CALEQ_1_DCGAIN_SHIFT				0
 
#define SERDES_IREG_RX_CALEQ_1_DFEPSTAP3DB_MASK				0x38
#define SERDES_IREG_RX_CALEQ_1_DFEPSTAP3DB_SHIFT			3

#define SERDES_IREG_RX_CALEQ_2_REG_NUM					25
 
#define SERDES_IREG_RX_CALEQ_2_DFEPSTAPGAIN_MASK			0x7
#define SERDES_IREG_RX_CALEQ_2_DFEPSTAPGAIN_SHIFT			0
 
#define SERDES_IREG_RX_CALEQ_2_DFETAP1GAIN_MASK				0x78
#define SERDES_IREG_RX_CALEQ_2_DFETAP1GAIN_SHIFT			3

#define SERDES_IREG_RX_CALEQ_3_REG_NUM					26
#define SERDES_IREG_RX_CALEQ_3_DFETAP2GAIN_MASK				0xf
#define SERDES_IREG_RX_CALEQ_3_DFETAP2GAIN_SHIFT			0
#define SERDES_IREG_RX_CALEQ_3_DFETAP3GAIN_MASK				0xf0
#define SERDES_IREG_RX_CALEQ_3_DFETAP3GAIN_SHIFT			4

#define SERDES_IREG_RX_CALEQ_4_REG_NUM					27
#define SERDES_IREG_RX_CALEQ_4_DFETAP4GAIN_MASK				0xf
#define SERDES_IREG_RX_CALEQ_4_DFETAP4GAIN_SHIFT			0
#define SERDES_IREG_RX_CALEQ_4_LOFREQAGCGAIN_MASK			0x70
#define SERDES_IREG_RX_CALEQ_4_LOFREQAGCGAIN_SHIFT			4

#define SERDES_IREG_RX_CALEQ_5_REG_NUM					28
#define SERDES_IREG_RX_CALEQ_5_PRECAL_CODE_SEL_MASK			0x7
#define SERDES_IREG_RX_CALEQ_5_PRECAL_CODE_SEL_SHIFT			0
#define SERDES_IREG_RX_CALEQ_5_HIFREQAGCCAP_MASK			0xf8
#define SERDES_IREG_RX_CALEQ_5_HIFREQAGCCAP_SHIFT			3

#ifdef CONFIG_SYNO_ALPINE_A0
 
#define SERDES_IREG_RXEQ_BEST_EYE_MSB_VAL_REG_NUM			29
#define SERDES_IREG_RXEQ_BEST_EYE_LSB_VAL_REG_NUM			30
#define SERDES_IREG_RXEQ_BEST_EYE_LSB_VAL_MASK				0x3F

#define SERDES_IREG_FLD_PCSRXEQ_START_REG_NUM				31
#define SERDES_IREG_FLD_PCSRXEQ_START					(1 << 0)

#define SERDES_IREG_FLD_RXCALEYEDIAGFSMIN_START_REG_NUM			31
#define SERDES_IREG_FLD_RXCALEYEDIAGFSMIN_START				(1 << 1)
#endif

#define SERDES_IREG_FLD_RXCALROAMEYEMEASIN_CYCLEEN_REG_NUM		31
#define SERDES_IREG_FLD_RXCALROAMEYEMEASIN_CYCLEEN_START		(1 << 2)

#ifdef CONFIG_SYNO_ALPINE_A0
 
#define SERDES_IREG_FLD_RXCALEYEDIAGFSM_DONE_REG_NUM			32
#define SERDES_IREG_FLD_RXCALEYEDIAGFSM_DONE				(1 << 0)

#define SERDES_IREG_FLD_RXCALEYEDIAGFSM_ERR_REG_NUM			32
#define SERDES_IREG_FLD_RXCALEYEDIAGFSM_ERR				(1 << 1)
#endif

#define SERDES_IREG_FLD_RXCALROAMEYEMEASDONE_REG_NUM			32
#define SERDES_IREG_FLD_RXCALROAMEYEMEASDONE				(1 << 2)

#ifdef CONFIG_SYNO_ALPINE_A0
 
#define SERDES_IREG_FLD_RXEQ_DONE_REG_NUM				32
#define SERDES_IREG_FLD_RXEQ_DONE					(1 << 3)
#endif

#define SERDES_IREG_FLD_RXCALROAMXADJUST_REG_NUM			33

#define SERDES_IREG_FLD_RXCALROAMYADJUST_REG_NUM			34

#ifdef CONFIG_SYNO_ALPINE_A0
 
#define	SERDES_IREG_FLD_RXCALEYEDIAGFSM_EYESUM_MSB_REG_NUM		35
#define	SERDES_IREG_FLD_RXCALEYEDIAGFSM_EYESUM_MSB_MAKE			0xFF
#define	SERDES_IREG_FLD_RXCALEYEDIAGFSM_EYESUM_MSB_SHIFT		0

#define	SERDES_IREG_FLD_RXCALEYEDIAGFSM_EYESUM_LSB_REG_NUM		36
#define	SERDES_IREG_FLD_RXCALEYEDIAGFSM_EYESUM_LSB_MAKE			0x3F
#define	SERDES_IREG_FLD_RXCALEYEDIAGFSM_EYESUM_LSB_SHIFT		0
#endif

#define SERDES_IREG_FLD_RXCALROAMEYEMEAS_ACC_MSB_REG_NUM		37
#define SERDES_IREG_FLD_RXCALROAMEYEMEAS_ACC_LSB_REG_NUM		38

#define SERDES_IREG_FLD_RXLOCK2REF_OVREN_REG_NUM			39
#define SERDES_IREG_FLD_RXLOCK2REF_OVREN				(1 << 1)

#define SERDES_IREG_FLD_RXROAM_XORBITSEL_REG_NUM			39
#ifdef CONFIG_SYNO_ALPINE_A0
#define SERDES_IREG_FLD_RXROAM_XORBITSEL				(1 << 2)
#endif
#define SERDES_IREG_FLD_RXROAM_XORBITSEL_MASK				(1 << 2)
#define SERDES_IREG_FLD_RXROAM_XORBITSEL_1ST				0
#define SERDES_IREG_FLD_RXROAM_XORBITSEL_2ND				(1 << 2)

#define SERDES_IREG_FLD_RXRANDET_REG_NUM				41
#define SERDES_IREG_FLD_RXRANDET_STAT					0x20

#define SERDES_IREG_FLD_POLARITY_RX_REG_NUM				46
#define SERDES_IREG_FLD_POLARITY_RX_INV					(1 << 0)

#define SERDES_IREG_FLD_POLARITY_TX_REG_NUM				46
#define SERDES_IREG_FLD_POLARITY_TX_INV					(1 << 1)

#define SERDES_IREG_FLD_LANEPCSPSTATE_LOCWREN_REG_NUM			85
#define SERDES_IREG_FLD_LANEPCSPSTATE_LOCWREN				(1 << 0)

#define SERDES_IREG_FLD_LB_LOCWREN_REG_NUM				85
#define SERDES_IREG_FLD_LB_LOCWREN					(1 << 1)

#define SERDES_IREG_FLD_PCSRX_LOCWREN_REG_NUM				85
#define SERDES_IREG_FLD_PCSRX_LOCWREN					(1 << 4)

#define SERDES_IREG_FLD_PCSRXBIST_LOCWREN_REG_NUM			85
#define SERDES_IREG_FLD_PCSRXBIST_LOCWREN				(1 << 5)

#define SERDES_IREG_FLD_PCSRXEQ_LOCWREN_REG_NUM				85
#define SERDES_IREG_FLD_PCSRXEQ_LOCWREN					(1 << 6)

#define SERDES_IREG_FLD_PCSTX_LOCWREN_REG_NUM				85
#define SERDES_IREG_FLD_PCSTX_LOCWREN					(1 << 7)

#ifdef CONFIG_SYNO_ALPINE_A0
 
#define SERDES_IREG_FLD_RXCAL_LOCWREN_REG_NUM				86
#endif

#define SERDES_IREG_FLD_PCSTXBIST_LOCWREN_REG_NUM			86
#define SERDES_IREG_FLD_PCSTXBIST_LOCWREN				(1 << 0)

#define SERDES_IREG_FLD_RX_DRV_OVERRIDE_EN_REG_NUM			86
#define SERDES_IREG_FLD_RX_DRV_OVERRIDE_EN				(1 << 3)

#ifdef CONFIG_SYNO_ALPINE_A0
#define SERDES_IREG_FLD_RXCALEYEDIAGFSMIN_LOCWREN_REG_NUM		86
#define SERDES_IREG_FLD_RXCALEYEDIAGFSMIN_LOCWREN			(1 << 4)
#endif

#define SERDES_IREG_FLD_RXCALROAMEYEMEASIN_LOCWREN_REG_NUM		86
#define SERDES_IREG_FLD_RXCALROAMEYEMEASIN_LOCWREN			(1 << 6)

#define SERDES_IREG_FLD_RXCALROAMXADJUST_LOCWREN_REG_NUM		86
#define SERDES_IREG_FLD_RXCALROAMXADJUST_LOCWREN			(1 << 7)

#define SERDES_IREG_FLD_RXCALROAMYADJUST_LOCWREN_REG_NUM		87
#define SERDES_IREG_FLD_RXCALROAMYADJUST_LOCWREN			(1 << 0)

#ifdef CONFIG_SYNO_ALPINE_A0
 
#define SERDES_IREG_FLD_RXCDRCALFOSC_LOCWREN_REG_NUM			87
#define SERDES_IREG_FLD_RXCDRCALFOSC_LOCWREN				(1 << 1)

#define SERDES_IREG_FLD_RXEYEDIAGFSM_LOCWREN_REG_NUM			87
#define SERDES_IREG_FLD_RXEYEDIAGFSM_LOCWREN				(1 << 2)

#define SERDES_IREG_FLD_RXTERMHIZ_LOCWREN_REG_NUM			87
#define SERDES_IREG_FLD_RXTERMHIZ_LOCWREN				(1 << 3)

#define SERDES_IREG_FLD_TXCALTCLKDUTY_LOCWREN_REG_NUM			87
#define SERDES_IREG_FLD_TXCALTCLKDUTY_LOCWREN				(1 << 4)
#endif

#define SERDES_IREG_FLD_TX_DRV_OVERRIDE_EN_REG_NUM			87
#define SERDES_IREG_FLD_TX_DRV_OVERRIDE_EN				(1 << 5)

#define SERDES_IREG_FLD_CMNCTLPOR_HARDRSTBYPASSEN_SYNTH_REG_NUM		2
#define SERDES_IREG_FLD_CMNCTLPOR_HARDRSTBYPASSEN_SYNTH_MASK		0x01
#define SERDES_IREG_FLD_CMNCTLPOR_HARDRSTBYPASSEN_SYNTH_VAL_IFACE	0x00
#define SERDES_IREG_FLD_CMNCTLPOR_HARDRSTBYPASSEN_SYNTH_VAL_REGS	0x01

#define SERDES_IREG_FLD_CMNCTLPOR_HARDRSTBYPASS_SYNTH_REG_NUM		2
#define SERDES_IREG_FLD_CMNCTLPOR_HARDRSTBYPASS_SYNTH_MASK		0x02
#define SERDES_IREG_FLD_CMNCTLPOR_HARDRSTBYPASS_SYNTH_VAL_ASSERT	0x00
#define SERDES_IREG_FLD_CMNCTLPOR_HARDRSTBYPASS_SYNTH_VAL_DEASSERT	0x02

#define SERDES_IREG_FLD_CMNPCSPSTATE_SYNTH_REG_NUM			3
#define SERDES_IREG_FLD_CMNPCSPSTATE_SYNTH_MASK				0x1f
#define SERDES_IREG_FLD_CMNPCSPSTATE_SYNTH_VAL_PD			0x01
#define SERDES_IREG_FLD_CMNPCSPSTATE_SYNTH_VAL_P2			0x02
#define SERDES_IREG_FLD_CMNPCSPSTATE_SYNTH_VAL_P1			0x04
#define SERDES_IREG_FLD_CMNPCSPSTATE_SYNTH_VAL_P0S			0x08
#define SERDES_IREG_FLD_CMNPCSPSTATE_SYNTH_VAL_P0			0x10

#define SERDES_IREG_FLD_CMNPCS_TXENABLE_REG_NUM				8
#define SERDES_IREG_FLD_CMNPCS_TXENABLE					(1 << 2)

#ifdef CONFIG_SYNO_ALPINE_A0
#define SERDES_IREG_FLD_RXEQ_COARSE_ITER_NUM_REG_NUM			30
#define SERDES_IREG_FLD_RXEQ_COARSE_ITER_NUM_MASK			0x7f
#define SERDES_IREG_FLD_RXEQ_COARSE_ITER_NUM_SHIFT			0

#define SERDES_IREG_FLD_RXEQ_FINE_ITER_NUM_REG_NUM			31
#define SERDES_IREG_FLD_RXEQ_FINE_ITER_NUM_MASK				0x7f
#define SERDES_IREG_FLD_RXEQ_FINE_ITER_NUM_SHIFT			0

#define SERDES_IREG_FLD_RXEQ_COARSE_RUN1_MASK_REG_NUM			32
#define SERDES_IREG_FLD_RXEQ_COARSE_RUN1_MASK_MASK			0xff
#define SERDES_IREG_FLD_RXEQ_COARSE_RUN1_MASK_SHIFT			0

#define SERDES_IREG_FLD_RXEQ_COARSE_RUN2_MASK_REG_NUM			33
#define SERDES_IREG_FLD_RXEQ_COARSE_RUN2_MASK_MASK			0x1
#define SERDES_IREG_FLD_RXEQ_COARSE_RUN2_MASK_SHIFT			0

#define SERDES_IREG_FLD_RXEQ_COARSE_STEP_REG_NUM			33
#define SERDES_IREG_FLD_RXEQ_COARSE_STEP_MASK				0x3e
#define SERDES_IREG_FLD_RXEQ_COARSE_STEP_SHIFT				1

#define SERDES_IREG_FLD_RXEQ_FINE_RUN1_MASK_REG_NUM			34
#define SERDES_IREG_FLD_RXEQ_FINE_RUN1_MASK_MASK			0xff
#define SERDES_IREG_FLD_RXEQ_FINE_RUN1_MASK_SHIFT			0

#define SERDES_IREG_FLD_RXEQ_FINE_RUN2_MASK_REG_NUM			35
#define SERDES_IREG_FLD_RXEQ_FINE_RUN2_MASK_MASK			0x1
#define SERDES_IREG_FLD_RXEQ_FINE_RUN2_MASK_SHIFT			0

#define SERDES_IREG_FLD_RXEQ_FINE_STEP_REG_NUM				35
#define SERDES_IREG_FLD_RXEQ_FINE_STEP_MASK				0x3e
#define SERDES_IREG_FLD_RXEQ_FINE_STEP_SHIFT				1

#define SERDES_IREG_FLD_RXEQ_LOOKUP_CODE_EN_REG_NUM			36
#define SERDES_IREG_FLD_RXEQ_LOOKUP_CODE_EN_MASK			0xff
#define SERDES_IREG_FLD_RXEQ_LOOKUP_CODE_EN_SHIFT			0

#define SERDES_IREG_FLD_RXEQ_LOOKUP_LASTCODE_REG_NUM			37
#define SERDES_IREG_FLD_RXEQ_LOOKUP_LASTCODE_MASK			0x7
#define SERDES_IREG_FLD_RXEQ_LOOKUP_LASTCODE_SHIFT			0

#define SERDES_IREG_FLD_RXEQ_DCGAIN_LUP0_REG_NUM			43
#define SERDES_IREG_FLD_RXEQ_DCGAIN_LUP0_MASK				0x7
#define SERDES_IREG_FLD_RXEQ_DCGAIN_LUP0_SHIFT				0
#endif

#define SERDES_IREG_FLD_CMNPCSBIST_MODESEL_REG_NUM			80
#define SERDES_IREG_FLD_CMNPCSBIST_MODESEL_MASK				0x07
#define SERDES_IREG_FLD_CMNPCSBIST_MODESEL_VAL_USER			0x00
#define SERDES_IREG_FLD_CMNPCSBIST_MODESEL_VAL_PRBS7			0x01
#define SERDES_IREG_FLD_CMNPCSBIST_MODESEL_VAL_PRBS23			0x02
#define SERDES_IREG_FLD_CMNPCSBIST_MODESEL_VAL_PRBS31			0x03
#define SERDES_IREG_FLD_CMNPCSBIST_MODESEL_VAL_CLK1010			0x04

#define SERDES_IREG_FLD_TXBIST_BITERROR_EN_REG_NUM			80
#define SERDES_IREG_FLD_TXBIST_BITERROR_EN				0x20

#define SERDES_IREG_FLD_CMNPCIEGEN3_LOCWREN_REG_NUM			95
#define SERDES_IREG_FLD_CMNPCIEGEN3_LOCWREN				(1 << 2)

#define SERDES_IREG_FLD_CMNPCS_LOCWREN_REG_NUM				95
#define SERDES_IREG_FLD_CMNPCS_LOCWREN					(1 << 3)

#define SERDES_IREG_FLD_CMNPCSBIST_LOCWREN_REG_NUM			95
#define SERDES_IREG_FLD_CMNPCSBIST_LOCWREN				(1 << 4)

#define SERDES_IREG_FLD_CMNPCSPSTATE_LOCWREN_REG_NUM			95
#define SERDES_IREG_FLD_CMNPCSPSTATE_LOCWREN				(1 << 5)

#define SERDES_IREG_FLD_PCS_LOCWREN_REG_NUM				96
#define SERDES_IREG_FLD_PCS_LOCWREN					(1 << 3)

#define SERDES_IREG_FLD_EYE_DIAG_SAMPLE_CNT_MSB_REG_NUM			150
#ifdef CONFIG_SYNO_ALPINE_A0
#define SERDES_IREG_FLD_EYE_DIAG_SAMPLE_CNT_MSB_MASK			0xff
#define SERDES_IREG_FLD_EYE_DIAG_SAMPLE_CNT_MSB_SHIFT			0
#endif
#define SERDES_IREG_FLD_EYE_DIAG_SAMPLE_CNT_LSB_REG_NUM			151
#ifdef CONFIG_SYNO_ALPINE_A0
#define SERDES_IREG_FLD_EYE_DIAG_SAMPLE_CNT_LSB_MASK			0xff
#define SERDES_IREG_FLD_EYE_DIAG_SAMPLE_CNT_LSB_SHIFT			0

#define SERDES_IREG_FLD_RXLOCK2REF_LOCWREN_REG_NUM			230
#define SERDES_IREG_FLD_RXLOCK2REF_LOCWREN				1 << 0

#define SERDES_IREG_FLD_RXCALEYEDIAGFSM_BERTHRESHOLD1_REG_NUM		623
#define SERDES_IREG_FLD_RXCALEYEDIAGFSM_BERTHRESHOLD1_MASK		0xff
#define SERDES_IREG_FLD_RXCALEYEDIAGFSM_BERTHRESHOLD1_SHIFT		0

#define SERDES_IREG_FLD_RXCALEYEDIAGFSM_BERTHRESHOLD2_REG_NUM		624
#define SERDES_IREG_FLD_RXCALEYEDIAGFSM_BERTHRESHOLD2_MASK		0xff
#define SERDES_IREG_FLD_RXCALEYEDIAGFSM_BERTHRESHOLD2_SHIFT		0

#define SERDES_IREG_FLD_RXCALEYEDIAGFSM_X_Y_VALWEIGHT_REG_NUM		626
#define SERDES_IREG_FLD_RXCALEYEDIAGFSM_XVALWEIGHT_MASK			0x0F
#define SERDES_IREG_FLD_RXCALEYEDIAGFSM_XVALWEIGHT_SHIFT		0
#define SERDES_IREG_FLD_RXCALEYEDIAGFSM_YVALWEIGHT_MASK			0xF0
#define SERDES_IREG_FLD_RXCALEYEDIAGFSM_YVALWEIGHT_SHIFT		4

#define SERDES_IREG_FLD_RXCALEYEDIAGFSM_XVALCOARSE_REG_NUM		627
#define SERDES_IREG_FLD_RXCALEYEDIAGFSM_XVALCOARSE_MASK			0x7F
#define SERDES_IREG_FLD_RXCALEYEDIAGFSM_XVALCOARSE_SHIFT		0

#define SERDES_IREG_FLD_RXCALEYEDIAGFSM_XVALFINE_REG_NUM		628
#define SERDES_IREG_FLD_RXCALEYEDIAGFSM_XVALFINE_MASK			0x7F
#define SERDES_IREG_FLD_RXCALEYEDIAGFSM_XVALFINE_SHIFT			0

#define SERDES_IREG_FLD_RXCALEYEDIAGFSM_YVALCOARSE_REG_NUM		629
#define SERDES_IREG_FLD_RXCALEYEDIAGFSM_YVALCOARSE_MASK			0x0F
#define SERDES_IREG_FLD_RXCALEYEDIAGFSM_YVALCOARSE_SHIFT		0

#define SERDES_IREG_FLD_RXCALEYEDIAGFSM_YVALFINE_REG_NUM		630
#define SERDES_IREG_FLD_RXCALEYEDIAGFSM_YVALFINE_MASK			0x0F
#define SERDES_IREG_FLD_RXCALEYEDIAGFSM_YVALFINE_SHIFT			0
#endif

#ifdef __cplusplus
}
#endif

#endif  
