#ifndef MY_ABC_HERE
#define MY_ABC_HERE
#endif
#ifndef _LINUX_GENHD_H
#define _LINUX_GENHD_H

#include <linux/types.h>
#include <linux/kdev_t.h>
#include <linux/rcupdate.h>
#include <linux/slab.h>

#ifdef CONFIG_BLOCK

#define kobj_to_dev(k)		container_of((k), struct device, kobj)
#define dev_to_disk(device)	container_of((device), struct gendisk, part0.__dev)
#define dev_to_part(device)	container_of((device), struct hd_struct, __dev)
#define disk_to_dev(disk)	(&(disk)->part0.__dev)
#define part_to_dev(part)	(&((part)->__dev))

extern struct device_type part_type;
extern struct kobject *block_depr;
extern struct class block_class;

enum {
 
	DOS_EXTENDED_PARTITION = 5,
	LINUX_EXTENDED_PARTITION = 0x85,
	WIN98_EXTENDED_PARTITION = 0x0f,

	SUN_WHOLE_DISK = DOS_EXTENDED_PARTITION,

	LINUX_SWAP_PARTITION = 0x82,
	LINUX_DATA_PARTITION = 0x83,
	LINUX_LVM_PARTITION = 0x8e,
	LINUX_RAID_PARTITION = 0xfd,	 

	SOLARIS_X86_PARTITION =	LINUX_SWAP_PARTITION,
	NEW_SOLARIS_X86_PARTITION = 0xbf,

	DM6_AUX1PARTITION = 0x51,	 
	DM6_AUX3PARTITION = 0x53,	 
	DM6_PARTITION =	0x54,		 
	EZD_PARTITION =	0x55,		 

	FREEBSD_PARTITION = 0xa5,	 
	OPENBSD_PARTITION = 0xa6,	 
	NETBSD_PARTITION = 0xa9,	 
	BSDI_PARTITION = 0xb7,		 
	MINIX_PARTITION = 0x81,		 
	UNIXWARE_PARTITION = 0x63,	 
};

#define DISK_MAX_PARTS			256
#define DISK_NAME_LEN			32

#include <linux/major.h>
#include <linux/device.h>
#include <linux/smp.h>
#include <linux/string.h>
#include <linux/fs.h>
#include <linux/workqueue.h>

struct partition {
	unsigned char boot_ind;		 
	unsigned char head;		 
	unsigned char sector;		 
	unsigned char cyl;		 
	unsigned char sys_ind;		 
	unsigned char end_head;		 
	unsigned char end_sector;	 
	unsigned char end_cyl;		 
	__le32 start_sect;	 
	__le32 nr_sects;		 
} __attribute__((packed));

struct disk_stats {
	unsigned long sectors[2];	 
	unsigned long ios[2];
	unsigned long merges[2];
	unsigned long ticks[2];
	unsigned long io_ticks;
	unsigned long time_in_queue;
};

#define PARTITION_META_INFO_VOLNAMELTH	64
#define PARTITION_META_INFO_UUIDLTH	16

struct partition_meta_info {
	u8 uuid[PARTITION_META_INFO_UUIDLTH];	 
	u8 volname[PARTITION_META_INFO_VOLNAMELTH];
};

struct hd_struct {
	sector_t start_sect;
	sector_t nr_sects;
	sector_t alignment_offset;
	unsigned int discard_alignment;
	struct device __dev;
	struct kobject *holder_dir;
	int policy, partno;
	struct partition_meta_info *info;
#ifdef CONFIG_FAIL_MAKE_REQUEST
	int make_it_fail;
#endif
	unsigned long stamp;
	atomic_t in_flight[2];
#ifdef	CONFIG_SMP
	struct disk_stats __percpu *dkstats;
#else
	struct disk_stats dkstats;
#endif
	atomic_t ref;
	struct rcu_head rcu_head;
#ifdef MY_ABC_HERE
	unsigned auto_remap;
#endif
};

#define GENHD_FL_REMOVABLE			1
 
#define GENHD_FL_MEDIA_CHANGE_NOTIFY		4
#define GENHD_FL_CD				8
#define GENHD_FL_UP				16
#define GENHD_FL_SUPPRESS_PARTITION_INFO	32
#define GENHD_FL_EXT_DEVT			64  
#define GENHD_FL_NATIVE_CAPACITY		128
#define GENHD_FL_BLOCK_EVENTS_ON_EXCL_WRITE	256
#define GENHD_FL_NO_PART_SCAN			512

enum {
	DISK_EVENT_MEDIA_CHANGE			= 1 << 0,  
	DISK_EVENT_EJECT_REQUEST		= 1 << 1,  
};

#define BLK_SCSI_MAX_CMDS	(256)
#define BLK_SCSI_CMD_PER_LONG	(BLK_SCSI_MAX_CMDS / (sizeof(long) * 8))

struct blk_scsi_cmd_filter {
	unsigned long read_ok[BLK_SCSI_CMD_PER_LONG];
	unsigned long write_ok[BLK_SCSI_CMD_PER_LONG];
	struct kobject kobj;
};

struct disk_part_tbl {
	struct rcu_head rcu_head;
	int len;
	struct hd_struct __rcu *last_lookup;
	struct hd_struct __rcu *part[];
};

struct disk_events;

struct gendisk {
	 
	int major;			 
	int first_minor;
	int minors;                      

	char disk_name[DISK_NAME_LEN];	 
	char *(*devnode)(struct gendisk *gd, mode_t *mode);

	unsigned int events;		 
	unsigned int async_events;	 

	struct disk_part_tbl __rcu *part_tbl;
	struct hd_struct part0;

	const struct block_device_operations *fops;
	struct request_queue *queue;
	void *private_data;

	int flags;
	struct device *driverfs_dev;   
	struct kobject *slave_dir;

	struct timer_rand_state *random;
	atomic_t sync_io;		 
	struct disk_events *ev;
#ifdef  CONFIG_BLK_DEV_INTEGRITY
	struct blk_integrity *integrity;
#endif
	int node_id;
#ifdef MY_ABC_HERE
	int systemDisk;
#endif
};

static inline struct gendisk *part_to_disk(struct hd_struct *part)
{
	if (likely(part)) {
		if (part->partno)
			return dev_to_disk(part_to_dev(part)->parent);
		else
			return dev_to_disk(part_to_dev(part));
	}
	return NULL;
}

static inline void part_pack_uuid(const u8 *uuid_str, u8 *to)
{
	int i;
	for (i = 0; i < 16; ++i) {
		*to++ = (hex_to_bin(*uuid_str) << 4) |
			(hex_to_bin(*(uuid_str + 1)));
		uuid_str += 2;
		switch (i) {
		case 3:
		case 5:
		case 7:
		case 9:
			uuid_str++;
			continue;
		}
	}
}

static inline int disk_max_parts(struct gendisk *disk)
{
	if (disk->flags & GENHD_FL_EXT_DEVT)
		return DISK_MAX_PARTS;
	return disk->minors;
}

static inline bool disk_part_scan_enabled(struct gendisk *disk)
{
	return disk_max_parts(disk) > 1 &&
		!(disk->flags & GENHD_FL_NO_PART_SCAN);
}

static inline dev_t disk_devt(struct gendisk *disk)
{
	return disk_to_dev(disk)->devt;
}

static inline dev_t part_devt(struct hd_struct *part)
{
	return part_to_dev(part)->devt;
}

extern struct hd_struct *disk_get_part(struct gendisk *disk, int partno);

static inline void disk_put_part(struct hd_struct *part)
{
	if (likely(part))
		put_device(part_to_dev(part));
}

#define DISK_PITER_REVERSE	(1 << 0)  
#define DISK_PITER_INCL_EMPTY	(1 << 1)  
#define DISK_PITER_INCL_PART0	(1 << 2)  
#define DISK_PITER_INCL_EMPTY_PART0 (1 << 3)  

struct disk_part_iter {
	struct gendisk		*disk;
	struct hd_struct	*part;
	int			idx;
	unsigned int		flags;
};

extern void disk_part_iter_init(struct disk_part_iter *piter,
				 struct gendisk *disk, unsigned int flags);
extern struct hd_struct *disk_part_iter_next(struct disk_part_iter *piter);
extern void disk_part_iter_exit(struct disk_part_iter *piter);

extern struct hd_struct *disk_map_sector_rcu(struct gendisk *disk,
					     sector_t sector);

#ifdef	CONFIG_SMP
#define part_stat_lock()	({ rcu_read_lock(); get_cpu(); })
#define part_stat_unlock()	do { put_cpu(); rcu_read_unlock(); } while (0)

#define __part_stat_add(cpu, part, field, addnd)			\
	(per_cpu_ptr((part)->dkstats, (cpu))->field += (addnd))

#define part_stat_read(part, field)					\
({									\
	typeof((part)->dkstats->field) res = 0;				\
	unsigned int _cpu;						\
	for_each_possible_cpu(_cpu)					\
		res += per_cpu_ptr((part)->dkstats, _cpu)->field;	\
	res;								\
})

static inline void part_stat_set_all(struct hd_struct *part, int value)
{
	int i;

	for_each_possible_cpu(i)
		memset(per_cpu_ptr(part->dkstats, i), value,
				sizeof(struct disk_stats));
}

static inline int init_part_stats(struct hd_struct *part)
{
	part->dkstats = alloc_percpu(struct disk_stats);
	if (!part->dkstats)
		return 0;
	return 1;
}

static inline void free_part_stats(struct hd_struct *part)
{
	free_percpu(part->dkstats);
}

#else  
#define part_stat_lock()	({ rcu_read_lock(); 0; })
#define part_stat_unlock()	rcu_read_unlock()

#define __part_stat_add(cpu, part, field, addnd)				\
	((part)->dkstats.field += addnd)

#define part_stat_read(part, field)	((part)->dkstats.field)

static inline void part_stat_set_all(struct hd_struct *part, int value)
{
	memset(&part->dkstats, value, sizeof(struct disk_stats));
}

static inline int init_part_stats(struct hd_struct *part)
{
	return 1;
}

static inline void free_part_stats(struct hd_struct *part)
{
}

#endif  

#define part_stat_add(cpu, part, field, addnd)	do {			\
	__part_stat_add((cpu), (part), field, addnd);			\
	if ((part)->partno)						\
		__part_stat_add((cpu), &part_to_disk((part))->part0,	\
				field, addnd);				\
} while (0)

#define part_stat_dec(cpu, gendiskp, field)				\
	part_stat_add(cpu, gendiskp, field, -1)
#define part_stat_inc(cpu, gendiskp, field)				\
	part_stat_add(cpu, gendiskp, field, 1)
#define part_stat_sub(cpu, gendiskp, field, subnd)			\
	part_stat_add(cpu, gendiskp, field, -subnd)

static inline void part_inc_in_flight(struct hd_struct *part, int rw)
{
	atomic_inc(&part->in_flight[rw]);
	if (part->partno)
		atomic_inc(&part_to_disk(part)->part0.in_flight[rw]);
}

static inline void part_dec_in_flight(struct hd_struct *part, int rw)
{
	atomic_dec(&part->in_flight[rw]);
	if (part->partno)
		atomic_dec(&part_to_disk(part)->part0.in_flight[rw]);
}

static inline int part_in_flight(struct hd_struct *part)
{
	return atomic_read(&part->in_flight[0]) + atomic_read(&part->in_flight[1]);
}

static inline struct partition_meta_info *alloc_part_info(struct gendisk *disk)
{
	if (disk)
		return kzalloc_node(sizeof(struct partition_meta_info),
				    GFP_KERNEL, disk->node_id);
	return kzalloc(sizeof(struct partition_meta_info), GFP_KERNEL);
}

static inline void free_part_info(struct hd_struct *part)
{
	kfree(part->info);
}

extern void part_round_stats(int cpu, struct hd_struct *part);

extern void add_disk(struct gendisk *disk);
extern void del_gendisk(struct gendisk *gp);
extern struct gendisk *get_gendisk(dev_t dev, int *partno);
extern struct block_device *bdget_disk(struct gendisk *disk, int partno);

extern void set_device_ro(struct block_device *bdev, int flag);
extern void set_disk_ro(struct gendisk *disk, int flag);

static inline int get_disk_ro(struct gendisk *disk)
{
	return disk->part0.policy;
}

extern void disk_block_events(struct gendisk *disk);
extern void disk_unblock_events(struct gendisk *disk);
extern void disk_flush_events(struct gendisk *disk, unsigned int mask);
extern unsigned int disk_clear_events(struct gendisk *disk, unsigned int mask);

extern void add_disk_randomness(struct gendisk *disk);
extern void rand_initialize_disk(struct gendisk *disk);

static inline sector_t get_start_sect(struct block_device *bdev)
{
	return bdev->bd_part->start_sect;
}
static inline sector_t get_capacity(struct gendisk *disk)
{
	return disk->part0.nr_sects;
}
static inline void set_capacity(struct gendisk *disk, sector_t size)
{
	disk->part0.nr_sects = size;
}

#ifdef CONFIG_SOLARIS_X86_PARTITION

#define SOLARIS_X86_NUMSLICE	16
#define SOLARIS_X86_VTOC_SANE	(0x600DDEEEUL)

struct solaris_x86_slice {
	__le16 s_tag;		 
	__le16 s_flag;		 
	__le32 s_start;		 
	__le32 s_size;		 
};

struct solaris_x86_vtoc {
	unsigned int v_bootinfo[3];	 
	__le32 v_sanity;		 
	__le32 v_version;		 
	char	v_volume[8];		 
	__le16	v_sectorsz;		 
	__le16	v_nparts;		 
	unsigned int v_reserved[10];	 
	struct solaris_x86_slice
		v_slice[SOLARIS_X86_NUMSLICE];  
	unsigned int timestamp[SOLARIS_X86_NUMSLICE];  
	char	v_asciilabel[128];	 
};

#endif  

#ifdef CONFIG_BSD_DISKLABEL
 
#define BSD_DISKMAGIC	(0x82564557UL)	 
#define BSD_MAXPARTITIONS	16
#define OPENBSD_MAXPARTITIONS	16
#define BSD_FS_UNUSED		0	 
struct bsd_disklabel {
	__le32	d_magic;		 
	__s16	d_type;			 
	__s16	d_subtype;		 
	char	d_typename[16];		 
	char	d_packname[16];			  
	__u32	d_secsize;		 
	__u32	d_nsectors;		 
	__u32	d_ntracks;		 
	__u32	d_ncylinders;		 
	__u32	d_secpercyl;		 
	__u32	d_secperunit;		 
	__u16	d_sparespertrack;	 
	__u16	d_sparespercyl;		 
	__u32	d_acylinders;		 
	__u16	d_rpm;			 
	__u16	d_interleave;		 
	__u16	d_trackskew;		 
	__u16	d_cylskew;		 
	__u32	d_headswitch;		 
	__u32	d_trkseek;		 
	__u32	d_flags;		 
#define NDDATA 5
	__u32	d_drivedata[NDDATA];	 
#define NSPARE 5
	__u32	d_spare[NSPARE];	 
	__le32	d_magic2;		 
	__le16	d_checksum;		 

	__le16	d_npartitions;		 
	__le32	d_bbsize;		 
	__le32	d_sbsize;		 
	struct	bsd_partition {		 
		__le32	p_size;		 
		__le32	p_offset;	 
		__le32	p_fsize;	 
		__u8	p_fstype;	 
		__u8	p_frag;		 
		__le16	p_cpg;		 
	} d_partitions[BSD_MAXPARTITIONS];	 
};

#endif	 

#ifdef CONFIG_UNIXWARE_DISKLABEL
 
#define UNIXWARE_DISKMAGIC     (0xCA5E600DUL)	 
#define UNIXWARE_DISKMAGIC2    (0x600DDEEEUL)	 
#define UNIXWARE_NUMSLICE      16
#define UNIXWARE_FS_UNUSED     0		 

struct unixware_slice {
	__le16   s_label;	 
	__le16   s_flags;	 
	__le32   start_sect;	 
	__le32   nr_sects;	 
};

struct unixware_disklabel {
	__le32   d_type;               	 
	__le32   d_magic;                 
	__le32   d_version;               
	char    d_serial[12];            
	__le32   d_ncylinders;            
	__le32   d_ntracks;               
	__le32   d_nsectors;              
	__le32   d_secsize;               
	__le32   d_part_start;            
	__le32   d_unknown1[12];          
 	__le32	d_alt_tbl;               
 	__le32	d_alt_len;               
 	__le32	d_phys_cyl;              
 	__le32	d_phys_trk;              
 	__le32	d_phys_sec;              
 	__le32	d_phys_bytes;            
 	__le32	d_unknown2;              
	__le32   d_unknown3;              
	__le32	d_pad[8];                

	struct unixware_vtoc {
		__le32	v_magic;		 
		__le32	v_version;		 
		char	v_name[8];		 
		__le16	v_nslices;		 
		__le16	v_unknown1;		 
		__le32	v_reserved[10];		 
		struct unixware_slice
			v_slice[UNIXWARE_NUMSLICE];	 
	} vtoc;

};   

#endif  

#ifdef CONFIG_MINIX_SUBPARTITION
#   define MINIX_NR_SUBPARTITIONS  4
#endif  

#define ADDPART_FLAG_NONE	0
#define ADDPART_FLAG_RAID	1
#define ADDPART_FLAG_WHOLEDISK	2

extern int blk_alloc_devt(struct hd_struct *part, dev_t *devt);
extern void blk_free_devt(dev_t devt);
extern dev_t blk_lookup_devt(const char *name, int partno);
extern char *disk_name (struct gendisk *hd, int partno, char *buf);

extern int disk_expand_part_tbl(struct gendisk *disk, int target);
extern int rescan_partitions(struct gendisk *disk, struct block_device *bdev);
extern int invalidate_partitions(struct gendisk *disk, struct block_device *bdev);
extern struct hd_struct * __must_check add_partition(struct gendisk *disk,
						     int partno, sector_t start,
						     sector_t len, int flags,
						     struct partition_meta_info
						       *info);
extern void __delete_partition(struct hd_struct *);
extern void delete_partition(struct gendisk *, int);
extern void printk_all_partitions(void);

extern struct gendisk *alloc_disk_node(int minors, int node_id);
extern struct gendisk *alloc_disk(int minors);
extern struct kobject *get_disk(struct gendisk *disk);
extern void put_disk(struct gendisk *disk);
extern void blk_register_region(dev_t devt, unsigned long range,
			struct module *module,
			struct kobject *(*probe)(dev_t, int *, void *),
			int (*lock)(dev_t, void *),
			void *data);
extern void blk_unregister_region(dev_t devt, unsigned long range);

extern ssize_t part_size_show(struct device *dev,
			      struct device_attribute *attr, char *buf);
extern ssize_t part_stat_show(struct device *dev,
			      struct device_attribute *attr, char *buf);
extern ssize_t part_inflight_show(struct device *dev,
			      struct device_attribute *attr, char *buf);
#ifdef CONFIG_FAIL_MAKE_REQUEST
extern ssize_t part_fail_show(struct device *dev,
			      struct device_attribute *attr, char *buf);
extern ssize_t part_fail_store(struct device *dev,
			       struct device_attribute *attr,
			       const char *buf, size_t count);
#endif  

static inline void hd_ref_init(struct hd_struct *part)
{
	atomic_set(&part->ref, 1);
	smp_mb();
}

static inline void hd_struct_get(struct hd_struct *part)
{
	atomic_inc(&part->ref);
	smp_mb__after_atomic_inc();
}

static inline int hd_struct_try_get(struct hd_struct *part)
{
	return atomic_inc_not_zero(&part->ref);
}

static inline void hd_struct_put(struct hd_struct *part)
{
	if (atomic_dec_and_test(&part->ref))
		__delete_partition(part);
}

#else  

static inline void printk_all_partitions(void) { }

static inline dev_t blk_lookup_devt(const char *name, int partno)
{
	dev_t devt = MKDEV(0, 0);
	return devt;
}

#endif  

#endif  
