/*
 *  linux/arch/arm/mach-comcerto/include/mach/comcerto-2000/clk-rst.h
 *
 *  Copyright (C) 2008 Mindspeed Technologies, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __CLK_H__
#define __CLK_H__

/*
 * Clock Reset Registers
 */
#define DEVICE_RST_CNTRL		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x000)
#define SERDES_RST_CNTRL		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x004)
#define PCIe_SATA_RST_CNTRL		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x008)
#define USB_RST_CNTRL			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x00C)
#define GNRL_DEVICE_CNFG_0		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x010)
#define GNRL_DEVICE_CNFG_1 		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x014)
#define GNRL_DEVICE_STATUS		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x018)
#define A9DP_PWR_STAT			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x028)
#define A9DP_PWR_CNTRL			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x02C)
#define GNRL_CLK_CNTRL_0 		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x030)
#define GNRL_CLK_CNTRL_1		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x034)
#define PLLS_GLOBAL_CNTRL		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x038)
#define AXI_CLK_CNTRL_0			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x040)
#define AXI_CLK_CNTRL_1			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x044)
#define AXI_CLK_CNTRL_2			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x048)
#define AXI_CLK_DIV_CNTRL		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x04C)
#define AXI_RESET_0			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x050)
#define AXI_RESET_1			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x054)
#define AXI_RESET_2			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x058)
#define A9DP_MPU_CLK_CNTRL		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x68)
#define A9DP_MPU_CLK_DIV_CNTRL       	APB_VADDR(COMCERTO_APB_CLK_BASE + 0x6C)
#define A9DP_MPU_RESET               	APB_VADDR(COMCERTO_APB_CLK_BASE + 0x70)
#define A9DP_CPU_CLK_CNTRL           	APB_VADDR(COMCERTO_APB_CLK_BASE + 0x74)
#define A9DP_CPU_RESET               	APB_VADDR(COMCERTO_APB_CLK_BASE + 0x78)
#define A9DP_CLK_CNTRL               	APB_VADDR(COMCERTO_APB_CLK_BASE + 0x80)
#define A9DP_CLK_DIV_CNTRL           	APB_VADDR(COMCERTO_APB_CLK_BASE + 0x84)
#define A9DP_RESET                   	APB_VADDR(COMCERTO_APB_CLK_BASE + 0x88)
#define L2CC_CLK_CNTRL			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x090)
#define L2CC_CLK_DIV_CNTRL		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x094)
#define L2CC_RESET			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x098)
#define TPI_CLK_CNTRL			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x0A0)
#define TPI_CLK_DIV_CNTRL		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x0A4)
#define TPI_RESET			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x0A8)
#define CSYS_CLK_CNTRL			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x0B0)
#define CSYS_CLK_DIV_CNTRL		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x0B4)
#define CSYS_RESET			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x0B8)
#define EXTPHY0_CLK_CNTRL		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x0C0)
#define EXTPHY0_CLK_DIV_CNTRL		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x0C4)
#define EXTPHY0_RESET			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x0C8)
#define EXTPHY1_CLK_CNTRL		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x0D0)
#define EXTPHY1_CLK_DIV_CNTRL		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x0D4)
#define EXTPHY1_RESET			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x0D8)
#define EXTPHY2_CLK_CNTRL 		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x0E0)
#define EXTPHY2_CLK_DIV_CNTRL 		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x0E4)
#define EXTPHY2_RESET			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x0E8)
#define DDR_CLK_CNTRL 			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x0F0)
#define DDR_CLK_DIV_CNTRL 		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x0F4)
#define DDR_RESET			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x0F8)
#define PFE_CLK_CNTRL 			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x100)
#define PFE_CLK_DIV_CNTRL 		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x104)
#define PFE_RESET			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x108)
#define IPSEC_CLK_CNTRL			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x110)
#define IPSEC_CLK_DIV_CNTRL		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x114)
#define IPSEC_RESET			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x118)
#define DECT_CLK_CNTRL 			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x120)
#define DECT_CLK_DIV_CNTRL 		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x124)
#define DECT_RESET 			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x128)
#define GEMTX_CLK_CNTRL			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x130)
#define GEMTX_CLK_DIV_CNTRL		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x134)
#define GEMTX_RESET			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x138)
#define TDMNTG_REF_CLK_CNTRL 		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x140)
#define TDMNTG_REF_CLK_DIV_CNTRL 	APB_VADDR(COMCERTO_APB_CLK_BASE + 0x144)
#define TDMNTG_RESET 			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x148)
#define TDM_CLK_CNTRL			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x14C)
#define TSUNTG_REF_CLK_CNTRL 		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x150)
#define TSUNTG_REF_CLK_DIV_CNTRL 	APB_VADDR(COMCERTO_APB_CLK_BASE + 0x154)
#define TSUNTG_RESET 			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x158)
#define SATA_PMU_CLK_CNTRL 		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x160)
#define SATA_PMU_CLK_DIV_CNTRL 		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x164)
#define SATA_PMU_RESET 			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x168)
#define SATA_OOB_CLK_CNTRL 		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x170)
#define SATA_OOB_CLK_DIV_CNTRL 		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x174)
#define SATA_OOB_RESET 			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x178)
#define SATA_OCC_CLK_CNTRL		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x180)
#define SATA_OCC_CLK_DIV_CNTRL		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x184)
#define SATA_OCC_RESET			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x188)
#define PCIE_OCC_CLK_CNTRL		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x190)
#define PCIE_OCC_CLK_DIV_CNTRL		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x194)
#define PCIE_OCC_RESET			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x198)
#define SGMII_OCC_CLK_CNTRL 		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x1A0)
#define SGMII_OCC_CLK_DIV_CNTRL 	APB_VADDR(COMCERTO_APB_CLK_BASE + 0x1A4)
#define SGMII_OCC_RESET 		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x1A8)
#define PLL0_M_LSB			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x1C0)
#define PLL0_M_MSB			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x1C4)
#define PLL0_P				APB_VADDR(COMCERTO_APB_CLK_BASE + 0x1C8)
#define PLL0_S				APB_VADDR(COMCERTO_APB_CLK_BASE + 0x1CC)
#define PLL0_CNTRL			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x1D0)
#define PLL0_TEST			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x1D4)
#define PLL0_STATUS			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x1D8)
#define PLL0_DIV_CNTRL			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x1DC)
#define PLL1_M_LSB			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x1E0)
#define PLL1_M_MSB			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x1E4)
#define PLL1_P				APB_VADDR(COMCERTO_APB_CLK_BASE + 0x1E8)
#define PLL1_S				APB_VADDR(COMCERTO_APB_CLK_BASE + 0x1EC)
#define PLL1_CNTRL			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x1F0)
#define PLL1_TEST			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x1F4)
#define PLL1_STATUS			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x1F8)
#define PLL1_DIV_CNTRL			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x1FC)
#define PLL2_M_LSB			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x200)
#define PLL2_M_MSB			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x204)
#define PLL2_P				APB_VADDR(COMCERTO_APB_CLK_BASE + 0x208)
#define PLL2_S				APB_VADDR(COMCERTO_APB_CLK_BASE + 0x20C)
#define PLL2_CNTRL			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x210)
#define PLL2_TEST			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x214)
#define PLL2_STATUS			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x218)
#define PLL2_DIV_CNTRL			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x21C)
#define PLL3_M_LSB			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x220)
#define PLL3_M_MSB			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x224)
#define PLL3_P				APB_VADDR(COMCERTO_APB_CLK_BASE + 0x228)
#define PLL3_S				APB_VADDR(COMCERTO_APB_CLK_BASE + 0x22c)
#define PLL3_CNTRL			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x230)
#define PLL3_TEST			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x234)
#define PLL3_STATUS			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x238)
#define PLL3_DITHER_CNTRL		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x23C)
#define PLL3_K_LSB 			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x240)
#define PLL3_K_MSB 			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x244)
#define PLL3_MFR 			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x248)
#define PLL3_MRR 			APB_VADDR(COMCERTO_APB_CLK_BASE + 0x24C)

#define PLL0				0
#define PLL1				1
#define PLL2				2
#define PLL3				3

/* Device Reset Control Register (DEVICE_RST_CNTRL)*/

#define CLK_DIV_RESTART         (1 << 7)
#define WD_STATUS_CLR           (1 << 6)
#define AXI_WD_RST_EN           (1 << 5)
#define DEBUG_RST               (1 << 4)
#define CLKRST_SCLR_RST         (1 << 3)
#define FUNC_SCLR_RST           (1 << 2)
#define GLB_SCLR_RST            (1 << 1)
#define PWR_ON_SOFT_RST         (1 << 0)

/* General Device Configuration Status Register (GNRL_DEVICE_STATUS) */
#define CPU1_WD_RST_ACTIVATED   (1 << 2)
#define CPU0_WD_RST_ACTIVATED   (1 << 1)
#define AXI_WD_RST_ACTIVATED    (1 << 0)

/* Clock Control Register */
#define CLOCK_DOMAIN_ENABLE		1
#define CLOCK_DOMAIN_ENABLE_SHIFT	0

#define CLOCK_SOURCE_PLL0		0
#define CLOCK_SOURCE_PLL1		1
#define CLOCK_SOURCE_PLL2		2
#define CLOCK_SOURCE_PLL3		3
#define CLOCK_SOURCE_PLL4		4

#define CLOCK_SOURCE_SHIFT		1

#define CLK_DIV_BYPASS			(1 << 7)
#define CLK_DIV_RATIO_MASK		0x1f

#define PLL_VSEL			(1 << 6)
#define PLL_LOCK_EN			(1 << 5)
#define PLL_BYPASS			(1 << 4)
#define PLL_RESET			(1 << 0)

#define PLL_LOCK			(1 << 0)

#define CLK_PLL_SRC_MASK		0x7
#define CLK_PLL_SRC_SHIFT		1
#define CLK_A9DP_PERI_DIV_BYPASS	(1 << 3)

/* TDMNTG */
#define TDMNTG_ADDR_SPACE_BASEADDR 		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x280)

#define TDM_NTG_CLK_CTRL	(TDMNTG_ADDR_SPACE_BASEADDR + 0x00)
#define TDM_NTG_INCR		(TDMNTG_ADDR_SPACE_BASEADDR + 0x04)
#define TDM_FSYNC_GEN_CTRL	(TDMNTG_ADDR_SPACE_BASEADDR + 0x08)
#define	TDM_FSYNC_LOW		(TDMNTG_ADDR_SPACE_BASEADDR + 0x0C)
#define TDM_FSYNC_HIGH		(TDMNTG_ADDR_SPACE_BASEADDR + 0x10)

#define FSYNC_FALL_EDGE		(1 << 1)
#define	NTG_DIV_RST_N		(1 << 5)
#define NTG_EN			(1 << 0)

/* TSUNTG */
#define TSUNTG_ADDR_SPACE_BASEADDR 		APB_VADDR(COMCERTO_APB_CLK_BASE + 0x2C0)

/* USB 3.0 */
#define USB1_UTMI_RST           (1 << 5)
#define USB1_PHY_RST            (1 << 4)
#define USB1_AXI_RST            (1 << 4)

/* USB 2.0 */
#define USB0_PHY_RST		(1 << 0)
#define USB0_UTMI_RST		(1 << 1)
#define USB0_AXI_RST		(1 << 3)

/* CPU */
#define CPU0_RST			(1 << 0)
#define NEON0_RST			(1 << 1)
#define CPU1_RST			(1 << 2)
#define NEON1_RST			(1 << 3)

#define CPU0_CLK_ENABLE		(1 << 0)
#define NEON0_CLK_ENABLE	(1 << 1)
#define CPU1_CLK_ENABLE		(1 << 2)
#define NEON1_CLK_ENABLE	(1 << 3)

#define GLOBAL_CLK_ENABLE	(1 << 0)

#define CLAMP_CORE0     	(1 << 4)
#define CLAMP_CORE1     	(1 << 6)
#define CORE_PWRDWN0        (1 << 5)
#define CORE_PWRDWN1        (1 << 7)
#define MP_PWRDWN       	(1 << 0)

#define SCPRE   			(1 << 4)
#define SCALL   			(1 << 5)
#define ISO_EN  			(1 << 6)

#ifndef __ASSEMBLY__

/* Function Declaration */
extern void HAL_clk_div_backup_relocate_table (void);
extern unsigned long HAL_get_ref_clk (void);
#endif

#endif
