#ifndef MY_ABC_HERE
#define MY_ABC_HERE
#endif
 
#ifndef __INCmvCtrlEnvLibh
#define __INCmvCtrlEnvLibh

#include "mvSysHwConfig.h"
#include "mvCommon.h"
#include "mvTypes.h"
#include "mvOs.h"
#include "ctrlEnv/mvCtrlEnvSpec.h"
#include "ctrlEnv/mvCtrlEnvRegs.h"
#include "ctrlEnv/mvCtrlEnvAddrDec.h"

typedef enum _mvSatRTypeID {
	 
	MV_SATR_CPU_DDR_L2_FREQ,
	MV_SATR_CORE_CLK_SELECT,
	MV_SATR_CPU1_ENABLE,
	MV_SATR_SSCG_DISABLE,
	MV_SATR_DDR_BUS_WIDTH,
	 
	MV_SATR_I2C0_SERIAL_ROM,
	MV_SATR_EXTERNAL_CPU_RESET,
	MV_SATR_EXTERNAL_CORE_RESET,
	 
	MV_SATR_BOOT_DEVICE,
	 
	MV_SATR_CPU_PLL_XTAL_BYPASS,
	MV_SATR_CPU0_ENDIANESS,
	MV_SATR_CPU0_NMFI,
	MV_SATR_CPU0_THUMB,
	MV_SATR_PEX0_CLOCK,
	MV_SATR_PEX1_CLOCK,
	MV_SATR_REF_CLOCK_ENABLE,
	MV_SATR_EFUSE_BYPASS,
	MV_SATR_POR_BYPASS,
	MV_SATR_TESTER_OPTIONS,
	MV_SATR_BOARD_ID,
	MV_SATR_READ_MAX_OPTION,
	MV_SATR_WRITE_CPU_FREQ,
	MV_SATR_WRITE_CORE_CLK_SELECT,
	MV_SATR_WRITE_CPU1_ENABLE,
	MV_SATR_WRITE_SSCG_DISABLE,
	MV_SATR_WRITE_DDR_BUS_WIDTH,
	MV_SATR_WRITE_MAX_OPTION
} MV_SATR_TYPE_ID;

typedef enum _mvConfigTypeID {
	MV_CONFIG_MAC0,
	MV_CONFIG_MAC1,
	MV_CONFIG_PON_SERDES,
	MV_CONFIG_PON_BEN_POLARITY,
	MV_CONFIG_SGMII0_CAPACITY,
	MV_CONFIG_SGMII1_CAPACITY,
	MV_CONFIG_LANE1,
	MV_CONFIG_LANE2,
	MV_CONFIG_LANE3,
	MV_CONFIG_DEVICE_BUS_MODULE,
	MV_CONFIG_SLIC_TDM_DEVICE,
	MV_CONFIG_TYPE_MAX_OPTION
} MV_CONFIG_TYPE_ID;

typedef enum _mvIoExpanderTypeID {
	MV_IO_EXPANDER_SFP0_TX_DIS,
	MV_IO_EXPANDER_SFP0_PRSNT,
	MV_IO_EXPANDER_SFP0_TX_FAULT,
	MV_IO_EXPANDER_SFP0_LOS,
	MV_IO_EXPANDER_SFP1_PRSNT,
	MV_IO_EXPANDER_SFP1_TX_FAULT,
	MV_IO_EXPANDER_SFP1_LOS,
	MV_IO_EXPANDER_SFP1_TX_DIS,
	MV_IO_EXPANDER_USB_VBUS,
	MV_IO_EXPANDER_MAC0_RJ45_PORT_LED,
	MV_IO_EXPANDER_MAC0_SFP_PORT_LED,
	MV_IO_EXPANDER_MAC1_RJ45_PORT_LED,
	MV_IO_EXPANDER_MAC1_SFP_PORT_LED,
	MV_IO_EXPANDER_PON_PORT_LED,
	MV_IO_EXPANDER_SD_STATUS,
	MV_IO_EXPANDER_SD_WRITE_PROTECT,
	MV_IO_EXPANDER_JUMPER1,
	MV_IO_EXPANDER_JUMPER2_EEPROM_ENABLED,
	MV_IO_EXPANDER_JUMPER3,
	MV_IO_EXPANDER_EXT_PHY_SMI_EN,
	MV_IO_EXPANDER_SPI1_CS_MSB0,
	MV_IO_EXPANDER_SPI1_CS_MSB1,
	MV_IO_EXPANDER_INTEG_PHY_PORTS_LED,
	MV_IO_EXPANDER_USB_SUPER_SPEED,
} MV_IO_EXPANDER_TYPE_ID;

typedef MV_STATUS (*MV_WIN_GET_FUNC_PTR)(MV_U32, MV_U32, MV_UNIT_WIN_INFO*);

typedef enum _mvSMIctrl {
	CPU_SMI_CTRL,
	SWITCH_SMI_CTRL,
	NO_SMI_CTRL,
} MV_SMI_CTRL;

typedef enum _mvCachePolicy {
	NO_COHERENCY,    
	WT_COHERENCY,    
	WB_COHERENCY     
} MV_CACHE_POLICY;

typedef enum _mvSwapType {
	MV_BYTE_SWAP,            
	MV_NO_SWAP,              
	MV_BYTE_WORD_SWAP,       
	MV_WORD_SWAP,            
	SWAP_TYPE_MAX            
} MV_SWAP_TYPE;

typedef enum {
	MV_ETHCOMP_SW_P0_2_GE_PHY_P0		=	BIT0,
	MV_ETHCOMP_SW_P1_2_GE_PHY_P1		=	BIT1,
	MV_ETHCOMP_SW_P2_2_GE_PHY_P2		=	BIT2,
	MV_ETHCOMP_SW_P3_2_GE_PHY_P3		=	BIT3,
	MV_ETHCOMP_SW_P4_2_RGMII0		=	BIT4,
	MV_ETHCOMP_SW_P4_2_RGMII0_EXT_PHY	=	BIT5,
	MV_ETHCOMP_GE_MAC0_2_SW_P6		=	BIT6,
	MV_ETHCOMP_GE_MAC0_2_GE_PHY_P0		=	BIT7,
	MV_ETHCOMP_GE_MAC0_2_RGMII0		=	BIT8,
	MV_ETHCOMP_GE_MAC0_2_COMPHY_1		=	BIT9,
	MV_ETHCOMP_GE_MAC0_2_COMPHY_2		=	BIT10,
	MV_ETHCOMP_GE_MAC0_2_COMPHY_3		=	BIT11,
	MV_ETHCOMP_GE_MAC1_2_SW_P4		=	BIT12,
	MV_ETHCOMP_GE_MAC1_2_GE_PHY_P3		=	BIT13,
	MV_ETHCOMP_GE_MAC1_2_RGMII1		=	BIT14,
	MV_ETHCOMP_GE_MAC1_2_PON_ETH_SERDES	=	BIT15,
	MV_ETHCOMP_P2P_MAC_2_PON_ETH_SERDES	=	BIT16,
	MV_ETHCOMP_P2P_MAC0_2_SW_SPEED_2G	=	BIT17,
	MV_ETHCOMP_GE_MAC0_2_COMPHY_SPEED_2G	=	BIT18,
	MV_ETHCOMP_GE_MAC1_2_RGMII0		=	BIT19,
	MV_ETHCOMP_GE_MAC1_2_PON_ETH_SERDES_SFP	=	BIT20,
} MV_ETH_COMPLEX_TOPOLOGY;

typedef enum {
	EPM_DEFAULT = 0x0,       
	EPM_MAC0_MII = 0x01,
	EPM_MAC1_MII = 0x10,
	EPM_SW_PORT_5_MII = 0x100,
	EPM_SW_PORT_6_MII = 0x1000
} MV_ETH_PORT_MODE;

typedef enum {
	SERDES_UNIT_UNCONNECTED = 0x0,
	SERDES_UNIT_PEX         = 0x1,
	SERDES_UNIT_SATA        = 0x2,
	SERDES_UNIT_SGMII0      = 0x3,
	SERDES_UNIT_SGMII1      = 0x4,
	SERDES_UNIT_SGMII2      = 0x5,
	SERDES_UNIT_SGMII3      = 0x6,
	SERDES_UNIT_QSGMII      = 0x7,
	SERDES_UNIT_LAST
} MV_SERDES_UNIT_INDX;

typedef enum {
	PEX_BUS_DISABLED        = 0,
	PEX_BUS_MODE_X1         = 1,
	PEX_BUS_MODE_X4         = 2,
	PEX_BUS_MODE_X8         = 3
} MV_PEX_UNIT_CFG;

typedef struct _boardSerdesConf {
	MV_U32 enableSerdesConfiguration;        
	MV_U32 serdesLine0_7;                    
	MV_U32 serdesLine8_15;                   
	MV_PEX_UNIT_CFG pex0Mod;
	MV_PEX_UNIT_CFG pex1Mod;
	MV_PEX_UNIT_CFG pex2Mod;
	MV_PEX_UNIT_CFG pex3Mod;
	MV_U32 busSpeed;         
} MV_SERDES_CFG;

#define TSEN_CTRL_MSB_REG				0xE8080

#define TSEN_CTRL_UNIT_CTRL_OFFSET			27
#define TSEN_CTRL_UNIT_CTRL_MASK			(6 << TSEN_CTRL_UNIT_CTRL_OFFSET)

#define TSEN_CTRL_READOUT_INVERT_OFFSET			15
#define TSEN_CTRL_READOUT_INVERT_MASK			(1 << TSEN_CTRL_READOUT_INVERT_OFFSET)

#define TSEN_CTRL_SOFT_RST_OFFSET			8
#define TSEN_CTRL_SOFT_RST_MASK				(1 << TSEN_CTRL_SOFT_RST_OFFSET)

#define TSEN_STATUS_REG							0xE8078
#define TSEN_STATUS_TEMP_OUT_OFFSET				0
#define TSEN_STATUS_TEMP_OUT_MASK				(0x1FF << TSEN_STATUS_TEMP_OUT_OFFSET)

#define SAR_CPU_FAB_GET(cpu, fab)       (((cpu & 0x7) << 21) | ((fab & 0xF) << 24))

MV_STATUS mvCtrlSatRWrite(MV_SATR_TYPE_ID satrWriteField, MV_SATR_TYPE_ID satrReadField, MV_U8 val);
MV_U32 mvCtrlSatRRead(MV_SATR_TYPE_ID satrField);
MV_STATUS mvCtrlCpuDdrL2FreqGet(MV_FREQ_MODE *freqMode);
MV_VOID mvCtrlSatrInit(MV_U32 early);
MV_VOID mvCtrlSysConfigInit(MV_VOID);
MV_U32 mvCtrlSysConfigGet(MV_CONFIG_TYPE_ID configField);
MV_U32 mvCtrlGetCpuNum(MV_VOID);
MV_U32 mvCtrlGetQuadNum(MV_VOID);
MV_STATUS mvCtrlUpdatePexId(MV_VOID);
MV_BOOL mvCtrlIsValidSatR(MV_VOID);
MV_STATUS mvCtrlFreqModeGet(MV_U32 freqModeSatRValue, MV_FREQ_MODE *freqMode);
MV_BOOL mvCtrlIsEepromEnabled(MV_VOID);
MV_STATUS mvCtrlEepromEnable(MV_BOOL enable);
MV_STATUS mvCtrlBoardConfigGet(MV_U8 *tempVal);
MV_U32 mvCtrlSocUnitInfoNumGet(MV_UNIT_ID unit);
MV_STATUS mvCtrlEnvInit(MV_VOID);
MV_U32    mvCtrlMppRegGet(MV_U32 mppGroup);
#ifdef MY_ABC_HERE
MV_32 mvCtrlGetJuncTemp(MV_VOID);
#else
MV_U32 mvCtrlGetJuncTemp(MV_VOID);
#endif
MV_STATUS mvEthComplexInit(MV_U32 ethCompConfig);
void mvCtrlNandClkSet(int nClock);
MV_U32 mvCtrlLaneSelectorGet(MV_U32 laneNum);
#if defined(MV_INCLUDE_PEX)
MV_U32 mvCtrlPexMaxIfGet(MV_VOID);
MV_U32 mvCtrlPexMaxUnitGet(MV_VOID);
#else
#define mvCtrlPciMaxIfGet()             1
#endif
MV_U32 mvCtrlPexActiveUnitNumGet(MV_VOID);

#if defined(MV_INCLUDE_PCI)
#define mvCtrlPciIfMaxIfGet()           1
#else
#define mvCtrlPciIfMaxIfGet()           (mvCtrlPexMaxIfGet())
#endif

MV_U32 mvCtrlEthMaxPortGet(MV_VOID);
MV_U32 mvCtrlSataMaxPortGet(MV_VOID);
#if defined(MV_INCLUDE_XOR)
MV_U32 mvCtrlXorMaxChanGet(MV_VOID);
MV_U32 mvCtrlXorMaxUnitGet(MV_VOID);
#endif
#if defined(MV_INCLUDE_USB)
MV_U32 mvCtrlUsbMaxGet(MV_VOID);
MV_U32 mvCtrlUsb3MaxGet(MV_VOID);
#endif
#if defined(MV_INCLUDE_SDIO)
MV_U32 mvCtrlSdioSupport(MV_VOID);
#endif
MV_U32 mvCtrlTdmSupport(MV_VOID);
MV_U32 mvCtrlTdmMaxGet(MV_VOID);
MV_TDM_UNIT_TYPE mvCtrlTdmUnitTypeGet(MV_VOID);
MV_U32 mvCtrlTdmUnitIrqGet(MV_VOID);
MV_U32 mvCtrlDevFamilyIdGet(MV_U16 ctrlModel);
MV_U16 mvCtrlModelGet(MV_VOID);
MV_U8 mvCtrlRevGet(MV_VOID);
MV_STATUS mvCtrlNameGet(char *pNameBuff);
MV_U32 mvCtrlModelRevGet(MV_VOID);
MV_VOID mvCtrlModelRevNameGet(char *pNameBuff);
MV_VOID mvCtrlAddrDecShow(MV_VOID);
const MV_8 *mvCtrlTargetNameGet(MV_TARGET target);
MV_U32    ctrlSizeToReg(MV_U32 size, MV_U32 alignment);
MV_U32    ctrlRegToSize(MV_U32 regSize, MV_U32 alignment);
MV_U32    ctrlSizeRegRoundUp(MV_U32 size, MV_U32 alignment);
MV_U32 mvCtrlSysRstLengthCounterGet(MV_VOID);
MV_STATUS ctrlWinOverlapTest(MV_ADDR_WIN *pAddrWin1, MV_ADDR_WIN *pAddrWin2);
MV_STATUS ctrlWinWithinWinTest(MV_ADDR_WIN *pAddrWin1, MV_ADDR_WIN *pAddrWin2);
MV_VOID mvCtrlSmiMasterSet(MV_SMI_CTRL smiCtrl);
MV_VOID mvCtrlPwrClckSet(MV_UNIT_ID unitId, MV_U32 index, MV_BOOL enable);
MV_BOOL mvCtrlPwrClckGet(MV_UNIT_ID unitId, MV_U32 index);
MV_BOOL mvCtrlIsBootFromNOR(MV_VOID);
MV_BOOL mvCtrlIsBootFromSPI(MV_VOID);
MV_BOOL mvCtrlIsBootFromNAND(MV_VOID);
MV_BOOL mvCtrlIsDLBEnabled(MV_VOID);
MV_U32 mvCtrlDDRBudWidth(MV_VOID);
MV_BOOL mvCtrlDDRThruXbar(MV_VOID);
MV_BOOL mvCtrlDDRECC(MV_VOID);

#define MV_SAR_INFO { \
{ MV_SATR_CPU_DDR_L2_FREQ,	 0x003E0000,	17,	1, {1} },\
{ MV_SATR_CORE_CLK_SELECT,	 0x00400000,	22,	1, {1} },\
{ MV_SATR_CPU1_ENABLE,		 0x00008000,	15,	0, {1} },\
{ MV_SATR_SSCG_DISABLE,		 0x00000002,	1,	0, {1} },\
{ MV_SATR_DDR_BUS_WIDTH,	 0x00000001,	0,	0, {1} },\
{ MV_SATR_I2C0_SERIAL_ROM,	 0X00000001,	0,	0, {1} },\
{ MV_SATR_EXTERNAL_CPU_RESET,	 0X00000000,	0,	0, {1} },\
{ MV_SATR_EXTERNAL_CORE_RESET,	 0X00000000,	0,	0, {1} },\
{ MV_SATR_BOOT_DEVICE,		 0X000001F8,	3,	0, {1} },\
{ MV_SATR_CPU_PLL_XTAL_BYPASS,	 0x00000200,	9,	0, {1} },\
{ MV_SATR_PEX0_CLOCK,		 0x00000400,	10,	0, {1} },\
{ MV_SATR_PEX1_CLOCK,		 0x00000800,	11,	0, {1} },\
{ MV_SATR_REF_CLOCK_ENABLE,	 0x00000004,	2,	0, {1} },\
{ MV_SATR_TESTER_OPTIONS,	 0x00080000,	19,	0, {1} },\
{ MV_SATR_CPU0_ENDIANESS,	 0x00001000,	12,	0, {1} },\
{ MV_SATR_CPU0_NMFI,		 0x00002000,	13,	0, {1} },\
{ MV_SATR_CPU0_THUMB,		 0x00004000,	14,	0, {1} },\
{ MV_SATR_EFUSE_BYPASS,		 0x00020000,	17,	0, {1} },\
{ MV_SATR_POR_BYPASS,		 0x00100000,	20,	0, {1} },\
{ MV_SATR_BOARD_ID,		 0x000000F0,	4,	1, {1} },\
{ MV_SATR_WRITE_CPU_FREQ,	 0X0000001F,	0,	0, {1} },\
{ MV_SATR_WRITE_CORE_CLK_SELECT, 0x00000001,	0,	1, {1} },\
{ MV_SATR_WRITE_CPU1_ENABLE,	 0x00000002,	1,	1, {1} },\
{ MV_SATR_WRITE_SSCG_DISABLE,	 0x00000004,	2,	1, {1} },\
{ MV_SATR_WRITE_DDR_BUS_WIDTH,	 0x00000001,	0,	0, {1} },\
};

#endif  
