#ifndef MY_ABC_HERE
#define MY_ABC_HERE
#endif
 
#ifndef __INCmvBoardEnvSpech
#define __INCmvBoardEnvSpech

#include "mvSysHwConfig.h"

#define BD_ID_DATA_START_OFFS			0x0
#define BD_DETECT_SEQ_OFFS				0x0
#define BD_SYS_NUM_OFFS					0x4
#define BD_NAME_OFFS					0x8

#define MV_BOARD_DIMM0_I2C_ADDR			0x56
#define MV_BOARD_DIMM0_I2C_ADDR_TYPE 	ADDR7_BIT
#define MV_BOARD_DIMM_I2C_CHANNEL		0x0

#define BOARD_ID_BASE			0x0
#if defined(MY_DEF_HERE)
#define BOARD_ID_MAX_RESERVED	0xF
#endif

#define DB_88F6710_BP_ID		(BOARD_ID_BASE)
#define DB_88F6710_PCAC_ID		(DB_88F6710_BP_ID + 1)
#define RD_88F6710_ID                   (DB_88F6710_PCAC_ID + 1)

#if defined(MY_DEF_HERE)

#define LAST_MV_BOARD_ID	RD_88F6710_ID
#if LAST_MV_BOARD_ID > BOARD_ID_MAX_RESERVED
#error "please check board id setting!"
#endif

#define SYNO_DS213j_ID			(BOARD_ID_MAX_RESERVED + 1)
#define SYNO_US3_ID			(SYNO_DS213j_ID + 1)
#define SYNO_RS214_ID			(SYNO_US3_ID + 1)
#define SYNO_DS214se_ID			(SYNO_RS214_ID + 1)
#define SYNO_DS414slim_ID			(SYNO_DS214se_ID + 1)
#define SYNO_DS115j_ID			(SYNO_DS414slim_ID + 1)
#define SYNO_DS216se_ID			(SYNO_DS115j_ID + 1)
#define MV_MAX_BOARD_ID			(SYNO_DS216se_ID + 1)

#else  
#define MV_MAX_BOARD_ID			(RD_88F6710_ID + 1)
#endif  
#define INVALID_BAORD_ID			0xFFFFFFFF

#ifdef MY_DEF_HERE
 
#define SYNO_DS213j_MPP0_7		0x00011111
#define SYNO_DS213j_MPP8_15		0x00000000
#define SYNO_DS213j_MPP16_23		0x00000110
#define SYNO_DS213j_MPP24_31		0x00000000
#define SYNO_DS213j_MPP32_39		0x00022220
#define SYNO_DS213j_MPP40_47		0x00000220

#ifdef MV_INCLUDE_NOR
#define SYNO_DS213j_MPP48_55		0x00000004
#define SYNO_DS213j_MPP56_63		0x00030000
#else
#define SYNO_DS213j_MPP48_55		0x00000004
#define SYNO_DS213j_MPP56_63		0x00030000
#endif

#define SYNO_DS213j_MPP64_67		0x00000000

#define SYNO_DS213j_GPP_OUT_ENA_LOW		(~(BIT31))
#define SYNO_DS213j_GPP_OUT_ENA_MID		(~(BIT0|BIT5|BIT16|BIT28|BIT30|BIT31))
#define SYNO_DS213j_GPP_OUT_ENA_HIGH		(~(BIT0|BIT1))

#define SYNO_DS213j_GPP_OUT_VAL_LOW		0x0
#define SYNO_DS213j_GPP_OUT_VAL_MID		0x0
#define SYNO_DS213j_GPP_OUT_VAL_HIGH		0x0

#define SYNO_DS213j_GPP_POL_LOW			0x0
#define SYNO_DS213j_GPP_POL_MID			0x0
#define SYNO_DS213j_GPP_POL_HIGH			0x0

#define SYNO_DS214se_MPP0_7			0x11111111
#define SYNO_DS214se_MPP8_15			0x11111111
#define SYNO_DS214se_MPP16_23        0x00000111
#define SYNO_DS214se_MPP24_31		0x00000000
#define SYNO_DS214se_MPP32_39		0x00022220
#define SYNO_DS214se_MPP40_47		0x00000220
#define SYNO_DS214se_MPP48_55		0x00000004
#define SYNO_DS214se_MPP56_63		0x00030000
#define SYNO_DS214se_MPP64_67		0x00000000

#define SYNO_DS214se_GPP_OUT_ENA_LOW		(~(BIT31))
#define SYNO_DS214se_GPP_OUT_ENA_MID		(~(BIT0|BIT5|BIT16|BIT28|BIT30|BIT31))
#define SYNO_DS214se_GPP_OUT_ENA_HIGH		(~(BIT0|BIT1))

#define SYNO_DS214se_GPP_OUT_VAL_LOW		0x0
#define SYNO_DS214se_GPP_OUT_VAL_MID		BIT5
#define SYNO_DS214se_GPP_OUT_VAL_HIGH		0x0

#define SYNO_DS214se_GPP_POL_LOW			0x0
#define SYNO_DS214se_GPP_POL_MID			0x0
#define SYNO_DS214se_GPP_POL_HIGH			0x0

#define SYNO_US3_MPP0_7		0x11110011
#define SYNO_US3_MPP8_15		0x11111111
#define SYNO_US3_MPP16_23		0x22222111
#define SYNO_US3_MPP24_31		0x02222222
#define SYNO_US3_MPP32_39		0x00000001
#define SYNO_US3_MPP40_47		0x30000000
#define SYNO_US3_MPP48_55		0x00033333
#define SYNO_US3_MPP56_63		0x10000000
#define SYNO_US3_MPP64_67		0x00000011

#define SYNO_US3_GPP_OUT_ENA_LOW		(~(0x0))
#define SYNO_US3_GPP_OUT_ENA_MID		(~(BIT8|BIT10|BIT11|BIT13|BIT28))
#define SYNO_US3_GPP_OUT_ENA_HIGH		(~(0x0))

#define SYNO_US3_GPP_OUT_VAL_LOW		0x0
#define SYNO_US3_GPP_OUT_VAL_MID		(BIT11|BIT28)
#define SYNO_US3_GPP_OUT_VAL_HIGH		0x0

#define SYNO_US3_GPP_POL_LOW			0x0
#define SYNO_US3_GPP_POL_MID			0x0
#define SYNO_US3_GPP_POL_HIGH			0x0

#define SYNO_RS214_MPP0_7               0x11111111
#define SYNO_RS214_MPP8_15              0x11111111
#define SYNO_RS214_MPP16_23             0x22222111
#define SYNO_RS214_MPP24_31             0x02222222
#define SYNO_RS214_MPP32_39             0x00022220
#define SYNO_RS214_MPP40_47             0x00000220
#define SYNO_RS214_MPP48_55             0x00000004
#define SYNO_RS214_MPP56_63             0x00030000
#define SYNO_RS214_MPP64_67             0x00000000

#define SYNO_RS214_GPP_OUT_ENA_LOW              0x0
#define SYNO_RS214_GPP_OUT_ENA_MID              (~(BIT0|BIT16|BIT17|BIT28|BIT31))
#define SYNO_RS214_GPP_OUT_ENA_HIGH             (~(BIT0|BIT1))

#define SYNO_RS214_GPP_OUT_VAL_LOW              0x0
#define SYNO_RS214_GPP_OUT_VAL_MID              0x0
#define SYNO_RS214_GPP_OUT_VAL_HIGH             0x0

#define SYNO_RS214_GPP_POL_LOW                  0x0
#define SYNO_RS214_GPP_POL_MID                  0x0
#define SYNO_RS214_GPP_POL_HIGH                 0x0

#define SYNO_DS414slim_MPP0_7          0x11111111
#define SYNO_DS414slim_MPP8_15         0x11111111
#define SYNO_DS414slim_MPP16_23        0x22222111
#define SYNO_DS414slim_MPP24_31        0x02222222
#define SYNO_DS414slim_MPP32_39        0x00022220
#define SYNO_DS414slim_MPP40_47        0x00000220
#define SYNO_DS414slim_MPP48_55        0x00000004
#define SYNO_DS414slim_MPP56_63        0x00000000
#define SYNO_DS414slim_MPP64_67        0x00000000

#define SYNO_DS414slim_GPP_OUT_ENA_LOW        (~(0x0))
#define SYNO_DS414slim_GPP_OUT_ENA_MID        (~(BIT31))
#define SYNO_DS414slim_GPP_OUT_ENA_HIGH       (~(BIT0|BIT1))

#define SYNO_DS414slim_GPP_OUT_VAL_LOW        0x0
#define SYNO_DS414slim_GPP_OUT_VAL_MID        0x0
#define SYNO_DS414slim_GPP_OUT_VAL_HIGH       0x0

#define SYNO_DS414slim_GPP_POL_LOW            0x0
#define SYNO_DS414slim_GPP_POL_MID            0x0
#define SYNO_DS414slim_GPP_POL_HIGH           0x0

#define SYNO_DS115j_MPP0_7          0x11111111
#define SYNO_DS115j_MPP8_15         0x11111111
#define SYNO_DS115j_MPP16_23        0x00000111
#define SYNO_DS115j_MPP24_31        0x00000000
#define SYNO_DS115j_MPP32_39        0x00022220
#define SYNO_DS115j_MPP40_47        0x00000220
#define SYNO_DS115j_MPP48_55        0x00000000
#define SYNO_DS115j_MPP56_63        0x00030000
#define SYNO_DS115j_MPP64_67        0x00000000

#define SYNO_DS115j_GPP_OUT_ENA_LOW     (~(BIT31))
#define SYNO_DS115j_GPP_OUT_ENA_MID     (~(BIT5|BIT16|BIT28|BIT31))
#define SYNO_DS115j_GPP_OUT_ENA_HIGH    (~(BIT0|BIT1))

#define SYNO_DS115j_GPP_OUT_VAL_LOW     0x0
#define SYNO_DS115j_GPP_OUT_VAL_MID     (BIT5|BIT12)
#define SYNO_DS115j_GPP_OUT_VAL_HIGH    0x0

#define SYNO_DS115j_GPP_POL_LOW         0x0
#define SYNO_DS115j_GPP_POL_MID         0x0
#define SYNO_DS115j_GPP_POL_HIGH        0x0

#define SYNO_DS216se_MPP0_7			0x11111111
#define SYNO_DS216se_MPP8_15			0x11111111
#define SYNO_DS216se_MPP16_23        0x00000111
#define SYNO_DS216se_MPP24_31		0x00000000
#define SYNO_DS216se_MPP32_39		0x00022220
#define SYNO_DS216se_MPP40_47		0x00000220
#define SYNO_DS216se_MPP48_55		0x00000004
#define SYNO_DS216se_MPP56_63		0x00030000
#define SYNO_DS216se_MPP64_67		0x00000000

#define SYNO_DS216se_GPP_OUT_ENA_LOW		(~(BIT31))
#define SYNO_DS216se_GPP_OUT_ENA_MID		(~(BIT0|BIT5|BIT16|BIT28|BIT30|BIT31))
#define SYNO_DS216se_GPP_OUT_ENA_HIGH		(~(BIT0|BIT1))

#define SYNO_DS216se_GPP_OUT_VAL_LOW		0x0
#define SYNO_DS216se_GPP_OUT_VAL_MID		BIT5
#define SYNO_DS216se_GPP_OUT_VAL_HIGH		0x0

#define SYNO_DS216se_GPP_POL_LOW			0x0
#define SYNO_DS216se_GPP_POL_MID			0x0
#define SYNO_DS216se_GPP_POL_HIGH			0x0

#define GPIO_UNDEF 0xFF

#endif  

#define DB_88F6710_MPP0_7		0x11111111
#define DB_88F6710_MPP8_15		0x11111111
#define DB_88F6710_MPP16_23		0x22222111
#define DB_88F6710_MPP24_31		0x02222222
#define DB_88F6710_MPP32_39		0x11111111
#define DB_88F6710_MPP40_47		0x11111111

#ifdef MV_INCLUDE_NOR
#define DB_88F6710_MPP48_55		0x41111111
#define DB_88F6710_MPP56_63		0x11111140
#else
#define DB_88F6710_MPP48_55		0x41111110
#define DB_88F6710_MPP56_63		0x11000140
#endif

#define DB_88F6710_MPP64_67		0x00000011

#define DB_88F6710_GPP_OUT_ENA_LOW		(~(0x0))
#define DB_88F6710_GPP_OUT_ENA_MID		(~(BIT27 | BIT28 | BIT29))
#define DB_88F6710_GPP_OUT_ENA_HIGH		(~(0x0))

#define DB_88F6710_GPP_OUT_VAL_LOW		0x0
#define DB_88F6710_GPP_OUT_VAL_MID		0x0
#define DB_88F6710_GPP_OUT_VAL_HIGH		0x0

#define DB_88F6710_GPP_POL_LOW			0x0
#define DB_88F6710_GPP_POL_MID			0x0
#define DB_88F6710_GPP_POL_HIGH			0x0

#define DB_88F6710_PCAC_MPP0_7			0x00001111
#define DB_88F6710_PCAC_MPP8_15			0x00000000
#define DB_88F6710_PCAC_MPP16_23		0x00000110
#define DB_88F6710_PCAC_MPP24_31		0x10000000
#define DB_88F6710_PCAC_MPP32_39		0x11111111
#define DB_88F6710_PCAC_MPP40_47		0x01111111
#define DB_88F6710_PCAC_MPP48_55		0x00000000
#define DB_88F6710_PCAC_MPP56_63		0x14040000
#define DB_88F6710_PCAC_MPP64_67		0x00000011

#define DB_88F6710_PCAC_GPP_OUT_ENA_LOW		(~(0x0))
#define DB_88F6710_PCAC_GPP_OUT_ENA_MID		(~(BIT26 | BIT27 | BIT29))
#define DB_88F6710_PCAC_GPP_OUT_ENA_HIGH	(~(0x0))

#define DB_88F6710_PCAC_GPP_OUT_VAL_LOW		0x0
#define DB_88F6710_PCAC_GPP_OUT_VAL_MID		0x0
#define DB_88F6710_PCAC_GPP_OUT_VAL_HIGH	0x0

#define DB_88F6710_PCAC_GPP_POL_LOW			0x0
#define DB_88F6710_PCAC_GPP_POL_MID			0x0
#define DB_88F6710_PCAC_GPP_POL_HIGH		0x0

#define RD_88F6710_MPP0_7         0x00011111
#define RD_88F6710_MPP8_15        0x33333030
#define RD_88F6710_MPP16_23       0x22222110
#define RD_88F6710_MPP24_31       0x02222222
#define RD_88F6710_MPP32_39       0x11111110
#define RD_88F6710_MPP40_47       0x01111111
#define RD_88F6710_MPP48_55       0x33344444
#define RD_88F6710_MPP56_63       0x03555556
#define RD_88F6710_MPP64_67       0x00000000

#define RD_88F6710_GPP_OUT_ENA_LOW	(~(BIT5 | BIT8))
#define RD_88F6710_GPP_OUT_ENA_MID	(~(BIT0 | BIT15 | BIT31))
#define RD_88F6710_GPP_OUT_ENA_HIGH	(~(BIT0 | BIT1))

#define RD_88F6710_GPP_OUT_VAL_LOW	(BIT5 | BIT8)
#define RD_88F6710_GPP_OUT_VAL_MID	0x0
#define RD_88F6710_GPP_OUT_VAL_HIGH	0x0

#define RD_88F6710_GPP_POL_LOW		BIT31
#define RD_88F6710_GPP_POL_MID		0x0
#define RD_88F6710_GPP_POL_HIGH		0x0

#endif  
