#ifndef MY_ABC_HERE
#define MY_ABC_HERE
#endif
 
#ifndef __ASM_PROCFNS_H
#define __ASM_PROCFNS_H

#ifdef __KERNEL__

#include <asm/glue-proc.h>
#include <asm/page.h>

#ifndef __ASSEMBLY__

struct mm_struct;

extern struct processor {
	 
	void (*_data_abort)(unsigned long pc);
	 
	unsigned long (*_prefetch_abort)(unsigned long lr);
	 
	void (*_proc_init)(void);
	 
	void (*_proc_fin)(void);
	 
	void (*reset)(unsigned long addr) __attribute__((noreturn));
	 
	int (*_do_idle)(void);
	 
	void (*dcache_clean_area)(void *addr, int size);

	void (*switch_mm)(unsigned long pgd_phys, struct mm_struct *mm);
	 
#if (defined(MY_DEF_HERE) || defined(MY_ABC_HERE)) && defined(CONFIG_ARM_LPAE)
	void (*set_pte_ext)(pte_t *ptep, pte_t pte);
#elif defined(MY_DEF_HERE) && defined(CONFIG_ARM_LPAE)
	void (*set_pte_ext)(pte_t *ptep, pte_t pte);
#elif defined(MY_DEF_HERE)
	void (*set_pte_ext)(pte_t *ptep, pteval_t pte, unsigned int ext);
#else
	void (*set_pte_ext)(pte_t *ptep, pte_t pte, unsigned int ext);
#endif

	unsigned int suspend_size;
	void (*do_suspend)(void *);
	void (*do_resume)(void *);
} processor;

#ifndef MULTI_CPU
extern void cpu_proc_init(void);
extern void cpu_proc_fin(void);
extern int cpu_do_idle(void);
extern void cpu_dcache_clean_area(void *, int);
extern void cpu_do_switch_mm(unsigned long pgd_phys, struct mm_struct *mm);
#if (defined(MY_DEF_HERE) || defined(MY_ABC_HERE)) && defined(CONFIG_ARM_LPAE)
extern void cpu_set_pte_ext(pte_t *ptep, pte_t pte);
#elif defined(MY_DEF_HERE) && defined(CONFIG_ARM_LPAE)
extern void cpu_set_pte_ext(pte_t *ptep, pte_t pte);
#elif defined(MY_DEF_HERE)
extern void cpu_set_pte_ext(pte_t *ptep, pteval_t pte, unsigned int ext);
extern void cpu_uncache_pte_ext(pte_t *ptep);
#else
extern void cpu_set_pte_ext(pte_t *ptep, pte_t pte, unsigned int ext);
#endif
extern void cpu_reset(unsigned long addr) __attribute__((noreturn));

extern void cpu_do_suspend(void *);
extern void cpu_do_resume(void *);
#else
#define cpu_proc_init			processor._proc_init
#define cpu_proc_fin			processor._proc_fin
#define cpu_reset			processor.reset
#define cpu_do_idle			processor._do_idle
#define cpu_dcache_clean_area		processor.dcache_clean_area
#define cpu_set_pte_ext			processor.set_pte_ext
#if defined(MY_DEF_HERE)
#define cpu_uncache_pte_ext		processor.uncache_pte_ext
#endif
#define cpu_do_switch_mm		processor.switch_mm

#define cpu_do_suspend			processor.do_suspend
#define cpu_do_resume			processor.do_resume
#endif

extern void cpu_resume(void);

#include <asm/memory.h>

#ifdef CONFIG_MMU

#if (defined(MY_DEF_HERE) || defined(MY_ABC_HERE)) && defined(CONFIG_SMP)

#define cpu_switch_mm(pgd,mm)	\
	({						\
		unsigned long flags;			\
		local_irq_save(flags);			\
		cpu_do_switch_mm(virt_to_phys(pgd),mm);	\
		local_irq_restore(flags);		\
	})

#else  

#define cpu_switch_mm(pgd,mm) cpu_do_switch_mm(virt_to_phys(pgd),mm)

#endif

#if (defined(MY_DEF_HERE) || defined(MY_ABC_HERE) || defined(MY_DEF_HERE)) && defined(CONFIG_ARM_LPAE)
#define cpu_get_pgd()  \
       ({                                              \
               unsigned long pg, pg2;                  \
               __asm__("mrrc   p15, 0, %0, %1, c2"     \
                       : "=r" (pg), "=r" (pg2)         \
                       :                               \
                       : "cc");                        \
               pg &= ~(PTRS_PER_PGD*sizeof(pgd_t)-1);  \
               (pgd_t *)phys_to_virt(pg);              \
       })
#else
#define cpu_get_pgd()	\
	({						\
		unsigned long pg;			\
		__asm__("mrc	p15, 0, %0, c2, c0, 0"	\
			 : "=r" (pg) : : "cc");		\
		pg &= ~0x3fff;				\
		(pgd_t *)phys_to_virt(pg);		\
	})

#endif
#endif

#endif  
#endif  
#endif  
