#ifndef MY_ABC_HERE
#define MY_ABC_HERE
#endif
#ifndef _ARM_KEXEC_H
#define _ARM_KEXEC_H

#ifdef CONFIG_KEXEC

#define KEXEC_SOURCE_MEMORY_LIMIT (-1UL)
 
#define KEXEC_DESTINATION_MEMORY_LIMIT (-1UL)
 
#define KEXEC_CONTROL_MEMORY_LIMIT (-1UL)

#if defined(MY_DEF_HERE)
#define KEXEC_CONTROL_PAGE_SIZE	(PAGE_SIZE)
#else
#define KEXEC_CONTROL_PAGE_SIZE	4096
#endif

#define KEXEC_ARCH KEXEC_ARCH_ARM

#define KEXEC_ARM_ATAGS_OFFSET  0x1000
#define KEXEC_ARM_ZIMAGE_OFFSET 0x8000

#ifndef __ASSEMBLY__

static inline void crash_setup_regs(struct pt_regs *newregs,
				    struct pt_regs *oldregs)
{
	if (oldregs) {
		memcpy(newregs, oldregs, sizeof(*newregs));
	} else {
		__asm__ __volatile__ (
			"stmia	%[regs_base], {r0-r12}\n\t"
			"mov	%[_ARM_sp], sp\n\t"
			"str	lr, %[_ARM_lr]\n\t"
			"adr	%[_ARM_pc], 1f\n\t"
			"mrs	%[_ARM_cpsr], cpsr\n\t"
		"1:"
			: [_ARM_pc] "=r" (newregs->ARM_pc),
			  [_ARM_cpsr] "=r" (newregs->ARM_cpsr),
			  [_ARM_sp] "=r" (newregs->ARM_sp),
			  [_ARM_lr] "=o" (newregs->ARM_lr)
			: [regs_base] "r" (&newregs->ARM_r0)
			: "memory"
		);
	}
}

extern void (*kexec_reinit)(void);

#endif  

#endif  

#endif  
