/*
 * Multiline4ch_8ch_PW2_4.c --
 *
 * This file contains profile data in byte format
 *
 * Project Info --
 *   Type:   Design for ZLR88601 4 to 8 Line, Multiline, Lite Coefficients
 *   Date:   Thursday, August 08, 2013 10:08:23
 *   Device: ZL880 ZL88601
 *
 *   This file was generated with Profile Wizard Version: P2.4.0
 *
 * Project Comments --
 *  ----------------------------------------------------------------------------------------------------------------------------------
 *  Profile Wizard Coefficient Revision 2.9 Release Notes:
 *  ----------------------------------------------------------------------------------------------------------------------------------
 *  I. General:
 *  1. This is the second release of the ZL88601 worldwide coefficients.
 *  2. This release includes support for the following 44 countries:
 *  Argentina (AR), Austria (AT), Australia (AU), Belgium (BE), Brazil (BR), Bulgaria (BG), Canada (CA), Switzerland (CH),
 *  Chile (CL), China (CN), Czech Republic (CZ), Germany (DE), Denmark (DK), Ecuador (EC), Spain (ES), Finland (FI),
 *  France (FR), UK (GB), Greece (GR), Hong Kong SAR China (HK), Hungary (HU), Indonesia (ID), Ireland (IE), Israel (IL),
 *  India (IN), Iceland (IS), Italy (IT), Japan (JP), S. Korea (KR), Mexico (MX), Malaysia (MY), Netherlands (NL),
 *  Norway (NO), New Zealand (NZ), Poland (PL), Portugal (PT), Russian Federation (RU), Sweden (SE), Singapore (SG),
 *  Thailand (TH), Turkey (TK), Taiwan (TW), USA (US), and South Africa (ZA).
 *  2. The coefficients in this and all releases are provided for use only with the Microsemi VoicePath API-II (VP-API-II). Please refer
 *  to the terms and conditions for licensing the software regarding terms and conditions of usage. These profiles are provided for
 *  reference only with no guarantee whatsoever by Microsemi Corporation.
 *  3. This release is for the ZLR88621L SM2 Line Module based on the ZL88601 and for the ZLR88621H Line Module set for a VBATH = -81V.
 *
 *  II. Device Profile:
 *  1. The default settings for the Device Profile are:
 *         PCLK = 8192 kHz
 *         PCM Transmit Edge = Positive
 *         Transmit Time Slot = 0
 *         Receive Time Slot = 0
 *         Interrupt Mode = Open Drain
 *         Switching Regulator Y Control Mode = Single
 *         Switching Regulator Y Voltage = 27V
 *         Switching Regulator Z Control Mode = Single
 *         Switching Regulator Z Voltage = 81V
 *         IO21 Pin Mode = Digital
 *         IO22 Pin Mode = Analog Voltage Sense
 *
 *  2. The settings may be changed by the user as necessary.  Please refer to the ZL880 and VP-API-II documentation for information
 *  about the supported settings.
 *
 *  II. DC Profiles:
 *  1. The DC_FXS_ZL880_ABS100V_DEF Profile is the default unless a country specific profile is selected. Example DC profile settings are
 *  provided for China, ETSI and the USA.
 *
 *  III. AC Profiles:
 *  1. FXS Coefficients assume -6dBr RX (Output from chipset) and 0dB TX relative gain levels.
 *  2. Supported countries not individually listed should use the default 600R profile AC_FXS_RF14_600R_DEF.
 *  4. AC FXS Coefficients assume the use of two 7 ohm series resistors or PTCs. Customers using other PTC resistance values (such as
 *  25ohms or 50 ohms) should not use these AC coefficients and can request alternate ones from Microsemi.
 *  5. This release includes both Narrowband and Wideband coefficients. Note that the ZL880 Series devices support per channel Narrowband or
 *  Wideband audio selection.
 *
 *  IV. Ring Profiles:
 *  1. RING_ZL880_ABS100V_DEF is the default ringing profile and should be used for all countries which do not have a listed ringing profile.
 *  The default ringing profile is set for a sine wave ringing with an amplitude of 50Vrms (70.7Vpk)with no DC bias and a frequency of 25 Hz
 *  generated by fixed (non-tracking) supply.
 *  2. Most ringing profiles on the list are sinusoidal with an amplitude of 50Vrms with no DC bias generated by fixed (non-tracking) supply.
 *  3. The ringing definitions may be changed based on the requirements of the target market as long as the total amplitude (AC + DC
 *  components) does not exceed the limits set forth in the ZL88601/602 data sheet.
 *
 *  V. Tone Profiles:
 *  1. These profiles are available only in the full version of the VP-API-II.
 *
 *  VI. Cadence Profiles:
 *  1. These profiles are available only in the full version of the VP-API-II.
 *
 *  VII. Caller ID Profiles:
 *  1. These profiles are available only in the full version of the VP-API-II.
 *
 *  VIII. Metering Profiles:
 *  1. These profiles are available only in the full version of the VP-API-II.
 *
 *  (c) Copyright 2012 Microsemi Corporation. All rights reserved.
 *
 *  -----------------------------------------------------------------------------------------------------------------------------------------------------
 */

#include "profile_88601.h"

/************** Device_Parameters **************/

/* Device Configuration Data - ZL88601 100V ABS (-90V/-30V) Master */
const VpProfileDataType ZLR88621L_ABS90V_OC_DEVICE[] = {
/* Profile Header ---------------------------------------------------------- */
	0x0C, 0xFF, 0x00,       /* Device Profile for ZL88601 device */
	0x29,                   /* Profile length = 41 + 4 = 45 bytes */
	0x03,                   /* Profile format version = 3 */
	0x14,                   /* MPI section length = 20 bytes */
/* Raw MPI Section --------------------------------------------------------- */
	0x46, 0x8A,             /* PCLK = 8.192 MHz; INTM = Open Drain */
	0x44, 0x00,             /* PCM Clock Slot = 0 TX / 0 RX; XE = Neg. */
	0x5E, 0x14, 0x04,       /* Device Mode Register */
	0xF6, 0xB1, 0x00, 0xB1, /* Switching Regulator Timing Params */
	0x00, 0xB0, 0x40,
	0xE4, 0x05, 0xA0, 0x00, /* Switching Regulator Params */
	0xE6, 0x00,             /* Switching Regulator Control */
/* Formatted Parameters Section -------------------------------------------- */
	0x20,                   /* IO21 Mode: Digital */
				/* IO22 Mode: Analog Voltage Sense */
	0x01,                   /* Dial pulse correction: 0 ms */
				/* Switcher Configuration = Multiline ABS 4/8 Line */
	0x00, 0xFF,             /* Over-current shutdown count = 255 */
	0xA1,                   /* Leading edge blanking window = 81 ns */
				/* ABS supply config: 1 = Master; 2 = Slave */
	0x2C, 0x40, 0x2C, 0x40, /* Free-Run Timing Parameters */
	0x2C, 0x40,
	0x1E,                   /* Switcher 1 Voltage = 30 V */
	0x5A,                   /* Switcher 2 Voltage = 90 V */
	0xFF,
	0xB1, 0x00,             /* Low-Power Timing Parameters */
	0x20, 0x6E,             /* Switcher Limit Voltages 32 V, 110 V */
	0x03                    /* Charge pump enabled */
				/* Charge Pump Overload Protection: Switcher Cycle Skip */
};

/************** DC_Parameters **************/

/* DC FXS Defaults - Use for all countries unless country file exists - 23mA Current Feed */
const VpProfileDataType DC_FXS_ZL880_ABS100V_DEF[] =
{
/* Profile Header ---------------------------------------------------------- */
   0x0C, 0x01, 0x00,       /* DC Profile for ZL88601 device */
   0x0B,                   /* Profile length = 11 + 4 = 15 bytes */
   0x02,                   /* Profile format version = 2 */
   0x03,                   /* MPI section length = 3 bytes */
/* Raw MPI Section --------------------------------------------------------- */
   0xC6, 0x91, 0xE5,       /* DC Feed Parameters: ir_overhead = 100 ohm; */
                           /* VOC = 48 V; LI = 50 ohm; ILA = 23 mA */
                           /* Battery Switch Offset Voltage = 4.02 V */
/* Formatted Parameters Section -------------------------------------------- */
   0x1C,                   /* Switch Hook Threshold = 11 mA */
                           /* Ground-Key Threshold = 18 mA */
   0x86,                   /* Switch Hook Debounce = 12 ms */
                           /* Ground-Key Debounce = 16 ms */
   0x58,                   /* Low-Power Switch Hook Hysteresis = 2 V */
                           /* Ground-Key Hysteresis = 6 mA */
                           /* Switch Hook Hysteresis = 2 mA */
   0x80,                   /* Low-Power Switch Hook Threshold = 22 V */
   0x00,                   /* R_OSP = 0 ohms */
   0x07                    /* R_ISP = 7 ohms */
};

/************** AC_Coefficients **************/

/* AC FXS RF14 600R Normal Coefficients (Default)  */
const VpProfileDataType AC_FXS_RF14_600R_DEF[] =
{
  /* AC Profile */
 0xA4, 0x00, 0xF4, 0x4C, 0x01, 0x49, 0xCA, 0xF5, 0x98, 0xAA, 0x7B, 0xAB,
 0x2C, 0xA3, 0x25, 0xA5, 0x24, 0xB2, 0x3D, 0x9A, 0x2A, 0xAA, 0xA6, 0x9F,
 0x01, 0x8A, 0x1D, 0x01, 0xA3, 0xA0, 0x2E, 0xB2, 0xB2, 0xBA, 0xAC, 0xA2,
 0xA6, 0xCB, 0x3B, 0x45, 0x88, 0x2A, 0x20, 0x3C, 0xBC, 0x4E, 0xA6, 0x2B,
 0xA5, 0x2B, 0x3E, 0xBA, 0x8F, 0x82, 0xA8, 0x71, 0x80, 0xA9, 0xF0, 0x50,
 0x00, 0x86, 0x2A, 0x42, 0xA1, 0xCB, 0x1B, 0xA3, 0xA8, 0xFB, 0x87, 0xAA,
 0xFB, 0x9F, 0xA9, 0xF0, 0x96, 0x2E, 0x01, 0x00
};

/************** Ring_Parameters **************/

/* Default Ringing 25Hz 50Vrms Fixed, AC Trip - Use for all countries unless country profile exists */
const VpProfileDataType RING_ZL880_ABS100V_DEF[] =
{
/* Profile Header ---------------------------------------------------------- */
   0x0C, 0x04, 0x00,       /* Ringing Profile for ZL88601 device */
   0x12,                   /* Profile length = 18 + 4 = 22 bytes */
   0x01,                   /* Profile format version = 1 */
   0x0C,                   /* MPI section length = 12 bytes */
/* Raw MPI Section --------------------------------------------------------- */
   0xC0, 0x08, 0x00, 0x00, /* Ringing Generator Parameters: */
         0x00, 0x44, 0x3A, /* 24.9 Hz Sine; 1.41 CF; 70.70 Vpk; 0.00 V bias */
         0x9D, 0x00, 0x00, /* Ring trip cycles = 1; RTHALFCYC = 0 */
         0x00, 0x00,
/* Formatted Parameters Section -------------------------------------------- */
   0xAA,                   /* Ring Trip Method = AC; Threshold = 21.0 mA */
   0x02,                   /* Ringing Current Limit = 54 mA */
   0x4E,                   /* Fixed; Max Ringing Supply = 75 V */
   0x00                    /* Balanced; Ring Cadence Control Disabled */
};

/************** Call_Progress_Tones **************/

/************** Cadence_Definitions **************/

/************** Caller_ID **************/

/************** Metering_Profile **************/

int dev_profile_size = sizeof(ZLR88621L_ABS90V_OC_DEVICE);
int dc_profile_size = sizeof(DC_FXS_ZL880_ABS100V_DEF);
int ac_profile_size = sizeof(AC_FXS_RF14_600R_DEF);
int ring_profile_size = sizeof(RING_ZL880_ABS100V_DEF);

/* end of file Multiline4ch_8ch_PW2_4.c */
