#ifndef __SND_ST_AUD_UNIPERIF_H
#define __SND_ST_AUD_UNIPERIF_H

#include <linux/platform_data/dma-st-fdma.h>

/*
 * Register access macros
 */

#define GET_UNIPERIF_REG(ip, offset, shift, mask) \
	((readl_relaxed(ip->base + offset) >> shift) & mask)
#define SET_UNIPERIF_REG(ip, offset, shift, mask, value) \
	writel_relaxed(((readl_relaxed(ip->base + offset) & \
	~(mask << shift)) | (((value) & mask) << shift)), ip->base + offset)
#define SET_UNIPERIF_BIT_REG(ip, offset, shift, mask, value) \
	writel_relaxed((((value) & mask) << shift), ip->base + offset)

/*
 * AUD_UNIPERIF_SOFT_RST
 */

#define OFFSET_UNIPERIF_SOFT_RST(ip) 0x0000
#define GET_UNIPERIF_SOFT_RST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		readl_relaxed(ip->base + OFFSET_UNIPERIF_SOFT_RST(ip)) : 0)
#define SET_UNIPERIF_SOFT_RST(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_SOFT_RST(ip))

/* SOFT_RST */
#define SHIFT_UNIPERIF_SOFT_RST_SOFT_RST(ip) 0x0
#define MASK_UNIPERIF_SOFT_RST_SOFT_RST(ip) 0x1
#define SET_UNIPERIF_SOFT_RST_SOFT_RST(ip) \
	SET_UNIPERIF_BIT_REG(ip, \
		OFFSET_UNIPERIF_SOFT_RST(ip), \
		SHIFT_UNIPERIF_SOFT_RST_SOFT_RST(ip), \
		MASK_UNIPERIF_SOFT_RST_SOFT_RST(ip), 1)
#define GET_UNIPERIF_SOFT_RST_SOFT_RST(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_SOFT_RST(ip), \
		SHIFT_UNIPERIF_SOFT_RST_SOFT_RST(ip), \
		MASK_UNIPERIF_SOFT_RST_SOFT_RST(ip))

/*
 * AUD_UNIPERIF_FIFO_DATA
 */

#define OFFSET_UNIPERIF_FIFO_DATA(ip) 0x0004
#define GET_UNIPERIF_FIFO_DATA(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_FIFO_DATA(ip))
#define SET_UNIPERIF_FIFO_DATA(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_FIFO_DATA(ip))

/*
 *  AUD_UNIPERIF_STA
 */

#define OFFSET_UNIPERIF_STA(ip) 0x0008
#define GET_UNIPERIF_STA(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_STA(ip))

/* SOFT_RESET_DONE */
#define SHIFT_UNIPERIF_STA_SOFT_RESET_DONE(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 0)
#define MASK_UNIPERIF_STA_SOFT_RESET_DONE(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << SHIFT_UNIPERIF_STA_SOFT_RESET_DONE(ip)))

/* FIFO_ERROR */
#define SHIFT_UNIPERIF_STA_FIFO_ERROR(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 0 : 8)
#define MASK_UNIPERIF_STA_FIFO_ERROR(ip) \
	(0x1 << SHIFT_UNIPERIF_STA_FIFO_ERROR(ip))

/* EODATABURST */
#define SHIFT_UNIPERIF_STA_EODATABURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 1 : -1)
#define MASK_UNIPERIF_STA_EODATABURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_STA_EODATABURST(ip)) : 0)

/* EOBLOCK */
#define SHIFT_UNIPERIF_STA_EOBLOCK(ip) 2
#define MASK_UNIPERIF_STA_EOBLOCK(ip) \
	(0x1 << SHIFT_UNIPERIF_STA_EOBLOCK(ip))

/* EOLATENCY */
#define SHIFT_UNIPERIF_STA_EOLATENCY(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 3 : -1)
#define MASK_UNIPERIF_STA_EOLATENCY(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_STA_EOLATENCY(ip)) : 0)

/* EOPD_DATABURST */
#define SHIFT_UNIPERIF_STA_EOPD_DATABURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 4 : -1)
#define MASK_UNIPERIF_STA_EOPD_DATABURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_STA_EOPD_DATABURST(ip)) : 0)

/* MEM_BLK_READ */
#define SHIFT_UNIPERIF_STA_MEM_BLK_READ(ip) 5
#define MASK_UNIPERIF_STA_MEM_BLK_READ(ip) \
	(0x1 << SHIFT_UNIPERIF_STA_MEM_BLK_READ(ip))

/* EOF_PAUSEBURST */
#define SHIFT_UNIPERIF_STA_EOF_PAUSEBURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 6 : -1)
#define MASK_UNIPERIF_STA_EOF_PAUSEBURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_STA_EOF_PAUSEBURST(ip)) : 0)

/* PA_PB_SYNC_LOST */
#define SHIFT_UNIPERIF_STA_PA_PB_SYNC_LOST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 7 : -1)
#define MASK_UNIPERIF_STA_PA_PB_SYNC_LOST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_STA_PA_PB_SYNC_LOST(ip)) : 0)

/* CHL_STS_BUFFER_EMPTY */
#define SHIFT_UNIPERIF_STA_CHL_STS_BUFFER_EMPTY(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 8 : 1)
#define MASK_UNIPERIF_STA_CHL_STS_BUFFER_EMPTY(ip) \
	(0x1 << SHIFT_UNIPERIF_STA_CHL_STS_BUFFER_EMPTY(ip))

/* DMA_ERROR */
#define SHIFT_UNIPERIF_STA_DMA_ERROR(ip) 9
#define MASK_UNIPERIF_STA_DMA_ERROR(ip) \
	(0x1 << SHIFT_UNIPERIF_STA_DMA_ERROR(ip))

/* RUNSTOP */
#define SHIFT_UNIPERIF_STA_RUNSTOP(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 10 : -1)
#define MASK_UNIPERIF_STA_RUNSTOP(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_STA_RUNSTOP(ip)) : 0)

/* RUN */
#define SHIFT_UNIPERIF_STA_RUN(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 10)
#define MASK_UNIPERIF_STA_RUN(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << SHIFT_UNIPERIF_STA_RUN(ip)))

/* STOPPED */
#define SHIFT_UNIPERIF_STA_STOPPED(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 11)
#define MASK_UNIPERIF_STA_STOPPED(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << SHIFT_UNIPERIF_STA_STOPPED(ip)))

/* UNDERFLOW_REC_DONE */
#define SHIFT_UNIPERIF_STA_UNDERFLOW_REC_DONE(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 12)
#define MASK_UNIPERIF_STA_UNDERFLOW_REC_DONE(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << SHIFT_UNIPERIF_STA_UNDERFLOW_REC_DONE(ip)))

/* UNDERFLOW_REC_FAILED */
#define SHIFT_UNIPERIF_STA_UNDERFLOW_REC_FAILED(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 13)
#define MASK_UNIPERIF_STA_UNDERFLOW_REC_FAILED(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << SHIFT_UNIPERIF_STA_UNDERFLOW_REC_FAILED(ip)))

/* VSYNC */
#define SHIFT_UNIPERIF_STA_VSYNC(ip) 16
#define MASK_UNIPERIF_STA_VSYNC(ip) \
	(0x1 << SHIFT_UNIPERIF_STA_VSYNC(ip))

/* CRC_RESULT_VALID */
#define SHIFT_UNIPERIF_STA_CRC_RESULT_VALID(ip) 20
#define MASK_UNIPERIF_STA_CRC_RESULT_VALID(ip) \
	(0x1 << SHIFT_UNIPERIF_STA_CRC_RESULT_VALID(ip))

/* CRC_LOST_LATE_READ */
#define SHIFT_UNIPERIF_STA_CRC_LOST_LATE_READ(ip) 21
#define MASK_UNIPERIF_STA_CRC_LOST_LATE_READ(ip) \
	(0x1 << SHIFT_UNIPERIF_STA_CRC_LOST_LATE_READ(ip))

/* LR_WIDTH_ERR */
#define SHIFT_UNIPERIF_STA_LR_WIDTH_ERR(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_RDR_1_0 ? -1 : 16)
#define MASK_UNIPERIF_STA_LR_WIDTH_ERR(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_RDR_1_0 ? \
		0 : (0x1 << SHIFT_UNIPERIF_STA_LR_WIDTH_ERR(ip)))

/*
 *  AUD_UNIPERIF_ITS
 */

#define OFFSET_UNIPERIF_ITS(ip) 0x000C
#define GET_UNIPERIF_ITS(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_ITS(ip))

/* SOFT_RESET_DONE */
#define SHIFT_UNIPERIF_ITS_SOFT_RESET_DONE(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 0)
#define MASK_UNIPERIF_ITS_SOFT_RESET_DONE(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << SHIFT_UNIPERIF_ITS_SOFT_RESET_DONE(ip)))

/* FIFO_ERROR */
#define SHIFT_UNIPERIF_ITS_FIFO_ERROR(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 0 : 8)
#define MASK_UNIPERIF_ITS_FIFO_ERROR(ip) \
	(0x1 << SHIFT_UNIPERIF_ITS_FIFO_ERROR(ip))

/* EODATABURST */
#define SHIFT_UNIPERIF_ITS_EODATABURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 1 : -1)
#define MASK_UNIPERIF_ITS_EODATABURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITS_EODATABURST(ip)) : 0)

/* EOBLOCK */
#define SHIFT_UNIPERIF_ITS_EOBLOCK(ip) 2
#define MASK_UNIPERIF_ITS_EOBLOCK(ip) \
	(0x1 << SHIFT_UNIPERIF_ITS_EOBLOCK(ip))

/* EOLATENCY */
#define SHIFT_UNIPERIF_ITS_EOLATENCY(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 3 : -1)
#define MASK_UNIPERIF_ITS_EOLATENCY(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITS_EOLATENCY(ip)) : 0)

/* EOPD_DATABURST */
#define SHIFT_UNIPERIF_ITS_EOPD_DATABURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 4 : -1)
#define MASK_UNIPERIF_ITS_EOPD_DATABURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITS_EOPD_DATABURST(ip)) : 0)

/* MEM_BLK_READ */
#define SHIFT_UNIPERIF_ITS_MEM_BLK_READ(ip) 5
#define MASK_UNIPERIF_ITS_MEM_BLK_READ(ip) \
	(0x1 << SHIFT_UNIPERIF_ITS_MEM_BLK_READ(ip))

/* EOF_PAUSEBURST */
#define SHIFT_UNIPERIF_ITS_EOF_PAUSEBURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 6 : -1)
#define MASK_UNIPERIF_ITS_EOF_PAUSEBURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITS_EOF_PAUSEBURST(ip)) : 0)

/* PA_PB_SYNC_LOST */
#define SHIFT_UNIPERIF_ITS_PA_PB_SYNC_LOST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 7 : -1)
#define MASK_UNIPERIF_ITS_PA_PB_SYNC_LOST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITS_PA_PB_SYNC_LOST(ip)) : 0)

/* CHL_STS_BUFFER_EMPTY */
#define SHIFT_UNIPERIF_ITS_CHL_STS_BUFFER_EMPTY(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 8 : 1)
#define MASK_UNIPERIF_ITS_CHL_STS_BUFFER_EMPTY(ip) \
	(0x1 << SHIFT_UNIPERIF_ITS_CHL_STS_BUFFER_EMPTY(ip))

/* DMA_ERROR */
#define SHIFT_UNIPERIF_ITS_DMA_ERROR(ip) 9
#define MASK_UNIPERIF_ITS_DMA_ERROR(ip) \
	(0x1 << SHIFT_UNIPERIF_ITS_DMA_ERROR(ip))

/* RUNSTOP */
#define SHIFT_UNIPERIF_ITS_RUNSTOP(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 10 : -1)
#define MASK_UNIPERIF_ITS_RUNSTOP(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITS_RUNSTOP(ip)) : 0)

/* RUN */
#define SHIFT_UNIPERIF_ITS_RUN(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 10)
#define MASK_UNIPERIF_ITS_RUN(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << SHIFT_UNIPERIF_ITS_RUN(ip)))

/* STOPPED */
#define SHIFT_UNIPERIF_ITS_STOPPED(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 11)
#define MASK_UNIPERIF_ITS_STOPPED(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << SHIFT_UNIPERIF_ITS_STOPPED(ip)))

/* UNDERFLOW_REC_DONE */
#define SHIFT_UNIPERIF_ITS_UNDERFLOW_REC_DONE(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 12)
#define MASK_UNIPERIF_ITS_UNDERFLOW_REC_DONE(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << SHIFT_UNIPERIF_ITS_UNDERFLOW_REC_DONE(ip)))

/* UNDERFLOW_REC_FAILED */
#define SHIFT_UNIPERIF_ITS_UNDERFLOW_REC_FAILED(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 13)
#define MASK_UNIPERIF_ITS_UNDERFLOW_REC_FAILED(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << SHIFT_UNIPERIF_ITS_UNDERFLOW_REC_FAILED(ip)))

/* VSYNC */
#define SHIFT_UNIPERIF_ITS_VSYNC(ip) 16
#define MASK_UNIPERIF_ITS_VSYNC(ip) \
	(0x1 << SHIFT_UNIPERIF_ITS_VSYNC(ip))

/* CRC_RESULT_VALID */
#define SHIFT_UNIPERIF_ITS_CRC_RESULT_VALID(ip) 20
#define MASK_UNIPERIF_ITS_CRC_RESULT_VALID(ip) \
	(0x1 << SHIFT_UNIPERIF_ITS_CRC_RESULT_VALID(ip))

/* CRC_LOST_LATE_READ */
#define SHIFT_UNIPERIF_ITS_CRC_LOST_LATE_READ(ip) 21
#define MASK_UNIPERIF_ITS_CRC_LOST_LATE_READ(ip) \
	(0x1 << SHIFT_UNIPERIF_ITS_CRC_LOST_LATE_READ(ip))

/* LR_WIDTH_ERR */
#define SHIFT_UNIPERIF_ITS_LR_WIDTH_ERR(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_RDR_1_0 ? -1 : 16)
#define MASK_UNIPERIF_ITS_LR_WIDTH_ERR(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_RDR_1_0 ? \
		0 : (0x1 << SHIFT_UNIPERIF_ITS_LR_WIDTH_ERR(ip)))

/*
 *  AUD_UNIPERIF_ITS_BCLR
 */

#define OFFSET_UNIPERIF_ITS_BCLR(ip) 0x0010
#define SET_UNIPERIF_ITS_BCLR(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_ITS_BCLR(ip))

/* SOFT_RESET_DONE */
#define SHIFT_UNIPERIF_ITS_BCLR_SOFT_RESET_DONE(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 0)
#define MASK_UNIPERIF_ITS_BCLR_SOFT_RESET_DONE(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << SHIFT_UNIPERIF_ITS_BCLR_SOFT_RESET_DONE(ip)))
#define SET_UNIPERIF_ITS_BCLR_SOFT_RESET_DONE(ip) \
	SET_UNIPERIF_ITS_BCLR(ip, \
		MASK_UNIPERIF_ITS_BCLR_SOFT_RESET_DONE(ip))

/* FIFO_ERROR */
#define SHIFT_UNIPERIF_ITS_BCLR_FIFO_ERROR(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 0 : 8)
#define MASK_UNIPERIF_ITS_BCLR_FIFO_ERROR(ip) \
	(0x1 << SHIFT_UNIPERIF_ITS_BCLR_FIFO_ERROR(ip))
#define SET_UNIPERIF_ITS_BCLR_FIFO_ERROR(ip) \
	SET_UNIPERIF_ITS_BCLR(ip, \
		MASK_UNIPERIF_ITS_BCLR_FIFO_ERROR(ip))

/* EODATABURST */
#define SHIFT_UNIPERIF_ITS_BCLR_EODATABURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 1 : -1)
#define MASK_UNIPERIF_ITS_BCLR_EODATABURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITS_BCLR_EODATABURST(ip)) : 0)
#define SET_UNIPERIF_ITS_BCLR_EODATABURST(ip) \
	SET_UNIPERIF_ITS_BCLR(ip, \
		MASK_UNIPERIF_ITS_BCLR_EODATABURST(ip))

/* EOBLOCK */
#define SHIFT_UNIPERIF_ITS_BCLR_EOBLOCK(ip) 2
#define MASK_UNIPERIF_ITS_BCLR_EOBLOCK(ip) \
	(0x1 << SHIFT_UNIPERIF_ITS_BCLR_EOBLOCK(ip))
#define SET_UNIPERIF_ITS_BCLR_EOBLOCK(ip) \
	SET_UNIPERIF_ITS_BCLR(ip, \
		MASK_UNIPERIF_ITS_BCLR_EOBLOCK(ip))

/* EOLATENCY */
#define SHIFT_UNIPERIF_ITS_BCLR_EOLATENCY(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 3 : -1)
#define MASK_UNIPERIF_ITS_BCLR_EOLATENCY(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITS_BCLR_EOLATENCY(ip)) : 0)
#define SET_UNIPERIF_ITS_BCLR_EOLATENCY(ip) \
	SET_UNIPERIF_ITS_BCLR(ip, \
		MASK_UNIPERIF_ITS_BCLR_EOLATENCY(ip))

/* EOPD_DATABURST */
#define SHIFT_UNIPERIF_ITS_BCLR_EOPD_DATABURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 4 : -1)
#define MASK_UNIPERIF_ITS_BCLR_EOPD_DATABURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITS_BCLR_EOPD_DATABURST(ip)) : 0)
#define SET_UNIPERIF_ITS_BCLR_EOPD_DATABURST(ip) \
	SET_UNIPERIF_ITS_BCLR(ip, \
		MASK_UNIPERIF_ITS_BCLR_EOPD_DATABURST(ip))

/* MEM_BLK_READ */
#define SHIFT_UNIPERIF_ITS_BCLR_MEM_BLK_READ(ip) 5
#define MASK_UNIPERIF_ITS_BCLR_MEM_BLK_READ(ip) \
	(0x1 << SHIFT_UNIPERIF_ITS_BCLR_MEM_BLK_READ(ip))
#define SET_UNIPERIF_ITS_BCLR_MEM_BLK_READ(ip) \
	SET_UNIPERIF_ITS_BCLR(ip, \
		MASK_UNIPERIF_ITS_BCLR_MEM_BLK_READ(ip))

/* EOF_PAUSEBURST */
#define SHIFT_UNIPERIF_ITS_BCLR_EOF_PAUSEBURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 6 : -1)
#define MASK_UNIPERIF_ITS_BCLR_EOF_PAUSEBURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITS_BCLR_EOF_PAUSEBURST(ip)) : 0)
#define SET_UNIPERIF_ITS_BCLR_EOF_PAUSEBURST(ip) \
	SET_UNIPERIF_ITS_BCLR(ip, \
		MASK_UNIPERIF_ITS_BCLR_EOF_PAUSEBURST(ip))

/* PA_PB_SYNC_LOST */
#define SHIFT_UNIPERIF_ITS_BCLR_PA_PB_SYNC_LOST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 7 : -1)
#define MASK_UNIPERIF_ITS_BCLR_PA_PB_SYNC_LOST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITS_BCLR_PA_PB_SYNC_LOST(ip)) : 0)
#define SET_UNIPERIF_ITS_BCLR_PA_PB_SYNC_LOST(ip) \
	SET_UNIPERIF_ITS_BCLR(ip, \
		MASK_UNIPERIF_ITS_BCLR_PA_PB_SYNC_LOST(ip))

/* CHL_STS_BUFFER_EMPTY */
#define SHIFT_UNIPERIF_ITS_BCLR_CHL_STS_BUFFER_EMPTY(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 8 : 1)
#define MASK_UNIPERIF_ITS_BCLR_CHL_STS_BUFFER_EMPTY(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
	(0x1 << SHIFT_UNIPERIF_ITS_BCLR_CHL_STS_BUFFER_EMPTY(ip)) : 0)
#define SET_UNIPERIF_ITS_BCLR_CHL_STS_BUFFER_EMPTY(ip) \
	SET_UNIPERIF_ITS_BCLR(ip, \
		MASK_UNIPERIF_ITS_BCLR_CHL_STS_BUFFER_EMPTY(ip))

/* DMA_ERROR */
#define SHIFT_UNIPERIF_ITS_BCLR_DMA_ERROR(ip) 9
#define MASK_UNIPERIF_ITS_BCLR_DMA_ERROR(ip) \
	(0x1 << SHIFT_UNIPERIF_ITS_BCLR_DMA_ERROR(ip))
#define SET_UNIPERIF_ITS_BCLR_DMA_ERROR(ip) \
	SET_UNIPERIF_ITS_BCLR(ip, \
		MASK_UNIPERIF_ITS_BCLR_DMA_ERROR(ip))

/* RUNSTOP */
#define SHIFT_UNIPERIF_ITS_BCLR_RUNSTOP(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 10 : -1)
#define MASK_UNIPERIF_ITS_BCLR_RUNSTOP(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITS_BCLR_RUNSTOP(ip)) : 0)
#define SET_UNIPERIF_ITS_BCLR_RUNSTOP(ip) \
	SET_UNIPERIF_ITS_BCLR(ip, \
		MASK_UNIPERIF_ITS_BCLR_RUNSTOP(ip))

/* RUN */
#define SHIFT_UNIPERIF_ITS_BCLR_RUN(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 10)
#define MASK_UNIPERIF_ITS_BCLR_RUN(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << SHIFT_UNIPERIF_ITS_BCLR_RUN(ip)))
#define SET_UNIPERIF_ITS_BCLR_RUN(ip) \
	SET_UNIPERIF_ITS_BCLR(ip, \
		MASK_UNIPERIF_ITS_BCLR_RUN(ip))

/* STOPPED */
#define SHIFT_UNIPERIF_ITS_BCLR_STOPPED(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 11)
#define MASK_UNIPERIF_ITS_BCLR_STOPPED(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << SHIFT_UNIPERIF_ITS_BCLR_STOPPED(ip)))
#define SET_UNIPERIF_ITS_BCLR_STOPPED(ip) \
	SET_UNIPERIF_ITS_BCLR(ip, \
		MASK_UNIPERIF_ITS_BCLR_STOPPED(ip))

/* UNDERFLOW_REC_DONE */
#define SHIFT_UNIPERIF_ITS_BCLR_UNDERFLOW_REC_DONE(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 12)
#define MASK_UNIPERIF_ITS_BCLR_UNDERFLOW_REC_DONE(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << \
			SHIFT_UNIPERIF_ITS_BCLR_UNDERFLOW_REC_DONE(ip)))
#define SET_UNIPERIF_ITS_BCLR_UNDERFLOW_REC_DONE(ip) \
	SET_UNIPERIF_ITS_BCLR(ip, \
		MASK_UNIPERIF_ITS_BCLR_UNDERFLOW_REC_DONE(ip))

/* UNDERFLOW_REC_FAILED */
#define SHIFT_UNIPERIF_ITS_BCLR_UNDERFLOW_REC_FAILED(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 13)
#define MASK_UNIPERIF_ITS_BCLR_UNDERFLOW_REC_FAILED(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << \
			SHIFT_UNIPERIF_ITS_BCLR_UNDERFLOW_REC_FAILED(ip)))
#define SET_UNIPERIF_ITS_BCLR_UNDERFLOW_REC_FAILED(ip) \
	SET_UNIPERIF_ITS_BCLR(ip, \
		MASK_UNIPERIF_ITS_BCLR_UNDERFLOW_REC_FAILED(ip))

/* VSYNC */
#define SHIFT_UNIPERIF_ITS_BCLR_VSYNC(ip) 16
#define MASK_UNIPERIF_ITS_BCLR_VSYNC(ip) \
	(0x1 << SHIFT_UNIPERIF_ITS_BCLR_VSYNC(ip))

/* CRC_RESULT_VALID */
#define SHIFT_UNIPERIF_ITS_BCLR_CRC_RESULT_VALID(ip) 20
#define MASK_UNIPERIF_ITS_BCLR_CRC_RESULT_VALID(ip) \
	(0x1 << SHIFT_UNIPERIF_ITS_BCLR_CRC_RESULT_VALID(ip))
#define SET_UNIPERIF_ITS_BCLR_CRC_RESULT_VALID(ip) \
	SET_UNIPERIF_ITS_BCLR(ip, \
		MASK_UNIPERIF_ITS_BCLR_CRC_RESULT_VALID(ip))

/* CRC_LOST_LATE_READ */
#define SHIFT_UNIPERIF_ITS_BCLR_CRC_LOST_LATE_READ(ip) 21
#define MASK_UNIPERIF_ITS_BCLR_CRC_LOST_LATE_READ(ip) \
	(0x1 << SHIFT_UNIPERIF_ITS_BCLR_CRC_LOST_LATE_READ(ip))
#define SET_UNIPERIF_ITS_BCLR_CRC_LOST_LATE_READ(ip) \
	SET_UNIPERIF_ITS_BCLR(ip, \
		MASK_UNIPERIF_ITS_BCLR_CRC_LOST_LATE_READ(ip))

/* LR_WIDTH_ERR */
#define SHIFT_UNIPERIF_ITS_BCLR_LR_WIDTH_ERR(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_RDR_1_0 ? -1 : 16)
#define MASK_UNIPERIF_ITS_BCLR_LR_WIDTH_ERR(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_RDR_1_0 ? \
		0 : (0x1 << SHIFT_UNIPERIF_ITS_BCLR_LR_WIDTH_ERR(ip)))

/*
 *  AUD_UNIPERIF_ITS_BSET
 */

#define OFFSET_UNIPERIF_ITS_BSET(ip) 0x0014
#define SET_UNIPERIF_ITS_BSET(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_ITS_BSET(ip))

/* SOFT_RESET_DONE */
#define SHIFT_UNIPERIF_ITS_BSET_SOFT_RESET_DONE(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 0)
#define MASK_UNIPERIF_ITS_BSET_SOFT_RESET_DONE(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << SHIFT_UNIPERIF_ITS_BSET_SOFT_RESET_DONE(ip)))
#define SET_UNIPERIF_ITS_BSET_SOFT_RESET_DONE(ip) \
	SET_UNIPERIF_ITS_BSET(ip, \
		MASK_UNIPERIF_ITS_BSET_SOFT_RESET_DONE(ip))

/* FIFO_ERROR */
#define SHIFT_UNIPERIF_ITS_BSET_FIFO_ERROR(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 0 : 8)
#define MASK_UNIPERIF_ITS_BSET_FIFO_ERROR(ip) \
	(0x1 << SHIFT_UNIPERIF_ITS_BSET_FIFO_ERROR(ip))
#define SET_UNIPERIF_ITS_BSET_FIFO_ERROR(ip) \
	SET_UNIPERIF_ITS_BSET(ip, \
		MASK_UNIPERIF_ITS_BSET_FIFO_ERROR(ip))

/* EODATABURST */
#define SHIFT_UNIPERIF_ITS_BSET_EODATABURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 1 : -1)
#define MASK_UNIPERIF_ITS_BSET_EODATABURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITS_BSET_EODATABURST(ip)) : 0)
#define SET_UNIPERIF_ITS_BSET_EODATABURST(ip) \
	SET_UNIPERIF_ITS_BSET(ip, \
		MASK_UNIPERIF_ITS_BSET_EODATABURST(ip))

/* EOBLOCK */
#define SHIFT_UNIPERIF_ITS_BSET_EOBLOCK(ip) 2
#define MASK_UNIPERIF_ITS_BSET_EOBLOCK(ip) \
	(0x1 << SHIFT_UNIPERIF_ITS_BSET_EOBLOCK(ip))
#define SET_UNIPERIF_ITS_BSET_EOBLOCK(ip) \
	SET_UNIPERIF_ITS_BSET(ip, \
		MASK_UNIPERIF_ITS_BSET_EOBLOCK(ip))

/* EOLATENCY */
#define SHIFT_UNIPERIF_ITS_BSET_EOLATENCY(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 3 : -1)
#define MASK_UNIPERIF_ITS_BSET_EOLATENCY(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITS_BSET_EOLATENCY(ip)) : 0)
#define SET_UNIPERIF_ITS_BSET_EOLATENCY(ip) \
	SET_UNIPERIF_ITS_BSET(ip, \
		MASK_UNIPERIF_ITS_BSET_EOLATENCY(ip))

/* EOPD_DATABURST */
#define SHIFT_UNIPERIF_ITS_BSET_EOPD_DATABURST(ip)  \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 4 : -1)
#define MASK_UNIPERIF_ITS_BSET_EOPD_DATABURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITS_BSET_EOPD_DATABURST(ip)) : 0)
#define SET_UNIPERIF_ITS_BSET_EOPD_DATABURST(ip) \
	SET_UNIPERIF_ITS_BSET(ip, \
		MASK_UNIPERIF_ITS_BSET_EOPD_DATABURST(ip))

/* MEM_BLK_READ */
#define SHIFT_UNIPERIF_ITS_BSET_MEM_BLK_READ(ip) 5
#define MASK_UNIPERIF_ITS_BSET_MEM_BLK_READ(ip) \
	(0x1 << SHIFT_UNIPERIF_ITS_BSET_MEM_BLK_READ(ip))
#define SET_UNIPERIF_ITS_BSET_MEM_BLK_READ(ip) \
	SET_UNIPERIF_ITS_BSET(ip, \
		MASK_UNIPERIF_ITS_BSET_MEM_BLK_READ(ip))

/* EOF_PAUSEBURST */
#define SHIFT_UNIPERIF_ITS_BSET_EOF_PAUSEBURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 6 : -1)
#define MASK_UNIPERIF_ITS_BSET_EOF_PAUSEBURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITS_BSET_EOF_PAUSEBURST(ip)) : 0)
#define SET_UNIPERIF_ITS_BSET_EOF_PAUSEBURST(ip) \
	SET_UNIPERIF_ITS_BSET(ip, \
		MASK_UNIPERIF_ITS_BSET_EOF_PAUSEBURST(ip))

/* PA_PB_SYNC_LOST */
#define SHIFT_UNIPERIF_ITS_BSET_PA_PB_SYNC_LOST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 7 : -1)
#define MASK_UNIPERIF_ITS_BSET_PA_PB_SYNC_LOST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITS_BSET_PA_PB_SYNC_LOST(ip)) : 0)
#define SET_UNIPERIF_ITS_BSET_PA_PB_SYNC_LOST(ip) \
	SET_UNIPERIF_ITS_BSET(ip, \
		MASK_UNIPERIF_ITS_BSET_PA_PB_SYNC_LOST(ip))

/* CHL_STS_BUFFER_EMPTY */
#define SHIFT_UNIPERIF_ITS_BSET_CHL_STS_BUFFER_EMPTY(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 8 : 1)
#define MASK_UNIPERIF_ITS_BSET_CHL_STS_BUFFER_EMPTY(ip) \
	(0x1 << SHIFT_UNIPERIF_ITS_BSET_CHL_STS_BUFFER_EMPTY(ip))
#define SET_UNIPERIF_ITS_BSET_CHL_STS_BUFFER_EMPTY(ip) \
	SET_UNIPERIF_ITS_BSET(ip, \
		MASK_UNIPERIF_ITS_BSET_CHL_STS_BUFFER_EMPTY(ip))

/* DMA_ERROR */
#define SHIFT_UNIPERIF_ITS_BSET_DMA_ERROR(ip) 9
#define MASK_UNIPERIF_ITS_BSET_DMA_ERROR(ip) \
	(0x1 << SHIFT_UNIPERIF_ITS_BSET_DMA_ERROR(ip))
#define SET_UNIPERIF_ITS_BSET_DMA_ERROR(ip) \
	SET_UNIPERIF_ITS_BSET(ip, \
		MASK_UNIPERIF_ITS_BSET_DMA_ERROR(ip))

/* RUNSTOP */
#define SHIFT_UNIPERIF_ITS_BSET_RUNSTOP(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 10 : -1)
#define MASK_UNIPERIF_ITS_BSET_RUNSTOP(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITS_BSET_RUNSTOP(ip)) : 0)
#define SET_UNIPERIF_ITS_BSET_RUNSTOP(ip) \
	SET_UNIPERIF_ITS_BSET(ip, \
		MASK_UNIPERIF_ITS_BSET_RUNSTOP(ip))
/* RUN */
#define SHIFT_UNIPERIF_ITS_BSET_RUN(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 10)
#define MASK_UNIPERIF_ITS_BSET_RUN(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << SHIFT_UNIPERIF_ITS_BSET_RUN(ip)))
#define SET_UNIPERIF_ITS_BSET_RUN(ip) \
	SET_UNIPERIF_ITS_BSET(ip, \
		MASK_UNIPERIF_ITS_BSET_RUN(ip))

/* STOPPED */
#define SHIFT_UNIPERIF_ITS_BSET_STOPPED(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 11)
#define MASK_UNIPERIF_ITS_BSET_STOPPED(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << SHIFT_UNIPERIF_ITS_BSET_STOPPED(ip)))
#define SET_UNIPERIF_ITS_BSET_STOPPED(ip) \
	SET_UNIPERIF_ITS_BSET(ip, \
		MASK_UNIPERIF_ITS_BSET_STOPPED(ip))

/* UNDERFLOW_REC_DONE */
#define SHIFT_UNIPERIF_ITS_BSET_UNDERFLOW_REC_DONE(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 12)
#define MASK_UNIPERIF_ITS_BSET_UNDERFLOW_REC_DONE(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << \
			SHIFT_UNIPERIF_ITS_BSET_UNDERFLOW_REC_DONE(ip)))
#define SET_UNIPERIF_ITS_BSET_UNDERFLOW_REC_DONE(ip) \
	SET_UNIPERIF_ITS_BSET(ip, \
		MASK_UNIPERIF_ITS_BSET_UNDERFLOW_REC_DONE(ip))

/* UNDERFLOW_REC_FAILED */
#define SHIFT_UNIPERIF_ITS_BSET_UNDERFLOW_REC_FAILED(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 13)
#define MASK_UNIPERIF_ITS_BSET_UNDERFLOW_REC_FAILED(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << \
			SHIFT_UNIPERIF_ITS_BSET_UNDERFLOW_REC_FAILED(ip)))
#define SET_UNIPERIF_ITS_BSET_UNDERFLOW_REC_FAILED(ip) \
	SET_UNIPERIF_ITS_BSET(ip, \
		MASK_UNIPERIF_ITS_BSET_UNDERFLOW_REC_FAILED(ip))

/* VSYNC */
#define SHIFT_UNIPERIF_ITS_BSET_VSYNC(ip) 16
#define MASK_UNIPERIF_ITS_BSET_VSYNC(ip) \
	(0x1 << SHIFT_UNIPERIF_ITS_BSET_VSYNC(ip))

/* CRC_RESULT_VALID */
#define SHIFT_UNIPERIF_ITS_BSET_CRC_RESULT_VALID(ip) 20
#define MASK_UNIPERIF_ITS_BSET_CRC_RESULT_VALID(ip) \
	(0x1 << SHIFT_UNIPERIF_ITS_BSET_CRC_RESULT_VALID(ip))
#define SET_UNIPERIF_ITS_BSET_CRC_RESULT_VALID(ip) \
	SET_UNIPERIF_ITS_BSET(ip, \
		MASK_UNIPERIF_ITS_BSET_CRC_RESULT_VALID(ip))

/* CRC_LOST_LATE_READ */
#define SHIFT_UNIPERIF_ITS_BSET_CRC_LOST_LATE_READ(ip) 21
#define MASK_UNIPERIF_ITS_BSET_CRC_LOST_LATE_READ(ip) \
	(0x1 << SHIFT_UNIPERIF_ITS_BSET_CRC_LOST_LATE_READ(ip))
#define SET_UNIPERIF_ITS_BSET_CRC_LOST_LATE_READ(ip) \
	SET_UNIPERIF_ITS_BSET(ip, \
		MASK_UNIPERIF_ITS_BSET_CRC_LOST_LATE_READ(ip))

/* LR_WIDTH_ERR */
#define SHIFT_UNIPERIF_ITS_BSET_LR_WIDTH_ERR(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_RDR_1_0 ? -1 : 16)
#define MASK_UNIPERIF_ITS_BSET_LR_WIDTH_ERR(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_RDR_1_0 ? \
		0 : (0x1 << SHIFT_UNIPERIF_ITS_BSET_LR_WIDTH_ERR(ip)))

/*
 *  AUD_UNIPERIF_ITM
 */

#define OFFSET_UNIPERIF_ITM(ip) 0x0018
#define GET_UNIPERIF_ITM(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_ITM(ip))

/* SOFT_RESET_DONE */
#define SHIFT_UNIPERIF_ITM_SOFT_RESET_DONE(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 0)
#define MASK_UNIPERIF_ITM_SOFT_RESET_DONE(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << SHIFT_UNIPERIF_ITM_SOFT_RESET_DONE(ip)))

/* FIFO_ERROR */
#define SHIFT_UNIPERIF_ITM_FIFO_ERROR(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 0 : 8)
#define MASK_UNIPERIF_ITM_FIFO_ERROR(ip) \
	(0x1 << SHIFT_UNIPERIF_ITM_FIFO_ERROR(ip))

/* EODATABURST */
#define SHIFT_UNIPERIF_ITM_EODATABURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 1 : -1)
#define MASK_UNIPERIF_ITM_EODATABURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITM_EODATABURST(ip)) : 0)

/* EOBLOCK */
#define SHIFT_UNIPERIF_ITM_EOBLOCK(ip) 2
#define MASK_UNIPERIF_ITM_EOBLOCK(ip) \
	(0x1 << SHIFT_UNIPERIF_ITM_EOBLOCK(ip))

/* EOLATENCY */
#define SHIFT_UNIPERIF_ITM_EOLATENCY(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 3 : -1)
#define MASK_UNIPERIF_ITM_EOLATENCY(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITM_EOLATENCY(ip)) : 0)

/* EOPD_DATABURST */
#define SHIFT_UNIPERIF_ITM_EOPD_DATABURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 4 : -1)
#define MASK_UNIPERIF_ITM_EOPD_DATABURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITM_EOPD_DATABURST(ip)) : 0)

/* MEM_BLK_READ */
#define SHIFT_UNIPERIF_ITM_MEM_BLK_READ(ip) 5
#define MASK_UNIPERIF_ITM_MEM_BLK_READ(ip) \
	(0x1 << SHIFT_UNIPERIF_ITM_MEM_BLK_READ(ip))

/* EOF_PAUSEBURST */
#define SHIFT_UNIPERIF_ITM_EOF_PAUSEBURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 6 : -1)
#define MASK_UNIPERIF_ITM_EOF_PAUSEBURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITM_EOF_PAUSEBURST(ip)) : 0)

/* PA_PB_SYNC_LOST */
#define SHIFT_UNIPERIF_ITM_PA_PB_SYNC_LOST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 7 : -1)
#define MASK_UNIPERIF_ITM_PA_PB_SYNC_LOST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITM_PA_PB_SYNC_LOST(ip)) : 0)

/* CHL_STS_BUFFER_EMPTY */
#define SHIFT_UNIPERIF_ITM_CHL_STS_BUFFER_EMPTY(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 8 : 1)
#define MASK_UNIPERIF_ITM_CHL_STS_BUFFER_EMPTY(ip) \
	(0x1 << SHIFT_UNIPERIF_ITM_CHL_STS_BUFFER_EMPTY(ip))

/* DMA_ERROR */
#define SHIFT_UNIPERIF_ITM_DMA_ERROR(ip) 9
#define MASK_UNIPERIF_ITM_DMA_ERROR(ip) \
	(0x1 << SHIFT_UNIPERIF_ITM_DMA_ERROR(ip))

/* RUNSTOP */
#define SHIFT_UNIPERIF_ITM_RUNSTOP(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 10 : -1)
#define MASK_UNIPERIF_ITM_RUNSTOP(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITM_RUNSTOP(ip)) : 0)

/* RUN */
#define SHIFT_UNIPERIF_ITM_RUN(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 10)
#define MASK_UNIPERIF_ITM_RUN(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << SHIFT_UNIPERIF_ITM_RUN(ip)))

/* STOPPED */
#define SHIFT_UNIPERIF_ITM_STOPPED(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 11)
#define MASK_UNIPERIF_ITM_STOPPED(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << SHIFT_UNIPERIF_ITM_STOPPED(ip)))

/* UNDERFLOW_REC_DONE */
#define SHIFT_UNIPERIF_ITM_UNDERFLOW_REC_DONE(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 12)
#define MASK_UNIPERIF_ITM_UNDERFLOW_REC_DONE(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << SHIFT_UNIPERIF_ITM_UNDERFLOW_REC_DONE(ip)))

/* UNDERFLOW_REC_FAILED */
#define SHIFT_UNIPERIF_ITM_UNDERFLOW_REC_FAILED(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 13)
#define MASK_UNIPERIF_ITM_UNDERFLOW_REC_FAILED(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << SHIFT_UNIPERIF_ITM_UNDERFLOW_REC_FAILED(ip)))

/* VSYNC */
#define SHIFT_UNIPERIF_ITM_VSYNC(ip) 16
#define MASK_UNIPERIF_ITM_VSYNC(ip) \
	(0x1 << SHIFT_UNIPERIF_ITM_VSYNC(ip))

/* CRC_RESULT_VALID */
#define SHIFT_UNIPERIF_ITM_CRC_RESULT_VALID(ip) 20
#define MASK_UNIPERIF_ITM_CRC_RESULT_VALID(ip) \
	(0x1 << SHIFT_UNIPERIF_ITM_CRC_RESULT_VALID(ip))

/* CRC_LOST_LATE_READ */
#define SHIFT_UNIPERIF_ITM_CRC_LOST_LATE_READ(ip) 21
#define MASK_UNIPERIF_ITM_CRC_LOST_LATE_READ(ip) \
	(0x1 << SHIFT_UNIPERIF_ITM_CRC_LOST_LATE_READ(ip))

/* LR_WIDTH_ERR */
#define SHIFT_UNIPERIF_ITM_LR_WIDTH_ERR(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_RDR_1_0 ? -1 : 16)
#define MASK_UNIPERIF_ITM_LR_WIDTH_ERR(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_RDR_1_0 ? \
		0 : (0x1 << SHIFT_UNIPERIF_ITM_LR_WIDTH_ERR(ip)))

/*
 *  AUD_UNIPERIF_ITM_BCLR
 */

#define OFFSET_UNIPERIF_ITM_BCLR(ip) 0x001c
#define SET_UNIPERIF_ITM_BCLR(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_ITM_BCLR(ip))

/* SOFT_RESET_DONE */
#define SHIFT_UNIPERIF_ITM_BCLR_SOFT_RESET_DONE(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 0)
#define MASK_UNIPERIF_ITM_BCLR_SOFT_RESET_DONE(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << SHIFT_UNIPERIF_ITM_BCLR_SOFT_RESET_DONE(ip)))
#define SET_UNIPERIF_ITM_BCLR_SOFT_RESET_DONE(ip) \
	SET_UNIPERIF_ITM_BCLR(ip, \
		MASK_UNIPERIF_ITM_BCLR_SOFT_RESET_DONE(ip))

/* FIFO_ERROR */
#define SHIFT_UNIPERIF_ITM_BCLR_FIFO_ERROR(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 0 : 8)
#define MASK_UNIPERIF_ITM_BCLR_FIFO_ERROR(ip) \
	(0x1 << SHIFT_UNIPERIF_ITM_BCLR_FIFO_ERROR(ip))
#define SET_UNIPERIF_ITM_BCLR_FIFO_ERROR(ip) \
	SET_UNIPERIF_ITM_BCLR(ip, \
		MASK_UNIPERIF_ITM_BCLR_FIFO_ERROR(ip))

/* EODATABURST */
#define SHIFT_UNIPERIF_ITM_BCLR_EODATABURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 1 : -1)
#define MASK_UNIPERIF_ITM_BCLR_EODATABURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITM_BCLR_EODATABURST(ip)) : 0)
#define SET_UNIPERIF_ITM_BCLR_EODATABURST(ip) \
	SET_UNIPERIF_ITM_BCLR(ip, \
		MASK_UNIPERIF_ITM_BCLR_EODATABURST(ip))

/* EOBLOCK */
#define SHIFT_UNIPERIF_ITM_BCLR_EOBLOCK(ip) 2
#define MASK_UNIPERIF_ITM_BCLR_EOBLOCK(ip) \
	(0x1 << SHIFT_UNIPERIF_ITM_BCLR_EOBLOCK(ip))
#define SET_UNIPERIF_ITM_BCLR_EOBLOCK(ip) \
	SET_UNIPERIF_ITM_BCLR(ip, \
		MASK_UNIPERIF_ITM_BCLR_EOBLOCK(ip))

/* EOLATENCY */
#define SHIFT_UNIPERIF_ITM_BCLR_EOLATENCY(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 3 : -1)
#define MASK_UNIPERIF_ITM_BCLR_EOLATENCY(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITM_BCLR_EOLATENCY(ip)) : 0)
#define SET_UNIPERIF_ITM_BCLR_EOLATENCY(ip) \
	SET_UNIPERIF_ITM_BCLR(ip, \
		MASK_UNIPERIF_ITM_BCLR_EOLATENCY(ip))

/* EOPD_DATABURST */
#define SHIFT_UNIPERIF_ITM_BCLR_EOPD_DATABURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 4 : -1)
#define MASK_UNIPERIF_ITM_BCLR_EOPD_DATABURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITM_BCLR_EOPD_DATABURST(ip)) : 0)
#define SET_UNIPERIF_ITM_BCLR_EOPD_DATABURST(ip) \
	SET_UNIPERIF_ITM_BCLR(ip, \
		MASK_UNIPERIF_ITM_BCLR_EOPD_DATABURST(ip))

/* MEM_BLK_READ */
#define SHIFT_UNIPERIF_ITM_BCLR_MEM_BLK_READ(ip) 5
#define MASK_UNIPERIF_ITM_BCLR_MEM_BLK_READ(ip) \
	(0x1 << SHIFT_UNIPERIF_ITM_BCLR_MEM_BLK_READ(ip))
#define SET_UNIPERIF_ITM_BCLR_MEM_BLK_READ(ip) \
	SET_UNIPERIF_ITM_BCLR(ip, \
		MASK_UNIPERIF_ITM_BCLR_MEM_BLK_READ(ip))

/* EOF_PAUSEBURST */
#define SHIFT_UNIPERIF_ITM_BCLR_EOF_PAUSEBURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 6 : -1)
#define MASK_UNIPERIF_ITM_BCLR_EOF_PAUSEBURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITM_BCLR_EOF_PAUSEBURST(ip)) : 0)
#define SET_UNIPERIF_ITM_BCLR_EOF_PAUSEBURST(ip) \
	SET_UNIPERIF_ITM_BCLR(ip, \
		MASK_UNIPERIF_ITM_BCLR_EOF_PAUSEBURST(ip))

/* PA_PB_SYNC_LOST */
#define SHIFT_UNIPERIF_ITM_BCLR_PA_PB_SYNC_LOST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 7 : -1)
#define MASK_UNIPERIF_ITM_BCLR_PA_PB_SYNC_LOST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITM_BCLR_PA_PB_SYNC_LOST(ip)) : 0)
#define SET_UNIPERIF_ITM_BCLR_PA_PB_SYNC_LOST(ip) \
	SET_UNIPERIF_ITM_BCLR(ip, \
		MASK_UNIPERIF_ITM_BCLR_PA_PB_SYNC_LOST(ip))

/* CHL_STS_BUFFER_EMPTY */
#define SHIFT_UNIPERIF_ITM_BCLR_CHL_STS_BUFFER_EMPTY(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 8 : 1)
#define MASK_UNIPERIF_ITM_BCLR_CHL_STS_BUFFER_EMPTY(ip) \
	(0x1 << SHIFT_UNIPERIF_ITM_BCLR_CHL_STS_BUFFER_EMPTY(ip))
#define SET_UNIPERIF_ITM_BCLR_CHL_STS_BUFFER_EMPTY(ip) \
	SET_UNIPERIF_ITM_BCLR(ip, \
		MASK_UNIPERIF_ITM_BCLR_CHL_STS_BUFFER_EMPTY(ip))

/* DMA_ERROR */
#define SHIFT_UNIPERIF_ITM_BCLR_DMA_ERROR(ip) 9
#define MASK_UNIPERIF_ITM_BCLR_DMA_ERROR(ip) \
	(0x1 << SHIFT_UNIPERIF_ITM_BCLR_DMA_ERROR(ip))
#define SET_UNIPERIF_ITM_BCLR_DMA_ERROR(ip) \
	SET_UNIPERIF_ITM_BCLR(ip, \
		MASK_UNIPERIF_ITM_BCLR_DMA_ERROR(ip))

/* RUNSTOP */
#define SHIFT_UNIPERIF_ITM_BCLR_RUNSTOP(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 10 : -1)
#define MASK_UNIPERIF_ITM_BCLR_RUNSTOP(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITM_BCLR_RUNSTOP(ip)) : 0)
#define SET_UNIPERIF_ITM_BCLR_RUNSTOP(ip) \
	SET_UNIPERIF_ITM_BCLR(ip, \
		MASK_UNIPERIF_ITM_BCLR_RUNSTOP(ip))
/* RUN */
#define SHIFT_UNIPERIF_ITM_BCLR_RUN(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 10)
#define MASK_UNIPERIF_ITM_BCLR_RUN(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << SHIFT_UNIPERIF_ITM_BCLR_RUN(ip)))
#define SET_UNIPERIF_ITM_BCLR_RUN(ip) \
	SET_UNIPERIF_ITM_BCLR(ip, \
		MASK_UNIPERIF_ITM_BCLR_RUN(ip))
/* STOPPED */
#define SHIFT_UNIPERIF_ITM_BCLR_STOPPED(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 11)
#define MASK_UNIPERIF_ITM_BCLR_STOPPED(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << SHIFT_UNIPERIF_ITM_BCLR_STOPPED(ip)))
#define SET_UNIPERIF_ITM_BCLR_STOPPED(ip) \
	SET_UNIPERIF_ITM_BCLR(ip, \
		MASK_UNIPERIF_ITM_BCLR_STOPPED(ip))

/* UNDERFLOW_REC_DONE */
#define SHIFT_UNIPERIF_ITM_BCLR_UNDERFLOW_REC_DONE(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 12)
#define MASK_UNIPERIF_ITM_BCLR_UNDERFLOW_REC_DONE(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << \
			SHIFT_UNIPERIF_ITM_BCLR_UNDERFLOW_REC_DONE(ip)))
#define SET_UNIPERIF_ITM_BCLR_UNDERFLOW_REC_DONE(ip) \
	SET_UNIPERIF_ITM_BCLR(ip, \
		MASK_UNIPERIF_ITM_BCLR_UNDERFLOW_REC_DONE(ip))

/* UNDERFLOW_REC_FAILED */
#define SHIFT_UNIPERIF_ITM_BCLR_UNDERFLOW_REC_FAILED(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 13)
#define MASK_UNIPERIF_ITM_BCLR_UNDERFLOW_REC_FAILED(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << \
			SHIFT_UNIPERIF_ITM_BCLR_UNDERFLOW_REC_FAILED(ip)))
#define SET_UNIPERIF_ITM_BCLR_UNDERFLOW_REC_FAILED(ip) \
	SET_UNIPERIF_ITM_BCLR(ip, \
		MASK_UNIPERIF_ITM_BCLR_UNDERFLOW_REC_FAILED(ip))

/* VSYNC */
#define SHIFT_UNIPERIF_ITM_BCLR_VSYNC(ip) 16
#define MASK_UNIPERIF_ITM_BCLR_VSYNC(ip) \
	(0x1 << SHIFT_UNIPERIF_ITM_BCLR_VSYNC(ip))

/* CRC_RESULT_VALID */
#define SHIFT_UNIPERIF_ITM_BCLR_CRC_RESULT_VALID(ip) 20
#define MASK_UNIPERIF_ITM_BCLR_CRC_RESULT_VALID(ip) \
	(0x1 << SHIFT_UNIPERIF_ITM_BCLR_CRC_RESULT_VALID(ip))
#define SET_UNIPERIF_ITM_BCLR_CRC_RESULT_VALID(ip) \
	SET_UNIPERIF_ITM_BCLR(ip, \
		MASK_UNIPERIF_ITM_BCLR_CRC_RESULT_VALID(ip))

/* CRC_LOST_LATE_READ */
#define SHIFT_UNIPERIF_ITM_BCLR_CRC_LOST_LATE_READ(ip) 21
#define MASK_UNIPERIF_ITM_BCLR_CRC_LOST_LATE_READ(ip) \
	(0x1 << SHIFT_UNIPERIF_ITM_BCLR_CRC_LOST_LATE_READ(ip))
#define SET_UNIPERIF_ITM_BCLR_CRC_LOST_LATE_READ(ip) \
	SET_UNIPERIF_ITM_BCLR(ip, \
		MASK_UNIPERIF_ITM_BCLR_CRC_LOST_LATE_READ(ip))

/* LR_WIDTH_ERR */
#define SHIFT_UNIPERIF_ITM_BCLR_LR_WIDTH_ERR(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_RDR_1_0 ? -1 : 16)
#define MASK_UNIPERIF_ITM_BCLR_LR_WIDTH_ERR(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_RDR_1_0 ? \
		0 : (0x1 << SHIFT_UNIPERIF_ITM_BCLR_LR_WIDTH_ERR(ip)))

/*
 *  AUD_UNIPERIF_ITM_BSET
 */

#define OFFSET_UNIPERIF_ITM_BSET(ip) 0x0020
#define SET_UNIPERIF_ITM_BSET(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_ITM_BSET(ip))

/* SOFT_RESET_DONE */
#define SHIFT_UNIPERIF_ITM_BSET_SOFT_RESET_DONE(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 0)
#define MASK_UNIPERIF_ITM_BSET_SOFT_RESET_DONE(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << SHIFT_UNIPERIF_ITM_BSET_SOFT_RESET_DONE(ip)))
#define SET_UNIPERIF_ITM_BSET_SOFT_RESET_DONE(ip) \
	SET_UNIPERIF_ITM_BSET(ip, \
		MASK_UNIPERIF_ITM_BSET_SOFT_RESET_DONE(ip))

/* FIFO_ERROR */
#define SHIFT_UNIPERIF_ITM_BSET_FIFO_ERROR(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 0 : 8)
#define MASK_UNIPERIF_ITM_BSET_FIFO_ERROR(ip) \
	(0x1 << SHIFT_UNIPERIF_ITM_BSET_FIFO_ERROR(ip))
#define SET_UNIPERIF_ITM_BSET_FIFO_ERROR(ip) \
	SET_UNIPERIF_ITM_BSET(ip, \
		MASK_UNIPERIF_ITM_BSET_FIFO_ERROR(ip))

/* EODATABURST */
#define SHIFT_UNIPERIF_ITM_BSET_EODATABURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 1 : -1)
#define MASK_UNIPERIF_ITM_BSET_EODATABURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITM_BSET_EODATABURST(ip)) : 0)
#define SET_UNIPERIF_ITM_BSET_EODATABURST(ip) \
	SET_UNIPERIF_ITM_BSET(ip, \
		MASK_UNIPERIF_ITM_BSET_EODATABURST(ip))

/* EOBLOCK */
#define SHIFT_UNIPERIF_ITM_BSET_EOBLOCK(ip) 2
#define MASK_UNIPERIF_ITM_BSET_EOBLOCK(ip) \
	(0x1 << SHIFT_UNIPERIF_ITM_BSET_EOBLOCK(ip))
#define SET_UNIPERIF_ITM_BSET_EOBLOCK(ip) \
	SET_UNIPERIF_ITM_BSET(ip, \
		MASK_UNIPERIF_ITM_BSET_EOBLOCK(ip))

/* EOLATENCY */
#define SHIFT_UNIPERIF_ITM_BSET_EOLATENCY(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 3 : -1)
#define MASK_UNIPERIF_ITM_BSET_EOLATENCY(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITM_BSET_EOLATENCY(ip)) : 0)
#define SET_UNIPERIF_ITM_BSET_EOLATENCY(ip) \
	SET_UNIPERIF_ITM_BSET(ip, \
		MASK_UNIPERIF_ITM_BSET_EOLATENCY(ip))

/* EOPD_DATABURST */
#define SHIFT_UNIPERIF_ITM_BSET_EOPD_DATABURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 4 : -1)
#define MASK_UNIPERIF_ITM_BSET_EOPD_DATABURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITM_BSET_EOPD_DATABURST(ip)) : 0)
#define SET_UNIPERIF_ITM_BSET_EOPD_DATABURST(ip) \
	SET_UNIPERIF_ITM_BSET(ip, \
		MASK_UNIPERIF_ITM_BSET_EOPD_DATABURST(ip))

/* MEM_BLK_READ */
#define SHIFT_UNIPERIF_ITM_BSET_MEM_BLK_READ(ip) 5
#define MASK_UNIPERIF_ITM_BSET_MEM_BLK_READ(ip) \
	(0x1 << SHIFT_UNIPERIF_ITM_BSET_MEM_BLK_READ(ip))
#define SET_UNIPERIF_ITM_BSET_MEM_BLK_READ(ip) \
	SET_UNIPERIF_ITM_BSET(ip, \
		MASK_UNIPERIF_ITM_BSET_MEM_BLK_READ(ip))

/* EOF_PAUSEBURST */
#define SHIFT_UNIPERIF_ITM_BSET_EOF_PAUSEBURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 6 : -1)
#define MASK_UNIPERIF_ITM_BSET_EOF_PAUSEBURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITM_BSET_EOF_PAUSEBURST(ip)) : 0)
#define SET_UNIPERIF_ITM_BSET_EOF_PAUSEBURST(ip) \
	SET_UNIPERIF_ITM_BSET(ip, \
		MASK_UNIPERIF_ITM_BSET_EOF_PAUSEBURST(ip))

/* PA_PB_SYNC_LOST */
#define SHIFT_UNIPERIF_ITM_BSET_PA_PB_SYNC_LOST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 7 : -1)
#define MASK_UNIPERIF_ITM_BSET_PA_PB_SYNC_LOST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITM_BSET_PA_PB_SYNC_LOST(ip)) : 0)
#define SET_UNIPERIF_ITM_BSET_PA_PB_SYNC_LOST(ip) \
	SET_UNIPERIF_ITM_BSET(ip, \
		MASK_UNIPERIF_ITM_BSET_PA_PB_SYNC_LOST(ip))

/* CHL_STS_BUFFER_EMPTY */
#define SHIFT_UNIPERIF_ITM_BSET_CHL_STS_BUFFER_EMPTY(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 8 : 1)
#define MASK_UNIPERIF_ITM_BSET_CHL_STS_BUFFER_EMPTY(ip) \
	(0x1 << SHIFT_UNIPERIF_ITM_BSET_CHL_STS_BUFFER_EMPTY(ip))
#define SET_UNIPERIF_ITM_BSET_CHL_STS_BUFFER_EMPTY(ip) \
	SET_UNIPERIF_ITM_BSET(ip, \
		MASK_UNIPERIF_ITM_BSET_CHL_STS_BUFFER_EMPTY(ip))

/* DMA_ERROR */
#define SHIFT_UNIPERIF_ITM_BSET_DMA_ERROR(ip) 9
#define MASK_UNIPERIF_ITM_BSET_DMA_ERROR(ip) \
	(0x1 << SHIFT_UNIPERIF_ITM_BSET_DMA_ERROR(ip))
#define SET_UNIPERIF_ITM_BSET_DMA_ERROR(ip) \
	SET_UNIPERIF_ITM_BSET(ip, \
		MASK_UNIPERIF_ITM_BSET_DMA_ERROR(ip))

/* RUNSTOP */
#define SHIFT_UNIPERIF_ITM_BSET_RUNSTOP(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 10 : -1)
#define MASK_UNIPERIF_ITM_BSET_RUNSTOP(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		(0x1 << SHIFT_UNIPERIF_ITM_BSET_RUNSTOP(ip)) : 0)
#define SET_UNIPERIF_ITM_BSET_RUNSTOP(ip) \
	SET_UNIPERIF_ITM_BSET(ip, \
		MASK_UNIPERIF_ITM_BSET_RUNSTOP(ip))

/* RUN */
#define SHIFT_UNIPERIF_ITM_BSET_RUN(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 10)
#define MASK_UNIPERIF_ITM_BSET_RUN(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << SHIFT_UNIPERIF_ITM_BSET_RUN(ip)))
#define SET_UNIPERIF_ITM_BSET_RUN(ip) \
	SET_UNIPERIF_ITM_BSET(ip, \
		MASK_UNIPERIF_ITM_BSET_RUN(ip))

/* STOPPED */
#define SHIFT_UNIPERIF_ITM_BSET_STOPPED(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 11)
#define MASK_UNIPERIF_ITM_BSET_STOPPED(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << SHIFT_UNIPERIF_ITM_BSET_STOPPED(ip)))
#define SET_UNIPERIF_ITM_BSET_STOPPED(ip) \
	SET_UNIPERIF_ITM_BSET(ip, \
		MASK_UNIPERIF_ITM_BSET_STOPPED(ip))

/* UNDERFLOW_REC_DONE */
#define SHIFT_UNIPERIF_ITM_BSET_UNDERFLOW_REC_DONE(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 12)
#define MASK_UNIPERIF_ITM_BSET_UNDERFLOW_REC_DONE(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << \
			SHIFT_UNIPERIF_ITM_BSET_UNDERFLOW_REC_DONE(ip)))
#define SET_UNIPERIF_ITM_BSET_UNDERFLOW_REC_DONE(ip) \
	SET_UNIPERIF_ITM_BSET(ip, \
		MASK_UNIPERIF_ITM_BSET_UNDERFLOW_REC_DONE(ip))

/* UNDERFLOW_REC_FAILED */
#define SHIFT_UNIPERIF_ITM_BSET_UNDERFLOW_REC_FAILED(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 13)
#define MASK_UNIPERIF_ITM_BSET_UNDERFLOW_REC_FAILED(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? \
		0 : (0x1 << \
			SHIFT_UNIPERIF_ITM_BSET_UNDERFLOW_REC_FAILED(ip)))
#define SET_UNIPERIF_ITM_BSET_UNDERFLOW_REC_FAILED(ip) \
	SET_UNIPERIF_ITM_BSET(ip, \
		MASK_UNIPERIF_ITM_BSET_UNDERFLOW_REC_FAILED(ip))

/* VSYNC */
#define SHIFT_UNIPERIF_ITM_BSET_VSYNC(ip) 16
#define MASK_UNIPERIF_ITM_BSET_VSYNC(ip) \
	(0x1 << SHIFT_UNIPERIF_ITM_BSET_VSYNC(ip))

/* CRC_RESULT_VALID */
#define SHIFT_UNIPERIF_ITM_BSET_CRC_RESULT_VALID(ip) 20
#define MASK_UNIPERIF_ITM_BSET_CRC_RESULT_VALID(ip) \
	(0x1 << SHIFT_UNIPERIF_ITM_BSET_CRC_RESULT_VALID(ip))
#define SET_UNIPERIF_ITM_BSET_CRC_RESULT_VALID(ip) \
	SET_UNIPERIF_ITM_BSET(ip, \
		MASK_UNIPERIF_ITM_BSET_CRC_RESULT_VALID(ip))

/* CRC_LOST_LATE_READ */
#define SHIFT_UNIPERIF_ITM_BSET_CRC_LOST_LATE_READ(ip) 21
#define MASK_UNIPERIF_ITM_BSET_CRC_LOST_LATE_READ(ip) \
	(0x1 << SHIFT_UNIPERIF_ITM_BSET_CRC_LOST_LATE_READ(ip))
#define SET_UNIPERIF_ITM_BSET_CRC_LOST_LATE_READ(ip) \
	SET_UNIPERIF_ITM_BSET(ip, \
		MASK_UNIPERIF_ITM_BSET_CRC_LOST_LATE_READ(ip))

/* LR_WIDTH_ERR */
#define SHIFT_UNIPERIF_ITM_BSET_LR_WIDTH_ERR(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_RDR_1_0 ? -1 : 16)
#define MASK_UNIPERIF_ITM_BSET_LR_WIDTH_ERR(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_RDR_1_0 ? \
		0 : (0x1 << SHIFT_UNIPERIF_ITM_BSET_LR_WIDTH_ERR(ip)))

/*
 *  UNIPERIF_SPDIF_PA_PB
 */

#define OFFSET_UNIPERIF_SPDIF_PA_PB(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 0x0024 : -1)
#define GET_UNIPERIF_SPDIF_PA_PB(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_SPDIF_PA_PB(ip))
#define SET_UNIPERIF_SPDIF_PA_PB(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_SPDIF_PA_PB(ip))
#define MASK_UNIPERIF_SPDIF_PA_PB(ip) 0xffff

/* PA */
#define SHIFT_UNIPERIF_SPDIF_PA_PB_PA(ip) 16

#define GET_UNIPERIF_SPDIF_PA_PB_PA(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_SPDIF_PA_PB(ip), \
		SHIFT_UNIPERIF_SPDIF_PA_PB_PA(ip), \
		MASK_UNIPERIF_SPDIF_PA_PB(ip))
#define SET_UNIPERIF_SPDIF_PA_PB_PA(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_SPDIF_PA_PB(ip), \
		SHIFT_UNIPERIF_SPDIF_PA_PB_PA(ip), \
		MASK_UNIPERIF_SPDIF_PA_PB(ip), value)

/* PB */
#define SHIFT_UNIPERIF_SPDIF_PA_PB_PB(ip) 0
#define GET_UNIPERIF_SPDIF_PA_PB_PB(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_SPDIF_PA_PB(ip), \
		SHIFT_UNIPERIF_SPDIF_PA_PB_PB(ip), \
		MASK_UNIPERIF_SPDIF_PA_PB(ip))
#define SET_UNIPERIF_SPDIF_PA_PB_PB(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_SPDIF_PA_PB(ip), \
		SHIFT_UNIPERIF_SPDIF_PA_PB_PB(ip), \
		MASK_UNIPERIF_SPDIF_PA_PB(ip), value)

/*
 *  UNIPERIF_SPDIF_PC_PD
 */

#define OFFSET_UNIPERIF_SPDIF_PC_PD(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 0x0028 : -1)
#define GET_UNIPERIF_SPDIF_PC_PD(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_SPDIF_PC_PD(ip))
#define SET_UNIPERIF_SPDIF_PC_PD(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_SPDIF_PC_PD(ip))
#define MASK_UNIPERIF_SPDIF_PC_PD(ip) 0xffff

/* PC */
#define SHIFT_UNIPERIF_SPDIF_PC_PD_PC(ip) 16
#define GET_UNIPERIF_SPDIF_PC_PD_PC(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_SPDIF_PC_PD(ip), \
		SHIFT_UNIPERIF_SPDIF_PC_PD_PC(ip), \
		MASK_UNIPERIF_SPDIF_PC_PD(ip))
#define SET_UNIPERIF_SPDIF_PC_PD_PC(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_SPDIF_PC_PD(ip), \
		SHIFT_UNIPERIF_SPDIF_PC_PD_PC(ip), \
		MASK_UNIPERIF_SPDIF_PC_PD(ip), value)

/* PD */
#define SHIFT_UNIPERIF_SPDIF_PC_PD_PD(ip) 0
#define GET_UNIPERIF_SPDIF_PC_PD_PD(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_SPDIF_PC_PD(ip), \
		SHIFT_UNIPERIF_SPDIF_PC_PD_PD(ip), \
		MASK_UNIPERIF_SPDIF_PC_PD(ip))
#define SET_UNIPERIF_SPDIF_PC_PD_PD(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_SPDIF_PC_PD(ip), \
		SHIFT_UNIPERIF_SPDIF_PC_PD_PD(ip), \
		MASK_UNIPERIF_SPDIF_PC_PD(ip), value)

/*
 *  UNIPERIF_SPDIF_PAUSE_LAT
 */

#define OFFSET_UNIPERIF_SPDIF_PAUSE_LAT(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 0x0038 : -1)
#define GET_UNIPERIF_SPDIF_PAUSE_LAT(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_SPDIF_PAUSE_LAT(ip))
#define SET_UNIPERIF_SPDIF_PAUSE_LAT(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_SPDIF_PAUSE_LAT(ip))
#define MASK_UNIPERIF_SPDIF_PAUSE_LAT(ip) 0xffff

/* PAUSE_GAPLENGTH */
#define SHIFT_UNIPERIF_SPDIF_PAUSE_LAT_GAPLENGTH(ip) 16
#define GET_UNIPERIF_SPDIF_PAUSE_LAT_GAPLENGTH(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_SPDIF_PAUSE_LAT(ip), \
		SHIFT_UNIPERIF_SPDIF_PAUSE_LAT_GAPLENGTH(ip), \
		MASK_UNIPERIF_SPDIF_PAUSE_LAT(ip))
#define SET_UNIPERIF_SPDIF_PAUSE_LAT_GAPLENGTH(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_SPDIF_PAUSE_LAT(ip), \
		SHIFT_UNIPERIF_SPDIF_PAUSE_LAT_GAPLENGTH(ip), \
		MASK_UNIPERIF_SPDIF_PAUSE_LAT(ip), value)

/* PAUSE_LAT */
#define SHIFT_UNIPERIF_SPDIF_PAUSE_LAT_LAT(ip) 0
#define GET_UNIPERIF_SPDIF_PAUSE_LAT_LAT(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_SPDIF_PAUSE_LAT(ip), \
		SHIFT_UNIPERIF_SPDIF_PAUSE_LAT_LAT(ip), \
		MASK_UNIPERIF_SPDIF_PAUSE_LAT(ip))
#define SET_UNIPERIF_SPDIF_PAUSE_LAT_LAT(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_SPDIF_PAUSE_LAT(ip), \
		SHIFT_UNIPERIF_SPDIF_PAUSE_LAT_LAT(ip), \
		MASK_UNIPERIF_SPDIF_PAUSE_LAT(ip), value)

/*
 *  UNIPERIF_SPDIF_FRAMELEN_BURST
 */

#define OFFSET_UNIPERIF_SPDIF_FRAMELEN_BURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 0x003C : -1)
#define GET_UNIPERIF_SPDIF_FRAMELEN_BURST(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_SPDIF_FRAMELEN_BURST(ip))
#define SET_UNIPERIF_SPDIF_FRAMELEN_BURST(ip, value) \
	writel_relaxed(value, ip->base + \
			OFFSET_UNIPERIF_SPDIF_FRAMELEN_BURST(ip))
#define MASK_UNIPERIF_SPDIF_FRAMELEN_BURST(ip) 0xffff

/* FRAMELEN_DAT_BURST */
#define SHIFT_UNIPERIF_SPDIF_FRAMELEN_BURST_DAT_BURST(ip) 16
#define GET_UNIPERIF_SPDIF_FRAMELEN_BURST_DAT_BURST(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_SPDIF_FRAMELEN_BURST(ip), \
		SHIFT_UNIPERIF_SPDIF_FRAMELEN_BURST_DAT_BURST(ip), \
		MASK_UNIPERIF_SPDIF_FRAMELEN_BURST(ip))
#define SET_UNIPERIF_SPDIF_FRAMELEN_BURST_DAT_BURST(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_SPDIF_FRAMELEN_BURST(ip), \
		SHIFT_UNIPERIF_SPDIF_FRAMELEN_BURST_DAT_BURST(ip), \
		MASK_UNIPERIF_SPDIF_FRAMELEN_BURST(ip), value)

/* FRAMELEN_DAT_PAUSE_BURST */
#define SHIFT_UNIPERIF_SPDIF_FRAMELEN_BURST_PAUSE_BURST(ip) 0
#define GET_UNIPERIF_SPDIF_FRAMELEN_BURST_PAUSE_BURST(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_SPDIF_FRAMELEN_BURST(ip), \
		SHIFT_UNIPERIF_SPDIF_FRAMELEN_BURST_PAUSE_BURST(ip), \
		MASK_UNIPERIF_SPDIF_FRAMELEN_BURST(ip))
#define SET_UNIPERIF_SPDIF_FRAMELEN_BURST_PAUSE_BURST(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_SPDIF_FRAMELEN_BURST(ip), \
		SHIFT_UNIPERIF_SPDIF_FRAMELEN_BURST_PAUSE_BURST(ip), \
		MASK_UNIPERIF_SPDIF_FRAMELEN_BURST(ip), value)

/*
 * UNIPERIF_CONFIG
 */

#define OFFSET_UNIPERIF_CONFIG(ip) 0x0040
#define GET_UNIPERIF_CONFIG(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_CONFIG(ip))
#define SET_UNIPERIF_CONFIG(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_CONFIG(ip))

/* PARITY_CNTR */
#define SHIFT_UNIPERIF_CONFIG_PARITY_CNTR(ip) 0
#define MASK_UNIPERIF_CONFIG_PARITY_CNTR(ip) 0x1
#define GET_UNIPERIF_CONFIG_PARITY_CNTR(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_PARITY_CNTR(ip), \
		MASK_UNIPERIF_CONFIG_PARITY_CNTR(ip))
#define SET_UNIPERIF_CONFIG_PARITY_CNTR_BY_HW(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_PARITY_CNTR(ip), \
		MASK_UNIPERIF_CONFIG_PARITY_CNTR(ip), 0)
#define SET_UNIPERIF_CONFIG_PARITY_CNTR_BY_SW(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_PARITY_CNTR(ip), \
		MASK_UNIPERIF_CONFIG_PARITY_CNTR(ip), 1)

/* CHANNEL_STA_CNTR */
#define SHIFT_UNIPERIF_CONFIG_CHANNEL_STA_CNTR(ip) 1
#define MASK_UNIPERIF_CONFIG_CHANNEL_STA_CNTR(ip) 0x1
#define GET_UNIPERIF_CONFIG_CHANNEL_STA_CNTR(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_CHANNEL_STA_CNTR(ip), \
		MASK_UNIPERIF_CONFIG_CHANNEL_STA_CNTR(ip))
#define SET_UNIPERIF_CONFIG_CHANNEL_STA_CNTR_BY_SW(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_CHANNEL_STA_CNTR(ip), \
		MASK_UNIPERIF_CONFIG_CHANNEL_STA_CNTR(ip), 0)
#define SET_UNIPERIF_CONFIG_CHANNEL_STA_CNTR_BY_HW(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip),    \
		SHIFT_UNIPERIF_CONFIG_CHANNEL_STA_CNTR(ip), \
		MASK_UNIPERIF_CONFIG_CHANNEL_STA_CNTR(ip), 1)

/* USER_DAT_CNTR */
#define SHIFT_UNIPERIF_CONFIG_USER_DAT_CNTR(ip) 2
#define MASK_UNIPERIF_CONFIG_USER_DAT_CNTR(ip) 0x1
#define GET_UNIPERIF_CONFIG_USER_DAT_CNTR(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_USER_DAT_CNTR(ip), \
		MASK_UNIPERIF_CONFIG_USER_DAT_CNTR(ip))
#define SET_UNIPERIF_CONFIG_USER_DAT_CNTR_BY_HW(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_USER_DAT_CNTR(ip), \
		MASK_UNIPERIF_CONFIG_USER_DAT_CNTR(ip), 1)
#define SET_UNIPERIF_CONFIG_USER_DAT_CNTR_BY_SW(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_USER_DAT_CNTR(ip), \
		MASK_UNIPERIF_CONFIG_USER_DAT_CNTR(ip), 0)

/* VALIDITY_DAT_CNTR */
#define SHIFT_UNIPERIF_CONFIG_VALIDITY_DAT_CNTR(ip) 3
#define MASK_UNIPERIF_CONFIG_VALIDITY_DAT_CNTR(ip) 0x1
#define GET_UNIPERIF_CONFIG_VALIDITY_DAT_CNTR(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_VALIDITY_DAT_CNTR(ip), \
		MASK_UNIPERIF_CONFIG_VALIDITY_DAT_CNTR(ip))
#define SET_UNIPERIF_CONFIG_VALIDITY_DAT_CNTR_BY_SW(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_VALIDITY_DAT_CNTR(ip), \
		MASK_UNIPERIF_CONFIG_VALIDITY_DAT_CNTR(ip), 0)
#define SET_UNIPERIF_CONFIG_VALIDITY_DAT_CNTR_BY_HW(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_VALIDITY_DAT_CNTR(ip), \
		MASK_UNIPERIF_CONFIG_VALIDITY_DAT_CNTR(ip), 1)

/* ONE_BIT_AUD_SUPPORT */
#define SHIFT_UNIPERIF_CONFIG_ONE_BIT_AUD(ip) 4
#define MASK_UNIPERIF_CONFIG_ONE_BIT_AUD(ip) 0x1
#define GET_UNIPERIF_CONFIG_ONE_BIT_AUD(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_ONE_BIT_AUD(ip), \
		MASK_UNIPERIF_CONFIG_ONE_BIT_AUD(ip))
#define SET_UNIPERIF_CONFIG_ONE_BIT_AUD_DISABLE(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_ONE_BIT_AUD(ip), \
		MASK_UNIPERIF_CONFIG_ONE_BIT_AUD(ip), 0)
#define SET_UNIPERIF_CONFIG_ONE_BIT_AUD_ENABLE(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_ONE_BIT_AUD(ip), \
		MASK_UNIPERIF_CONFIG_ONE_BIT_AUD(ip), 1)

/* MEMORY_FMT */
#define SHIFT_UNIPERIF_CONFIG_MEM_FMT(ip) 5
#define MASK_UNIPERIF_CONFIG_MEM_FMT(ip) 0x1
#define VALUE_UNIPERIF_CONFIG_MEM_FMT_16_0(ip) 0
#define VALUE_UNIPERIF_CONFIG_MEM_FMT_16_16(ip) 1
#define GET_UNIPERIF_CONFIG_MEM_FMT(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_MEM_FMT(ip), \
		MASK_UNIPERIF_CONFIG_MEM_FMT(ip))
#define SET_UNIPERIF_CONFIG_MEM_FMT(ip, value)	\
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_MEM_FMT(ip), \
		MASK_UNIPERIF_CONFIG_MEM_FMT(ip), value)
#define SET_UNIPERIF_CONFIG_MEM_FMT_16_0(ip)   \
	SET_UNIPERIF_CONFIG_MEM_FMT(ip, \
		VALUE_UNIPERIF_CONFIG_MEM_FMT_16_0(ip))
#define SET_UNIPERIF_CONFIG_MEM_FMT_16_16(ip) \
	SET_UNIPERIF_CONFIG_MEM_FMT(ip, \
		VALUE_UNIPERIF_CONFIG_MEM_FMT_16_16(ip))

/* REPEAT_CHL_STS */
#define SHIFT_UNIPERIF_CONFIG_REPEAT_CHL_STS(ip) 6
#define MASK_UNIPERIF_CONFIG_REPEAT_CHL_STS(ip) 0x1
#define GET_UNIPERIF_CONFIG_REPEAT_CHL_STS(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_REPEAT_CHL_STS(ip), \
		MASK_UNIPERIF_CONFIG_REPEAT_CHL_STS(ip))
#define SET_UNIPERIF_CONFIG_REPEAT_CHL_STS_ENABLE(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_REPEAT_CHL_STS(ip), \
		MASK_UNIPERIF_CONFIG_REPEAT_CHL_STS(ip), 0)
#define SET_UNIPERIF_CONFIG_REPEAT_CHL_STS_DISABLE(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_REPEAT_CHL_STS(ip), \
		MASK_UNIPERIF_CONFIG_REPEAT_CHL_STS(ip), 1)

/* BACK_STALL_REQ */
#define SHIFT_UNIPERIF_CONFIG_BACK_STALL_REQ(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 7 : -1)
#define MASK_UNIPERIF_CONFIG_BACK_STALL_REQ(ip) 0x1
#define GET_UNIPERIF_CONFIG_BACK_STALL_REQ(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_BACK_STALL_REQ(ip), \
		MASK_UNIPERIF_CONFIG_BACK_STALL_REQ(ip))
#define SET_UNIPERIF_CONFIG_BACK_STALL_REQ_DISABLE(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_BACK_STALL_REQ(ip), \
		MASK_UNIPERIF_CONFIG_BACK_STALL_REQ(ip), 0)
#define SET_UNIPERIF_CONFIG_BACK_STALL_REQ_ENABLE(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_BACK_STALL_REQ(ip), \
		MASK_UNIPERIF_CONFIG_BACK_STALL_REQ(ip), 1)

/* FDMA_TRIGGER_LIMIT */
#define SHIFT_UNIPERIF_CONFIG_FDMA_TRIGGER_LIMIT(ip) 8
#define MASK_UNIPERIF_CONFIG_FDMA_TRIGGER_LIMIT(ip) 0x7F
#define GET_UNIPERIF_CONFIG_FDMA_TRIGGER_LIMIT(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_FDMA_TRIGGER_LIMIT(ip), \
		MASK_UNIPERIF_CONFIG_FDMA_TRIGGER_LIMIT(ip))
#define SET_UNIPERIF_CONFIG_FDMA_TRIGGER_LIMIT(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_FDMA_TRIGGER_LIMIT(ip), \
		MASK_UNIPERIF_CONFIG_FDMA_TRIGGER_LIMIT(ip), value)

/* CHL_STS_UPDATE */
#define SHIFT_UNIPERIF_CONFIG_CHL_STS_UPDATE(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 16 : -1)
#define MASK_UNIPERIF_CONFIG_CHL_STS_UPDATE(ip) 0x1
#define GET_UNIPERIF_CONFIG_CHL_STS_UPDATE(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip),  \
		SHIFT_UNIPERIF_CONFIG_CHL_STS_UPDATE(ip), \
		MASK_UNIPERIF_CONFIG_CHL_STS_UPDATE(ip))
#define SET_UNIPERIF_CONFIG_CHL_STS_UPDATE(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_CHL_STS_UPDATE(ip), \
		MASK_UNIPERIF_CONFIG_CHL_STS_UPDATE(ip), 1)

/* PD_FMT */
#define SHIFT_UNIPERIF_CONFIG_PD_FMT(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 17 : -1)
#define MASK_UNIPERIF_CONFIG_PD_FMT(ip) 0x1
#define GET_UNIPERIF_CONFIG_PD_FMT(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_PD_FMT(ip), \
		MASK_UNIPERIF_CONFIG_PD_FMT(ip))
#define SET_UNIPERIF_CONFIG_PD_FMT_IN_BIT(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_PD_FMT(ip), \
		MASK_UNIPERIF_CONFIG_PD_FMT(ip), 1)
#define SET_UNIPERIF_CONFIG_PD_FMT_IN_BYTE(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_PD_FMT(ip), \
		MASK_UNIPERIF_CONFIG_PD_FMT(ip), 1)

/* IDLE_MOD */
#define SHIFT_UNIPERIF_CONFIG_IDLE_MOD(ip) 18
#define MASK_UNIPERIF_CONFIG_IDLE_MOD(ip) 0x1
#define GET_UNIPERIF_CONFIG_IDLE_MOD(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_IDLE_MOD(ip), \
		MASK_UNIPERIF_CONFIG_IDLE_MOD(ip))
#define SET_UNIPERIF_CONFIG_IDLE_MOD_DISABLE(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_IDLE_MOD(ip), \
		MASK_UNIPERIF_CONFIG_IDLE_MOD(ip), 0)
#define SET_UNIPERIF_CONFIG_IDLE_MOD_ENABLE(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_IDLE_MOD(ip), \
		MASK_UNIPERIF_CONFIG_IDLE_MOD(ip), 1)

/* SUBFRAME_SELECTION */
#define SHIFT_UNIPERIF_CONFIG_SUBFRAME_SEL(ip) 19
#define MASK_UNIPERIF_CONFIG_SUBFRAME_SEL(ip) 0x1
#define GET_UNIPERIF_CONFIG_SUBFRAME_SEL(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_SUBFRAME_SEL(ip), \
		MASK_UNIPERIF_CONFIG_SUBFRAME_SEL(ip))
#define SET_UNIPERIF_CONFIG_SUBFRAME_SEL_SUBF1_SUBF0(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_SUBFRAME_SEL(ip), \
		MASK_UNIPERIF_CONFIG_SUBFRAME_SEL(ip), 1)
#define SET_UNIPERIF_CONFIG_SUBFRAME_SEL_SUBF0_SUBF1(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_SUBFRAME_SEL(ip), \
		MASK_UNIPERIF_CONFIG_SUBFRAME_SEL(ip), 0)

/* FULL_SW_CONTROL */
#define SHIFT_UNIPERIF_CONFIG_SPDIF_SW_CTRL(ip) 20
#define MASK_UNIPERIF_CONFIG_SPDIF_SW_CTRL(ip) 0x1
#define GET_UNIPERIF_CONFIG_SPDIF_SW_CTRL(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_SPDIF_SW_CTRL(ip), \
		MASK_UNIPERIF_CONFIG_SPDIF_SW_CTRL(ip))
#define SET_UNIPERIF_CONFIG_SPDIF_SW_CTRL_ENABLE(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_SPDIF_SW_CTRL(ip), \
		MASK_UNIPERIF_CONFIG_SPDIF_SW_CTRL(ip), 1)
#define SET_UNIPERIF_CONFIG_SPDIF_SW_CTRL_DISABLE(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_SPDIF_SW_CTRL(ip), \
		MASK_UNIPERIF_CONFIG_SPDIF_SW_CTRL(ip), 0)

/* SYNC_LOST_UPDATE */
#define SHIFT_UNIPERIF_CONFIG_SYNC_LOST_UPDATE(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 21 : -1)
#define MASK_UNIPERIF_CONFIG_SYNC_LOST_UPDATE(ip) 0x1
#define GET_UNIPERIF_CONFIG_SYNC_LOST_UPDATE(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_SYNC_LOST_UPDATE(ip), \
		MASK_UNIPERIF_CONFIG_SYNC_LOST_UPDATE(ip))
#define SET_UNIPERIF_CONFIG_SYNC_LOST_UPDATE_CLEAR(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_SYNC_LOST_UPDATE(ip), \
		MASK_UNIPERIF_CONFIG_SYNC_LOST_UPDATE(ip), 0)

/* MASTER_CLKEDGE */
#define SHIFT_UNIPERIF_CONFIG_MSTR_CLKEDGE(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 24 : -1)
#define MASK_UNIPERIF_CONFIG_MSTR_CLKEDGE(ip) 0x1
#define GET_UNIPERIF_CONFIG_MSTR_CLKEDGE(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_MSTR_CLKEDGE(ip), \
		MASK_UNIPERIF_CONFIG_MSTR_CLKEDGE(ip))
#define SET_UNIPERIF_CONFIG_MSTR_CLKEDGE_FALLING(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_MSTR_CLKEDGE(ip), \
		MASK_UNIPERIF_CONFIG_MSTR_CLKEDGE(ip), 1)
#define SET_UNIPERIF_CONFIG_MSTR_CLKEDGE_RISING(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONFIG(ip), \
		SHIFT_UNIPERIF_CONFIG_MSTR_CLKEDGE(ip), \
		MASK_UNIPERIF_CONFIG_MSTR_CLKEDGE(ip), 0)

/*
 * UNIPERIF_CTRL
 */

#define OFFSET_UNIPERIF_CTRL(ip) 0x0044
#define GET_UNIPERIF_CTRL(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_CTRL(ip))
#define SET_UNIPERIF_CTRL(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_CTRL(ip))

/* OPERATION */
#define SHIFT_UNIPERIF_CTRL_OPERATION(ip) 0
#define MASK_UNIPERIF_CTRL_OPERATION(ip) 0x7
#define GET_UNIPERIF_CTRL_OPERATION(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_CTRL_OPERATION(ip), \
		MASK_UNIPERIF_CTRL_OPERATION(ip))
#define VALUE_UNIPERIF_CTRL_OPERATION_OFF(ip) 0
#define SET_UNIPERIF_CTRL_OPERATION_OFF(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_CTRL_OPERATION(ip), \
		MASK_UNIPERIF_CTRL_OPERATION(ip), \
		VALUE_UNIPERIF_CTRL_OPERATION_OFF(ip))
#define VALUE_UNIPERIF_CTRL_OPERATION_MUTE_PCM_NULL(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 1 : -1)
#define SET_UNIPERIF_CTRL_OPERATION_MUTE_PCM_NULL(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_CTRL_OPERATION(ip), \
		MASK_UNIPERIF_CTRL_OPERATION(ip), \
		VALUE_UNIPERIF_CTRL_OPERATION_MUTE_PCM_NULL(ip))
#define VALUE_UNIPERIF_CTRL_OPERATION_MUTE_PAUSE_BURST(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 2 : -1)
#define SET_UNIPERIF_CTRL_OPERATION_MUTE_PAUSE_BURST(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_CTRL_OPERATION(ip), \
		MASK_UNIPERIF_CTRL_OPERATION(ip), \
		VALUE_UNIPERIF_CTRL_OPERATION_MUTE_PAUSE_BURST(ip))
#define VALUE_UNIPERIF_CTRL_OPERATION_PCM_DATA(ip) 3
#define SET_UNIPERIF_CTRL_OPERATION_PCM_DATA(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_CTRL_OPERATION(ip), \
		MASK_UNIPERIF_CTRL_OPERATION(ip), \
		VALUE_UNIPERIF_CTRL_OPERATION_PCM_DATA(ip))
/* This is the same as above! */
#define VALUE_UNIPERIF_CTRL_OPERATION_AUDIO_DATA(ip) 3
#define SET_UNIPERIF_CTRL_OPERATION_AUDIO_DATA(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_CTRL_OPERATION(ip), \
		MASK_UNIPERIF_CTRL_OPERATION(ip), \
		VALUE_UNIPERIF_CTRL_OPERATION_AUDIO_DATA(ip))
#define VALUE_UNIPERIF_CTRL_OPERATION_ENC_DATA(ip) 4
#define SET_UNIPERIF_CTRL_OPERATION_ENC_DATA(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_CTRL_OPERATION(ip), \
		MASK_UNIPERIF_CTRL_OPERATION(ip), \
		VALUE_UNIPERIF_CTRL_OPERATION_ENC_DATA(ip))
#define VALUE_UNIPERIF_CTRL_OPERATION_CD_DATA(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 5 : -1)
#define SET_UNIPERIF_CTRL_OPERATION_CD_DATA(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_CTRL_OPERATION(ip), \
		MASK_UNIPERIF_CTRL_OPERATION(ip), \
		VALUE_UNIPERIF_CTRL_OPERATION_CD_DATA(ip))
#define VALUE_UNIPERIF_CTRL_OPERATION_STANDBY(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 7)
#define SET_UNIPERIF_CTRL_OPERATION_STANDBY(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_CTRL_OPERATION(ip), \
		MASK_UNIPERIF_CTRL_OPERATION(ip), \
		VALUE_UNIPERIF_CTRL_OPERATION_STANDBY(ip))

/* EXIT_STBY_ON_EOBLOCK */
#define SHIFT_UNIPERIF_CTRL_EXIT_STBY_ON_EOBLOCK(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 3)
#define MASK_UNIPERIF_CTRL_EXIT_STBY_ON_EOBLOCK(ip) 0x1
#define GET_UNIPERIF_CTRL_EXIT_STBY_ON_EOBLOCK(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_CTRL_EXIT_STBY_ON_EOBLOCK(ip), \
		MASK_UNIPERIF_CTRL_EXIT_STBY_ON_EOBLOCK(ip))
#define SET_UNIPERIF_CTRL_EXIT_STBY_ON_EOBLOCK_OFF(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_CTRL_EXIT_STBY_ON_EOBLOCK(ip), \
		MASK_UNIPERIF_CTRL_EXIT_STBY_ON_EOBLOCK(ip), 0)
#define SET_UNIPERIF_CTRL_EXIT_STBY_ON_EOBLOCK_ON(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_CTRL_EXIT_STBY_ON_EOBLOCK(ip), \
		MASK_UNIPERIF_CTRL_EXIT_STBY_ON_EOBLOCK(ip), 1)

/* ROUNDING */
#define SHIFT_UNIPERIF_CTRL_ROUNDING(ip) 4
#define MASK_UNIPERIF_CTRL_ROUNDING(ip) 0x1
#define GET_UNIPERIF_CTRL_ROUNDING(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_CTRL_ROUNDING(ip), \
		MASK_UNIPERIF_CTRL_ROUNDING(ip))
#define SET_UNIPERIF_CTRL_ROUNDING_OFF(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_CTRL_ROUNDING(ip), \
		MASK_UNIPERIF_CTRL_ROUNDING(ip), 0)
#define SET_UNIPERIF_CTRL_ROUNDING_ON(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_CTRL_ROUNDING(ip), \
		MASK_UNIPERIF_CTRL_ROUNDING(ip), 1)

/* DIVIDER */
#define SHIFT_UNIPERIF_CTRL_DIVIDER(ip) 5
#define MASK_UNIPERIF_CTRL_DIVIDER(ip) 0xff
#define GET_UNIPERIF_CTRL_DIVIDER(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_CTRL_DIVIDER(ip), \
		MASK_UNIPERIF_CTRL_DIVIDER(ip))
#define SET_UNIPERIF_CTRL_DIVIDER(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_CTRL_DIVIDER(ip), \
		MASK_UNIPERIF_CTRL_DIVIDER(ip), value)

/* BYTE_SWAP */
#define SHIFT_UNIPERIF_CTRL_BYTE_SWP(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 13 : -1)
#define MASK_UNIPERIF_CTRL_BYTE_SWP(ip) 0x1
#define GET_UNIPERIF_CTRL_BYTE_SWP(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_CTRL_BYTE_SWP(ip), \
		MASK_UNIPERIF_CTRL_BYTE_SWP(ip))
#define SET_UNIPERIF_CTRL_BYTE_SWP_OFF(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_CTRL_BYTE_SWP(ip), \
		MASK_UNIPERIF_CTRL_BYTE_SWP(ip), 0)
#define SET_UNIPERIF_CTRL_BYTE_SWP_ON(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_CTRL_BYTE_SWP(ip), \
		MASK_UNIPERIF_CTRL_BYTE_SWP(ip), 1)

/* ZERO_STUFFING_HW_SW */
#define SHIFT_UNIPERIF_CTRL_ZERO_STUFF(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 14 : -1)
#define MASK_UNIPERIF_CTRL_ZERO_STUFF(ip) 0x1
#define GET_UNIPERIF_CTRL_ZERO_STUFF(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_CTRL_ZERO_STUFF(ip), \
		MASK_UNIPERIF_CTRL_ZERO_STUFF(ip))
#define SET_UNIPERIF_CTRL_ZERO_STUFF_HW(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_CTRL_ZERO_STUFF(ip), \
		MASK_UNIPERIF_CTRL_ZERO_STUFF(ip), 1)
#define SET_UNIPERIF_CTRL_ZERO_STUFF_SW(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_CTRL_ZERO_STUFF(ip), \
		MASK_UNIPERIF_CTRL_ZERO_STUFF(ip), 0)

/* SPDIF_LAT */
#define SHIFT_UNIPERIF_CTRL_SPDIF_LAT(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 16 : -1)
#define MASK_UNIPERIF_CTRL_SPDIF_LAT(ip) 0x1
#define GET_UNIPERIF_CTRL_SPDIF_LAT(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_CTRL_SPDIF_LAT(ip), \
		MASK_UNIPERIF_CTRL_SPDIF_LAT(ip))
#define SET_UNIPERIF_CTRL_SPDIF_LAT_ON(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_CTRL_SPDIF_LAT(ip), \
		MASK_UNIPERIF_CTRL_SPDIF_LAT(ip), 1)
#define SET_UNIPERIF_CTRL_SPDIF_LAT_OFF(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_CTRL_SPDIF_LAT(ip), \
		MASK_UNIPERIF_CTRL_SPDIF_LAT(ip), 0)

/* EN_SPDIF_FORMATTING */
#define SHIFT_UNIPERIF_CTRL_SPDIF_FMT(ip) 17
#define MASK_UNIPERIF_CTRL_SPDIF_FMT(ip) 0x1
#define GET_UNIPERIF_CTRL_SPDIF_FMT(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_CTRL_SPDIF_FMT(ip), \
		MASK_UNIPERIF_CTRL_SPDIF_FMT(ip))
#define SET_UNIPERIF_CTRL_SPDIF_FMT_ON(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_CTRL_SPDIF_FMT(ip), \
		MASK_UNIPERIF_CTRL_SPDIF_FMT(ip), 1)
#define SET_UNIPERIF_CTRL_SPDIF_FMT_OFF(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_CTRL_SPDIF_FMT(ip), \
		MASK_UNIPERIF_CTRL_SPDIF_FMT(ip), 0)

/* READER_OUT_SELECT */
#define SHIFT_UNIPERIF_CTRL_READER_OUT_SEL(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 18 : -1)
#define MASK_UNIPERIF_CTRL_READER_OUT_SEL(ip) 0x1
#define GET_UNIPERIF_CTRL_READER_OUT_SEL(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_CTRL_READER_OUT_SEL(ip), \
		MASK_UNIPERIF_CTRL_READER_OUT_SEL(ip))
#define SET_UNIPERIF_CTRL_READER_OUT_SEL_IN_MEM(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_CTRL_READER_OUT_SEL(ip), \
		MASK_UNIPERIF_CTRL_READER_OUT_SEL(ip), 0)
#define SET_UNIPERIF_CTRL_READER_OUT_SEL_ON_I2S_LINE(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_CTRL_READER_OUT_SEL(ip), \
		MASK_CORAUD_UNIPERIF_CTRL_READER_OUT_SEL(ip), 1)

/* UNDERFLOW_REC_WINDOW */
#define SHIFT_UNIPERIF_CTRL_UNDERFLOW_REC_WINDOW(ip) 20
#define MASK_UNIPERIF_CTRL_UNDERFLOW_REC_WINDOW(ip) 0xff
#define GET_UNIPERIF_CTRL_UNDERFLOW_REC_WINDOW(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_CTRL_UNDERFLOW_REC_WINDOW(ip), \
		MASK_UNIPERIF_CTRL_UNDERFLOW_REC_WINDOW(ip))
#define SET_UNIPERIF_CTRL_UNDERFLOW_REC_WINDOW(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_CTRL_UNDERFLOW_REC_WINDOW(ip), \
		MASK_UNIPERIF_CTRL_UNDERFLOW_REC_WINDOW(ip), value)

/*
 * UNIPERIF_I2S_FMT a.k.a UNIPERIF_FORMAT
 */

#define OFFSET_UNIPERIF_I2S_FMT(ip) 0x0048
#define GET_UNIPERIF_I2S_FMT(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_I2S_FMT(ip))
#define SET_UNIPERIF_I2S_FMT(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_I2S_FMT(ip))

/* NBIT */
#define SHIFT_UNIPERIF_I2S_FMT_NBIT(ip) 0
#define MASK_UNIPERIF_I2S_FMT_NBIT(ip) 0x1
#define GET_UNIPERIF_I2S_FMT_NBIT(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_I2S_FMT(ip), \
		SHIFT_UNIPERIF_I2S_FMT_NBIT(ip), \
		MASK_UNIPERIF_I2S_FMT_NBIT(ip))
#define SET_UNIPERIF_I2S_FMT_NBIT_32(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_I2S_FMT(ip), \
		SHIFT_UNIPERIF_I2S_FMT_NBIT(ip), \
		MASK_UNIPERIF_I2S_FMT_NBIT(ip), 0)
#define SET_UNIPERIF_I2S_FMT_NBIT_16(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_I2S_FMT(ip), \
		SHIFT_UNIPERIF_I2S_FMT_NBIT(ip), \
		MASK_UNIPERIF_I2S_FMT_NBIT(ip), 1)

/* DATA_SIZE */
#define SHIFT_UNIPERIF_I2S_FMT_DATA_SIZE(ip) 1
#define MASK_UNIPERIF_I2S_FMT_DATA_SIZE(ip) 0x7
#define GET_UNIPERIF_I2S_FMT_DATA_SIZE(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_I2S_FMT(ip), \
		SHIFT_UNIPERIF_I2S_FMT_DATA_SIZE(ip), \
		MASK_UNIPERIF_I2S_FMT_DATA_SIZE(ip))
#define SET_UNIPERIF_I2S_FMT_DATA_SIZE_16(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_I2S_FMT(ip), \
		SHIFT_UNIPERIF_I2S_FMT_DATA_SIZE(ip), \
		MASK_UNIPERIF_I2S_FMT_DATA_SIZE(ip), 0)
#define SET_UNIPERIF_I2S_FMT_DATA_SIZE_18(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_I2S_FMT(ip), \
		SHIFT_UNIPERIF_I2S_FMT_DATA_SIZE(ip), \
		MASK_UNIPERIF_I2S_FMT_DATA_SIZE(ip), 1)
#define SET_UNIPERIF_I2S_FMT_DATA_SIZE_20(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_I2S_FMT(ip), \
		SHIFT_UNIPERIF_I2S_FMT_DATA_SIZE(ip), \
		MASK_UNIPERIF_I2S_FMT_DATA_SIZE(ip), 2)
#define SET_UNIPERIF_I2S_FMT_DATA_SIZE_24(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_I2S_FMT(ip), \
		SHIFT_UNIPERIF_I2S_FMT_DATA_SIZE(ip), \
		MASK_UNIPERIF_I2S_FMT_DATA_SIZE(ip), 3)
#define SET_UNIPERIF_I2S_FMTL_DATA_SIZE_28(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_I2S_FMT(ip), \
		SHIFT_UNIPERIF_I2S_FMT_DATA_SIZE(ip), \
		MASK_UNIPERIF_I2S_FMT_DATA_SIZE(ip), 4)
#define SET_UNIPERIF_I2S_FMT_DATA_SIZE_32(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_I2S_FMT(ip), \
		SHIFT_UNIPERIF_I2S_FMT_DATA_SIZE(ip), \
		MASK_UNIPERIF_I2S_FMT_DATA_SIZE(ip), 5)

/* LR_POL */
#define SHIFT_UNIPERIF_I2S_FMT_LR_POL(ip) 4
#define MASK_UNIPERIF_I2S_FMT_LR_POL(ip) 0x1
#define VALUE_UNIPERIF_I2S_FMT_LR_POL_LOW(ip) 0x0
#define VALUE_UNIPERIF_I2S_FMT_LR_POL_HIG(ip) 0x1
#define GET_UNIPERIF_I2S_FMT_LR_POL(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_I2S_FMT(ip), \
		SHIFT_UNIPERIF_I2S_FMT_LR_POL(ip), \
		MASK_UNIPERIF_I2S_FMT_LR_POL(ip))
#define SET_UNIPERIF_I2S_FMT_LR_POL(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_I2S_FMT(ip), \
		SHIFT_UNIPERIF_I2S_FMT_LR_POL(ip), \
		MASK_UNIPERIF_I2S_FMT_LR_POL(ip), value)
#define SET_UNIPERIF_I2S_FMT_LR_POL_LOW(ip) \
	SET_UNIPERIF_I2S_FMT_LR_POL(ip, \
		VALUE_UNIPERIF_I2S_FMT_LR_POL_LOW(ip))
#define SET_UNIPERIF_I2S_FMT_LR_POL_HIG(ip) \
	SET_UNIPERIF_I2S_FMT_LR_POL(ip, \
		VALUE_UNIPERIF_I2S_FMT_LR_POL_HIG(ip))

/* SCLK_EDGE */
#define SHIFT_UNIPERIF_I2S_FMT_SCLK_EDGE(ip) 5
#define MASK_UNIPERIF_I2S_FMT_SCLK_EDGE(ip) 0x1
#define GET_UNIPERIF_I2S_FMT_SCLK_EDGE(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_I2S_FMT(ip), \
		SHIFT_UNIPERIF_I2S_FMT_SCLK_EDGE(ip), \
		MASK_UNIPERIF_I2S_FMT_SCLK_EDGE(ip))
#define SET_UNIPERIF_I2S_FMT_SCLK_EDGE_RISING(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_I2S_FMT(ip), \
		SHIFT_UNIPERIF_I2S_FMT_SCLK_EDGE(ip), \
		MASK_UNIPERIF_I2S_FMT_SCLK_EDGE(ip), 0)
#define SET_UNIPERIF_I2S_FMT_SCLK_EDGE_FALLING(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_I2S_FMT(ip), \
		SHIFT_UNIPERIF_I2S_FMT_SCLK_EDGE(ip), \
		MASK_UNIPERIF_I2S_FMT_SCLK_EDGE(ip), 1)

/* PADDING */
#define SHIFT_UNIPERIF_I2S_FMT_PADDING(ip) 6
#define MASK_UNIPERIF_I2S_FMT_PADDING(ip) 0x1
#define MASK_UNIPERIF_I2S_FMT_PADDING(ip) 0x1
#define VALUE_UNIPERIF_I2S_FMT_PADDING_I2S_MODE(ip) 0x0
#define VALUE_UNIPERIF_I2S_FMT_PADDING_SONY_MODE(ip) 0x1
#define GET_UNIPERIF_I2S_FMT_PADDING(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_I2S_FMT(ip), \
		SHIFT_UNIPERIF_I2S_FMT_PADDING(ip), \
		MASK_UNIPERIF_I2S_FMT_PADDING(ip))
#define SET_UNIPERIF_I2S_FMT_PADDING(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_I2S_FMT(ip), \
		SHIFT_UNIPERIF_I2S_FMT_PADDING(ip), \
		MASK_UNIPERIF_I2S_FMT_PADDING(ip), value)
#define SET_UNIPERIF_I2S_FMT_PADDING_I2S_MODE(ip) \
	SET_UNIPERIF_I2S_FMT_PADDING(ip, \
		VALUE_UNIPERIF_I2S_FMT_PADDING_I2S_MODE(ip))
#define SET_UNIPERIF_I2S_FMT_PADDING_SONY_MODE(ip) \
	SET_UNIPERIF_I2S_FMT_PADDING(ip, \
		VALUE_UNIPERIF_I2S_FMT_PADDING_SONY_MODE(ip))

/* ALIGN */
#define SHIFT_UNIPERIF_I2S_FMT_ALIGN(ip) 7
#define MASK_UNIPERIF_I2S_FMT_ALIGN(ip) 0x1
#define GET_UNIPERIF_I2S_FMT_ALIGN(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_I2S_FMT(ip), \
		SHIFT_UNIPERIF_I2S_FMT_ALIGN(ip), \
		MASK_UNIPERIF_I2S_FMT_ALIGN(ip))
#define SET_UNIPERIF_I2S_FMT_ALIGN_LEFT(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_I2S_FMT(ip), \
		SHIFT_UNIPERIF_I2S_FMT_ALIGN(ip), \
		MASK_UNIPERIF_I2S_FMT_ALIGN(ip), 0)
#define SET_UNIPERIF_I2S_FMT_ALIGN_RIGHT(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_I2S_FMT(ip), \
		SHIFT_UNIPERIF_I2S_FMT_ALIGN(ip), \
		MASK_UNIPERIF_I2S_FMT_ALIGN(ip), 1)

/* ORDER */
#define SHIFT_UNIPERIF_I2S_FMT_ORDER(ip) 8
#define MASK_UNIPERIF_I2S_FMT_ORDER(ip) 0x1
#define GET_UNIPERIF_I2S_FMT_ORDER(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_I2S_FMT(ip), \
		SHIFT_UNIPERIF_I2S_FMT_ORDER(ip), \
		MASK_UNIPERIF_I2S_FMT_ORDER(ip))
#define SET_UNIPERIF_I2S_FMT_ORDER_LSB(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_I2S_FMT(ip), \
		SHIFT_UNIPERIF_I2S_FMT_ORDER(ip), \
		MASK_UNIPERIF_I2S_FMT_ORDER(ip), 0)
#define SET_UNIPERIF_I2S_FMT_ORDER_MSB(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_I2S_FMT(ip), \
		SHIFT_UNIPERIF_I2S_FMT_ORDER(ip), \
		MASK_UNIPERIF_I2S_FMT_ORDER(ip), 1)

/* NUM_CH */
#define SHIFT_UNIPERIF_I2S_FMT_NUM_CH(ip) 9
#define MASK_UNIPERIF_I2S_FMT_NUM_CH(ip) 0x7
#define GET_UNIPERIF_I2S_FMT_NUM_CH(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_I2S_FMT(ip), \
		SHIFT_UNIPERIF_I2S_FMT_NUM_CH(ip), \
		MASK_UNIPERIF_I2S_FMT_NUM_CH(ip))
#define SET_UNIPERIF_I2S_FMT_NUM_CH(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_I2S_FMT(ip), \
		SHIFT_UNIPERIF_I2S_FMT_NUM_CH(ip), \
		MASK_UNIPERIF_I2S_FMT_NUM_CH(ip), value)

/* NO_OF_SAMPLES_TO_READ */
#define SHIFT_UNIPERIF_I2S_FMT_NO_OF_SAMPLES_TO_READ(ip) 12
#define MASK_UNIPERIF_I2S_FMT_NO_OF_SAMPLES_TO_READ(ip) 0xfffff
#define GET_UNIPERIF_I2S_FMT_NO_OF_SAMPLES_TO_READ(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_I2S_FMT(ip), \
		SHIFT_UNIPERIF_I2S_FMT_NO_OF_SAMPLES_TO_READ(ip), \
		MASK_UNIPERIF_I2S_FMT_NO_OF_SAMPLES_TO_READ(ip))
#define SET_UNIPERIF_I2S_FMT_NO_OF_SAMPLES_TO_READ(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_I2S_FMT(ip), \
		SHIFT_UNIPERIF_I2S_FMT_NO_OF_SAMPLES_TO_READ(ip), \
		MASK_UNIPERIF_I2S_FMT_NO_OF_SAMPLES_TO_READ(ip), value)

/*
 * UNIPERIF_BIT_CONTROL
 */

#define OFFSET_UNIPERIF_BIT_CONTROL(ip)  \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 0x004c)
#define GET_UNIPERIF_BIT_CONTROL(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_BIT_CONTROL(ip))
#define SET_UNIPERIF_BIT_CONTROL(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_BIT_CONTROL(ip))

/* CLR_UNDERFLOW_DURATION */
#define SHIFT_UNIPERIF_BIT_CONTROL_CLR_UNDERFLOW_DURATION(ip) 0
#define MASK_UNIPERIF_BIT_CONTROL_CLR_UNDERFLOW_DURATION(ip) 0x1
#define GET_UNIPERIF_BIT_CONTROL_CLR_UNDERFLOW_DURATION(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_BIT_CONTROL(ip), \
		SHIFT_UNIPERIF_BIT_CONTROL_CLR_UNDERFLOW_DURATION(ip), \
		MASK_UNIPERIF_BIT_CONTROL_CLR_UNDERFLOW_DURATION(ip))
#define SET_UNIPERIF_BIT_CONTROL_CLR_UNDERFLOW_DURATION(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_BIT_CONTROL(ip), \
		SHIFT_UNIPERIF_BIT_CONTROL_CLR_UNDERFLOW_DURATION(ip), \
		MASK_UNIPERIF_BIT_CONTROL_CLR_UNDERFLOW_DURATION(ip), 1)

/* CHL_STS_UPDATE */
#define SHIFT_UNIPERIF_BIT_CONTROL_CHL_STS_UPDATE(ip) 1
#define MASK_UNIPERIF_BIT_CONTROL_CHL_STS_UPDATE(ip) 0x1
#define GET_UNIPERIF_BIT_CONTROL_CHL_STS_UPDATE(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_BIT_CONTROL(ip), \
		SHIFT_UNIPERIF_BIT_CONTROL_CHL_STS_UPDATE(ip), \
		MASK_UNIPERIF_BIT_CONTROL_CHL_STS_UPDATE(ip))
#define SET_UNIPERIF_BIT_CONTROL_CHL_STS_UPDATE(ip) \
	SET_UNIPERIF_BIT_REG(ip, \
		OFFSET_UNIPERIF_BIT_CONTROL(ip), \
		SHIFT_UNIPERIF_BIT_CONTROL_CHL_STS_UPDATE(ip), \
		MASK_UNIPERIF_BIT_CONTROL_CHL_STS_UPDATE(ip), 1)

/*
 * UNIPERIF_STATUS_1
 */

#define OFFSET_UNIPERIF_STATUS_1(ip) 0x0050
#define GET_UNIPERIF_STATUS_1(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_STATUS_1(ip))
#define SET_UNIPERIF_STATUS_1(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_STATUS_1(ip))

/* UNDERFLOW_DURATION */
#define SHIFT_UNIPERIF_STATUS_1_UNDERFLOW_DURATION(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 0)
#define MASK_UNIPERIF_STATUS_1_UNDERFLOW_DURATION(ip) 0xff
#define GET_UNIPERIF_STATUS_1_UNDERFLOW_DURATION(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_STATUS_1(ip), \
		SHIFT_UNIPERIF_STATUS_1_UNDERFLOW_DURATION(ip), \
		MASK_UNIPERIF_STATUS_1_UNDERFLOW_DURATION(ip))
#define SET_UNIPERIF_STATUS_1_UNDERFLOW_DURATION(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_STATUS_1(ip), \
		SHIFT_UNIPERIF_STATUS_1_UNDERFLOW_DURATION(ip), \
		MASK_UNIPERIF_STATUS_1_UNDERFLOW_DURATION(ip), value)

/* HW_CURRENT_STATE */
#define SHIFT_UNIPERIF_STATUS_1_HW_CURRENT_STATE(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 8)
#define MASK_UNIPERIF_STATUS_1_HW_CURRENT_STATE(ip) 0x7
#define VALUE_UNIPERIF_STATUS_1_HW_CURRENT_STATE_OFF(ip) 0x0
#define VALUE_UNIPERIF_STATUS_1_HW_CURRENT_STATE_AUDIO_DATA(ip) 0x3
#define VALUE_UNIPERIF_STATUS_1_HW_CURRENT_STATE_UNDERFLOW_REC(ip) 0x6
#define VALUE_UNIPERIF_STATUS_1_HW_CURRENT_STATE_STANDBY(ip) 0x7
#define GET_UNIPERIF_STATUS_1_HW_CURRENT_STATE(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_STATUS_1(ip), \
		SHIFT_UNIPERIF_STATUS_1_HW_CURRENT_STATE(ip), \
		MASK_UNIPERIF_STATUS_1_HW_CURRENT_STATE(ip))
#define SET_UNIPERIF_STATUS_1_HW_CURRENT_STATE(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_STATUS_1(ip), \
		SHIFT_UNIPERIF_STATUS_1_HW_CURRENT_STATE(ip), \
		MASK_UNIPERIF_STATUS_1_HW_CURRENT_STATE(ip), value)

/* SAMPL_CNT */
#define SHIFT_UNIPERIF_STATUS_1_SAMPL_CNT(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 0 : -1)
#define MASK_UNIPERIF_STATUS_1_SAMPL_CNT(ip) 0xffff
#define GET_UNIPERIF_STATUS_1_SAMPL_CNT(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_STATUS_1(ip), \
		SHIFT_UNIPERIF_STATUS_1_SAMPL_CNT(ip), \
		MASK_UNIPERIF_STATUS_1_SAMPL_CNT(ip))
#define SET_UNIPERIF_STATUS_1_SAMPL_CNT(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_STATUS_1(ip), \
		SHIFT_UNIPERIF_STATUS_1_SAMPL_CNT(ip), \
		MASK_UNIPERIF_STATUS_1_SAMPL_CNT(ip), value)

/* PA_C_BIT_NUMBER */
#define SHIFT_UNIPERIF_STATUS_1_PA_C_BIT_NUMBER(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 16 : -1)
#define MASK_UNIPERIF_STATUS_1_PA_C_BIT_NUMBER(ip) 0xff
#define GET_UNIPERIF_STATUS_1_PA_C_BIT_NUMBER(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_STATUS_1(ip), \
		SHIFT_UNIPERIF_STATUS_1_PA_C_BIT_NUMBER(ip), \
		MASK_UNIPERIF_STATUS_1_PA_C_BIT_NUMBER(ip))
#define SET_UNIPERIF_STATUS_1_PA_C_BIT_NUMBER(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_STATUS_1(ip), \
		SHIFT_UNIPERIF_STATUS_1_PA_C_BIT_NUMBER(ip), \
		MASK_UNIPERIF_STATUS_1_PA_C_BIT_NUMBER(ip), value)

/* SAMPLES_PRESENT */
#define SHIFT_UNIPERIF_STATUS_1_SAMPLES_PRESENT(ip) 24
#define MASK_UNIPERIF_STATUS_1_SAMPLES_PRESENT(ip) 0x7f
#define GET_UNIPERIF_STATUS_1_SAMPLES_PRESENT(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_STATUS_1(ip), \
		SHIFT_UNIPERIF_STATUS_1_SAMPLES_PRESENT(ip), \
		MASK_UNIPERIF_STATUS_1_SAMPLES_PRESENT(ip))
#define SET_UNIPERIF_STATUS_1_SAMPLES_PRESENT(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_STATUS_1(ip), \
		SHIFT_UNIPERIF_STATUS_1_SAMPLES_PRESENT(ip), \
		MASK_UNIPERIF_STATUS_1_SAMPLES_PRESENT(ip), value)

/*
 * AUD_UNIPERIF_CHANNEL_STA_REGN
 */

#define OFFSET_UNIPERIF_CHANNEL_STA_REGN(ip, n) (0x0060 + (4 * n))
#define GET_UNIPERIF_CHANNEL_STA_REGN(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_CHANNEL_STA_REGN(ip, n))
#define SET_UNIPERIF_CHANNEL_STA_REGN(ip, n, value) \
	writel_relaxed(value, ip->base + \
			OFFSET_UNIPERIF_CHANNEL_STA_REGN(ip, n))

#define OFFSET_UNIPERIF_CHANNEL_STA_REG0(ip) 0x0060
#define GET_UNIPERIF_CHANNEL_STA_REG0(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_CHANNEL_STA_REG0(ip))
#define SET_UNIPERIF_CHANNEL_STA_REG0(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_CHANNEL_STA_REG0(ip))

#define OFFSET_UNIPERIF_CHANNEL_STA_REG1(ip) 0x0064
#define GET_UNIPERIF_CHANNEL_STA_REG1(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_CHANNEL_STA_REG1(ip))
#define SET_UNIPERIF_CHANNEL_STA_REG1(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_CHANNEL_STA_REG1(ip))

#define OFFSET_UNIPERIF_CHANNEL_STA_REG2(ip) 0x0068
#define GET_UNIPERIF_CHANNEL_STA_REG2(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_CHANNEL_STA_REG2(ip))
#define SET_UNIPERIF_CHANNEL_STA_REG2(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_CHANNEL_STA_REG2(ip))

#define OFFSET_UNIPERIF_CHANNEL_STA_REG3(ip) 0x006C
#define GET_UNIPERIF_CHANNEL_STA_REG3(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_CHANNEL_STA_REG3(ip))
#define SET_UNIPERIF_CHANNEL_STA_REG3(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_CHANNEL_STA_REG3(ip))

#define OFFSET_UNIPERIF_CHANNEL_STA_REG4(ip) 0x0070
#define GET_UNIPERIF_CHANNEL_STA_REG4(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_CHANNEL_STA_REG4(ip))
#define SET_UNIPERIF_CHANNEL_STA_REG4(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_CHANNEL_STA_REG4(ip))

#define OFFSET_UNIPERIF_CHANNEL_STA_REG5(ip) 0x0074
#define GET_UNIPERIF_CHANNEL_STA_REG5(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_CHANNEL_STA_REG5(ip))
#define SET_UNIPERIF_CHANNEL_STA_REG5(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_CHANNEL_STA_REG5(ip))

/*
 * AUD_UNIPERIF_USER_VALIDITY
 */

#define OFFSET_UNIPERIF_USER_VALIDITY(ip) 0x0090
#define GET_UNIPERIF_USER_VALIDITY(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_USER_VALIDITY(ip))
#define SET_UNIPERIF_USER_VALIDITY(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_USER_VALIDITY(ip))

/* VALIDITY_LEFT */
#define SHIFT_UNIPERIF_USER_VALIDITY_VALIDITY_LEFT(ip) 0
#define MASK_UNIPERIF_USER_VALIDITY_VALIDITY_LEFT(ip) 0x1
#define GET_UNIPERIF_USER_VALIDITY_VALIDITY_LEFT(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_USER_VALIDITY(ip), \
		SHIFT_UNIPERIF_USER_VALIDITY_VALIDITY_LEFT(ip), \
		MASK_UNIPERIF_USER_VALIDITY_VALIDITY_LEFT(ip))
#define SET_UNIPERIF_USER_VALIDITY_VALIDITY_LEFT(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_USER_VALIDITY(ip), \
		SHIFT_UNIPERIF_USER_VALIDITY_VALIDITY_LEFT(ip), \
		MASK_UNIPERIF_USER_VALIDITY_VALIDITY_LEFT(ip), value)

/* VALIDITY_RIGHT */
#define SHIFT_UNIPERIF_USER_VALIDITY_VALIDITY_RIGHT(ip) 1
#define MASK_UNIPERIF_USER_VALIDITY_VALIDITY_RIGHT(ip) 0x1
#define GET_UNIPERIF_USER_VALIDITY_VALIDITY_RIGHT(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_USER_VALIDITY(ip), \
		SHIFT_UNIPERIF_USER_VALIDITY_VALIDITY_RIGHT(ip), \
		MASK_UNIPERIF_USER_VALIDITY_VALIDITY_RIGHT(ip))
#define SET_UNIPERIF_USER_VALIDITY_VALIDITY_RIGHT(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_USER_VALIDITY(ip), \
		SHIFT_UNIPERIF_USER_VALIDITY_VALIDITY_RIGHT(ip), \
		MASK_UNIPERIF_USER_VALIDITY_VALIDITY_RIGHT(ip), value)

/* USER_LEFT */
#define SHIFT_UNIPERIF_USER_VALIDITY_USER_LEFT(ip) 2
#define MASK_UNIPERIF_USER_VALIDITY_USER_LEFT(ip) 0x1
#define GET_UNIPERIF_USER_VALIDITY_USER_LEFT(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_USER_VALIDITY(ip), \
		SHIFT_UNIPERIF_USER_VALIDITY_USER_LEFT(ip), \
		MASK_UNIPERIF_USER_VALIDITY_USER_LEFT(ip))
#define SET_UNIPERIF_USER_VALIDITY_USER_LEFT(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_USER_VALIDITY(ip), \
		SHIFT_UNIPERIF_USER_VALIDITY_USER_LEFT(ip), \
		MASK_UNIPERIF_USER_VALIDITY_USER_LEFT(ip), value)

/* USER_RIGHT */
#define SHIFT_UNIPERIF_USER_VALIDITY_USER_RIGHT(ip) 3
#define MASK_UNIPERIF_USER_VALIDITY_USER_RIGHT(ip) 0x1
#define GET_UNIPERIF_USER_VALIDITY_USER_RIGHT(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_USER_VALIDITY(ip), \
		SHIFT_UNIPERIF_USER_VALIDITY_USER_RIGHT(ip), \
		MASK_UNIPERIF_USER_VALIDITY_USER_RIGHT(ip))
#define SET_UNIPERIF_USER_VALIDITY_USER_RIGHT(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_USER_VALIDITY(ip), \
		SHIFT_UNIPERIF_USER_VALIDITY_USER_RIGHT(ip), \
		MASK_UNIPERIF_USER_VALIDITY_USER_RIGHT(ip), value)

/*
 * UNIPERIF_DFV0
 */

#define OFFSET_UNIPERIF_DFV0(ip) 0x0100
#define GET_UNIPERIF_DFV0(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_DFV0(ip))
#define SET_UNIPERIF_DFV0(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_DFV0(ip))

/* ITS_BSET_ENABLE */
#define SHIFT_UNIPERIF_DFV0_ITS_BSET(ip) 0x0
#define MASK_UNIPERIF_DFV0_ITS_BSET(ip) 0x1
#define SET_UNIPERIF_DFV0_ITS_BSET_ENABLE(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_SOFT_RST(ip), \
		SHIFT_UNIPERIF_DFV0_ITS_BSET(ip), \
		MASK_UNIPERIF_DFV0_ITS_BSET(ip), 1)
#define SET_UNIPERIF_DFV0_ITS_BSET_DISABLE(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_SOFT_RST(ip), \
		SHIFT_UNIPERIF_DFV0_ITS_BSET(ip), \
		MASK_UNIPERIF_DFV0_ITS_BSET(ip), 0)

/* STANDBY_MODE_DEBUG_ENABLE */
#define SHIFT_UNIPERIF_DFV0_STANDBY_MODE_DEBUG(ip) \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? -1 : 1)
#define MASK_UNIPERIF_DFV0_STANDBY_MODE_DEBUG(ip) 0x1
#define SET_UNIPERIF_DFV0_STANDBY_MODE_DEBUG_ENABLE(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_SOFT_RST(ip), \
		SHIFT_UNIPERIF_DFV0_STANDBY_MODE_DEBUG(ip), \
		MASK_UNIPERIF_DFV0_STANDBY_MODE_DEBUG(ip), 1)
#define SET_UNIPERIF_DFV0_STANDBY_MODE_DEBUG_DISABLE(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_SOFT_RST(ip), \
		SHIFT_UNIPERIF_DFV0_STANDBY_MODE_DEBUG(ip), \
		MASK_UNIPERIF_DFV0_STANDBY_MODE_DEBUG(ip), 0)

/*
 * UNIPERIF_CONTROLABILITY
 */

#define OFFSET_UNIPERIF_CONTROLABILITY(ip) 0x0104
#define GET_UNIPERIF_CONTROLABILITY(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_CONTROLABILITY(ip))
#define SET_UNIPERIF_CONTROLABILITY(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_CONTROLABILITY(ip))

/* EN_PATTERN_GEN */
#define SHIFT_UNIPERIF_CONTROLABILITY_EN_PATTERN_GEN(ip) 0
#define MASK_UNIPERIF_CONTROLABILITY_EN_PATTERN_GEN(ip) 1
#define GET_UNIPERIF_CONTROLABILITY_EN_PATTERN_GEN(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONTROLABILITY(ip), \
		SHIFT_UNIPERIF_CONTROLABILITY_EN_PATTERN_GEN(ip), \
		MASK_UNIPERIF_CONTROLABILITY_EN_PATTERN_GEN(ip))
#define SET_UNIPERIF_CONTROLABILITY_EN_PATTERN_GEN_ENABLE(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONTROLABILITY(ip), \
		SHIFT_UNIPERIF_CONTROLABILITY_EN_PATTERN_GEN(ip), \
		MASK_UNIPERIF_CONTROLABILITY_EN_PATTERN_GEN(ip), 1)
#define SET_UNIPERIF_CONTROLABILITY_EN_PATTERN_GEN_DISABLE(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONTROLABILITY(ip), \
		SHIFT_UNIPERIF_CONTROLABILITY_EN_PATTERN_GEN(ip), \
		MASK_UNIPERIF_CONTROLABILITY_EN_PATTERN_GEN(ip), 0)

/* DAC_CHARACTERIZATION */
#define SHIFT_UNIPERIF_CONTROLABILITY_DAC_CHARACTERIZATION(ip) 4
#define MASK_UNIPERIF_CONTROLABILITY_DAC_CHARACTERIZATION(ip) 0xf
#define GET_UNIPERIF_CONTROLABILITY_DAC_CHARACTERIZATION(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONTROLABILITY(ip), \
		SHIFT_UNIPERIF_CONTROLABILITY_DAC_CHARACTERIZATION(ip), \
		MASK_UNIPERIF_CONTROLABILITY_DAC_CHARACTERIZATION(ip))
#define SET_UNIPERIF_CONTROLABILITY_DAC_CHARACTERIZATION(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CONTROLABILITY(ip), \
		SHIFT_UNIPERIF_CONTROLABILITY_DAC_CHARACTERIZATION(ip), \
		MASK_UNIPERIF_CONTROLABILITY_DAC_CHARACTERIZATION(ip), \
		value)

/*
 * UNIPERIF_CRC_CTRL
 */

#define OFFSET_UNIPERIF_CRC_CTRL(ip) 0x0108
#define GET_UNIPERIF_CRC_CTRL(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_CRC_CTRL(ip))
#define SET_UNIPERIF_CRC_CTRL(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_CRC_CTRL(ip))

/* EN_CRC_INPUT */
#define SHIFT_UNIPERIF_CRC_CONTROL_EN_CRC_INPUT(ip) 0
#define MASK_UNIPERIF_CRC_CONTROL_EN_CRC_INPUT(ip) 1
#define GET_UNIPERIF_CRC_CONTROL_EN_CRC_INPUT(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CRC_CONTROL(ip), \
		SHIFT_UNIPERIF_CRC_CONTROL_EN_CRC_INPUT(ip), \
		MASK_UNIPERIF_CRC_CONTROL_EN_CRC_INPUT(ip))
#define SET_UNIPERIF_CRC_CONTROL_EN_CRC_INPUT_ENABLE(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CRC_CONTROL(ip), \
		SHIFT_UNIPERIF_CRC_CONTROL_EN_CRC_INPUT(ip), \
		MASK_UNIPERIF_CRC_CONTROL_EN_CRC_INPUT(ip), 1)
#define SET_UNIPERIF_CRC_CONTROL_EN_CRC_INPUT_DISABLE(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CRC_CONTROL(ip), \
		SHIFT_UNIPERIF_CRC_CONTROL_EN_CRC_INPUT(ip), \
		MASK_UNIPERIF_CRC_CONTROL_EN_CRC_INPUT(ip), 0)

/* EN_CRC_OUTPUT */
#define SHIFT_UNIPERIF_CRC_CONTROL_EN_CRC_OUTPUT(ip) 1
#define MASK_UNIPERIF_CRC_CONTROL_EN_CRC_OUTPUT(ip) 1
#define GET_UNIPERIF_CRC_CONTROL_EN_CRC_OUTPUT(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CRC_CONTROL(ip), \
		SHIFT_UNIPERIF_CRC_CONTROL_EN_CRC_OUTPUT(ip), \
		MASK_UNIPERIF_CRC_CONTROL_EN_CRC_OUTPUT(ip))
#define SET_UNIPERIF_CRC_CONTROL_EN_CRC_OUTPUT_ENABLE(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CRC_CONTROL(ip), \
		SHIFT_UNIPERIF_CRC_CONTROL_EN_CRC_OUTPUT(ip), \
		MASK_UNIPERIF_CRC_CONTROL_EN_CRC_OUTPUT(ip), 1)
#define SET_UNIPERIF_CRC_CONTROL_EN_CRC_OUTPUT_DISABLE(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CRC_CONTROL(ip), \
		SHIFT_UNIPERIF_CRC_CONTROL_EN_CRC_OUTPUT(ip), \
		MASK_UNIPERIF_CRC_CONTROL_EN_CRC_OUTPUT(ip), 0)

/* CLR_CRC_RES */
#define SHIFT_UNIPERIF_CRC_CONTROL_CLR_CRC_RES(ip)  \
	((ip)->ver < SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0 ? 4 : -1)
#define MASK_UNIPERIF_CRC_CONTROL_CLR_CRC_RES(ip) 1
#define GET_UNIPERIF_CRC_CONTROL_CLR_CRC_RES(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CRC_CONTROL(ip), \
		SHIFT_UNIPERIF_CRC_CONTROL_CLR_CRC_RES(ip), \
		MASK_UNIPERIF_CRC_CONTROL_CLR_CRC_RES(ip))
#define SET_UNIPERIF_CRC_CONTROL_CLR_CRC_RES(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CRC_CONTROL(ip), \
		SHIFT_UNIPERIF_CRC_CONTROL_CLR_CRC_RES(ip), \
		MASK_UNIPERIF_CRC_CONTROL_CLR_CRC_RES(ip), 1)

/*
 * UNIPERIF_CRC_WINDOW
 */

#define OFFSET_UNIPERIF_CRC_WINDOW(ip) 0x010c
#define GET_UNIPERIF_CRC_WINDOW(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_CRC_WINDOW(ip))
#define SET_UNIPERIF_CRC_WINDOW(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_CRC_WINDOW(ip))

/* NUM_SAMPLES */
#define SHIFT_UNIPERIF_CRC_WINDOW_NUM_SAMPLES(ip) 0
#define MASK_UNIPERIF_CRC_WINDOW_NUM_SAMPLES(ip) 0xffffff
#define GET_UNIPERIF_CRC_WINDOW_NUM_SAMPLES(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CRC_WINDOW(ip), \
		SHIFT_UNIPERIF_CRC_WINDOW_NUM_SAMPLES(ip), \
		MASK_UNIPERIF_CRC_WINDOW_NUM_SAMPLES(ip))
#define SET_UNIPERIF_CRC_WINDOW_NUM_SAMPLES(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CRC_WINDOW(ip), \
		SHIFT_UNIPERIF_CRC_WINDOW_NUM_SAMPLES(ip), \
		MASK_UNIPERIF_CRC_WINDOW_NUM_SAMPLES(ip), value)

/*
 * UNIPERIF_CRC_VALUE_IN
 */

#define OFFSET_UNIPERIF_CRC_VALUE_IN(ip) 0x0110
#define GET_UNIPERIF_CRC_VALUE_IN(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_CRC_VALUE_IN(ip))
#define SET_UNIPERIF_CRC_VALUE_IN(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_CRC_VALUE_IN(ip))

/*
 * UNIPERIF_CRC_VALUE_OUT
 */

#define OFFSET_UNIPERIF_CRC_VALUE_OUT(ip) 0x0114
#define GET_UNIPERIF_CRC_VALUE_OUT(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_CRC_VALUE_OUT(ip))
#define SET_UNIPERIF_CRC_VALUE_OUT(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_CRC_VALUE_OUT(ip))

/*
 * UNIPERIF_CRC_VALUE_OUT
 */

#define OFFSET_UNIPERIF_CRC_VALUE_OUT(ip) 0x0114
#define GET_UNIPERIF_CRC_VALUE_OUT(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_CRC_VALUE_OUT(ip))
#define SET_UNIPERIF_CRC_VALUE_OUT(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_CRC_VALUE_OUT(ip))

/*
 * AUD_UNIPERIF_TDM_ENABLE
 */

#define OFFSET_UNIPERIF_TDM_ENABLE(ip) 0x0118
#define GET_UNIPERIF_TDM_ENABLE(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_TDM_ENABLE(ip))
#define SET_UNIPERIF_TDM_ENABLE(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_TDM_ENABLE(ip))

/* TDM_ENABLE */
#define SHIFT_UNIPERIF_TDM_ENABLE_TDM_ENABLE(ip) 0x0
#define MASK_UNIPERIF_TDM_ENABLE_TDM_ENABLE(ip) 0x1
#define GET_UNIPERIF_TDM_ENABLE_TDM_ENABLE(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_ENABLE(ip), \
		SHIFT_UNIPERIF_TDM_ENABLE_TDM_ENABLE(ip), \
		MASK_UNIPERIF_TDM_ENABLE_TDM_ENABLE(ip))
#define SET_UNIPERIF_TDM_ENABLE_TDM_ENABLE(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_ENABLE(ip), \
		SHIFT_UNIPERIF_TDM_ENABLE_TDM_ENABLE(ip), \
		MASK_UNIPERIF_TDM_ENABLE_TDM_ENABLE(ip), 1)
#define SET_UNIPERIF_TDM_ENABLE_TDM_DISABLE(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_ENABLE(ip), \
		SHIFT_UNIPERIF_TDM_ENABLE_TDM_ENABLE(ip), \
		MASK_UNIPERIF_TDM_ENABLE_TDM_ENABLE(ip), 0)

/*
 * AUD_UNIPERIF_TDM_FS_REF_FREQ
 */

#define OFFSET_UNIPERIF_TDM_FS_REF_FREQ(ip) 0x011c
#define GET_UNIPERIF_TDM_FS_REF_FREQ(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_TDM_FS_REF_FREQ(ip))
#define SET_UNIPERIF_TDM_FS_REF_FREQ(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_TDM_FS_REF_FREQ(ip))

/* REF_FREQ */
#define SHIFT_UNIPERIF_TDM_FS_REF_FREQ_REF_FREQ(ip) 0x0
#define VALUE_UNIPERIF_TDM_FS_REF_FREQ_8KHZ(ip) 0
#define VALUE_UNIPERIF_TDM_FS_REF_FREQ_16KHZ(ip) 1
#define VALUE_UNIPERIF_TDM_FS_REF_FREQ_32KHZ(ip) 2
#define MASK_UNIPERIF_TDM_FS_REF_FREQ_REF_FREQ(ip) 0x3
#define GET_UNIPERIF_TDM_FS_REF_FREQ_REF_FREQ(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_FS_REF_FREQ(ip), \
		SHIFT_UNIPERIF_TDM_FS_REF_FREQ_REF_FREQ(ip), \
		MASK_UNIPERIF_TDM_FS_REF_FREQ_REF_FREQ(ip))
#define SET_UNIPERIF_TDM_FS_REF_FREQ_8KHZ(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_FS_REF_FREQ(ip), \
		SHIFT_UNIPERIF_TDM_FS_REF_FREQ_REF_FREQ(ip), \
		MASK_UNIPERIF_TDM_FS_REF_FREQ_REF_FREQ(ip), \
		VALUE_UNIPERIF_TDM_FS_REF_FREQ_8KHZ(ip))
#define SET_UNIPERIF_TDM_FS_REF_FREQ_16KHZ(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_FS_REF_FREQ(ip), \
		SHIFT_UNIPERIF_TDM_FS_REF_FREQ_REF_FREQ(ip), \
		MASK_UNIPERIF_TDM_FS_REF_FREQ_REF_FREQ(ip), \
		VALUE_UNIPERIF_TDM_FS_REF_FREQ_16KHZ(ip))
#define SET_UNIPERIF_TDM_FS_REF_FREQ_32KHZ(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_FS_REF_FREQ(ip), \
		SHIFT_UNIPERIF_TDM_FS_REF_FREQ_REF_FREQ(ip), \
		MASK_UNIPERIF_TDM_FS_REF_FREQ_REF_FREQ(ip), \
		VALUE_UNIPERIF_TDM_FS_REF_FREQ_32KHZ(ip))

/*
 * AUD_UNIPERIF_TDM_FS_REF_DIV
 */

#define OFFSET_UNIPERIF_TDM_FS_REF_DIV(ip) 0x0120
#define GET_UNIPERIF_TDM_FS_REF_DIV(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_TDM_FS_REF_DIV(ip))
#define SET_UNIPERIF_TDM_FS_REF_DIV(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_TDM_FS_REF_DIV(ip))

/* NUM_TIMESLOT */
#define SHIFT_UNIPERIF_TDM_FS_REF_DIV_NUM_TIMESLOT(ip) 0x0
#define MASK_UNIPERIF_TDM_FS_REF_DIV_NUM_TIMESLOT(ip) 0xff
#define GET_UNIPERIF_TDM_FS_REF_DIV_NUM_TIMESLOT(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_FS_REF_DIV(ip), \
		SHIFT_UNIPERIF_TDM_FS_REF_DIV_NUM_TIMESLOT(ip), \
		MASK_UNIPERIF_TDM_FS_REF_DIV_NUM_TIMESLOT(ip))
#define SET_UNIPERIF_TDM_FS_REF_DIV_NUM_TIMESLOT(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_FS_REF_DIV(ip), \
		SHIFT_UNIPERIF_TDM_FS_REF_DIV_NUM_TIMESLOT(ip), \
		MASK_UNIPERIF_TDM_FS_REF_DIV_NUM_TIMESLOT(ip), value)

/*
 * AUD_UNIPERIF_TDM_FS01_FREQ
 */

#define OFFSET_UNIPERIF_TDM_FS01_FREQ(ip) 0x0124
#define GET_UNIPERIF_TDM_FS01_FREQ(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_TDM_FS01_FREQ(ip))
#define SET_UNIPERIF_TDM_FS01_FREQ(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_TDM_FS01_FREQ(ip))

/* FS01_FREQ */
#define SHIFT_UNIPERIF_TDM_FS01_FREQ_FS01_FREQ(ip) 0x0
#define VALUE_UNIPERIF_TDM_FS01_FREQ_8KHZ(ip) 0
#define VALUE_UNIPERIF_TDM_FS01_FREQ_16KHZ(ip) 1
#define MASK_UNIPERIF_TDM_FS01_FREQ_FS01_FREQ(ip) 0x1
#define GET_UNIPERIF_TDM_FS01_FREQ_FS01_FREQ(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_FS01_FREQ(ip), \
		SHIFT_UNIPERIF_TDM_FS01_FREQ_FS01_FREQ(ip), \
		MASK_UNIPERIF_TDM_FS01_FREQ_FS01_FREQ(ip))
#define SET_UNIPERIF_TDM_FS01_FREQ_8KHZ(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_FS01_FREQ(ip), \
		SHIFT_UNIPERIF_TDM_FS01_FREQ_FS01_FREQ(ip), \
		MASK_UNIPERIF_TDM_FS01_FREQ_FS01_FREQ(ip), \
		VALUE_UNIPERIF_TDM_FS01_FREQ_8KHZ(ip))
#define SET_UNIPERIF_TDM_FS01_FREQ_16KHZ(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_FS01_FREQ(ip), \
		SHIFT_UNIPERIF_TDM_FS01_FREQ_FS01_FREQ(ip), \
		MASK_UNIPERIF_TDM_FS01_FREQ_FS01_FREQ(ip), \
		VALUE_UNIPERIF_TDM_FS01_FREQ_16KHZ(ip))

/*
 * AUD_UNIPERIF_TDM_FS01_WIDTH
 */

#define OFFSET_UNIPERIF_TDM_FS01_WIDTH(ip) 0x0128
#define GET_UNIPERIF_TDM_FS01_WIDTH(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_TDM_FS01_WIDTH(ip))
#define SET_UNIPERIF_TDM_FS01_WIDTH(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_TDM_FS01_WIDTH(ip))

/* FS01_WIDTH */
#define SHIFT_UNIPERIF_TDM_FS01_WIDTH_FS01_WIDTH(ip) 0x0
#define VALUE_UNIPERIF_TDM_FS01_WIDTH_I2S(ip) 0
#define VALUE_UNIPERIF_TDM_FS01_WIDTH_1BIT(ip) 1
#define VALUE_UNIPERIF_TDM_FS01_WIDTH_8BIT(ip) 2
#define VALUE_UNIPERIF_TDM_FS01_WIDTH_16BIT(ip) 3
#define VALUE_UNIPERIF_TDM_FS01_WIDTH_32BIT(ip) 4
#define MASK_UNIPERIF_TDM_FS01_WIDTH_FS01_WIDTH(ip) 0x7
#define GET_UNIPERIF_TDM_FS01_WIDTH_FS01_WIDTH(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_FS01_WIDTH(ip), \
		SHIFT_UNIPERIF_TDM_FS01_WIDTH_FS01_WIDTH(ip), \
		MASK_UNIPERIF_TDM_FS01_WIDTH_FS01_WIDTH(ip))
#define SET_UNIPERIF_TDM_FS01_WIDTH_I2S(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_FS01_WIDTH(ip), \
		SHIFT_UNIPERIF_TDM_FS01_WIDTH_FS01_WIDTH(ip), \
		MASK_UNIPERIF_TDM_FS01_WIDTH_FS01_WIDTH(ip), \
		VALUE_UNIPERIF_TDM_FS01_WIDTH_I2S(ip))
#define SET_UNIPERIF_TDM_FS01_WIDTH_1BIT(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_FS01_WIDTH(ip), \
		SHIFT_UNIPERIF_TDM_FS01_WIDTH_FS01_WIDTH(ip), \
		MASK_UNIPERIF_TDM_FS01_WIDTH_FS01_WIDTH(ip), \
		VALUE_UNIPERIF_TDM_FS01_WIDTH_1BIT(ip))
#define SET_UNIPERIF_TDM_FS01_WIDTH_8BIT(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_FS01_WIDTH(ip), \
		SHIFT_UNIPERIF_TDM_FS01_WIDTH_FS01_WIDTH(ip), \
		MASK_UNIPERIF_TDM_FS01_WIDTH_FS01_WIDTH(ip), \
		VALUE_UNIPERIF_TDM_FS01_WIDTH_8BIT(ip))
#define SET_UNIPERIF_TDM_FS01_WIDTH_16BIT(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_FS01_WIDTH(ip), \
		SHIFT_UNIPERIF_TDM_FS01_WIDTH_FS01_WIDTH(ip), \
		MASK_UNIPERIF_TDM_FS01_WIDTH_FS01_WIDTH(ip), \
		VALUE_UNIPERIF_TDM_FS01_WIDTH_16BIT(ip))
#define SET_UNIPERIF_TDM_FS01_WIDTH_32BIT(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_FS01_WIDTH(ip), \
		SHIFT_UNIPERIF_TDM_FS01_WIDTH_FS01_WIDTH(ip), \
		MASK_UNIPERIF_TDM_FS01_WIDTH_FS01_WIDTH(ip), \
		VALUE_UNIPERIF_TDM_FS01_WIDTH_32BIT(ip))

/*
 * AUD_UNIPERIF_TDM_FS02_FREQ
 */

#define OFFSET_UNIPERIF_TDM_FS02_FREQ(ip) 0x012c
#define GET_UNIPERIF_TDM_FS02_FREQ(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_TDM_FS02_FREQ(ip))
#define SET_UNIPERIF_TDM_FS02_FREQ(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_TDM_FS02_FREQ(ip))

/* FS02_FREQ */
#define SHIFT_UNIPERIF_TDM_FS02_FREQ_FS02_FREQ(ip) 0x0
#define VALUE_UNIPERIF_TDM_FS02_FREQ_8KHZ(ip) 0
#define VALUE_UNIPERIF_TDM_FS02_FREQ_16KHZ(ip) 1
#define MASK_UNIPERIF_TDM_FS02_FREQ_FS02_FREQ(ip) 0x1
#define GET_UNIPERIF_TDM_FS02_FREQ_FS02_FREQ(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_FS02_FREQ(ip), \
		SHIFT_UNIPERIF_TDM_FS02_FREQ_FS02_FREQ(ip), \
		MASK_UNIPERIF_TDM_FS02_FREQ_FS02_FREQ(ip))
#define SET_UNIPERIF_TDM_FS02_FREQ_8KHZ(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_FS02_FREQ(ip), \
		SHIFT_UNIPERIF_TDM_FS02_FREQ_FS02_FREQ(ip), \
		MASK_UNIPERIF_TDM_FS02_FREQ_FS02_FREQ(ip), \
		VALUE_UNIPERIF_TDM_FS02_FREQ_8KHZ(ip))
#define SET_UNIPERIF_TDM_FS02_FREQ_16KHZ(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_FS02_FREQ(ip), \
		SHIFT_UNIPERIF_TDM_FS02_FREQ_FS02_FREQ(ip), \
		MASK_UNIPERIF_TDM_FS02_FREQ_FS02_FREQ(ip), \
		VALUE_UNIPERIF_TDM_FS02_FREQ_16KHZ(ip))

/*
 * AUD_UNIPERIF_TDM_FS02_WIDTH
 */

#define OFFSET_UNIPERIF_TDM_FS02_WIDTH(ip) 0x0130
#define GET_UNIPERIF_TDM_FS02_WIDTH(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_TDM_FS02_WIDTH(ip))
#define SET_UNIPERIF_TDM_FS02_WIDTH(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_TDM_FS02_WIDTH(ip))

/* FS02_WIDTH */
#define SHIFT_UNIPERIF_TDM_FS02_WIDTH_FS02_WIDTH(ip) 0x0
#define VALUE_UNIPERIF_TDM_FS02_WIDTH_I2S(ip) 0
#define VALUE_UNIPERIF_TDM_FS02_WIDTH_1BIT(ip) 1
#define VALUE_UNIPERIF_TDM_FS02_WIDTH_8BIT(ip) 2
#define VALUE_UNIPERIF_TDM_FS02_WIDTH_16BIT(ip) 3
#define VALUE_UNIPERIF_TDM_FS02_WIDTH_32BIT(ip) 4
#define MASK_UNIPERIF_TDM_FS02_WIDTH_FS02_WIDTH(ip) 0x7
#define GET_UNIPERIF_TDM_FS02_WIDTH_FS02_WIDTH(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_FS02_WIDTH(ip), \
		SHIFT_UNIPERIF_TDM_FS02_WIDTH_FS02_WIDTH(ip), \
		MASK_UNIPERIF_TDM_FS02_WIDTH_FS02_WIDTH(ip))
#define SET_UNIPERIF_TDM_FS02_WIDTH_I2S(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_FS02_WIDTH(ip), \
		SHIFT_UNIPERIF_TDM_FS02_WIDTH_FS02_WIDTH(ip), \
		MASK_UNIPERIF_TDM_FS02_WIDTH_FS02_WIDTH(ip), \
		VALUE_UNIPERIF_TDM_FS02_WIDTH_I2S(ip))
#define SET_UNIPERIF_TDM_FS02_WIDTH_1BIT(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_FS02_WIDTH(ip), \
		SHIFT_UNIPERIF_TDM_FS02_WIDTH_FS02_WIDTH(ip), \
		MASK_UNIPERIF_TDM_FS02_WIDTH_FS02_WIDTH(ip), \
		VALUE_UNIPERIF_TDM_FS02_WIDTH_1BIT(ip))
#define SET_UNIPERIF_TDM_FS02_WIDTH_8BIT(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_FS02_WIDTH(ip), \
		SHIFT_UNIPERIF_TDM_FS02_WIDTH_FS02_WIDTH(ip), \
		MASK_UNIPERIF_TDM_FS02_WIDTH_FS02_WIDTH(ip), \
		VALUE_UNIPERIF_TDM_FS02_WIDTH_8BIT(ip))
#define SET_UNIPERIF_TDM_FS02_WIDTH_16BIT(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_FS02_WIDTH(ip), \
		SHIFT_UNIPERIF_TDM_FS02_WIDTH_FS02_WIDTH(ip), \
		MASK_UNIPERIF_TDM_FS02_WIDTH_FS02_WIDTH(ip), \
		VALUE_UNIPERIF_TDM_FS02_WIDTH_16BIT(ip))
#define SET_UNIPERIF_TDM_FS02_WIDTH_32BIT(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_FS02_WIDTH(ip), \
		SHIFT_UNIPERIF_TDM_FS02_WIDTH_FS02_WIDTH(ip), \
		MASK_UNIPERIF_TDM_FS02_WIDTH_FS02_WIDTH(ip), \
		VALUE_UNIPERIF_TDM_FS02_WIDTH_32BIT(ip))

/*
 * AUD_UNIPERIF_TDM_FS02_TIMESLOT_DELAY
 */

#define OFFSET_UNIPERIF_TDM_FS02_TIMESLOT_DELAY(ip) 0x0134
#define GET_UNIPERIF_TDM_FS02_TIMESLOT_DELAY(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_TDM_FS02_TIMESLOT_DELAY(ip))
#define SET_UNIPERIF_TDM_FS02_TIMESLOT_DELAY(ip, value) \
	writel_relaxed(value, ip->base + \
		OFFSET_UNIPERIF_TDM_FS02_TIMESLOT_DELAY(ip))

/* PCM_CLOCK */
#define SHIFT_UNIPERIF_TDM_FS02_TIMESLOT_DELAY_PCM_CLOCK(ip) 0x0
#define MASK_UNIPERIF_TDM_FS02_TIMESLOT_DELAY_PCM_CLOCK(ip) 0xf
#define GET_UNIPERIF_TDM_FS02_TIMESLOT_DELAY_PCM_CLOCK(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_FS02_TIMESLOT_DELAY(ip), \
		SHIFT_UNIPERIF_TDM_FS02_TIMESLOT_DELAY_PCM_CLOCK(ip), \
		MASK_UNIPERIF_TDM_FS02_TIMESLOT_DELAY_PCM_CLOCK(ip))
#define SET_UNIPERIF_TDM_FS02_TIMESLOT_DELAY_PCM_CLOCK(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_FS02_TIMESLOT_DELAY(ip), \
		SHIFT_UNIPERIF_TDM_FS02_TIMESLOT_DELAY_PCM_CLOCK(ip), \
		MASK_UNIPERIF_TDM_FS02_TIMESLOT_DELAY_PCM_CLOCK(ip), \
		value)

/* TIMESLOT */
#define SHIFT_UNIPERIF_TDM_FS02_TIMESLOT_DELAY_TIMESLOT(ip) 0x4
#define MASK_UNIPERIF_TDM_FS02_TIMESLOT_DELAY_TIMESLOT(ip) 0xff
#define GET_UNIPERIF_TDM_FS02_TIMESLOT_DELAY_TIMESLOT(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_FS02_TIMESLOT_DELAY(ip), \
		SHIFT_UNIPERIF_TDM_FS02_TIMESLOT_DELAY_TIMESLOT(ip), \
		MASK_UNIPERIF_TDM_FS02_TIMESLOT_DELAY_TIMESLOT(ip))
#define SET_UNIPERIF_TDM_FS02_TIMESLOT_DELAY_TIMESLOT(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_FS02_TIMESLOT_DELAY(ip), \
		SHIFT_UNIPERIF_TDM_FS02_TIMESLOT_DELAY_TIMESLOT(ip), \
		MASK_UNIPERIF_TDM_FS02_TIMESLOT_DELAY_TIMESLOT(ip), \
		value)

/*
 * AUD_UNIPERIF_TDM_DATA_MSBIT_START
 */

#define OFFSET_UNIPERIF_TDM_DATA_MSBIT_START(ip) 0x0138
#define GET_UNIPERIF_TDM_DATA_MSBIT_START(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_TDM_DATA_MSBIT_START(ip))
#define SET_UNIPERIF_TDM_DATA_MSBIT_START(ip, value) \
	writel_relaxed(value, ip->base + \
		OFFSET_UNIPERIF_TDM_DATA_MSBIT_START(ip))

/* DELAY */
#define SHIFT_UNIPERIF_TDM_DATA_MSBIT_START_DELAY(ip) 0x0
#define MASK_UNIPERIF_TDM_DATA_MSBIT_START_DELAY(ip) 0x7
#define GET_UNIPERIF_TDM_DATA_MSBIT_START_DELAY(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_DATA_MSBIT_START(ip), \
		SHIFT_UNIPERIF_TDM_DATA_MSBIT_START_DELAY(ip), \
		MASK_UNIPERIF_TDM_DATA_MSBIT_START_DELAY(ip))
#define SET_UNIPERIF_TDM_DATA_MSBIT_START_DELAY(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_DATA_MSBIT_START(ip), \
		SHIFT_UNIPERIF_TDM_DATA_MSBIT_START_DELAY(ip), \
		MASK_UNIPERIF_TDM_DATA_MSBIT_START_DELAY(ip), value)

/*
 * AUD_UNIPERIF_TDM_WORD_POS_1_2
 */

#define OFFSET_UNIPERIF_TDM_WORD_POS_1_2(ip) 0x013c
#define GET_UNIPERIF_TDM_WORD_POS_1_2(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_TDM_WORD_POS_1_2(ip))
#define SET_UNIPERIF_TDM_WORD_POS_1_2(ip, value) \
	writel_relaxed(value, ip->base + \
		OFFSET_UNIPERIF_TDM_WORD_POS_1_2(ip))

/* TS_1_MSB */
#define SHIFT_UNIPERIF_TDM_WORD_POS_1_2_TS_1_MSB(ip) 0x0
#define MASK_UNIPERIF_TDM_WORD_POS_1_2_TS_1_MSB(ip) 0x7f
#define GET_UNIPERIF_TDM_WORD_POS_1_2_TS_1_MSB(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_WORD_POS_1_2(ip), \
		SHIFT_UNIPERIF_TDM_WORD_POS_1_2_TS_1_MSB(ip), \
		MASK_UNIPERIF_TDM_WORD_POS_1_2_TS_1_MSB(ip))
#define SET_UNIPERIF_TDM_WORD_POS_1_2_TS_1_MSB(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_WORD_POS_1_2(ip), \
		SHIFT_UNIPERIF_TDM_WORD_POS_1_2_TS_1_MSB(ip), \
		MASK_UNIPERIF_TDM_WORD_POS_1_2_TS_1_MSB(ip), value)

/* TS_1_LSB */
#define SHIFT_UNIPERIF_TDM_WORD_POS_1_2_TS_1_LSB(ip) 0x8
#define MASK_UNIPERIF_TDM_WORD_POS_1_2_TS_1_LSB(ip) 0x7f
#define GET_UNIPERIF_TDM_WORD_POS_1_2_TS_1_LSB(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_WORD_POS_1_2(ip), \
		SHIFT_UNIPERIF_TDM_WORD_POS_1_2_TS_1_LSB(ip), \
		MASK_UNIPERIF_TDM_WORD_POS_1_2_TS_1_LSB(ip))
#define SET_UNIPERIF_TDM_WORD_POS_1_2_TS_1_LSB(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_WORD_POS_1_2(ip), \
		SHIFT_UNIPERIF_TDM_WORD_POS_1_2_TS_1_LSB(ip), \
		MASK_UNIPERIF_TDM_WORD_POS_1_2_TS_1_LSB(ip), value)

/* TS_2_MSB */
#define SHIFT_UNIPERIF_TDM_WORD_POS_1_2_TS_2_MSB(ip) 0x10
#define MASK_UNIPERIF_TDM_WORD_POS_1_2_TS_2_MSB(ip) 0x7f
#define GET_UNIPERIF_TDM_WORD_POS_1_2_TS_2_MSB(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_WORD_POS_1_2(ip), \
		SHIFT_UNIPERIF_TDM_WORD_POS_1_2_TS_2_MSB(ip), \
		MASK_UNIPERIF_TDM_WORD_POS_1_2_TS_2_MSB(ip))
#define SET_UNIPERIF_TDM_WORD_POS_1_2_TS_2_MSB(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_WORD_POS_1_2(ip), \
		SHIFT_UNIPERIF_TDM_WORD_POS_1_2_TS_2_MSB(ip), \
		MASK_UNIPERIF_TDM_WORD_POS_1_2_TS_2_MSB(ip), value)

/* TS_2_LSB */
#define SHIFT_UNIPERIF_TDM_WORD_POS_1_2_TS_2_LSB(ip) 0x18
#define MASK_UNIPERIF_TDM_WORD_POS_1_2_TS_2_LSB(ip) 0x7f
#define GET_UNIPERIF_TDM_WORD_POS_1_2_TS_2_LSB(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_WORD_POS_1_2(ip), \
		SHIFT_UNIPERIF_TDM_WORD_POS_1_2_TS_2_LSB(ip), \
		MASK_UNIPERIF_TDM_WORD_POS_1_2_TS_2_LSB(ip))
#define SET_UNIPERIF_TDM_WORD_POS_1_2_TS_2_LSB(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_WORD_POS_1_2(ip), \
		SHIFT_UNIPERIF_TDM_WORD_POS_1_2_TS_2_LSB(ip), \
		MASK_UNIPERIF_TDM_WORD_POS_1_2_TS_2_LSB(ip), value)

/*
 * AUD_UNIPERIF_TDM_WORD_POS_3_4
 */

#define OFFSET_UNIPERIF_TDM_WORD_POS_3_4(ip) 0x0140
#define GET_UNIPERIF_TDM_WORD_POS_3_4(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_TDM_WORD_POS_3_4(ip))
#define SET_UNIPERIF_TDM_WORD_POS_3_4(ip, value) \
	writel_relaxed(value, ip->base + \
		OFFSET_UNIPERIF_TDM_WORD_POS_3_4(ip))

/* TS_3_MSB */
#define SHIFT_UNIPERIF_TDM_WORD_POS_3_4_TS_3_MSB(ip) 0x0
#define MASK_UNIPERIF_TDM_WORD_POS_3_4_TS_3_MSB(ip) 0x7f
#define GET_UNIPERIF_TDM_WORD_POS_3_4_TS_3_MSB(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_WORD_POS_3_4(ip), \
		SHIFT_UNIPERIF_TDM_WORD_POS_3_4_TS_3_MSB(ip), \
		MASK_UNIPERIF_TDM_WORD_POS_3_4_TS_3_MSB(ip))
#define SET_UNIPERIF_TDM_WORD_POS_3_4_TS_3_MSB(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_WORD_POS_3_4(ip), \
		SHIFT_UNIPERIF_TDM_WORD_POS_3_4_TS_3_MSB(ip), \
		MASK_UNIPERIF_TDM_WORD_POS_3_4_TS_3_MSB(ip), value)

/* TS_3_LSB */
#define SHIFT_UNIPERIF_TDM_WORD_POS_3_4_TS_3_LSB(ip) 0x8
#define MASK_UNIPERIF_TDM_WORD_POS_3_4_TS_3_LSB(ip) 0x7f
#define GET_UNIPERIF_TDM_WORD_POS_3_4_TS_3_LSB(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_WORD_POS_3_4(ip), \
		SHIFT_UNIPERIF_TDM_WORD_POS_3_4_TS_3_LSB(ip), \
		MASK_UNIPERIF_TDM_WORD_POS_3_4_TS_3_LSB(ip))
#define SET_UNIPERIF_TDM_WORD_POS_3_4_TS_3_LSB(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_WORD_POS_3_4(ip), \
		SHIFT_UNIPERIF_TDM_WORD_POS_3_4_TS_3_LSB(ip), \
		MASK_UNIPERIF_TDM_WORD_POS_3_4_TS_3_LSB(ip), value)

/* TS_4_MSB */
#define SHIFT_UNIPERIF_TDM_WORD_POS_3_4_TS_4_MSB(ip) 0x10
#define MASK_UNIPERIF_TDM_WORD_POS_3_4_TS_4_MSB(ip) 0x7f
#define GET_UNIPERIF_TDM_WORD_POS_3_4_TS_4_MSB(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_WORD_POS_3_4(ip), \
		SHIFT_UNIPERIF_TDM_WORD_POS_3_4_TS_4_MSB(ip), \
		MASK_UNIPERIF_TDM_WORD_POS_3_4_TS_4_MSB(ip))
#define SET_UNIPERIF_TDM_WORD_POS_3_4_TS_4_MSB(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_WORD_POS_3_4(ip), \
		SHIFT_UNIPERIF_TDM_WORD_POS_3_4_TS_4_MSB(ip), \
		MASK_UNIPERIF_TDM_WORD_POS_3_4_TS_4_MSB(ip), value)

/* TS_4_LSB */
#define SHIFT_UNIPERIF_TDM_WORD_POS_3_4_TS_4_LSB(ip) 0x18
#define MASK_UNIPERIF_TDM_WORD_POS_3_4_TS_4_LSB(ip) 0x7f
#define GET_UNIPERIF_TDM_WORD_POS_3_4_TS_4_LSB(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_WORD_POS_3_4(ip), \
		SHIFT_UNIPERIF_TDM_WORD_POS_3_4_TS_4_LSB(ip), \
		MASK_UNIPERIF_TDM_WORD_POS_3_4_TS_4_LSB(ip))
#define SET_UNIPERIF_TDM_WORD_POS_3_4_TS_4_LSB(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_WORD_POS_3_4(ip), \
		SHIFT_UNIPERIF_TDM_WORD_POS_3_4_TS_4_LSB(ip), \
		MASK_UNIPERIF_TDM_WORD_POS_3_4_TS_4_LSB(ip), value)

/*
 * AUD_UNIPERIF_TDM_WORD_POS_5_6
 */

#define OFFSET_UNIPERIF_TDM_WORD_POS_5_6(ip) 0x0144
#define GET_UNIPERIF_TDM_WORD_POS_5_6(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_TDM_WORD_POS_5_6(ip))
#define SET_UNIPERIF_TDM_WORD_POS_5_6(ip, value) \
	writel_relaxed(value, ip->base + \
		OFFSET_UNIPERIF_TDM_WORD_POS_5_6(ip))

/* TS_5_MSB */
#define SHIFT_UNIPERIF_TDM_WORD_POS_5_6_TS_5_MSB(ip) 0x0
#define MASK_UNIPERIF_TDM_WORD_POS_5_6_TS_5_MSB(ip) 0x7f
#define GET_UNIPERIF_TDM_WORD_POS_5_6_TS_5_MSB(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_WORD_POS_5_6(ip), \
		SHIFT_UNIPERIF_TDM_WORD_POS_5_6_TS_5_MSB(ip), \
		MASK_UNIPERIF_TDM_WORD_POS_5_6_TS_5_MSB(ip))
#define SET_UNIPERIF_TDM_WORD_POS_5_6_TS_5_MSB(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_WORD_POS_5_6(ip), \
		SHIFT_UNIPERIF_TDM_WORD_POS_5_6_TS_5_MSB(ip), \
		MASK_UNIPERIF_TDM_WORD_POS_5_6_TS_5_MSB(ip), value)

/* TS_5_LSB */
#define SHIFT_UNIPERIF_TDM_WORD_POS_5_6_TS_5_LSB(ip) 0x8
#define MASK_UNIPERIF_TDM_WORD_POS_5_6_TS_5_LSB(ip) 0x7f
#define GET_UNIPERIF_TDM_WORD_POS_5_6_TS_5_LSB(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_WORD_POS_5_6(ip), \
		SHIFT_UNIPERIF_TDM_WORD_POS_5_6_TS_5_LSB(ip), \
		MASK_UNIPERIF_TDM_WORD_POS_5_6_TS_5_LSB(ip))
#define SET_UNIPERIF_TDM_WORD_POS_5_6_TS_5_LSB(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_WORD_POS_5_6(ip), \
		SHIFT_UNIPERIF_TDM_WORD_POS_5_6_TS_5_LSB(ip), \
		MASK_UNIPERIF_TDM_WORD_POS_5_6_TS_5_LSB(ip), value)

/* TS_6_MSB */
#define SHIFT_UNIPERIF_TDM_WORD_POS_5_6_TS_6_MSB(ip) 0x10
#define MASK_UNIPERIF_TDM_WORD_POS_5_6_TS_6_MSB(ip) 0x7f
#define GET_UNIPERIF_TDM_WORD_POS_5_6_TS_6_MSB(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_WORD_POS_5_6(ip), \
		SHIFT_UNIPERIF_TDM_WORD_POS_5_6_TS_6_MSB(ip), \
		MASK_UNIPERIF_TDM_WORD_POS_5_6_TS_6_MSB(ip))
#define SET_UNIPERIF_TDM_WORD_POS_5_6_TS_6_MSB(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_WORD_POS_5_6(ip), \
		SHIFT_UNIPERIF_TDM_WORD_POS_5_6_TS_6_MSB(ip), \
		MASK_UNIPERIF_TDM_WORD_POS_5_6_TS_6_MSB(ip), value)

/* TS_6_LSB */
#define SHIFT_UNIPERIF_TDM_WORD_POS_5_6_TS_6_LSB(ip) 0x18
#define MASK_UNIPERIF_TDM_WORD_POS_5_6_TS_6_LSB(ip) 0x7f
#define GET_UNIPERIF_TDM_WORD_POS_5_6_TS_6_LSB(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_WORD_POS_5_6(ip), \
		SHIFT_UNIPERIF_TDM_WORD_POS_5_6_TS_6_LSB(ip), \
		MASK_UNIPERIF_TDM_WORD_POS_5_6_TS_6_LSB(ip))
#define SET_UNIPERIF_TDM_WORD_POS_5_6_TS_6_LSB(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_WORD_POS_5_6(ip), \
		SHIFT_UNIPERIF_TDM_WORD_POS_5_6_TS_6_LSB(ip), \
		MASK_UNIPERIF_TDM_WORD_POS_5_6_TS_6_LSB(ip), value)

/*
 * AUD_UNIPERIF_TDM_WORD_POS_7_8
 */

#define OFFSET_UNIPERIF_TDM_WORD_POS_7_8(ip) 0x0148
#define GET_UNIPERIF_TDM_WORD_POS_7_8(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_TDM_WORD_POS_7_8(ip))
#define SET_UNIPERIF_TDM_WORD_POS_7_8(ip, value) \
	writel_relaxed(value, ip->base + \
		OFFSET_UNIPERIF_TDM_WORD_POS_7_8(ip))

/* TS_7_MSB */
#define SHIFT_UNIPERIF_TDM_WORD_POS_7_8_TS_7_MSB(ip) 0x0
#define MASK_UNIPERIF_TDM_WORD_POS_7_8_TS_7_MSB(ip) 0x7f
#define GET_UNIPERIF_TDM_WORD_POS_7_8_TS_7_MSB(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_WORD_POS_7_8(ip), \
		SHIFT_UNIPERIF_TDM_WORD_POS_7_8_TS_7_MSB(ip), \
		MASK_UNIPERIF_TDM_WORD_POS_7_8_TS_7_MSB(ip))
#define SET_UNIPERIF_TDM_WORD_POS_7_8_TS_7_MSB(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_WORD_POS_7_8(ip), \
		SHIFT_UNIPERIF_TDM_WORD_POS_7_8_TS_7_MSB(ip), \
		MASK_UNIPERIF_TDM_WORD_POS_7_8_TS_7_MSB(ip), value)

/* TS_7_LSB */
#define SHIFT_UNIPERIF_TDM_WORD_POS_7_8_TS_7_LSB(ip) 0x8
#define MASK_UNIPERIF_TDM_WORD_POS_7_8_TS_7_LSB(ip) 0x7f
#define GET_UNIPERIF_TDM_WORD_POS_7_8_TS_7_LSB(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_WORD_POS_7_8(ip), \
		SHIFT_UNIPERIF_TDM_WORD_POS_7_8_TS_7_LSB(ip), \
		MASK_UNIPERIF_TDM_WORD_POS_7_8_TS_7_LSB(ip))
#define SET_UNIPERIF_TDM_WORD_POS_7_8_TS_7_LSB(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_WORD_POS_7_8(ip), \
		SHIFT_UNIPERIF_TDM_WORD_POS_7_8_TS_7_LSB(ip), \
		MASK_UNIPERIF_TDM_WORD_POS_7_8_TS_7_LSB(ip), value)

/* TS_8_MSB */
#define SHIFT_UNIPERIF_TDM_WORD_POS_7_8_TS_8_MSB(ip) 0x10
#define MASK_UNIPERIF_TDM_WORD_POS_7_8_TS_8_MSB(ip) 0x7f
#define GET_UNIPERIF_TDM_WORD_POS_7_8_TS_8_MSB(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_WORD_POS_7_8(ip), \
		SHIFT_UNIPERIF_TDM_WORD_POS_7_8_TS_8_MSB(ip), \
		MASK_UNIPERIF_TDM_WORD_POS_7_8_TS_8_MSB(ip))
#define SET_UNIPERIF_TDM_WORD_POS_7_8_TS_8_MSB(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_WORD_POS_7_8(ip), \
		SHIFT_UNIPERIF_TDM_WORD_POS_7_8_TS_8_MSB(ip), \
		MASK_UNIPERIF_TDM_WORD_POS_7_8_TS_8_MSB(ip), value)

/* TS_8_LSB */
#define SHIFT_UNIPERIF_TDM_WORD_POS_7_8_TS_8_LSB(ip) 0x18
#define MASK_UNIPERIF_TDM_WORD_POS_7_8_TS_8_LSB(ip) 0x7f
#define GET_UNIPERIF_TDM_WORD_POS_7_8_TS_8_LSB(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_WORD_POS_7_8(ip), \
		SHIFT_UNIPERIF_TDM_WORD_POS_7_8_TS_8_LSB(ip), \
		MASK_UNIPERIF_TDM_WORD_POS_7_8_TS_8_LSB(ip))
#define SET_UNIPERIF_TDM_WORD_POS_7_8_TS_8_LSB(ip, value) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_TDM_WORD_POS_7_8(ip), \
		SHIFT_UNIPERIF_TDM_WORD_POS_7_8_TS_8_LSB(ip), \
		MASK_UNIPERIF_TDM_WORD_POS_7_8_TS_8_LSB(ip), value)

/*
 * UNIPERIF_LR_WIDTH_CHK
 */

#define OFFSET_UNIPERIF_LR_WIDTH_CHK(ip) 0x0150
#define GET_UNIPERIF_LR_WIDTH_CHK(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_LR_WIDTH_CHK(ip))
#define SET_UNIPERIF_LR_WIDTH_CHK(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_LR_WIDTH_CHK(ip))

/* LR_WIDTH_CHK_EN */
#define SHIFT_UNIPERIF_LR_WIDTH_CHK_LR_WIDTH_CHK_EN(ip) 0
#define MASK_UNIPERIF_LR_WIDTH_CHK_LR_WIDTH_CHK_EN(ip) 0x1
#define GET_UNIPERIF_LR_WIDTH_CHK_LR_WIDTH_CHK_EN(ip) \
	GET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_LR_WIDTH_CHK_LR_WIDTH_CHK_EN(ip), \
		MASK_UNIPERIF_LR_WIDTH_CHK_LR_WIDTH_CHK_EN(ip))
#define SET_UNIPERIF_LR_WIDTH_CHK_LR_WIDTH_CHK_EN_DISABLE(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_LR_WIDTH_CHK_LR_WIDTH_CHK_EN(ip), \
		MASK_UNIPERIF_LR_WIDTH_CHK_LR_WIDTH_CHK_EN(ip), 0)
#define SET_UNIPERIF_LR_WIDTH_CHK_LR_WIDTH_CHK_EN_ENABLE(ip) \
	SET_UNIPERIF_REG(ip, \
		OFFSET_UNIPERIF_CTRL(ip), \
		SHIFT_UNIPERIF_LR_WIDTH_CHK_LR_WIDTH_CHK_EN(ip), \
		MASK_UNIPERIF_LR_WIDTH_CHK_LR_WIDTH_CHK_EN(ip), 1)

/*
 * UNIPERIF_LR_WIDTH_VAL
 */

#define OFFSET_UNIPERIF_LR_WIDTH_VAL(ip) 0x0154
#define GET_UNIPERIF_LR_WIDTH_VAL(ip) \
	readl_relaxed(ip->base + OFFSET_UNIPERIF_LR_WIDTH_VAL(ip))
#define SET_UNIPERIF_LR_WIDTH_VAL(ip, value) \
	writel_relaxed(value, ip->base + OFFSET_UNIPERIF_LR_WIDTH_VAL(ip))

#define UNIPERIF_FIFO_SIZE		70 /* FIFO is 70 cells deep */
#define UNIPERIF_FIFO_FRAMES		4 /* FDMA trigger limit in frames */
#define UNIPERIF_PLAYER_UNDERFLOW_US	1000

#define UNIPERIF_MIN_RATE 8000
#define UNIPERIF_MAX_RATE 48000

#define UNIPERIF_MIN_CHANNELS 1
#define UNIPERIF_MAX_CHANNELS 8

#define UNIPERIF_PERIODS_BYTES_MIN	128
#define UNIPERIF_PERIODS_BYTES_MAX	(64 * PAGE_SIZE)
#define UNIPERIF_PERIODS_MIN		2
#define UNIPERIF_PERIODS_MAX		48
#define UNIPERIF_BUFFER_BYTES_MAX	(2048 * PAGE_SIZE)

/* Link type (format) description */
#define SND_ST_FORMAT_I2S              0x00000001
#define SND_ST_FORMAT_LEFT_JUSTIFIED   0x00000002
#define SND_ST_FORMAT_RIGHT_JUSTIFIED  0x00000003
#define SND_ST_FORMAT_SPDIF            0x00000004
#define SND_ST_FORMAT_MASK             0x0000000f

/* Following values are valid only for I2S, Left Justified and
 * Right justified formats and can be bit-added to format;
 * they define size of one subframe (channel) transmitted.
 * For SPDIF the frame size is fixed and defined by standard. */
#define SND_ST_FORMAT_SUBFRAME_32_BITS 0x00000010
#define SND_ST_FORMAT_SUBFRAME_16_BITS 0x00000020
#define SND_ST_FORMAT_SUBFRAME_MASK    0x000000f0

struct uniperif;

/*
 * Uniperipheral IP revisions
 */
enum uniperif_version {
	SND_ST_UNIPERIF_VERSION_UNKOWN,
	/* SASG1 (Orly), Newman */
	SND_ST_UNIPERIF_VERSION_C6AUD0_UNI_1_0,
	/* SASC1, SASG2 (Orly2) */
	SND_ST_UNIPERIF_VERSION_UNI_PLR_1_0,
	/* SASC1, SASG2 (Orly2), TELSS, Cannes */
	SND_ST_UNIPERIF_VERSION_UNI_RDR_1_0,
	/* TELSS (SASC1) */
	SND_ST_UNIPERIF_VERSION_TDM_PLR_1_0,
	/* Cannes/Monaco */
	SND_ST_UNIPERIF_VERSION_UNI_PLR_TOP_1_0
};

enum uniperif_type {
	SND_ST_UNIPERIF_PLAYER_TYPE_NONE,
	SND_ST_UNIPERIF_PLAYER_TYPE_HDMI,
	SND_ST_UNIPERIF_PLAYER_TYPE_PCM,
	SND_ST_UNIPERIF_PLAYER_TYPE_SPDIF
};

enum uniperif_state {
	UNIPERIF_STATE_STOPPED,
	UNIPERIF_STATE_STARTED,
	UNIPERIF_STATE_STANDBY,
	UNIPERIF_STATE_UNDERFLOW,
	UNIPERIF_STATE_OVERFLOW = UNIPERIF_STATE_UNDERFLOW,
	UNIPERIF_STATE_XRUN
};

struct uniperif_info {
	const char *name;
	int ver;
	enum uniperif_type player_type;
	unsigned int iec958_lr_pol;		/* HDMI/SPDIF LR polarity */
	unsigned int iec958_i2s_mode;		/* HDMI/SPDIF I2S mode */
	unsigned int channels;
	int underflow_enabled;			/* Underflow recovery mode */
	const char *fdma_name;
	struct device_node *dma_np;
	unsigned int fdma_initiator;
	unsigned int fdma_direct_conn;
	unsigned int fdma_request_line;
	const char *clk_name;
	unsigned int oversampling;
};

enum uniperif_iec958_encoding_mode {
	UNIPERIF_IEC958_ENCODING_MODE_PCM,
	UNIPERIF_IEC958_ENCODING_MODE_ENCODED
};

struct uniperif_iec958_settings {
	enum uniperif_iec958_encoding_mode encoding_mode;
	struct snd_aes_iec958 iec958;
};

struct uniperif_ops {
	int (*open)(struct uniperif *player);
	void (*close)(struct uniperif *player);
	int (*prepare)(struct uniperif *player,
				struct snd_pcm_runtime *runtime);
	int (*start)(struct uniperif *player);
	int (*stop)(struct uniperif *player);
};

struct uniperif {
	/* System information */
	struct uniperif_info *info;
	struct device *dev;
	int ver; /* IP version, used by register access macros */

	/* capabilities */
	const struct snd_pcm_hardware *hw;

	/* Resources */
	struct resource *mem_region;
	void *base;
	unsigned long fifo_phys_address;
	int irq;

	/* Clocks */
	struct clk *clk;
	struct snd_pcm_hw_constraint_list channels_constraint;

	/* Runtime data */
	enum uniperif_state state;
	struct snd_info_entry *entry;

	/* Specific to IEC958 player */
	struct uniperif_iec958_settings stream_settings;
	spinlock_t lock;

	/* dma  */
	struct st_dma_audio_config dma_config;

	/*alsa ctrl*/
	struct snd_kcontrol_new *snd_ctrls;
	int num_ctrls;

	unsigned int format;

	/* DAI callbacks */
	const struct uniperif_ops *ops;
};
/* uniperiph player*/
int uniperif_player_init(struct platform_device *pdev,
				struct uniperif **uni_player,
				struct snd_info_entry *snd_info_root);
int uniperif_player_remove(struct platform_device *pdev);

/* uniperiph reader */
int uniperif_reader_init(struct platform_device *pdev,
				struct uniperif **uni_reader,
				struct snd_info_entry *snd_info_root);
int uniperif_reader_remove(struct platform_device *pdev);
#endif
